<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT . '/classes/mjcontroller.php';
require_once JPATH_COMPONENT . '/controllers/default.php';

class MjDevicesController extends MjDefaultController
{
    public function display()
    {
        $this->loadFramework();

        $viewName = $this->joomlaWrapper->getRequestWord('view', '');

        $actualViewName = 'default';

        switch ($viewName) {
            case '':
                $actualViewName = 'desktop';
                break;
            case 'tablet':
                require_once JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/classes/mobilejoomla.php';
                /** @var MobileJoomla $mj */
                $mj = new MobileJoomla($this->joomlaWrapper);
                if ($mj->checkMarkup('tablet') === false) /*check tablet mode doesn't exist*/ {
                    $actualViewName = 'mjpro';
                }
                break;
        }

        echo $this->renderView('global/page', array(
            'sidebar' => $this->renderView('global/sidebar', array(
                'controllerName' => $this->name,
                'viewName' => $viewName
            )),
            'content' => $this->renderView($actualViewName, array(
                'viewName' => $viewName
            ))
        ));
    }
}