<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

class MJToolbar
{
    private $title;
    private $buttons = array();
    private $hideBackButton = false;
    private $hideHomeButton = false;

    public function setTitle($title)
    {
        $this->title = $title;
    }

    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param string $pos
     * @param string $url
     * @param string $icon
     * @param string $title
     * @param array $options
     */
    public function appendButton($pos, $url, $icon = '', $title = '', $options = array())
    {
        if (!isset($this->buttons[$pos])) {
            $this->buttons[$pos] = array();
        }
        $this->buttons[$pos][] = $this->makeButton($url, $icon, $title, $options);
    }

    /**
     * @param string $pos
     * @param string $url
     * @param string $icon
     * @param string $title
     * @param array $options
     */
    public function prependButton($pos, $url, $icon = '', $title = '', $options = array())
    {
        if (!isset($this->buttons[$pos])) {
            $this->buttons[$pos] = array();
        }
        array_unshift($this->buttons[$pos], $this->makeButton($url, $icon, $title, $options));
    }

    private function makeButton($url, $icon, $title, $options)
    {
        $button = new stdClass;
        $button->url = $url;
        $button->icon = $icon;
        $button->title = $title;
        $button->options = $options;
        return $button;
    }

    public function getButtons($pos)
    {
        return isset($this->buttons[$pos]) ? $this->buttons[$pos] : array();
    }

    public function hideBackButton($status = true)
    {
        $this->hideBackButton = $status;
    }

    public function isBackButtonHidden()
    {
        return $this->hideBackButton;
    }

    public function hideHomeButton($status = true)
    {
        $this->hideHomeButton = $status;
    }

    public function isHomeButtonHidden()
    {
        return $this->hideHomeButton;
    }
}
