<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

/* @todo: merge with MobileJoomla class */
class MjHelper
{
    /**
     * @return array
     */
    public static function getDeviceList()
    {
        static $deviceList;
        if ($deviceList === null) {
            JPluginHelper::importPlugin('mobile');

            $dispatcher = JDispatcher::getInstance();
            $result = $dispatcher->trigger('onMjGetDeviceList');

            array_unshift($result, array('desktop' => 'desktop'));
            $deviceList = call_user_func_array('array_merge', $result);
        }

        return $deviceList;
    }

    public static function currentVersion()
    {
        // community / basic / pro
        $version = '2.1.51';

        $version_dat = JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/packages/version.dat';
        if (is_file($version_dat)) {
            $edition = file_get_contents($version_dat);
        } else {
            $edition = 'Community';
        }

        switch ($edition) {
            case 'Community':
            case 'Pro':
                break;
            case 'Basic':
                $version .= '.' . strtolower($edition);
                break;
        }

        return $version;
    }

    public static function cssCheckUpdate()
    {
        $document = JFactory::getDocument();
        $document->addStyleSheet('components/com_mobilejoomla/assets/css/mjbanner.css');

        jimport('joomla.plugins.helper');
        if (JPluginHelper::isEnabled('mobile', 'scientia')) {
            $detector = 'wurfl';
        } elseif (JPluginHelper::isEnabled('mobile', 'amdd')) {
            $detector = 'amdd';
        } else {
            $detector = 'simple';
        }
        $js = '(function(d){'
            . 'var s=d.createElement("link");'
            . 's.href="//www.mobilejoomla.com/checker.php?v=' . urlencode(self::currentVersion())
            . '&j=' . urlencode(JVERSION)
            . '&p=' . ((float)PHP_VERSION)
            . '&d=' . $detector . '";'
            . 's.rel="stylesheet";'
            . 's.type="text/css";'
            . 's.media="only x";'
            . 'd.getElementsByTagName("head")[0].appendChild(s);'
            . 'setTimeout(function(){s.media="all"});'
            . '})(document);';
        $document->addScriptDeclaration($js);
    }

    public static function jsGetNotification()
    {
        // @todo by analogy to joomla's updater
        include_once JPATH_ADMINISTRATOR . '/components/com_mobilejoomla/legacy/joomlawrapper.php';
        $joomlaWrapper = MjJoomlaWrapper::getInstance();
        $joomlaWrapper->loadLanguageFile('com_mobilejoomla', JPATH_ADMINISTRATOR);

        /** @var JDocumentHtml $doc */
        $doc = JFactory::getDocument();
        $doc->addScriptDeclaration('var mj_updater_text="' . addslashes(JText::_('COM_MJ__NEW_VERSION_AVAILABLE')) . '";');
        $doc->addScript('components/com_mobilejoomla/assets/js/mj_ui.js?v=' . self::currentVersion() . '&j=' . JVERSION);
    }

    /**
     * @param string $plugin
     * @return string
     */
    private static function getPluginPath($plugin)
    {
        list($folder, $name) = explode('/', $plugin);
        return
            JPATH_PLUGINS
            . '/' . $folder
            . (version_compare(JVERSION, '1.6', '>=') ? '/' . $name : '')
            . '/' . $name . '.php';
    }

    /**
     * @param MjSettingsModel $mjSettings
     */
    public static function jsGetRecommendation($mjSettings)
    {
        $recommend = array(
            'mj' => self::currentVersion(),
            'j' => JVERSION,
            'domain' => $mjSettings->get('desktop_domain'),
        );

        $stdTemplates = array('', 'mobile_basic', 'mobile_smartphone', 'mobile_iphone', 'mobile_imode', 'mobile_wap');
        $isStdTpl = 1;
        foreach ($mjSettings->getAll() as $key => $value) {
            if (preg_match('#\.template$#', $key) && !in_array($value, $stdTemplates, true)) {
                $isStdTpl = 0;
                break;
            }
        }
        $recommend['stdtpl'] = $isStdTpl;

        $exts = array(
            'jcomments' => 'mobile/mobilejcomments',
            'kunena' => 'mobile/mobilekunena',
            'virtuemart' => 'system/vm_mobile',
        );
        foreach ($exts as $ext => $plugin) {
            if (!file_exists(self::getPluginPath($plugin))) {
                $extPath = JPATH_ADMINISTRATOR . "/components/com_{$ext}/{$ext}.xml";
                if (is_file($extPath)) {
                    $xml = simplexml_load_file($extPath);
                    if (isset($xml->version[0])) {
                        $recommend[$ext] = (int)$xml->version[0];
                    }
                }
            }
        }

        /** @var JDocumentHtml $doc */
        $doc = JFactory::getDocument();
        $doc->addScript('https://www.mobilejoomla.com/recommend.php?' . http_build_query($recommend, '', '&amp;'),
            'text/javascript', true, true);
    }

    public static function jsGetExpiration()
    {

    }
}