<?php
/**
 * Mobile Joomla! extension
 * https://www.mobilejoomla.com
 *
 * @version    2.1.51
 * @license    GNU/GPL v2 - http://www.gnu.org/licenses/gpl-2.0.html
 * @copyright  (C) 2008-2022 Kuneri Ltd. / Denis Ryabov
 * @date       March 2022
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_COMPONENT . '/classes/mjbasecontroller.php';

abstract class MjController extends MjBaseController
{
    public function display()
    {
        $this->loadFramework();

        $viewName = $this->joomlaWrapper->getRequestWord('view', 'default');

        echo $this->renderView('global/page', array(
            'sidebar' => $this->renderView('global/sidebar', array(
                'controllerName' => $this->name,
                'viewName' => $viewName
            )),
            'content' => $this->renderView($viewName)
        ));
    }

    protected function loadFramework()
    {
        $this->joomlaWrapper->loadMootools();

        $bootstrapTemplate = version_compare(JVERSION, '3.0', '>=');
        if (!$bootstrapTemplate) {
            // @todo: use minified files
            $doc = JFactory::getDocument();
            $doc->addStyleSheet('components/com_mobilejoomla/assets/css/j3x_template.css');
            $doc->addScript('components/com_mobilejoomla/assets/js/jquery.min.js');
            $doc->addScript('components/com_mobilejoomla/assets/js/jquery-noconflict.js');
            $doc->addScript('components/com_mobilejoomla/assets/js/bootstrap.min.js');
            $doc->addScript('components/com_mobilejoomla/assets/js/chosen.jquery.min.js');
            $doc->addScript('components/com_mobilejoomla/assets/js/j3x_template.js');
            JHtml::_('behavior.tooltip');
            if (strncmp(JVERSION, '1.5.', 4) === 0) {
                JHtml::script(JUri::root(true) . '/includes/js/overlib_mini.js');
            }
        } else {
            JHtml::_('jquery.framework');
            JHtml::_('bootstrap.tooltip');
        }
    }
}