<?php
/**
 * ------------------------------------------------------------------------
 * JA Multilingual Component for J25 & J32
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2011 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class JalangHelper
{
	public static $extension = 'com_jalang';

	public static function isJoomla3x() {
		return version_compare(JVERSION, '3.0', 'ge');
	}

	/**
	 * Configure the Linkbar.
	 *
	 * @param   string	$vName	The name of the active view.
	 *
	 * @return  void
	 * @since   1.6
	 */
	public static function addSubmenu($vName)
	{
		if(self::isJoomla3x()) {
			JHtmlSidebar::addEntry(
				JText::_('TRANSLATE'),
				'index.php?option=com_jalang&view=tool',
				$vName == 'tool'
			);

			JHtmlSidebar::addEntry(
				JText::_('ASSOCIATION_MANAGER'),
				'index.php?option=com_jalang&view=items',
				$vName == 'items'
			);
		} else {
			JSubMenuHelper::addEntry(
				JText::_('TRANSLATE'),
				'index.php?option=com_jalang&view=tool',
				$vName == 'tool'
			);

			JSubMenuHelper::addEntry(
				JText::_('ASSOCIATION_MANAGER'),
				'index.php?option=com_jalang&view=items',
				$vName == 'items'
			);
		}

	}
	
	public static function getHelperContent() {
		$app = JFactory::getApplication();
		$itemtype = $app->getUserState('com_jalang.itemtype', 'content');
		return JalangHelperContent::getInstance($itemtype);
	}

	public static function getDefaultLanguage()
	{
		static $lang;
		// We need to go to com_languages to get the site default language, it's the best we can guess.
		if (empty($lang))
		{
			$lang = JComponentHelper::getParams('com_languages')->get('site', 'en-GB');
		}
		return $lang;
	}

	public static function getLanguage($lang_code = null) {
		if(!$lang_code) {
			$lang_code = self::getDefaultLanguage();
		}
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select(array($db->quoteName('extension_id'), $db->quoteName('name'), $db->quoteName('type'), $db->quoteName('element')))->from('#__extensions');
		$query->where(array($db->quoteName('type').'='.$db->quote('language'),
			$db->quoteName('client_id').'='.$db->quote('0'),
			$db->quoteName('element').'='.$db->quote($lang_code) ));
		$db->setQuery($query);
		$lang = $db->loadObject();
		return $lang;
	}

	public static function getListInstalledLanguages()
	{
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select('*')->from('#__extensions');
		$query->where(array($db->quoteName('type').'='.$db->quote('language'),
			$db->quoteName('client_id').'='.$db->quote('0')));
		$db->setQuery($query);
		$list = $db->loadObjectList('element');
		return $list;
	}

	public static function getListLanguages($ignoreDefault = 1, $installedNote = 1) {
		static $list = null;
		if(empty($list)) {
			$db   = JFactory::getDbo();
			$query = $db->getQuery(true);

			// Select the required fields from the updates table
			$query->select('name, element, version')->from('#__updates');

			// This Where clause will avoid to list languages already installed.
			//$query->where('extension_id = 0');
			$query->where($db->quoteName('type').'='.$db->quote('package'));

			$query->order($db->escape('extension_id') . ' ' . $db->escape('DESC'));
			$query->order($db->escape('name') . ' ' . $db->escape('ASC'));

			$db->setQuery($query);
			$rows = $db->loadObjectList();
			$list = array();

			$languages = self::getListInstalledLanguages();
			$defaultLanguage = self::getDefaultLanguage();
			if(count($rows)) {
				foreach($rows as $row) {
					if(preg_match('/^pkg_([a-z]{2}-[A-Z]{2})$/', $row->element, $matches) && version_compare($row->version, '3.0', 'ge')) {
						$row->lang_code = $matches[1];
						if($ignoreDefault && $row->lang_code == $defaultLanguage) continue;
						if($installedNote && isset($languages[$row->lang_code])) {
							$row->text = sprintf('%s (%s) - %s', $row->name, $row->lang_code, JText::_('INSTALLED'));
						} else {
							$row->text = sprintf('%s (%s)', $row->name, $row->lang_code);
						}
						$list[$row->lang_code] = $row;
					}
				}
			}

			foreach($languages as $lang_code => $row) {
				if($ignoreDefault && $lang_code == $defaultLanguage) continue;
				if(!isset($list[$lang_code])) {
					$lang = new stdClass();
					$lang->name = $row->name;
					$lang->lang_code = $lang_code;
					$lang->element = 'pkg_'.$lang_code;
					$lang->version = JVERSION;
					if($installedNote) {
						$lang->text = sprintf('%s (%s) - %s', $row->name, $lang_code, JText::_('INSTALLED'));
					} else {
						$lang->text = sprintf('%s (%s)', $row->name, $lang_code);
					}
					array_unshift($list, $lang);
				}
			}
		}
		return $list;
	}

	public static function getListContentLanguages()
	{
		static $items;
		if (empty($items))
		{
			// Get the database object and a new query object.
			$db    = JFactory::getDbo();
			$query = $db->getQuery(true);

			// Build the query.
			$query->select('*')
				->from('#__languages AS a')
				->where('a.published >= 0')
				->order('a.title');

			// Set the query and load the options.
			$db->setQuery($query);
			$items = $db->loadObjectList();
		}

		return $items;
	}
}
