<?php
/**
 * ------------------------------------------------------------------------
 * JA Multilingual Component for J25 & J32
 * ------------------------------------------------------------------------
 * Copyright (C) 2004-2011 J.O.O.M Solutions Co., Ltd. All Rights Reserved.
 * @license - GNU/GPL, http://www.gnu.org/licenses/gpl.html
 * Author: J.O.O.M Solutions Co., Ltd
 * Websites: http://www.joomlart.com - http://www.joomlancers.com
 * ------------------------------------------------------------------------
 */

defined('_JEXEC') or die;

JalangHelperContent::registerAdapter(
	__FILE__,
	'menu',
	10,
	JText::_('Menus'),
	JText::_('Menus')
);

class JalangHelperContentMenu extends JalangHelperContent
{
	public function __construct($config = array())
	{
		$this->table = 'menu';
		$this->edit_context = 'com_menus.edit.item';
		$this->associate_context = 'com_menus.item';
		$this->alias_field = 'alias';
		$this->translate_filters = array('`id`<>1', '`client_id`=0', "`menutype` <> 'default-all'");
		$this->translate_fields = array('title');
		//$this->reference_fields = array('menutype'=>'menu_types');
		$this->reference_tables = array('menu_types');
		$this->nested_field = 'parent_id';
		$this->nested_value = 1;
		parent::__construct($config);
	}

	public function getEditLink($id) {
		if($this->checkout($id)) {
			return 'index.php?option=com_menus&view=item&layout=edit&id='.$id;
		}
		return false;
	}
	
	/**
	 * Returns an array of fields the table can be sorted by
	 */
	public function getSortFields()
	{
		return array(
			'a.title' => JText::_('JGLOBAL_TITLE'),
			'a.menutype' => JText::_('MENU_TYPE'),
			'a.id' => JText::_('JGRID_HEADING_ID')
		);
	}
	
	/**
	 * Returns an array of fields will be displayed in the table list
	 */
	public function getDisplayFields()
	{
		return array(
			'a.id' => JText::_('JGRID_HEADING_ID'),
			'a.title' => JText::_('JGLOBAL_TITLE'),
			'a.menutype' => JText::_('MENU_TYPE'),
		);
	}

	public function beforeSave(&$translator, $sourceid, &$row) {
		$params = json_decode($row['params']);

		//menutype
		$row['menutype'] = $translator->getNewAlias($row['menutype']);

		//path
		if(isset($row['path'])) {
			$row['path'] = $translator->getNewPath($row['path']);
		}

		//update link
		$aLinks = array(
			//com_banners
			array('table' => 'categories', 		'link' => 'index.php?option=com_banners&view=category&id='),
			//com_content
			array('table' => 'content', 		'link' => 'index.php?option=com_content&view=article&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_content&view=category&layout=blog&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_content&view=category&layout=fixel&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_content&view=category&layout=ja_fixel:fixel&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_content&view=category&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_content&view=categories&id='),
			//com_contact
			array('table' => 'contact_details', 'link' => 'index.php?option=com_contact&view=contact&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_contact&view=category&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_contact&view=categories&id='),
			//com_newsfeeds
			array('table' => 'newsfeeds', 		'link' => 'index.php?option=com_newsfeeds&view=newsfeed&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_newsfeeds&view=category&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_newsfeeds&view=categories&id='),
			//com_weblinks
			array('table' => 'weblinks', 		'link' => 'index.php?option=com_weblinks&view=weblink&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_weblinks&view=category&id='),
			array('table' => 'categories', 		'link' => 'index.php?option=com_weblinks&view=categories&id='),

			//com_k2
			array('table' => 'k2_items', 		'link' => 'index.php?option=com_k2&view=item&layout=item&id='),
			array('table' => 'k2_categories', 	'link' => 'index.php?option=com_k2&view=itemlist&layout=category&task=category&id='),

			//com_virtuemart
			array('table' => 'virtuemart_categories', 		'link' => 'index.php?option=com_virtuemart&view=categories&virtuemart_category_id='),
			array('table' => 'virtuemart_categories', 		'link' => 'index.php?option=com_virtuemart&view=category&virtuemart_category_id='),
			array('table' => 'virtuemart_manufacturers',	'link' => 'index.php?option=com_virtuemart&view=manufacturer&layout=details&virtuemart_manufacturer_id='),
			array('table' => 'virtuemart_products',			'link' => 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='),
			array('table' => 'virtuemart_products',			'link' => 'index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id='),
			array('table' => 'virtuemart_vendors',			'link' => 'index.php?option=com_virtuemart&view=vendor&layout=contact&virtuemart_vendor_id='),
			array('table' => 'virtuemart_vendors',			'link' => 'index.php?option=com_virtuemart&view=vendor&layout=details&virtuemart_vendor_id='),
			array('table' => 'virtuemart_vendors',			'link' => 'index.php?option=com_virtuemart&view=vendor&layout=tos&virtuemart_vendor_id=')
		);

		$tableCategory = 'categories';
		foreach($aLinks as $link) {
			if(strpos($row['link'], $link['link']) === 0) {
				$oid = (int) substr($row['link'], strlen($link['link']));
				if(in_array($link['table'] , array('k2_categories', 'virtuemart_categories'))) {
					$tableCategory = $link['table'];
				}

				if($oid) {
					$nid = $translator->getAssociatedItem($link['table'], $oid);
					if($nid) {
						$row['link'] = str_replace($link['link'].$oid, $link['link'].$nid, $row['link']);
					}
				}
				break;
			}
		}

		if(strpos($row['link'], 'option=com_k2') !== false) {
			$tableCategory = 'k2_categories';
		}
		// update category ids
		$cats = array('catid', 'categories', 'catsid', 'categoryIDs', 'display_model-modcats-category', 'category', 'featured_categories', 'userCategoriesFilter', 'categoriesFilter');
		foreach ($cats as $cat) {
			if (isset($params->$cat)) {
				if(is_array($params->$cat) && count($params->$cat)) {
					$catid = array();
					foreach ($params->$cat as $cid) {
						$catid[] = $translator->getAssociatedItem($tableCategory, $cid, $cid);
					}
					$params->$cat = $catid;
				} else {
					if (is_numeric($params->$cat)) {
						$cid = $params->$cat;
						$params->$cat = $translator->getAssociatedItem($tableCategory, $cid, $cid);
					}
				}
			}
		}

		/**
		 * Update Item Alias:
		 * should double check in afterTranslate event because in some case, older item was configured to point to newer menu item
		 * so, it might not return correct associated item here
		 */
		if($row['type'] == 'alias') {
			if($params->aliasoptions) {
				$params->aliasoptions = $translator->getAssociatedItem($this->table, $params->aliasoptions, $params->aliasoptions);
			}
		}

		$row['params'] = json_encode($params);
	}

	public function afterTranslate(&$translator) {

		require_once( JPATH_ADMINISTRATOR . '/components/com_menus/tables/menu.php' );

		$db = JFactory::getDbo();
		//Update Item Alias
		$query = $db->getQuery(true);
		$query->select($db->quoteName('id').','.$db->quoteName('params'))
				->from('#__'.$this->table)
				->where(array('`client_id`=0', $db->quoteName('type').'='.$db->quote('alias'), $db->quoteName('language').'='.$db->quote($translator->toLangTag)));
		$db->setQuery($query);
		$rows = $db->loadAssocList();

		if (count($rows)) {
			foreach ($rows as $row) {
				$params = json_decode($row['params']);
				$aid = $params->aliasoptions;
				$params->aliasoptions = $translator->getAssociatedItem($this->table, $params->aliasoptions, $params->aliasoptions);

				if ($params->aliasoptions != $aid) {
					$query = "UPDATE #__menu SET `params`=".$db->quote(json_encode($params))." WHERE `id`=".$db->quote($row['id']);
					$db->setQuery($query);
					$db->execute();
				}
			}
		}

		// create default-all menutype with default menu item for all languages
		$query = "INSERT IGNORE INTO #__menu_types(`menutype`, `title`, `description`) VALUES('default-all', 'Default', 'Default for all languages')";
		$db->setQuery($query);
		$db->execute();

		// insert default menu item
		$query = "INSERT IGNORE INTO `#__menu` ".
			"(`menutype`, `title`, `alias`, `path`, `link`, `type`, `published`, `parent_id`, `level`, `component_id`, `browserNav`, `access`, `template_style_id`, `home`, `language`, `client_id`)".
			" VALUES('default-all', 'Default', 'default', 'default', 'index.php?option=com_content&view=featured', 'component', 1, 1, 1, 22, 0, 1, 0, 1, '*', 0)";
		$db->setQuery($query);
		$db->execute();

		//REBUILD MENU TREE
		$config = array();
		$tableMenu = JTable::getInstance('Menu', 'MenusTable', $config);
		$tableMenu->rebuild();
	}
}