<?php
/**
 * @package		Joomla.Site
 * @subpackage	mod_login
 * @copyright	Copyright (C) 2005 - 2013 Open Source Matters, Inc. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 */

// no direct access
defined('_JEXEC') or die;
JHtml::_('behavior.keepalive');
?>
<div class="sp-mod-login pull-right">
<span class="sp-signin">
     <a class="login_link" href="#login" role="button" data-toggle="modal"><?php echo ($user->id>0) ? JText::_('MY_ACCOUNT') : JText::_('JLOGIN'); ?>  /</a>
</span>
<span class="sp-register">
	<a href="<?php echo JRoute::_( 'index.php?option=com_users&view=registration' ); ?>"><span><?php echo JText::_('JREGISTER'); ?></a>
</span>

<!--Modal-->
<div id="login" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	  <div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icon-remove"></i></button>
		<h3><?php echo ($user->id>0) ? JText::_('MY_ACCOUNT') : JText::_('JLOGIN'); ?></h3>
	  </div>
	  <div class="modal-body">

		<?php if ($type == 'logout') : ?>
		<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post" id="login-form">
		<?php if ($params->get('greeting')) : ?>
			<div class="login-greeting">
			<?php if($params->get('name') == 0) : {
				echo JText::sprintf('MOD_LOGIN_HINAME', htmlspecialchars($user->get('name')));
			} else : {
				echo JText::sprintf('MOD_LOGIN_HINAME', htmlspecialchars($user->get('username')));
			} endif; ?>
			</div>
		<?php endif; ?>
			<div class="logout-button">
				<input type="submit" name="Submit" class="button" value="<?php echo JText::_('JLOGOUT'); ?>" />
				<input type="hidden" name="option" value="com_users" />
				<input type="hidden" name="task" value="user.logout" />
				<input type="hidden" name="return" value="<?php echo $return; ?>" />
				<?php echo JHtml::_('form.token'); ?>
			</div>
		</form>
		<?php else : ?>

		<form action="<?php echo JRoute::_('index.php', true, $params->get('usesecure')); ?>" method="post" id="login-form" >
			<?php if ($params->get('pretext')): ?>
				<div class="pretext">
				<p><?php echo $params->get('pretext'); ?></p>
				</div>
			<?php endif; ?>
			<fieldset class="userdata">
			<div class="row-fluid">
				<div class="span6">
					<input id="modlgn-username" placeholder="<?php echo JText::_('MOD_LOGIN_VALUE_USERNAME') ?>" type="text" name="username" class="input-block-level"  />
				</div>
				<div class="span6">
					<input id="modlgn-passwd" type="password" placeholder="<?php echo JText::_('JGLOBAL_PASSWORD') ?>" name="password" class="input-block-level" />
				</div>
			</div>
			<p></p>
			<p>
				<?php echo JText::_('FORGOT'); ?> <a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
				<?php echo JText::_('USERNAME'); ?></a> <?php echo jText::_('OR'); ?> <a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
				<?php echo JText::_('PASSWORD'); ?></a>
			</p>
			<div class="clearfix">
				<?php if (JPluginHelper::isEnabled('system', 'remember')) : ?>
					<div class="pull-left modlgn-remember">
						<input id="modlgn-remember" type="checkbox" name="remember" class="inputbox" value="yes"/>
						<label for="modlgn-remember"><?php echo JText::_('MOD_LOGIN_REMEMBER_ME') ?></label>
						
					</div>
				<?php endif; ?>
				<input type="submit" name="Submit" class="button pull-right" value="<?php echo JText::_('JLOGIN') ?>" />
			</div>
			
			<input type="hidden" name="option" value="com_users" />
			<input type="hidden" name="task" value="user.login" />
			<input type="hidden" name="return" value="<?php echo $return; ?>" />
			<?php echo JHtml::_('form.token'); ?>
			</fieldset>
			<?php if ($params->get('posttext')): ?>
				<div class="posttext">
				<p><?php echo $params->get('posttext'); ?></p>
				</div>
			<?php endif; ?>
		</form>

		<?php endif; ?>

	</div>
	<!--/Modal body-->
	
	<div class="modal-footer">
		<?php
		$usersConfig = JComponentHelper::getParams('com_users');
		if ($usersConfig->get('allowUserRegistration')) : ?>
			<i class="icon-lock"></i> <a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>">
				<?php echo JText::_('MOD_LOGIN_REGISTER'); ?></a>
		<?php endif; ?>
	</div>
	<!--/Modal footer-->
</div>
<!--/Modal-->

</div>

