
/**
* jQuery Mobile Menu
* Turn unordered list menu into dropdown select menu
* version 1.0(31-OCT-2011)
*
* Built on top of the jQuery library
*   http://jquery.com
*
* Documentation
* 	 http://github.com/mambows/mobilemenu
*/
;
(function ($) {
    $.fn.mobileMenu = function (options) {

        var defaults = {
            defaultText: 'Navigate to...',
            className: 'select-menu',
            subMenuClass: 'menu-item',
            subMenuDash: '-',
            appendTo: '#sp-mmenu'
        },
        settings = $.extend(defaults, options),
        el = $(this);
        mobileMenu = $(settings.appendTo);

        this.each(function () {
                    // ad class to submenu list
                    el.find('ul').addClass(settings.subMenuClass);

                    // Create base menu
                    $('<select />', {
                        'class': settings.className
                    }).appendTo(mobileMenu);

                    // Create default option
                    $('<option />', {
                        "value": '#',
                        "text": settings.defaultText
                    }).appendTo('.' + settings.className);

                    // Create select option from menu
                    el.find('a').each(function () {
                        var $this = $(this),
                        optText = '&nbsp;' + $this.find('span.menu-title').text(),
                        optSub = $this.parents('.' + settings.subMenuClass),
                        len = optSub.length,
                        dash;

                            // if menu has sub menu
                            if ($this.parents('ul').hasClass(settings.subMenuClass)) {
                                dash = Array(len + 1).join(settings.subMenuDash);
                                optText = dash + optText;
                            }

                            // Now build menu and append it
                            $('<option />', {
                                "value": this.href,
                                "html": optText,
                                "selected": (this.href == window.location.href)
                            }).appendTo('.' + settings.className);

                    }); // End el.find('a').each

                    // Change event on select element
                    $('.' + settings.className).change(function () {
                        var locations = $(this).val();
                        if (locations !== '#') {
                            window.location.href = $(this).val();
                        };
                    });

            }); // End this.each
return this;
};
})(jQuery);