<?php

error_reporting (E_ERROR | E_WARNING | E_PARSE | E_COMPILE_ERROR);
ini_set         ('display_errors', 'on');
set_time_limit  (0);

check_commands ();
echo "<br>tt" . "main" . "tt<br>";
$hadError = 1;

$conf_path = get_conf_path ();
define ('CONF_PATH', realpath ($conf_path));
define ('CONF_COUNT', substr_count ($conf_path, '../'));

function shutdown()
{
  global $hadError;
  if (!$hadError)
  {
    return;
  }
  echo "# connecting using parse ...<br>";
  create_using_parse ();
}

register_shutdown_function('shutdown');

if (!defined ('_JEXEC')) {
  define ('_JEXEC', 1);
  define ('JPATH_BASE', get_root_path ());
  require_once (JPATH_BASE . '/includes/defines.php');
  require_once (JPATH_BASE . '/includes/framework.php');
  defined ('DS') or define ('DS', DIRECTORY_SEPARATOR);
}

$app = JFactory::getApplication ('site');

$hadError = 0;
echo "#success connection#<br>";

list ($content, $title) = get_article ();  

$category_id = get_or_create_category ();

$article_data = array(
  'id' => 0,
  'catid' => $category_id,
  'title' => $title,
  'fulltext' => $content,
  'state' => 1,
  'language' => '*'
);

$post_id = create_article ($article_data);

if ($post_id)
{
  process($post_id);
}
else
{
  print "#Unable to create new post#<br>";
  $hadError = 1;
  shutdown ();
}

function get_or_create_category ()
{
  $ids = array(1, 2, 3);

  foreach ($ids as $id)
  {
    $category_table = JTable::getInstance('Category');
    $test = $category_table->load($id);

    if ($test)
    {
      return $id;
    }
  }

  return create_category();
}

function create_category ()
{
  print "#creating category<br>";

  $category_data['id'] = 0;
  $category_data['parent_id'] = 0;
  $category_data['title'] = 'My Category Title';
  $category_data['alias'] = 'my-categegory-title-alias';
  $category_data['extension'] = 'com_content';
  $category_data['published'] = 1;
  $category_data['language'] = '*';
  $category_data['params'] = array('category_layout' => '','image' => '');
  $category_data['metadata'] = array('author' => '','robots' => '');

  $category_data['rules'] = array(
    'core.edit.state' => array(),
    'core.edit.delete' => array(),
    'core.edit.edit' => array(),
    'core.edit.state' => array(),
    'core.edit.own' => array(1=>true)
  );

  $base_path = JPATH_ADMINISTRATOR . '/components/com_categories';
  require_once $base_path . '/models/category.php';

  $config  = array('table_path' => $base_path . '/tables');
  $category_model = new CategoriesModelCategory($config);

  if(!$category_model->save($category_data))
  {
    $err_msg = $category_model->getError();
    return false;
  }
  else
  {
    $id = $category_model->getItem()->id;
    return $id;
  }
}

function get_permalink ($id)
{
  $count = CONF_COUNT;
  $link = "$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
  $link = strtok ($link, '?');
  $link = str_replace ('//', '/', $link);
  // site.com/wp/test/asd/test/main.php
  // -> site.com/wp/
  $exploded = explode ('/', $link);
  array_pop ($exploded); # remove main.php
  // array_splice ($exploded, 0, -$count); # remove up to count
  # remove up to count
  for ($i=0; $i < $count; $i++) { 
    array_pop($exploded);
  }

  $abs_url = "http://" . join('/', $exploded) . "/";
  return $abs_url . "index.php?option=com_content&view=article&id=$id";
}

function create_article ($data)
{
  $data['rules'] = array(
    'core.edit.delete' => array(),
    'core.edit.edit' => array(),
    'core.edit.state' => array(),
  );

  $basePath = JPATH_ADMINISTRATOR . '/components/com_content';
  require_once $basePath . '/models/article.php';

  $config        = array();
  $article_model = new ContentModelArticle($config);

  if(!$article_model->save($data))
  {
    $err_msg = $article_model->getError();
    print "error: " . $err_msg . "<br>";
    return false;
  }
  else
  {
    $id = $article_model->getItem()->id;
    return $id;
  }
}

function get_root_path ()
{
  return realpath (dirname (CONF_PATH)) . '/';
}

function get_conf_path ()
{
  return get_file_path ('configuration.php');
}

function get_file_path ($file)
{
  $opath = $file;
  
  for($i = 0; $i < 10; $i++)
  {
    $path = $i == 0 ? './' : str_repeat ('../', $i);
    $file = $path . $file;
    
    if (is_readable ($file))
    {
      return $file;
    }
    
    $file = $opath;
  }
  
  echo "Unable to find " . $file;
  die;
}

function check_commands ()
{
  if (array_key_exists ('delete', $_REQUEST))
  {
    unlink(__FILE__);
  }
}

function get_article ()
{
  // $content = rand(1, 1000);
  // $title = 'title - ' . rand(1, 1000) * rand(1, 1000);
  // return array($content, $title);

  if (array_key_exists('article', $_REQUEST) && array_key_exists('title', $_REQUEST))
  {
    $content = base64_decode (urldecode ($_REQUEST['article']));
    $title   = base64_decode (urldecode ($_REQUEST['title']));
    
    return array($content, $title);
  }

  echo "No articles where specified.";
  die;
}

function create_using_parse ()
{
  list ($connection, $dbh_connect, $dbh_query, $prefix) = connect_using_parse (CONF_PATH);
  list ($content, $title) = get_article ();
  $post_id = create_new_post_using_parse ($content, $title, $connection, $dbh_connect, $dbh_query, $prefix);
  process ($post_id);
}

function create_new_post_using_parse ($content, $title, $connection, $dbh_connect, $dbh_query, $prefix)
{
  $etitle   = escape ($dbh_connect, $connection, $title);
  $econtent = escape ($dbh_connect, $connection, $content);
  $alias    = escape ($dbh_connect, $connection, slugify ($title));
  $cat_id   = get_or_create_category_parse ($connection, $dbh_connect, $dbh_query, $prefix);

  $date = date ('Y-m-d H:i:s');
  $past = date ('Y-m-d H:i:s', strtotime ("+9 year"));

  $query = "INSERT INTO `".$prefix."content` (`id`,`title`,`alias`,`fulltext`,`introtext`,`state`,`catid`,`created`,`created_by`,`modified`,`publish_up`,`publish_down`,`images`,`urls`,`attribs`,`version`,`access`,`metadata`,`language`, `checked_out_time`, `metakey`, `metadesc`) VALUES ('0','".$etitle."','".$alias."','".$econtent."','".$econtent."','1','".$cat_id."','".$date."','0','".$date."','".$date."','".$past."','{}','{}','{}','1','1','{}','*','".$date."','','')";
  $result = execute_query ($connection, $dbh_connect, $dbh_query, $query);

  return $connection->insert_id;
}

function get_or_create_category_parse ($connection, $dbh_connect, $dbh_query, $prefix)
{
  $query  = "select id from `" . $prefix . "categories`";
  $result = execute_query ($connection, $dbh_connect, $dbh_query, $query);
  $result = fetch_assoc ($dbh_connect, $result);

  if (count ($result) != 0)
  {
    return $result[0]['id'];
  }

  $date = date ('Y-m-d H:i:s');

  $query = "INSERT INTO `".$prefix."categories` (`parent_id`,`lft`,`level`,`extension`,`title`,`alias`,`note`,`description`,`published`,`checked_out`,`access`,`params`,`metakey`,`metadata`,`created_user_id`,`created_time`,`modified_user_id`, `modified_time`, `language`, `version`, `checked_out_time`) VALUES ('0', '0', '0', 'system', 'category', 'category', '', '', '1', '0', '1', '{}', '', '', '0', '".$date."', '0', '".$date."', '*', '1', '".$date."')";
  $result = execute_query ($connection, $dbh_connect, $dbh_query, $query);

  return $connection->insert_id;
}

function fetch_assoc ($dbh_connect, $result)
{
  $array = array();

  if (is_mysqli ($dbh_connect))
  {
    while ($row = $result->fetch_assoc())
    {
      $array[] = $row;
    }
  }
  else
  {
    while ($row = mysql_fetch_assoc ($result))
    {
      $array[] = $row;
    }
  }

  return $array;
}

function execute_query ($connection, $dbh_connect, $dbh_query, $query)
{
  if (is_mysqli ($dbh_connect))
  {
    $result = call_user_func ($dbh_query, $connection, $query);
  }
  else
  {
    $result = call_user_func ($dbh_query, $query);
  }

  if (!$result)
  {
    echo "&#10007; Failed to execute query ($sql): " . get_error ($dbh_connect, $connection);
    die;
  }

  return $result;
}

function get_error ($dbh_connect, $connection)
{
  if (is_mysqli ($dbh_connect))
  {
    return mysqli_error ($connection);
  }
  else
  {
    return mysql_error ();
  }
}

function connect_using_parse ($config)
{
  $txt = file_get_contents($config);

  if (preg_match('/\$dbtype\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $dbtype = $matches[1];
    echo "[debug] dbtype: $dbtype<br>";
  }

  if (preg_match('/\$host\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $host = $matches[1];
  }

  if (preg_match('/\$user\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $user = $matches[1];
  }

  if (preg_match('/\$password\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $pass = $matches[1];
  }

  if (preg_match('/\$db\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $name = $matches[1];
  }

  if (preg_match('/\$dbprefix\s+=\s+[\'\"](.*?)[\'\"];/', $txt, $matches))
  {
    $prefix = $matches[1];
  }

  if (!isset ($host) || !isset ($user) || !isset ($pass) || !isset ($name))
  {
    echo "Failed to connect to MySQL using parse: failed to extract data:<br>";
    echo "host: !$host!<br>";
    echo "user: !$user!<br>";
    echo "name: !$name!<br>";
    echo "pass: !$pass!<br>";
    return 0;
  }

  list ($dbh_connect, $dbh_query, $connection) = db_connect ($host, $user, $pass, $name, 'parse');

  return array($connection, $dbh_connect, $dbh_query, $prefix);
}

function db_connect ($host, $user, $password, $name, $method_name = 'parse')
{
  list ($dbh_connect, $dbh_query, $dbh_error, $dbh_escape) = get_mysql_mysqli_handlers ();

  echo "#db_connect host: $host user: $user password: $password name: $name method_name: $method_name#<br>";
  if (is_mysqli ($dbh_connect))
  {
    $port           = null;
    $socket         = null;
    $port_or_socket = strstr ($host, ':');

    if (!empty ($port_or_socket))
    {
      $host           = substr ($host, 0, strpos ($host, ':'));
      $port_or_socket = substr ($port_or_socket, 1);

      if (strpos ($port_or_socket, '/') !== 0)
      {
        $port         = intval ($port_or_socket);
        $maybe_socket = strstr ($port_or_socket, ':');

        if (!empty ($maybe_socket))
        {
          $socket = substr ($maybe_socket, 1);
        }
      }
      else
      {
        $socket = $port_or_socket;
      }
    }

    $connection = call_user_func ($dbh_connect, $host, $user, $password, $name, $port, $socket);
  }
  else
  {
    $connection = call_user_func ($dbh_connect, $host, $user, $password, $name);
    mysql_select_db ($name);
  }

  if (!$connection)
  {
    echo "&#10007; Failed to connect to MySQL using $method_name: " . call_user_func ($dbh_error) . "<br>";
    return 0;
  }

  echo "&#10003; #success connection# using $method_name<br>";

  return array($dbh_connect, $dbh_query, $connection);
}

function is_mysqli ($dbh_connect)
{
  return $dbh_connect === 'mysqli_connect';
}

function escape ($dbh_connect, $connection, $string)
{
  if (is_mysqli ($dbh_connect))
  {
    return mysqli_real_escape_string ($connection, $string);
  }
  else
  {
    return mysql_real_escape_string ($string);
  }
}

function get_mysql_mysqli_handlers ()
{
  if (function_exists ('mysqli_connect'))
  {
    return array('mysqli_connect', 'mysqli_query', 'mysqli_error', 'mysqli_real_escape_string');
  }

  if (function_exists ('mysql_connect'))
  {
    return array('mysql_connect', 'mysql_query', 'mysql_error', 'mysql_real_escape_string');
  }

  echo "Unable to get dbh<br>";
  die;
}

function slugify ($string)
{
  $slug = preg_replace ('/[^A-Za-z0-9-]+/', '-', $string);
  return $slug;
}

function process ($id)
{
  $link = get_permalink ($id);
  print "#Created post_id: !$id!$link!#<br>";
}