<?php

require_once 'Connection.php';

/**
 * Kelions lap valdymo klas
 *
 * Operacij su kelions lapais valdymo klas
 *
 * @author     Mindaugas rimkus <mindaugas.rimkus@disigma.lt>
 */

class PassageSheet {
	
	
	
	/**
	 * Grainami kelions lapai pagal paiekos slyg
	 *
	 * @param Date $passageFrom Nuo kada rodomi kelions lapai
	 * @param Date $passageTo Iki kada rodomi kelions lapai 
	 * @param int $searchParam Paiekos parametras 0 - Kelions lapo numeris; 1 - Vairuotojas; 2 - Automobilio mark; 3 - Automobilio modelis; 4 - Valstybinis numeris; 5 - Automobilio tipas L / K
	 * @param string $search Paiekos laukas
	 * @return Grainami kelions lapai pagal paiekos slygas
	 */
	
	public function getPassageSheets($passageFrom,$passageTo,$searchParam,$search) {
		$sql = "";
		if (strlen($passageFrom) > 0) {
			$sql = " and passage_sheet.passage_from>='".$passageFrom."'";
		}
		if (strlen($passageTo) > 0) {
			$sql .= " and passage_sheet.passage_from<='".$passageTo."'";
		}
		if ($searchParam == 0 && strlen($search) > 0) {
			$search = $search + 0;
			$sql .= " and passage_sheet.id=".$search;
		}
		if ($searchParam == 1 && strlen($search) > 0) {
			$sql .= " and lower(personnel.name||' '||personnel.surname) like lower('%".$search."%')";
		}
		
		if ($searchParam == 2 && strlen($search) > 0) {
			$sql .= " and lower(make.name) like lower('%".$search."%')";
		}
		if ($searchParam == 3 && strlen($search) > 0) {
			$sql .= " and lower(model.name) like lower('%".$search."%')";
		}
		if ($searchParam == 4 && strlen($search) > 0) {
			$sql .= " and lower(vehicle.registration_number) like lower('%".$search."%')";
		}
		if ($searchParam == 5 && ($search=='L' or $search=='l')) {
			$sql .= " and model.vehicle_type=1";
		}
		if ($searchParam == 5 && ($search=='K' or $search=='k')) {
			$sql .= " and model.vehicle_type=2";
		}
		if ($searchParam == 5 && ($search=='P' or $search=='p')) {
			$sql .= " and model.vehicle_type=3";
		}
		
		//echo $sql;
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select make.name as make_name,model.name as model_name, make.name||\' \'||model.name as make_model, vehicle.registration_number,personnel.name as personnel_name,personnel.surname as personnel_surname,personnel.name || \' \' || personnel.surname as name_surname, passage_sheet.id as passage_sheet_id,passage_sheet.id as passage_sheet_id1,passage_sheet.passage_from,passage_sheet.passage_to,passage_sheet.task,passage_sheet.document_date as passage_sheet_document_date,passage_sheet.record_time as passage_sheet_record_time,CASE WHEN model.vehicle_type=1 THEN \'Lengvasis\' WHEN model.vehicle_type=2 THEN \'Krovininis\' END as vehicle_type,personnel.id as personnel_id,vehicle_driver.id as vehicle_driver_id,vehicle.id as vehicle_id, passage_sheet.trailer_id as trailer_id			from make,model,vehicle,personnel,vehicle_driver,passage_sheet		where make.id=model.make_id and vehicle.model_id=model.id and personnel.id=vehicle_driver.personnel_id and vehicle_driver.vehicle_id=vehicle.id and passage_sheet.vehicle_driver_id=vehicle_driver.id '.$sql.' order by passage_sheet.id desc limit 1000');
			$stmt->execute();
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;

	}
	
	
	/**
	 * Grainami vairuotojai vairuojantys lengvuosius automobilius
	 * 
	 * @param int $type Automobilio tipas; 1 - Lengvasis; 2 - Sunkveimis; 3 - Priekaba
	 * @param int $mustIncludePersonID Privaloma traukti  asmen, nesvarbu ar itrintas, privaloma redagavimui.
	 *
	 * @return Grainami vairuotojai vairuojantys lengvuosius automobilius
	 */
	
	public function getAllCarDrivers($type,$mustIncludePersonID) {

	

		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select max(personnel.id) as id,personnel.name,personnel.surname,personnel.name ||\' \'|| personnel.surname as name_surname from personnel,vehicle_driver,vehicle,model where personnel.id=vehicle_driver.personnel_id and vehicle_driver.vehicle_id=vehicle.id and vehicle.model_id=model.id and  model.vehicle_type=? and ((vehicle_driver.is_deleted=false and  personnel.is_deleted=false and vehicle_driver.is_deleted=false and vehicle.is_deleted=false) or personnel.id=?)  group by personnel.name, personnel.surname order by name,surname');
			$stmt->execute(array($type,$mustIncludePersonID)); 
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	
	}
	
	/**
	 * Grainami vairuotojui priskirtos transporto priemons
	 *
	 * @param int $type Automobilio tipas; 1 - Lengvasis; 2 - Sunkveimis; 3 - Priekaba
	 * @param int $personnelID Darbuotojo identifikacinis numeris
	 * @param int $mustIncludeVehicleID Privaloma terpti i transporto net jei itrinta, privaloma redagavimui.
	 *
	 * @return Grainami vairuotojui priskirtos transporto priemons
	 */
	
	public function getAllDriverCars($type,$personnelID,$mustIncludeVehicleID) {
	
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select vehicle_driver.id,make.name,model.name,vehicle.registration_number,make.name ||\' \'||model.name ||\' (\'||vehicle.registration_number||\')\' as car, vehicle.id as vehicle_id from personnel,vehicle_driver,vehicle,model,make where make.id=model.make_id and personnel.id=vehicle_driver.personnel_id and vehicle_driver.vehicle_id=vehicle.id and vehicle.model_id=model.id  and personnel.id=?  and model.vehicle_type=? and ((vehicle_driver.is_deleted=false and personnel.is_deleted=false and vehicle_driver.is_deleted=false) or vehicle.id=?)');
					
			$stmt->execute(array($personnelID,$type,$mustIncludeVehicleID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	
	}
	
	
	/**
	 * Grainamos priekabos priskirtos transporto priemonei
	 *
	 * @param int $type Automobilio tipas; 1 - Lengvasis; 2 - Sunkveimis; 3 - Priekaba
	 * @param int $vehicleID Transporto priemons identifikacinis numeris
	 * @param int $mustIncludeTrailerID Priekabos identifikacinis numeris privaloma traukti net itrint, dl redagavimo
	 *
	 * @return Grainamos priekabos priskirtos transporto priemonei
	 */
	  
	public function getCarTrailers($type,$vehicleID,$mustIncludeTrailerID)  {
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select vehicle_trailer.id,make.name,model.name,vehicle.registration_number,make.name ||\' \'||model.name ||\' (\'||vehicle.registration_number||\')\' as trailer from model,make,vehicle,vehicle_trailer where make.id=model.make_id   and vehicle.model_id=model.id and vehicle.id=vehicle_trailer.trailer_id and ((vehicle_trailer.is_deleted=false and vehicle.is_deleted=false) or vehicle_trailer.id=?)   and vehicle_trailer.vehicle_id=? and model.vehicle_type=?');
				
			$stmt->execute(array($mustIncludeTrailerID,$vehicleID,$type));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
				//file_put_contents($file, print_r($row));
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
			
		}
		
		
		return $rows;
	
	}
	
	/**
	 * Kelions lapo raymas  duomen baz
	 *
	 * @param Date $documentDate Dokumento data
	 * @param Date $dateFrom Kelions pradia
	 * @param Date $dateTo Kelions pabaiga
	 * @param int $vehicleDriverId vairuotojo identifikacinis numeris
	 * @param int $programUserId programos vartotojo identifikacinis numeris
	 * @param int $trailerId prikabos identifikacinis numeris
	 * @param string $task Uduoties apraymas
	 *
	 * @return Grainamas terpto kelions lapo identifikacinis numeris 
	 */
	//vehicle_driver_id,program_user_id,trailer_id,passage_sheet_no,passage_from,passage_to,task,document_date
	public function insertPassageSheet($documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task) {
	
		//$file = '/home/webapps/disigma.lt/flex/kelregas/classes/log';
		// Open the file to get existing content
		//$current = file_get_contents($file);
		// Append a new person to the file
		//$current .= "$documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task";
		// Write the contents back to the file
		//file_put_contents($file, $current);   
		$documentDate .= " ".date('H:i:s');
		
		
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('insert into  passage_sheet (document_date,passage_from,passage_to,vehicle_driver_id,program_user_id,trailer_id,task)  values (?,?,?,?,?,?,?) returning id');
	
			$stmt->execute(array($documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task));
			$rows = array();
			$row = $stmt->fetch();
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
			//$documentDate .= " \n".$e->getMessage();
		}
		return $row['id'];
	
	}
	
	
	/**
	 * Kelions lapo paalinimas i duomen bazs
	 *
	 * @param int $passageSheetId Kelions lapo identifikacinis numeris
	 */
	//vehicle_driver_id,program_user_id,trailer_id,passage_sheet_no,passage_from,passage_to,task,document_date
	public function deletePassageSheet($passageSheetId) {
	
	
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('delete  from passage_sheet where id=?');
	
			$stmt->execute(array($passageSheetId));
		
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
	}
	
	/**
	 * Kelions lapo rao atnaujinimas
	 *
	 * @param int $passageSheetID atnaujinamo kelions lap rao identifikacinis numeris
	 * @param Date $documentDate Dokumento data
	 * @param Date $dateFrom Kelions pradia
	 * @param Date $dateTo Kelions pabaiga
	 * @param int $vehicleDriverId vairuotojo identifikacinis numeris
	 * @param int $programUserId programos vartotojo identifikacinis numeris
	 * @param int $trailerId prikabos identifikacinis numeris
	 * @param string $task Uduoties apraymas
	 *
	 * @return Grainamas terpto kelions lapo identifikacinis numeris
	 */
	//vehicle_driver_id,program_user_id,trailer_id,passage_sheet_no,passage_from,passage_to,task,document_date
	public function updatePassageSheet($passageSheetID,$documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task) {
	
		//$file = '/home/webapps/disigma.lt/flex/kelregas/classes/log';
		// Open the file to get existing content
		//$current = file_get_contents($file);
		// Append a new person to the file
		//$current .= "$documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task";
		// Write the contents back to the file
		//file_put_contents($file, $current);
		$documentDate .= " ".date('H:i:s');
	
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('update  passage_sheet set document_date=?,passage_from=?,passage_to=?,vehicle_driver_id=?,program_user_id=?,trailer_id=?,task=? where id=?');
	
			$stmt->execute(array($documentDate,$dateFrom,$dateTo,$vehicleDriverId,$programUserId,$trailerId,$task,$passageSheetID));
			
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
			//$documentDate .= " \n".$e->getMessage();
		}
	}
	
	
	/**
	 * Grainamas iduotas kuras (konkreiam kelions lapui)
	 *
	 * @param int $passageSheetID kelions lapo identifikacinis numeris
	 * @return Grainamas iduotas kuras (konkreiam kelions lapui)
	 */
	
	public function getDispensedFuel($passageSheetID) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select dispensed_fuel.id,dispensed_fuel.quantity,fuel_type.name,dispensed_fuel.fuel_type_id from dispensed_fuel,fuel_type where dispensed_fuel.fuel_type_id=fuel_type.id and dispensed_fuel.passage_sheet_id=?');
			$stmt->execute(array($passageSheetID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	}
	
	
	/**
	 * Grainamas kuro tip sraas priskirtas konkreio vairuotojo konkreiam automobiliui
	 *
	 * @param int $vehicleDriverID vairuotojo identifikacinis numeris
	 * @return Grainamas kuro tip sraas priskirtas konkreio vairuotojo konkreiam automobiliui
	 */
	
	public function getFuelTypesByVehicleDriver($vehicleDriverID) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try { 
			$stmt = $pdo->prepare('select fuel_type.id,fuel_type.name from vehicle_driver,fuel_rate,fuel_type, vehicle where vehicle_driver.vehicle_id=vehicle.id and fuel_rate.vehicle_id=vehicle.id and fuel_rate.fuel_type_id=fuel_type.id and vehicle_driver.id=? group by fuel_type.id,fuel_type.name');
			$stmt->execute(array($vehicleDriverID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	}

	/**
	 * Iduoto kuro raymas  duomen baz
	 *
	 * @param int $passageSheetID Kelions lapo identifikacinis numeris
	 * @param int $fuelTypeID Kuro tipo identifikacinis numeris
	 * @param Numeric $quantity Iduodamo kuro kiekis
	 *
	 * @return void Iduoto kuro raymas  duomen baz
	 */
	//vehicle_driver_id,program_user_id,trailer_id,passage_sheet_no,passage_from,passage_to,task,document_date
	public function dispenseFuel($passageSheetID,$fuelTypeID,$quantity) {

		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('insert into  dispensed_fuel (passage_sheet_id,fuel_type_id,quantity)  values (?,?,?)');
	
			$stmt->execute(array($passageSheetID,$fuelTypeID,$quantity));
			
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
			//$documentDate .= " \n".$e->getMessage();
		}
	}
	
	/**
	 * Iduoto kuro paalinimas i duomen bazs
	 *
	 * @param int $dispensedFuelID Iduoto kuro identifikacinis numeris
	 */
	public function deleteDispensedFuel($dispensedFuelID) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('delete from dispensed_fuel where id=?');
			$stmt->execute(array($dispensedFuelID));
	
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
	}

	/**
	 * Grainamas iduotas kuras pagal identifikacin numer
	 *
	 * @param int $dispensedFuelID Iduoto kuro identifikacinis numeris
	 * @return Grainamas iduotas kuras pagal identifikacin numer
	 */
	
	public function getDispensedFuelByID($dispensedFuelID) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select id,passage_sheet_id,fuel_type_id,quantity,record_time from dispensed_fuel where id=?');
			$stmt->execute(array($dispensedFuelID));
			$rows = array();
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $row;
	}
	
	/**
	 * Atnaujinami iduoto kuro duomenys
	 *
	 * @param int $dispensedFuelID Iduoto kuro identifikacinis numeris
	 * @param int $fuelTypeID Kuro tipo identifikacinis numeris
	 * @param Numeric $quantity Kuro kiekis
	 * @return void Atnaujinami iduoto kuro duomenys
	 */
	
	public function updateDispensedFuel($dispensedFuelID,$fuelTypeID,$quantity) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('update dispensed_fuel dispensed_fuel set fuel_type_id=?,	quantity=? where id=?');
			$stmt->execute(array($fuelTypeID,$quantity,$dispensedFuelID));
		
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		
	}
	
	/**
	 * Graina sukaiiuot kur, kelions lape esaniai transporto priemonei
	 * 
	 * @param int $passageSheetID Kelions lapo identifikacinis numeris
	 * @param String $dateFrom kuro skaiiavimo pradios data
	 * @param String $dateTo kuro skaiiavimo pradios pabaiga
	 * @return Graina sukaiiuot kur, kelions lape esaniai transporto priemonei
	 */
	
	public function getCalculatedFuel($passageSheetID,$dateFrom,$dateTo) {
		$sql = "";
		if (strlen($dateFrom) > 0) {
			$sql = " and passage_sheet.passage_from>='".$dateFrom."'";
		}
		if (strlen($dateTo) > 0) {
			$sql .= " and passage_sheet.passage_from<='".$dateTo."'";
		}
		
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select sum(used_fuel) as used,fuel_type.name, fuel_type.id as fuel_type_id, (select sum(quantity) from passage_sheet, dispensed_fuel where passage_sheet.id=dispensed_fuel.passage_sheet_id and fuel_type.id=dispensed_fuel.fuel_type_id   and passage_sheet.vehicle_driver_id in (select vehicle_driver.id from vehicle_driver where vehicle_id in (select vehicle.id from passage_sheet,vehicle_driver,vehicle,model,make where passage_sheet.vehicle_driver_id=vehicle_driver.id and vehicle_driver.vehicle_id=vehicle.id and vehicle.model_id=model.id and model.make_id = make.id and passage_sheet.id=?) '.$sql.')  )  as dispensed from passage_sheet,passage_sheet_record,fuel_type,fuel_rate where passage_sheet.id=passage_sheet_record.passage_sheet_id and fuel_rate.id=passage_sheet_record.fuel_rate_id and fuel_rate.fuel_type_id=fuel_type.id and passage_sheet.vehicle_driver_id in (select vehicle_driver.id from vehicle_driver where vehicle_id in (select vehicle.id from passage_sheet,vehicle_driver,vehicle,model,make where passage_sheet.vehicle_driver_id=vehicle_driver.id and vehicle_driver.vehicle_id=vehicle.id and vehicle.model_id=model.id and model.make_id = make.id and passage_sheet.id=?) '.$sql.')   group by fuel_type.id,fuel_type.name order by fuel_type.name');
			$stmt->execute(array($passageSheetID,$passageSheetID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	}
	
	/**
	 * Grainami kelions lapo raai
	 *
	 * @param int $passageSheetID Kelions lapo identifikacinis numeris
	 * @return Grainami kelions lapo raai
	 */
	
	public function getPassageSheetRecords($passageSheetID) {
		
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('SELECT passage_sheet_record.id,passage_sheet_record.passage_sheet_id,passage_sheet_record.load_id,passage_sheet_record.job_id,passage_sheet_record.account_id,passage_sheet_record.fuel_rate_id,passage_sheet_record.fuel_coefficient,passage_sheet_record.km_without_load,passage_sheet_record.km_with_load,passage_sheet_record.load_discharge,passage_sheet_record.load_discharge_price,passage_sheet_record.load_quantity,passage_sheet_record.job_quantity,passage_sheet_record.from_place,passage_sheet_record.to_place,passage_sheet_record.used_fuel,passage_sheet_record.earnings,passage_sheet_record.record_time,passage_sheet_record.earnings_coef,passage_sheet_record.index_group,passage_sheet_record.earnings_type,passage_sheet_record.fuel_calc_type,passage_sheet_record.motor_hours,passage_sheet_record.work_date, load.load_name,load.load_code,job.job_name,job.job_code,account.account_name,account.account_code,account.account_code ||\' \'|| account.account_name as account,  fuel_rate.fuel_rate_name,fuel_rate.fuel_rate_name ||\' - \'||passage_sheet_record.fuel_coefficient as fuelratecoef,km_without_load + km_with_load as km FROM passage_sheet_record left join load  on  passage_sheet_record.load_id=load.id left join job on passage_sheet_record.job_id=job.id Left join account on passage_sheet_record.account_id=account.id left join fuel_rate on passage_sheet_record.fuel_rate_id=fuel_rate.id where passage_sheet_record.passage_sheet_id=?');
			$stmt->execute(array($passageSheetID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	}
	
}

//$con = new Connection();
//$e = new Employer();
//print_r($e->getData());
 
//$nam = new PassageSheet(); 
//print_r($nam->insertPassageSheet('07/30/2014','07/30/2014','07/30/2014',115,37,2,'kk'));

?>