<?php

require_once 'Connection.php';

/**
 * Operacij su modeliais ir markmis valdymo klas
 *
 * Operacij su modeliais ir markmis valdymo klas
 *
 * @author     Mindaugas rimkus <mindaugas.rimkus@disigma.lt>
 */

class MakesModels  {

	
	/**
	 * Grainamos marks pagal paiekos slyg
	 *
	 * @param String $search Paiekos slyga
	 *
	 * @return Grainami marks pagal paiekos slyg
	 */
	
	public function getMakes ($search) {
	
		$sql = "";
		if (strlen($search) > 0) {
			$sql .= " and lower(name) like lower('%".$search."%')";
		}
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select id,name,description,is_deleted,record_time from make where is_deleted=false '.$sql.' order by name');
			$stmt->execute(array());
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	
	}
	
	
	/**
	 * Grainami modeliai pagal paiekos slyg
	 *
	 * @param int int $searchParam Paiekos parametras 0 - Modelio pavadinimas; 1 - L / K / P modelio tipas Lengvoji, krovinin, priekaba
	 * @param String $search Paiekos slyga
	 * @param int $makeID marks identifikacinis numeris
	 *
	 * @return Grainami modeliai pagal paiekos slyg
	 */
	
	public function getModels ($searchParam,$search,$makeID) {
	
			$sql = "";

		if ($searchParam == 0 && strlen($search) > 0) {
			$sql .= " and lower(model.name) like lower('%".$search."%')";
		}

		if ($searchParam == 1 && ($search=='L' or $search=='l')) {
			$sql .= " and model.vehicle_type=1";
		}
		if ($searchParam == 1 && ($search=='K' or $search=='k')) {
			$sql .= " and model.vehicle_type=2";
		}
		if ($searchParam == 1 && ($search=='P' or $search=='p')) {
			$sql .= " and model.vehicle_type=3";
		}
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select id,make_id,name,description,is_deleted,record_time,vehicle_type,CASE WHEN vehicle_type=1 THEN \'Lengvasis\' WHEN vehicle_type=2 THEN \'Krovininis\' WHEN vehicle_type=3 THEN \'Priekaba\' END as vehicle_type_str from model where is_deleted=false and make_id=? '.$sql.' order by name');
			$stmt->execute(array($makeID));
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	
	}
	
}

//$con = new Connection();
//$e = new Employer();
//print_r($e->getData());
 
//$nam = new PassageSheet(); 
//print_r($nam->insertPassageSheet('07/30/2014','07/30/2014','07/30/2014',115,37,2,'kk'));

?>