<?php

require_once 'Connection.php';

/**
 * Prisijungimo valdymo klas
 *
 * Prisijungimo prie kelions lap apskaitos programos valdymo klas
 *
 * @author     Mindaugas rimkus <mindaugas.rimkus@disigma.lt>
 */

class Login {
	
	/**
	 * Graina programos vartotojo identifikacin numer
	 *
	 * @param string $username vedamas vartotojo vardas
	 * @param string $password vedamas slaptaodis
	 * @return Graina programos vartotojo identifikacin numer arba 0 jei vartotojas nerastas
	 */
	
	public function getLogin($username,$password) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select program_user.personnel_id,program_user.id, company.id as company_id from company,subdivision,personnel,program_user where company.id=subdivision.company_id and subdivision.id=personnel.subdivision_id and personnel.id=program_user.personnel_id and username like ? and password like ? ');
			$stmt->execute(array($username, $password));
			$row = $stmt->fetch();
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return array('personnel_id'=>0+$row["personnel_id"],'program_user_id'=>0+$row["id"],'company_id'=>0+$row["company_id"]);
	
	}
	
	/**
	 * Graina programos vartotojo duomenys
	 *
	 * @param int $id Programos vartotojo identifikacinis numeris
	 * @return Graina programos vartotojo duomenys
	 */
	
	public function getProgramUserData($id) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select company.name as company_name,subdivision.name as subdivision_name,position.name as position_name,personnel.name,personnel.surname from company,subdivision,position,personnel where company.id=subdivision.company_id and position.id=personnel.position_id and subdivision.id=personnel.subdivision_id and personnel.id=?');
			$stmt->execute(array($id));
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $row;
	
	}
	


	
}

//$con = new Connection();
//$e = new Employer();
//print_r($e->getData());
 
//$nam = new Login();
//print_r($nam->getLogin('labas','labas'));

?>