<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Test
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: AllTests.php 23522 2010-12-16 20:33:22Z andries $
 */

if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'Zend_Test_PHPUnit_AllTests::main');
}

require_once 'Zend/Test/PHPUnit/ControllerTestCaseTest.php';
require_once 'Zend/Test/PHPUnit/Db/AllTests.php';
require_once 'Zend/Test/PHPUnit/Constraint/AllTests.php';

/**
 * @category   Zend
 * @package    Zend_Test
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @group      Zend_Test
 * @group      Zend_Test_PHPUnit
 */
class Zend_Test_PHPUnit_AllTests
{
    public static function main()
    {
        PHPUnit_TextUI_TestRunner::run(self::suite());
    }

    public static function suite()
    {
        $suite = new PHPUnit_Framework_TestSuite('Zend Framework - Zend_Test_PHPUnit');

        $suite->addTestSuite('Zend_Test_PHPUnit_ControllerTestCaseTest');
        $suite->addTest(Zend_Test_PHPUnit_Db_AllTests::suite());
        $suite->addTest(Zend_Test_PHPUnit_Constraint_AllTests::suite());

        return $suite;
    }
}

if (PHPUnit_MAIN_METHOD == 'Zend_Test_PHPUnit_AllTests::main') {
    Zend_Test_PHPUnit_AllTests::main();
}
