<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

*Padangų informacijos valdymo klasė
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Tyre
{
	/**
	*Gražinamas visų skirtingų padangų pločių masyvas
	*@return Array visų skirtingų padangų pločių masyvas
	*/
	public function getAllTyresWidth()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct tyre_width from tyre where is_deleted=false order by tyre_width asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresWidth()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų padangų aukščių masyvas
	*@return Array visų skirtingų padangų aukščių masyvas
	*/
	public function getAllTyresHeight()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct height from tyre where is_deleted=false order by height asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresHeight()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų padangų diametrų masyvas
	*@return Array visų skirtingų padangų diametrų masyvas
	*/

	public function getAllTyresDiameter()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct diameter from tyre where is_deleted=false order by diameter asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresDiameter()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų greičio indeksų masyvas
	*@return Array visų skirtingų greičio indeksų masyvas
	*/

	public function getAllTyresSpeedIndex()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct speed_index from tyre where is_deleted=false order by speed_index asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresSpeedIndex()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų apkrovimo indeksų masyvas
	*@return Array visų skirtingų apkrovimo indeksų masyvas
	*/

	public function getAllTyresLoadIndex()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct load_index from tyre where is_deleted=false order by load_index asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresLoadIndex()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų padangų raštų masyvas
	*@return Array visų skirtingų padangų raštų masyvas
	*/

	public function getAllTyresWeave()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct weave from tyre where is_deleted=false order by weave asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyresWeave()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų padangų gamintojų pavadinimų masyvas
	*@return Array visų skirtingų padangų gamintojų pavadinimų masyvas
	*/

	public function getTyreManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from tyre_manufacturer where id = any(select distinct tyre_manufacturer_id from tyre where is_deleted=false order by tyre_manufacturer_id) order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTyreManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų padangų gamintojų pavadinimų masyvas
	*@return Array visų skirtingų padangų gamintojų pavadinimų masyvas
	*/

	public function getAllTyreManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from tyre_manufacturer order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getAllTyreManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas padangų duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš tyre lentelės pagal pateiktas paieškos sąlygas
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $tyre_manufacturer_id Padangų gamintojo identifikacinis numeris
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Padangų sezonas: 1 - vasara; 2 - žiema; 3 - Visasezoninė; 4 - Džipams;
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param numeric(7,2) $max_price Padangos kaina
	*@param String $weave Padangos raštas
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array padangų duomenų masyvas
	*/

	public function getTyres($offset,$limit,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$max_price,$weave,$user_discount)
	{
		//echo $max_price;
		if ($tyre_manufacturer_id+0 == 0) {
			$tyre_manufacturer_id = '%';
		}
		if ($tyre_width+0 == 0) {
			$tyre_width = '%';
		}
		if ($height+0 == 0) {
			$height = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($season+0 == 0) {
			$season = '%';
		}
		if ($load_index+0 == 0) {
			$load_index = '%';
		}
		$speed_index = trim($speed_index);
		if (strlen($speed_index) == 0) {
			$speed_index = '%';
		}
		$weave = trim($weave);
		if (strlen($weave) == 0) {
			$weave = '%';
		}	
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select id, tyre_manufacturer_id, tyre_width, height, diameter, season, load_index, speed_index, price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from tyre where is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.') and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' order by price limit '.$limit.' offset '.$offset;	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select tyre.id, tyre_manufacturer_id, name, tyre_width, height, diameter, season, load_index, speed_index, price_lt,min_price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price,price_in_store from tyre,tyre_manufacturer where tyre_manufacturer.id=tyre.tyre_manufacturer_id and tyre.is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' order by price limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTyres()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinamas padangų akcijų duomenų masyvas
	*@param Integer $tyre_manufacturer_id Padangų gamintojo identifikacinis numeris
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Padangų sezonas: 1 - vasara; 2 - žiema; 3 - Visasezoninė; 4 - Džipams;
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param numeric(7,2) $max_price Padangos kaina
	*@param String $weave Padangos raštas
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array padangų akcijų duomenų masyvas
	*/

	public function getTyresSales($tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$max_price,$weave,$user_discount)
	{
		//echo $max_price;
		if ($tyre_manufacturer_id+0 == 0) {
			$tyre_manufacturer_id = '%';
		}
		if ($tyre_width+0 == 0) {
			$tyre_width = '%';
		}
		if ($height+0 == 0) {
			$height = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($season+0 == 0) {
			$season = '%';
		}
		if ($load_index+0 == 0) {
			$load_index = '%';
		}
		$speed_index = trim($speed_index);
		if (strlen($speed_index) == 0) {
			$speed_index = '%';
		}
		$weave = trim($weave);
		if (strlen($weave) == 0) {
			$weave = '%';
		}	
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select id, tyre_manufacturer_id, tyre_width, height, diameter, season, load_index, speed_index, price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from tyre where is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.') and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' order by price limit '.$limit.' offset '.$offset;	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select tyre.id, tyre_manufacturer_id, name, tyre_width, height, diameter, season, load_index, speed_index, price_lt,min_price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price,price_in_store from tyre,tyre_manufacturer where tyre_manufacturer.id=tyre.tyre_manufacturer_id and tyre.is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' and status=2 order by price');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTyres()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas padangų kiekis pagal paieškos sąlygas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš tyre lentelės pagal pateiktas paieškos sąlygas
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $tyre_manufacturer_id Padangų gamintojo identifikacinis numeris
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Padangų sezonas: 1 - vasara; 2 - žiema; 3 - Visasezoninė; 4 - Džipams;
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param numeric(7,2) $price_lt Padangos kaina
	*@param String $weave Padangos raštas
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array padangų kiekis pagal paieškos sąlygas
	*/

	public function getTyresCount($offset,$limit,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$max_price,$weave,$user_discount)
	{
		
		//echo $max_price;
		if ($tyre_manufacturer_id+0 == 0) {
			$tyre_manufacturer_id = '%';
		}
		if ($tyre_width+0 == 0) {
			$tyre_width = '%';
		}
		if ($height+0 == 0) {
			$height = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($season+0 == 0) {
			$season = '%';
		}
		if ($load_index+0 == 0) {
			$load_index = '%';
		}
		$speed_index = trim($speed_index);
		if (strlen($speed_index) == 0) {
			$speed_index = '%';
		}
		$weave = trim($weave);
		if (strlen($weave) == 0) {
			$weave = '%';
		}	
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo "$offset,$limit,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$max_price,$weave,$user_discount";
		//echo 'select id, tyre_manufacturer_id, tyre_width, height, diameter, season, load_index, speed_index, price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from tyre where is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.') and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' order by price limit '.$limit.' offset '.$offset;	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select count(tyre.id) from tyre,tyre_manufacturer where tyre_manufacturer.id=tyre.tyre_manufacturer_id and tyre.is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' limit '.$limit.' offset '.$offset);
		if (PEAR::isError($result)) {
			$db->disconnect();
			echo $result->getDebugInfo();
			die('Kritinė klaida: Tyre->getTyresCount()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
		
	}
	
	
	/**
	*Gražinamas akcijinių padangų kiekis pagal paieškos sąlygas
	*@param Integer $tyre_manufacturer_id Padangų gamintojo identifikacinis numeris
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Padangų sezonas: 1 - vasara; 2 - žiema; 3 - Visasezoninė; 4 - Džipams;
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param numeric(7,2) $price_lt Padangos kaina
	*@param String $weave Padangos raštas
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array akcijinių padangų kiekis pagal paieškos sąlygas
	*/

	public function getTyresCountSales($tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$max_price,$weave,$user_discount)
	{
		//echo $max_price;
		if ($tyre_manufacturer_id+0 == 0) {
			$tyre_manufacturer_id = '%';
		}
		if ($tyre_width+0 == 0) {
			$tyre_width = '%';
		}
		if ($height+0 == 0) {
			$height = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($season+0 == 0) {
			$season = '%';
		}
		if ($load_index+0 == 0) {
			$load_index = '%';
		}
		$speed_index = trim($speed_index);
		if (strlen($speed_index) == 0) {
			$speed_index = '%';
		}
		$weave = trim($weave);
		if (strlen($weave) == 0) {
			$weave = '%';
		}	
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select id, tyre_manufacturer_id, tyre_width, height, diameter, season, load_index, speed_index, price_lt, weave, description_lt, description_en, description_ru, small_photo_path, discount_flag, status, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from tyre where is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.') and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' order by price limit '.$limit.' offset '.$offset;	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select count(tyre.id) from tyre,tyre_manufacturer where tyre_manufacturer.id=tyre.tyre_manufacturer_id and tyre.is_deleted=false and trim(to_char(tyre_manufacturer_id,\'999999999999\')) like \''.$tyre_manufacturer_id.'\' and trim(to_char(tyre_width,\'999999999999\')) like \''.$tyre_width.'\' and trim(to_char(height,\'999999999999\')) like \''.$height.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and trim(to_char(season,\'999999999999\')) like \''.$season.'\' and trim(to_char(load_index,\'999999999999\')) like \''.$load_index.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and speed_index like \''.$speed_index.'\' and weave  like \''.$weave.'\' and status=2');
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $result->getDebugInfo();
			die('Kritinė klaida: Tyre->getTyresCount()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
		
	}
	
	/**
	*
	*
	*Gražinama maksimali prekės kaina
	*@return Integer 0 ir daugiau - maksimali prekės kaina
	*/
	public function getTopPrice()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select max(price_lt) from tyre where is_deleted=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTopPrice()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			
			$result->fetchInto($data);
			//echo $data[0].":ma price";
			return $data[0]+0;
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas pasirinktos padangos duomenų masyvas
	*@param Integer $tyreID Padangos identifikacinis numeris
	*@return Array padangų duomenų masyvas
	*/

	public function getTyre($tyreID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select tyre.id, tyre_manufacturer_id, name, tyre_width, height, diameter, season, load_index, speed_index, price_lt,min_price_lt, weave, description_lt, description_en, description_ru, big_photo_path, discount_flag, status, balance, price_in_store, small_photo_path from tyre,tyre_manufacturer where tyre_manufacturer.id=tyre.tyre_manufacturer_id and tyre.id='.$tyreID);
		if (PEAR::isError($res)) {
			//echo $res->getMessage();
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTyre()');
		}
		$res->fetchInto($selectedTyre);
		$db->disconnect();
		return $selectedTyre;
		
	}
	
	/**
	*
	*Gražinamas padangų likutis
	*@param Integer $tyreID Padangos identifikacinis numeris
	*@return Integer 0 ir daugiau - padangų likutis
	*/
	public function getTyreBalance($tyreID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select balance from tyre where id='.$tyreID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->getTyreBalance()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Skaičiaus tikrinimas
	*@param String $digit Skaičius
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function isDigit($digit)
	{
		$digit = trim($digit);
		if (strlen($digit) == 0) return false; 
		
		if (preg_match("/[^\d]/",$digit)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Skaičiaus po kablelio tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Atnaujinami padangos duomenys
	*@param Integer $id Padangos identifikacinis numeris
	*@param Integer $tyre_manufacturer_id Padangos gamintojo ID
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Sezonas
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali padangos kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $weave Raštas
	*@param String $description_lt Aprašymas LT
	*@param String $description_en Aprašymas EN
	*@param String $description_ru Aprašymas RU
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Integer $status Statusas
	*/
	public function updateTyre($id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status)
	{
		//echo "$id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update tyre set tyre_manufacturer_id=?,tyre_width=?,height=?,diameter=?,season=?,load_index=?,speed_index=?,balance=?,price_lt=?,min_price_lt=?,price_in_store=?,weave=?,description_lt=?,description_en=?,description_ru=?,big_photo_path=?,small_photo_path=?,discount_flag=?,status=? where id=?');
		$data = array($tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status,$id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getDebugInfo();
			die('Kritinė klaida: Tyre->updateTyre()');
		}
		$db->disconnect();
	}
	
	/**
	*Įterpiami padangos duomenys
	*@param Integer $tyre_manufacturer_id Padangos gamintojo ID
	*@param Integer $tyre_width Padangos plotis
	*@param Integer $height Padangos aukštis
	*@param Integer $diameter Padangos diametras
	*@param Integer $season Sezonas
	*@param Integer $load_index Apkrovimo indeksas
	*@param String $speed_index Greičio indeksas
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali padangos kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $weave Raštas
	*@param String $description_lt Aprašymas LT
	*@param String $description_en Aprašymas EN
	*@param String $description_ru Aprašymas RU
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Boolean $status Statusas
	*/
	public function insertTyre($tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status)
	{
		//echo "$id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into tyre (tyre_manufacturer_id,tyre_width,height,diameter,season,load_index,speed_index,balance,price_lt,min_price_lt,price_in_store,weave,description_lt,description_en,description_ru,big_photo_path,small_photo_path,discount_flag,status) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			echo $query_res->getDebugInfo();
			die('Kritinė klaida: Tyre->insertTyre()');
		}
		$db->disconnect();
	}
	
	/**
	*Padangos pašalinimas
	*
	*@param Integer $tyreID Padangos identifikacinis numeris
	*@return void
	*/
	public function removeTyre($tyreID)
	{
		$tyre = $this->getTyre($tyreID);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from tyre where id='.$tyreID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Tyre->removeTyre()');
		}
		$db->disconnect();
		
		
		$big_photo_path = $tyre[15];
		$small_photo_path = $tyre[20];
		
		unlink ($big_photo_path);
		unlink ($small_photo_path);
	}
}
?>