<?php

require_once ('DB.php');

/**
 * Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
 */
require_once ('ConnectManager.class.php');

/**
 * Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
 */
require_once ('Logging.class.php');

/**
 * Prijungiama HTTP/Client.php PEAR klasių rinkinio HTTP request'ų valdymo klasė
 */
require_once 'HTTP/Client.php';

/**
 * Prijungiama lib/nusoap.php SOAP variklis
 */
require_once ('lib/nusoap.php');

/**
 * Sisteminė klasė 
 */

require_once ('System.class.php');

/**

 * Šioje klasėje realizuotos daugiatarifių SMS žinučių siuntimas
 *@copyright Copyright 2006, Mindaugas Rimkus
 */
class MessageSender {
	
	/**
	 *Gražinamas sekantis tele2 tranzakcijos ID
	 *
	 *@return Integer tele2 transaction ID
	 */
	
	public function getTele2TransactionID() {
		$connect = new ConnectManager ( );
		$db = $connect->getConnect ();
		$result = $db->query ( 'select nextval(\'tele2\') ' );
		if (PEAR::isError ( $result )) {
			$db->disconnect ();
			die ( 'Kritine klaida: getTele2TransactionID()' );
		}
		
		$db->disconnect ();
		$id = 0;
		if ($result->numRows ()) {
			$result->fetchInto ( $data );
			$id = $data [0];
		}
		if ($id == 2147483647) {
			$connect = new ConnectManager ( );
			$db = $connect->getConnect ();
			$result = $db->query ( 'select setval(\'tele2\',1,false) ' );
			if (PEAR::isError ( $result )) {
				$db->disconnect ();
				die ( 'Kritine klaida: getTele2TransactionID() restart' );
			}
			
			$db->disconnect ();
		}
		return $id;
	}
	
	/**
	 *
	 *Išsiunčiama daugetarifė SMS žinutė
	 *@param Integer $clientID Išiųstos žinutės identifikavimas pagal užsetintą ID (Ka gavus reportą būtų galima atsekti kokia  tai žinutė)
	 *@param String $destinationNumber Gavėjo telefono numeris
	 *@param String $originNumber Siuntėjo telefono numeris
	 *@param String $messageText SMS žinutės tekstas
	 *@param Integer $price Žinutės kaina centais
	 *@param integer $status Papildomas statusas perduodamas į delivery reportą (1 - SMS siustas pagal gautą žinutę)
	 *@return void Išsiunčiama daugetarifė SMS žinutė
	 */
	public function sendMessage($clientID, $destinationNumber, $originNumber, $messageText, $price, $status) {
		//$client = new soapclient__('https://cbg2.tele2.com:443',true);
		$client = new soapclient__('https://62.80.229.104:443',true);
		$log = new Logging ( );
		$http = new HTTP_Client ( );
		
		$messageText = urlencode ( $messageText );
		$deliveryURL = urlencode ( "http://rae6ahpheiPu:Aeyir8cosaix@127.0.0.1/tele2/delivery_reports.php?clientid=$clientID&identification=$status&status=%d&statusstring=%A" );
		
		$phone = str_replace ( '+', '00', $destinationNumber );
		$price = ( int ) $price;
		$tID = $this->getTele2TransactionID();
		//$param = array ('login.user' => 'K9837808', 'login.password' => 'JuYviJaHrWuhteGV7RzWRxwBGzAQtQ', 'Version' => 203, 'OriginatingCustomerId' => "$phone", 'ContentType' => 2, 'Amount' => ( int ) $price, 'Currency' => 9, 'ContentDescription' => 'INFOTELA', 'VAT' => 1900 );
		
		$body = '
		<T2api:Call xmlns:T2api="urn:/T2api/Proto/Soap">
			<T2api:request>
				<T2api:url>CBG</T2api:url>
				<T2api:method>Purchase</T2api:method>
				<T2api:kwargs>
					<T2api:item>
						<T2api:key>Version</T2api:key>
						<T2api:valueUnsigned>208</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>ContentType</T2api:key>
						<T2api:valueUnsigned>2</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>Currency</T2api:key>
						<T2api:valueUnsigned>9</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>Amount</T2api:key>
						<T2api:valueUnsigned>'.$price.'</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>VAT</T2api:key>
						<T2api:valueUnsigned>1900</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>OriginatingCustomerId</T2api:key>
						<T2api:valueString>'.$phone.'</T2api:valueString>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>username</T2api:key>
						<T2api:valueString>K9837808</T2api:valueString>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>password</T2api:key>
						<T2api:valueString>#dm$9m9YTXXPBWnBME+9wPT3</T2api:valueString>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>ContentDescription</T2api:key>
						<T2api:valueString>INFOTELA</T2api:valueString>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>ProviderTransactionId</T2api:key>
						<T2api:valueUnsigned>'.$tID.'</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>ReferenceID</T2api:key>
						<T2api:valueUnsigned>0</T2api:valueUnsigned>
					</T2api:item>
					
					<T2api:item>
						<T2api:key>XtraData</T2api:key>
						<T2api:valueString>Provider definedtext</T2api:valueString>
					</T2api:item>
				</T2api:kwargs>
			</T2api:request>
		</T2api:Call>
		
		';
		
		$soapmes =  $client->serializeEnvelope($body,$HEADER,array(),'document', 'literal');
 		$client->send($soapmes, $SOAPACTION);
 		
		$pattern = '/[?\n\s\W\w]*\?xml/i';
		$res = preg_replace($pattern, "", $client->response);
		$res = '<?xml '.$res; 
        $messageXML = simplexml_load_string($res);

		$body = $messageXML->children("http://schemas.xmlsoap.org/soap/envelope/");
		$response = $body->children("urn:/T2api/Proto/Soap");
		//echo "Pranesimas KLAIDA:".$response[0]->data[0]->item[0]->valueDict[0]->item[1]->valueUnsigned[0];
		//echo "Pranesimas OK:".$response[0]->data[0]->item[0]->valueDict[0]->item[1]->valueSigned[0];
		//echo "Statusas:".$response[0]->rc;
		
		
		$statArray = $response[0]->data[0]->item[0]->valueDict[0]->item[1]->children("urn:/T2api/Proto/Soap");
		$stat = $statArray[1];
		
		if (strlen($stat) == 0) {
			$stat = $response[0]->rc;
		}
		
		if ($stat != '0') {
			
			$errorStatus = $stat;
			if ($errorStatus == 1) {
				$faultMessage = urlencode ( "Content Provider does not exist" );
			}
			if ($errorStatus == 2) {
				$faultMessage = urlencode ( "Amount is out of range" );
			}
			if ($errorStatus == 3) {
				$faultMessage = urlencode ( "Customer does not exist" );
			}
			if ($errorStatus == 4) {
				$faultMessage = urlencode ( "Purchase within time restriction. Customer must not be charged with multiple transactions for the same  service." );
			}
			if ($errorStatus == 5) {
				$faultMessage = urlencode ( "Invalid routing information" );
			}
			if ($errorStatus == 6) {
				$faultMessage = urlencode ( "To many requests in timeframe" );
			}
			if ($errorStatus == 7) {
				$faultMessage = urlencode ( "To many pending IN requests" );
			}
			if ($errorStatus == 8) {
				$faultMessage = urlencode ( "Customer does not exist in IN" );
			}
			if ($errorStatus == 9) {
				$faultMessage = urlencode ( "Customer account balance to low" );
			}
			if ($errorStatus == 10) {
				$faultMessage = urlencode ( "IN read timeout during balance check" );
			}
			if ($errorStatus == 11) {
				$faultMessage = urlencode ( "IN read timeout during withdrawal" );
			}
			if ($errorStatus == 12) {
				$faultMessage = urlencode ( "Communication error before withdrawal" );
			}
			if ($errorStatus == 13) {
				$faultMessage = urlencode ( "Communication error during withdrawal" );
			}
			if ($errorStatus == 14) {
				$faultMessage = urlencode ( "Invalid CHARGE ACCOUNT" );
			}
			if ($errorStatus == 15) {
				$faultMessage = urlencode ( "Invalid VAT_PERCENTAGE" );
			}
			if ($errorStatus == 16) {
				$faultMessage = urlencode ( "Invalid CURRENCY" );
			}
			if ($errorStatus == 17) {
				$faultMessage = urlencode ( "IN Node not connected" );
			}
			if ($errorStatus == 18) {
				$faultMessage = urlencode ( "The content provider and customer are of different nationalities" );
			}
			if ($errorStatus == 19) {
				$faultMessage = urlencode ( "Requested currency differs from provider currency" );
			}
			if ($errorStatus == 20) {
				$faultMessage = urlencode ( "Invalid provider currency. The currency is not correct" );
			}
			if ($errorStatus == 21) {
				$faultMessage = urlencode ( "Max number of outstanding CGB requests exceeded" );
			}
			if ($errorStatus == 22) {
				$faultMessage = urlencode ( "Customer has requested barring service for MMS or Content or both MMS and Content." );
			}
			if ($errorStatus == 23) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 24) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 25) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 26) {
				$faultMessage = urlencode ( "Customer account has either expired, or never been activated for the content service (no first call)." );
			}
			if ($errorStatus == 27) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 28) {
				$faultMessage = urlencode ( "Internal error - payment broker" );
			}
			if ($errorStatus == 29) {
				$faultMessage = urlencode ( "Internal error/timeout" );
			}
			if ($errorStatus == 30) {
				$faultMessage = urlencode ( "Internal error - transaction already open" );
			}
			if ($errorStatus == 31) {
				$faultMessage = urlencode ( "Internal error - transaction busy" );
			}
			if ($errorStatus == 32) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 33) {
				$faultMessage = urlencode ( "Internal error - possible overload" );
			}
			if ($errorStatus == 35) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 36) {
				$faultMessage = urlencode ( "Customer under 16 yrs" );
			}
			if ($errorStatus == 37) {
				$faultMessage = urlencode ( "Age check failed (no age data on customer or multiple rows)" );
			}
			if ($errorStatus == 38) {
				$faultMessage = urlencode ( "Customer under 18 yrs" );
			}
			if ($errorStatus == 39) {
				$faultMessage = urlencode ( "Customer info" );
			}
			if ($errorStatus == 40) {
				$faultMessage = urlencode ( "Customer info" );
			}
			if ($errorStatus == 41) {
				$faultMessage = urlencode ( "Customer info error" );
			}
			if ($errorStatus == 42) {
				$faultMessage = urlencode ( "Customer info error" );
			}
			if ($errorStatus == 43) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 44) {
				$faultMessage = urlencode ( "Duplicate found (ProviderTransactionID already used)" );
			}
			if ($errorStatus == 45) {
				$faultMessage = urlencode ( "Duplicate function error" );
			}
			if ($errorStatus == 46) {
				$faultMessage = urlencode ( "Duplicate found (ProviderTransactionID already used) but previous transaction status not found" );
			}
			if ($errorStatus == 47) {
				$faultMessage = urlencode ( "Incoming queue timeout1" );
			}
			if ($errorStatus == 48) {
				$faultMessage = urlencode ( "Incoming queue timeout2" );
			}
			if ($errorStatus == 50) {
				$faultMessage = urlencode ( "Customer has requested barring service for adult content" );
			}
			if ($errorStatus == 51) {
				$faultMessage = urlencode ( "Limit for Content exceeded" );
			}
			if ($errorStatus == 52) {
				$faultMessage = urlencode ( "Limit for MMS exceeded" );
			}
			if ($errorStatus == 53) {
				$faultMessage = urlencode ( "Limit for Volume exceeded" );
			}
			if ($errorStatus == 54) {
				$faultMessage = urlencode ( "Customer not Active" );
			}
			if ($errorStatus == 400) {
				$faultMessage = urlencode ( "UnknownURI" );
			}
			if ($errorStatus == 401) {
				$faultMessage = urlencode ( "ReadOnlyURI" );
			}
			if ($errorStatus == 402) {
				$faultMessage = urlencode ( "UnknownMethod" );
			}
			if ($errorStatus == 410) {
				$faultMessage = urlencode ( "UnknownKey" );
			}
			if ($errorStatus == 411) {
				$faultMessage = urlencode ( "ReadonlyKey" );
			}
			if ($errorStatus == 412) {
				$faultMessage = urlencode ( "SubspaceNotAllowed" );
			}
			if ($errorStatus == 413) {
				$faultMessage = urlencode ( "SubspaceNeeded" );
			}
			if ($errorStatus == 414) {
				$faultMessage = urlencode ( "UnknownSubspace" );
			}
			if ($errorStatus == 415) {
				$faultMessage = urlencode ( "DuplicateKey" );
			}
			if ($errorStatus == 416) {
				$faultMessage = urlencode ( "ValueNotSet" );
			}
			if ($errorStatus == 420) {
				$faultMessage = urlencode ( "ParameterUnknown" );
			}
			if ($errorStatus == 421) {
				$faultMessage = urlencode ( "ParameterNeeded" );
			}
			if ($errorStatus == 422) {
				$faultMessage = urlencode ( "ParameterSyntaxError" );
			}
			if ($errorStatus == 423) {
				$faultMessage = urlencode ( "ParameterInvalid" );
			}
			if ($errorStatus == 424) {
				$faultMessage = urlencode ( "ParameterLengthInvalid" );
			}
			if ($errorStatus == 425) {
				$faultMessage = urlencode ( "ParameterIllegalCharacters" );
			}
			if ($errorStatus == 430) {
				$faultMessage = urlencode ( "AuthenticationFailed" );
			}
			if ($errorStatus == 431) {
				$faultMessage = urlencode ( "AuthorizationFailed" );
			}
			if ($errorStatus == 432) {
				$faultMessage = urlencode ( "Suspended" );
			}
			if ($errorStatus == 433) {
				$faultMessage = urlencode ( "Disabled" );
			}
			if ($errorStatus == 434) {
				$faultMessage = urlencode ( "ClientNotAuthenticated" );
			}
			if ($errorStatus == 441) {
				$faultMessage = urlencode ( "ClientNotAuthorized" );
			}
			if ($errorStatus == 442) {
				$faultMessage = urlencode ( "UserNotAuthenticated" );
			}
			if ($errorStatus == 443) {
				$faultMessage = urlencode ( "UserNotAuthorized" );
			}
			if ($errorStatus == 444) {
				$faultMessage = urlencode ( "NotEncypted" );
			}
			if ($errorStatus == 450) {
				$faultMessage = urlencode ( "ValueUndefined" );
			}
			if ($errorStatus == 451) {
				$faultMessage = urlencode ( "SearchCriteriaTooWide" );
			}
			if ($errorStatus == 452) {
				$faultMessage = urlencode ( "ObjectNotFound" );
			}
			if ($errorStatus == 453) {
				$faultMessage = urlencode ( "OperationNotAllowed" );
			}
			if ($errorStatus == 500) {
				$faultMessage = urlencode ( "Unavailable" );
			}
			if ($errorStatus == 501) {
				$faultMessage = urlencode ( "Aborted" );
			}
			if ($errorStatus == 502) {
				$faultMessage = urlencode ( "ProtocolError" );
			}
			if ($errorStatus == 503) {
				$faultMessage = urlencode ( "Cluster" );
			}
			if ($errorStatus == 530) {
				$faultMessage = urlencode ( "TransactionFailed: often indicates a syntax error in the XML or incompatibility between XML and wsdl (possible with respect to the defined value). Where this is difficult to resolve, test with the XML from this document, and change only that which needs to be changed." );
			}	
			if ($errorStatus == 531) {
				$faultMessage = urlencode ( "OutOfResources" );
			}
			if ($errorStatus == 532) {
				$faultMessage = urlencode ( "UnknownSession" );
			}
			if ($errorStatus == 533) {
				$faultMessage = urlencode ( "Again" );
			}
			if ($errorStatus == 533) {
				$faultMessage = urlencode ( "Timeout" );
			}
			
			if ($errorStatus == 540) {
				$faultMessage = urlencode ( "BackendUnavailablePermanently" );
			}
			if ($errorStatus == 541) {
				$faultMessage = urlencode ( "BackendUnavailableTemporarily" );
			}
	
			if ($errorStatus == 1001) {
				$faultMessage = urlencode ( "Unknown MSISDN" );
			}
			if ($errorStatus == 1002) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 1003) {
				$faultMessage = urlencode ( "Not Enough Credit" );
			}
			if ($errorStatus == 1004) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 1005) {
				$faultMessage = urlencode ( "Internal error" );
			}
			if ($errorStatus == 1006) {
				$faultMessage = urlencode ( "Internal error" );
			}

			if (preg_match("/^999\d*/i",$errorStatus)) {
				$faultMessage = urlencode ( $result ['faultstring'] );
			} else {
				$errorStatus += 1000;
			}
			
			$url = "http://rae6ahpheiPu:Aeyir8cosaix@127.0.0.1/tele2/delivery_reports.php?clientid=$clientID&identification=$status&status=$errorStatus&statusstring=$faultMessage";
		} else {
			$destinationNumber = str_replace ( '+370', '', $destinationNumber );
			$url = "http://127.0.0.1:24002/cgi-bin/sendsms?username=ooMahng5mair&password=yahbooPh1gie&to=$destinationNumber&from=$originNumber&text=$messageText&dlr-mask=31&dlr-url=$deliveryURL";
		}
		
		//echo $url;
		$getRequest = $http->get ( $url );
		if ($getRequest >= 300 || $getRequest < 200) {
			$log->logError ( 'MessageSender->sendMessage() -> GET Request Failed with error code: ' . $getRequest . ' Http request: ' . $url );
			return false;
		} else {
			return true;
		}
		//http://content.lt:13002/cgi-bin/sendsms?username=ooMahng5mair&password=yahbooPh1gie&to=+37069825357&text=1aHello+world&dlr-mask=31&dlr-url=http://content.lt/~mindaugas/kannel/gaunam2.php?text=%25daa%25A
	}
	
	/**
	 *Siųstos žinutės statuso pakeitimas iš neapdorotos į apdorotą
	 *@param Integer $sendedSMSMessageID Siųstos sms žinutės iš informacinės sistemos identifikacnis numeris
	 *@return void Įterpiami gauto sms duomenys į duomenų bazę
	 */
	public function changeSendedSMSMessageStatus($sendedSMSMessageID) {
		$log = new Logging ( );
		$connect = new ConnectManager ( );
		$db = $connect->getConnect ();
		$query = $db->prepare ( 'update send_sms_billing set processed=true where id=?' );
		$data = array ($sendedSMSMessageID );
		$query_res = $db->execute ( $query, $data );
		if (PEAR::isError ( $query_res )) {
			$db->disconnect ();
			$log->logError ( 'MessageSender->changeSendedSMSMessageStatus() -> ' . $query_res->getDebugInfo () );
			die ( 'Kritinė klaida: MessageSender->changeSendedSMSMessageStatus()' );
		}
		$db->disconnect ();
	}
	
	/**
	 *Gautai žinutė nurodoma, kad jei išsiųstas atsakymas
	 *@param Integer $receivedMessageID Gautos žinutės identifikacinis numeris
	 *@return void Gautai žinutė nurodoma, kad jei išsiųstas atsakymas
	 */
	public function changeReceivedSMSMessageStatus($receivedMessageID) {
		
		//BEGIN SYSTEM
		$system = new System ( );
		$isSystem = $system->getSystemPar ( $receivedMessageID );
		if ($isSystem == 't') {
			$number = $system->getSystemOrginatingNumber ( 3 );
		}
		//END SYSTEM
		

		$log = new Logging ( );
		$connect = new ConnectManager ( );
		$db = $connect->getConnect ();
		
		//Nesisteminis
		if ($isSystem == 'f') {
			$query = $db->prepare ( 'update received_messages set processed_status=true where id=?' );
			$data = array ($receivedMessageID );
		} 
		else {
			
			$query = $db->prepare ( 'update received_messages set processed_status=true, senderphone=? where id=?' );
			$data = array ($number, $receivedMessageID );
		}
		//end sisteminis
		

		$query_res = $db->execute ( $query, $data );
		if (PEAR::isError ( $query_res )) {
			$db->disconnect ();
			$log->logError ( 'MessageSender->changeReceivedSMSMessageStatus() -> ' . $query_res->getDebugInfo () );
			die ( 'Kritinė klaida: MessageSender->changeReceivedSMSMessageStatus()' );
		}
		$db->disconnect ();
	}

}

//$a = new Customer();
//echo $a->checkVATCode('1as34d');


?>