<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

*Ratlankių informacijos valdymo klasė
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Wheel
{
	/**
	*Gražinamas visų skirtingų ratlankių diametrų masyvas
	*@return Array visų skirtingų ratlankių diametrų masyvas
	*/
	public function getAllWheelsDiameter()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct diameter from wheel where is_deleted=false order by diameter asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getAllWheelsDiameter()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų ratlankių gamintojų masyvas
	*@return Array visų ratlankių gamintojų masyvas
	*/
	public function getWheelsManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from wheel_manufacturer where id = any(select distinct wheel_manufacturer_id from wheel where is_deleted=false order by wheel_manufacturer_id) order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheelsManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų ratlankių gamintojų masyvas
	*@return Array visų ratlankių gamintojų masyvas
	*/
	public function getAllWheelsManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from wheel_manufacturer order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getAllWheelsManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*
	*Gražinamas ratlankių likutis
	*@param Integer $wheelID Ratlankio identifikacinis numeris
	*@return Integer 0 ir daugiau - ratlankio likutis
	*/
	public function getWheelBalance($wheelID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select balance from wheel where id='.$wheelID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheelBalance()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas ratlankių duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš wheel lentelės pagal pateiktas paieškos sąlygas
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo identifikacinis numeris
	*@param Integer $diameter Ratlankio diametras
	*@param numeric(7,2) $max_price Padangos kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array ratlankių duomenų masyvas
	*/

	public function getWheels($offset,$limit,$wheel_manufacturer_id,$diameter,$max_price,$user_discount)
	{
		//echo "$offset,$limit,$wheel_manufacturer_id,$diameter,$wheel_width,$max_price,$user_discount";
		if ($wheel_manufacturer_id+0 == 0) {
			$wheel_manufacturer_id = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select wheel.id, wheel_manufacturer_id, name, wheel_width, diameter, price_lt,min_price_lt, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(wheel_width,\'999999999999\')) like \''.$wheel_width.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' order by price limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select wheel.id, wheel_manufacturer_id, name, 0, diameter, price_lt,min_price_lt, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price, price_in_store,color,identification, design from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and wheel.id in (select min(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and color=1 group by identification) order by price limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getMessage();
			die('Kritinė klaida: Wheel->getWheels()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		//echo count($data);
		//echo "<pre>";
		//print_r($data);
		//echo "</pre>";
		for ($i = 0; $i < count($data); $i++) {
			$data[$i][] = $this->getWheelIdentificationGroup($data[$i][14]);
		}
		
		//echo "<pre>";
		//print_r($data);
		//echo "</pre>";
		return $data;
		
	}
	
	/**
	*Gražinamas akcijinių ratlankių duomenų masyvas
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo identifikacinis numeris
	*@param Integer $diameter Ratlankio diametras
	*@param numeric(7,2) $max_price Padangos kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array ratlankių duomenų masyvas
	*/

	public function getWheelsSales($wheel_manufacturer_id,$diameter,$max_price,$user_discount)
	{
		//echo "$offset,$limit,$wheel_manufacturer_id,$diameter,$wheel_width,$max_price,$user_discount";
		if ($wheel_manufacturer_id+0 == 0) {
			$wheel_manufacturer_id = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select wheel.id, wheel_manufacturer_id, name, wheel_width, diameter, price_lt,min_price_lt, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(wheel_width,\'999999999999\')) like \''.$wheel_width.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' order by price limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select wheel.id, wheel_manufacturer_id, name, 0, diameter, price_lt,min_price_lt, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price,price_in_store from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and status=2 order by price');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getMessage();
			die('Kritinė klaida: Wheel->getWheels()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas ratlankių kiekis pagal paieškos sąlygas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš wheel lentelės pagal pateiktas paieškos sąlygas
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo identifikacinis numeris
	*@param Integer $diameter Ratlankio diametras
	*@param numeric(7,2) $max_price Ratlankio kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array ratlankių kiekis pagal paieškos sąlygas
	*/

	public function getWheelsCount($offset,$limit,$wheel_manufacturer_id,$diameter,$max_price,$user_discount)
	{
		if ($wheel_manufacturer_id+0 == 0) {
			$wheel_manufacturer_id = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select count(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(wheel_width,\'999999999999\')) like \''.$wheel_width.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and wheel.id in (select min(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and color=1 group by identification)');
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheelsCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$res->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
		
	}

	/**
	*Gražinamas akcijinių ratlankių kiekis pagal paieškos sąlygas
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo identifikacinis numeris
	*@param Integer $diameter Ratlankio diametras
	*@param numeric(7,2) $max_price Padangos kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array ratlankių kiekis pagal paieškos sąlygas
	*/

	public function getWheelsCountSales($wheel_manufacturer_id,$diameter,$max_price,$user_discount)
	{
		if ($wheel_manufacturer_id+0 == 0) {
			$wheel_manufacturer_id = '%';
		}
		if ($diameter+0 == 0) {
			$diameter = '%';
		}
		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		//echo 'select count(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(wheel_width,\'999999999999\')) like \''.$wheel_width.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(wheel.id) from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.is_deleted=false and trim(to_char(wheel_manufacturer_id,\'999999999999\')) like \''.$wheel_manufacturer_id.'\' and trim(to_char(diameter,\'999999999999\')) like \''.$diameter.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and status=2');
		if (PEAR::isError($res)) {
			//echo $res->getMessage();
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheelsCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$res->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
		
	}
	
	/**
	*
	*
	*Gražinama maksimali prekės (ratlankio) kaina
	*@return Integer 0 ir daugiau - maksimali prekės kaina
	*/
	public function getTopPrice()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select max(price_lt) from wheel where is_deleted=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getTopPrice()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0]+0;
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Gražinamas unikalus keturių ratlankių spalvų surišimo numeris
	*@return Integer unikalus keturių ratlankių spalvų surišimo numeris
	*/
	public function getIdentificationNumber()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select max(identification) from wheel');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getIdentificationNumber()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0]+1;
		} else {
			return 0;
		}
	}
	
	
	/**
	*Gražinamas pasirinkto ratlankio duomenų masyvas
	*@param Integer $wheelID Ratlankio identifikacinis numeris
	*@return Array ratlankio duomenų masyvas
	*/

	public function getWheel($wheelID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select wheel.id, wheel_manufacturer_id, name, diameter, 0, color, balance, price_lt,min_price_lt, \'\', \'\', \'\', big_photo_path, discount_flag, status, balance,small_photo_path,price_in_store,design from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.id='.$wheelID);
		if (PEAR::isError($res)) {
			//echo $res->getMessage();
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheel()');
		}
		$res->fetchInto($selectedWheel);
		$db->disconnect();
		return $selectedWheel;
	}
	
	/**
	*Ratlankio pašalinimas
	*
	*@param Integer $identification Ratlankio grupės identifikacinis numeris
	*@return void
	*/
	public function removeWheel($identification)
	{
		$wheel = $this->getWheelByIdentificationID($identification,1);
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from wheel where identification='.$identification);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->removeTyre()');
		}
		$db->disconnect();
		
		
		$big_photo_path = $wheel[8];
		$small_photo_path = $wheel[12];
		
		unlink ($big_photo_path);
		unlink ($small_photo_path);
	}
	
	/**
	*Atnaujinami ratlankio duomenys
	*@param Integer $identification 4 ratlankių spalvų identifikacinė grupė
	*@param Integer $color Ratlankio spalva
	*@param String $design Ratlankio dizainas
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo ID
	*@param Integer $diameter Ratlankio diametras
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali padangos kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Integer $status Statusas
	*/
	public function updateWheel($identification,$color,$design,$wheel_manufacturer_id,$diameter,$balance,$price_lt,$min_price_lt,$price_in_store,$big_photo_path,$small_photo_path,$discount_flag,$status)
	{
		//echo "$id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update wheel set wheel_manufacturer_id=?,diameter=?,balance=?,price_lt=?,min_price_lt=?,price_in_store=?,big_photo_path=?,small_photo_path=?,discount_flag=?,status=?, design=? where identification=? and color=?');
		$data = array($wheel_manufacturer_id,$diameter,$balance,$price_lt,$min_price_lt,$price_in_store,$big_photo_path,$small_photo_path,$discount_flag,$status,$design,$identification,$color);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getDebugInfo();
			die('Kritinė klaida: Wheel->updateWheel()');
		}
		$db->disconnect();
	}
	
	
	/**
	*Ratlankio įterpimas į duomenų bazę
	*@param Integer $wheel_manufacturer_id Ratlankio gamintojo ID
	*@param Integer $diameter Ratlankio diametras
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali padangos kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Integer $status Statusas
	*@param Integer $color Ratlankio spalva 1 - Sidabrinė, 2 - Spindinti, 3 - Tamsi-spindinti, 4 - Chromo
	*@param Integer $identification Integer 4ioms ratlankio spalvoms bendras identifikacinis numeris
	*@param String $design Ratlankio dizainas
	*/
	public function insertWheel($wheel_manufacturer_id,$diameter,$balance,$price_lt,$min_price_lt,$price_in_store,$big_photo_path,$small_photo_path,$discount_flag,$status,$color,$identification,$design)
	{
		//echo "$wheel_manufacturer_id,$wheel_width,$diameter,$pcd,$balance,$price_lt,$min_price_lt,$price_in_store,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into wheel (wheel_manufacturer_id,diameter,balance,price_lt,min_price_lt,price_in_store,big_photo_path,small_photo_path,discount_flag,status,color,identification,design) values (?,?,?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($wheel_manufacturer_id,$diameter,$balance,$price_lt,$min_price_lt,$price_in_store,$big_photo_path,$small_photo_path,$discount_flag,$status,$color,$identification,$design);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			echo $query_res->getDebugInfo();
			die('Kritinė klaida: Wheel->insertWheel()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Skaičiaus tikrinimas
	*@param String $digit Skaičius
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function isDigit($digit)
	{
		$digit = trim($digit);
		if (strlen($digit) == 0) return false; 
		
		if (preg_match("/[^\d]/",$digit)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Skaičiaus po kablelio tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Gražinamas visų ratlankių masyvas priklausantis identifikacinai grupei
	*@param Integer $identification Identifikacinė grupė
	*@return Array visų ratlankių masyvas priklausantis identifikacinai grupei
	*/
	public function getWheelIdentificationGroup($identification)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id, price_lt, min_price_lt, price_in_store,discount_flag,color,identification from wheel where identification='.$identification.' and color<>1 and is_deleted=false order by color');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Wheel->getWheelIdentificationGroup()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*
	*Gražinama identifikacinė keturių padangų identifikacinė grupė
	*@return Integer $wheelID Padangos identifikacinis numeris
	*/
	public function getIdentification($wheelID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select identification from wheel where id='.$wheelID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Wheel->getIdentification()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0]+0;
		
	}
	
	/**
	*Gražinamas pasirinkto ratlankio duomenų masyvas
	*@param Integer $identificationID identifikacinė keturių padangų identifikacinė grupė
	*@param Integer $color Ratlankio spalva 1 - Sidabrinė, 2 - Spindinti, 3 - Tamsi-spindinti, 4 - Chromo
	*@return Array ratlankio duomenų masyvas
	*/

	public function getWheelByIdentificationID($identificationID,$color)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select wheel.id, wheel_manufacturer_id, name, diameter, color, balance, price_lt,min_price_lt, big_photo_path, discount_flag, status, balance,small_photo_path,price_in_store,design from wheel,wheel_manufacturer where wheel_manufacturer.id=wheel.wheel_manufacturer_id and wheel.identification='.$identificationID.' and color='.$color);
		if (PEAR::isError($res)) {
			//echo $res->getMessage();
			$db->disconnect();
			die('Kritinė klaida: Wheel->getWheelByIdentificationID()');
		}
		$res->fetchInto($selectedWheel);
		$db->disconnect();
		return $selectedWheel;
	}
	
}
?>