<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');

/**
* Prijungiama DeliverMessagesToThirdParties.class.php realizuotas ryšys su klientų informacinėmis sistemomis
*/
require_once('DeliverMessagesToThirdParties.class.php');

/**

* Šioje klasėje realizuotos išsiųstų sms reportų apdorojimas
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class DeliveryReports
{
	/**
	*Apdorojamas gautas SMS delivery reportas, atrenkami duomenys ir įrašomi į duomenų bazę
	*@param Integer $clientid - Žinutės identifikacinis numeris, kurios reportas buvo gautas
	*@param Integer $identification - Delivery reporto identifikatorius (1 - automatinė sistema 2 - paprastai siųstas SMS)
	*@param Integer $status - delivery reporto statusas:
	*    1: delivery success
    *    2: delivery failure
    *    4: message buffered
    *    8: smsc submit
    *    16: smsc reject
	*@param String $status_string Statuso aprašymas
	*@return void Įterpiami gauto sms duomenys į duomenų bazę
	*/
	public function processDeliveryReport($clientid,$identification,$status,$status_string)
	{
		if ($status == 1) {
			$status = 16777216;
		}
		$log = new Logging();
		$deliver = new DeliverMessagesToThirdParties();
		if ($identification == 1) {
			if ($this->checkMessageProccessing($clientid) == true) {
				$this->updateMessageProcessing($clientid,$status,$status_string);
			} else {
				$this->insertMessageProcessing($clientid,$status,$status_string);
			}
			$deliver->deliverDeliveryReportToCustomerIS($clientid,$status,$status_string);
		} elseif ($identification == 2) {
			if ($this->checkMessageProccessingSMS($clientid) == true) {
				$this->updateMessageProcessingSMS($clientid,$status,$status_string);
			} else {
				$this->insertMessageProcessingSMS($clientid,$status,$status_string);
			}
		}
		
	}

	/**
	*Tikrinama ar žinutė yra bent vieną kartą apdorota
	*@param Integer $receivedMessageID Gautos žinutės identifikacinis numeris
	*@return Boolean t - žinutė yra bent kartą apdorota, f - žinutė dar nebuvo apdorota
	*/
	public function checkMessageProccessing($receivedMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id from message_processing where received_message_id='.$receivedMessageID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('DeliveryReports->checkMessageProccessing() -> '.$result->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->checkMessageProccessing()');
		}
		$db->disconnect();

		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Tikrinama ar SMS tipo žinutė yra bent vieną kartą apdorota
	*@param Integer $receivedMessageID Gautos žinutės identifikacinis numeris
	*@return Boolean t - žinutė yra bent kartą apdorota, f - žinutė dar nebuvo apdorota
	*/
	public function checkMessageProccessingSMS($receivedMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id from sms_sent_message_processing where sent_message_id='.$receivedMessageID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('DeliveryReports->checkMessageProccessingSMS() -> '.$result->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->checkMessageProccessingSMS()');
		}
		$db->disconnect();

		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	
	/**
	*Apdoroto automatinės sistemos delivery reporto reiškmių atnaujinimas
	*@param Integer $clientid - Žinutės identifikacinis numeris, kurios reportas buvo gautas
	*@param Integer $status - delivery reporto statusas:
	*    1: delivery success
    *    2: delivery failure
    *    4: message buffered
    *    8: smsc submit
    *    16: smsc reject
	*@param String $status_string Statuso aprašymas
	*@return void Apdoroto automatinės sistemos delivery reporto reiškmių atnaujinimas
	*/
	public function updateMessageProcessing($clientid,$status,$status_string)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update message_processing set status=?,status_string=? where received_message_id=?');
		$data = array($status,$status_string,$clientid);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('DeliveryReports->updateMessageProcessing() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->updateMessageProcessing()');
		}
		$db->disconnect();
	}

	/**
	*Apdoroto automatinės sistemos delivery reporto reiškmių iterpimas į DB
	*@param Integer $clientid - Žinutės identifikacinis numeris, kurios reportas buvo gautas
	*@param Integer $status - delivery reporto statusas:
	*    1: delivery success
    *    2: delivery failure
    *    4: message buffered
    *    8: smsc submit
    *    16: smsc reject
	*@param String $status_string Statuso aprašymas
	*@return void Apdoroto automatinės sistemos delivery reporto reiškmių iterpimas į DB
	*/
	public function insertMessageProcessing($clientid,$status,$status_string)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into message_processing (received_message_id,status,status_string) values (?,?,?)');
		$data = array($clientid,$status,$status_string);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('DeliveryReports->insertMessageProcessing() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->insertMessageProcessing()');
		}
		$db->disconnect();
	}
	
	/**
	*Paprastai siųsto sms delivery reporto reiškmių atnaujinimas
	*@param Integer $clientid - Žinutės identifikacinis numeris, kurios reportas buvo gautas
	*@param Integer $status - delivery reporto statusas:
	*    1: delivery success
    *    2: delivery failure
    *    4: message buffered
    *    8: smsc submit
    *    16: smsc reject
	*@param String $status_string Statuso aprašymas
	*@return void Paprastai siųsto sms delivery reporto reiškmių atnaujinimas
	*/
	public function updateMessageProcessingSMS($clientid,$status,$status_string)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update sms_sent_message_processing set status=?,status_string=? where sent_message_id=?');
		$data = array($status,$status_string,$clientid);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('DeliveryReports->updateMessageProcessingSMS() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->updateMessageProcessingSMS()');
		}
		$db->disconnect();
	}
	
	/**
	*Paprastai siųsto sms delivery reporto reiškmių iterpimas į DB
	*@param Integer $clientid - Žinutės identifikacinis numeris, kurios reportas buvo gautas
	*@param Integer $status - delivery reporto statusas:
	*    1: delivery success
    *    2: delivery failure
    *    4: message buffered
    *    8: smsc submit
    *    16: smsc reject
	*@param String $status_string Statuso aprašymas
	*@return void Paprastai siųsto sms delivery reporto reiškmių iterpimas į DB
	*/
	public function insertMessageProcessingSMS($clientid,$status,$status_string)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into sms_sent_message_processing (sent_message_id,status,status_string) values (?,?,?)');
		$data = array($clientid,$status,$status_string);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('DeliveryReports->insertMessageProcessing() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: DeliveryReports->insertMessageProcessing()');
		}
		$db->disconnect();
	}
	
}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>