<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');

/**
* Prijungiama Customer.class.php klientų duomenų valdymo klasė
*/
require_once('Customer.class.php');

/**
* Prijungiama HTTP/Client.php PEAR klasių rinkinio HTTP request'ų valdymo klasė
*/
require_once 'HTTP/Client.php';

/**

* Šioje klasėje realizuotas ryšys su klientų informacinėmis sistemomis
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class DeliverMessagesToThirdParties
{
	
	/**
	*
	*HTTP/GET užklausos siuntimas
	*@param String $url URL adresas kurio bus atlikta HTTP GET užklausa
	*@return void HTTP/GET užklausos siuntimas
	*/
	public function sendHTTPGetRequest($url)
	{
		$log = new Logging();
		$http = new HTTP_Client();
		$getRequest = $http->get($url);
		//echo $getRequest;
		if ($getRequest >= 300 || $getRequest < 200) {
			$log->logError('DeliverMessagesToThirdParties->sendHTTPGetRequest() -> GET Request Failed with error code: '.$getRequest.' Http request: '.$url);
		}
	}
	
	/**
	 *Gauta žinutė perduodama trečios šalies informacinei sistemai, jei yra aktyvuotas IS
	 * 
	 *@param String $receivedMessageID Gautos žinutės identifikacinis numeris
	 *@param Integer $messageText gautos žinutės tekstas
	 *@param Integer $networkID GSM operatoriaus identifikacinis numeris (1 - Omnitel; 2 - Bite; 3 - Tele2) 
	 *@param String $phoneNumber Telefono numeris
	 */
	public function deliverMessageToCustomerIS($receivedMessageID,$messageText,$networkID,$phoneNumber) {
		$customer = new Customer();
		
		$keywords = preg_split("/[\s]+/", trim($messageText));
		if (count($keywords) >= 1) {
			$firstMessageWord = $keywords[0];
			$customerID = $customer->getCustomerID($firstMessageWord);
			$isAccessAllowed = $customer->checkGSMAccess($customerID,2);
			$isURLEnabled = $customer->checkCustomerISURL($customerID);
			if ($customerID > 0 && $isAccessAllowed == true && $isURLEnabled == true) {
				$customerISURL = $customer->getCustomerISURL($customerID);
				$messageText = urlencode($messageText);
				$phoneNumber = urlencode($phoneNumber);
				$formedURL = $customerISURL."?received_message_id=".$receivedMessageID."&message=".$messageText."&operator=".$networkID."&phone=".$phoneNumber;
				$this->sendHTTPGetRequest($formedURL);
				//echo 'Access granted';
				
			}
		}
	}
	
	/**
	 *Gautas žinutės siuntimo reportas perduodamas trečios šalies informacinei sistemai, jei yra aktyvuotas IS
	 * 
	 *@param String $receivedMessageID Gautos žinutės identifikacinis numeris
	 *@param Integer $status - delivery reporto statusas:
	 *    1: delivery success
     *    2: delivery failure
     *    4: message buffered
     *    8: smsc submit
     *    16: smsc reject
	 *@param String $status_string Statuso aprašymas
	*/
	public function deliverDeliveryReportToCustomerIS($receivedMessageID,$status,$status_string) {
		$customer = new Customer();
		$customerID = $customer->getCustomerIDByReceiveMessageID($receivedMessageID);
		$isAccessAllowed = $customer->checkGSMAccess($customerID,2);
		$isURLEnabled = $customer->checkCustomerISURL($customerID);
		if ($customerID > 0 && $isAccessAllowed == true && $isURLEnabled == true) {
			$customerISURL = $customer->getCustomerISURL($customerID);
			$receivedMessageID = urlencode($receivedMessageID);
			$status = urlencode($status);
			$status_string = urlencode($status_string);
			
			$formedURL = $customerISURL."?received_message_id=".$receivedMessageID."&status=".$status."&status_string=".$status_string;
			$this->sendHTTPGetRequest($formedURL);
		}
	}
}
		

?>