<?php
/**
 * @version	1.5
 * @package	Module: Content Plugins
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/**
 * 
 * @return 
 */
class modContentPluginsHelper {

	/**
	 * Render Module
	 *
	 * @access public
	 * @return mixed Parameter value
	 * @since 1.5
	 */
	function _renderModule( $params ) 
	{
		$html = '';
		$html = modContentPluginsHelper::_displayArticle( $params );
		return $html;
	}

	/**
	 * 
	 * @return unknown_type
	 */
	function _displayArticle( $params )
	{
		$html = '';
		
		$articleid = $params->get('articleid');
		if ($articleid)
		{
			global $mainframe;
			$dispatcher	   =& JDispatcher::getInstance();
			
			$article =& JTable::getInstance('content');
			$article->load( $articleid );
			$article->text = $article->introtext . chr(13).chr(13) . $article->fulltext;

			$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
			$cparams		=& $mainframe->getParams('com_content');
			$aparams	=& $article->parameters;
			$cparams->merge($aparams);

			// Fire Content plugins on the article so they change their tags
			/*
			 * Process the prepare content plugins
			 */
				JPluginHelper::importPlugin('content');
				$results = $dispatcher->trigger('onPrepareContent', array (& $article, & $cparams, $limitstart));

			/*
			 * Handle display events
			 */
				$article->event = new stdClass();
				$results = $dispatcher->trigger('onAfterDisplayTitle', array ($article, &$cparams, $limitstart));
				$article->event->afterDisplayTitle = trim(implode("\n", $results));
		
				$results = $dispatcher->trigger('onBeforeDisplayContent', array (& $article, & $cparams, $limitstart));
				$article->event->beforeDisplayContent = trim(implode("\n", $results));
		
				$results = $dispatcher->trigger('onAfterDisplayContent', array (& $article, & $cparams, $limitstart));
				$article->event->afterDisplayContent = trim(implode("\n", $results));

			// Use param for displaying article title
			if ($params->get( 'display_article_title', '0' )) {
				$html .= "<h3>{$article->title}</h3>";
			}				
				$html .= $article->event->afterDisplayTitle;
				$html .= $article->event->beforeDisplayContent;
				$html .= $article->text;
				$html .= $article->event->afterDisplayContent;
		}
		
		return $html;
	}
}