<?php
/**
* @version $Id: index2.php 6022 2006-12-18 22:30:07Z friesengeist $
* @package Joomla
* @copyright Copyright (C) 2005 Open Source Matters. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/
if (!defined ('_VALID_MOS')) {
	define( '_VALID_MOS', 1 );

	// Set flag that this is a parent file
	header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );  // disable IE caching
	header( "Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . " GMT" );
	header( "Cache-Control: no-cache, must-revalidate" );
	header( "Pragma: no-cache" );

	chdir ('../../');

	require( 'globals.php' );
	require_once( 'configuration.php' );

	$splitter = md5("JA Flashnews");
	// SSL check - $http_host returns <live site url>:<port number if it is 443>
	$http_host = explode(':', $_SERVER['HTTP_HOST'] );
	if( (!empty( $_SERVER['HTTPS'] ) && strtolower( $_SERVER['HTTPS'] ) != 'off' || isset( $http_host[1] ) && $http_host[1] == 443) && substr( $mosConfig_live_site, 0, 8 ) != 'https://' ) {
		$mosConfig_live_site = 'https://'.substr( $mosConfig_live_site, 7 );
	}

	require_once( 'includes/joomla.php' );

	// displays offline/maintanance page or bar
	if ($mosConfig_offline == 1) {
		require( $mosConfig_absolute_path .'/offline.php' );
	}

	// load system bot group
	$_MAMBOTS->loadBotGroup( 'system' );

	// trigger the onStart events
	$_MAMBOTS->trigger( 'onStart' );

	require_once( $mosConfig_absolute_path .'/includes/sef.php' );
	require_once( $mosConfig_absolute_path .'/includes/frontend.php' );

	// retrieve some expected url (or form) arguments
	$news 	= intval( mosGetParam( $_REQUEST, 'news' , 0) ) ;
	$total 	= intval( mosGetParam( $_REQUEST, 'total', 0 ) );
	$option = strval( strtolower( mosGetParam( $_REQUEST, 'option' ) ) );

	// mainframe is an API workhorse, lots of 'core' interaction routines
	$mainframe = new mosMainFrame( $database, $option, '.' );
	$mainframe->initSession();

	// trigger the onAfterStart events
	$_MAMBOTS->trigger( 'onAfterStart' );

	// get the information about the current user from the sessions table
	$my = $mainframe->getUser();
	// patch to lessen the impact on templates
	if ($option == 'search') {
		$option = 'com_search';
	}

	// loads english language file by default
	if ($mosConfig_lang=='') {
		$mosConfig_lang = 'english';
	}
	include_once( $mosConfig_absolute_path .'/language/' . $mosConfig_lang . '.php' );


	if ($option == 'login') {
		$mainframe->login();
		mosRedirect('index.php');
	} else if ($option == 'logout') {
		$mainframe->logout();
		mosRedirect( 'index.php' );
	}

	// detect first visit
	$mainframe->detect();

	// precapture the output of the component
	require_once( $mosConfig_absolute_path . '/editor/editor.php' );

	ob_start();

	$_MOS_OPTION['buffer'] = ob_get_contents();

	ob_end_clean();

	$charset = array(
	   "CHARSET=ISO-8859-1" => "ISO8859-1",
	   "CHARSET=ISO8859-1" => "ISO8859-1",
	   "CHARSET=ISO-8859-15" => "ISO8859-15",
	   "CHARSET=ISO8859-15" => "ISO8859-15",
	   "CHARSET=UTF-8" => "UTF-8",
	   "CHARSET=CP866" => "ibm866",
	   "CHARSET=866" => "ibm866",
	   "CHARSET=IBM866" => "ibm866",
	   "CHARSET=CP1251" => "Windows-1251",
	   "CHARSET=WINDOWS-1251" => "Windows-1251",
	   "CHARSET=WIN-1251" => "Windows-1251",
	   "CHARSET=1251" => "Windows-1251",
	   "CHARSET=CP1252" => "Windows-1252",
	   "CHARSET=WINDOWS-1252" => "Windows-1252",
	   "CHARSET=1252" => "Windows-1252",
	   "CHARSET=KOI8-R" => "koi8-ru",
	   "CHARSET=KOI8-RU" => "koi8-ru",
	   "CHARSET=KOI8R" => "koi8-ru",
	   "CHARSET=BIG5" => "950",
	   "CHARSET=950" => "950",
	   "CHARSET=GB2312" => "936",
	   "CHARSET=936" => "936",
	   "CHARSET=BIG5-HKSCS" => "BIG5-HKSCS",
	   "CHARSET=SHIFT_JIS" => "SJIS",
	   "CHARSET=SJIS" => "SJIS",
	   "CHARSET=932" => "SJIS",
	   "CHARSET=EUC-JP" => "EUCJP",
	   "CHARSET=EUCJP" => "EUCJP"
	);

	$current_charset = isset($charset[strtoupper(_ISO)]) ? $charset[strtoupper(_ISO)] : "ISO8859-1";

	$my = $mainframe->getUser();
	$gid = intval( $my->gid );
	$db = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

	$query = "SELECT params FROM #__modules WHERE module = 'mod_janewsflash';";
	$database->setQuery($query);
	$params = $database->loadResult();
	$params = new mosParameters ($params);

	function textprocess($string) {
		global $current_charset;
		if ($current_charset == "UTF-8") return $string;
		else if (function_exists("iconv")) return iconv(str_replace("CHARSET=", "", strtoupper(_ISO)), "UTF-8", $string);
		else if ($current_charset) {
			$trans_tbl = array("&lt;" => "<", "&gt;" => ">", "&amp;" => "&");
			return strtr(htmlentities($string, ENT_NOQUOTES, $current_charset), $trans_tbl);
		} else return $string;
	}

} else {
	global $mainframe;
	global $my, $mosConfig_shownoauth, $mosConfig_offset, $mosConfig_link_titles, $acl, $mosConfig_absolute_path, $delaytime;
	$splitter = "";
	function textprocess($string) {
		return $string;
	}
}

if (!defined( '_JA_NEWSFLASH' )) {
	/** ensure that functions are declared only once */
	define( '_JA_NEWSFLASH', 1 );

	function ja_output_newsflash( &$row, &$params, &$access ) {
		global $mainframe, $_MAMBOTS;

		$row->text 		= $row->introtext;
		$row->groups 	= '';
		$row->readmore 	= (trim( $row->fulltext ) != '') && ($params->get( 'readmore' ));
		$row->metadesc 	= '';
		$row->metakey 	= '';
		$row->access 	= '';
		$row->created 	= '';
		$row->modified 	= '';

		$params->set('image', 1);
		
		$_MAMBOTS->loadBotGroup( 'content' );
		$results = $_MAMBOTS->trigger( 'onPrepareContent', array( &$row, &$params, null ), true );
		
		$html = "";
		ja_linkInfo ($row, $params);
		
		if ($params->get('link_titles')) $newTitle .= "<a href=\"".$row->link_on."\" title=\"".$row->title."\">".$row->title."</a>";
		else $newTitle .= "".$row->title."";
		
		//Get image
		$regex = "/\<img.*\/\>/";
		
		preg_match ($regex, $row->text, $matches);
		$row->text = preg_replace ($regex, '', $row->text);
		
		$newReadmore 	=	"<a href=\"".$row->link_on."\" title=\"".$row->link_text."\">".$row->link_text."</a>";
		$html = str_replace("##TITLE##",$newTitle,$params->get("templates"));
		$html = str_replace("##CONTENT##",$row->text,$html);
		$img = count($matches)?$matches[0]:"";
		$html = str_replace("##IMAGE##", $img, $html);
		$html =	str_replace("##READMORE##",$newReadmore,$html);
		echo $html;
	}

	function ja_linkInfo( &$row, &$params ) {
		global $my;

		$row->link_on 	= '';
		$row->link_text	= '';

		if ($params->get( 'readmore' ) || $params->get( 'link_titles' )) {
			if ( $params->get( 'intro_only' ) ) {
				// checks if the item is a public or registered/special item
				if ( $row->access <= $my->gid ) {
					$row->link_on = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id=' . $row->id . $row->Itemid_link );

					if ( isset($row->readmore) && @$row->readmore) {
						// text for the readmore link
						$row->link_text = _READ_MORE;
					}
				} else {
					$row->link_on = sefRelToAbs( 'index.php?option=com_registration&amp;task=register' );

					if ( isset($row->readmore) && @$row->readmore ) {
						// text for the readmore link if accessible only if registered
						$row->link_text	= _READ_MORE_REGISTER;
					}
				}
			}
		}
	}
}

require_once( $mainframe->getPath( 'front_html', 'com_content') );

// Disable edit ability icon
$access = new stdClass();
$access->canEdit 	= 0;
$access->canEditOwn = 0;
$access->canPublish = 0;

$now 				= _CURRENT_SERVER_TIME;
$noauth 			= !$mainframe->getCfg( 'shownoauth' );
$nullDate 			= $database->getNullDate();

$catid 				= intval( $params->get( 'catid' ) );
$delaytime 		= intval( $params->get( 'delaytime', 0 ) );
$moduleclass_sfx    = $params->get( 'moduleclass_sfx' );
$link_titles		= $params->get( 'link_titles', $mosConfig_link_titles );

$params->set( 'intro_only', 		1 );
$params->set( 'hide_author', 		1 );
$params->set( 'hide_createdate', 	0 );
$params->set( 'hide_modifydate', 	1 );
$params->set( 'link_titles', 		$link_titles );

// query to determine article count
$query = "SELECT a.id, a.introtext, a.fulltext , a.images, a.attribs, a.title, a.state"
."\n FROM #__content AS a"
."\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
."\n INNER JOIN #__sections AS s ON s.id = a.sectionid"
."\n WHERE a.state = 1"
. ( $noauth ? "\n AND a.access <= " . (int) $my->gid . " AND cc.access <= " . (int) $my->gid . " AND s.access <= " . (int) $my->gid : '' )
."\n AND (a.publish_up = " . $database->Quote( $nullDate ) . " OR a.publish_up <= " . $database->Quote( $now ) . " ) "
."\n AND (a.publish_down = " . $database->Quote( $nullDate ) . " OR a.publish_down >= " . $database->Quote( $now ) . " )"
."\n AND a.catid = " . (int) $catid
."\n AND cc.published = 1"
."\n AND s.published = 1"
."\n ORDER BY a.ordering"
;

$database->setQuery( $query, 0, $items );
$rows = $database->loadObjectList();

$numrows = count( $rows );

// check if any results returned
if ( $numrows ) {
	$curnews = intval( mosGetParam( $_REQUEST, 'curnews' ) );

	srand ((double) microtime() * 1000000);
	while (true) {
		$flashnum = rand( 0, $numrows-1 );
		if ($flashnum != $curnews) break;
	}
	$row = $rows[$flashnum];
}

$Itemid = $mainframe->getItemid( $firstnew->id, 0, 0, 1, 1, 1 );

$row->introtext = textprocess($row->introtext);
$row->fulltext = textprocess($row->fulltext);
$xheight = $params->get('xheight');

if (!mosGetParam($_GET,'loadajax',0)) {

?>
	<script type="text/javascript">
	if (!self.jaNewsflash) {
		jaNewsflash = new Object();
	}
		jaNewsflash.animation = '<?php echo $params->get('animation'); ?>';
		jaNewsflash.livesite = '<?php echo $mosConfig_live_site; ?>';
		jaNewsflash.delaytime = <?php echo $delaytime; ?>;	
		jaNewsflash.splitter = "97c8730aa693f60439cf3cf4558ce5ea";
		jaNewsflash.interval= <?php echo $params->get('animationtime'); ?>; 
		jaNewsflash.currentItem = <?php echo $flashnum;?>;	
	</script>
	<div style="position:relative; width:100%;height:<?php echo $xheight; ?>px; overflow:hidden;">
		<div id="ja-scoll_1" style="position:absolute; top:0;  left:0; width: 100%; display:block;">
	<?php
		echo  ja_output_newsflash( $row, $params, $access );
	?>
		</div>
		<div id="ja-scoll_2" style="position: absolute; top:0; left:0; width: 100%; display:none;">
		</div>
	</div>	
	<?php
}
else{
	echo  ja_output_newsflash( $row, $params, $access );
	echo $splitter.$flashnum;
}
?>
