<?php
/**
*Menu valdymas
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Straipsnių valdymas
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Menu
{
	/**
	*Gražinamas visų menu grupių masyvas
	*@param String $search paieškos sąlyga
	*@return Array visų menu grupių masyvas asociatyvus masyvas
	*/
	public function getMenuGroups($search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,name,is_deleted,order_id,published from menu_group where is_deleted=false and lower(name) like \'%'.$search.'%\' order by order_id desc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenuGroups()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų menu grupių masyvas, kuriuose yra patiekalų ir anonimams leidžiama žiūrėti
	*@param String $search paieškos sąlyga
	*@return Array visų menu grupių masyvas asociatyvus masyvas
	*/
	public function getMenuGroupsAnonymous($search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select menu_group.id,menu_group.name,menu_group.is_deleted,menu_group.order_id,menu_group.published,menu_group.name_en from menu_group,menu where menu_group.id=menu.menu_group_id and menu.is_deleted=false and menu.view_not_registred=true and menu_group.is_deleted=false and lower(menu_group.name) like \'%'.$search.'%\' order by menu_group.order_id desc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenuGroups()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų menu grupių masyvas, kuriuose yra patiekalų ir leidžiama žiūrėti
	*@param String $search paieškos sąlyga
	*@return Array visų menu grupių masyvas asociatyvus masyvas
	*/
	public function getMenuGroupsRegistred($search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select menu_group.id,menu_group.name,menu_group.is_deleted,menu_group.order_id,menu_group.published,menu_group.name_en from menu_group,menu where menu_group.id=menu.menu_group_id and menu.is_deleted=false and menu_group.is_deleted=false and lower(menu_group.name) like \'%'.$search.'%\' order by menu_group.order_id desc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenuGroups()');
		}
		$db->disconnect();
		return $data;
	}
	

	
	/**
	*Pakeičiamas menu grupės publikavimo statusas
	*@param Integer $menu_group_id Menu grupės identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateMenuGrupsPublication($menu_group_id,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu_group set published=? where id=?');
		$data = array($pubStatus,$menu_group_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuGrupsPublication()');
		}
		$db->disconnect();
	}
	
	/**
	*Gražinamas pasirinktos menu grupės išsidėstymo pozicijos
	*@return Array pasirinktos pozicijos
	*/
	public function getMenuGroupsPositions()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select max(order_id),min(order_id) from menu_group where is_deleted=false');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->getMenuGroupsPositions()');
		}
		$res->fetchInto($positions);
		$db->disconnect();
		return $positions;
	}
	
	/**
	*Pakeičiama menu grupės pozicija
	*@param Integer $menu_group_id Menu grupės identifikacinis numeris
	*@param Integer $position_id Einamosios pozicijos identifikacinis numeris
	*@param String $direction Pozicija kur keisti kryptį
	*/
	public function updateMenuGrupsPositions($menu_group_id,$position_id,$direction)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($direction == 'up') {
			$res = $db->query('select id,order_id from menu_group where is_deleted=false and order_id>'.$position_id.' order by order_id asc  limit 1');
		}
		if ($direction == 'down') {
			$res = $db->query('select id,order_id from menu_group where is_deleted=false and order_id<'.$position_id.' order by order_id desc limit 1');
		}		
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->updateMenuGrupsPositions()');
		}
		
		$res->fetchInto($oldPosition);

		//Is kurio perkeliama atnaujinamas
		$query = $db->prepare('update menu_group set order_id=? where id=?');
		$data = array($position_id,$oldPosition[0]);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuGrupsPositions()');
		}
		
		//Kuris buvo keiciamas atnaujinamas
		$query = $db->prepare('update menu_group set order_id=? where id=?');
		$data = array($oldPosition[1],$menu_group_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuGrupsPositions()');
		}
				
		$db->disconnect();
	}
	
	/**
	*
	*Ištrinamos menu grupės
	*@param Integer ARRAY $menuGroupsIDS meniu grupių identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeMenuGroups($menuGroupsIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($menuGroupsIDS); $i++) {
			if ($i != count($menuGroupsIDS) - 1) {
				$whereClause .= 'id='.$menuGroupsIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$menuGroupsIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from menu_group where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->removeMenuGroups()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*Sukuriama patiekalų grupė
	*@param String $name Lietuviškas patiekalų grupės pavadinimas
	*@param String $name_en Angliškas patiekalų grupės pavadinimas
	*@param String $name_ru Rusiškas patiekalų grupės pavadinimas
	*@param bool $published Ar publikuoti: true - publikuoti; false - nepublikuoti;
	*/
	public function insertMenuGroup($name,$name_en,$name_ru,$published)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into menu_group (name,name_en,name_ru,published) values (?,?,?,?)');
		$data = array($name,$name_en,$name_ru,$published);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->insertMenuinsertMenuGroup()');
		}

		$db->disconnect();
	}
	
	/**
	*Atnaujinama patiekalų grupė
	*@param Integer $menuGroupID atnaujinamos kategorijos identifikacinis numeris
	*@param String $name Patiekalų grupės pavadinimas lietuviškai
	*@param String $name_en Patiekalų grupės pavadinimas angliškai
	*@param String $name_ru Patiekalų grupės pavadinimas rusiškai
	*@param bool $published Ar publikuoti: true - publikuoti; false - nepublikuoti;
	*/
	public function updateMenuGroup($menuGroupID,$name,$name_en,$name_ru,$published)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu_group set name=?,name_en=?,name_ru=?,published=? where id=?');
		$data = array($name,$name_en,$name_ru,$published,$menuGroupID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuGroup()');
		}

		$db->disconnect();
	}
	
	/**
	*Gražinamas pasirinktos menu grupės duomenys
	*@param Integer $menuGroupID
	*@return Array pasirinktos menu grupės duomenys
	*/
	public function getMenuGroupsData($menuGroupID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id,name,is_deleted,order_id,published,name_en,name_ru from menu_group where id='.$menuGroupID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->getMenuGroupsData()');
		}
		$res->fetchInto($menuGroup);
		$db->disconnect();
		return $menuGroup;
	}
	
	
	//Menu prasideda metodai
	
	/**
	*Gražinamas visų menu masyvas
	*@param String $search paieškos sąlyga
	*@param Integer $menuGroupID menu grupės identifikacinis numeris (Jie 0 tuomet rodyti visų kategorijų menu)
	*@return Array visų menu asociatyvus masyvas
	*/
	public function getMenus($menuGroupID,$search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($menuGroupID != 0) {
			$data = $db->getAssoc('select menu.id,menu.dish,menu.price, menu.order_id,menu_group.name,menu.published,menu.view_not_registred,menu.menu_group_id,menu_group.name_en,menu_group.name_ru,menu.dish_description,menu.dish_en,menu.dish_ru,menu.dish_description_en,menu.dish_description_ru,menu.view_registred from menu,menu_group where menu_group.is_deleted=false and menu.is_deleted=false and menu_group.id='.$menuGroupID.' and menu.dish like \'%'.$search.'%\' and  menu.menu_group_id=menu_group.id order by menu.order_id desc');
		} else {
			$data = $db->getAssoc('select menu.id,menu.dish,menu.price, menu.order_id,menu_group.name,menu.published,menu.view_not_registred,menu.menu_group_id,menu_group.name_en,menu_group.name_ru,menu.dish_description,menu.dish_en,menu.dish_ru,menu.dish_description_en,menu.dish_description_ru,menu.view_registred from menu,menu_group where menu_group.is_deleted=false and menu.is_deleted=false and  menu.dish like \'%'.$search.'%\' and  menu.menu_group_id=menu_group.id order by menu.order_id desc');
		}
		
		if (PEAR::isError($data)) {
			echo $data->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenus()');
		}
		$db->disconnect();
		return $data;
	}
	

	
	/**
	*Gražinamas menu išsidėstymo pozicijos
	*@param Integer $menuGroupID menu grupės identifikacinis numeris; jei 0 - imamos visos menu kategorijos
	*@return Array pasirinktos pozicijos
	*/
	public function getMenusPositions($menuGroupID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($menuGroupID != 0) {
			$res = $db->query('select max(menu.order_id),min(menu.order_id) from menu,menu_group where menu_group.id=menu.menu_group_id and menu.is_deleted=false and menu_group.is_deleted=false and menu.menu_group_id='.$menuGroupID);
		} else {
			$res = $db->query('select max(menu.order_id),min(menu.order_id) from menu,menu_group where menu_group.id=menu.menu_group_id and menu.is_deleted=false and menu_group.is_deleted=false');
		}
		
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->getMenusPositions()');
		}
		$res->fetchInto($positions);
		$db->disconnect();
		return $positions;
	}
	
	/**
	*Pakeičiamas menu publikavimo statusas
	*@param Integer $menu_id Menu identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateMenuPublication($menu_id,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu set published=? where id=?');
		$data = array($pubStatus,$menu_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuPublication()');
		}
		$db->disconnect();
	}
	
	/**
	*Pakeičiamas menu publikavimo neregistruotiems vartotojams statusas
	*@param Integer $menu_id_not_registred_pub Menu identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateMenuPublicationNotRegistred($menu_id_not_registred_pub,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu set view_not_registred=? where id=?');
		$data = array($pubStatus,$menu_id_not_registred_pub);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuPublicationNotRegistred()');
		}
		$db->disconnect();
	}
	
	/**
	*Pakeičiamas menu publikavimo registruotiems vartotojams statusas
	*@param Integer $menu_id_registred_pub Menu identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateMenuPublicationRegistred($menu_id_registred_pub,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu set view_registred=? where id=?');
		$data = array($pubStatus,$menu_id_registred_pub);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuPublicationRegistred()');
		}
		$db->disconnect();
	}
	
	/**
	*Pakeičiama menu pozicija
	*@param Integer $menu_id Menu identifikacinis numeris
	*@param Integer $position_id Einamosios pozicijos identifikacinis numeris
	*@param String $direction Pozicija kur keisti kryptį
	*/
	public function updateMenuPositions($menu_id,$position_id,$direction)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($direction == 'up') {
			$res = $db->query('select menu.id,menu.order_id from menu,menu_group where menu.menu_group_id=menu_group.id and menu.is_deleted=false and menu_group.is_deleted=false and menu.order_id>'.$position_id.' order by menu.order_id asc  limit 1');
		}
		if ($direction == 'down') {
			$res = $db->query('select menu.id,menu.order_id from menu,menu_group where menu.menu_group_id=menu_group.id and menu.is_deleted=false and menu.is_deleted=false and menu.order_id<'.$position_id.' order by menu.order_id desc limit 1');
		}		
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->updateMenuPositions()');
		}
		
		$res->fetchInto($oldPosition);

		//Is kurio perkeliama atnaujinamas
		$query = $db->prepare('update menu set order_id=? where id=?');
		$data = array($position_id,$oldPosition[0]);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuPositions()');
		}
		
		//Kuris buvo keiciamas atnaujinamas
		$query = $db->prepare('update menu set order_id=? where id=?');
		$data = array($oldPosition[1],$menu_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenuPositions()');
		}
				
		$db->disconnect();
	}
	

	/**
	*
	*Ištrinami menu
	*@param Integer ARRAY $menuIDS meniu identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeMenus($menuIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($menuIDS); $i++) {
			if ($i != count($menuIDS) - 1) {
				$whereClause .= 'id='.$menuIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$menuIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from menu where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->removeMenus()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*
	*
	*Skaičiaus su kableliu tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Sukuriamas patiekalas
	*@param String $name Lietuviškai patiekalo pavadinimas
	*@param String $name_en Angliškai patiekalo pavadinimas
	*@param String $name_ru Rusiškai patiekalo pavadinimas
	*@param Integer $mgroupID patiekalo grupės identifikacinis numeris
	*@param String $description patiekalo aprašymas lietuviškai
	*@param String $description_en patiekalo aprašymas angliškai
	*@param String $description_ru patiekalo aprašymas rusiškai
	*@param Numeric(8;2) $price Patiekalo kaina
	*@param bool $published Ar publikuoti: true - publikuoti; false - nepublikuoti;
	*@param bool $view_not_registred Ar rodyti neregistruotiems: true - rodyti; false - nerodyti;
	*@param bool $view_registred Ar rodyti neregistruotiems: true - rodyti; false - nerodyti;
	*/
	public function insertMenu($name,$name_en,$name_ru,$mgroupID,$description,$description_en,$description_ru,$price,$published,$view_not_registred,$view_registred)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into menu (dish,dish_en,dish_ru,dish_description,dish_description_en,dish_description_ru,price,menu_group_id,published,view_not_registred,view_registred) values (?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($name,$name_en,$name_ru,$description,$description_en,$description_ru,$price,$mgroupID,$published,$view_not_registred,$view_registred);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->insertMenu()');
		}

		$db->disconnect();
	}
	
	
	/**
	*Gražinamas pasirinkto menu duomenys
	*@param Integer $menuID menu identifikacinis numeris
	*@return Array pasirinkto menu duomenys
	*/
	public function getMenuData($menuID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id,dish,dish_description,price,menu_group_id,order_id,published,view_not_registred,dish_en,dish_ru,dish_description_en,dish_description_ru,is_deleted,view_registred from menu where id='.$menuID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->getMenuData()');
		}
		$res->fetchInto($menu);
		$db->disconnect();
		return $menu;
	}
	
	/**
	*Atnaujinami patiekalo duomenys
	*@param Integer $menuID Atnaujinamo patiekalo identifikacinis numeris
	*@param String $name Lietuviškas patiekalo pavadinimas
	*@param String $name_en Angliškas patiekalo pavadinimas
	*@param String $name_ru Rusiškas patiekalo pavadinimas
	*@param Integer $mgroupID patiekalo grupės identifikacinis numeris
	*@param String $description Lietuviškas patiekalo aprašymas
	*@param String $description_en Angliškas patiekalo aprašymas
	*@param String $description_ru Rusiškas patiekalo aprašymas
	*@param Numeric(8;2) $price Patiekalo kaina
	*@param bool $published Ar publikuoti: true - publikuoti; false - nepublikuoti;
	*@param book $view_not_registred Ar rodyti neregistruotiems vartotojams: true - rodyti; false - nerodyti;
	*@param book $view_registred Ar rodyti registruotiems vartotojams: true - rodyti; false - nerodyti;
	*/
	public function updateMenu($menuID,$name,$name_en,$name_ru,$mgroupID,$description,$description_en,$description_ru,$price,$published,$view_not_registred,$view_registred)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update menu set dish=?,dish_en=?,dish_ru=?,dish_description=?,dish_description_en=?,dish_description_ru=?,price=?,menu_group_id=?,published=?,view_not_registred=?,view_registred=? where id=?');
		$data = array($name,$name_en,$name_ru,$description,$description_en,$description_ru,$price,$mgroupID,$published,$view_not_registred,$view_registred,$menuID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Menu->updateMenu()');
		}

		$db->disconnect();
	}
	
	/**
	*Tikrinama užsakymo pradžios data
	*@param Integer $beforeOrderHours Prie dabarties laiko pridedamas šis kiekis valandų ir lyginamas su užsakymo pradžia (Užsakymo pradžia turi būti vėlesnė)
	*@param Date $orderFrom Užsakymo pradžios data
	*@return Array true - užaskymo pradžios data teisingas; false - klaidinga
	*/
	public function checkOrderFromTime($beforeOrderHours,$orderFrom)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select 1 where now() + interval \''.$beforeOrderHours.' hours\' <= \''.$orderFrom.'\'');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->checkOrderFromTime()');
		}
		
		$db->disconnect();
		while ($res->fetchInto($menu)) {
			return true;
		}
		
		return false;
	}
	
	/**
	*Tikrinama užsakymo pabaigos data
	*@param Integer $minTimeBetweenOrder Minimalus užsakymo laikas valandomis
	*@param Date $orderFrom Užsakymo pradžios data
	*@param Date $orderTo Užsakymo pabaigos data
	*@return Array true - užaskymo pabaigos data teisinga; false - klaidinga
	*/
	public function checkOrderToTime($minTimeBetweenOrder,$orderFrom,$orderTo)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select 1 where \''.$orderFrom.'\'  <= timestamp \''.$orderTo.'\' - interval \''.$minTimeBetweenOrder.' hours\' ');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->checkOrderToTime()');
		}
		
		$db->disconnect();
		while ($res->fetchInto($menu)) {
			return true;
		}
		
		return false;
	}
	
	/**
	*Tikrinama užsakymo neperilgas užsakymas
	*@param Integer $maxOrderHours maksimalus užsakymo laikas valandomis
	*@param Date $orderFrom Užsakymo pradžios data
	*@param Date $orderTo Užsakymo pabaigos data
	*@return Array true - teisingas; false - klaidinga
	*/
	public function checkMaxOrderTime($maxOrderHours,$orderFrom,$orderTo)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query(' select 1 where (timestamp \' '.$orderTo.' \' -  timestamp \' '.$orderFrom.'\') <= interval \' '.$maxOrderHours.' hours\'');
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->checkOrderToTime()');
		}
		
		$db->disconnect();
		while ($res->fetchInto($menu)) {
			return true;
		}
		
		return false;
	}
	
	/**
	*Gražinamas klientui priskirtų ložių sąrašas
	*@param $customerID Įmonės kliento identifikacinis numeris
	*@return Array klientui priskirtų ložių masyvas
	*/
	public function getCustomerAssignedLodges($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select companies_loges.id, loges.loge_number,loges.type  from loge_customers,companies,companies_loges,loges where companies.id=loge_customers.company_id and companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loge_customers.id='.$customerID.' order by loges.loge_number asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getCustomerAssignedLodges()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Atliekamas užsakymas
	*@param Integer $companies_loge_id Įmonei priskirtos ložės identifikacinis numeris
	*@param Integer $loge_customer_id Įmonės kliento identifikacinis numeris
	*@param Integer $payment_type Apmokėjimas: 1 - grynais; 2 - pavedimu;
	*@param Text $other_info Papildoma informacija
	*@param Date $orderFrom Užsakymo pradžios data
	*@param Date $orderTo Užsakymo pabaigos data
	*@param Array $ids menu identifikaciniai numeriai
	*@param Array $quantities pasirinkti kiekiai
	*@param Integer $peopleCount žmonių kiekis
	*@return Array true - S; false - klaidinga
	*/
	public function insertOrder($companies_loge_id,$loge_customer_id,$payment_type,$other_info,$orderFrom,$orderTo,$ids,$quantities,$peopleCount)
	{
		//echo "insertOrder($companies_loge_id,$loge_customer_id,$payment_type,$other_info,$orderFrom,$orderTo,$ids,$quantities)";

	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('begin');
		$res = $db->query('select nextval(\'loges_orders_id_seq\'::regclass)');
		if (PEAR::isError($res)) {
			$res = $db->query('rollback');
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->insertOrder() (get nextval)');
		}
		$res->fetchInto($orderIDar);
		$orderID = $orderIDar[0];
		
		//cia ta kai buvo dar OrderTo $res = $db->query('insert into loges_orders (id,companies_loge_id,loge_customer_id,from_time,to_time,payment_type,other_info,people_count) values ('.$orderID.','.$companies_loge_id.','.$loge_customer_id.',\' '.$orderFrom.' \',\' '.$orderTo.' \','.$payment_type.',\' '.$other_info.' \','.$peopleCount.')');
		//be orderTO:
		$res = $db->query('insert into loges_orders (id,companies_loge_id,loge_customer_id,from_time,payment_type,other_info,people_count) values ('.$orderID.','.$companies_loge_id.','.$loge_customer_id.',\' '.$orderFrom.' \','.$payment_type.',\' '.$other_info.' \','.$peopleCount.')');
		if (PEAR::isError($res)) {
			$res = $db->query('rollback');
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->insertOrder() (insert into loges_orders)');
		}
		//echo "<pre>";
		// print_r($ids);
		//echo "</pre>";
		
			//	echo "<pre>";
		// print_r($quantities);
		//echo "</pre>";
		
		for ($i = 0; $i < count($ids); $i++) {
		$res = $db->query('insert into ordered_menu (menu_id,loges_order_id,quantity) values ('.$ids[$i].','.$orderID.','.$quantities[$i].')');
		if (PEAR::isError($res)) {
			$res = $db->query('rollback');
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: Menu->insertOrder() (insert into loges_orders)');
		}
		}
		$res = $db->query('commit');
		$db->disconnect();
		
	}
	
	/**
	*Gražinamas klientui priskirtos ložės numeris
	*@param $customer_lodges_id Klientui priskirtos ložės arba kabinos identifikacinis numeris
	*@return Array klientui priskirtos ložės numeris
	*/
	public function getLodgeNumber($customer_lodges_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select loges.loge_number from loges,companies_loges where loges.id=companies_loges.loge_id and companies_loges.id='.$customer_lodges_id);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getLodgeNumber()');
		}
		$data = null;
		$res->fetchInto($row);
		
		$db->disconnect();
		return $row[0];
		
	}
	
	/**
	*Gražinamas jau užsakytų ložių laikų sąrašas
	*@param $lodgeNumber ložės numeris
	*@return Array jau užsakytų ložių laikų sąrašas
	*/
	public function getAllreadyOrdered($lodgeNumber)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select loges_orders.id, loges_orders.from_time,loges_orders.to_time,loges_orders.confirmation from loges,companies_loges,loges_orders where loges.id=companies_loges.loge_id and companies_loges.id=loges_orders.companies_loge_id and loges.loge_number='.$lodgeNumber.' and loges_orders.from_time>=now() order by loges_orders.from_time desc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getAllreadyOrdered()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Tikrinama ar nepersidengia užsakymo laikai
	*@param $from užsakymo pradžios laikas
	*@param $to užsakymo pabaigos laikas
	*@param $lodgeNumber ložės numeris
	*@return true - persidengia; false - nepersidengia
	*/
	public function checkOrderTimesOverlaps($from,$to,$lodgeNumber)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select 1 from loges,companies_loges,loges_orders where loges.id=companies_loges.loge_id and companies_loges.id=loges_orders.companies_loge_id and loges.loge_number='.$lodgeNumber.' and (loges_orders.from_time,loges_orders.to_time) overlaps (timestamp \''.$from.'\', timestamp \' '.$to.' \')');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->checkOrderTimesOverlaps()');
		}
		
		$db->disconnect();
		while ($res->fetchInto($row)) {
		    return true;
		}
		
		return false;
		
	}
}

/*
$a = new CompaniesInterface();
print_r($a->getPracticeJobStudent(2));
*/
?>
