<?php
/**
*Smarty template klasės pritaikymas "Areno komponento Menu" poreikiams
*
*Klasės SmartyGood praplėtimas. 
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**
* Prijungiama Smarty.class.php klasių biblioteka
*/
require_once('Smarty.class.php');
/**
*StartyGood klasė
*
*Sukuriama SmartyGood klasė, kuri yra Smarty poklasė. Ji skirta nustatyti pradinius klasės kintamuosius.
*Nustatomos template, kešavimo, nuostatatų katalogai.
*@author Mindaugas Rimkus
*/
class SmartyGood extends Smarty
{
	/**
	*SmaryGoo konstruktorius
	*
	*Inicijuojami klasės kintamieji, reikšmėmis kurios naudojamos visuose šablonuose.
	*/
	public function __construct()
	{
		$this->template_dir='/home/webapps/arenabaras.lt/administrator/components/com_menu/tpl/en/template_dir';
		$this->compile_dir='/home/webapps/arenabaras.lt/administrator/components/com_menu/tpl/en/compile_dir';
		$this->config_dir='/home/webapps/arenabaras.lt/administrator/components/com_menu/tpl/en/config_dir';
		$this->cache_dir='/home/webapps/arenabaras.lt/administrator/components/com_menu/tpl/en/cache_dir';
		$this->left_delimiter = '<!--{';
		$this->right_delimiter = '}-->';
	}
	
	/**
	*Virtualus šablono kintamųjų atskirimas
	*
	*Sukuriamas antras šablono kintamųjų atskirimo simbolis.
	*/
	public function changeCodeDelimeter($tpl_source, &$smarty)
	{
		$tpl_source = preg_replace("/{%/","<!--{",$tpl_source);
		return preg_replace("/%}/","}-->",$tpl_source);
	}
}
?>
