<?php
/**
*Smarty template klasės pritaikymas "BITNET apskaitos" poreikiams
*
*Klasės SmartyGood praplėtimas. 
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**
* Prijungiama Smarty.class.php klasių biblioteka
*/
require_once('Smarty.class.php');
/**
*StartyGood klasė
*
*Sukuriama SmartyGood klasė kuri yra Smarty poklasė. Ji skirta nustatyti pradinius klasės kintamuosius.
*Nustatomos template, kešavimo, nuostatatų katalogai.
*@author Mindaugas Rimkus
*/
class SmartyGood extends Smarty
{
	/**
	*SmaryGoo konstruktorius
	*
	*Inicijuojami klasės kintamieji, reikšmėmis kurios naudojamos visuose šablonuose.
	*/
	public function __construct()
	{
		
		if (preg_match("/Win32/i",$_SERVER['SERVER_SOFTWARE'])) {
			//echo "Windows";
			define('SMARTY','C:/Program Files/Apache Group/Apache2/htdocs/bitnet_accountancy');
			
		} else {
			define('SMARTY','/home/webapps/mano.bitnet.lt');
		}
		
		
		$this->template_dir=SMARTY.'/templates/template_dir';
		$this->compile_dir=SMARTY.'/templates/compile_dir';
		$this->config_dir=SMARTY.'/templates/config_dir';
		$this->cache_dir=SMARTY.'/templates/cache_dir';
		//echo SMARTY.'/templates/cache_dir';
		$this->left_delimiter = '<!--{';
		$this->right_delimiter = '}-->';
	}
	/**
	*Virtualus šablono kintamųjų atskirimas
	*
	*Sukuriamas antras šablono kintamųjų atskirimo simbolis.
	*/
	public function changeCodeDelimeter($tpl_source, &$smarty)
	{
		$tpl_source = preg_replace("/{%/","<!--{",$tpl_source);
		return preg_replace("/%}/","}-->",$tpl_source);
	}
}
?>