/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.context;

import java.applet.Applet;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import javax.swing.JApplet;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import wjhk.jupload2.context.DefaultJUploadContext;
import wjhk.jupload2.exception.JUploadException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JUploadContextApplet
extends DefaultJUploadContext {
    JApplet theApplet = null;

    public JUploadContextApplet(JApplet theApplet) {
        if (theApplet == null) {
            throw new IllegalArgumentException("theApplet may not be null");
        }
        this.theApplet = theApplet;
        this.init(this.findParentFrame(theApplet), theApplet);
    }

    private Frame findParentFrame(JApplet theApplet) {
        for (Container c = theApplet; c != null; c = c.getParent()) {
            if (!(c instanceof Frame)) continue;
            return (Frame)c;
        }
        return null;
    }

    @Override
    public JApplet getApplet() {
        return this.theApplet;
    }

    @Override
    public String getParameter(String key, String def) {
        String paramStr = this.theApplet.getParameter(key) != null ? this.theApplet.getParameter(key) : def;
        this.displayDebugParameterValue(key, paramStr);
        return paramStr;
    }

    @Override
    public int getParameter(String key, int def) {
        String paramDef = Integer.toString(def);
        String paramStr = this.theApplet.getParameter(key) != null ? this.theApplet.getParameter(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseInt(paramStr, def);
    }

    @Override
    public float getParameter(String key, float def) {
        String paramDef = Float.toString(def);
        String paramStr = this.theApplet.getParameter(key) != null ? this.theApplet.getParameter(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseFloat(paramStr, def);
    }

    @Override
    public long getParameter(String key, long def) {
        String paramDef = Long.toString(def);
        String paramStr = this.theApplet.getParameter(key) != null ? this.theApplet.getParameter(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseLong(paramStr, def);
    }

    @Override
    public boolean getParameter(String key, boolean def) {
        String paramDef = def ? "true" : "false";
        String paramStr = this.theApplet.getParameter(key) != null ? this.theApplet.getParameter(key) : paramDef;
        this.displayDebugParameterValue(key, paramStr);
        return this.parseBoolean(paramStr, def);
    }

    @Override
    public void readCookieFromNavigator(Vector<String> headers) {
        String cookie = null;
        try {
            cookie = (String)JSObject.getWindow((Applet)this.theApplet).eval("document.cookie");
        }
        catch (JSException e) {
            System.out.println("JSException (" + e.getClass() + ": " + e.getMessage() + ") in DefaultUploadPolicy, trying default values.");
            cookie = System.getProperty("debug_cookie");
            System.out.println("  no navigator found, reading 'debug_cookie' from system properties (" + cookie + ")");
        }
        if (cookie != null) {
            headers.add("Cookie: " + cookie);
        }
    }

    @Override
    public void readUserAgentFromNavigator(Vector<String> headers) {
        String userAgent = null;
        try {
            userAgent = (String)JSObject.getWindow((Applet)this.theApplet).eval("navigator.userAgent");
        }
        catch (JSException e) {
            System.out.println("JSException (" + e.getClass() + ": " + e.getMessage() + ") in DefaultUploadPolicy, trying default values.");
            userAgent = System.getProperty("debug_agent");
            System.out.println("  no navigator found, reading 'debug_agent' from system properties (" + userAgent + ")");
        }
        if (userAgent != null) {
            headers.add("User-Agent: " + userAgent);
        }
    }

    @Override
    public Cursor getCursor() {
        return this.theApplet.getCursor();
    }

    @Override
    public Cursor setCursor(Cursor cursor) {
        Cursor previousCursor = this.theApplet.getCursor();
        this.theApplet.setCursor(cursor);
        return previousCursor;
    }

    @Override
    public void showStatus(String status) {
        this.getUploadPanel().getStatusLabel().setText(status);
    }

    @Override
    public void displayURL(String url, boolean success) {
        try {
            if (url.toLowerCase().startsWith("javascript:")) {
                String expr = url.substring(11);
                expr = expr.replaceAll("%msg%", Matcher.quoteReplacement(this.jsString(this.getUploadPolicy().getLastResponseMessage())));
                expr = expr.replaceAll("%body%", Matcher.quoteReplacement(this.jsString(this.getUploadPolicy().getLastResponseBody())));
                expr = expr.replaceAll("%success%", Matcher.quoteReplacement(success ? "true" : "false"));
                this.displayDebug("Calling javascript expression: " + expr, 80);
                JSObject.getWindow((Applet)this.theApplet).eval(expr);
            } else if (success) {
                String target = this.getUploadPolicy().getAfterUploadTarget();
                if (this.getUploadPolicy().getDebugLevel() >= 100) {
                    this.getUploadPolicy().alertStr("No switch to getAfterUploadURL, because debug level is " + this.getUploadPolicy().getDebugLevel() + " (>=100)");
                } else {
                    this.theApplet.getAppletContext().showDocument(new URL(url), null == target ? "_self" : target);
                }
            }
        }
        catch (Exception ee) {
            try {
                this.getUploadPolicy().displayErr(ee);
            }
            catch (JUploadException e) {
                ee.printStackTrace();
            }
        }
    }

    @Override
    public String normalizeURL(String url) throws JUploadException {
        if (null == url || url.length() == 0) {
            return this.theApplet.getDocumentBase().toString();
        }
        URI uri = null;
        try {
            uri = new URI(url);
            if (null == uri.getScheme()) {
                uri = this.theApplet.getDocumentBase().toURI().resolve(url);
            }
            if (!(uri.getScheme().equals("http") || uri.getScheme().equals("https") || uri.getScheme().equals("ftp"))) {
                throw new JUploadException("URI scheme " + uri.getScheme() + " not supported.");
            }
        }
        catch (URISyntaxException e) {
            throw new JUploadException(e);
        }
        return uri.toString();
    }

    public String jsString(String s) {
        String dollarReplacement = Matcher.quoteReplacement("\\$");
        String singleQuoteReplacement = Matcher.quoteReplacement("\\'");
        String linefeedReplacement = Matcher.quoteReplacement("\\n");
        if (s == null || s.equals("")) {
            return "";
        }
        s = s.replaceAll("\\$", dollarReplacement);
        s = s.replaceAll("\"", "'");
        s = s.replaceAll("'", singleQuoteReplacement);
        s = s.replaceAll("\n", linefeedReplacement);
        s = s.replaceAll("\r", "");
        return s;
    }
}

