<?php
session_start();
//error_reporting(E_ALL);

//Prevent Magic Quotes from affecting scripts, regardless of server settings

//Make sure when reading file data,
//PHP doesn't "magically" mangle backslashes!
set_magic_quotes_runtime(FALSE);

if (get_magic_quotes_gpc()) {
   /*
   All these global variables are slash-encoded by default,
   because    magic_quotes_gpc is set by default!
   (And magic_quotes_gpc affects more than just $_GET, $_POST, and $_COOKIE)
   */
   $_SERVER = stripslashes_array($_SERVER);
   $_GET = stripslashes_array($_GET);
   $_POST = stripslashes_array($_POST);
   $_COOKIE = stripslashes_array($_COOKIE);
   $_FILES = stripslashes_array($_FILES);
   $_ENV = stripslashes_array($_ENV);
   $_REQUEST = stripslashes_array($_REQUEST);
   $HTTP_SERVER_VARS = stripslashes_array($HTTP_SERVER_VARS);
   $HTTP_GET_VARS = stripslashes_array($HTTP_GET_VARS);
   $HTTP_POST_VARS = stripslashes_array($HTTP_POST_VARS);
   $HTTP_COOKIE_VARS = stripslashes_array($HTTP_COOKIE_VARS);
   $HTTP_POST_FILES = stripslashes_array($HTTP_POST_FILES);
   $HTTP_ENV_VARS = stripslashes_array($HTTP_ENV_VARS);
   if (isset($_SESSION)) {    #These are unconfirmed (?)
       $_SESSION = stripslashes_array($_SESSION, '');
       $HTTP_SESSION_VARS = stripslashes_array($HTTP_SESSION_VARS, '');
   }
   /*
   The $GLOBALS array is also slash-encoded, but when all the above are
   changed, $GLOBALS is updated to reflect those changes.  (Therefore
   $GLOBALS should never be modified directly).  $GLOBALS also contains
   infinite recursion, so it's dangerous...
   */
}

function stripslashes_array($data) {
   if (is_array($data)){
       foreach ($data as $key => $value){
           $data[$key] = stripslashes_array($value);
       }
       return $data;
   }else{
       return stripslashes($data);
   }
}

/**
*Administracimo sasajos prisijungimo langas
*
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama ../classes/SmartyGood.class.php klasių biblioteka
*/
require_once('../classes/SmartyGood.class.php');


/**
* Prijungiama ../classes/Admin.class.php Administratorių informacijos valdymo klasių biblioteka
*/
require_once('../classes/Admin.class.php');

/**
* Prijungiama ../classes/Customer.class.php Klientų informacijos valdymo klasių biblioteka
*/
require_once('../classes/Customer.class.php');





$smarty = new SmartyGood();
$smarty->register_prefilter(array(&$smarty, "changeCodeDelimeter"));



$customer = new Customer();

//32 pradzia id


$invoice = @$customer->getInvoice($_GET['id']);

$smarty->assign('quantity',$invoice[33]+0);
$smarty->assign('payment_quantity',$invoice[34]+0);
$smarty->assign('inv_date',$invoice[36]);
$smarty->assign('pay_date',$invoice[37]);

$smarty->assign('purpose',$invoice[39]);




if (@strlen($_GET['file_del']) > 0) {
	
	$customer->deleteInvoiceFile($invoice[0],$_GET['id'],$invoice[38]);
	$smarty->assign('file_del_success',1);

}

if (@strlen($_GET['delete']) > 0) {
	$customer->deleteInvoice($invoice[0],$_GET['id'],$invoice[38]);
	echo "<script language='javascript'>this.location = 'invoices.php?deletesuccess=1'</script>";
	

}




$invoice = @$customer->getInvoice($_GET['id']);
$smarty->assign('invoice',$invoice);
$smarty->assign('inv_path',$invoice[38]);


$is_inv = $invoice[41];
if ($is_inv == 't') {
	$vat_inv_no = $invoice[42];
	$vat = $invoice[43];
	$vat_inv_date = $invoice[44];
	$vat_inv_quantity = $invoice[45];
	$vat_oper_code = $invoice[47];
} else {
	$vat_inv_no = $customer->getVATNumber();
	//echo $vat_inv_no;
	$vat = null;
	$vat_inv_date = null;
	$vat_inv_quantity = null;
	$vat_oper_code = null;
}

$smarty->assign('is_inv',$is_inv);
$smarty->assign('vat_inv_no',$vat_inv_no);
$smarty->assign('vat',$vat);
$smarty->assign('vat_inv_date',$vat_inv_date);
$smarty->assign('vat_inv_quantity',$vat_inv_quantity);
$smarty->assign('vat_oper_code',$vat_oper_code);


if ($_SERVER['REQUEST_METHOD'] == 'POST' && @$_POST['vat_form'] == 1) {
	
	$smarty->assign('is_inv',$_POST['is_inv']);
	
	$error = 0;
	if ($_POST['is_inv'] == 't') {
		
		//echo $_POST['vat_inv_no'];
		$smarty->assign('vat_inv_no',$_POST['vat_inv_no']);
		$smarty->assign('vat',$_POST['vat']);
		$smarty->assign('vat_inv_date',$_POST['vat_inv_date']);
		$smarty->assign('vat_inv_quantity',$_POST['vat_inv_quantity']);
		$smarty->assign('vat_oper_code',$_POST['vat_oper_code']);
		
		if (!$customer->checkInt($_POST['vat_inv_no']))  {
			$smarty->assign('vat_inv_no_error',1);
			$error++;
		}
		
		if (!$customer->checkInt($_POST['vat']))  {
			$smarty->assign('vat_error',1);
			$error++;
		}
		
		if (strlen($_POST['vat_oper_code']) == 0)  {
			$smarty->assign('vat_oper_code_error',1);
			$error++;
		}
		
		if (strlen($_POST['vat_inv_date']) == 0)  {
			$smarty->assign('vat_inv_date_error',1);
			$error++;
		}
		
		if (!$customer->checkDigit($_POST['vat_inv_quantity']))  {
			$smarty->assign('vat_inv_quantity_error',1);
			$error++;
		}
	}
	if ($error == 0) {
		$customer->insertVAT(@$_GET['id'],@$_POST['is_inv'],@$_POST['vat_inv_no'],@$_POST['vat'],@$_POST['vat_inv_date'],@$_POST['vat_inv_quantity'],@$invoice[46],@$invoice[2],@$_POST['vat_oper_code']);
		$smarty->assign('success_vat',1);
		$invoice = @$customer->getInvoice($_GET['id']);
		$smarty->assign('invoice',$invoice);
		$smarty->assign('inv_path',$invoice[38]);
		
		
		$is_inv = $invoice[41];
		if ($is_inv == 't') {
			$vat_inv_no = $invoice[42];
			$vat = $invoice[43];
			$vat_inv_date = $invoice[44];
			$vat_inv_quantity = $invoice[45];
			$vat_oper_code = $invoice[47];
		} else {
			$vat_inv_no = $customer->getVATNumber();
			//echo $vat_inv_no;
			$vat = null;
			$vat_inv_date = null;
			$vat_inv_quantity = null;
			$vat_oper_code = null;
		}
		
		$smarty->assign('is_inv',$is_inv);
		$smarty->assign('vat_inv_no',$vat_inv_no);
		$smarty->assign('vat',$vat);
		$smarty->assign('vat_inv_date',$vat_inv_date);
		$smarty->assign('vat_inv_quantity',$vat_inv_quantity);
		$smarty->assign('vat_oper_code',$vat_oper_code);
	} else {
		$smarty->assign('error',1);
	}
	
}


if ($_SERVER['REQUEST_METHOD'] == 'POST' && @$_POST['vat_form'] != 1) {
	
	$smarty->assign('quantity',$_POST['quantity']);
	$smarty->assign('payment_quantity',$_POST['payment_quantity']);
	
	$smarty->assign('inv_date',$_POST['inv_date']);
	$smarty->assign('pay_date',$_POST['pay_date']);
	
	
	
	$smarty->assign('purpose',$_POST['purpose']);
	


	$error = 0;
	
	if (!$customer->checkDigit($_POST['quantity']))  {
		$smarty->assign('quantity_error',1);
		$error++;
	}
	
	if (!$customer->checkDigit($_POST['payment_quantity']))  {
		$smarty->assign('payment_quantity_error',1);
		$error++;
	}
	
	if (strlen($_POST['inv_date']) == 0)  {
		$smarty->assign('inv_date_error',1);
		$error++;
	}
	
	if (strlen($_POST['pay_date']) == 0 && $_POST['payment_quantity'] > 0)  {
		$smarty->assign('pay_date_error',1);
		$error++;
	}
	

	
	if (strlen($_POST['purpose']) == 0)  {
		$smarty->assign('purpose_error',1);
		$error++;
	}
	
	
	
	

	if (strlen($_FILES['inv_path']['tmp_name']) > 0 && !is_uploaded_file($_FILES['inv_path']['tmp_name']) ) {
		$error++;
		$smarty->assign('inv_path_error',1);
	}

	if ($error == 0) {
		
		
		$invoice_path = "";
		if (is_uploaded_file($_FILES['inv_path']['tmp_name'])) {
			$invoice_path = '../invoices/'.time().$_FILES['inv_path']['name'];
			move_uploaded_file($_FILES['inv_path']['tmp_name'], $invoice_path);
			@unlink($invoice[12]);
		}
		
		$smarty->assign('success',1);
		$customer->updateInvoice($_GET['id'],$invoice[12],$_POST['quantity'],$_POST['payment_quantity'],$_POST['inv_date'],$_POST['pay_date'],$invoice_path,$_POST['purpose']);
		
		$invoice = @$customer->getInvoice($_GET['id']);
		$smarty->assign('invoice',$invoice);
		$smarty->assign('inv_path',$invoice[38]);
		
	}
	$smarty->assign('error',$error);
}










$admin = new Admin();
$adminID = @$admin->getAdminID($_SESSION['username'],$_SESSION['password']);

if ($adminID == 0) {
	echo "<script language='javascript'>this.location = 'login.php'</script>";
} else {
	$smarty->display('admin/invoice_detail.tpl');
}


?>