<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

* Šioje klasėje realizuotos SMS siuntimo funkcijos
*
*@copyright Copyright 2020, Mindaugas Rimkus
*/
class SMSSender
{
	//RouteSMS username
	public $username = "disigma1";
	//RouteSMS password
	public $password = "labas123";
	//RouteSMS url
	public $url = "http://api.rmlconnect.net:8080/bulksms/bulksms?";
	
	/**
	*
	*
	*SMS siuntimas
	*@param Integer $contractID Sutarties identifikacinis numeris
	*@param String $message_receiver SMS gavėjo telefono numeris
	*@param String $message_text Žinutės tekstass
	*@return Array išsiųsta SMS žinutė
	*/
	public function sendSMS($contractID,$message_receiver,$message_text)
	{
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$res =  $db->query('select id,sender,receiver,msg_text,sms_insert_status,sent_time,dlr_time,dlr_status,message_id,url_view_time,create_time,modify_time from send_sms_by_contractid('.$contractID.',\''.$message_receiver.'\',\''.$message_text.'\')');
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: SMSSender->sendSMS()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
	}
	
	/**
	*Gražinamas paskutinės žinutės išsiųstos sutarčiai duomenys
	*@param Integer $contractID Kontrakto identifikacinis numeris
	*@return Array paskutinės žinutės išsiųstos sutarčiai duomenys
	*/

	public function getLastSMSDataByContractID($contractID)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,sender,receiver,msg_text,sms_insert_status,sent_time,dlr_time,dlr_status,message_id,url_view_time from sms where contract_id='.$contractID.' order by id desc limit 1');
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: SMSSender->getLastSMSDataByContractID()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
	}
	
	/**
	*Atnaujinamas SMS žinutėje esančio URL paspaudimo laikas į einamajį
	*@param Integer $id SMS žinutės identifikacinis numeris
	*/
	public function updateURLViewTime($id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$types = array("integer");
		$statement = $db->prepare('update sms set url_view_time=now()  where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: SMSSender->updateURLViewTime(): fail prepare');
		}

		$data = array($id);
		$resultset = $statement->execute($data);
	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: SMSSender->updateURLViewTime(): fail execute');
		}
		

	}
	
	/**
	*Atnaujinamas SMS žinutėje esantys delivery reports laukai (dlr_time,dlr_status)
	*@param String $message_id SMS žinutės RouteSMS identifikacinis
	*@param String $dlr_status Delivery statusas
	*/
	public function updateDeliveryReport($message_id,$dlr_status)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$types = array("text","text");
		$statement = $db->prepare('update sms set dlr_time=now(), dlr_status=?  where message_id like ?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: SMSSender->updateURLViewTime(): fail prepare');
		}

		$data = array($dlr_status,$message_id);
		$resultset = $statement->execute($data);
	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: SMSSender->updateDeliveryReport(): fail execute');
		}
		

	}
	
	/**
	*Gražinamas 12 paskutininių SMS žinučių išsiųstų sutarčiai
	*@param Integer $contractID
	*@return Array 12 paskutininių SMS žinučių išsiųstų sutarčiai masyvas
	*/

	public function getLast12SMS($contractID)
	{
	
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select 	id,contract_id,sender,receiver,msg_text,sms_insert_status,sent_time,dlr_time,dlr_status,message_id,url_view_time from sms where contract_id='.$contractID.' order by id desc limit 12');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: SMSSender->getLast12SMS()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Pašalinamos SMS žinutės 
	*@param $smsArray Array SMS žinučių masyvas
	*/
	public function deleteSMS($smsArray)
	{
		$strIDS = '';
		for ($i = 0; $i < count($smsArray); $i++) {
			if ($i == 0) {
				$strIDS .= ' id='.$smsArray[$i]. ''; 
			} else {
				$strIDS .= ' or id='.$smsArray[$i]. ''; 
			}
		}
		//echo $strIDS;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$statement = $db->prepare('delete from sms   where '.$strIDS,null, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: SMSSender->deleteSMS(): fail prepare');
		}

		$resultset = $statement->execute();
	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: SMSSender->updateURLViewTime(): fail execute');
		}
		

	}
	
	
	
}