<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka 
*/
require_once('ConnectManager.class.php');


/**
* Prijungiama ConnectManagerInfoside.class.php prisijungimo prie duomenų bazės klasių biblioteka Infoside apskaitos 
*/
require_once('ConnectManagerInfoside.class.php');

/**
* Prijungiama Logging.class.php istorijos žurnalų valdymo klasių biblioteka
*/
require_once('Logging.class.php');

/**

*Klientų valdymo klasė
*
*@copyright Copyright 2009, Mindaugas Rimkus
*/
class Customer
{
	public $email = "visvien@inbox.lt";
	public $email1 = "mekapas@inbox.lt";
	
	public function generatePassword ($length = 8)
	{
		
		  // start with a blank password
		  $password = "";
		
		  // define possible characters
		  $possible = "0123456789bcdfghjkmnpqrstvwxyz"; 
		    
		  // set up a counter
		  $i = 0; 
		    
		  // add random characters to $password until $length is reached
		  while ($i < $length) { 
		
		    // pick a random character from the possible ones
		    $char = substr($possible, mt_rand(0, strlen($possible)-1), 1);
		        
		    // we don't want this character if it's already in the password
		    if (!strstr($password, $char)) { 
		      $password .= $char;
		      $i++;
		    }
		
		  }
		
		  // done!
		  return $password;
	}

	/**
	*
	*
	*Tikrinama ar fizinio asmens vardas ar pavardė sudarytas tik iš didžiųjų arba mažųjų raidžių bei gali gali talpinti tarpų simbolį
	*@param String $naturalPersonNameSurname fizinio asmens vardas arba pavardė
	*@return Boolean true - valid $naturalPersonNameSurname, false - Invalid
	*/
	public function checkNaturalPersonNameSurname($naturalPersonNameSurname)
	{
		$naturalPersonNameSurname = trim($naturalPersonNameSurname);
		if (strlen($naturalPersonNameSurname) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя]/",$naturalPersonNameSurname)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Tikrinamas asmens kodas
	*@param String $identityCode fizinio asmens asmens kodas
	*@return Boolean true - valid $identityCode, false - Invalid
	*/
	public function checkIdentityCode($identityCode)
	{
		$identityCode = trim($identityCode);
		if (preg_match("/\b[\d]{11}\b/",$identityCode)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Tikrinamas adresas
	*@param String $address Gyvenamosios vietos adresas
	*@return Boolean true - valid $address, false - Invalid
	*/
	public function checkAddress($address)
	{
		$address = trim($address);
		if (strlen($address) == 0) return false; 
		
		if (preg_match("/[^\da-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя\\\\\-\\.,:]/",$address)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*Telefono tikrinimas
	*
	*Tikrinama ar telefono numeris sudarytas tinkamai
	*@param String $phone telefono numeris
	*@return Boolean true - valid $phone, false - Invalid
	*/
	public function checkPhone($phone) 
	{
		$phone = trim($phone);
		if (preg_match("/^[+\d][\d]+[\d]$/",$phone)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*PVM kodo tikrinimas
	*
	*Tikrinama ar PVM kodas sudarytas tinkamai
	*@param String $vat_code PVM kodas
	*@return Boolean true - valid $vat_code, false - Invalid
	*/
	public function checkVATCode($vat_code) 
	{
		$vat_code = trim($vat_code);
		if (strlen($vat_code) == 0) return true;
		if (preg_match("/[^\d\w]/",$vat_code)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Tikrinama vartotojo vardas
	*@param String $username Prisijungimo prie sistemos vartotojo vardas
	*@return Boolean true - valid $username, false - Invalid
	*/
	public function checkUsername($username)
	{
		$username = trim($username);
		if (strlen($username) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ\d\\-_]/",$username)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Slaptažodžio tikrinimas
	*@param String $password Prisijungimo prie sistemos slaptažodžio tikrinimas
	*@return Boolean true - valid $password, false - Invalid
	*/
	public function checkPassword($password)
	{
		$password = trim($password);
		if (strlen($password) == 0) return false; 
		
		if (preg_match("/[\r\t\n\f]/",$password)) {
			return false;
		} else {
			return true;
		}
	}
	
	
	
	
	/**
	*
	*
	*Tikrinamas įmonės pavadinimas
	*@param String $companyName Įmonės pavadinimas
	*@return Boolean true - valid $companyName, false - Invalid
	*/
	public function checkCompanyName($companyName)
	{
		$companyName = trim($companyName);
		if (strlen($companyName) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя\\\\\-\\.,:]/",$companyName)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Įmonės kodo tikrinimas
	*@param String $code Įmonės kodas
	*@return Boolean true - valid $code, false - Invalid
	*/
	public function checkCode($code)
	{
		$code = trim($code);
		if (strlen($code) == 0) return false; 
		
		if (preg_match("/[^\d]/",$code)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Skaičiaus po kablelio tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Dataos tikrinimas yyyy.mm.dd
	*@param String $digit Data yyyy.mm.dd
	*@return Boolean true - valid $date, false - Invalid
	*/
	public function checkDate($date)
	{
		$date = trim($date);
		
		if (preg_match("/^[\d]{4}\.[\d]{2}.[\d]{2}$/",$date)) {
			return true;
		} else {
			return false;
		}
	}

	/**
	*
	*
	*Dataos tikrinimas yyyy-mm-dd
	*@param String $digit Data yyyy-mm-dd
	*@return Boolean true - valid $date, false - Invalid
	*/
	public function checkDate1($date)
	{
		$date = trim($date);
		
		if (preg_match("/^[\d]{4}-[\d]{2}-[\d]{2}$/",$date)) {
			return true;
		} else {
			return false;
		}
	}
	
	
	/**
	*
	*
	*Dataos tikrinimas .txt extention
	*@param String $fileName failo pavadinimas
	*@return Boolean true - valid $fileName, false - Invalid
	*/
	public function checkTxtExt($fileName)
	{
		$fileName = trim($fileName);
		
		if (preg_match("/\.txt$/",$fileName)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Dataos tikrinimas .csv extention
	*@param String $fileName failo pavadinimas
	*@return Boolean true - valid $fileName, false - Invalid
	*/
	public function checkCsvExt($fileName)
	{
		$fileName = trim($fileName);
		
		if (preg_match("/\.csv$/",$fileName)) {
			return true;
		} else {
			return false;
		}
	}
	
	
	/**
	*
	*
	*Dataos tikrinimas Perlo failo pavadinimas
	*@param String $fileName failo pavadinimas
	*@return Boolean true - valid $fileName, false - Invalid
	*/
	public function checkPerlFileName($fileName)
	{
		$fileName = trim($fileName);
		
		if (preg_match("/^(PP|VPP)\d{6}\.txt$/",$fileName)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Skaičiaus be kablelio tikrinimas
	*@param String $digit Skaičius be kablelio
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkInt($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Vartotojo vardo egzistencijos tikrinimas
	*@param String $username kliento vartotojo vardas 
	*@return Boolean true - egzistoja toks $username duomenų bazėja, false - neegzistuoja
	*/
	public function checkUsernameExistence($username)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$username = trim($username);
		$result= $db->query('select id from customers where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->checkUsernameExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Kliento egzistencijos tikrinimas
	*@param Integer $id Šį ID reikia praleisti
	*@param String $username Vartotojo vardas
	*@return Boolean true - egzistoja toks klientas duomenų bazėja, false - neegzistuoja
	*/
	public function checkCustomerExistence($id,$username)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$name = trim($name);
		$surname = trim($surname);
		$result= $db->query('select id from customers where id<>'.$id.' and username=\''.$username.'\' ');
		if (PEAR::isError($result)) {
			//echo $result->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->checkCustomerExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Įterpiamas klientas
	*
	*@param String $company_name Įmonės pavadinimas
	*@param String $code Įmonės kodas arba fizinio asmens kodas
	*@param String $vat_code Įmonės PVM kodas
	*@param String $name Fizinio asmens vardas arba įmonės kontaktinio asmens vardas
	*@param String $surname Fizinio asmens pavardė arba įmonės kontaktinio asmens pavardė
	*@param String $address Adresas
	*@param String $phone Telefonas
	*@param String $username Prisijungimo prie sistemos vartotojo vardas
	*@param Sting $password Prisijungimo prie sistemos slaptažodis
	*@param Boolean $is_company Ar įmonė: true - įmonė, false - fizinis asmuo
	*@param Boolean $sms_inform SMS informavimas: true - įjungtas, false - išjungtas
	*/
	public function insertCustomer($company_name,$code,$vat_code,$name,$surname,$address,$phone,$username,$password,$is_company,$sms_inform)
	{
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($company_name) == 0) {
			$company_name = null;
		}
		if (strlen($vat_code) == 0) {
			$vat_code = null;
		}
		if (strlen($phone) == 0) {
			$phone = null;
		}

		
		$types = array("text","text","text","text","text","text","text","text","text","boolean","boolean");

		$statement = $db->prepare('insert into customers (company_name,code,vat_code,name,surname,address,phone,username,password,is_company,sms_inform) values (?,?,?,?,?,?,?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->insertCustomer(): fail prepare');
		}

		$data = array($company_name,$code,$vat_code,$name,$surname,$address,$phone,$username,$password,$is_company,$sms_inform);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->insertCustomer(): fail execute');
		}
		//$log->logError("Admin: ".$_SESSION['admin']." insert customer: $company_name,$code,$vat_code,$name,$surname,$address,$phone,$username,$password,$is_company");
		
		if ($is_company == false) {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento registracija (fizinis asmuo)",
			"Vardas: $name<br />Pavardė: $surname<br />Asmens kodas: $code<br />Adresas: $address<br />Telefonas: $phone<br />Vartotojo vardas: $username<br />Slaptažodis:$password <br /><br />Priregistravo: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento registracija (įmonė)",
			"Įmonės pavadinimas: $company_name<br />Įmonės kodas: $code<br />Kontaktinio asmens vardas: $name<br />Kontaktinio asmens pavardė: $surname<br />Adresas: $address<br />Telefonas: $phone<br />Vartotojo vardas: $username<br />Slaptažodis:$password <br /><br />Priregistravo: {$_SESSION['admin']}",
			"",
			""
			);
		}
		
	}
	
	
	
	/**
	*Atnaujinamas klientas
	*
	*@param Integer $id Kliento identifikacinis numeris
	*@param String $company_name Įmonės pavadinimas
	*@param String $code Įmonės kodas arba fizinio asmens kodas
	*@param String $vat_code Įmonės PVM kodas
	*@param String $name Fizinio asmens vardas arba įmonės kontaktinio asmens vardas
	*@param String $surname Fizinio asmens pavardė arba įmonės kontaktinio asmens pavardė
	*@param String $address Adresas
	*@param String $phone Telefonas
	*@param String $username Prisijungimo prie sistemos vartotojo vardas
	*@param Sting $password Prisijungimo prie sistemos slaptažodis
	*@param Boolean $is_company Ar įmonė: true - įmonė, false - fizinis asmuo
	*@param Boolean $sms_inform SMS informvimas: true - įjungtas, false - išjungtas
	*/
	public function updateCustomer($id,$company_name,$code,$vat_code,$name,$surname,$address,$phone,$username,$password,$is_company,$sms_inform)
	{
		$customer = $this->getCustomer($id);
		//$is_company = $customer[10];
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($company_name) == 0) {
			$company_name = null;
		}
		if (strlen($vat_code) == 0) {
			$vat_code = null;
		}
		if (strlen($phone) == 0) {
			$phone = null;
		}

		
		$types = array("text","text","text","text","text","text","text","text","text","boolean","boolean","integer");

		$statement = $db->prepare('update customers set company_name=?,code=?,vat_code=?,name=?,surname=?,address=?,phone=?,username=?,password=?,is_company=?,sms_inform=? where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->updateCustomer(): fail prepare');
		}

		$data = array($company_name,$code,$vat_code,$name,$surname,$address,$phone,$username,$password,$is_company,$sms_inform,$id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->updateCustomer(): fail execute');
		}
		
			if ($is_company == false) {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento informacijos atnaujinimas (fizinis asmuo)",
			"<b>Prieš keitimą:</b><br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Po keitimo:</b> <br /><br />Vardas: $name<br />Pavardė: $surname<br />Asmens kodas: $code<br />Adresas: $address<br />Telefonas: $phone<br />Vartotojo vardas: $username<br />Slaptažodis:$password <br /><br />Keitimus atliko: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento informacijos atnaujinimas (įmonė)",
			"<b>Prieš keitimą:</b><br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Po keitimo:</b> <br /><br />Įmonės pavadinimas: $company_name<br />Įmonės kodas: $code<br />Kontaktinio asmens vardas: $name<br />Kontaktinio asmens pavardė: $surname<br />Adresas: $address<br />Telefonas: $phone<br />Vartotojo vardas: $username<br />Slaptažodis:$password<br /><br />Keitimus atliko: {$_SESSION['admin']}",
			"",
			""
			);
		}		
		

	}
	


	/**
	*Gražinami klientų pagal paieškos sąlygą duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš customers lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String  $search paieškos sąlyga
	*@param Boolean $type Kliento tipas: false - fizinis; true - įmonė; null - visi
	*@return Array visų klientų pagal paieškos sąlygą duomenų masyvas
	*/

	public function getCustomers($offset,$limit,$search,$type)
	{
		

		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and is_company=false";
			} else {
				$is_company = " and is_company=true";
			}
		} else {
			$is_company = "";
		}
		
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,company_name,code,vat_code,name,surname,address,phone,username,password,is_company,registred,sms_inform from customers where (lower(coalesce(company_name,\'\')) like lower(\'%'.$search.'%\') or lower(name) like lower(\'%'.$search.'%\') or lower(surname) like lower(\'%'.$search.'%\') or lower(code) like lower(\'%'.$search.'%\') or lower(coalesce(vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(phone,\'\')) like lower(\'%'.$search.'%\') or lower(username) like lower(\'%'.$search.'%\') or lower(name) ||\' \'|| lower(surname) like lower(\'%'.$search.'%\') )'.$is_company.'    order by id limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomers()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami klientai kuriems aktyvuotas sms siuntimas
	*@return Array klientai kuriems aktyvuotas sms siuntimas
	*/

	public function getCustomersForSMS()
	{
		

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		//where sms_inform=true 
		$res =  $db->query('select id,company_name,code,vat_code,name,surname,address,phone,username,password,is_company,registred,sms_inform from customers   order by id');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomersForSMS()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas klientų kiekis pagal paieškos sąlygą
	*@param String  $search paieškos sąlyga
	*@param Boolean $type Kliento tipas: false - fizinis; true - įmonė; null - visi
	*@return integer klientų kiekis pagal paieškos sąlygą
	*/

	public function getCustomersCount($search,$type)
	{	
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and is_company=false";
			} else {
				$is_company = " and is_company=true";
			}
		} else {
			$is_company = "";
		}
		//echo 'select count(motorbike.id) from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and engine_type like \''.$motorbike_engine_type.'\' and trim(to_char(cubage,\'999999999999.999\')) like \''.$motorbike_cubage.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(id) from customers where (lower(coalesce(company_name,\'\')) like lower(\'%'.$search.'%\') or lower(name) like lower(\'%'.$search.'%\') or lower(surname) like lower(\'%'.$search.'%\') or lower(code) like lower(\'%'.$search.'%\') or lower(coalesce(vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(phone,\'\')) like lower(\'%'.$search.'%\') or lower(username) like lower(\'%'.$search.'%\') or lower(name) ||\' \'|| lower(surname) like lower(\'%'.$search.'%\')  )'.$is_company.'   ');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomersCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		} else {
			return 0;
		}
	}
	
	
	/**
	*Gražinamas klientas 
	*@param String  $id Kliento identifikacinis numeris
	*@return Array Klientas
	*/

	public function getCustomer($id)
	{	

	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,company_name,code,vat_code,name,surname,address,phone,username,password,is_company,registred,sms_inform from customers where id='.$id);
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomer()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
	}
	
	
	/**
	*Tikrinama ar egzistuoja nurodytas klientas pagal ID ir slaptažodį
	*@param Integer  $id Sutarties identifikacinis numeris
	*@param String  $password Kliento slaptažodis
	*@return Array Klientas
	*/

	public function checkCustomerByIDPassword($id,$password)
	{	

	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select contracts.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.username,customers.password,customers.is_company,customers.registred,customers.id from customers,contracts where contracts.customer_id=customers.id and contracts.id='.$id.' and customers.password like \''.$password.'\'');
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->checkCustomerByIDPassword()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
	}
	
	
	/**
	*Gražinami visi BITNET planai
	*@return Array visi BITNET planai
	*/

	public function getPlans()
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,name,download,upload,price_company,price_person from plans order by id');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getPlans()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami visi savininkai
	*@return Array visi savininkai
	*/

	public function getOwners()
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,name,surname,username,password from owners order by id');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getOwners()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Tikrinama ar pirmoji data yra ankstesnė už antrąją
	*@param date $valid_from
	*@param date $valid_to
	*@return true - valid_from ankstesnė už valid_to, false - priešingu atveju
	*/

	public function checkDates($valid_from,$valid_to)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select \''.$valid_from.'\' >=\''.$valid_to.'\'');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->checkDates()');
		}
		
		$row = $res->fetchRow();
		$db->disconnect();
		
		
		if ($row[0] == 't') {
			//echo "tiesa";
			return true;
		} else {
			//echo "melas";
			return false;
		}	
	}
	
	/**
	*Tikrinama ar ar tai data (nuo 1970/01/01)
	*@param date $date
	*@return true - data tinkama false - data neteisinga 
	*/

	public function isDate($date)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select is_date(\''.$date.'\')');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->isDate()');
		}
		
		$row = $res->fetchRow();
		$db->disconnect();
		
		
		if ($row[0] == 't') {
			//echo "tiesa";
			return true;
		} else {
			//echo "melas";
			return false;
		}	
	}

	
	/**
	*Įterpiama nauja sutartis į duomenų bazę
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $plan_id Apmokęstinimo plano identifikacinis numeris
	*@param Numeric $mountly_fee Mėnesinis mokęstis
	*@param Integer $owner_id Savininko identifikacinis numeris
	*@param Date $valid_from Sutarties galiojimo pradžia
	*@param Date $valid_to Sutarties galiojimo pabaiga (null - neterminuota)
	*@param String $contract_path Kelias iki sutarties failo
	*@param Date $suspend_from Sutartis pristabdymo pradžia
	*@param Date $suspend_to Sutartis pristabdymo pabaiga (null - neterminuotai)
	*@param Boolean $is_active Ar aktyvi sutartis: true - aktyvi, false - nutraukta
	*@param String $other_info Papildoma sutarties informacija

	*/
	public function insertContract($customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active,$other_info)
	{
		$customer = $this->getCustomer($customer_id);
		$is_company = $customer[10];
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($valid_to) == 0) {
			$valid_to = null;
		}
		if (strlen($contract_path) == 0) {
			$contract_path = null;
		}
		if (strlen($suspend_from) == 0) {
			$suspend_from = null;
		}
		if (strlen($suspend_to) == 0) {
			$suspend_to = null;
		}
		if ($is_active == 't') {
			$is_active = true;
		} else {
			$is_active = false;
		}
		
		if (strlen($other_info) == 0) {
			$other_info = null;
		}

		
		$types = array("integer","integer","decimal","integer","date","date","text","date","date","boolean","text");

		$statement = $db->prepare('insert into contracts (customer_id,plan_id,mountly_fee,owner_id,valid_from,valid_to,contract_path,suspend_from,suspend_to,is_active,other_info) values(?,?,?,?,?,?,?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->insertContract(): fail prepare');
		}

		$data = array($customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active,$other_info);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->insertContract(): fail execute');
		}
		
		
		//customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id order by contract.id desc limit 1 
		$contratLast = $this->getContractLast();
		if ($contratLast[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contratLast[12]}<br />Planas: {$contratLast[27]} {$contratLast[28]} / {$contratLast[29]}<br />Savininkas: {$contratLast[22]} {$contratLast[23]}<br />Kaina už mėn. (Lt) {$contratLast[13]}<br />Sutarties pradžia: {$contratLast[14]}<br />Sutarties pabaiga: {$contratLast[15]} <br />Atjungta nuo: {$contratLast[17]} <br />Atjungta iki: {$contratLast[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contratLast[32]}</td></tr></table>";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties registracija (fizinis asmuo)",
			"<b>Klientas</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sutartį įvedė: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties registracija (įmonė)",
			"<b>Klientas</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sutartį įvedė: {$_SESSION['admin']}",
			"",
			""
			);
		}
		

	}	
	
	
	/**
	*Atnaujinami sutarties duomenys
	*@param Integer $contract_id Sutarties identifikacinis numeris, kuriai atnaujinami duomenys
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $plan_id Apmokęstinimo plano identifikacinis numeris
	*@param Numeric $mountly_fee Mėnesinis mokęstis
	*@param Integer $owner_id Savininko identifikacinis numeris
	*@param Date $valid_from Sutarties galiojimo pradžia
	*@param Date $valid_to Sutarties galiojimo pabaiga (null - neterminuota)
	*@param String $contract_path Kelias iki sutarties failo
	*@param Date $suspend_from Sutartis pristabdymo pradžia
	*@param Date $suspend_to Sutartis pristabdymo pabaiga (null - neterminuotai)
	*@param Boolean $is_active Ar aktyvi sutartis: true - aktyvi, false - nutraukta
	*@param String $other_info Papildoma sutarties informacija

	*/
	public function updateContract($contract_id,$customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active,$other_info)
	{
		$customer = $this->getCustomer($customer_id);
		$is_company = $customer[10];
		$contract = $this->getCustomerContract($contract_id);
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($valid_to) == 0) {
			$valid_to = null;
		}
		if (strlen($contract_path) == 0) {
			$contract_path = null;
		}
		if (strlen($suspend_from) == 0) {
			$suspend_from = null;
		}
		if (strlen($suspend_to) == 0) {
			$suspend_to = null;
		}
		if ($is_active == 't') {
			$is_active = true;
		} else {
			$is_active = false;
		}
		
		if (strlen($other_info) == 0) {
			$other_info = null;
		}
		

		
		$types = array("integer","integer","decimal","integer","date","date","text","date","date","boolean","text","integer");

		$statement = $db->prepare('update contracts set customer_id=?,plan_id=?,mountly_fee=?,owner_id=?,valid_from=?,valid_to=?,contract_path=?,suspend_from=?,suspend_to=?,is_active=?,other_info=? where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->updateContract(): fail prepare');
		}

		$data = array($customer_id,$plan_id,$mountly_fee,$owner_id,$valid_from,$valid_to,$contract_path,$suspend_from,$suspend_to,$is_active,$other_info,$contract_id);
		
		$resultset = $statement->execute($data);

		$contractNew = $this->getCustomerContract($contract_id);
		if ($contractNew[19] == 't') {
			$statusasNew = "Galioja";
		} else {
			$statusasNew = "Nutraukta";
		}
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "Sutarties nr.: {$contract[12]}\nPlanas: {$contract[27]} {$contract[28]} / {$contract[29]}\nSavininkas: {$contract[22]} {$contract[23]}\nKaina eur/mėn.: {$contract[13]}\nSutarties pradžia: {$contract[14]}\nSutarties pabaiga: {$contract[15]} \nAtjungta nuo: {$contract[17]} \nAtjungta iki: {$contract[18]} \nStatusas: $statusas\nPapildoma informacija: \n{$contract[34]}";
		
		$contratsHTMLNew = "Sutarties nr.: {$contractNew[12]}\nPlanas: {$contractNew[27]} {$contractNew[28]} / {$contractNew[29]}\nSavininkas: {$contractNew[22]} {$contractNew[23]}\nKaina eur/mėn.: {$contractNew[13]}\nSutarties pradžia: {$contractNew[14]}\nSutarties pabaiga: {$contractNew[15]} \nAtjungta nuo: {$contractNew[17]} \nAtjungta iki: {$contractNew[18]} \nStatusas: $statusasNew\nPapildoma informacija: \n{$contractNew[34]}";
		
		if ($is_company == 'f') {
			$telegram = "<b>Sutarties atnaujinimas (fizinis asmuo)</b>\n<b>Klientas</b>\nVardas: $customer[4]\nPavardė: $customer[5]\nAsmens kodas: $customer[2]\nAdresas: $customer[6]\nTelefonas: $customer[7]\nVartotojo vardas: $customer[8]\nSlaptažodis:$customer[9]\n\n<b>Prieš keitimą Sutartis:</b>\n$contratsHTML\n\n<b>Po keitimo Sutartis:</b>\n$contratsHTMLNew\n\n<b>Sutartį atnaujino: {$_SESSION['admin']}</b>";
			$telegram = urlencode($telegram);
		} else {
			$telegram = "<b>Sutarties atnaujinimas (įmonė)</b>\n<b>Klientas</b> \nĮmonės pavadinimas: ".$customer[1]."\nĮmonės kodas: ".$customer[2]."\nKontaktinio asmens vardas: ".$customer[4]."\nKontaktinio asmens pavardė: ".$customer[5]."\nAdresas: ".$customer[6]."\nTelefonas: ".$customer[7]."\nVartotojo vardas: ".$customer[8]."\nSlaptažodis:".$customer[9]." \n \n<b>Prieš keitimą Sutartis:</b>\n".$contratsHTML."\n\n<b>Po keitimo Sutartis:</b> \n".$contratsHTMLNew."\n\n<b>Sutartį atnaujino: {$_SESSION['admin']}</b>";
			$telegram = urlencode($telegram);
		}
		$this->sendTelegram($telegram);
	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->updateContract(): fail execute');
		}
		

	}	
	
	
	/**
	*Gražinami visų klientui priklausančių sutarčių duomenų masyvas
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array visų klientui priklausančių sutarčių duomenų masyvas
	*/

	public function getCustomerContracts($customer_id)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end),contracts.other_info from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and customers.id='.$customer_id.' order by contracts.id');
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerContracts()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Pašalinimas klientas iš duomenų bazės
	*@param Integer $id Kliento identifikacinis numeris
	*@param Array $contracts Klientui priklausančio sutartys
	*/
	public function deleteCustomer($id,$contracts)
	{
		$customer = $this->getCustomer($id);
		$is_company = $customer[10];
		//echo "type".$is_company;
//select id,company_name,code,vat_code,name,surname,address,phone,username,password,is_company,registred from customers where id='.$id);
		

		
		
		//customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end) from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and customers.id='.$customer_id.' order by contracts.id');
		
		$contratsHTML = "<table>\n";
		
//select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where contract_id='.$contract_id);
		
		for ($i = 0; $i < count($contracts); $i++) {
			@unlink($contracts[$i][16]);
		    if ($contracts[$i][19] == 't') {
		    	$statusas = "Galioja";
		    } else {
		    	$statusas = "Nutraukta";
		    }
			$contratsHTML .="<tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contracts[$i][12]}<br />Planas: {$contracts[$i][27]} {$contracts[$i][28]} / {$contracts[$i][29]}<br />Savininkas: {$contracts[$i][22]} {$contracts[$i][23]}<br />Kaina už mėn. (Lt) {$contracts[$i][13]}<br />Sutarties pradžia: {$contracts[$i][14]}<br />Sutarties pabaiga: {$contracts[$i][15]} <br />Atjungta nuo: {$contracts[$i][17]} <br />Atjungta iki: {$contracts[$i][18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contracts[$i][34]}</td><td>";
			$addresses = $this->getAddresses($contracts[$i][12]);
			for ($j = 0; $j < count($addresses); $j++) {
				$contratsHTML .= "\n<table>\n";
				$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>{$addresses[$j][1]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Subnet mask:</td><td>{$addresses[$j][2]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Gateway:</td><td>{$addresses[$j][3]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>{$addresses[$j][4]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>{$addresses[$j][5]}</td></tr>\n";
				$contratsHTML .= "<tr><td>MAC adresas:</td><td>{$addresses[$j][8]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>{$addresses[$j][6]}</td></tr>\n";
				$contratsHTML .= "</table>\n<br />";
				
			}
			$contratsHTML .="</td></tr>\n<tr><td colspan=\"2\">&nbsp;</td></tr>\n";
		}
		$contratsHTML .= "</table>";
		
		$types = array("integer");

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$statement = $db->prepare('delete from customers where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteCustomer(): fail prepare');
		}

		$data = array($id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getCode();
			
			echo "<script language='javascript'>this.location = 'customer_detail.php?id=$id&deletefail=1'</script>";
			die('Kritinė klaida: Customer->deleteCustomer(): fail execute');
		}

		
		
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento pašalinimas (fizinis asmuo)",
			"Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Automatiškai pašalintos sutartys:</b> <br /><br />$contratsHTML<br /><br />Pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Kliento pašalinimas (įmonė)",
			"Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Automatiškai pašalintos sutartys:</b> <br /><br />$contratsHTML<br /><br />Pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}

	}	
	
	
	/**
	*Pašalinimas klientas iš duomenų bazės
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@param String $file Kelias iki sutarties failo kurį reikia ištrinti
	*/
	public function deleteContractFile($customer_id,$contract_id,$file)
	{
		$customer = $this->getCustomer($customer_id);
		$is_company = $customer[10];
		$contract = $this->getCustomerContract($contract_id);
		
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		@unlink($file);
		

		
		$types = array("integer");

		$statement = $db->prepare('update contracts set contract_path=null where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteContractFile(): fail prepare');
		}

		$data = array($contract_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->deleteContractFile(): fail execute');
		}
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}

		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Pašalintas failas: <b>$file</b><br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties failo pašalinimas (fizinis asmuo)",
			"<b>Klientas</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sutarties failą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties failo pašalinimas (įmonė)",
			"<b>Klientas</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sutarties failą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}
		

	}	
	
	
	
	/**
	*Pašalinima kliento sutartis
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@param String $file Kelias iki sutarties failo kurį reikia ištrinti
	*/
	public function deleteContract($customer_id,$contract_id,$file)
	{
		$customer = $this->getCustomer($customer_id);
		$is_company = $customer[10];
		$contract = $this->getCustomerContract($contract_id);
		
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		



			$contratsHTML .="<table>\n<tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td><td>";
			$addresses = $this->getAddresses($contract_id);
			for ($j = 0; $j < count($addresses); $j++) {
				$contratsHTML .= "\n<table>\n";
				$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>{$addresses[$j][1]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Subnet mask:</td><td>{$addresses[$j][2]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Gateway:</td><td>{$addresses[$j][3]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>{$addresses[$j][4]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>{$addresses[$j][5]}</td></tr>\n";
				$contratsHTML .= "<tr><td>MAC adresas:</td><td>{$addresses[$j][8]}</td></tr>\n";
				$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>{$addresses[$j][6]}</td></tr>\n";
				$contratsHTML .= "</table>\n<br />";
				
			}

		$contratsHTML .= "</table>";
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		@unlink($file);
		

		
		$types = array("integer");

		$statement = $db->prepare('delete from contracts where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteContract(): fail prepare');
		}

		$data = array($contract_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			echo "<script language='javascript'>this.location = 'contract_detail.php?id=$contract_id&deletefail=1'</script>";
			
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->deleteContract(): fail execute');
		}
		

		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties pašalinimas (fizinis asmuo)",
			"Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Pašalinta sutartis:</b> <br /><br />$contratsHTML<br /><br />Pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Sutarties pašalinimas (įmonė)",
			"Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Pašalinta sutartis:</b> <br /><br />$contratsHTML<br /><br />Pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}

		

	}	
	
	
	


	/**
	*Gražinamas klientui priklausančios sutarties duomenų masyvas
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@return Array klientui priklausančios sutarties duomenų masyvas
	*/

	public function getCustomerContract($contract_id)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end),contracts.other_info from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and contracts.id='.$contract_id.' order by contracts.id');
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerContract()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
		
	}
	
	/**
	*
	*
	*Tikrinamas ipv4 adresas
	*@param String $ipv4 adresas
	*@return Boolean true - valid $ipv4, false - Invalid
	*/
	public function checkIPv4($ipv4)
	{
		$ipv4 = trim($ipv4);
		if (strlen($ipv4) == 0) return false; 
		
		if (!preg_match( "/^(([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5]).){3}([1-9]?[0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$/", $ipv4)) {
			return false;
		} else {
			return true;
		}
	}
	
	
	/**
	*
	*
	*Tikrinamas MAC adresas
	*@param String $mac adresas
	*@return Boolean true - valid $mac, false - Invalid
	*/
	public function checkMAC($mac)
	{
		$mac = trim($mac);
		if (strlen($mac) == 0) return false; 
		
		if (!preg_match( "/^([0-9a-fA-F]{2}[:-]){5}[0-9a-fA-F]{2}$/i", $mac)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*Įterpiamas naujas IPv4 adresas į duomenų bazę
	*@param String $ipv4 IPv4 adresas 
	*@param String $subnet Subnet mask adresas
	*@param String $gateway Gateway adresas
	*@param String $dns1 Pagrindinio DNS serverio adresas
	*@param String $dns2 Antrinio DNS serverio adresas
	*@param String $other Papildoma tinklo informacija
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@param String $mac Tinklo plokštės MAC adresas
	*/
	public function insertAddress($ipv4,$subnet,$gateway,$dns1,$dns2,$other,$contract_id,$mac)
	{
		$contract = $this->getCustomerContract($contract_id);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($dns2) == 0) {
			$dns2 = null;
		}
		
		if (strlen($other) == 0) {
			$other = null;
		}


		
		$types = array("text","text","text","text","text","text","integer","text");

		$statement = $db->prepare('insert into network_info (ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address) values (?,?,?,?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->insertAddress(): fail prepare');
		}

		$data = array($ipv4,$subnet,$gateway,$dns1,$dns2,$other,$contract_id,$mac);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->insertAddress(): fail execute');
		}
		
		
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		
		
		$contratsHTML .= "<br /><b>Įvesti tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>$ipv4</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>$subnet</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>$gateway</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>$dns1</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>$dns2</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>$mac</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>$other</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Įvesti tinklo duomenys (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis įvedė: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Įvesti tinklo duomenys (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis įvedė: {$_SESSION['admin']}",
			"",
			""
			);
		}
	}

	
	/**
	*Gražinami visi sutarčiai priklausantys IPv4 adresai
	*@param Integer $contract_id sutarties identifikacinis numeris
	*@return Array visi sutarčiai priklausantys IPv4 adresai
	*/

	public function getAddresses($contract_id)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where contract_id='.$contract_id);
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getAddresses()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas adresas
	*@param Integer $address_id adreso identifikacinis numeris
	*/

	public function getAddress($address_id)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where id='.$address_id);
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getAddress()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
		
	}
	
	/**
	*Pašalinima IPv4 adresas
	*@param Integer $address_id adreso identifikacinis numeris
	*/
	public function deleteAddress($address_id)
	{
		$address = $this->getAddress($address_id);

		$contract = $this->getCustomerContract($address[7]);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];	
		
	
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		
		

		
		$types = array("integer");

		$statement = $db->prepare('delete from network_info where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteAddress(): fail prepare');
		}

		$data = array($address_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->deleteAddress(): fail execute');
		}
		
		
	
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		//select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where id='.$address_id);
		
		
		$contratsHTML .= "<br /><b>Pašalinti tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>{$address[1]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>{$address[2]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>{$address[3]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>{$address[4]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>{$address[5]}</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>{$address[8]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>{$address[6]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		

		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pašalinti tinklo duomenys (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pašalinti tinklo duomenys (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}

		
	}
	
	
	/**
	*Atnaujinamas IPv4 adresas duomenų bazėje
	*@param Integer $id Atnaujinamo adreso identifikacinis numeris
	*@param String $ipv4 IPv4 adresas 
	*@param String $subnet Subnet mask adresas
	*@param String $gateway Gateway adresas
	*@param String $dns1 Pagrindinio DNS serverio adresas
	*@param String $dns2 Antrinio DNS serverio adresas
	*@param String $other Papildoma tinklo informacija
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@param String $mac MAC adresas
	*/
	public function updateAddress($id,$ipv4,$subnet,$gateway,$dns1,$dns2,$other,$contract_id,$mac)
	{

		$contract = $this->getCustomerContract($contract_id);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];	
		
		$oldAddress = $this->getAddress($id);	
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($dns2) == 0) {
			$dns2 = null;
		}
		
		if (strlen($other) == 0) {
			$other = null;
		}


		
		$types = array("text","text","text","text","text","text","integer","text","integer");

		$statement = $db->prepare('update network_info set ip=?,mask=?,gateway=?,dns1=?,dns2=?,other_info=?,contract_id=?,mac_address=?  where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->updateAddress(): fail prepare');
		}

		$data = array($ipv4,$subnet,$gateway,$dns1,$dns2,$other,$contract_id,$mac,$id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->updateAddress(): fail execute');
		}
		
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		//select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where id='.$address_id);
		
		
		$contratsHTML .= "<br /><b>Prieš keitimą tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>{$oldAddress[1]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>{$oldAddress[2]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>{$oldAddress[3]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>{$oldAddress[4]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>{$oldAddress[5]}</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>{$oldAddress[8]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>{$oldAddress[6]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		

		$contratsHTML .= "<br /><b>Po keitimo tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>$ipv4</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>$subnet</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>$gateway</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>$dns1</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>$dns2</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>$mac</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>$other</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pakeisti tinklo duomenys (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pakeitė: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pakeisti tinklo duomenys (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pakeitė: {$_SESSION['admin']}",
			"",
			""
			);
		}
		

	}
	
	
	/**
	*Atnaujinamas IPv4 adresas duomenų bazėje
	*@param Integer $id Atnaujinamo adreso identifikacinis numeris
	*@param String $ipv4 IPv4 adresas 
	*@param String $subnet Subnet mask adresas
	*@param String $gateway Gateway adresas
	*@param String $dns1 Pagrindinio DNS serverio adresas
	*@param String $dns2 Antrinio DNS serverio adresas
	*@param String $other Papildoma tinklo informacija
	*@param String $mac MAC adresas
	*/
	public function updateAddressWithoutContract($id,$ipv4,$subnet,$gateway,$dns1,$dns2,$other,$mac)
	{
		$oldAddress = $this->getAddress($id);	
		
		$contract = $this->getCustomerContract($oldAddress[7]);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];	
		
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($dns2) == 0) {
			$dns2 = null;
		}
		
		if (strlen($other) == 0) {
			$other = null;
		}


		
		$types = array("text","text","text","text","text","text","text","integer");

		$statement = $db->prepare('update network_info set ip=?,mask=?,gateway=?,dns1=?,dns2=?,other_info=?,mac_address=?  where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->updateAddressWithoutContract(): fail prepare');
		}

		$data = array($ipv4,$subnet,$gateway,$dns1,$dns2,$other,$mac,$id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->updateAddress(): fail execute');
		}
		
		
		
			if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		//select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where id='.$address_id);
		
		
		$contratsHTML .= "<br /><b>Prieš keitimą tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>{$oldAddress[1]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>{$oldAddress[2]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>{$oldAddress[3]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>{$oldAddress[4]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>{$oldAddress[5]}</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>{$oldAddress[8]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>{$oldAddress[6]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		

		$contratsHTML .= "<br /><b>Po keitimo tinklo duomenys:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>IPv4 adresas:</td><td>$ipv4</td></tr>\n";
		$contratsHTML .= "<tr><td>Subnet mask:</td><td>$subnet</td></tr>\n";
		$contratsHTML .= "<tr><td>Gateway:</td><td>$gateway</td></tr>\n";
		$contratsHTML .= "<tr><td>Pirminis DNS serveris:</td><td>$dns1</td></tr>\n";
		$contratsHTML .= "<tr><td>Antrinis DNS serveris:</td><td>$dns2</td></tr>\n";
		$contratsHTML .= "<tr><td>MAC adresas:</td><td>$mac</td></tr>\n";
		$contratsHTML .= "<tr><td>Papildoma informacija:</td><td>$other</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pakeisti tinklo duomenys (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pakeitė: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email>",
			"BITNET <$this->email>",
			"Pakeisti tinklo duomenys (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Tinklo duomenis pakeitė: {$_SESSION['admin']}",
			"",
			""
			);
		}
		
	}
	
	
	/**
	*Gražinamas sutarčių sąrašas pagal paieškos sąlygas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš contracts lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@return Array sutarčių duomenų masyvas
	*/

	public function getCustomerContractsBySearch($offset,$limit,$search,$type,$owner_id,$valid,$not_valid,$suspended,$broken)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		$sql = " and (";
		
		if ($broken == 'on') {
			//echo strlen($sql)."broken". " ".$sql."<br />";
			
			$sql .= "contracts.is_active=false";
		} 
		
		if ($valid == 'on') {
			//echo strlen($sql)."valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			
			$sql .= " (coalesce((valid_from<now()  and valid_to> now()),true) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ))";
			
		} 
		
		if ($not_valid == 'on') {
			//echo strlen($sql)."not valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= " ((coalesce((valid_to< now()),false) or valid_from> now()) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ) )";
		} 
		
		if ($suspended == 'on') {
			//echo strlen($sql)."suspended". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= "  (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  )";
		} 
		
		$sql .= ") ";
		
		if (strlen($sql) == 8) {
			$sql = "";
		}
		
		
		

		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end) from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$sql.' order by contracts.id limit '.$limit.' offset '.$offset );
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerContracts()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sutarčių kiekis pagal paieškos sąlygas
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@return Array sutarčių kiekis
	*/

	public function getCustomerContractsBySearchCount($search,$type,$owner_id,$valid,$not_valid,$suspended,$broken)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		$sql = " and (";
		
		if ($broken == 'on') {
			//echo strlen($sql)."broken". " ".$sql."<br />";
			
			$sql .= "contracts.is_active=false";
		} 
		
		if ($valid == 'on') {
			//echo strlen($sql)."valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			
			$sql .= " (coalesce((valid_from<now()  and valid_to> now()),true) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ))";
			
		} 
		
		if ($not_valid == 'on') {
			//echo strlen($sql)."not valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= " ((coalesce((valid_to< now()),false) or valid_from> now()) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ) )";
		} 
		
		if ($suspended == 'on') {
			//echo strlen($sql)."suspended". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= "  (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  )";
		}
		
		$sql .= ") ";
		
		if (strlen($sql) == 8) {
			$sql = "";
		}
		//$sql = "";
		
		//(coalesce((valid_from<now() and valid_to> now()),true) and contracts.is_active=true) 
		
		
		
//echo $sql;
		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(customers.id) from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$sql.'' );
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerContractsBySearchCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		} else {
			return 0;
		}
	}
	
	
	/**
	*Gražinamas sutarčių uždirbamų pinigų per menėsį pagal sąvininkus masyvas
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@return Array sutarčių uždirbamų pinigų per menėsį pagal sąvininkus masyvas
	*/

	public function getCustomerContractsBySearchMoney($search,$type,$owner_id,$valid,$not_valid,$suspended,$broken)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		$sql = " and (";
		
		if ($broken == 'on') {
			//echo strlen($sql)."broken". " ".$sql."<br />";
			
			$sql .= "contracts.is_active=false";
		} 
		
		if ($valid == 'on') {
			//echo strlen($sql)."valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			
			$sql .= " (coalesce((valid_from<now()  and valid_to> now()),true) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ))";
			
		} 
		
		if ($not_valid == 'on') {
			//echo strlen($sql)."not valid". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= " ((coalesce((valid_to< now()),false) or valid_from> now()) and contracts.is_active=true and not (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  ) )";
		} 
		
		if ($suspended == 'on') {
			//echo strlen($sql)."suspended". " ".$sql."<br />";
			if (strlen($sql) != 6) {
				$sql .= " or ";
			}
			$sql .= "  (coalesce(suspend_from<now(),false) and   coalesce(suspend_to>now(),true)  and contracts.is_active=true  )";
		}
		
		$sql .= ") ";
		
		if (strlen($sql) == 8) {
			$sql = "";
		}
		//$sql = "";
		
		//(coalesce((valid_from<now() and valid_to> now()),true) and contracts.is_active=true) 
		
		
		
//echo $sql;
		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select owners.id,owners.name,owners.surname, sum(contracts.mountly_fee) from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$sql.'   group by owners.id,owners.name,owners.surname order by owners.id' );
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerContractsBySearchMoney()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas klientų turinčių aktyvių sutartčių masyvas
	*@param Integer $owner_id Savininko identifikacinis numeris
	*@return Array  klientų turinčių aktyvių sutartčių masyvas
	*/

	public function getActiveCustomers($owner_id)
	{
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if (@strlen($owner_id) > 0) {
			$owner_id = ' and owners.id='.$owner_id;
		} else {
			$owner_id = '';
		}
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred from customers,contracts,owners where customers.id=contracts.customer_id and owners.id=contracts.owner_id and contracts.is_active=true '.$owner_id.' group by customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred  order by customers.company_name,customers.name');
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getActiveCustomers()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas klientų turinčių aktyvių sutartčių masyvas
	*@param Integer $owner_id Savininko identifikacinis numeris
	*@return Array  klientų turinčių aktyvių sutartčių masyvas
	*/

	public function getActiveCustomersBySwedbankPaymentDescription($search,$seachByPaymentDescription)
	{
		
		$seachByPaymentDescription = mb_convert_case($seachByPaymentDescription, MB_CASE_LOWER, "UTF-8"); //Padarom mazosiom
		//$seachByPaymentDescription = preg_replace("/[^\W\d]*\d\w*/u", "",$seachByPaymentDescription); //Ismetam zodzius kuriuose yra skaiciu
		//$seachByPaymentDescription = preg_replace("/internet\w*/u", "",$seachByPaymentDescription); //ismetam zodzius kuriuose yra zodis internet, zemesni pan.
		//$seachByPaymentDescription = preg_replace("/tv\s+/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/televiz\w*/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/uz\s+/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/už\s+/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/ir\s+/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/pagal\s+/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/sutart\w*/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/nr\.*w*/u", "",$seachByPaymentDescription);
		//$seachByPaymentDescription = preg_replace("/\//u", "",$seachByPaymentDescription);
		$seachByPaymentDescription = preg_replace("/\s+/u", " ",$seachByPaymentDescription);
		$seachByPaymentDescription = preg_replace("/\'*\"*/u", "",$seachByPaymentDescription);
		
		
		//$seachByPaymentDescriptionArr = preg_split("/[\s]+/", $seachByPaymentDescription);
		
//'asdas 12w1mindaugas briedisa ' like  '%'||lower(customers.name)||' '||lower(customers.surname)||'%' ;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if (@strlen($owner_id) > 0) {
			$owner_id = ' and owners.id='.$owner_id;
		} else {
			$owner_id = '';
		}
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,ROUND(contracts.mountly_fee,2) from customers,contracts,owners where customers.id=contracts.customer_id and owners.id=contracts.owner_id and    (lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(\''.$search.'\') like  \'%\'||lower(customers.name)||\' \'||lower(customers.surname)||\'%\'  or   lower(customers.name)||\' \'||lower(customers.surname) like lower(\'%'.$search.'%\') or lower(\''.$search.'\') like  \'%\'||lower(customers.surname)||\' \'||lower(customers.name)||\'%\'  or lower(customers.surname)||\' \'||lower(customers.name) like lower(\'%'.$search.'%\')   or \''.$seachByPaymentDescription.'\' like  \'%\'||lower(customers.name)||\' \'||lower(customers.surname)||\'%\' or \''.$seachByPaymentDescription.'\' like  \'%\'||lower(customers.surname)||\' \'||lower(customers.name)||\'%\' or \''.$seachByPaymentDescription.'\' like  \'%\'|| translate(lower(customers.name), \'ą,č,ę,ė,į,š,ų,ū,ž\', \'a,c,e,e,i,s,u,u,z\')||\' \'||translate(lower(customers.surname), \'ą,č,ę,ė,į,š,ų,ū,ž\', \'a,c,e,e,i,s,u,u,z\')||\'%\' or \''.$seachByPaymentDescription.'\' like  \'%\'||customers.code||\'%\')      order by customers.company_name,customers.name');
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			echo $seachByPaymentDescription;
			die('Kritinė klaida: Customer->getActiveCustomersBySwedbankPaymentDescription()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	
	/**
	*Gražinamas kliento sutarčių masyvas
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array  kliento sutarčių masyvas
	*/

	public function getActiveCustomersContracts($customer_id)
	{
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select contracts.id,contracts.plan_id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.suspend_from,contracts.suspend_to, plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,customers.is_company from contracts,plans,customers where contracts.customer_id=customers.id and contracts.plan_id=plans.id and customers.id='.$customer_id.' order by contracts.mountly_fee');
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getActiveCustomersContracts()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	//select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end) from customers,contracts,owners,plans where customers.id=contracts.customer_id
	
	/**
	*Aktyvios sutarties masyvas
	*@param Integer $contract_id Aktyvios sutarties masyvas
	*@return Array  aktyvios sutarties masyvas
	*/

	public function getActiveContract($contract_id)
	{
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,contracts.other_info,0,0,0,0,0,0,0,0,0,0,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end) from customers,contracts where customers.id=contracts.customer_id and contracts.id='.$contract_id);
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getActiveContract()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
	}
	
	
	/**
	*Įterpiama sąskaitą į duomenų bazę
	*@param Numeric(8;2) $quantity Sąskaitos suma
	*@param Integer $contract_id Sutarties identifikacinis numeris
	*@param Date $inv_date Sąskaitos išrašymo data
	*@param String $inv_path Kelias iki sąskaitos
	*@param String $purpose Mokėjimo paskirtis
	*/
	public function insertInvoice($quantity,$contract_id,$inv_date,$inv_path,$purpose)
	{
		$contract = $this->getCustomerContract($contract_id);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];	
		
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($inv_path) == 0) {
			$inv_path = null;
		}
		
		if (strlen($purpose) == 0) {
			$purpose = null;
		}
	

		
		$types = array("decimal","integer","date","text","text");

		$statement = $db->prepare('insert into invoices (quantity,contract_id,inv_date,inv_path,purpose) values (?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->insertInvoice(): fail prepare');
		}

		$data = array($quantity,$contract_id,$inv_date,$inv_path,$purpose);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->insertInvoice(): fail execute');
		}
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		//select id,ip,mask,gateway,dns1,dns2,other_info,contract_id,mac_address from network_info where id='.$address_id);
		
		$inv = $this->getInvoiceLast();
		$contratsHTML .= "<br /><b>Išrašyta sąskaita:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>Sąskaitos numeris:</td><td>{$inv[32]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos suma:</td><td>{$quantity} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos išrašymo data:</td><td>{$inv_date}</td></tr>\n";
		$contratsHTML .= "<tr><td>Mokėjimo paskirtis:</td><td>{$purpose}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Išrašyta sąskaita (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą išrašė: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Išrašyta sąskaita (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą išrašė: {$_SESSION['admin']}",
			"",
			""
			);
		}
		
	}

	
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš invoices lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesBySearch($offset,$limit,$search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and (invoices.payment_quantity=0 or invoices.quantity > invoices.payment_quantity)";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' order by invoices.id limit '.$limit.' offset '.$offset ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearch()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas
	*@param Integer $contractID Sutarties identifikacinis numeris
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesByContractID($contractID)
	{		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select contracts.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and contracts.id='.$contractID.' order by invoices.id'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesByContractID()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas sugrupuoti pagal kliento asmeninis duomenis
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš invoices lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesBySearchGrouped($offset,$limit,$search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and (invoices.payment_quantity=0 or invoices.quantity > invoices.payment_quantity)";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' group by customers.id order by customers.id limit '.$limit.' offset '.$offset ); 
		
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearchGrouped()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas sugrupuoti pagal sutarties ID
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš invoices lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesBySearchGroupedByContractID($offset,$limit,$search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and (invoices.payment_quantity=0 or invoices.quantity > invoices.payment_quantity)";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select contracts.id from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' group by contracts.id order by contracts.id limit '.$limit.' offset '.$offset ); 
		
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearchGroupedByContractID()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas sugrupuoti pagal kliento asmeninis duomenis
	*@param Integer $contractID Sutarties identifikacinis numeris
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesGroupedByContractID($contractID)
	{
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		//echo 'select contracts.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and  contracts.id='.$contractID.' group by contracts.id order by contracts.id ';
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and  contracts.id='.$contractID.' group by customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred order by customers.id '); 
		
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesGroupedByContractID()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		
		return $data;
	}
	
	
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš invoices lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@param Integer $customer_id  Kliento identifikacinis numeris
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesBySearchByCustomer($offset,$limit,$search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount,$customer_id)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and (invoices.payment_quantity=0 or invoices.quantity > invoices.payment_quantity)";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
		
		
		
		
		
		
		
		
		
		

		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\'))) and customers.id='.$customer_id.'  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' order by invoices.id limit '.$limit.' offset '.$offset ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearch()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	
	
	

	
	
	
	
	
	/**
	*Gražinamas sąskaitų pinigai pagal savininkus
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Array sąskaitų pinigai pagal savininkus
	*/

	public function getCustomerInvoicesMoney($search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and invoices.payment_quantity=0";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
		
		
		
		
		
		
		

		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select owners.id,owners.name,owners.surname,sum(invoices.quantity),sum(invoices.payment_quantity),sum(contracts.mountly_fee) from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' group by owners.id,owners.name,owners.surname order by owners.id ' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesMoney()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų pinigai pagal paieškos sąlygas
	*@param Integer $contractID Sutarties identifikacinis numeris
	*@return Array sąskaitų pinigai pagal paieškos sąlygas
	*/

	public function getCustomerInvoicesMoneyByContractID($contractID)
	{		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select owners.id,owners.name,owners.surname,sum(invoices.quantity),sum(invoices.payment_quantity),sum(contracts.mountly_fee) from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and contracts.id='.$contractID.' group by owners.id,owners.name,owners.surname order by owners.id ' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesMoneyByContractID()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas kiekis

	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Integer sąskaitų sąrašas pagal paieškos sąlygas kiekis
	*/

	public function getCustomerInvoicesBySearchCount($search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and invoices.payment_quantity=0";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
		
		
		
		
		
		
		

		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(invoices.id) from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearchCount()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas kiekis

	*@param Integer $contractID Sutarties identifikacinis numeris
	*@return Integer sąskaitų sąrašas pagal paieškos sąlygas kiekis
	*/

	public function getCustomerInvoicesCountByContractID($contractID)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(invoices.id) from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and contracts.id='.$contractID); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesCountByContractID()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		} else {
			return 0;
		}
	}
	
	


	
	/**
	*Gražinama sąskaita
	*@param Integer $invoice_id sąskaitos identifikacinis numeris
	*@return Array Gražinama sąskaita
	*/

	public function getInvoice($invoice_id)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.inv_date+ interval \'15 days\',invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity,invoices.vat_inv_id,invoices.vat_oper_code from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and invoices.id='.$invoice_id ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getInvoice()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
	}
	
	/**
	*Gražinama paskutinė kliento sąskaita pagal sutarties ID
	*@param Integer $contractID sutarties identifikacinis numeris
	*@return Array Gražinama sąskaita
	*/

	public function getLastInvoiceByContract($contractID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.inv_date+ interval \'15 days\',invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity,invoices.vat_inv_id,invoices.vat_oper_code from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and invoices.contract_id='.$contractID.' order by invoices.id desc limit 1' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getInvoice()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
	}
	
	
	/**
	*Gražinamas PVM sąskaitos numeris
	*@return Integer PVM Sąskaitos numeris
	*/

	public function getVATNumber()
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select max(invoices.vat_inv_no) from invoices' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getVATNumber()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0]+1;
		}
	}
	
	
	
	
	/**
	*Pašalinimas sąskaitos failas
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $invoice_id Sąskaitos identifikacinis numeris
	*@param String $file Kelias iki sąskaitos failo kurį reikia ištrinti
	*/
	public function deleteInvoiceFile($customer_id,$invoice_id,$file)
	{
		
		
		
		$customer = $this->getCustomer($customer_id);
		$is_company = $customer[10];	
		$inv = $this->getInvoice($invoice_id);
		$contract = $this->getCustomerContract($inv[12]);
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		@unlink($file);
		

		
		$types = array("integer");

		$statement = $db->prepare('update invoices set inv_path=null where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteInvoiceFile(): fail prepare');
		}

		$data = array($invoice_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->deleteInvoiceFile(): fail execute');
		}
		
		
			if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		
		
		
		$contratsHTML .= "<br /><b>Failas pašalintas šioje sąskaitoje:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>Sąskaitos numeris:</td><td>{$inv[32]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos suma:</td><td>{$inv[33]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėta suma:</td><td>{$inv[34]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos išrašymo data:</td><td>{$inv[36]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėjimo data:</td><td>{$inv[37]}</td></tr>\n";
		$contratsHTML .= "<tr><td><b>Pašalintas failas:</b></td><td><b>{$file}</b></td></tr>\n";
		$contratsHTML .= "<tr><td>Mokėjimo paskirtis:</td><td>{$inv[39]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		

		
		
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos failo pašalinimas (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitos failą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos failo pašalinimas (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitos failą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}

		
		
	}
	
	
	
	/**
	*Atnaujinama sąskaitą 
	*@param Integer $invoice_id Sąskaitos identifikacinis numeris
	*@param Integer $contract_id sutarties identifikacinis numeris
	*@param Numeric(8;2) $quantity Sąskaitos suma
	*@param Numeric(8;2) $payment_quantity gauta apmokėjimo suma
	*@param Date $inv_date Sąskaitos išrašymo data
	*@param Date $pay_date apmokėjimo data
	*@param String $inv_path Kelias iki sąskaitos
	*@param String $purpose Mokėjimo paskirtis
	*/
	public function updateInvoice($invoice_id,$contract_id,$quantity,$payment_quantity,$inv_date,$pay_date,$inv_path,$purpose)
	{
		
		$contract = $this->getCustomerContract($contract_id);	
		$customer = $this->getCustomer($contract[0]);
		$is_company = $customer[10];	
		
		$invOld = $this->getInvoice($invoice_id);

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($inv_path) == 0) {
			$inv_path = null;
		}
		
		if (strlen($purpose) == 0) {
			$purpose = null;
		}
		if (strlen($pay_date) == 0) {
			$pay_date = null;
		}
				
		
	

		
		$types = array("decimal","decimal","date","date","text","text","integer");

		$statement = $db->prepare('update invoices set quantity=?,payment_quantity=?,inv_date=?,pay_date=?,inv_path=?,purpose=? where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->updateInvoice(): fail prepare');
		}

		$data = array($quantity,$payment_quantity,$inv_date,$pay_date,$inv_path,$purpose,$invoice_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->updateInvoice(): fail execute');
		}
		
		//32 invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.inv_date+ interval \'15 days\' from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and invoices.id='.$invoice_id );
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		
		
		$invNew = $this->getInvoice($invoice_id);
		
		$contratsHTML .= "<br /><b>Sąskaita prieš keitimą:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>Sąskaitos numeris:</td><td>{$invOld[32]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos suma:</td><td>{$invOld[33]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėta suma:</td><td>{$invOld[34]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos išrašymo data:</td><td>{$invOld[36]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėjimo data:</td><td>{$invOld[37]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Mokėjimo paskirtis:</td><td>{$invOld[39]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		$contratsHTML .= "<br /><b>Sąskaita po keitimo:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>Sąskaitos numeris:</td><td>{$invNew[32]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos suma:</td><td>{$invNew[33]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėta suma:</td><td>{$invNew[34]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos išrašymo data:</td><td>{$invNew[36]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėjimo data:</td><td>{$invNew[37]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Mokėjimo paskirtis:</td><td>{$invNew[39]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		
		
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos atnaujinimas (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą atnaujino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos atnaujinimas (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą atnaujino: {$_SESSION['admin']}",
			"",
			""
			);
		}
		
		
	}
	
	
	
		/**
	*Atnaujinama sąskaitos mokėjimo įrašas (Apmokėjimo data ir Mokėjimo suma)
	*@param Integer $invoice_id Sąskaitos identifikacinis numeris
	*@param Integer $contractID Sutarties identifikacinis numeris
	*@param Numeric(8;2) $payment_quantity gauta apmokėjimo suma
	*@param Date $pay_date apmokėjimo data
	*@param String $bank_transfer_id Banko išrašo pervedimo identifikacinis numeris
	*@param Boolean t - grynieji pinigai; f - pavedimu
	*/
	public function setPayment($invoice_id,$contractID,$payment_quantity,$pay_date,$bank_transfer_id,$useCash)
	{

		$lastID = $invoice_id;
		$payment = $payment_quantity;
		$payments = array();
		$debts = $this->getInvoicesDebt($contractID);
		$import = array();
		if ($useCash == true) {
			$useCash = true;
		} else {
			$useCash = false;
		}
		foreach ($debts as $value) {
			
			if ($payment >= $value[1]) {
				$payment = $payment - $value[1];
				$import[] = array($value[0],$value[1]);
			} elseif ($payment > 0) {
				$import[] = array($value[0],$payment);
				$payment = 0;
			}
		}
		if ($import[0][0] ==  $lastID && $payment > 0) {
			$import[0][1] += $payment;
		} elseif ($payment > 0) {
			$import[] = array($lastID,$payment);
		}
		//echo $payment;
		//echo "<pre>";
		//print_r($import);
		//echo "</pre>";


		$types = array("integer","date","decimal","text","boolean");
		 
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$db->beginTransaction();
		

		$error = 0;
		$statement = $db->prepare('insert into payments (invoice_id,pay_date,payment_quantity,bank_transfer_id,cash) values (?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$error++;
		}
			
		
		foreach($import as $item) {
			$data = array($item[0],$pay_date,$item[1],$bank_transfer_id,$useCash);
			$resultset = $statement->execute($data);

			if (PEAR::isError($resultset)) {
				$error++;
			}
		}
		
		if ($error == 0) {
			$db->commit();
			$db->disconnect();
			return 1;
		
		} else {
			$db->rollback();
			$db->disconnect();
			return 2;
		}
		
		
		
		

/*
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$types = array("integer","decimal","date");

		$statement = $db->prepare('insert into payments (invoice_id,payment_quantity,pay_date) values (?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			return false;
		}

		$data = array($invoice_id,$payment_quantity,$pay_date);
		
		//$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			return false;
		}
		return true;
	*/	
	}
	
	
	/**
	*Pašalinima sąskaita
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param Integer $invoice_id Sąskaitos identifikacinis numeris
	*@param String $file Kelias iki sąskaitos failo kurį reikia ištrinti
	*/
	public function deleteInvoice($customer_id,$invoice_id,$file)
	{
		$customer = $this->getCustomer($customer_id);
		
		
		
		$is_company = $customer[10];	
		
		$inv = $this->getInvoice($invoice_id);
		
		$contract = $this->getCustomerContract($inv[12]);
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		@unlink($file);
		

		
		$types = array("integer");

		$statement = $db->prepare('delete from invoices where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->deleteInvoice(): fail prepare');
		}

		$data = array($invoice_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->deleteInvoice(): fail execute');
		}
		
		
		if ($contract[19] == 't') {
			$statusas = "Galioja";
		} else {
			$statusas = "Nutraukta";
		}
		$contratsHTML = "<table><tr><td valign=\"top\" width=\"280\">Sutarties nr.:{$contract[12]}<br />Planas: {$contract[27]} {$contract[28]} / {$contract[29]}<br />Savininkas: {$contract[22]} {$contract[23]}<br />Kaina už mėn. (Lt) {$contract[13]}<br />Sutarties pradžia: {$contract[14]}<br />Sutarties pabaiga: {$contract[15]} <br />Atjungta nuo: {$contract[17]} <br />Atjungta iki: {$contract[18]} <br />Statusas: $statusas<br />Papildoma informacija: <br />{$contract[34]}</td></tr></table>";

		
		
		
		$contratsHTML .= "<br /><b>Pašalinta sąskaita:</b><br /><br />\n<table>\n";
		$contratsHTML .= "<tr><td>Sąskaitos numeris:</td><td>{$inv[32]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos suma:</td><td>{$inv[33]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėta suma:</td><td>{$inv[34]} Lt</td></tr>\n";
		$contratsHTML .= "<tr><td>Sąskaitos išrašymo data:</td><td>{$inv[36]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Apmokėjimo data:</td><td>{$inv[37]}</td></tr>\n";
		$contratsHTML .= "<tr><td>Mokėjimo paskirtis:</td><td>{$inv[39]}</td></tr>\n";
		$contratsHTML .= "</table>\n<br />";
		

		
		
		
		if ($is_company == 'f') {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos pašalinimas (fizinis asmuo)",
			"<b>Klientas:</b> <br /><br />Vardas: $customer[4]<br />Pavardė: $customer[5]<br />Asmens kodas: $customer[2]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		} else {
			$this->UTF8_mail(
			"BITNET <$this->email1>",
			"BITNET <$this->email1>",
			"Sąskaitos pašalinimas (įmonė)",
			"<b>Klientas:</b> <br /><br />Įmonės pavadinimas: $customer[1]<br />Įmonės kodas: $customer[2]<br />Kontaktinio asmens vardas: $customer[4]<br />Kontaktinio asmens pavardė: $customer[5]<br />Adresas: $customer[6]<br />Telefonas: $customer[7]<br />Vartotojo vardas: $customer[8]<br />Slaptažodis:$customer[9] <br /><br /><b>Sutartis:</b> <br /><br />$contratsHTML<br /><br />Sąskaitą pašalino: {$_SESSION['admin']}",
			"",
			""
			);
		}
		
		
		
		

		
	}	
	
	
	public function destroySession() {
		session_start();
		$_SESSION = array();
		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(), '', time()-42000, '/');
		}
		session_destroy();
	}
	
	
	
	
	/**
	*
	*
	*Gražinamas kliento identifikacinis numeris pagal pateikta vartotojo vardą ir slaptažodį
	*@param String $username  pateiktas vartotojo vardas 
	*@param String $password  pateiktas slaptažodis
	*@return Integer 0 - klientas neegzistuoja, 1 ir daugiau - kliento identifikacinis numeris
	*/
	public function getCustomerID($username, $password)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		//$username = trim($username);
		//$password = trim($password);
		
		//echo "$username, $password";
		$types = array("text","text");

		$statement = $db->prepare('select id from customers where username=? and password=?',$types, MDB2_PREPARE_RESULT);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerID(): fail prepare');
		}

		$data = array($username,$password);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getMessage();
			die('Kritinė klaida: Customer->getCustomerID(): fail execute');
		}


	
		$db->disconnect();
		if ($result = $resultset->fetchRow()) {
			return $result[0];
		} else {
			return 0;
		}
	}
	
	
	
	/**
	*Kliento duomenys
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array Kliento duomenys
	*/

	public function getCustomerData($customer_id)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,company_name,code,vat_code,name,surname,address,phone,is_company,username,password,registred,activate_iptv from customers where id='.$customer_id); 
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomer()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
	}
	
	
	/**
	*Gražinama sąskaita
	*@param Integer $invoice_id sąskaitos identifikacinis numeris
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array Gražinama sąskaita
	*/

	public function getInvoiceByCustomer($invoice_id,$customer_id)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.inv_date+ interval \'15 days\' from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and invoices.id='.$invoice_id.' and contracts.customer_id='.$customer_id ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getInvoice()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
	}
	
	
	/**
	*Gražinami visi klientui priklausantys IPv4 adresai
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array visi klientui priklausantys IPv4 adresai
	*/

	public function getAddressesByCustomer($customer_id)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select network_info.id,network_info.ip,network_info.mask,network_info.gateway,network_info.dns1,network_info.dns2,network_info.other_info,network_info.contract_id from network_info,contracts,customers where customers.id=contracts.customer_id and contracts.id=network_info.contract_id and customers.id='.$customer_id);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getAddressesByCustomer()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinama sąskaita
	*@return Array Gražinama sąskaita
	*/

	public function getInvoiceLast()
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.inv_date+ interval \'15 days\' from customers,contracts,owners,plans,invoices where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id  order by invoices.id desc limit 1 ' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getInvoiceLast()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
		
	}
	
	
	
	/**
	*Gražinami adresai pagal paieškos sąlygą duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš network_info lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String  $search paieškos sąlyga
	*@return Array adresai pagal paieškos sąlygą duomenų masyvas
	*/

	public function getAddressesBySearch($offset,$limit,$search)
	{
	
		
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.username,customers.password,customers.is_company,customers.registred,network_info.id,network_info.ip,network_info.mask,network_info.gateway,network_info.dns1,network_info.dns2,network_info.other_info,network_info.mac_address,contracts.is_active,coalesce((valid_from<now() and valid_to> now()),true),(case when suspend_from is not null then coalesce((suspend_from<now() and suspend_to> now()),true) else false end) from customers,contracts,network_info where (lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\') or lower(network_info.ip) like lower(\''.$search.'\')) and  customers.id=contracts.customer_id and contracts.id=network_info.contract_id    order by network_info.id limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getAddressesBySearch()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas adresų pagal paieškos sąlygą kiekis
	*@param String  $search paieškos sąlyga
	*@return integer adresų pagal paieškos sąlygą kiekis
	*/

	public function getAddressesCount($search)
	{	

		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(network_info.id) from customers,contracts,network_info where (lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\') or lower(network_info.ip) like lower(\''.$search.'\')) and  customers.id=contracts.customer_id and contracts.id=network_info.contract_id');
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getAddressesCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		} else {
			return 0;
		}
	}
	
	
	public function UTF8_mail(
	$from,$to,$subject,$message,$cc="",$bcc=""){
	
	$from = explode("<",$from );
	
	$headers =
	"From: =?UTF-8?B?"
	.base64_encode($from[0])."?= <"
	. $from[1] . "\r\n";
	
	$to = explode("<",$to );
	$to = "=?UTF-8?B?".base64_encode($to[0])
	."?= <". $to[1] ;
	
	$subject="=?UTF-8?B?"
	.base64_encode($subject)."?=\n";
	
	if($cc!=""){
	$cc = explode("<",$cc );
	$headers .= "Cc: =?UTF-8?B?"
	.base64_encode($cc[0])."?= <"
	. $cc[1] . "\r\n";
	}
	
	if($bcc!=""){
	$bcc = explode("<",$bcc );
	$headers .= "Bcc: =?UTF-8?B?"
	.base64_encode($bcc[0])."?= <"
	. $bcc[1] . "\r\n";
	}
	
	$headers .=
	"Content-Type: text/html; "
	. "charset=UTF-8; format=flowed\n"
	. "MIME-Version: 1.0\n"
	. "Content-Transfer-Encoding: 8bit\n"
	. "X-Mailer: PHP\n";
	
	return mail($to, $subject, $message, $headers);
	
	}
	
	
	/**
	*Gražinama paskutinė sutartis
	*@return Array Gražinama paskutinė sutartis
	*/

	public function getContractLast()
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person,contracts.other_info from customers,contracts,owners,plans where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id order by contracts.id desc limit 1 ' ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getContractLast()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row;
		}
		
		
	}
	
	
	
	/**
	*Įterpiama PVM sąskaita
	*@param Integer $invoice_id Išankstinės sąskaitos numeris
	*@param Boolean $is_inv Ar egzistuoja PVM sąskaita
	*@param Integer $vat_inv_no PVM sąskaitos numeris
	*@param Integer $vat PVM dydis
	*@param Date $vat_inv_date PVM sąskaitos data
	*@param Double $vat_inv_quantity PVM sąskaitos suma
	*@param Integer $vat_inv_id Buhalterinėje apskaitoje sąskaitos identifikacinis numeris
	*@param Text $code Kliento kodas
	*@param Text $vat_oper_code PVM Sąskaitoje esančio įrašo kodas
	*/
	public function insertVAT($invoice_id,$is_inv,$vat_inv_no,$vat,$vat_inv_date,$vat_inv_quantity,$vat_inv_id,$code,$vat_oper_code)
	{
	
		//echo $vat_oper_code;
		$connectInfoside = new ConnectManagerInfoside();
		$dbInfoside = $connectInfoside->getConnect();
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$vat_inv_idPar = $vat_inv_id;
		if ($is_inv == 'f') {
			$vat_inv_no = null;
			$vat = null;
			$vat_inv_date = null;
			$vat_inv_quantity = null;
			$vat_inv_id = null;
			$vat_oper_code = null;
		}
		
		if ($is_inv == 'f') {
			$is_inv = false;
		} else {
			$is_inv = true;
		}

		
		$types = array("boolean","integer","integer","date","decimal","integer","text","integer");

		$statement = $db->prepare('update invoices set is_inv=?, vat_inv_no=?, vat=?, vat_inv_date=?, vat_inv_quantity=?, vat_inv_id=?, vat_oper_code=? where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->insertVAT(): fail prepare');
		}

		$data = array($is_inv,$vat_inv_no,$vat,$vat_inv_date,$vat_inv_quantity,$vat_inv_id,$vat_oper_code,$invoice_id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->insertVAT(): fail execute');
		}
		$db->disconnect();
		

		
		
		//Jei nera iterpta dar i buhalterine iterpiame t.y. ziurima pagal $vat_inv_id
		if ($is_inv == true) {
			
			
			//Istrinama saskaita pries koreguojant
			if ($vat_inv_idPar != null) {
				
				
				//Istrinama Saskaita is Infoside
				$dbInfoside = $connectInfoside->getConnect();
				$types = array("integer");
				$statement = $dbInfoside->prepare('delete from "Vazt" where "KlucVazt"=?',$types, MDB2_PREPARE_MANIP);
				if (PEAR::isError($statement)) {
					$dbInfoside->disconnect();
					echo $statement->getDebugInfo();
					die('Kritinė klaida: Customer->insertVAT_DeleteFromVaztBeferoInsert(): fail prepare');
				}
		
				$data = array($vat_inv_idPar);
				
				$resultset = $statement->execute($data);
		
			
				if (PEAR::isError($resultset)) {
					$dbInfoside->disconnect();
					die('Kritinė klaida: Customer->insertVAT_DeleteFromVaztBeferoInsert(): fail execute');
				}
				$dbInfoside->disconnect();
				
				
				
			}
			
			
			$types = array("text","date","date","text","decimal");
	
			$dbInfoside = $connectInfoside->getConnect();
			$statement = $dbInfoside->prepare('insert into "Vazt" ("Number","Data","Klient","PVM") values (?,?,?,?)',$types, MDB2_PREPARE_MANIP);
			if (PEAR::isError($statement)) {
				$dbInfoside->disconnect();
				echo $statement->getDebugInfo();
				die('Kritinė klaida: Customer->insertVAT_Vazt(): fail prepare');
			}
	
			$data = array("INFT".$vat_inv_no,$vat_inv_date,$code,$vat/100);
			
			$resultset = $statement->execute($data);
	
		
			if (PEAR::isError($resultset)) {
				$dbInfoside->disconnect();
				//echo $resultset->getDebugInfo();
				die('Kritinė klaida: Customer->insertVAT_Vazt(): fail execute');
			}
			$dbInfoside->disconnect();
			
			
			
			//Grazinamas paskutinis iterptas Vazt ID
			$dbInfoside = $connectInfoside->getConnect();
			$res =  $dbInfoside->query('select last_value FROM "Vazt_KlucVazt_seq"' ); 
			if (PEAR::isError($res)) {
				echo $res->getDebugInfo();
				$dbInfoside->disconnect();
				die('Kritinė klaida: Customer->insertVAT_LastID()');
			}
			$dbInfoside->disconnect();
			
			$row = $res->fetchRow();
			$lastID = $row[0];
			
			
			
			
			
			//Iterpiama operacija
			$dbInfoside = $connectInfoside->getConnect();
			$price = round(($vat_inv_quantity*100)/(100+$vat),4);
			$statement = $dbInfoside->prepare('insert into "VaztOper" ("MaterID","KiekNuras","Kaina","NumbDok") select \''.$vat_oper_code.'\',1,'.$price.', last_value FROM "Vazt_KlucVazt_seq"',null, MDB2_PREPARE_MANIP);
			if (PEAR::isError($statement)) {
				$dbInfoside->disconnect();
				echo $statement->getDebugInfo();
				die('Kritinė klaida: Customer->insertVAT_VaztOper(): fail prepare');
			}
	
			$data = array();
			
			$resultset = $statement->execute($data);
	
		
			if (PEAR::isError($resultset)) {
				$dbInfoside->disconnect();
				//echo $resultset->getDebugInfo();
				die('Kritinė klaida: Customer->insertVAT_VaztOper(): fail execute');
			}
			$dbInfoside->disconnect();
			
			
			
			//Iterpiamas paskutinis ID i bitnet DB
			//echo $lastID;
			$types = array("integer","integer");
	
			$statement = $db->prepare('update invoices set vat_inv_id=? where id=?',$types, MDB2_PREPARE_MANIP);
			if (PEAR::isError($statement)) {
				$db->disconnect();
				die('Kritinė klaida: Customer->insertVATLastIDToBitnet(): fail prepare');
			}
			$data = array($lastID,$invoice_id);
			$resultset = $statement->execute($data);
			if (PEAR::isError($resultset)) {
				$db->disconnect();
				//echo $resultset->getDebugInfo();
				die('Kritinė klaida: Customer->insertVATLastIDToBitnet(): fail execute');
			}
			$db->disconnect();
			
			

		}
		
		//Istrinama saskaita
		if ($vat_inv_idPar != null && $is_inv == false) {
			
			
			//Istrinama Saskaita is Infoside
			$dbInfoside = $connectInfoside->getConnect();
			$types = array("integer");
			$statement = $dbInfoside->prepare('delete from "Vazt" where "KlucVazt"=?',$types, MDB2_PREPARE_MANIP);
			if (PEAR::isError($statement)) {
				$dbInfoside->disconnect();
				echo $statement->getDebugInfo();
				die('Kritinė klaida: Customer->insertVAT_DeleteFromVazt(): fail prepare');
			}
	
			$data = array($vat_inv_idPar);
			
			$resultset = $statement->execute($data);
	
		
			if (PEAR::isError($resultset)) {
				$dbInfoside->disconnect();
				die('Kritinė klaida: Customer->insertVAT_DeleteFromVazt(): fail execute');
			}
			$dbInfoside->disconnect();
			
			
			
		}
	
	}
	
	
	
	/**
	*Gražinamas kliento vardas ir pavardė pagal sutarties numerį
	*@param Integer $contractID Kontrakto identifikacinis numeris
	*@return String Kliento vardas ir pavardė
	*/

	public function getCustomerNameByContract($contractID)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,name,surname from customers,contracts  where customers.id=contracts.customer_id and contracts.id='.$contractID);
		if (PEAR::isError($res)) {
			//echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerNameByContract()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			return $res->fetchRow();
			
		} 
		
	}
	
	/**
	*Gražinami mokėjimai pagal sąskaitos id
	*@param Integer $invoiceID Sąskaitos identifikacinis numeris
	*@return Array mokėjimų masyvas pagal $invoiceID 
	*/

	public function getPaymentsByInvoicesID($invoiceID)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,invoice_id,pay_date,payment_quantity,comment,bank_transfer_id,cash from payments where invoice_id='.$invoiceID.' order by pay_date desc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getPaymentsByInvoicesID()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	

	/**
	*Atnaujinamas mokėjimas
	*@param Integer $id Mokėjimo identifikacinis numeris
	*@param Date $payDate Apmokėjimo data
	*@param Numeris(8,2) $paymentQuantity Apmokėta suma
	*@param String $comment Apmokėjimo komentaras
	*@param String $bankId Banko pavedimo identifikacinis numeris
	*@param String $cash True - Grynieji pinigai; False - pavedimu
	*/
	public function updatePayment($id,$payDate,$paymentQuantity,$comment,$bankId,$cash)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		if (strlen($comment) == 0) {
			$comment = null;
		}
		if (strlen($bankId) == 0) {
			$bankId = null;
		}
		
		if (trim($cash) == 'on') {
			$cash = true;
		} else {
			$cash = false;
		}
		
		$types = array("date","decimal","text","text","boolean","integer");

		$statement = $db->prepare('update payments set pay_date=?,payment_quantity=?,comment=?,bank_transfer_id=?,cash=? where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$db->disconnect();
			//echo $statement->getDebugInfo();
			die('Kritinė klaida: Customer->updatePayment(): fail prepare');
		}

		$data = array($payDate,$paymentQuantity,$comment,$bankId,$cash,$id);
		
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getDebugInfo();
			die('Kritinė klaida: Customer->updatePayment(): fail execute');
		}

	}
	
	/**
	*Mokėjimo įterpimas į DB ir įterpto ID gražinimas
	*@param Integer $invoiceID Sąskaitos identifikacinis numeris
	*@param Date $payDate Apmokėjimo data
	*@param Numeris(8,2) $paymentQuantity Apmokėta suma
	*@param String $comment Apmokėjimo komentaras
	*@param String $bankId Banko pavedimo identifikacinis numeris
	*@param String $cash True - Grynieji pinigai; False - pavedimu
	*@return Array Įterpto mokėjimo identifikacinis numeris masyve
	*/

	public function insertPayment($invoiceID,$payDate,$paymentQuantity,$comment,$bankId,$cash)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		if (strlen($comment) == 0) {
			$comment = null;
		}
		
		if (strlen($bankId) == 0) {
			$bankId = null;
		}
		
	
		if (trim($cash) == 'on') {
			$cash = 'true';
		} else {
			$cash = 'false';
		}
		

		$data = array($invoiceID,$payDate,$paymentQuantity,$comment,$bankId,$cash);
		if ($bankId == null && $comment == null) {
			$sql = 'insert into payments (invoice_id,pay_date,payment_quantity,cash) values ('.$invoiceID.',\''.$payDate.'\','.$paymentQuantity.','.$cash.') returning id';
		} elseif ($bankId != null && $comment == null) {
			$sql = 'insert into payments (invoice_id,pay_date,payment_quantity,bank_transfer_id,cash) values ('.$invoiceID.',\''.$payDate.'\','.$paymentQuantity.',\''.$bankId.'\','.$cash.') returning id';
		} elseif ($bankId == null && $comment != null) {
			$sql = 'insert into payments (invoice_id,pay_date,payment_quantity,comment,cash) values ('.$invoiceID.',\''.$payDate.'\','.$paymentQuantity.',\''.$comment.'\','.$cash.') returning id';
		} elseif ($bankId != null && $comment != null) {
			$sql = 'insert into payments (invoice_id,pay_date,payment_quantity,comment,bank_transfer_id,cash) values ('.$invoiceID.',\''.$payDate.'\','.$paymentQuantity.',\''.$comment.'\',\''.$bankId.'\','.$cash.') returning id';
		}
		$res =  $db->query($sql);

		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->insertPayment()');
		}
		
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Pašalinimas mokėjimas iš DB
	*@param Integer $id Mokėjimo identifikacinis numeris
	*/
	public function deletePayment($id)
	{
		$types = array("integer");

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$statement = $db->prepare('delete from payments where id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			
			$db->disconnect();
			die('Kritinė klaida: Customer->deletePayment(): fail prepare');
		}

		$data = array($id);
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getCode();
			die('Kritinė klaida: Customer->deletePayment(): fail execute');
		}
	}	
	
	/**
	*Tikrinama ar jau mokėjimo duomenys yra importuoti į imported_payments lentelę
	*@param String $fileName faiko pavadinimas
	*@return Integer 1 - failas jau importuotas; 0 - failas neimportuotas; 2 - DB klaida;
	*/

	public function checkImportedFileName($fileName)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id from imported_payments where file_name like \''.$fileName.'\'');
		
		if (PEAR::isError($res)) {
			$db->disconnect();
			return 2;
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		
		if (count($data) > 0) {
			return 1;
		} else {
			return 0;
		}
		
	}
	
	/**
	*Įterpimas sugeneruoto mokėjimo į DB
	*@param $importArray []	
	*       [0] => PP200304.txt
    *       [1] => 945
    *       [2] => 2020.03.04
    *       [3] => 13.31
	*@return Integer 1 - Sėkmingai importuota; 2 - Importavimo klaida; 3 - Importavimas jau egzistuoja
	*/
	public function importPayment($importArray)
	{
	
		if (count($importArray) > 0) {
			$importStatus = $this->checkImportedFileName($importArray[0][0]);
		} else {
			return 2;
		}
		if ($importStatus == 1 ) {
			return 3;
		} elseif ($importStatus == 2) {
			return 2;
		}
		$types = array("integer","text","date","decimal","integer");
		 
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$db->beginTransaction();
		
		
		$error = 0;
		$statement = $db->prepare('insert into imported_payments (contract_id,file_name,payment_date,payment_quantity,type) values (?,?,?,?,?)',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			$error++;
		}
			
		
		foreach($importArray as $item) {
			$data = array($item[1],$item[0],$item[2],$item[3],1);
			$resultset = $statement->execute($data);

			if (PEAR::isError($resultset)) {
				$error++;
			}
		}
		
		if ($error == 0) {
			$db->commit();
			$db->disconnect();
			return 1;
		
		} else {
			$db->rollback();
			$db->disconnect();
			return 2;
		}
		
		
	}
	
	/**
	*Mokėjimų perkėlimas į kitą SF
	*@param Integer $currentID einamosios sąskaitos ID
	*@param Integer $upgradeID atnaujinamos sąskaitos ID
	*/
	public function movePayment($currentID,$upgradeID)
	{
		$types = array("integer","integer");

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$statement = $db->prepare('update payments set invoice_id=? where invoice_id=?',$types, MDB2_PREPARE_MANIP);
		if (PEAR::isError($statement)) {
			
			$db->disconnect();
			die('Kritinė klaida: Customer->movePayment(): fail prepare');
		}

		$data = array($upgradeID,$currentID);
		$resultset = $statement->execute($data);

	
		if (PEAR::isError($resultset)) {
			$db->disconnect();
			//echo $resultset->getCode();
			die('Kritinė klaida: Customer->movePayment(): fail execute');
		}
	}
	
	/**
	*Sugrupuotas importuotų duomenų masyvas pagal importavimą iš invoices lentelės
	*@param Integer $customerID
	*@return Array kliento importuotų duomenų duomenų masyvas
	*/

	public function getImportedPaymentSumFromInvoices($customerID)
	{
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$res =  $db->query('select min(contract_id),min(type),min(file_name),sum(payment_quantity),payment_date, (select sum(payments.payment_quantity) from payments,invoices,contracts where contracts.id=invoices.contract_id and invoices.id=payments.invoice_id and payments.pay_date=imported_payments.payment_date and contracts.customer_id='.$customerID.') as rasta from imported_payments,contracts  where contracts.id=imported_payments.contract_id and contracts.customer_id='.$customerID.' group by payment_date order by payment_date'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getImportedPaymentSumFromInvoices()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas sąskaitų sąrašas pagal paieškos sąlygas (Sujungtos su apmokėjimų lentele)
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš invoices lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param String $search Paieškos sąlyga
	*@param Integer $type Kliento tipas: f - fizinis asmuo; t - įmonė
	*@param Integer $owner_id Sąvininko identifikacinis numeris
	*@param Date $from Rodyti išrašytas sąskaitas nuo
	*@param Date $to Rodyti išrašytas sąskaitas iki
	*@param String $full - pilnai apmokėta
	*@param String $not_full - nepilnai apmokėta
	*@param String $not_pay - nemokėtos
	*@param String $over_pay - permokėtos
	*@param String $discount - su nuolaida
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesBySearchJoin($offset,$limit,$search,$type,$owner_id,$from,$to,$full,$not_full,$not_pay,$over_pay,$discount)
	{
		
		if (strlen($type) > 0) {
			if ($type == "f") {
				$is_company = " and customers.is_company=false ";
			} else {
				$is_company = " and customers.is_company=true ";
			}
		} else {
			$is_company = "";
		}
		
		if (strlen($owner_id) > 0) {
			
			$owner_id = " and owners.id=".$owner_id;
		} else {
			$owner_id = "";
		}
		
		if (strlen($from) > 0) {
			
			$from = " and invoices.inv_date>=".'\''.$from.'\'';
		} else {
			$from = "";
		}
		
		if (strlen($to) > 0) {
			
			$to = " and invoices.inv_date<=".'\''.$to.'\'';
		} else {
			$to = "";
		}
		
		
		
		if ($full == 'on') {
			$full = " and invoices.quantity = invoices.payment_quantity";
		} else {
			$full = '';
		}
		
		if ($not_full == 'on') {
			$not_full = " and (invoices.quantity > invoices.payment_quantity and  invoices.payment_quantity <> 0)";
		} else {
			$not_full = '';
		}
		
		if ($not_pay == 'on') {
			$not_pay = " and (invoices.payment_quantity=0 or invoices.quantity > invoices.payment_quantity)";
		} else {
			$not_pay = '';
		}
		
		if ($over_pay == 'on') {
			$over_pay = " and invoices.quantity < invoices.payment_quantity";
		} else {
			$over_pay = '';
		}
		
		if ($discount == 'on') {
			$discount = " and invoices.quantity < contracts.mountly_fee";
		} else {
			$discount = '';
		}
			
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity,payments.pay_date,payments.payment_quantity,payments.comment from customers,contracts,owners,plans,invoices left join payments ON invoices.id = payments.invoice_id where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and ((lower(coalesce(customers.company_name,\'\')) like lower(\'%'.$search.'%\') or lower(customers.name) like lower(\'%'.$search.'%\') or lower(customers.surname) like lower(\'%'.$search.'%\') or lower(customers.code) like lower(\'%'.$search.'%\') or lower(coalesce(customers.vat_code,\'\')) like lower(\'%'.$search.'%\') or lower(coalesce(customers.phone,\'\')) like lower(\'%'.$search.'%\') or lower(customers.username) like lower(\'%'.$search.'%\') or lower(customers.name) ||\' \'|| lower(customers.surname) like lower(\'%'.$search.'%\')))  '.$is_company.' '.$owner_id.' '.$from.' '.$to.' '.$full.' '.$not_full.' '.$not_pay.' '.$over_pay.' '.$discount.' order by invoices.id asc, payments.pay_date desc limit '.$limit.' offset '.$offset ); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesBySearchJoin()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinamas sąskaitų sąrašas pagal kliento identifikacinį nr. (Sujungtos su apmokėjimų lentele)
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Array sąskaitų duomenų masyvas
	*/

	public function getCustomerInvoicesByCustomerIDJoin($customerID)
	{
		

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select customers.id,customers.company_name,customers.code,customers.vat_code,customers.name,customers.surname,customers.address,customers.phone,customers.is_company,customers.username,customers.password,customers.registred,contracts.id,contracts.mountly_fee,contracts.valid_from,contracts.valid_to,contracts.contract_path,contracts.suspend_from,contracts.suspend_to,contracts.is_active,contracts.registred,owners.id,owners.name,owners.surname,owners.username,owners.password,plans.id,plans.name,plans.download,plans.upload,plans.price_company,plans.price_person, invoices.id,invoices.quantity,invoices.payment_quantity,invoices.contract_id,invoices.inv_date,invoices.pay_date,invoices.inv_path,invoices.purpose,invoices.is_inv,invoices.vat_inv_no,invoices.vat,invoices.vat_inv_date,invoices.vat_inv_quantity,payments.pay_date,payments.payment_quantity,payments.comment from customers,contracts,owners,plans,invoices left join payments ON invoices.id = payments.invoice_id where customers.id=contracts.customer_id and contracts.plan_id=plans.id and contracts.owner_id=owners.id and invoices.contract_id=contracts.id and customers.id='.$customerID.' order by invoices.id asc, payments.pay_date desc'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerInvoicesByCustomerIDJoin()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas neapmokėtų saskaitų identifikaciniai numeriai su skolos suma
	*@param Integer $contractID sutarties identifikacinis numeris
	*@return Array neapmokėtų saskaitų identifikaciniai numeriai su skolos suma
	*/

	public function getInvoicesDebt($contractID)
	{
		

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select id,quantity-payment_quantity from invoices where   payment_quantity<quantity and contract_id='.$contractID.' order by id desc'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getInvoicesDebt()');
		}
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinama importuoto mokėjimo pagal datą ir sutarties nr. palyginimas (perlo mokėjimų ir sistemos mokėjimų lentelėse) 
	*@param Integer $contractID sutarties identifikacinis numeris
	*@param Date $date Apmokėjimo data
	*@return Array importuoto mokėjimo pagal datą ir sutarties nr. palyginimas
	*/

	public function comparePaymentsByDateContractID($contractID,$date)
	{
		//echo $contractID."<br />";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
			
		$res =  $db->query('select sum(payment_quantity) from imported_payments where contract_id='.$contractID.' and payment_date=\''.$date.'\''); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->comparePaymentsByDateContractID(). Table imported_payments');
		}
		
		$row = $res->fetchRow();
	
		$res1 =  $db->query('select sum(payments.payment_quantity) from invoices,payments where invoices.id=payments.invoice_id and invoices.contract_id='.$contractID.' and payments.pay_date=\''.$date.'\''); 
		if (PEAR::isError($res1)) {
			echo $res1->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->comparePaymentsByDateContractID(). Table payments');
		}
		
		$row1 = $res1->fetchRow();
		
		$db->disconnect();
		$imported_payment = $row[0];
		$paid_payment = $row1[0];
		if ($imported_payment == null) {$imported_payment  = 0;}
		if ($paid_payment == null) {$paid_payment  = 0;}
		return array($imported_payment,$paid_payment);
		
	}
	
	/**
	*Gražinama importuoto mokėjimo pagal banko perlaidos identifikacinį numerį suma. 
	*@param String $bankTransferID Banko perlaidos identifikacinis numeris
	*@return Numeris(8,2) Importuoto mokėjimo pagal banko perlaidos identifikacinį numerį suma
	*/

	public function getSumByBankTransferID($bankTransferID)
	{
		//echo $contractID."<br />";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
			
		$res =  $db->query('select sum(payment_quantity) from payments where bank_transfer_id like \''.$bankTransferID.'\''); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getSumByBankTransferID(). Table payments');
		}
		
		$row = $res->fetchRow();
	
		
		$db->disconnect();
	
		if ($row[0] != null) {
			return $row[0];
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinama importuoto mokėjimo pagal banko perlaidos identifikacinį numerį visi asmenų duomenys sutarties nr./įmonės pavadinimas/vardas/pavardė/asmens kodas/įmonės kodas
	*@param String $bankTransferID Banko perlaidos identifikacinis numeris
	*@return Array  klientų duomenų masyvas
	*/

	public function getNamesByBankTransferID($bankTransferID)
	{
		//echo $contractID."<br />";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
			
		$res =  $db->query('select contracts.id,customers.company_name,customers.name,customers.surname,customers.code,sum(payments.payment_quantity) from customers,contracts,invoices,payments where customers.id=contracts.customer_id and contracts.id=invoices.contract_id and invoices.id=payments.invoice_id and  bank_transfer_id like \''.$bankTransferID.'\' group by contracts.id,customers.company_name,customers.name,customers.surname,customers.code order by customers.company_name,customers.name,customers.surname'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getNamesByBankTransferID(). Table payments');
		}
		
		$data = null;
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	
	/**
	*Gražinama importuoto mokėjimo banko perlaidos identifikacinis numeris pagal datą ir iš invoiceID išsitraukus contractID 
	*@param Date $date - Apmokėjimo data
	*@param Integer $invoiceData Sąskaitos duomenys
	*@return String Banko perlaidos identifikacinis numeris
	*/

	public function getBankIDByDateAndInvoice($date,$invoiceData)
	{
		
		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select payments.bank_transfer_id from customers,contracts,invoices,payments where customers.id=contracts.customer_id and contracts.id=invoices.contract_id and invoices.id=payments.invoice_id and payments.pay_date=\''.$date.'\' and contracts.id='.$invoiceData[12].' order by payments.modify_time desc limit 1'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getSumByBankTransferID(). Table payments');
		}
		
		$row = $res->fetchRow();
	
		
		$db->disconnect();
	
		if ($row[0] != null) {
			return $row[0];
		} else {
			return '';
		}
		
	}
	
	
	/**
	*Generuojamas Rivilės XML failas failas iš gautų perlo mokėjimų
	*@param Date $dateFrom - Nuo kada generuojamas failas
	*@param Date $dateTo - Iki kada generuojamas failas
	*@param Integer - 1 - rodyti visus; 2 tik Disigma; 3 - Is perlo kiti
	*@param Date $invDate - Sąskaitos generavimo data
	*@return Array  sugeneruotas XML 
	*/

	public function generateInvXMLFromPerlas($dateFrom,$dateTo,$type,$invDate)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		if (strlen($dateFrom) > 0) {
			
			$dateFrom = " and imported_payments.payment_date>=".'\''.$dateFrom.'\'';
		} else {
			$dateFrom = "";
		}
		
		if (strlen($dateTo) > 0) {
			
			$dateTo = " and imported_payments.payment_date<=".'\''.$dateTo.'\'';
		} else {
			$dateTo = "";
		}
		if ($type == 2) {
			$type = " and file_name like 'PP%'";
		} elseif ($type == 3) {
			$type = " and file_name like 'VPP%'";
		} 
		else {
			$type = "";
		}
		
		$res =  $db->query("select name,surname,code,imported_payments.payment_date, sum(imported_payments.payment_quantity) from customers,contracts,imported_payments where customers.id=contracts.customer_id and contracts.id=imported_payments.contract_id ".$dateFrom." ".$dateTo." ".$type." group by imported_payments.payment_date,name,surname,code order by customers.code"); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->generateInvXMLFromPerlas()');
		}
		$exportXML = "";
		$data = null;
		while ($row = $res->fetchRow()) {
		   $exportXML .= "<I06>\n";
		   $exportXML .= "    <I06_OP_TIP>51</I06_OP_TIP>\n";
		   $exportXML .= "    <I06_PVM_TIP>1</I06_PVM_TIP>\n";
		   $exportXML .= "    <I06_OP_DATA>".preg_replace("/\//u", ".",$invDate)."</I06_OP_DATA>\n";
		   $exportXML .= "    <I06_DOK_DATA>".preg_replace("/\//u", ".",$invDate)."</I06_DOK_DATA>\n";
		   $exportXML .= "    <I06_MOK_DOK>MOK-". preg_replace("/-/u", "",$row[3])."</I06_MOK_DOK>\n";
		   $exportXML .= "    <I06_KODAS_KS>".$row[2]."</I06_KODAS_KS>\n";
		   $exportXML .= "    <I06_KODAS_SS>2712</I06_KODAS_SS>\n";
		   $exportXML .= "    <I06_MOK_SUMA>1</I06_MOK_SUMA>\n";
		   
		   $exportXML .= "    <I07>\n";
		   $exportXML .= "        <I07_TIPAS>2</I07_TIPAS>\n";
		   $exportXML .= "        <I07_KODAS>INTPASL</I07_KODAS>\n";
		   $exportXML .= "        <I07_KAINA_SU>".$row[4]."</I07_KAINA_SU>\n";
		   $exportXML .= "        <T_KIEKIS>1</T_KIEKIS>\n";
		   $exportXML .= "    </I07>\n";
		   
		   $exportXML .= "</I06>\n\n";
		}
		$db->disconnect();
		return $exportXML;
	}
	
	/**
	*Sumojami pinigai gauti iš perlo mokėjimų
	*@param Date $dateFrom - Nuo kada 
	*@param Date $dateTo - Iki kada
	*@param Integer - 1 - rodyti visus; 2 tik Disigma; 3 - Is perlo kiti
	*@return Numeris(8,2) Pinigų suma
	*/

	public function getMoneyFromPerl($dateFrom,$dateTo,$type)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		//to_date('2023-02-16','YYYY-MM-DD') + interval '1 day'
		
		if (strlen($dateFrom) > 0) {
			
			$dateFrom = " and imported_payments.payment_date>=".'\''.$dateFrom.'\'';
		} else {
			$dateFrom = "";
		}
		
		if (strlen($dateTo) > 0) {
			
			$dateTo = " and imported_payments.payment_date<=".'\''.$dateTo.'\'';
		} else {
			$dateTo = "";
		}
		if ($type == 2) {
			$type = " and file_name like 'PP%'";
		} elseif ($type == 3) {
			$type = " and file_name like 'VPP%'";
		} 
		else {
			$type = "";
		}

		$res =  $db->query("select sum(imported_payments.payment_quantity) from customers,contracts,imported_payments where customers.id=contracts.customer_id and contracts.id=imported_payments.contract_id ".$dateFrom." ".$dateTo." ".$type); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getMoneyFromPerl()');
		}
		
		$row = $res->fetchRow();

		$db->disconnect();
		return $row[0];
	}
	
	/**
	*Sumojami pinigai gauti iš payments lentelės
	*@param Date $dateFrom - Nuo kada 
	*@param Date $dateTo - Iki kada
	*@param Integer - 1 - rodyti visus; 2 tik Disigma Swedbank pavedimai; 3 - Grynieji
	*@return Numeris(8,2) Pinigų suma
	*/

	public function getMoneyFromPayments($dateFrom,$dateTo,$type)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		//to_date('2023-02-16','YYYY-MM-DD') + interval '1 day'
		
		if (strlen($dateFrom) > 0) {
			
			$dateFrom = " and payments.pay_date>=".'\''.$dateFrom.'\'';
		} else {
			$dateFrom = "";
		}
		
		if (strlen($dateTo) > 0) {
			
			$dateTo = " and payments.pay_date<=".'\''.$dateTo.'\'';
		} else {
			$dateTo = "";
		}
		
		if ($type == 2) {
			$type = " and length(bank_transfer_id)=16 and cash=false";
		} elseif ($type == 3) {
			$type = " and cash=true";
		} 
		else {
			$type = "";
		}

		$res =  $db->query("select sum(payments.payment_quantity) from customers,contracts,invoices,payments where customers.id=contracts.customer_id and contracts.id=invoices.contract_id and invoices.id=payments.invoice_id ".$dateFrom." ".$dateTo." ".$type); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->getMoneyFromPerl()');
		}
		
		$row = $res->fetchRow();

		$db->disconnect();
		return $row[0];
	}
	
	/**
	*Generuojamas Rivilės XML failas failas iš gautų perlo mokėjimų
	*@param Date $dateFrom - Nuo kada generuojamas failas
	*@param Date $dateTo - Iki kada generuojamas failas
	*@param Integer - 1 - rodyti visus; 2 tik Disigma Swedbank pavedimai; 3 - Grynieji
	*@param Date $invDate - Sąskaitos generavimo data
	*@return Array  sugeneruotas XML 
	*/

	public function generateInvXMLFromPayments($dateFrom,$dateTo,$type,$invDate)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		if (strlen($dateFrom) > 0) {
			
			$dateFrom = " and payments.pay_date>=".'\''.$dateFrom.'\'';
		} else {
			$dateFrom = "";
		}
		
		if (strlen($dateTo) > 0) {
			
			$dateTo = " and payments.pay_date<=".'\''.$dateTo.'\'';
		} else {
			$dateTo = "";
		}
		
		if ($type == 2) {
			$type = " and length(bank_transfer_id)=16 and cash=false";
		} elseif ($type == 3) {
			$type = " and cash=true";
		} 
		else {
			$type = "";
		}
		
		$res =  $db->query("select name,surname,code,payments.pay_date,sum(payments.payment_quantity) from customers,contracts,invoices,payments where customers.id=contracts.customer_id and contracts.id=invoices.contract_id and invoices.id=payments.invoice_id ".$dateFrom." ".$dateTo." ".$type." group by payments.pay_date,name,surname,code order by customers.code"); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->generateInvXMLFromPerlas()');
		}
		$exportXML = "";
		$data = null;
		while ($row = $res->fetchRow()) {
		   $exportXML .= "<I06>\n";
		   $exportXML .= "    <I06_OP_TIP>51</I06_OP_TIP>\n";
		   $exportXML .= "    <I06_PVM_TIP>1</I06_PVM_TIP>\n";
		   $exportXML .= "    <I06_OP_DATA>".preg_replace("/\//u", ".",$invDate)."</I06_OP_DATA>\n";
		   $exportXML .= "    <I06_DOK_DATA>".preg_replace("/\//u", ".",$invDate)."</I06_DOK_DATA>\n";
		   $exportXML .= "    <I06_MOK_DOK>MOK-". preg_replace("/-/u", "",$row[3])."</I06_MOK_DOK>\n";
		   $exportXML .= "    <I06_KODAS_KS>".$row[2]."</I06_KODAS_KS>\n";
		   $exportXML .= "    <I06_KODAS_SS>2711</I06_KODAS_SS>\n";
		   $exportXML .= "    <I06_MOK_SUMA>1</I06_MOK_SUMA>\n";
		   
		   $exportXML .= "    <I07>\n";
		   $exportXML .= "        <I07_TIPAS>2</I07_TIPAS>\n";
		   $exportXML .= "        <I07_KODAS>INTPASL</I07_KODAS>\n";
		   $exportXML .= "        <I07_KAINA_SU>".$row[4]."</I07_KAINA_SU>\n";
		   $exportXML .= "        <T_KIEKIS>1</T_KIEKIS>\n";
		   $exportXML .= "    </I07>\n";
		   
		   $exportXML .= "</I06>\n\n";
		}
		$db->disconnect();
		return $exportXML;
	}
	
	/**
	*Telegramo žinutės siuntimas per postgresql funkciją send_telegram
	*@param String $message Žinutės tekstas
	*@return Integer siuntimo statusas
	*/

	public function sendTelegram($message)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select  send_telegram(\''.$message.'&parse_mode=html\')'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->sendTelegram()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0]+1;
		}
	}
	
	/**
	*Tikrinamas kliento importuotų imokos ir sutarties pokytis
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer 
	*	return value:
	*	1 - Nesutvarkytas perlo importas;
	*	2 - Pasikeitė paskutinės sąskaitos sumą lyginant su sutartimi;
	*	3 - Abu kriterijai teisingi 1. ir 2.
	*	0 - Perlo importas geras - paskutinė sąskaita nepasikeitė lyginant su sutartini.
	*/

	public function checkImports($customerID)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select check_imports('.$customerID.')'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->checkImports()');
		}
		$db->disconnect();
		if ($res->numRows()) {
			$row = $res->fetchRow();
			return $row[0];
		}
	}
	
	/**
	*Tikrinamas kliento sutarties suma nepasikeitė paskutinėse dviejuose sąskaituose
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer 
	*	return value:
	*	1 - Pasikeitė
	*	0 - Nepasikeitė
	*/

	public function checkContractWithInvoices($customerID)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select invoices.id,mountly_fee,quantity,contracts.modify_time,invoices.modify_time,case when NOW() - INTERVAL \'30 DAY\' < contracts.modify_time then 1 else 0 end from invoices,contracts,customers where invoices.contract_id=contracts.id and contracts.customer_id=customers.id and customers.id='.$customerID.' order by invoices.id desc limit 2'); 
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->checkImports()');
		}
		$db->disconnect();
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}	
	
	//Funkcionalumas susijas su VAT 
	
	/**
	*Tikrinamas ar mokėjimui sukurta VAT sąskaita
	*@param String $fileName Perlo failo pavadinimas
	*@param String $contractID Sutarties identifikacinis numeris
	*@param Numeris(8,2) $paymentQuantity Apmokėta suma iš failo
	*@return Array(integer,integer) 
	*	return value:
	*	1,vat_inv_no,vat_inv_quantity  - Importuota sėkmingai
	*	2,vat_inv_no,vat_inv_quantity - Importuota per didelė suma
	*	3,vat_inv_no,vat_inv_quantity - Importuota per maža suma
	* 	4,vat_inv_no,vat_inv_quantity - Atlikta per daug importų
	*	99,null,null - Neimportuota
	*/

	public function checkVatInvExistane($fileName,$contractID,$paymentQuantity)
	{
	
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select vat_inv_quantity,vat_inv_no,vat_inv_quantity from invoices where vat_oper_code like \''.$fileName.'\' and contract_id='.$contractID);
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->checkVatInvExistane()');
		}
		$db->disconnect();
		while ($row = $res->fetchRow()) {
		    $data[] = $row;
		}
		if (count($data) > 1) {
			return array(4,$data[0][1],$data[0][2]);
		}
		if (count($data) == 0) {
			return array(99,null);
		}
		if (count($data) == 1) {
			if ($data[0][0] == $paymentQuantity) {
				return array(1,$data[0][1],$data[0][2]);
			}
		}
		if (count($data) == 1) {
			if ($data[0][0] > $paymentQuantity) {
				return array(2,$data[0][1],$data[0][2]);
			}
			if ($data[0][0] < $paymentQuantity) {
				return array(3,$data[0][1],$data[0][2]);
			}
		}
		
		$db->disconnect();
		//return $data;
	}
	
	/**
	*Pataisomas sąskaitos numeris pagal standartą
	*@param Integer $invoiceNo Sąskaitos numeris
	*@return String Sąskaitos numeris su pridėtais priekyje nuliais
	*/

	public function modifyVatNo($invoiceNo)
	{
		$invMod = $invoiceNo;
		if ($invoiceNo < 10) {
			$invMod = '000000'.$invoiceNo;
		}
		if ($invoiceNo > 10 & $invoiceNo < 100) {
			$invMod = '00000'.$invoiceNo;
		}
		if ($invoiceNo > 100 & $invoiceNo < 1000) {
			$invMod = '0000'.$invoiceNo;
		}
		if ($invoiceNo > 1000 & $invoiceNo < 10000) {
			$invMod = '000'.$invoiceNo;
		}		
		if ($invoiceNo > 10000 & $invoiceNo < 100000) {
			$invMod = '00'.$invoiceNo;
		}				
		if ($invoiceNo > 100000 & $invoiceNo < 1000000) {
			$invMod = '0'.$invoiceNo;
		}			
		return $invMod;
	}

		
}
?>