<?php

require_once 'Connection.php';

/**
 * mons duomen valdymo klas
 *
 * Operacij su mons duomenimis valdymas
 *
 * @author     Mindaugas rimkus <mindaugas.rimkus@disigma.lt>
 */

class Company {

	/**
	 * Grainami mons duomenys pagal mons identifikacin numer
	 *
	 * @param int $companyID mons identifikacinis numeris
	 * @return Grainami mons duomenys pagal mons identifikacin numer
	 */
	
	public function getCompanyData($companyID) {
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select id,name,address,code,vat_code,phone,fax,is_deleted,record_time from company where id=?');
			$stmt->execute(array($companyID));
			$rows = array();
			$row = $stmt->fetch(PDO::FETCH_ASSOC);
			
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $row;
	}
	
	/**
	 * Grainamos pareigos pagal paiekos slyg
	 *
	 * @param String $search Paiekos slyga
	 *
	 * @return Grainamos pareigos pagal paiekos slyg
	 */
	
	public function getPosition($search) {
	
		$sql = "";
		if (strlen($search) > 0) {
			$sql .= " and lower(name) like lower('%".$search."%')";
		}
	
		$con = new Connection();
		$pdo = $con->getConnect();
		try {
			$stmt = $pdo->prepare('select id,name,is_deleted,record_time from position where is_deleted=false '.$sql.' order by position.name');
			$stmt->execute(array());
			$rows = array();
			while($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
				$rows[] = $row;
			}
		} catch(PDOException $e) {
			echo 'ERROR: ' . $e->getMessage();
		}
		return $rows;
	
	}
	
	
}
	
	// $con = new Connection();
	// $e = new Employer();
	// print_r($e->getData());
	
// $nam = new PassageSheet();
	// print_r($nam->insertPassageSheet('07/30/2014','07/30/2014','07/30/2014',115,37,2,'kk'));

?>