<?php
/**
 * Zend Framework
 *
 * LICENSE
 *
 * This source file is subject to the new BSD license that is bundled
 * with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://framework.zend.com/license/new-bsd
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@zend.com so we can send you a copy immediately.
 *
 * @category   Zend
 * @package    Zend_Navigation
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @version    $Id: AllTests.php 23522 2010-12-16 20:33:22Z andries $
 */

require_once 'PHPUnit/Framework/Constraint/TraversableContainsOnly.php';

if (!defined('PHPUnit_MAIN_METHOD')) {
    define('PHPUnit_MAIN_METHOD', 'Zend_Navigation_AllTests::main');
}

require_once 'Zend/Navigation/ContainerTest.php';
require_once 'Zend/Navigation/PageFactoryTest.php';
require_once 'Zend/Navigation/PageTest.php';
require_once 'Zend/Navigation/Page/AllTests.php';

/**
 * @category   Zend
 * @package    Zend_Navigation
 * @subpackage UnitTests
 * @copyright  Copyright (c) 2005-2010 Zend Technologies USA Inc. (http://www.zend.com)
 * @license    http://framework.zend.com/license/new-bsd     New BSD License
 * @group      Zend_Navigation
 */
class Zend_Navigation_AllTests
{
    public static function main()
    {
        PHPUnit_TextUI_TestRunner::run(self::suite());
    }

    public static function suite()
    {
        $suite = new PHPUnit_Framework_TestSuite('Zend Framework - Zend_Navigation');

        $suite->addTestSuite('Zend_Navigation_ContainerTest');
        $suite->addTestSuite('Zend_Navigation_PageFactoryTest');
        $suite->addTestSuite('Zend_Navigation_PageTest');
        $suite->addTest(Zend_Navigation_Page_AllTests::suite());

        return $suite;
    }
}

if (PHPUnit_MAIN_METHOD == 'Zend_Navigation_AllTests::main') {
    Zend_Navigation_AllTests::main();
}
