﻿<?php
/**
*Naujienų valdymas
*
*Naujienų formavimas
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Naujienų valdymas
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class News
{
	/**
	*Gražinamas visų universitetų vardų asociatyvus masyvas
	*@return Array Universitetų asociatyvus masyvas
	*/
	public function getAllUniversitiesAssoc()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name from universities');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Gražinamas visų fakultetų priklausančių tam tikram universitetui asociatyvus masyvas
	*@param Integer $universityID Universiteto identifikacinis numeris
	*@return Array Visi fakultetai priklausantys tam tikram universitetui
	*/
	public function getAllFacultiesAssoc($universityID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$universityID = trim($universityID);
		$data = $db->getAssoc('select id, name from faculties where university_id='.$universityID.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Gražinamas visų katedrų priklausančių tam tikram fakultetui asociatyvus masyvas
	*@param Integer $facultyID Fakulteto identifikacinis numeris
	*@return Array Visos katedros priklausančios tam tikram fakultetui
	*/
	public function getAllDepartmentsAssoc($facultyID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$facultyID = trim($facultyID);
		$data = $db->getAssoc('select id, name from department where faculty_id='.$facultyID.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Gražinamos visos specialybės dėstomos tam tikroje katedroje asociatyvus masyvas
	*@param Integer $departmentID Specialybės identifikacinis numeris
	*@return Array Visos specialybės priklausančios dėstotmos tam tikroje katedroje
	*/
	public function getAllSpecialitiesAssoc($departmentID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$departmentID = trim($departmentID);
		$data = $db->getAssoc('select id, name from speciality where department_id='.$departmentID.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Studento registracijos duomenys įrašomi į db.
	*@param String $student_no Studento pažymėjimo numeris
	*@param String $name Studento vardas
	*@param String $surname Studento pavardė
	*@param String $username Studento prisijungimo prie sistemos vardas
	*@param String $password Studento prisijungimo prie sistemos slaptažodis
	*@param String $email Studento elektroninis paštas
	*@param String $phone Studento telefono numeris
	*@param Integer $speciality_id Specialybės identifikacinis numeris
	*/
	public function insertStudent($student_no,$name,$surname,$username,$password,$email,$phone,$speciality_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO students (student_no,name,surname,username,password,email,phone,speciality_id) VALUES (?, ?, ?,?,?,?,?,?)');
		$data = array($student_no,$name,$surname,$username,$password,$email,$phone,$speciality_id);
		$db->execute($query, $data);
	}
}
/** 
* Įmonių registracijos SQL apdorojimas
*
* Gražinami asocijuotieji masyvai veiklų kategorijų bei veiklų pokategorijos. Registracijos duomenys įrašomi į DB.
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class CompanyRegisterSQL
{
	/**
	*Gražinamos visos aukščiausio lygio darbų kategorijų asociatyvus masyvas
	*@return Array Aukščiausio lygio darbų kategorijų asociatyvus masyvas
	*/
	public function getCategories()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name from categories');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Gražinamos visų pakategorijų asociatyvus masyvas
	*@param Integer $categoryID Kategorijos identifikacinis numeris
	*@param Array $exceptionsID Pakategorijų identifikaciniai numeriai kurie nebus itraukiami į galutini rezultatą
	*@return Array Visos abstrakčioje kategorijoje esančios pakategorijos
	*/
	public function getAllSubcategories($categoryID,$exceptionsID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$categoryID = trim($categoryID);
		if ($exceptionsID) {
			foreach ($exceptionsID as $id) {
				$str .= ' and id<>'.$id;
			}
			$data = $db->getAssoc('select id, name from subcategories where category_id='.$categoryID.' '.$str.' order by id');
		} else {
			$data = $db->getAssoc('select id, name from subcategories where category_id='.$categoryID.' order by id');
		}
		
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Gražinamas paketegorijos vardas
	*@param Integer $subCategoryID Pakategorijos identifikacinis numeris
	*@return String Pakategorijos pavadinimas
	*/
	public function getSubcategory($subCategoryID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$subCategoryID = trim($subCategoryID);
		$result = $db->query('select name from subcategories where id='.$subCategoryID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	/**
	*Įmonės registracijos duomenys įrašomi į db.
	*@param Array $dataFromCreditreform Duomenys apie registruojamą įmonę iš Creditreform duomenų bazių
	*@param Array $dataFromForms Įmonės atstovo užpyldyti formos duomenys
	*@param Array $selectedSubcategories Įmonės pasirinktų pakategorijų identifikaciniai numeriai
	*/
	public function insertCompany($dataFromCreditreform,$dataFromForms,$selectedSubcategories)
	{
		
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO companies (name,contact_person_name,contact_person_surname,activity_desc,username,password,email,phone,fax,code,contact_person_phone,contact_person_email,chief_role,chief_name,chief_surname,address,register_date) VALUES (?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)');
		$dataFromCreditreform[1] = preg_replace("/<\/td>/","",$dataFromCreditreform[1]);
		$dataFromCreditreform[1] = trim($dataFromCreditreform[1]);
		//$data = array('imonespavadinimas',$dataFromForms['input_contact_person_name'],$dataFromForms['input_contact_person_surname'],$dataFromForms['input_activity_desc'],$dataFromForms['input_username'],$dataFromForms['input_password'],$dataFromForms['input_email'],$dataFromForms['input_phone'],$dataFromForms['input_fax'],$dataFromCreditreform[0],$dataFromForms['input_contact_person_phone'],$dataFromForms['input_contact_person_email'],$dataFromCreditreform[2],$dataFromCreditreform[3],$dataFromCreditreform[4],$dataFromCreditreform[5],$dataFromCreditreform[6]);
		$data = array($dataFromCreditreform[1],$dataFromForms['input_contact_person_name'],$dataFromForms['input_contact_person_surname'],$dataFromForms['input_activity_desc'],$dataFromForms['input_username'],$dataFromForms['input_password'],$dataFromForms['input_email'],$dataFromForms['input_phone'],$dataFromForms['input_fax'],$dataFromCreditreform[0],$dataFromForms['input_contact_person_phone'],$dataFromForms['input_contact_person_email'],$dataFromCreditreform[2],$dataFromCreditreform[3],$dataFromCreditreform[4],$dataFromCreditreform[5],$dataFromCreditreform[6]);
		//echo 'INSERT INTO companies (name,contact_person_name,contact_person_surname,activity_desc,username,password,email,phone,fax,code,contact_person_phone,contact_person_email,chief_role,chief_name,chief_surname,address,register_date) VALUES (?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)'."<br />";
		//print_r($data);
		$db->execute($query, $data);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Blogi įvedimo duomenys');
		} else {
			$result = $db->query('select id from companies where code=\''.$dataFromCreditreform[0].'\'');
			$result->fetchInto($row);
			$compananyID = $row[0];
			foreach ($selectedSubcategories as $compSubcat) {
				$data = array($compSubcat,$compananyID);
				$query = $db->prepare('insert into company_subcategories (subcategory_id,company_id) VALUES (?, ?)');
				$db->execute($query, $data);
			}
		}
	}
	
}

/** 
* Studentų duomenų valdymas
*
* Gražinami studentų duomenų asociatyvieji masyvai, taip pat keičiami duomenų studentų įrašai
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class StudentsData
{
	/**
	*Gražinami studentų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš students lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurie bus ieškomą (Studento pažymėjimo numeris, vardas, pavardė, prisijungimo vardas, elektroninis paštas, telefonas)
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getStudents($offset,$search,$choise)
	{
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (!$search && !$choise) {
			$data = $db->getAssoc('select id, student_no, name, surname from students order by id limit 10 offset '.$offset);
		}
		if ($choise == 1) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where student_no like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 2) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 3) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 4) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where username like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 5) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 6) {
			$data = $db->getAssoc('select id, student_no, name, surname from students where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		$db->disconnect();
		return $data;
	}
	/**
	*Stundentų kiekis sistemoje
	*@return Integer Studentų skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getStudentsCount()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from students');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	/**
	*Gražinami detalūs studento duomenys
	*@param Integer $id Studento identifikacinis numeris
	*@return Array Studento duomenys
	*/
	public function getStudent($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, student_no, name, surname, username, password, email, phone, flag, speciality_id, block from students where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		$key = array_keys($data);
		$good = $key[0];
		if (!$data[$good][8]) {
			$db->disconnect();
			return $data;
		}
		//--
		$result = $db->query('select name from speciality where id='.$data[$good][8]);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($speciality);
		$db->disconnect();
		$data[$good][8] = $speciality[0];
		return $data;
	}
	/**
	*Stundentų kiekis sistemoje, pagal paieškos sąlygą
	*@return Integer Studentų skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getStudentsCountBySearch($search,$choise)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$search = trim($search);
		if ($choise == 1) {
			$result = $db->query('select count(id) from students where student_no like \'%'.$search.'%\'');
		}
		if ($choise == 2) {
			$result = $db->query('select count(id) from students where name like \'%'.$search.'%\'');
		}
		if ($choise == 3) {
			$result = $db->query('select count(id) from students where surname like \'%'.$search.'%\'');
		}
		if ($choise == 4) {
			$result = $db->query('select count(id) from students where username like \'%'.$search.'%\'');
		}
		if ($choise == 5) {
			$result = $db->query('select count(id) from students where email like \'%'.$search.'%\'');
		}
		if ($choise == 6) {
			$result = $db->query('select count(id) from students where phone like \'%'.$search.'%\'');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Studento slaptažodžio keitimas.
	*@param Integer $id Studento registracijos identifikacinis numeris
	*@param String $password Naujas studento slaptažodis
	*/
	public function updateStudentPassword($id, $password)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update students set password=? where id=?');
		$db->execute($query, array($password,$id));
	}
	
	/**
	*Studento telefono ir elektroninio pašto keitimas.
	*@param Integer $id Studento registracijos identifikacinis numeris
	*@param String $email Naujas eletroninio pašto adresas
	*@param String $phone Naujas telefono numeris
	*/
	public function updateStudentInfo($id, $email, $phone)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update students set email=?, phone=? where id=?');
		$db->execute($query, array($email,$phone,$id));
	}
	
	/**
	*Studento blokavimo statuso keitimas
	*@param Integer $id Studento registracijos identifikacinis numeris
	*@param Boolean $blockstatus Blokavimo statusas
	*/
	public function updateBlockStatus($id, $blockstatus)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update students set block=? where id=?');
		$db->execute($query, array($blockstatus,$id));
	}
	
	/**
	*Studentas pašalinimas iš sistemos.
	*@param Integer $id Studento registracijos identifikacinis numeris
	*@return 1 - Studentas pašalintas sėkmingai, 0 - studento pašalinimo klaida
	*/
	public function removeStudent($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from students where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$res = $db->execute($query, array($id));
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* Dėstytojų duomenų valdymas
*
* Gražinami dėstytojų duomenų asociatyvieji masyvai, taip pat keičiami duomenų dėstytojų įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class TeachersData extends StudentRegisterSQL
{
	/**
	*Gražinamas universiteto pavadinimas
	*@param Integer $universityID Universiteto identifikacinis numeris
	*@return String Universiteto pavadinimas
	*/
	public function getUniversity($universityID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$universityID = trim($universityID);
		$result = $db->query('select name from universities where id='.$universityID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	/**
	*Gražinamas fakulteto pavadinimas
	*@param Integer $facultyID fakulteto identifikacinis numeris
	*@return String fakulteto pavadinimas
	*/
	public function getFaculty($facultyID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$facultyID = trim($facultyID);
		$result = $db->query('select name from faculties where id='.$facultyID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	/**
	*Gražinamas katedros pavadinimas
	*@param Integer $departmentID katedros identifikacinis numeris
	*@return String katedros pavadinimas
	*/
	public function getDepartment($departmentID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$departmentID = trim($departmentID);
		$result = $db->query('select name from department where id='.$departmentID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Dėstytojų registracijos duomenys įrašomi į db.
	*@param String $name Dėstytojo vardas
	*@param String $surname Dėstytojo pavardė
	*@param String $username Dėstytojo prisijungimo prie sistemos vardas
	*@param String $password Dėstytojo prisijungimo prie sistemos slaptažodis
	*@param String $email Dėstytojo elektroninis paštas
	*@param String $phone Dėstytojo telefono numeris
	*/
	public function insertTeacher($name,$surname,$username,$password,$email,$phone,$department_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into teachers (name,surname,username,password,email,phone,department_id) VALUES (?, ?, ?,?,?,?,?)');
		$data = array($name,$surname,$username,$password,$email,$phone,$department_id);
		$db->execute($query, $data);
	}

	/**
	*Dėstytojų kiekis sistemoje
	*@return Integer Dėstytojų skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getTeachersCount()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from teachers');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Dėstytojų kiekis sistemoje, pagal paieškos sąlygą
	*@return Integer Dėstytojų skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getTeachersCountBySearch($search,$choise)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$search = trim($search);
		if ($choise == 1) {
			$result = $db->query('select count(id) from teachers where name like \'%'.$search.'%\'');
		}
		if ($choise == 2) {
			$result = $db->query('select count(id) from teachers where surname like \'%'.$search.'%\'');
		}
		if ($choise == 3) {
			$result = $db->query('select count(id) from teachers where username like \'%'.$search.'%\'');
		}
		if ($choise == 4) {
			$result = $db->query('select count(id) from teachers where email like \'%'.$search.'%\'');
		}
		if ($choise == 5) {
			$result = $db->query('select count(id) from teachers where phone like \'%'.$search.'%\'');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	/**
	*Gražinami Dėstytojų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš teachers lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurie bus ieškomą (vardas, pavardė, prisijungimo vardas, elektroninis paštas, telefonas)
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getTeachers($offset,$search,$choise)
	{
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (!$search && !$choise) {
			$data = $db->getAssoc('select id, name, surname from teachers order by id limit 10 offset '.$offset);
		}
		if ($choise == 1) {
			$data = $db->getAssoc('select id, name, surname from teachers where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 2) {
			$data = $db->getAssoc('select id, name, surname from teachers where surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 3) {
			$data = $db->getAssoc('select id, name, surname from teachers where username like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 4) {
			$data = $db->getAssoc('select id, name, surname from teachers where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 5) {
			$data = $db->getAssoc('select id, name, surname from teachers where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta teachers lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs dėstytojo duomenys
	*@param Integer $id dėstytojo identifikacinis numeris
	*@return Array Dėstytojo duomenys
	*/
	public function getTeacher($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, surname, username, password, email, phone, department_id from teachers where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta teachers lentelė');
		}
		$key = array_keys($data);
		$good = $key[0];
		if (!$data[$good][6]) {
			$db->disconnect();
			return $data;
		}
		//--
		$result = $db->query('select name from department where id='.$data[$good][6]);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($department);
		$db->disconnect();
		$data[$good][6] = $department[0];
		return $data;
	}

	/**
	*Dėstytojo slaptažodžio keitimas.
	*@param Integer $id Dėstytojo registracijos identifikacinis numeris
	*@param String $password Naujas dėstytojo slaptažodis
	*/
	public function updateTeacherPassword($id, $password)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update teachers set password=? where id=?');
		$db->execute($query, array($password,$id));
	}

	/**
	*Gražinami dėstytojui priskirti moduliai
	*@param Integer $id dėstytojo identifikacinis numeris
	*@return Array Dėstytojo duomenys
	*/
	public function getAssignedTeacherModules($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, practice_module_id from teachers_modules where teacher_id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta teachers_modules lentelė');
		}
		$db->disconnect();
		//print_r($data);
		//echo "\n\n";
		foreach ($data as $key=>$value) {
			//echo $value;
			$connect = new Connect();
			$db = $connect->getConnect();
			$result = $db->query('select id, code, study_program, name,requirement, description, goal, speciality_id from pratice_modules where id='.$value);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta pratice_modules lentelė');
			}
			$result->fetchInto($pratice_modules);
			$specialityArray = $this->getSpecialityArray($pratice_modules[7]);
			$departmentArray = $this->getDepartmentArray($specialityArray[1]);
			$facultyArray = $this->getFacultyArray($departmentArray[1]);
			$university = $this->getUniversity($facultyArray[1]);
			$data[$key] = array($pratice_modules[0], $pratice_modules[1], $pratice_modules[2], $pratice_modules[3], $pratice_modules[4], $pratice_modules[5], $pratice_modules[6],$specialityArray[0], $departmentArray[0],$facultyArray[0],$university);
			$db->disconnect();
		}

		return $data;

	}
	
	/**
	*Gražinamas specialybės pavadinimas ir katedros kodas
	*@param Integer $id Specialybės identifikacinis numeris
	*@return Array("Specialybės pavadinimas","Katedros kodas") Gražinamas specialybės pavadinimas ir katedros kodas
	*/
	public function getSpecialityArray($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name, department_id from speciality where id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return array($data[0],$data[1]);
	}
	
	/**
	*Gražinamas katedros pavadinimas ir fakulteto kodas
	*@param Integer $id Katedros identifikacinis numeris
	*@return Array("Katedros pavadinimas","Fakulteto kodas") Gražinamas katedros pavadinimas ir fakulteto kodas
	*/
	public function getDepartmentArray($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name, faculty_id from department where id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return array($data[0],$data[1]);
	}

	/**
	*Gražinamas Fakulteto pavadinimas ir universite kodas
	*@param Integer $id Fakulteto identifikacinis numeris
	*@return Array("Fakulteto pavadinimas","Universiteto kodas") Gražinamas Fakulteto pavadinimas ir universito kodas
	*/
	public function getFacultyArray($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name, university_id from faculties where id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return array($data[0],$data[1]);
	}
	
	/**
	*Gražinamas visų praktikos modulių priklausančių tam tikram specialybei asociatyvus masyvas
	*@param Integer $specialityid Specialybės identifikacinis numeris
	*@return Array Visi praktikos moduliai priklausantys tam tikram universitetui
	*/
	public function getAllPracticeModulesAssoc($specialityid)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$specialityid = trim($specialityid);
		$data = $db->getAssoc('select id, code, name from pratice_modules where speciality_id='.$specialityid.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinamas specialybės pavadinimas
	*@param Integer $specialityid specialybės identifikacinis numeris
	*@return String specialybės pavadinimas
	*/
	public function getSpeciality($specialityid)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$specialityid = trim($specialityid);
		$result = $db->query('select name from speciality where id='.$specialityid);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinamas praktikos modulio kodas ir pavadinimas
	*@param Integer $practicemoduleid praktikos modulio identifikacinis numeris
	*@return Array praktikos modulio pavadinimas ir kodas
	*/
	public function getPracticeModuleCodeName($practicemoduleid)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$practicemoduleid = trim($practicemoduleid);
		$result = $db->query('select code,name from pratice_modules where id='.$practicemoduleid);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return array($data[0],$data[1]);
	}
	
	/**
	*Tikrinama ar dėstytojui nėra priskirtas modulis korio id pateikiamas kaip metodo parametras
	*@param Integer $teacherid dėstytojo identifikacinis numeris
	*@param Integer $moduleid praktikos modulio identifikacinis numeris
	*@return 0 - Modulis nėra priskirtas dėstytojui, 1 - modulis yra priskirtas dėstytojui
	*/
	public function checkTeacherModule($moduleid, $teacherid)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$moduleid = trim($moduleid);
		$teacherid = trim($teacherid);
		$result = $db->query('select id from teachers_modules where teacher_id='.$teacherid.' and practice_module_id='.$moduleid);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		if (isset($data[0])) {
			return 1;
		} else {
			return 0;
		}
	}
	
	/**
	*Tikrinama ar kitam dėstytojui nėra priskirtas modulis korio id pateikiamas kaip metodo parametras
	*@param Integer $teacherid einamojo dėstytojo identifikacinis numeris
	*@param Integer $moduleid praktikos modulio identifikacinis numeris
	*@return 0 - Modulis nėra priskirtas kitam dėstytojui, 1 - modulis yra priskirtas dėstytojui
	*/
	public function checkAssignedOtherTeacherModule($moduleid, $teacherid)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$moduleid = trim($moduleid);
		$teacherid = trim($teacherid);
		$result = $db->query('select id from teachers_modules where teacher_id<>'.$teacherid.' and practice_module_id='.$moduleid);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		if (isset($data[0])) {
			return 1;
		} else {
			return 0;
		}
	}
	
	/**
	*Dėstytojui priskiriama praktikos darbo administravimo kategorija.
	*@param String $practiceModuleID Praktikos darbo identifikacinis numeris
	*@param String $teacherID Dėstytojo identifikacinis numeris
	*/
	public function insertTeacherPracticeModule($practiceModuleID,$teacherID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into teachers_modules (teacher_id,practice_module_id) VALUES (?, ?)');
		$data = array($teacherID,$practiceModuleID);
		$db->execute($query, $data);
	}
	
	/**
	*Pašalinama dėstytojui priskirta praktikos kategorija.
	*@param Integer $teacherModelID Dėstytojui priskirto modulio ID
	*/
	public function removeTeacherPracticeModule($teacherModelID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from teachers_modules where id=?');
		$db->execute($query, $teacherModelID);
	}

	/**
	*Dėstytojo telefono ir elektroninio pašto keitimas.
	*@param Integer $id Dėstytojo registracijos identifikacinis numeris
	*@param String $email Naujas eletroninio pašto adresas
	*@param String $phone Naujas telefono numeris
	*/
	public function updateTeacherInfo($id, $email, $phone)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update teachers set email=?, phone=? where id=?');
		$db->execute($query, array($email,$phone,$id));
	}
	
	
	/**
	*Tikrinama ar galima pašalinti dėstytojui priskirtą modulį
	*@param Integer $practiceModuleID dėstytojui priskirto praktikos modulio identifikacinis numeris
	*@return 1 - Modulį galima pašalinti, 0 - modulio negalima pašalinti
	*/
	public function canRemove($practiceModuleID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$practiceModuleID = trim($practiceModuleID);
		$result = $db->query('select id from teachers_modules where id='.$practiceModuleID.' and closed=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		if (isset($data[0])) {
			return 0;
		} else {
			return 1;
		}
	}
}


/** 
* Administratorių duomenų valdymas
*
* Gražinami administratorių duomenų asociatyvieji masyvai, taip pat keičiami duomenų administratorių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class AdminsData
{
	/**
	*Administratoriaus registracijos duomenys įrašomi į db.
	*@param String $name Administratoriaus vardas
	*@param String $surname Administratoriaus pavardė
	*@param String $username Administratoriaus prisijungimo prie sistemos vardas
	*@param String $password Administratoriaus prisijungimo prie sistemos slaptažodis
	*@param String $email Administratoriaus elektroninis paštas
	*@param String $phone Administratoriaus telefono numeris
	*/
	public function insertAdmin($name,$surname,$username,$password,$email,$phone)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO admins (name,surname,username,password,email,phone) VALUES (?, ?, ?,?,?,?)');
		$data = array($name,$surname,$username,$password,$email,$phone);
		$db->execute($query, $data);
	}
	
	/**
	*Administratorių kiekis sistemoje
	*@return Integer Administratorių skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getAdminsCount()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from admins');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta admins lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Administratorių kiekis sistemoje, pagal paieškos sąlygą
	*@return Integer Administratorių skaičius kurie yra prisiregistravę sistemoje
	*/
	public function getAdminsCountBySearch($search,$choise)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$search = trim($search);
		if ($choise == 1) {
			$result = $db->query('select count(id) from admins where name like \'%'.$search.'%\'');
		}
		if ($choise == 2) {
			$result = $db->query('select count(id) from admins where surname like \'%'.$search.'%\'');
		}
		if ($choise == 3) {
			$result = $db->query('select count(id) from admins where username like \'%'.$search.'%\'');
		}
		if ($choise == 4) {
			$result = $db->query('select count(id) from admins where email like \'%'.$search.'%\'');
		}
		if ($choise == 5) {
			$result = $db->query('select count(id) from admins where phone like \'%'.$search.'%\'');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta admins lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Administratorių duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš admins lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurie bus ieškomą (vardas, pavardė, prisijungimo vardas, elektroninis paštas, telefonas)
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getAdmins($offset,$search,$choise)
	{
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (!$search && !$choise) {
			$data = $db->getAssoc('select id, name, surname from admins order by id limit 10 offset '.$offset);
		}
		if ($choise == 1) {
			$data = $db->getAssoc('select id, name, surname from admins where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 2) {
			$data = $db->getAssoc('select id, name, surname from admins where surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 3) {
			$data = $db->getAssoc('select id, name, surname from admins where username like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 4) {
			$data = $db->getAssoc('select id, name, surname from admins where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 5) {
			$data = $db->getAssoc('select id, name, surname from admins where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta admins lentelė');
		}
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinami detalūs administratoriaus duomenys
	*@param Integer $id administratoriaus identifikacinis numeris
	*@return Array administratoriaus duomenys
	*/
	public function getAdmin($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, surname, username, password, email, phone from admins where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta admins lentelė');
		}
		$db->disconnect();
		return $data;
	}
	

	/**
	*Administratoriaus slaptažodžio keitimas.
	*@param Integer $id Administratoriaus registracijos identifikacinis numeris
	*@param String $password Naujas administratoriaus slaptažodis
	*/
	public function updateAdminPassword($id, $password)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update admins set password=? where id=?');
		$db->execute($query, array($password,$id));
	}
	
	/**
	*Administratoriaus pašalinimas iš sistemos.
	*@param Integer $id Administratoriaus registracijos identifikacinis numeris
	*@return 1 - Administratorius pašalintas sėkmingai, 0 - administratoriaus pašalinimo klaida
	*/
	public function removeAdmin($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from admins where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$res = $db->execute($query, array($id));
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* Universitetų duomenų valdymas
*
* Gražinami universitetų duomenų asociatyvieji masyvai, taip pat keičiami duomenų universitetų įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class UniversitiesData
{
	/**
	*Universitetų kiekis sistemoje
	*@return Integer Universitetų skaičius sistemoje
	*/
	public function getUniversitiesCount()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from universities');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Universitetų kiekis sistemoje, pagal paieškos sąlygą
	*@return Integer Universitetų skaičius sistemoje
	*/
	public function getUniversitiesCountBySearch($search,$choise)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$search = trim($search);
		if ($choise == 1) {
			$result = $db->query('select count(id) from universities where name like \'%'.$search.'%\'');
		}
		if ($choise == 2) {
			$result = $db->query('select count(id) from universities where city like \'%'.$search.'%\'');
		}
		if ($choise == 3) {
			$result = $db->query('select count(id) from universities where street like \'%'.$search.'%\'');
		}
		if ($choise == 4) {
			$result = $db->query('select count(id) from universities where code like \'%'.$search.'%\'');
		}
		if ($choise == 5) {
			$result = $db->query('select count(id) from universities where company_code like \'%'.$search.'%\'');
		}
		if ($choise == 6) {
			$result = $db->query('select count(id) from universities where phone like \'%'.$search.'%\'');
		}
		if ($choise == 7) {
			$result = $db->query('select count(id) from universities where fax like \'%'.$search.'%\'');
		}
		if ($choise == 8) {
			$result = $db->query('select count(id) from universities where email like \'%'.$search.'%\'');
		}
		if ($choise == 9) {
			$result = $db->query('select count(id) from universities where www like \'%'.$search.'%\'');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	
	/**
	*Gražinami Universitetų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš universities lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (universiteto pavadinimas,miestą kuriame yra universitetas, gatvę kurioje yra universitetas, gatvės kodas kurioje yra universitetas,įmonės kodas, universiteto telefonas, universiteto faksas, universiteto elektroninis paštas, universiteto internetinis adresas)
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getUniversities($offset,$search,$choise)
	{
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (!$search && !$choise) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities order by id limit 10 offset '.$offset);
		}
		if ($choise == 1) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 2) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where city like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 3) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where street like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 4) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 5) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where company_code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 6) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 7) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 8) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if ($choise == 9) {
			$data = $db->getAssoc('select id, name, city, street, code, company_code, phone, fax, email, www from universities where www like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinami detalūs universiteto duomenys
	*@param Integer $id universiteto identifikacinis numeris
	*@return Array universiteto duomenys
	*/
	public function getUniversity($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, city, street, street_no, code, company_code, phone, fax, email, www from universities where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Universiteto registracijos duomenys įrašomi į db.
	*@param String $name Universiteto pavadinimas
	*@param String $city Miestas kuriame yra universitetas
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $company_code Įmonės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*/
	public function insertUniversity($name,$city,$street,$street_no,$code,$company_code,$phone,$fax,$email,$www)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into universities (name,city,street,street_no,code,company_code,phone,fax,email,www) VALUES (?, ?, ?,?,?,?,?,?,?,?)');
		$data = array($name,$city,$street,$street_no,$code,$company_code,$phone,$fax,$email,$www);
		$db->execute($query, $data);
	}
	
	/**
	*Redaguojami universiteto duomenys.
	*@param String $university_id Universiteto identifikacinis numeris
	*@param String $name Universiteto pavadinimas
	*@param String $city Miestas kuriame yra universitetas
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $company_code Įmonės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*/
	public function updateUniversity($university_id,$name,$city,$street,$street_no,$code,$company_code,$phone,$fax,$email,$www)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update universities set name=?,city=?,street=?,street_no=?,code=?,company_code=?,phone=?,fax=?,email=?,www=? where id=?');
		$data = array($name,$city,$street,$street_no,$code,$company_code,$phone,$fax,$email,$www,$university_id);
		$db->execute($query, $data);
	}
	
	/**
	*Universiteto pašalinimas iš DB.
	*@param String $university_id Universiteto identifikacinis numeris
	*@return Integer 1 - universitetas sėkmingai pašalintas iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteUniversity($university_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from universities where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($university_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* Fakultetų duomenų valdymas
*
* Gražinami fakultetų duomenų asociatyvieji masyvai, taip pat keičiami duomenų fakultetų įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class FacultiesData extends TeachersData
{

	/**
	*Fakultetų kiekis sistemoje
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@return Integer fakultetų skaičius sistemoje
	*/
	public function getFacultiesCount($university_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($university_id)) {
			$result = $db->query('select count(id) from faculties where university_id='.$university_id);
		} else {
			$result = $db->query('select count(id) from faculties');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Fakultetų kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@return Integer Fakultetų skaičius sistemoje
	*/
	public function getFacultiesCountBySearch($search,$choise,$university_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($university_id)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from faculties where name like \'%'.$search.'%\'');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from faculties where city like \'%'.$search.'%\'');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from faculties where street like \'%'.$search.'%\'');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from faculties where code like \'%'.$search.'%\'');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from faculties where phone like \'%'.$search.'%\'');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from faculties where fax like \'%'.$search.'%\'');
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from faculties where email like \'%'.$search.'%\'');
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from faculties where www like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from faculties where name like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from faculties where city like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from faculties where street like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from faculties where code like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from faculties where phone like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from faculties where fax like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from faculties where email like \'%'.$search.'%\' and university_id='.$university_id);
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from faculties where www like \'%'.$search.'%\' and university_id='.$university_id);
			}			
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami fakultetų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš fakulteto lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (fakulteto pavadinimas,miestą kuriame yra fakultetas, gatvę kurioje yra fakultetas, gatvės kodas kurioje yra fakultetas, fakulteto telefonas, fakulteto faksas, fakulteto elektroninis paštas, fakulteto internetinis adresas)
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getFaculties($offset,$search,$choise,$university_id)
	{
		//$university_id = trim($university_id);
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($university_id)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and city like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and street like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where university_id='.$university_id.' and www like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where city like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where street like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from faculties where www like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs fakulteto duomenys
	*@param Integer $id fakulteto identifikacinis numeris
	*@return Array fakulteto duomenys
	*/
	public function getFaculty($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, city, street,street_no, code, phone, fax, email, www, university_id from faculties where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Fakulteto registracijos duomenys įrašomi į db.
	*@param Integer $university_id universiteto identifikacinis numeris
	*@param String $name Fakulteto pavadinimas
	*@param String $city Miestas kuriame yra fakultetas
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*/
	public function insertFaculty($university_id,$name,$city,$street,$street_no,$code,$phone,$fax,$email,$www)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into faculties (name,city,street,street_no,code,phone,fax,email,www,university_id) VALUES (?, ?,?,?,?,?,?,?,?,?)');
		$data = array($name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$university_id);
		$db->execute($query, $data);
	}
	
	/**
	*Redaguojami fakulteto duomenys.
	*@param String $faculty_id Fakulteto identifikacinis numeris
	*@param String $name Fakulteto pavadinimas
	*@param String $city Miestas kuriame yra fakultetas
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*/
	public function updateFaculty($faculty_id,$name,$city,$street,$street_no,$code,$phone,$fax,$email,$www)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update faculties set name=?,city=?,street=?,street_no=?,code=?,phone=?,fax=?,email=?,www=? where id=?');
		$data = array($name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$faculty_id);
		$db->execute($query, $data);
	}
	
	/**
	*Fakulteto pašalinimas iš DB.
	*@param String $faculty_id Fakulteto identifikacinis numeris
	*@return Integer 1 - fakultetas sėkmingai pašalintas iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteFaculty($faculty_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from faculties where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($faculty_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* katedrų duomenų valdymas
*
* Gražinami katedrų duomenų asociatyvieji masyvai, taip pat keičiami duomenų katedrų įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class DepartmentsData extends FacultiesData
{
	/**
	*Gražinamas fakulteto pavadinimas
	*@param String $faculty_id Fakulteto identifikacinis numeris
	*@return String Fakulteto pavadinimas
	*/
	function getFacultyName($faculty_id) {
		$detailFaculty = parent::getFaculty($faculty_id);
		return $detailFaculty[$faculty_id][0];
	}
	
	/**
	*Gražinami katedrų identifikacinių numerių masyvas
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@param Integer $faculty_id Fakulteto identifikacinis numeris
	*@return Array katedrų identifikacinių numerių masyvas
	*/
	public function getDepartmensID($university_id,$faculty_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$faculties = array();
		$db = $connect->getConnect();
		if (isset($faculty_id)) {
			$faculties[0] = $faculty_id;
			return $faculties;
			
		} elseif (isset($university_id)) {
			$result = $db->query('select id from faculties where university_id='.$university_id);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta faculties lentelė');
			}
			while ($result->fetchInto($data)) {
				$faculties[] = $data[0];
			}
			$db->disconnect();
		}
		return $faculties;
	}
	
	/**
	*Katedrų kiekis sistemoje
	*@param Integer $ids fakultetų identifikacinių numerių masyvas
	*@return Integer katedrų skaičius sistemoje
	*/
	public function getDepartmentsCount($ids)
	{
		//$university_id = trim($university_id);
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " faculty_id=".$ids[$i]." or ";
			} else {
				$str .= " faculty_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			$result = $db->query('select count(id) from department where '.$str);
		} else {
			$result = $db->query('select count(id) from department');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Katedrų kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $ids fakultetų identifikacinių numerių masyvas
	*@return Integer Katedrų skaičius sistemoje
	*/
	public function getDepartmentsCountBySearch($search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " faculty_id=".$ids[$i]." or ";
			} else {
				$str .= " faculty_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($ids)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from department where name like \'%'.$search.'%\'');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from department where city like \'%'.$search.'%\'');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from department where street like \'%'.$search.'%\'');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from department where code like \'%'.$search.'%\'');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from department where phone like \'%'.$search.'%\'');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from department where fax like \'%'.$search.'%\'');
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from department where email like \'%'.$search.'%\'');
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from department where www like \'%'.$search.'%\'');
			}
			if ($choise == 9) {
				$result = $db->query('select count(id) from department where chief_name like \'%'.$search.'%\'');
			}
			if ($choise == 10) {
				$result = $db->query('select count(id) from department where chief_surname like \'%'.$search.'%\'');
			}
			if ($choise == 11) {
				$result = $db->query('select count(id) from department where chief_email like \'%'.$search.'%\'');
			}
			if ($choise == 12) {
				$result = $db->query('select count(id) from department where chief_phone like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from department where name like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from department where city like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from department where street like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from department where code like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from department where phone like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from department where fax like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from department where email like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from department where www like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 9) {
				$result = $db->query('select count(id) from department where chief_name like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 10) {
				$result = $db->query('select count(id) from department where chief_surname like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 11) {
				$result = $db->query('select count(id) from department where chief_email like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 12) {
				$result = $db->query('select count(id) from department where chief_phone like \'%'.$search.'%\' and ('.$str.')');
			}			
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami katedrų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš katedrų lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (katedros pavadinimas,miestą kuriame yra katedra, gatvę kurioje yra katedra, gatvės kodas kurioje yra katedra, katedros telefonas, katedros faksas, katedros elektroninis paštas, katedros internetinis adresas, katedros vadovo vardas, katedros vadovo pavardė, katedros vadovo email, katedros vadovo telefonas)
	*@param Integer $ids fakultetų identifikacinių numerių masyvas
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getDepartments($offset,$search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " faculty_id=".$ids[$i]." or ";
			} else {
				$str .= " faculty_id=".$ids[$i]." ";
			}
		}
		//$university_id = trim($university_id);
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and city like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and street like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and www like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 9) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and chief_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 10) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and chief_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 11) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and chief_email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 12) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where ('.$str.') and chief_phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where city like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where street like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where www like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 9) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where chief_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 10) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where chief_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 11) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where chief_email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 12) {
				$data = $db->getAssoc('select id, name, city, street, code, phone, fax, email, www from department where chief_phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs katedros duomenys
	*@param Integer $id katedros identifikacinis numeris
	*@return Array katedros duomenys
	*/
	public function getDepartment($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, city, street,street_no, code, phone, fax, email, www, chief_name, chief_surname, chief_email, chief_phone, faculty_id from department where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Katedros registracijos duomenys įrašomi į db.
	*@param Integer $faculty_id fakulteto identifikacinis numeris
	*@param String $name Katedros pavadinimas
	*@param String $city Miestas kuriame yra katedra
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*@param String $chief_name Katedros vadovo vardas
	*@param String $chief_surname Katedros vadovo pavardė
	*@param String $chief_email Katedros vadovo email
	*@param String $chief_phone Katedros vadovo telefonas
	*/
	public function insertDepartment($faculty_id,$name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$chief_name,$chief_surname,$chief_email,$chief_phone)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		//echo "$name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$chief_name,$chief_surname,$chief_email,$chief_phone,$university_id";
		$query = $db->prepare('insert into department (name,city,street,street_no,code,phone,fax,email,www,chief_name,chief_surname,chief_email,chief_phone,faculty_id) VALUES (?, ?,?,?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$chief_name,$chief_surname,$chief_email,$chief_phone,$faculty_id);
		$db->execute($query, $data);
	}
	
	/**
	*Redaguojami katedros duomenys.
	*@param String $department_id katedros identifikacinis numeris
	*@param String $name Fatedros pavadinimas
	*@param String $city Miestas kuriame yra katedra
	*@param String $street Gatvės pavadinimas
	*@param String $street_no Pastato numeris
	*@param String $code Gatvės kodas
	*@param String $phone Telefono numeris
	*@param String $fax Fakso numeris
	*@param String $email Elektroninio pašto adresas
	*@param String $www Interneto svetainės adresas
	*@param String $chief_name Katedros vadovo vardas
	*@param String $chief_surname Katedros vadovo pavardė
	*@param String $chief_email Katedros vadovo email
	*@param String $chief_phone Katedros vadovo telefonas
	*/
	public function updateDepartment($department_id,$name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$chief_name,$chief_surname,$chief_email,$chief_phone)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update department set name=?,city=?,street=?,street_no=?,code=?,phone=?,fax=?,email=?,www=?,chief_name=?,chief_surname=?,chief_email=?,chief_phone=? where id=?');
		$data = array($name,$city,$street,$street_no,$code,$phone,$fax,$email,$www,$chief_name,$chief_surname,$chief_email,$chief_phone,$department_id);
		$db->execute($query, $data);
	}
	
	/**
	*Katedros pašalinimas iš DB.
	*@param String $department_id Katedros identifikacinis numeris
	*@return Integer 1 - katedra sėkmingai pašalintas iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteDepartment($department_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from department where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($department_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* Specialybių duomenų valdymas
*
* Gražinami specialybių duomenų asociatyvieji masyvai, taip pat keičiami duomenų specialybių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class SpecialitiesData extends DepartmentsData
{
	/**
	*Gražinami katedros pavadinimas
	*@param Integer $id katedros identifikacinis numeris
	*@return String katedros pavadinimas
	*/
	public function getDepartmentName($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$id = trim($id);
		$result = $db->query('select name from department where id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta department lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinamas katedrų identifikacinių numerių masyvas
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@param Integer $faculty_id Fakulteto identifikacinis numeris
	*@param Integer $department_id katedros identifikacinis numeris
	*@return Array katedrų identifikacinių numerių masyvas
	*/
	public function getDPID($university_id,$faculty_id,$department_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$departments = array();
		$db = $connect->getConnect();
		
		if (isset($department_id)) {
			$departments[0] = $department_id;
		} elseif (isset($faculty_id)) {
			$result = $db->query('select id from department where faculty_id='.$faculty_id);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta department lentelė');
			}
			while ($result->fetchInto($data)) {
				$departments[] = $data[0];
			}
			$db->disconnect();
		} elseif (isset($university_id)) {
			$result = $db->query('select id from department where faculty_id = any(select id from faculties where university_id='.$university_id.')');
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta department arba faculties lentelė');
			}
			while ($result->fetchInto($data)) {
				$departments[] = $data[0];
			}
			$db->disconnect();
		}

		return $departments;
	}
	
	/**
	*Specialybių kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $ids katedrų identifikacinių numerių masyvas
	*@return Integer Specialybių skaičius sistemoje
	*/
	public function getSpecialitiesCountBySearch($search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " department_id=".$ids[$i]." or ";
			} else {
				$str .= " department_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($ids)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from speciality where name like \'%'.$search.'%\'');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from speciality where description like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from speciality where name like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from speciality where description like \'%'.$search.'%\' and ('.$str.')');
			}		
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Specialybių kiekis sistemoje
	*@param Integer $ids katedrų identifikacinių numerių masyvas
	*@return Integer specialybių skaičius sistemoje
	*/
	public function getSpecialitiesCount($ids)
	{
		//$university_id = trim($university_id);
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " department_id=".$ids[$i]." or ";
			} else {
				$str .= " department_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			$result = $db->query('select count(id) from speciality where '.$str);
		} else {
			$result = $db->query('select count(id) from speciality');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami specialybių duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš speciality lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (specialybės pavadinimas,specialybės aprašymas)
	*@param Integer $ids katedrų identifikacinių numerių masyvas
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getSpecialities($offset,$search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " department_id=".$ids[$i]." or ";
			} else {
				$str .= " department_id=".$ids[$i]." ";
			}
		}
		//$university_id = trim($university_id);
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, description from speciality where ('.$str.') order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, description from speciality where ('.$str.') and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select  id, name, description from speciality where ('.$str.') and description like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, description from speciality order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, description from speciality where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, description from speciality where description like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs specialybės duomenys
	*@param Integer $id specialybės identifikacinis numeris
	*@return Array specialybės duomenys
	*/
	public function getSpeciality($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, description, department_id from speciality where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Specialybės registracijos duomenys įrašomi į db.
	*@param Integer $department_id Katedros identifikacinis numeris
	*@param String $name Specialybės pavadinimas
	*@param String $description Specialybės aprašymas
	*/
	public function insertSpeciality($department_id,$name,$description)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into speciality (name,description,department_id) VALUES (?,?,?)');
		$data = array($name,$description,$department_id);
		$db->execute($query, $data);
	}
	
	/**
	*Redaguojami specialybės duomenys.
	*@param String $speciality_id Specialybės identifikacinis numeris
	*@param String $name Specialybės pavadinimas
	*@param String $description Specialybės aprašymas
	*/
	public function updateSpeciality($speciality_id,$name,$description)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update speciality set name=?,description=? where id=?');
		$data = array($name,$description,$speciality_id);
		$db->execute($query, $data);
	}
	
	/**
	*Specialybės pašalinimas iš DB.
	*@param String $speciality_id Specialybės identifikacinis numeris
	*@return Integer 1 - Specialybė sėkmingai pašalinta iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteSpeciality($speciality_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from speciality where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($speciality_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}

/** 
* Modulių duomenų valdymas
*
* Gražinami modulių duomenų asociatyvieji masyvai, taip pat keičiami duomenų modulių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class ModulesData extends SpecialitiesData
{
	/**
	*Gražinamas specialybės pavadinimas
	*@param Integer $id specialybės identifikacinis numeris
	*@return String Specialybės pavadinimas
	*/
	public function getSpecialityName($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$id = trim($id);
		$result = $db->query('select name from speciality where id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta speciality lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinamas specialybių identifikacinių numerių masyvas
	*@param Integer $university_id Universiteto identifikacinis numeris
	*@param Integer $faculty_id Fakulteto identifikacinis numeris
	*@param Integer $department_id katedros identifikacinis numeris
	*@param Integer $speciality_id specialybės identifikacinis numeris
	*@return Array specialybių identifikacinių numerių masyvas
	*/
	public function getSpecialitiesID($university_id,$faculty_id,$department_id,$speciality_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$specialities = array();
		$db = $connect->getConnect();
		
		if (isset($speciality_id)) {
			$specialities[0] = $speciality_id;
		} elseif (isset($department_id)) {
			$result = $db->query('select id from speciality where department_id='.$department_id);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta speciality lentelė');
			}
			while ($result->fetchInto($data)) {
				$specialities[] = $data[0];
			}
			$db->disconnect();
		} elseif (isset($faculty_id)) {
			$result = $db->query('select id from speciality where department_id = any(select id from department where faculty_id='.$faculty_id.')');
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta speciality arba department lentelė');
			}
			while ($result->fetchInto($data)) {
				$specialities[] = $data[0];
			}
			$db->disconnect();
		} elseif (isset($university_id)) {
			$result = $db->query('select id from speciality where department_id = any(select id from department where faculty_id= any (select id from faculties where university_id='.$university_id.'))');
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta speciality arba department arba faculties lentelė');
			}
			while ($result->fetchInto($data)) {
				$specialities[] = $data[0];
			}
			$db->disconnect();
		}

		return $specialities;
	}
	
	/**
	*Modulių kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $ids specialybių identifikacinių numerių masyvas
	*@return Integer Modulių skaičius sistemoje
	*/
	public function getModulesCountBySearch($search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " speciality_id=".$ids[$i]." or ";
			} else {
				$str .= " speciality_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($ids)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from pratice_modules where name like \'%'.$search.'%\'');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from pratice_modules where code like \'%'.$search.'%\'');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from pratice_modules where study_program like \'%'.$search.'%\'');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from pratice_modules where requirement like \'%'.$search.'%\'');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from pratice_modules where description like \'%'.$search.'%\'');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from pratice_modules where goal like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from pratice_modules where name like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from pratice_modules where code like \'%'.$search.'%\' and ('.$str.')');
			}		
			if ($choise == 3) {
				$result = $db->query('select count(id) from pratice_modules where study_program like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from pratice_modules where requirement like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from pratice_modules where description like \'%'.$search.'%\' and ('.$str.')');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from pratice_modules where goal like \'%'.$search.'%\' and ('.$str.')');
			}
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Modulių kiekis sistemoje
	*@param Integer $ids specialybių identifikacinių numerių masyvas
	*@return Integer modulių skaičius sistemoje
	*/
	public function getModulesCount($ids)
	{
		//$university_id = trim($university_id);
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " speciality_id=".$ids[$i]." or ";
			} else {
				$str .= " speciality_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			$result = $db->query('select count(id) from pratice_modules where '.$str);
		} else {
			$result = $db->query('select count(id) from pratice_modules');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami modulių duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš modulių lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (modulio pavadinimas,modulio kodas, studijų programa, reikalavimai, aprašymas,modulio tikslas)
	*@param Integer $ids specialybių identifikacinių numerių masyvas
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getModules($offset,$search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " speciality_id=".$ids[$i]." or ";
			} else {
				$str .= " speciality_id=".$ids[$i]." ";
			}
		}
		//$university_id = trim($university_id);
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and study_program like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and requirement like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and description like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where ('.$str.') and goal like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, code from pratice_modules order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where study_program like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where requirement like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where description like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, code from pratice_modules where goal like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs modulio duomenys
	*@param Integer $id modulio identifikacinis numeris
	*@return Array modulio duomenys
	*/
	public function getModule($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, code, study_program, requirement, description, goal, speciality_id from pratice_modules where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta pratice_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Modulio registracijos duomenys įrašomi į db.
	*@param Integer $speciality_id Specialybės identifikacinis numeris
	*@param String $name Modulio pavadinimas
	*@param String $code Modulio kodas
	*@param String $study_program Studijų programos pavadinimas
	*@param String $requirement Modulio reikalavimai
	*@param String $description Modulio aprašymas
	*@param String $goal Modulio tikslas
	*/
	public function insertModule($speciality_id,$name,$code,$study_program,$requirement,$description,$goal)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into pratice_modules (name,code,study_program,requirement,description,goal,speciality_id) VALUES (?,?,?,?,?,?,?)');
		$data = array($name,$code,$study_program,$requirement,$description,$goal,$speciality_id);
		$db->execute($query, $data);
	}
	
	/**
	*Redaguojami modulio duomenys.
	*@param String $module_id Modulio identifikacinis numeris
	*@param String $name Modulio pavadinimas
	*@param String $code Modulio kodas
	*@param String $study_program Studijų programos pavadinimas
	*@param String $requirement Modulio reikalavimai
	*@param String $description Modulio aprašymas
	*@param String $goal Modulio tikslas
	*/
	public function updateModule($module_id,$name,$code,$study_program,$requirement,$description,$goal)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update pratice_modules set name=?,code=?,study_program=?,requirement=?,description=?,goal=? where id=?');
		$data = array($name,$code,$study_program,$requirement,$description,$goal,$module_id);
		$db->execute($query, $data);
	}
	
	/**
	*Modulio pašalinimas iš DB.
	*@param String $module_id Modulio identifikacinis numeris
	*@return Integer 1 - Modulis sėkmingai pašalintas iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteModule($module_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from pratice_modules where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($module_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
}
/** 
* Įmonių duomenų valdymas
*
* Gražinami įmonių duomenų asociatyvieji masyvai, taip pat keičiami duomenų įmonių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class CompaniesData extends CompanyRegisterSQL 
{
	/**
	*Gražinamas kategorijos pavadinimas
	*@param Integer $categoryID Kategorijos identifikacinis numeris
	*@return String Kategorijos pavadinimas
	*/
	public function getCategory($categoryID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$categoryID = trim($categoryID);
		$result = $db->query('select name from categories where id='.$categoryID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami subkategorijų identifikacinių numerių masyvas
	*@param Integer $category_id Kategorijos identifikacinis numeris
	*@param Integer $subcategory_id Subkategorijos identifikacinis numeris
	*@return Array subkategorijų identifikacinių numerių masyvas
	*/
	public function getSubcategoriesID($category_id,$subcategory_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$subcategories = array();
		$db = $connect->getConnect();
		if (isset($subcategory_id)) {
			$subcategories[0] = $subcategory_id;
			return $subcategories;
			
		} elseif (isset($category_id)) {
			$result = $db->query('select id from subcategories where category_id='.$category_id);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Sugadinta subcategories lentelė');
			}
			while ($result->fetchInto($data)) {
				$subcategories[] = $data[0];
			}
			$db->disconnect();
		}
		return $subcategories;
	}
	
	/**
	*Įmonių kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $ids subkategorijų identifikacinių numerių masyvas
	*@return Integer įmonių skaičius sistemoje
	*/
	public function getCompaniesCountBySearch($search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " subcategory_id=".$ids[$i]." or ";
			} else {
				$str .= " subcategory_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($ids)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from companies where name like \'%'.$search.'%\'');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from companies where contact_person_name like \'%'.$search.'%\'');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from companies where contact_person_surname like \'%'.$search.'%\'');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from companies where activity_desc like \'%'.$search.'%\'');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from companies where email like \'%'.$search.'%\'');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from companies where phone like \'%'.$search.'%\'');
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from companies where fax like \'%'.$search.'%\'');
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from companies where code like \'%'.$search.'%\'');
			}
			if ($choise == 9) {
				$result = $db->query('select count(id) from companies where contact_person_phone like \'%'.$search.'%\'');
			}
			if ($choise == 10) {
				$result = $db->query('select count(id) from companies where contact_person_email like \'%'.$search.'%\'');
			}
			if ($choise == 11) {
				$result = $db->query('select count(id) from companies where chief_role like \'%'.$search.'%\'');
			}
			if ($choise == 12) {
				$result = $db->query('select count(id) from companies where chief_name like \'%'.$search.'%\'');
			}
			if ($choise == 13) {
				$result = $db->query('select count(id) from companies where chief_surname like \'%'.$search.'%\'');
			}
			if ($choise == 14) {
				$result = $db->query('select count(id) from companies where address like \'%'.$search.'%\'');
			}
			if ($choise == 15) {
				$result = $db->query('select count(id) from companies where register_date like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from companies where name like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 2) {
				$result = $db->query('select count(id) from companies where contact_person_name like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 3) {
				$result = $db->query('select count(id) from companies where contact_person_surname like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 4) {
				$result = $db->query('select count(id) from companies where activity_desc like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 5) {
				$result = $db->query('select count(id) from companies where email like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 6) {
				$result = $db->query('select count(id) from companies where phone like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 7) {
				$result = $db->query('select count(id) from companies where fax like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 8) {
				$result = $db->query('select count(id) from companies where code like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 9) {
				$result = $db->query('select count(id) from companies where contact_person_phone like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 10) {
				$result = $db->query('select count(id) from companies where contact_person_email like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 11) {
				$result = $db->query('select count(id) from companies where chief_role like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 12) {
				$result = $db->query('select count(id) from companies where chief_name like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}	
			if ($choise == 13) {
				$result = $db->query('select count(id) from companies where chief_surname like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}
			if ($choise == 14) {
				$result = $db->query('select count(id) from companies where address like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}	
			if ($choise == 15) {
				$result = $db->query('select count(id) from companies where register_date like \'%'.$search.'%\' and id = any (select company_id from company_subcategories where ('.$str.'))');
			}	
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Įmonių kiekis sistemoje
	*@param Integer $ids subkategorijų identifikacinių numerių masyvas
	*@return Integer Įmonių skaičius sistemoje
	*/
	public function getComapaniesCount($ids)
	{
		//$university_id = trim($university_id);
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " subcategory_id=".$ids[$i]." or ";
			} else {
				$str .= " subcategory_id=".$ids[$i]." ";
			}
		}
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			$result = $db->query('select count(id) from companies where id = any (select company_id from company_subcategories where ('.$str.'))');
		} else {
			$result = $db->query('select count(id) from companies');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami įmonių duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš įmonių lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma
	*@param Integer $ids subkategorijų identifikacinių numerių masyvas
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getCompanies($offset,$search,$choise,$ids)
	{
		$str = "";
		for ($i = 0; $i < count($ids); $i++){
			if ($i != count($ids) - 1) {
				$str .= " subcategory_id=".$ids[$i]." or ";
			} else {
				$str .= " subcategory_id=".$ids[$i]." ";
			}
		}
		
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($ids)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and contact_person_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and contact_person_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and activity_desc like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 9) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and contact_person_phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 10) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and contact_person_email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 11) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and chief_role like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 12) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and chief_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 13) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and chief_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 14) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and address like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 15) {
				$data = $db->getAssoc('select id, name, code from companies where id = any (select company_id from company_subcategories where ('.$str.')) and register_date like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name, code from companies order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name, code from companies where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 2) {
				$data = $db->getAssoc('select id, name, code from companies where contact_person_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 3) {
				$data = $db->getAssoc('select id, name, code from companies where contact_person_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 4) {
				$data = $db->getAssoc('select id, name, code from companies where activity_desc like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 5) {
				$data = $db->getAssoc('select id, name, code from companies where email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 6) {
				$data = $db->getAssoc('select id, name, code from companies where phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 7) {
				$data = $db->getAssoc('select id, name, code from companies where fax like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 8) {
				$data = $db->getAssoc('select id, name, code from companies where code like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 9) {
				$data = $db->getAssoc('select id, name, code from companies where contact_person_phone like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 10) {
				$data = $db->getAssoc('select id, name, code from companies where contact_person_email like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 11) {
				$data = $db->getAssoc('select id, name, code from companies where chief_role like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 12) {
				$data = $db->getAssoc('select id, name, code from companies where chief_name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 13) {
				$data = $db->getAssoc('select id, name, code from companies where chief_surname like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 14) {
				$data = $db->getAssoc('select id, name, code from companies where address like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
			if ($choise == 15) {
				$data = $db->getAssoc('select id, name, code from companies where register_date like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinami detalūs įmonės duomenys
	*@param Integer $id įmonės identifikacinis numeris
	*@return Array Įmonės duomenys
	*/
	public function getCompany($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name,contact_person_name,contact_person_surname,activity_desc,username,password,email,phone,fax,code,contact_person_phone,contact_person_email,chief_role,chief_name,chief_surname,address,register_date,block from companies where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami subkategorijų pavadinimai priklausantys įmonei
	*@param Integer $id įmonės identifikacinis numeris
	*@return Array subkategorijų pavadinimai priklausantys įmonei
	*/
	public function getSubcategoriesNames($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select subcategory_id from company_subcategories where company_id='.$id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta company_subcategories lentelė');
		}
		$names = array();
		while ($result->fetchInto($data)) {
			$result_names = $db->query('select name from subcategories where id='.$data[0]);
			$result_names->fetchInto($name);
			$names[] = $name[0];
		}
		return $names;
	}
	
	/**
	*Įmonės pašalinimas iš DB.
	*@param String $company_id Įmonės identifikacinis numeris
	*@return Integer 1 - Įmonė sėkmingai pašalinta iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteCompany($company_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from companies where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($company_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
	
	/**
	*Įmonės slaptažodžio keitimas.
	*@param Integer $id Įmonės registracijos identifikacinis numeris
	*@param String $password Naujas įmonės slaptažodis
	*/
	public function updateComapnyPassword($id, $password)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies set password=? where id=?');
		$db->execute($query, array($password,$id));
	}
	
	/**
	*Įmonės duomenų keitimas.
	*@param Integer $id Įmonės registracijos identifikacinis numeris
	*@param String $address Įmonės adresas
	*@param String $phone Įmonės telefonas
	*@param String $fax Įmonės faksas
	*@param String $email Įmonės elektroninio pašto adresas
	*@param String $activity_desc Įmonės veiklos aprašymas
	*@param String $chief_name Įmonės vadovo vardas
	*@param String $chief_surname Įmonės vadovo pavardė
	*@param String $chief_role Įmonės vadovo pareigos
	*@param String $contact_person_name Įmonės vadovo vardas
	*@param String $contact_person_surname Įmonės vadovo pavardė
	*@param String $contact_person_phone Įmonės kontaktinio asmens telefonas
	*@param String $contact_person_email Įmonės kontaktinio asmens elektroninio pašto adresas
	*/
	public function updateComapnyInfo($id, $address, $phone, $fax, $email, $activity_desc, $chief_name, $chief_surname, $chief_role, $contact_person_name, $contact_person_surname, $contact_person_phone, $contact_person_email)
	{
		//echo "$id, $address, $phone, $fax, $email, $activity_desc, $chief_name, $chief_surname, $chief_role, $contact_person_name, $contact_person_surname, $contact_person_phone, $contact_person_email";
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies set address=?, phone=?,fax=?,email=?,activity_desc=?,chief_name=?,chief_surname=?,chief_role=?,contact_person_name=?,contact_person_surname=?,contact_person_phone=?,contact_person_email=? where id=?');
		$db->execute($query, array($address, $phone, $fax, $email, $activity_desc, $chief_name, $chief_surname, $chief_role, $contact_person_name, $contact_person_surname, $contact_person_phone, $contact_person_email,$id));
	}
	
	/**
	*Įmonės blokavimo statuso keitimas
	*@param Integer $id Įmonės registracijos identifikacinis numeris
	*@param Boolean $blockstatus Blokavimo statusas
	*/
	public function updateCompanyBlock($id, $blockstatus)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies set block=? where id=?');
		$db->execute($query, array($blockstatus,$id));
	}
	
}

/** 
* Kategorijų duomenų valdymas
*
* Gražinami kategorijų duomenų asociatyvieji masyvai, taip pat keičiami duomenų įmonių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class CategoriesData extends CompaniesData 
{
	/**
	*Kategorijų kiekis sistemoje, pagal paieškos sąlygą
	*@return Integer Kategorijų skaičius sistemoje
	*/
	public function getCategoriesCountBySearch($search,$choise)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$search = trim($search);
		if ($choise == 1) {
			$result = $db->query('select count(id) from categories where name like \'%'.$search.'%\'');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Kategorijų kiekis sistemoje
	*@return Integer Kategorijų skaičius sistemoje
	*/
	public function getCategoriesCount()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from categories');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami kategorijų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš categories lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (kategorijos pavadinimas)
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getCategories($offset,$search,$choise)
	{
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (!$search && !$choise) {
			$data = $db->getAssoc('select id, name from categories order by id limit 10 offset '.$offset);
		}
		if ($choise == 1) {
			$data = $db->getAssoc('select id, name from categories where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Kategorijos registracijos duomenys įrašomi į db.
	*@param String $name Kategorijos pavadinimas
	*/
	public function insertCategory($name)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into categories (name) VALUES (?)');
		$data = array($name);
		$db->execute($query, $data);
	}
	
	/**
	*Gražinami detalūs kategorijos duomenys
	*@param Integer $id kategorijos identifikacinis numeris
	*@return Array Kategorijos
	*/
	public function getCategory($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name from categories where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Keičiamas kategorijos pavadinimas
	*@param Integer $id Kategorijos registracijos identifikacinis numeris
	*@param String $name naujas kategorijos pavadinimas
	*/
	public function modifyCategory($id, $name)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update categories set name=? where id=?');
		$db->execute($query, array($name,$id));
	}
	
	/**
	*Kategorijos pašalinimas iš DB.
	*@param String $category_id Kategorijos identifikacinis numeris
	*@return Integer 1 - Kategorija sėkmingai pašalinta iš sistemos, 0 - pašalinimo klaida
	*/
	public function deleteCategory($category_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from categories where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$data = array($category_id);
		$res = $db->execute($query, $data);
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
	
}

/** 
* Sub-kategorijų duomenų valdymas
*
* Gražinami sub-kategorijų duomenų asociatyvieji masyvai, taip pat keičiami duomenų įmonių įrašai, registracija
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class SubcategoriesData extends CompaniesData 
{
	/**
	*Gražinamos visų kategorijų vardų asociatyvus masyvas
	*@return Array Visos veiklų kategorijos
	*/
	public function getAllCategoriesAssoc()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name from categories order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta categories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Sub-kategorijų kiekis sistemoje, pagal paieškos sąlygą
	*@param Integer $search Paieškos sąlyga
	*@param Integer $choise Paieškos laukas
	*@param Integer $category_id Kategorijos identifikacinis numeris
	*@return Integer Sub-kategorijų skaičius sistemoje
	*/
	public function getSubcategoriesCountBySearch($search,$choise,$category_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		//$university_id = trim($university_id);
		$search = trim($search);
		if (!isset($category_id)) {
			if ($choise == 1) {
				$result = $db->query('select count(id) from subcategories where name like \'%'.$search.'%\'');
			}
		} else {
			if ($choise == 1) {
				$result = $db->query('select count(id) from subcategories where name like \'%'.$search.'%\' and category_id='.$category_id);
			}			
		}

		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Sub-kategorijų kiekis sistemoje
	*@param Integer $category_id kategorijos identifikacinis numeris
	*@return Integer sub-kategorijų skaičius sistemoje
	*/
	public function getSubcategoriesCount($category_id)
	{
		//$university_id = trim($university_id);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($category_id)) {
			$result = $db->query('select count(id) from subcategories where category_id='.$category_id);
		} else {
			$result = $db->query('select count(id) from subcategories');
		}
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami sub-kategorijų duomenys
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš subcategories lentelės
	*@param String $search paieškos tekstas
	*@param Integer $choise Laukas pagal kurį bus ieškoma (sub-kategorijos pavadinimas)
	*@param Integer $category_id Kategorijos identifikacinis numeris
	*@return Array Praleidžiamas $offset pradinis atrinktas įrašų skaičius, po to gražinami 10 tolesnių įrašų
	*/
	public function getSubcategory($offset,$search,$choise,$category_id)
	{
		//$university_id = trim($university_id);
		$search = trim($search);
		$connect = new Connect();
		$db = $connect->getConnect();
		if (isset($category_id)) {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name from subcategories where category_id='.$category_id.' order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name from subcategories where category_id='.$category_id.' and name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}

		} else {
			if (!$search && !$choise) {
				$data = $db->getAssoc('select id, name from subcategories order by id limit 10 offset '.$offset);
			}
			if ($choise == 1) {
				$data = $db->getAssoc('select id, name from subcategories where name like \'%'.$search.'%\' order by id limit 10 offset '.$offset);
			}
		}
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Sub - kategorijos registracijos duomenys įrašomi į db.
	*@param String $name Sub-kategorijos pavadinimas
	*@param Integer $category_id Kategorijos identifikacinis numeris
	*/
	public function insertSubcategory($name,$category_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into subcategories (name,category_id) VALUES (?,?)');
		$data = array($name,$category_id);
		$db->execute($query, $data);
	}
	
	/**
	*Keičiamas sub-kategorijos pavadinimas
	*@param Integer $id Sub-kategorijos registracijos identifikacinis numeris
	*@param String $name naujas sub-kategorijos pavadinimas
	*/
	public function modifySubcategory($id, $name)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update subcategories set name=? where id=?');
		$db->execute($query, array($name,$id));
	}
	
	/**
	*Sub-kategorijos pašalinimas
	*@param Integer $id Sub-kategorijos registracijos identifikacinis numeris
	*@return 1 - sėkmingai pašalinta, 0 - pašalinimo klaida
	*/
	public function deleteSubcategory($id)
	{
		echo $id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from subcategories where id=?');
		if (PEAR::isError($query)) {
			$db->disconnect();
			return 0;
		}
		$result = $db->execute($query, array($id));
		if (PEAR::isError($result)) {
			$db->disconnect();
			return 0;
		}
		echo "galas";
		return 1;
	}
	
	/**
	*Gražinami detalūs sub-kategorijos duomenys
	*@param Integer $id sub-kategorijos identifikacinis numeris
	*@return Array Sub-kategorijos
	*/
	public function getSubcategoryDetail($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name,category_id from subcategories where id='.$id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Sugadinta subcategories lentelė');
		}
		$db->disconnect();
		return $data;
	}
}

/** 
* Įmonių sąsajos duomenų valdymas
*
* Gražinami įmonių duomenų asociatyvieji masyvai, taip pat keičiami duomenų įmonių įrašai, manipuliuojama su praktikos darbais
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class CompaniesInterface extends CompaniesData 
{
	/**
	*Gražinami detalūs sub-kategorijos duomenys
	*@param Integer $username Įmonės prisijungimo vardas
	*@return Integer Įmonės prisijungimo identifikacinis numeris
	*/
	public function getCompanyID($username)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id from companies where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getCompanyID() Sugadinta companies lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}

	/**
	*Gražinamos kategorijos priklausančios įmonei
	*@param Integer $companyID įmonės identifikacinis numeris
	*@return Array Kategorijų identifikacininių numerių masyvas
	*/
	public function getCompaniesCategoriesIDS($companyID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$categoriesIDS = array();
		$result = $db->query('select category_id from subcategories where id = any (select subcategory_id from company_subcategories where company_id='.$companyID.') group by category_id');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getCompaniesCategoriesIDS() Sugadinta subcategories arba company_subcategories lentelė');
		}
		while ($row = $result->fetchRow()) {
			 $categoriesIDS[] = $row[0];
		}
		$db->disconnect();
		return $categoriesIDS;
	}	
	
	/**
	*Gražinamos asociatyvus subkategorijų masyvas
	*@param Integer $companyID įmonės identifikacinis numeris
	*@param Array $catIDS Įmonės registruotų kategorijų identifikacininių numerių masyvas
	*@return Array asociatyvus kategorijų ir subkategorijų masyvas
	*/
	public function getCompaniesCatSubcatIDS($companyID,$catIDS)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$resultAsoc = array();
		for ($i = 0; $i < count($catIDS); $i++) {
			$result = $db->query('select id from subcategories where category_id='.$catIDS[$i].' and id=any(select subcategory_id from company_subcategories where company_id='.$companyID.');');
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('CompaniesInterface->getCompaniesCatSubcatIDS() Sugadinta subcategories arba company_subcategories lentelė');
			}
			while ($row = $result->fetchRow()) {
				$resultAsoc[$i][] = $row[0];
			}
		}
		$db->disconnect();
		return $resultAsoc;
	}

	/**
	*Gražinamas kategorijų pavadinimų masyvas
	*@param Array Kategorijų identifikacininių numerių masyvas
	*@return Array Kategorijų vardų masyvas
	*/
	public function getCompaniesCategoriesNames($catIDS)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$categoriesNames = array();
		for ($i = 0; $i < count($catIDS); $i++) {
			$result = $db->query('select name from categories where id='.$catIDS[$i]);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('CompaniesInterface->getCompaniesCategoriesNames() Sugadinta categories lentelė');
			}
			$row = $result->fetchRow();
			$categoriesNames[] = $row[0];
		}
		$db->disconnect();
		return $categoriesNames;
	}	
	
	/**
	*Gražinamos asociatyvus subkategorijų vardų masyvas
	*@param Array $SubcatIDS asociatyvus subkategorijų identifikacinių numerių masyvas
	*@return Array asociatyvus subkategorijų vardų masyvas
	*/
	public function getCompaniesCatSubcatNames($SubcatIDS)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$resultAsoc = array();
		for ($i = 0; $i < count($SubcatIDS); $i++) {
			for ($j = 0; $j < count($SubcatIDS[$i]); $j++)
			{
				$result = $db->query('select name from subcategories where id='.$SubcatIDS[$i][$j]);
				if (PEAR::isError($result)) {
					$db->disconnect();
					die('CompaniesInterface->getCompaniesCatSubcatNames() Sugadinta subcategories lentelė');
				}
				$row = $result->fetchRow();
				$resultAsoc[$i][] = $row[0];
			}
		}
		$db->disconnect();
		return $resultAsoc;
	}

	/**
	*Gražinamas sub-kategorijos pavadinimas
	*@param Integer $subcategory_id Sub-kategorijos identifikacinis numeris
	*@return String sub-kategorijos pavadinimas
	*/
	public function getSubcategoryName($subcategory_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name from subcategories where id='.$subcategory_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getSubcategoryName() Sugadinta subcategories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	
	/**
	*Gražinamas kategorijos pavadinimas
	*@param Integer $subcategory_id Sub-kategorijos identifikacinis numeris
	*@return String kategorijos pavadinimas
	*/
	public function getCategoryNameBySubcategory($subcategory_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name from categories where id=(select category_id from subcategories where id='.$subcategory_id.')');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getSubcategoryName() Sugadinta categories arba subcategories lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Įmonės pasiūlytas praktikos darbas įrašomas į DB.
	*@param String $job_title
	*@param String $job_description
	*@param Integer $company_id
	*@param Integer $subcategory_id
	*/
	public function insertPracticeJob($job_title,$job_description,$company_id,$subcategory_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into practice_jobs (title,description,company_id,subcategory_id) VALUES (?,?,?,?)');
		$data = array($job_title,$job_description,$company_id,$subcategory_id);
		$db->execute($query, $data);
	}
	
	/**
	*Gražinamos asociatyvus praktikos darbų kiekių tam tikroje sub-kategorijoje masyvas
	*@param Array $SubcatIDS asociatyvus subkategorijų identifikacinių numerių masyvas
	*@param Integer $companyID Įmonės identifikacinis numeris
	*@return Array asociatyvus praktikos darbų kiekių tam tikroje sub-kategorijoje masyvas
	*/
	public function getCompaniesCatSubcatPracticeJobCount($SubcatIDS,$companyID)
	{
		//print_r($SubcatIDS);
		$connect = new Connect();
		$db = $connect->getConnect();
		$resultAsoc = array();
		for ($i = 0; $i < count($SubcatIDS); $i++) {
			for ($j = 0; $j < count($SubcatIDS[$i]); $j++)
			{
				//echo $SubcatIDS[$i][$j]."<br/>";
				$result = $db->query('select count(id) from practice_jobs where company_id='.$companyID.' and subcategory_id='.$SubcatIDS[$i][$j]);
				if (PEAR::isError($result)) {
					$db->disconnect();
					die('CompaniesInterface->getCompaniesCatSubcatPracticeJobCount() Sugadinta practice_jobs lentelė');
				}
				$row = $result->fetchRow();
				$resultAsoc[$i][] = $row[0];
			}
		}
		$db->disconnect();
		return $resultAsoc;
	}
	
	/**
	*Gražinami sub-kategorijoje esantys įmonės pasiūlyti praktikos darbai
	*@param Integer $subcategory_id Sub-kategorijos identifikacinis numeris
	*@param Integer $company_id įmonės identifikacinis numeris
	*@return Array Sub-categories praktikos darbai
	*/
	public function getSubcategoriesPracticeJobs($subcategory_id,$company_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,title,description,company_id,subcategory_id from practice_jobs where company_id='.$company_id.' and subcategory_id='.$subcategory_id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('CompaniesInterface->getSubcategoriesPracticeJobs() Sugadinta practice_jobs lentelė');
		}
		$db->disconnect();
		return $data;
		
	}

	/**
	*Gražinami praktikos darbo komentarai
	*@param Integer $practice_job_id Praktikos darbo identifikacinis numeris
	*@return String Praktikos darbo komentarai
	*/
	public function getPracticeJobComments($practice_job_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$comments = array();
		$result = $db->query('select id,commenter_id,commenter_table_id,comment,time from practice_jobs_comments where practice_job_id='.$practice_job_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getPracticeJobComments() Sugadinta practice_jobs_comments lentelė');
		}
		while ($result->fetchInto($data)) {
			if ($data[2] == 1) {
				$res = $db->query('select name,surname from students where id='.$data[1]);
			}
			if ($data[2] == 2) {
				$res = $db->query('select name from companies where id='.$data[1]);
			}
			if ($data[2] == 3) {
				$res = $db->query('select name,surname from teachers where id='.$data[1]);
			}
			if (PEAR::isError($res)) {
				$db->disconnect();
				die('CompaniesInterface->getPracticeJobComments() Sugadinta students,companies,teachers lentelė');
			}
			$res->fetchInto($comment);
			if ($data[2] == 1 || $data[2] == 3) {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0],$comment[1]);
			} else {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0]);
			}
		}
		$db->disconnect();
		//print_r($comments);
		return $comments;
	}
	
	/**
	*Praktikos darbo komentaras įrašomas į DB.
	*@param Integer $commenter_id Komentuotojo identifikacinis numeris
	*@param Integer $commenter_table_id Kas yra komentuotojas (1 - studentas, 2 - įmonė, 3 - dėstytojas);
	*@param String $comment Komentaras
	*@param Integer $practice_job_id Praktikos darbas kuriam bus priskirtas komentaras
	*/
	public function insertPracticeJobComment($commenter_id,$commenter_table_id,$comment,$practice_job_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into practice_jobs_comments (commenter_id,commenter_table_id,comment,practice_job_id) VALUES (?,?,?,?)');
		$data = array($commenter_id,$commenter_table_id,$comment,$practice_job_id);
		$db->execute($query, $data);
	}
	
	/**
	*Gražinami studento duomenys kuries yra pasirinkęs praktikos darbą
	*@param Integer $practice_job_id Praktikos darbo identifikacinis numeris
	*@return Array Studento duomeny masyvas
	*/
	public function getPracticeJobStudent($practice_job_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$comments = array();
		$result = $db->query('select id,student_no,name,surname,email,phone,speciality_id from students where id=(select student_id from choised_jobs where practice_job_id='.$practice_job_id.')');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('CompaniesInterface->getPracticeJobStudent() Sugadinta students,choised_jobs lentelė');
		}
		//echo "ok";
		$result->fetchInto($student);
		if (!isset($student)) {
			$db->disconnect();
			return;
		}
		//print_r($student);
		$result_department = $db->query('select name from department where id=(select department_id from speciality where id='.$student[6].')');
		$result_department->fetchInto($department);
		
		$result_faculty = $db->query('select name from faculties where id=(select faculty_id from department where id=(select department_id from speciality where id='.$student[6].'))');
		$result_faculty->fetchInto($faculty);
		
		$result_university = $db->query('select name from universities where id=(select university_id from faculties where id=(select faculty_id from department where id=(select department_id from speciality where id='.$student[6].')))');
		$result_university->fetchInto($university);
		
		$db->disconnect();
		
		$data = new TeachersData();
		$speciality_id = $student[6];
		$speciality_name = $data->getSpeciality($speciality_id);
		
		$department_name = $department[0];
		$faculty_name = $faculty[0];
		$university_name = $university[0];

		
		$student[6] = array($speciality_name,$department_name,$faculty_name,$university_name);
		return $student;
	}
	
	/**
	*Gražinami pasirinkto praktikos darbo komentarai
	*@param Integer $practice_job_id Praktikos darbo identifikacinis numeris
	*@return String Praktikos darbo komentarai
	*/
	public function getPracticeJobChoisedComments($practice_job_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$comments = array();
		$result = $db->query('select id,commenter_id,commenter_table_id,comment,time from choised_job_comments where choised_job_id=(select id from choised_jobs where practice_job_id='.$practice_job_id.')');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('CompaniesInterface->getPracticeJobComments() Sugadinta practice_jobs_comments lentelė');
		}
		while ($result->fetchInto($data)) {
			if ($data[2] == 1) {
				$res = $db->query('select name,surname from students where id='.$data[1]);
			}
			if ($data[2] == 2) {
				$res = $db->query('select name from companies where id='.$data[1]);
			}
			if ($data[2] == 3) {
				$res = $db->query('select name,surname from teachers where id='.$data[1]);
			}
			if (PEAR::isError($res)) {
				$db->disconnect();
				die('CompaniesInterface->getPracticeJobComments() Sugadinta students,companies,teachers lentelė');
			}
			$res->fetchInto($comment);
			if ($data[2] == 1 || $data[2] == 3) {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0],$comment[1]);
			} else {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0]);
			}
		}
		$db->disconnect();
		//print_r($comments);
		return $comments;
	}
	
	/**
	*Pasirinkto praktikos darbo komentaras įrašomas į DB.
	*@param Integer $commenter_id Komentuotojo identifikacinis numeris
	*@param Integer $commenter_table_id Kas yra komentuotojas (1 - studentas, 2 - įmonė, 3 - dėstytojas);
	*@param String $comment Komentaras
	*@param Integer $practice_job_id Praktikos darbas kuriam bus priskirtas komentaras
	*/
	public function insertPracticeJobChoisedComment($commenter_id,$commenter_table_id,$comment,$practice_job_id)
	{
		//echo $practice_job_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		//echo $practice_job_id;
		//echo "$commenter_id,$commenter_table_id,$comment,$practice_job_id";
		$result = $db->query('select id from choised_jobs where practice_job_id='.$practice_job_id);
		//echo $result->getMessage();
		$result->fetchInto($choised_job);
		$choised_job_id = $choised_job[0];
		$query = $db->prepare('insert into choised_job_comments (commenter_id,commenter_table_id,comment,choised_job_id) VALUES (?,?,?,?)');
		$data = array($commenter_id,$commenter_table_id,$comment,$choised_job_id);
		$db->execute($query, $data);
	}

}

/** 
* Studentų sąsajos duomenų valdymas
*
* Gražinami studentų duomenų asociatyvieji masyvai, taip pat keičiami duomenų įmonių įrašai, manipuliuojama su praktikos darbais
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class StudentsInterface extends StudentsData 
{
	/**
	*Gražinamas studento identifikacinis numeris
	*@param Integer $username Studento prisijungimo vardas
	*@return Integer Studento prisijungimo identifikacinis numeris
	*/
	public function getStudentID($username)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id from students where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('StudentsInterface->getStudentID() Sugadinta students lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinamos visos veiklos kategorijos
	*@return Array Kategorijų asociatyvus masyvas
	*/
	public function getCategories()
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,name from categories order by lower(name) asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('StudentsInterface->getCategories() Sugadinta categories lentelė');
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamos visos veiklos sub-kategorijos
	*@param $category_id Integer Veiklos kategorijos identifikacinis numeris
	*@return Array sub-kategorijų asociatyvus masyvas
	*/
	public function getSubcategories($category_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,name from subcategories where category_id='.$category_id.' order by lower(name) asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('StudentsInterface->getSubcategories() Sugadinta subcategories lentelė');
		}
		$db->disconnect();
		return $data;
		
	}

	/**
	*Gražinamos visos įmonės vykdančios veiklas tam tikroje sub-kategorije
	*@param $subcategory_id Integer Veiklos sub-kategorijos identifikacinis numeris
	*@return Array įmonių asociatyvus masyvas
	*/
	public function getCompaniesInSubcategory($subcategory_id)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,name,code from companies where id=any(select company_id from company_subcategories where subcategory_id='.$subcategory_id.') order by lower(name) asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('StudentsInterface->getCompaniesInSubcategory() Sugadinta comapnies,company_subcategories lentelė');
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamos visos įmonės pasiūlyti darbai tam tikroje sub-kategorijoje
	*@param $subcategory_id Integer Veiklos sub-kategorijos identifikacinis numeris
	*@param $company_id Integer Įmonės identifikacinis numeris
	*@return Array įmonių pasiūlyti darbai tam tikroje subcategorijoje
	*/
	public function getCompaniesSubcategoryPracticeJobs($company_id,$subcategory_id)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,title from practice_jobs where company_id='.$company_id.' and subcategory_id='.$subcategory_id.' order by lower(title) asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			echo $data->getMessage();
			die('StudentsInterface->getCompaniesSubcategoryPracticeJobs() Sugadinta practice_jobs lentelė');
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinami praktikos darbo duomenys
	*@param Integer $practice_job_id Praktikos darbo identifikacinis numeris
	*@return Array Gražinamas praktikos darbo duomenų asociatyvus masyvas 
	*/
	public function getPracticeJob($practice_job_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id,title,description from practice_jobs where id='.$practice_job_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('StudentsInterface->getPracticeJob() Sugadinta practice_jobs lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami visų aktyvių praktikos darbų modulių asociatyvus masyvas
	*@return Array įmonių pasiūlyti darbai tam tikroje subcategorijoje
	*/
	public function getActivePracticeModules()
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select teachers_modules.id,pratice_modules.id,pratice_modules.code,pratice_modules.study_program,pratice_modules.name from teachers_modules,pratice_modules where teachers_modules.practice_module_id=pratice_modules.id and teachers_modules.closed=false');
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('StudentsInterface->getActivePracticeModules() Sugadinta teachers_modules,pratice_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami detalūs praktikos modulio duomenys
	*@param Integer $practice_module_id Praktikos modulio identifikacinis numeris
	*@return Array detalūs praktikos modulio duomenys asociatyviajame masyve
	*/
	public function getDetailPracticeModule($practice_module_id)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,code,study_program,name,requirement,description,goal from pratice_modules where id='.$practice_module_id);
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('StudentsInterface->getDetailPracticeModule() Sugadinta pratice_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinas praktikos darbo dėstytojo vardas ir pavardė
	*@param Integer $teachers_modules_id Dėstytojo dėstomo modulio identifikacinis numeris
	*@return Array Masyvas (vardas,pavardė)
	*/
	public function getTeacher($teachers_modules_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name,surname from teachers where id=(select teacher_id from teachers_modules where id='.$teachers_modules_id.')');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getTeacher() Sugadinta teachers,teachers_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Praktikos darbo pasirinkimas įrašomas į DB
	*@param Integer $student_id Studento identifikacinis numeris
	*@param Integer $practice_job_id Praktikos darbo identifikacinis numeris
	*@param String $teacher_module_id Atliekamo praktikos darbo modulio identifikacinis numeris
	*@return Integer 1 - Klaida, jei praktikos darbas jau turi studentą, 2 - Jei studentas bando du kartus pasirinkti praktikos darbą
	*/
	public function insertChoisePracticeJob($student_id,$practice_job_id,$teacher_module_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		//echo $practice_job_id;
		$result = $db->query('select id from choised_jobs where practice_job_id='.$practice_job_id);
		//echo $result->getMessage();
		$result->fetchInto($error);
		if (isset($error)) {
			//print_r($error);
			return 1;
		}
		$result = $db->query('select id from choised_jobs where student_id='.$student_id);
		//echo $result->getMessage();
		$result->fetchInto($error);
		if (isset($error)) {
			//print_r($error);
			return 2;
		}
		$query = $db->prepare('insert into choised_jobs (student_id,practice_job_id,teacher_module_id) VALUES (?,?,?)');
		$data = array($student_id,$practice_job_id,$teacher_module_id);
		$db->execute($query, $data);
	}
	
	/**
	*Gražinas studento atliekamas praktikos darbo pavadinimas, aprašymas ir pasirinkimo identifikacinis numeris
	*@param Integer $student_id studento identifikacinis numeris
	*@return Array Masyvas (id, title)
	*/
	public function getStudentChoisedJob($student_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select choised_jobs.id, practice_jobs.title,practice_jobs.id, practice_jobs.company_id,practice_jobs.description from choised_jobs,practice_jobs where choised_jobs.practice_job_id=practice_jobs.id and choised_jobs.student_id='.$student_id);
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getStudentChoisedJob() Sugadinta choised_jobs,practice_jobs lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinas praktikos darbo dėstytojo vardas, pavardė, email, telefonas
	*@param Integer Studento identifikacinis numeris
	*@return Array Masyvas (praktikos darbo dėstytojo vardas, pavardė, email, telefonas)
	*/
	public function getTeacherByChoisedJobStudent($student_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select name,surname,email,phone from teachers where id=(select teacher_id from teachers_modules where id=(select teacher_module_id from choised_jobs where student_id='.$student_id.'))');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getTeacherByChoisedJobStudent() Sugadinta teachers,teachers_modules,choised_jobs lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami praktikos darbų užduočių pavadinimai tam tikrame dėstytojo modulyje
	*@param Integer $teacher_module Dėstytojo praktikos modulio identifikacinis numeris
	*@return Array pavadinimų asociatyvus masyvas
	*/
	public function getTasksInTeacherModule($teacher_module)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,task_name, teacher_module_id from tasks where teacher_module_id='.$teacher_module.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('StudentsInterface->getTasksInTeacherModule() Sugadinta tasks lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinas Dėstytojo praktikos modulio identifikacinis numeris
	*@param Integer $student_id Studento identifikacinis numeris
	*@return Integer Dėstytojo praktikos modulio identifikacinis numeris
	*/
	public function getTeacherModuleID($student_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select teacher_module_id from choised_jobs where student_id='.$student_id);
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getTeacherModuleID() Sugadinta choised_jobs lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami užduoties duomenys
	*@param Integer $task_id užduoties identifikacinis numeris
	*@return Array užduoties duomenys
	*/
	public function getTask($task_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select task_name,task_description from tasks where id='.$task_id);
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getTask() Sugadinta tasks lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}

	/**
	*Gražinama tam tikros užduoties tam tikro studento darbo ataskaita
	*@param Integer $task_id užduoties identifikacinis numeris
	*@param Integer $student_id Studento identifikacinis numeris
	*@return Array Užduoties ataskaitos duomenys
	*/
	public function getTaskReport($task_id,$student_id)
	{
		//echo $teachers_modules_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id,title,description,grade from students_reports where task_id='.$task_id.' and student_id='.$student_id);
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->getTaskReport() Sugadinta students_reports lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami studentų ataskaitų komentarai
	*@param Integer $student_report_id Studento ataskaitos identifikacinis numeris
	*@return String Praktikos darbo komentarai
	*/
	public function getStudentReportComments($student_report_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$comments = array();
		$result = $db->query('select id,commenter_id,commenter_table_id,comment,time from students_reports_comments where student_report_id='.$student_report_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('StudentsInterface->getStudentReportComments() Sugadinta students_reports_comments lentelė');
		}
		while ($result->fetchInto($data)) {
			if ($data[2] == 1) {
				$res = $db->query('select name,surname from students where id='.$data[1]);
			}
			if ($data[2] == 2) {
				$res = $db->query('select name from companies where id='.$data[1]);
			}
			if ($data[2] == 3) {
				$res = $db->query('select name,surname from teachers where id='.$data[1]);
			}
			if (PEAR::isError($res)) {
				$db->disconnect();
				die('StudentsInterface->getStudentReportComments() Sugadinta students,companies,teachers lentelė');
			}
			$res->fetchInto($comment);
			if ($data[2] == 1 || $data[2] == 3) {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0],$comment[1]);
			} else {
				$comments[]  = array($data[0],$data[2],$data[3],$data[4],$comment[0]);
			}
		}
		$db->disconnect();
		//print_r($comments);
		return $comments;
	}
	
	/**
	*Studentų ataskaita įrašoma į DB
	*@param Integer $task_id užduoties identifikacinis numeris
	*@param Integer $student_id Studento identifikacinis numeris
	*@param String $title Antraštė
	*@param Integer $description Ataskaita
	*/
	public function insertStudentReport($task_id,$student_id,$title,$description)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id from students_reports where task_id='.$task_id.' and student_id='.$student_id);
		
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('StudentsInterface->insertStudentReport() Sugadinta students_reports lentelė');
		}
		
		$result->fetchInto($data);
		
		if (isset($data)) {
			$query = $db->prepare('update students_reports set title=?,description=? where id='.$data[0]);
			$data = array($title,$description);
			$db->execute($query, $data);
		} else {
			$query = $db->prepare('insert into students_reports (task_id,student_id,title,description) VALUES (?,?,?,?)');
			$data = array($task_id,$student_id,$title,$description);
			$db->execute($query, $data);
		}
	}
	
	/**
	*Studento ataskaitos komentaras įrašomas į DB.
	*@param Integer $commenter_id Komentuotojo identifikacinis numeris
	*@param Integer $commenter_table_id Kas yra komentuotojas (1 - studentas, 2 - įmonė, 3 - dėstytojas);
	*@param String $comment Komentaras
	*@param Integer $student_report_id Studento ataskaitos identifikacinis numeris
	*/
	public function insertStudentReportComment($commenter_id,$commenter_table_id,$comment,$student_report_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into students_reports_comments (commenter_id,commenter_table_id,comment,student_report_id) VALUES (?,?,?,?)');
		$data = array($commenter_id,$commenter_table_id,$comment,$student_report_id);
		$db->execute($query, $data);
	}

}

/** 
* Dėstytojų sąsajos duomenų valdymas
*
* Gražinami dėstytojų duomenų asociatyvieji masyvai, taip pat keičiami duomenų dėstytojų įrašai, manipuliuojama su praktikos darbais
*@package DataManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class TeacherInterface extends StudentsInterface  
{
	/**
	*Uždaromas dėstytojo dėstomas praktikos modulis
	*@param Integer $teacherModuleID Dėstytojo dėstomo modulio identifikacinis numeris
	*
	*/
	public function closePracticeModule($teacherModuleID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select practice_job_id from choised_jobs where teacher_module_id='.$teacherModuleID.'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('TeacherInterface->closePracticeModule() Sugadinta choised_jobs lentelė');
		}
		while($result->fetchInto($data)) {
			$db->query('delete from practice_jobs where id='.$data[0].'');
			//echo ;
		}
		$db->query('delete from tasks where teacher_module_id='.$teacherModuleID.'');
		$db->query('update teachers_modules set closed=true where id='.$teacherModuleID);
		$db->disconnect();
		
	}
	/**
	*Atidaromas dėstytojo dėstomas praktikos modulis
	*@param Integer $teacherModuleID Dėstytojo dėstomo modulio identifikacinis numeris
	*
	*/
	public function openPracticeModule($teacherModuleID)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$db->query('update teachers_modules set closed=false');
		$db->disconnect();
	}
	
	/**
	*Gražinami dėstytojo prisijungimo prie sistemos identifikacinis numeris
	*@param Integer $username Dėstytojo prisijungimo vardas
	*@return Integer dėstytojo prisijungimo prie sistemos identifikacinis numeris
	*/
	public function getTeacherID($username)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id from teachers where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('TeacherInterface->getTeacherID() Sugadinta teachers lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
	/**
	*Gražinami dėstytojų dėstomų modulių 
	*@param Integer $teacherID Dėstytojo identifikacinis numeris
	*@return Array pavadinimų asociatyvus masyvas
	*/
	public function getTeacherModules($teacherID)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select teachers_modules.id,pratice_modules.id,teachers_modules.closed,pratice_modules.code, pratice_modules.study_program,pratice_modules.name from pratice_modules,teachers_modules where pratice_modules.id=teachers_modules.practice_module_id and teachers_modules.teacher_id='.$teacherID);
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getTeacherModules() Sugadinta pratice_modules,teachers_modules lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinami dėstytojo dėstomas modulis
	*@param Integer $teacherModuleID Dėstytojo dėstomo modulio identifikacinis numeris
	*@return Array Dėstomo modulio duomenų asociatyvus masyvas
	*/
	public function getTeacherModule($teacherModuleID)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select teachers_modules.id,pratice_modules.id,teachers_modules.closed,pratice_modules.code, pratice_modules.study_program,pratice_modules.name from pratice_modules,teachers_modules where pratice_modules.id=teachers_modules.practice_module_id and teachers_modules.id='.$teacherModuleID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getTeacherModule() Sugadinta pratice_modules,teachers_modules lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamos užduotys priklausančios dėstomam praktikos darbo moduliui
	*@param Integer $teacherModuleID Dėstytojo dėstomo modulio identifikacinis numeris
	*@return Array Užduotys
	*/
	public function getTasks($teacherModuleID)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,task_name from tasks where teacher_module_id='.$teacherModuleID.' order by id');
		if (PEAR::isError($data)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getTasks() Sugadinta tasks lentelė');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinama užduoties duomenys
	*@param Integer $taskID Užduoties identifikacinis numeris
	*@return Array Užduotys duomenys
	*/
	public function getTask($taskID)
	{
		//echo $subcategory_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$result = $db->query('select id,task_name,task_description from tasks where id='.$taskID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getTask() Sugadinta tasks lentelė');
		}
		$result->fetchInto($data);
		$db->disconnect();
		return $data;
	}
	
	/**
	*Užduoties įrašymas į DB
	*@param Integer $teacher_module_id Dėstytojo dėstomo praktimos modulio identifikacinis numeris
	*@param Integer $task_name Užduoties antraštė
	*@param String $task_description užduoties aprašymas
	*/
	public function insertTask($teacher_module_id,$task_name,$task_description)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into tasks (teacher_module_id,task_name,task_description) VALUES (?,?,?)');
		$data = array($teacher_module_id,$task_name,$task_description);
		$db->execute($query, $data);
	}
	
	/**
	*Užduoties modifikavimas
	*@param Integer $task_id užduoties identifikacinis numeris
	*@param Integer $task_name Užduoties antraštė
	*@param String $task_description užduoties aprašymas
	*/
	public function updateTask($task_id,$task_name,$task_description)
	{
		//echo 'update tasks set task_name=?,task_description=? where id='.$task_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update tasks set task_name=?,task_description=? where id='.$task_id);

		$data = array($task_name,$task_description);
		$db->execute($query, $data);
	}
	
	/**
	*Praktikos darbo užduoties pašalinimas
	*@param Integer $id Praktikos darbo užduoties identifikacinis numeris
	*@return 1 - Užduotis pašalintas sėkmingai, 0 - užduoties pašalinimo klaida
	*/
	public function removeTask($id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('delete from tasks where id=?');
		if (PEAR::isError($query)) {
			return 0;
		}
		$res = $db->execute($query, array($id));
		if (PEAR::isError($res)) {
			return 0;
		}
		return 1;
	}
	
	/**
	*Gražinami studentų duomenys pagal dėstytojo dėstomą praktikos modulį
	*@param Integer $teacherModuleID dėstytojo dėstomo dalyko identifikacinis numeris
	*@return Array Studento duomenys
	*/
	public function getStudentsInTeacherModule($teacherModuleID)
	{
		//echo $teacherModuleID;
		$connect = new Connect();
		$db = $connect->getConnect();
		
		$result = $db->query('select students.id, students.student_no, students.email, students.name, students.surname from choised_jobs,students where choised_jobs.student_id=students.id and choised_jobs.teacher_module_id='.$teacherModuleID.' order by students.name');
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getStudentsInTeacherModule() Sugadinta choised_jobs,students lentelė');
		}
		$students = array();
		while ($result->fetchInto($data)) {
			$students[] = $data;
		}
		$db->disconnect();
		//echo "--";
		//print_r($students);
		return $students;
	}
	
	/**
	*Praktikos išmetimas iš praktikos
	*@param Integer $student_id studento identifikacinis numeris
	*/
	public function removeStudentPractice($student_id)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$db->prepare('delete from choised_jobs where student_id=?');
		$db->execute($query, array($student_id));
		$db->disconnect();
		$connect = new Connect();
		$db = $connect->getConnect();
		$db->prepare('delete from students_reports where student_id=?');
		$db->execute($query, array($student_id));
		$db->disconnect();

	}
	
	/**
	*Gražinami studentų duomenys pagal užduoties identifikacinį numerį
	*@param Integer $taskID užduoties identifikacinis numeris
	*@return Array Studento duomenys
	*/
	public function getStudentsInTasks($taskID)
	{
		//echo $teacherModuleID;
		$connect = new Connect();
		$db = $connect->getConnect();
		
		$result = $db->query('select students.id, students.student_no, students.name, students.surname from students_reports,students where students_reports.student_id=students.id and students_reports.task_id='.$taskID.' order by students.name');
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getStudentsInTasks() Sugadinta students_reports,students lentelė');
		}
		$students = array();
		while ($result->fetchInto($data)) {
			$students[] = $data;
		}
		$db->disconnect();
		//echo "--";
		//print_r($students);
		return $students;
	}
	
	/**
	*Studento darbo įvertinimas
	*@param Integer $task_id užduoties identifikacinis numeris
	*@param Integer $student_id studento identifikacinis numeris
	*@param String $grade Pažymys
	*/
	public function setGrade($task_id,$student_id,$grade)
	{
		//echo 'update students_reports set grade=? where task_id='.$task_id.' and student_id='.$student_id;
		$connect = new Connect();
		$db = $connect->getConnect();
		$query = $db->prepare('update students_reports set grade=? where task_id=? and student_id=?');

		$data = array($grade,$task_id,$student_id);
		$db->execute($query, $data);
	}
	
	/**
	*Gražinamas studento ataskaitos identifikacinis numeris
	*@param Integer $task_id užduoties identifikacinis numeris
	*@param Integer $student_id studento identifikacinis numeris
	*@return Integer studento ataskaitos identifikacinis numeris
	*/
	public function getStudentReportID($task_id,$student_id)
	{
		//echo $teacherModuleID;
		$connect = new Connect();
		$db = $connect->getConnect();
		
		$result = $db->query('select id from students_reports where task_id='.$task_id.' and student_id='.$student_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $data->getMessage();
			die('TeacherInterface->getStudentReportID() Sugadinta students_reports lentelė');
		}

		$result->fetchInto($data);
		$db->disconnect();
		return $data[0];
	}
	
}

/*
$a = new CompaniesInterface();
print_r($a->getPracticeJobStudent(2));
*/
?>
