<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

* Šioje klasėje realizuotos visos operacijos susijusios su klientų valdymu
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Customer
{
	/**
	*
	*
	*Tikrinama ar fizinio asmens vardas ar pavardė sudarytas tik iš didžiųjų arba mažųjų raidžių bei gali gali talpinti tarpų simbolį
	*@param String $naturalPersonNameSurname fizinio asmens vardas arba pavardė
	*@return Boolean true - valid $naturalPersonNameSurname, false - Invalid
	*/
	public function checkNaturalPersonNameSurname($naturalPersonNameSurname)
	{
		$naturalPersonNameSurname = trim($naturalPersonNameSurname);
		if (strlen($naturalPersonNameSurname) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя]/",$naturalPersonNameSurname)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Tikrinamas asmens kodas
	*@param String $identityCode fizinio asmens asmens kodas
	*@return Boolean true - valid $identityCode, false - Invalid
	*/
	public function checkIdentityCode($identityCode)
	{
		$identityCode = trim($identityCode);
		if (preg_match("/\b[\d]{11}\b/",$identityCode)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Tikrinamas adresas
	*@param String $address Gyvenamosios vietos adresas
	*@return Boolean true - valid $address, false - Invalid
	*/
	public function checkAddress($address)
	{
		$address = trim($address);
		if (strlen($address) == 0) return false; 
		
		if (preg_match("/[^\da-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя\\\\\-\\.,:]/",$address)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*Elektronio pašto adreso tikrinimas
	*
	*Tikrinama ar elektroninis paštas sudarytas pagal taisykles
	*@param String $email elektroninio pašto adresas
	*@return Boolean true - valid $email, false - Invalid
	*/
	public function checkEmail($email) 
	{
		$email = trim($email);
		if (preg_match("/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$/",$email)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Telefono tikrinimas
	*
	*Tikrinama ar telefono numeris sudarytas tinkamai
	*@param String $phone telefono numeris
	*@return Boolean true - valid $phone, false - Invalid
	*/
	public function checkPhone($phone) 
	{
		$phone = trim($phone);
		if (preg_match("/^[+\d][\d]+[\d]$/",$phone)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*PVM kodo tikrinimas
	*
	*Tikrinama ar PVM kodas sudarytas tinkamai
	*@param String $vat_code PVM kodas
	*@return Boolean true - valid $vat_code, false - Invalid
	*/
	public function checkVATCode($vat_code) 
	{
		$vat_code = trim($vat_code);
		if (strlen($vat_code) == 0) return true;
		if (preg_match("/[^\d\w]/",$vat_code)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Tikrinama vartotojo vardas
	*@param String $username Prisijungimo prie sistemos vartotojo vardas
	*@return Boolean true - valid $username, false - Invalid
	*/
	public function checkUsername($username)
	{
		$username = trim($username);
		if (strlen($username) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ\d\\-_]/",$username)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Slaptažodžio tikrinimas
	*@param String $password Prisijungimo prie sistemos slaptažodžio tikrinimas
	*@return Boolean true - valid $password, false - Invalid
	*/
	public function checkPassword($password)
	{
		$password = trim($password);
		if (strlen($password) == 0) return false; 
		
		if (preg_match("/[\r\t\n\f]/",$password)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Tikrinamas įmonės pavadinimas
	*@param String $companyName Įmonės pavadinimas
	*@return Boolean true - valid $companyName, false - Invalid
	*/
	public function checkCompanyName($companyName)
	{
		$companyName = trim($companyName);
		if (strlen($companyName) == 0) return false; 
		
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ АаБбВвГгДдЕеЁёЖжЗзИиЙйКкЛлМмНнОоПпРрСсТтУуФфХхЦцЧчШшЩщъЫыьЭэЮюЯя\\\\\-\\.,:]/",$companyName)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Įmonės kodo tikrinimas
	*@param String $code Įmonės kodas
	*@return Boolean true - valid $code, false - Invalid
	*/
	public function checkCode($code)
	{
		$code = trim($code);
		if (strlen($code) == 0) return false; 
		
		if (preg_match("/[^\d]/",$code)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Skaičiaus po kablelio tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Vartotojo vardo egzistencijos tikrinimas
	*@param String $username kliento vartotojo vardas 
	*@return Boolean true - egzistoja toks $username duomenų bazėja, false - neegzistuoja
	*/
	public function checkUsernameExistence($username)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$username = trim($username);
		$result= $db->query('select id from customer where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->checkUsernameExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Kliento egzistencijos tikrinimas
	*@param String $name kliento vardas 
	*@param String $surname kliento pavardė
	*@return Boolean true - egzistoja toks klientas duomenų bazėja, false - neegzistuoja
	*/
	public function checkCustomerExistence($name,$surname)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$name = trim($name);
		$surname = trim($surname);
		$result= $db->query('select id from customer where name=\''.$name.'\' and surname=\''.$surname.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->checkCustomerExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Kliento registracijos duomenys įrašomi į db.
	*@param String $name Kliento vardas, jei fizinis asmuo
	*@param String $surname Kliento pavardė, jei fizinis asmuo
	*@param String $identity_code Asmens kodas, jei fizinis asmuo
	*@param String $address Kliento adresas
	*@param String $phone Kliento telefonas
	*@param String $email Kliento email
	*@param String $company_name Įmonės pavadinimas, jei juridinis asmuo
	*@param String $position Įmonėje dirbačio asmens pareigos
	*@param String $code Įmonės kodas, jei juridinis asmuo
	*@param String $vat_code Įmonės PVM kodas, jei juridinis asmuo
	*@param String $fax Faksas, jei juridinis asmuo
	*@param Boolean $type Kliento tipas: true - fizinis asmuo; false - juridinis asmuo
	*/
	public function insertCustomer($name,$surname,$identity_code,$address,$phone,$email,$company_name,$position,$code,$vat_code,$fax,$type)
	{
		//echo "(name=$name,surname=$surname,identity_code=$identity_code,address=$address,phone=$phone,email=$email,company_name=$company_name,code=$code,fax=$fax,type=$type,username=$username,password=$password)";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO customer (name,surname,identity_code,address,phone,email,company_name,position,code,vat_code,fax,type) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($name,$surname,$identity_code,$address,$phone,$email,$company_name,$position,$code,$vat_code,$fax,$type);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			//echo $query_res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Customer->insertCustomer()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*
	*Gražinamas kliento identifikacinis numeris pagal pateikta vartotojo vardą ir slaptažodį
	*@param String $username kliento pateiktas vartotojo vardas 
	*@param String $password kliento pateiktas slaptažodis
	*@return Integer 0 - klientas neegzistuoja, 1 ir daugiau - kliento identifikacinis numeris
	*/
	public function getCustomerID($name, $surname)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$name = trim($name);
		$surname = trim($surname);
		$result= $db->query('select id from customer where name=\''.$name.'\' and surname=\''.$surname.'\' and is_deleted=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerID()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Sesijos sunaikinimas - atsijungimas nuo portalo
	*@return void
	*/
	public function destrySession() {
		//session_start();
		$_SESSION = array();
		if (isset($_COOKIE[session_name()])) {
			setcookie(session_name(), '', time()-42000, '/');
		}
		session_destroy();
	}
	
	/**
	*Gražinami pasirinkto kliento duomenys
	*@param Integer $clientID Kliento identifikacinis numeris
	*@return Array pasirinkto kliento duomenys
	*/
	public function getCustomer($clientID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id, name, surname, identity_code, address, phone, email, company_name, code, fax, type, discount, vat_code, position from customer where id='.$clientID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomer()');
		}
		$res->fetchInto($customer);
		$db->disconnect();
		return $customer;
	}
	
	/**
	*Atnaujinami Kliento registracijos duomenys.
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param String $name Kliento vardas, jei fizinis asmuo
	*@param String $surname Kliento pavardė, jei fizinis asmuo
	*@param String $identity_code Asmens kodas, jei fizinis asmuo
	*@param String $address Kliento adresas
	*@param String $phone Kliento telefonas
	*@param String $email Kliento email
	*@param String $company_name Įmonės pavadinimas, jei juridinis asmuo
	*@param String $position Darbuotojo pareigos, jei juridinis asmuo
	*@param String $code Įmonės kodas, jei juridinis asmuo
	*@param String $vat_code Įmonės PVM kodas, jei juridinis asmuo
	*@param String $fax Faksas, jei juridinis asmuo
	*/
	public function updateCustomer($customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$position,$code,$vat_code,$fax)
	{
		//echo '$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password ->'."$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update customer set name=?,surname=?,identity_code=?,address=?,phone=?,email=?,company_name=?,code=?,fax=?,vat_code=?,position=? where id=?');
		$data = array($name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$vat_code,$position,$customerID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Customer->updateCustomer()');
		}
		$db->disconnect();
	}
	
		/**
	*Atnaujinami Kliento registracijos duomenys.
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Double $customerDiscount Klientu suteikiama nuolaida
	*@param String $name Kliento vardas, jei fizinis asmuo
	*@param String $surname Kliento pavardė, jei fizinis asmuo
	*@param String $identity_code Asmens kodas, jei fizinis asmuo
	*@param String $address Kliento adresas
	*@param String $phone Kliento telefonas
	*@param String $email Kliento email
	*@param String $company_name Įmonės pavadinimas, jei juridinis asmuo
	*@param String $position Kontaktinio asmens pareigos, jei juridinis asmuo
	*@param String $code Įmonės kodas, jei juridinis asmuo
	*@param String $vat_code Įmonės PVM kodas, jei juridinis asmuo
	*@param String $fax Faksas, jei juridinis asmuo
	*/
	public function updateCustomerWithDiscount($customerID,$customerDiscount,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$position, $code,$vat_code,$fax)
	{
		if ($customerDiscount+0 == 0) {
			$customerDiscount = 0;
		}
		//echo '$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password ->'."$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update customer set name=?,surname=?,identity_code=?,address=?,phone=?,email=?,company_name=?,code=?,fax=?, discount=?, position=?,vat_code=? where id=?');
		$data = array($name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$customerDiscount,$position,$vat_code,$customerID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			echo $query_res->getDebugInfo();
			die('Kritinė klaida: Customer->updateCustomerWithDiscount()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*
	*Gražinamas klientui suteikta nuoldaida
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer Klientui suteikta nuolaida
	*/
	public function getCustomerDiscount($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$customerID = trim($customerID);
		$result= $db->query('select discount from customer where id='.$customerID.' and is_deleted=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getCustomerDiscount()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas visų klientų asociatyvus masyvas
	*@return Array visų klientų asociatyvus masyvas
	*/
	public function getAllCustomers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, name, surname, identity_code, address, phone, email, company_name, code, fax, type, discount from customer order by id asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->getAllCustomers()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Kliento pašalinimas
	*
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return void
	*/
	public function removeCustomer($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from customer where id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Customer->removeCustomer()');
		}
		$db->disconnect();
	}
	
}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>