<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');



/**

* Šioje klasėje realizuotos SMS gavimo funkcijos
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Receiver
{
	/**
	*Įterpiami gauto sms duomenys į duomenų bazę
	*@param Integer $network_id GSM operatoriaus identifikacinis numeris (1 - Omnitel; 2 - Bite; 3 - Tele2)
	*@param String $senderphone Žinutės siuntejo telefono numeris
	*@param String $message_text Žinutės tekstas
	*@param String $received_time Žinutės gavimo laikas
	*@param Boolean $processed_status 1 - šiai žinutei išsiųstas atsakymas; 0 - atsakymas neišsiųstas
	*@return void Įterpiami gauto sms duomenys į duomenų bazę
	*/
	public function insertReceivedMessage($network_id,$senderphone,$message_text,$received_time,$processed_status)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO received_messages (network_id,senderphone,message_text,received_time,processed_status) values (?,?,?,?,?)');
		$data = array($network_id,$senderphone,$message_text,$received_time,$processed_status);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('Receiver->insertReceivedMessage() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: Receiver->insertReceivedMessage()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Gražinamas postgresql CURRENT_TIMESTAMP
	*@return postgresql CURRENT_TIMESTAMP
	*/
	public function getCurrentTimeStamp()
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select CURRENT_TIMESTAMP');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Receiver->getCurrentTimeStamp() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Receiver->getCurrentTimeStamp()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*
	*Gražinamas gautos žinutės identifikacinis numeris pagal pateiktą laiką
	*@param Timestamp $timeStamp Laiko timestamp reikšmė
	*@return Integer gautos žinutės identifikacinis numeris
	*/
	public function getReceivedMessageID($timeStamp)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id from received_messages where received_time=\''.$timeStamp.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Receiver->getReceivedMessageID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Receiver->getReceivedMessageID()');
		}
		
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	//time,phone,network_id,processed,message,allowed_billing_id,customer_id
	/**
	*Įterpiami SMS siunčiamo pranešimo duomenys gauti iš informacinės sistemos
	*@param Integer $network_id GSM operatoriaus identifikacinis numeris (1 - Omnitel; 2 - Bite; 3 - Tele2)
	*@param String $phone Gavėjo telefono numeris
	*@param String $message_text Žinutės tekstas
	*@param String $time Žinutės išsiuntimo laikas
	*@param Boolean $processed_status true - SMS žinutė išsiųsta; false - SMS žinutė neišsiųsta
	*@param Integer $allowed_billing_id Leidžiamas apmokestinimo identifikacinis numeris
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return void Įterpiami SMS siunčiamo pranešimo duomenys gauti iš informacinės sistemos
	*/
	public function insertSendSMSMessage($network_id,$phone,$message_text,$time,$processed_status,$allowed_billing_id,$customer_id)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('INSERT INTO send_sms_billing (network_id,phone,message,time,processed,allowed_billing_id,customer_id) values (?,?,?,?,?,?,?)');
		$data = array($network_id,$phone,$message_text,$time,$processed_status,$allowed_billing_id,$customer_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('Receiver->insertSendSMSMessage() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: Receiver->insertSendSMSMessage()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Gražinamas siunčiamos žinutės identifikacinis numeris pagal pateiktą laiką
	*@param Timestamp $timeStamp Laiko timestamp reikšmė
	*@return Integer siunčiamos žinutės identifikacinis numeris pagal pateiktą laiką
	*/
	public function getReceivedSendMessageID($timeStamp)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id from send_sms_billing where time=\''.$timeStamp.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Receiver->getReceivedSendMessageID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Receiver->getReceivedSendMessageID()');
		}
		
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>