<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');

/**
* Prijungiama Customer.class.php klientų duomenų valdymo klasė
*/
require_once('Customer.class.php');

/**
* Prijungiama MessageSender.class.php daugiatarifių SMS žinučių siuntimo klasių biblioteka
*/
require_once('MessageSender.class.php');



/**

* Šioje klasėje realizuotos gauto SMS apdorojimas
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Processing
{
	//Atsakymas i klaidingai pateikta uzklausa
	private $error = "Atsiprasome, siuo metu negalime priimti Jusu zinutes. Del detalesnes informacijos skambinkite tel. 1616 nuo 6.00 iki 22.00 valandos(sis pranesimas nemokamas).";
	
	//id,network_id,senderphone,message_text,received_time
	
	/**
	 *Apdorojama gauta žinutė ir pagal gautus duomenis atliekami atitinkami apmokestinimai
	 * 
	 *@param String $receivedMessageID Gautos žinutės identifikacinis numeris
	 *@param Integer $messageText gautos žinutės tekstas
	 *@param Integer $networkID GSM operatoriaus identifikacinis numeris (1 - Omnitel; 2 - Bite; 3 - Tele2) 
	 *@param String $phoneNumber Telefono numeris
	 */
	public function processReceivedMessage($receivedMessageID,$messageText,$networkID,$phoneNumber) {
		$customer = new Customer();
		$sender = new MessageSender();
		
		if ($networkID == 3) {
			$keywords = preg_split("/[\s]+/", trim($messageText));
			if (count($keywords) >= 1) {
				
				$firstMessageWord = $keywords[0];
				$secondMessageWord = $keywords[1];
				
				
				$customerID = $customer->getCustomerID($firstMessageWord);
				$isAccessAllowed = $customer->checkGSMAccess($customerID,3);
				$customerSubcodeID = $customer->getSubCodeID($secondMessageWord,$customerID);
				$isURLEnabled = $customer->checkCustomerISURL($customerID);
				
				//echo $customerSubcodeID ."<br />";
				//echo $isURLEnabled ."<br />";
				
				//Toks kliento kodas neegzistuoja
				if ($customerID == 0) {
					$sender->sendMessage($receivedMessageID,$phoneNumber,'1616',$this->error,0,1);
					$sender->changeReceivedSMSMessageStatus($receivedMessageID);
					$customer->setReceiveMessagePrice($receivedMessageID,0);
				}
				
				//Klientas egzistuoja, bet nerastas subcodas, siunciam jei nera aktyvus kliento IS url adresas
				if ($customerID > 0 && $customerSubcodeID == 0 && $isAccessAllowed == true && $isURLEnabled == false) {
					$errorMessage = $customer->getCustomerErrorReply($customerID);
					$sender->sendMessage($receivedMessageID,$phoneNumber,'1616',$errorMessage,0,1);
					$sender->changeReceivedSMSMessageStatus($receivedMessageID);
					$customer->setReceiveMessageCustomer($receivedMessageID,$customerID);
					$customer->setReceiveMessagePrice($receivedMessageID,0);
				}
				if ($customerID > 0 && $customerSubcodeID > 0 && $isAccessAllowed == true && $isURLEnabled == false) {
					$subcodeReply = $customer->getCustomerSubcodeReply($customerSubcodeID);
					$price = $customer->getCustomerSubcodePrice($customerSubcodeID);
					$sender->sendMessage($receivedMessageID,$phoneNumber,'1616',$subcodeReply,$price,1);
					$sender->changeReceivedSMSMessageStatus($receivedMessageID);
					$customer->setReceiveMessageCustomer($receivedMessageID,$customerID);
					$customer->setReceiveMessagePrice($receivedMessageID,$price);
				}
			} else {
				$sender->sendMessage($receivedMessageID,$phoneNumber,'1616',$this->error,0,1);
				$sender->changeReceivedSMSMessageStatus($receivedMessageID);
			}
			
		}

	}
	
}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>