<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');



/**

* Šioje klasėje realizuotos Klientų duomenų valdymas
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Customer
{

	
	/**
	*
	*Gražinamas kliento identifikacinis numeris pagal atsiųstą žinutės kodą
	*@param String $firstMessageWord Pirmas gautos žinutės žodis
	*@return Integer 0 - klientas nerastas; 1 ir daugiau - kliento identifikacinis numeris
	*/
	public function getCustomerID($firstMessageWord)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$firstMessageWord = strtolower ($firstMessageWord);
		$result = $db->query('select id from customers where lower(message_code)=\''.$firstMessageWord.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerID()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Gražinamas kliento subcodo identifikacinis numeris
	*@param String $subCode Subkodo pavadinimas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer 0 - subkodas nerastas; 1 ir daugiau - subkodo identifikacinis numeris
	*/
	public function getSubCodeID($subCode,$customerID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$subCode = strtolower ($subCode);
		$result = $db->query('select id from customer_subcodes where lower(message_subcode)=\''.$subCode.'\' and customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getSubCodeID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getSubCodeID()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Gražinamas kliento neteisingos užklausos atsakymas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return String - Gražinamas kliento neteisingos užklausos atsakymas
	*/
	public function getCustomerErrorReply($customerID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select error_reply from customers where id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerErrorReply() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerErrorReply()');
		}
		
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*
	*Gražinamas sub-kodo atasakymas
	*@param Integer $subCodeID sub-kodo identifikacinis numeris
	*@return String - Gražinamas sub-kodo atasakymas
	*/
	public function getCustomerSubcodeReply($subCodeID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select reply from customer_subcodes where id='.$subCodeID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerSubcodeReply() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerSubcodeReply()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*
	*Gražinamas sub-kodo kaina centais
	*@param Integer $subCodeID sub-kodo identifikacinis numeris
	*@return Integer sub-kodo kaina centais
	*/
	public function getCustomerSubcodePrice($subCodeID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select cost from billing where id=(select billing_id from assigned_customers_billing where id=(select allowed_billing_id from customer_subcodes where id='.$subCodeID.'))');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerSubcodePrice() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerSubcodePrice()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Tikrinama ar klientui leidžiama naudotis tam tikru GSM tinklu
	*@param String $firstMessageWord Pirmas gautos žinutės žodis
	*@param Integer $customerID Kliento identifikacinis numeris 
	*@param Integer $networkID GSM operatoriaus identifikacinis numeris (1 - Omnitel; 2 - Bite; 3 - Tele2) 
	*@return Boolean t - klientas turi leidimą operuoti tinklu, f - prieiga uždrausta
	*/
	public function checkGSMAccess($customerID,$networkID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id from allowed_networks where network_id='.$networkID.' and customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->checkGSMAccess() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->checkGSMAccess()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	
	/**
	*
	*Tikrinama ar kliento informacinės sistemos adresas naudojamas
	* 
	*@param Integer $customerID Kliento identifikacinis numeris 
	*@return Boolean true - kliento informacinės sistemos adresas pateiktas
    *                false - informacinės sistemos adresas nėra aktyvus 
	*/
	public function checkCustomerISURL($customerID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select url from customers where id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->checkCustomerISURL() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->checkCustomerISURL()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			if (strlen($data[0]) >= 8) {
				return true;
			} else {
				return false;
			}
		} else {
			return false;
		}
	}
	
	/**
	*
	*Gražinamas informacinės sistemos adresas
	* 
	*@param Integer $customerID Kliento identifikacinis numeris 
	*@return String Gražinamas informacinės sistemos adresas
	*/
	public function getCustomerISURL($customerID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select url from customers where id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerISURL() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerISURL()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*
	*Gražinama kaina pagal pateiktą kliento leidžiamą tarifo identifikacinį numerį
	* 
	*@param Integer $customerID Kliento identifikacinis numeris 
	*@param Integer $allowedBillingID Leidžiamo klientui priskirto tarifo identifikacinis numeris
	*@return Integer Leidžiamo tarifo kaina centais; -1 - tarifas nerastas
	*/
	public function getPriceByAllowedBillingID($customerID,$allowedBillingID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select billing.cost from billing,assigned_customers_billing where billing.id=assigned_customers_billing.billing_id and assigned_customers_billing.id='.$allowedBillingID.' and assigned_customers_billing.customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getPriceByAllowedBillingID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getPriceByAllowedBillingID()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return -1;
		}
	}
	
	
	/**
	*Gautai žinutei, kliento priskyrimas
	*@param Integer $receiveMessageID gautos žinutės identifikacinis numeris
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return void Gautai žinutei, kliento priskyrimas
	*/
	public function setReceiveMessageCustomer($receiveMessageID,$customerID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update received_messages set client_id=? where id=?');
		$data = array($customerID,$receiveMessageID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('Customer->setReceiveMessageCustomer() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: Customer->setReceiveMessageCustomer()');
		}
		$db->disconnect();
	}
	
	/**
	*Gautai žinutei, kainos priskyrimas
	*@param Integer $receiveMessageID gautos žinutės identifikacinis numeris
	*@param Integer $price Gautai žinutei išsiųsta kaina
	*@return void Gautai žinutei, kainos priskyrimas
	*/
	public function setReceiveMessagePrice($receiveMessageID,$price)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update received_messages set price=? where id=?');
		$data = array($price,$receiveMessageID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('Customer->setReceiveMessagePrice() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: Customer->setReceiveMessagePrice()');
		}
		$db->disconnect();
	}
	
	
	/**
	*
	*Gražinamas GSM operatoriaus id pagal žinutės ID
	* 
	*@param Integer $receivedMessageID gautos žinutės identifikacinis numeris
	*@return Integer GSM operatoriaus identifikacinis numeris
	*/
	public function getOperatorID($receivedMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select network_id from received_messages where id='.$receivedMessageID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getOperatorID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getOperatorID()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}

	/**
	*
	*Gražinamas kliento identifikacinis numeris pagal žinutės identifikacinį numerį
	* 
	*@param Integer $receivedMessageID gautos žinutės identifikacinis numeris
	*@return Integer kliento identifikacinis numeris pagal žinutės identifikacinį numerį
	*/
	public function getCustomerIDByReceiveMessageID($receivedMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select message_text from received_messages where id='.$receivedMessageID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerIDByReceiveMessageID() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerIDByReceiveMessageID()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		
		$keywords = preg_split("/[\s]+/", trim($data[0]));
		if (count($keywords) >= 1) {	
			$firstMessageWord = $keywords[0];
			return $this->getCustomerID($firstMessageWord);
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Gražinama kaina pagal leidžiamo tarifo identifikacinį numerį
	*@param Integer $allowedBillingID leidžiamo tarifo identifikacinis numeris
	*@return Integer Atsakymo kaina centais
	*/
	public function getCustomerAllowdBillingPrice($allowedBillingID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select cost from billing where id=(select billing_id from assigned_customers_billing where id='.$allowedBillingID.')');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getCustomerAllowdBillingPrice() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getCustomerAllowdBillingPrice()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*Gražinamas žinutės siuntėjo telefonas
	* 
	*@param Integer $receivedMessageID gautos žinutės identifikacinis numeris
	*@return String Gautos žinutės telefono nr.
	*/
	public function getReceiveMessagePhone($receivedMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select senderphone from received_messages where id='.$receivedMessageID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('Customer->getReceiveMessagePhone() -> '.$result->getDebugInfo());
			die('Kritinė klaida: Customer->getReceiveMessagePhone()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*Gauta atsakymo žinutė įrašoma į DB
	*@param Integer $received_message_id $Gautos žinutės identifikacinis numeris
	*@param Integer $allowed_billing_id Leidžiamas siunčiamos žinutės klientui priskirtas tarifas
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@param String $reply Siunčiamas gautai žinutei atsakymas
	*@param Boolean $processed_status Žinutės apdorojimo statusas
	*@return void Gauta atsakymo žinutė įrašoma į DB
	*/
	public function insertReplyISMessage($received_message_id,$allowed_billing_id,$customer_id,$reply,$processed_status)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into send_messages (received_message_id,allowed_billing_id,customer_id,reply,processed_status) values (?,?,?,?,?)');
		$data = array($received_message_id,$allowed_billing_id,$customer_id,$reply,$processed_status);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('Customer->insertReplyISMessage() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: Customer->insertReplyISMessage()');
		}
		$db->disconnect();
	}

}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>