<?php

/**
* Prijungiama HTTP/Client.php PEAR klasių rinkinio HTTP request'ų valdymo klasė
*/
require_once 'HTTP/Client.php';

/**
* Prijungiama classes/Receiver.class.php SMS gavimo klasių biblioteka
*/
require_once('classes/Receiver.class.php');

/**
* Prijungiama classes/DeliverMessagesToThirdParties.class.php Žinučių perdavimo trečiai šaliai klasių biblioteka
*/
require_once('classes/DeliverMessagesToThirdParties.class.php');

/**
* Prijungiama classes/MessageSender.class.php daugiatarifių SMS žinučių siuntimo klasių biblioteka
*/
require_once('classes/MessageSender.class.php');

/**
* Prijungiama classes/Customer.class.php Klientų duomenų valdymas
*/
require_once('classes/Customer.class.php');

/**
* Prijungiama classes/Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('classes/Logging.class.php');




$http = new HTTP_Client();

$xml = <<<XML
<?xml version="1.0" encoding="ISO-8859-1"?>
<message>
	<submit>
		<oa>
			<number>1616</number>
		</oa>
		<da>
			<number>+37065859790</number>
		</da>
		<ud>is siuntimas</ud>
		<allowed_billing_id>1</allowed_billing_id>
		<customer_id>1</customer_id>
	</submit>
</message>
XML;

$xml = new SimpleXMLElement($HTTP_RAW_POST_DATA);
//$xml = new SimpleXMLElement($xml);

$originatingNumber = $xml->submit->da->number;
$message = $xml->submit->ud;
$allowed_billing_id = $xml->submit->allowed_billing_id;
$customer_id = $xml->submit->customer_id;

$customer = new Customer();
if ($customer->getPriceByAllowedBillingID($customer_id,$allowed_billing_id) != -1) {
	$receiver = new Receiver();
	$currentTimestamp = $receiver->getCurrentTimeStamp();
	
	$receiver->insertSendSMSMessage(2,$originatingNumber,$message,$currentTimestamp,false,$allowed_billing_id,$customer_id);
	
	$sender = new MessageSender();
	if ($sender->sendMessage($receiver->getReceivedSendMessageID($currentTimestamp),$originatingNumber,'1616',$message,$customer->getPriceByAllowedBillingID($customer_id,$allowed_billing_id),2) == true) {
		$sender->changeSendedSMSMessageStatus($receiver->getReceivedSendMessageID($currentTimestamp));
	}
} else {
	$log = new Logging();
	$log->logError('sms_sender.php -> Invalid Billing: oa: '.$xml->submit->oa->number.' da: '.$xml->submit->da->number.' ud: '.$xml->submit->ud.' allowed_billing_id: '.$xml->submit->allowed_billing_id.' customer_id: '.$xml->submit->customer_id);
}





?>