﻿<?php
/**
*Vartojojų valdymo paketas
*
*Registracijos tikrinimas, ...
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2005, Mindaugas Rimkus
*@package ServerRequestmanager
*@subpackage UserManagement
*/

/**
* Prijungiama /classes/DataManagement.class.php klasių biblioteka
*/
require_once('DataManagement.class.php');
/**

* Studento registracijos tikrinimas
*
* Tikrinamos studento registracijos forma, ar studentas suvedė teisingą informaciją. Teisingos informacijos įrašymas į DB.
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class StudentRegister
{
	/**
	*Studento numerio tikrinimas
	*
	*Tikrinama ar studento numeris sudededa tik iš skaičių, taip pat ar jis yra sudarytas iš 6 skaičių.
	*@param String $studentNo  Studento pažymėjimo numeris
	*@return Integer 1 - valid $studentNo, 0 - Invalid
	*/
	public function checkStudentNo($studentNo)
	{
		$studentNo = trim($studentNo);
		if (preg_match("/^\d\d{4}\d$/",$studentNo)) {
			return 1;
		} else {
			return 0;
		}
	}
	/**
	*Studento vardo tikrinimas
	*
	*Tikrinama ar studento vardas sudarytas tik iš raidžių, neleidžiami kiti simboliai.
	*@param String $studentName  Studento vardas
	*@return Integer 1 - valid $studentName, 0 - Invalid
	*/
	public function checkStudentName($studentName) 
	{
		$studentName = trim($studentName);
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ]/",$studentName) || strlen($studentName) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Studento pavardės tikrinimas
	*
	*Tikrinama ar studento pavardė sudaryta tik iš raidžių, neleidžiami kiti simboliai.
	*@param String $studentSurname Studento pavardė
	*@return Integer 1 - valid $studentSurname, 0 - Invalid
	*/
	public function checkStudentSurname($studentSurname) 
	{
		$studentSurname = trim($studentSurname);
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ]/",$studentSurname) || strlen($studentSurname) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Studento vartotojo vardo tikrinimas
	*
	*Tikrinama ar studento vartotojo vardas netalpita tarpų simbolių.
	*@param String $studentUsername Studento vartotojo vardas
	*@return Integer 1 - valid $studentUsername, 0 - Invalid
	*/
	public function checkStudentUsername($studentUsername) 
	{
		if (preg_match("/\s/",$studentUsername) || strlen($studentUsername) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Studento slaptažodžio tikrinimas
	*
	*Tikrinama ar studento slaptažodis netalpita tarpų simbolių.
	*@param String $studentPassword Studento slaptažodis
	*@return Integer 1 - valid $studentPassword, 0 - Invalid
	*/
	public function checkStudentPassword($studentPassword) 
	{
		if (preg_match("/\s/",$studentPassword) || strlen($studentPassword) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Studento elektronio pašto adreso tikrinimas
	*
	*Tikrinama ar studento elektroninis paštas sudarytas pagal taisykles
	*@param String $studentEmail Studento elektroninio pašto adresas
	*@return Integer 1 - valid $studentEmail, 0 - Invalid
	*/
	public function checkStudentEmail($studentEmail) 
	{
		$studentEmail = trim($studentEmail);
		if (preg_match("/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$/",$studentEmail)) {
			return 1;
		} else {
			return 0;
		}
	}
	/**
	*Studento telefono tikrinimas
	*
	*Tikrinama ar telefono numeris sudarytas tinkamai
	*@param String $studentPhone Studento telefono numeris
	*@return Integer 1 - valid $studentPhone, 0 - Invalid
	*/
	public function checkStudentPhone($studentPhone) 
	{
		$studentPhone = trim($studentPhone);
		if (preg_match("/^[+\d][\d]+[\d]$/",$studentPhone) || strlen($studentPhone) == 0) {
			return 1;
		} else {
			return 0;
		}
	}
	/**
	*Studento egzistencijos tikrinimas pagal studento pažymėjimo numerį
	*
	*Tikrinama ar sistemoje neegistuoja studentas su tokiu pat studento pažymėjimo numeriu
	*@param String $studentNo Studento pažymėjimo numeris
	*@return Integer 1 - Egzistuoja studentas su tokiu numeriu, 0 - neegzistuoja
	*/
	public function checkExistenceStudentNo($studentNo)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$studentNo = trim($studentNo);
		$result= $db->query('select student_no from students where student_no=\''.$studentNo.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		} else {
			$db->disconnect();
			return 0;
		}
		
	}
	/**
	*Vartojo vardo egzistencijos tikrinimas
	*
	*Tikrinama ar sistemoje neegistuoja vartotojas su pasiūlytu vartotojo vardu
	*@param String $username vartotojo vardas
	*@return Integer 1 - Egzistuoja vartotojo vardas (studentas), 2 - Egzistuoja vartotojo vardas (įmonė), 3 - Egzistuoja vartotojo vardas (dėstytojas), 4 - Egzistuoja vartotojo vardas (administratorius), 0 - neegzistuoja
	*/
	public function checkExistenceUsername($username)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$username = trim($username);
		$result = $db->query('select username from students where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta students lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		}
		$result = $db->query('select username from companies where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 2;
		}
		
		$result = $db->query('select username from admins where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta admins lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 4;
		}

		$result = $db->query('select username from teachers where username=\''.$username.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta teachers lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 3;
		}
		$db->disconnect();
		return 0;
	}

}
/**

* Firmų registracijos valdymas duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class CompanyRegister extends StudentRegister 
{
	/**
	*Firmos pradinių duomenų sugeneravimas
	*
	*Surandami įmanomi duomenys pagal įmonės kodą.
	*@param String $companyCode Įmonės kodas
	*@return Array Įmonės duomenys, 0 - jei įmonė nerasta
	*/
	public function getComapyData($companyCode)
	{
		$companyCode = trim($companyCode);
		$address = @file_get_contents("http://www.kkg.lt/public.asp?cId=$companyCode&ref=FDX");
		preg_match("/<td>\s*(\d{9})\s*<\/td>\s*<td>\s*(.*)\s*[<\/td>]*\s*<td>\s*(.*)\s*<\/td>\s*<td>\s*(.*)\s*<\/td>\s*<td>\s*(.*)\s*<\/td>\s*<td>\s*(.*)\s*<\/td>/",$address,$info);
		if (!preg_match("/(.*?)\s*(\w*?)\s+(\w*)$/",$info[3],$chief)) {
			return 0;
		}
		$companyData = array($info[1],$info[2],$chief[1],$chief[2],$chief[3],$info[4],$info[5],$info[6]);
		return $companyData;
	}
	/**
	*Įmonės elektronio pašto adreso tikrinimas
	*
	*Tikrinama ar įmonės elektroninis paštas sudarytas pagal taisykles
	*@param String $companyEmail Įmonės elektroninio pašto adresas
	*@return Integer 1 - valid $companyEmail, 0 - Invalid
	*/
	public function checkCompanyEmail($companyEmail) 
	{
		$companyEmail = trim($companyEmail);
		if (preg_match("/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$/",$companyEmail)) {
			return 1;
		} else {
			return 0;
		}
	}
	/**
	*Įmonės telefono ar faxo tikrinimas
	*
	*Tikrinama ar telefono - faxo numeris sudarytas tinkamai
	*@param String $companyPhoneFax Įmonės telefono - faxo numeris
	*@return Integer 1 - valid $companyPhoneFax, 0 - Invalid
	*/
	public function checkCompanyPhoneFax($companyPhoneFax) 
	{
		$companyPhoneFax = trim($companyPhoneFax);
		if (preg_match("/^[+\d][\d]+[\d]$/",$companyPhoneFax)) {
			return 1;
		} else {
			return 0;
		}
	}
	/**
	*Įmonės kontaktinio asmens vardo tikrinimas
	*
	*Tikrinama ar įmonės kontaktinio asmens vardas sudarytas tik iš raidžių, neleidžiami kiti simboliai.
	*@param String $companyContactName  Įmonės kontaktinio asmens vardas
	*@return Integer 1 - valid $companyContactName, 0 - Invalid
	*/
	public function checkCompanyContactPersonName($companyContactName) 
	{
		$companyContactName = trim($companyContactName);
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ]/",$companyContactName) || strlen($companyContactName) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Įmonės kontaktinio asmens pavardės tikrinimas
	*
	*Tikrinama ar įmonės kontaktinio asmens pavardė sudaryta tik iš raidžių, neleidžiami kiti simboliai.
	*@param String $companyContactSurname Įmonės kontaktinio asmens pavardė
	*@return Integer 1 - valid $companyContactSurname, 0 - Invalid
	*/
	public function checkCompanyContactPersonSurname($companyContactSurname) 
	{
		$companyContactSurname = trim($companyContactSurname);
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ]/",$companyContactSurname) || strlen($companyContactSurname) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Įmonės vartotojo vardo tikrinimas
	*
	*Tikrinama ar įmonės vartotojo vardas netalpita tarpų simbolių.
	*@param String $companyUsername Įmonės vartotojo vardas
	*@return Integer 1 - valid $companyUsername, 0 - Invalid
	*/
	public function checkCompanyUsername($companyUsername) 
	{
		if (preg_match("/\s/",$companyUsername) || strlen($companyUsername) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Įmonės slaptažodžio tikrinimas
	*
	*Tikrinama ar įmonės slaptažodis netalpita tarpų simbolių.
	*@param String $companyPassword Įmonės slaptažodis
	*@return Integer 1 - valid $companyPassword, 0 - Invalid
	*/
	public function checkCompanyPassword($companyPassword) 
	{
		if (preg_match("/\s/",$companyPassword) || strlen($companyPassword) == 0) {
			return 0;
		} else {
			return 1;
		}
	}
	/**
	*Įmonės egzistencijos tikrinimas pagal įmonės kodą
	*
	*Tikrinama ar sistemoje neegistuoja įmonė su tokiu pat įmonės kodu
	*@param String $code Įmonės kodas
	*@return Integer 1 - Egzistuoja įmonė su tokiu kodu, 0 - neegzistuoja
	*/
	public function checkExistenceCompany($code)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$code = trim($code);
		$result= $db->query('select code from companies where code=\''.$code.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta companies lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		} else {
			$db->disconnect();
			return 0;
		}
		
	}
}

/**
* Dėstytojų registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class TeacherRegister extends StudentRegister 
{
}


/**
* Prisijungimo prie darbų portalo valdymas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class LoginManager extends StudentRegister
{
	/**
	*Vartojo vardo ir slaptažodžio tikrinimas
	*
	*Tikrinama ar sistemoje egzistuoja vartotojas, kuris nori prisijungti į sistemą
	*@param String $username vartotojo vardas
	*@param String $password slaptažodis
	*@return Integer 1 - Egzistuoja studentas, 2 - Egzistuoja įmonė, 3 - Egzistuoja dėstytojas, 4 - Egzistuoja administratorius, 0 - neegzistuoja
	*/
	public function checkLogin($username, $password)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$username = trim($username);
		$password = trim($password);
		$result = $db->query('select username from students where username=\''.$username.'\' and password=\''.$password.'\' and block<>\'t\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			return 0;
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		}
		$result = $db->query('select username from companies where username=\''.$username.'\' and password=\''.$password.'\' and block<>\'t\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			return 0;
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 2;
		}
		
		$result = $db->query('select username from admins where username=\''.$username.'\' and password=\''.$password.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			return 0;
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 4;
		}

		$result = $db->query('select username from teachers where username=\''.$username.'\' and password=\''.$password.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			return 0;
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 3;
		}
		$db->disconnect();
		return 0;
	}
}


/**
* Administratorių registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class AdminRegister extends StudentRegister 
{
}

/**
* Universitetų registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class UniversityRegister extends StudentRegister 
{
	/**
	*Universiteto pavadinimo tikrinimas
	*
	*Tikrinama ar universiteto vardas sudarytas =< 100 simbolių
	*@param String $universityName  Universiteto pavadinimas
	*@return Integer 1 - valid $universityName, 0 - Invalid
	*/
	public function checkUniversityName($universityName) 
	{
		$universityName = trim($universityName);
		if (strlen($universityName) == 0 || strlen($universityName) > 100) {
			return 0;
		} else {
			return 1;
		}
	}

	/**
	*Miesto pavadinimo tikrinimas
	*
	*Tikrinama ar miesto pavadinimas sudarytas =< 100 simbolių
	*@param String $cityName  Miesto pavadinimas
	*@return Integer 1 - valid $cityName, 0 - Invalid
	*/
	public function checkCityName($cityName) 
	{
		$cityName = trim($cityName);
		if (preg_match("/[^a-zA-ZąčęėįšųūžĄČĘĖĮŠŲŪŽ]/",$cityName) || strlen($cityName) == 0 || strlen($cityName) > 100) {
			return 0;
		} else {
			return 1;
		}
	}
	

	/**
	*Gatvės pavadinimo tikrinimas
	*
	*Tikrinama ar gatvės pavadinimas sudarytas =< 100 simbolių
	*@param String $streetName  Gatvės pavadinimas
	*@return Integer 1 - valid $streetName, 0 - Invalid
	*/
	public function checkStreetName($streetName) 
	{
		$streetName = trim($streetName);
		if (strlen($streetName) == 0 || strlen($streetName) > 100) {
			return 0;
		} else {
			return 1;
		}
	}
	
	/**
	*Gatvės numerio tikrinimas
	*
	*Tikrinama ar gatvės numeris sudarytas =< 40 simbolių
	*@param String $streetNumber  Gatvės numeris
	*@return Integer 1 - valid $streetNumber, 0 - Invalid
	*/
	public function checkStreetNumber($streetNumber) 
	{
		$streetNumber = trim($streetNumber);
		if (strlen($streetNumber) == 0 || strlen($streetNumber) > 40) {
			return 0;
		} else {
			return 1;
		}
	}
	
	/**
	*Gatvės kodo tikrinimas
	*
	*Tikrinama ar gatvės kodas sudarytas =< 20 simbolių
	*@param String $streetCode  Gatvės kodas
	*@return Integer 1 - valid $streetCode, 0 - Invalid
	*/
	public function checkStreetCode($streetCode) 
	{
		$streetCode = trim($streetCode);
		if (preg_match("/\s/",$streetCode) || strlen($streetCode) == 0 || strlen($streetCode) > 20) {
			return 0;
		} else {
			return 1;
		}
	}
	
	/**
	*Įmonės kodo tikrinimas
	*
	*Tikrinama ar įmonės kodas sudarytas =< 9 simbolių
	*@param String $companyCode  Įmonės kodas
	*@return Integer 1 - valid $companyCode, 0 - Invalid
	*/
	public function checkCompanyCode($companyCode) 
	{
		$companyCode = trim($companyCode);
		if (preg_match("/[^\w]/",$companyCode) || strlen($companyCode) == 0 || strlen($companyCode) > 9) {
			return 0;
		} else {
			return 1;
		}
	}
	
	/**
	*Internetinio adreso tikrinimas
	*
	*Tikrinama ar teisingas sudarytas įmonės internetinis adresas =< 200 simbolių
	*@param String $www  Internetinis adresas
	*@return Integer 1 - valid $www, 0 - Invalid
	*/
	public function checkWWW($www) 
	{
		$www = trim($www);
		if (preg_match("/\s]/",$www) || strlen($www) == 0 || strlen($www) > 200) {
			return 0;
		} else {
			return 1;
		}
	}

	/**
	*Tikrinama ar neegzistuoja sistemoje universitetas su tokiu pačiu pavadinimu.
	*
	*@param String $universityName Universiteto pavadinimas
	*@return Integer 1 - Egzistuoja universitetas su tokiu pavadinimu, 0 - neegzistuoja
	*/
	public function checkExistenceUniversityName($universityName)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$universityName = trim($universityName);
		$result= $db->query('select id from universities where name=\''.$universityName.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta universities lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		} else {
			$db->disconnect();
			return 0;
		}
		
	}

}

/**
* Fakultetų registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class FacultyRegister extends UniversityRegister
{
	/**
	*Tikrinama ar neegzistuoja sistemoje fakultetas su tokiu pačiu pavadinimu.
	*
	*@param String $facultyName Fakulteto pavadinimas
	*@return Integer 1 - Egzistuoja fakultetas su tokiu pavadinimu, 0 - neegzistuoja
	*/
	public function checkExistenceFacultyName($facultyName)
	{
		$connect = new Connect();
		$db = $connect->getConnect();
		$facultyName = trim($facultyName);
		$result= $db->query('select id from universities where name=\''.$facultyName.'\'');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Sugadinta faculties lentelė');
		}
		if ($result->numRows()) {
			$db->disconnect();
			return 1;
		} else {
			$db->disconnect();
			return 0;
		}
		
	}
}

/**
* Katedrų registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class DepartmentRegister extends FacultyRegister
{
}
/**
* Specialybių registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class SpecialityRegister extends DepartmentRegister
{
}

/**
* Modulių registracijos valdymas, duomenų generavimas, registracijos formų tikrinimas
*
* 
*@package UserManagement
*@copyright Copyright 2005, Mindaugas Rimkus
*/
class ModuleRegister extends SpecialityRegister
{
}

/*
$a = new CompanyRegister();
print_r($a->getComapyData('145578020      '));
*/
?> 