<?php
/**
*Pirkimo proceso valdymas
*
*Pirkimo proceso valdymas
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Pirkimo proceso valdymas
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class ShoppingCart
{
	/**
	*Prekės įdėjimas į krepšelį
	*@param Integer $itemType 1 - Padanga, 2 - Ratlankis, 3 - Motoroleris
	*@param Integer $itemID Prekės identifikacinis numeris
	*@param Integer $quantity Kiekis
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return void Prekės įdėjimas į krepšelį
	*/
	public function placeItemToShoppingCart($itemType,$itemID,$quantity,$customerID)
	{
		//echo "$itemType,$itemID,$quantity,$customerID";
		if ($itemType == 1) {
			//Apdorojam padangų įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(1,$itemID,$customerID);
			
			$quantity = $quantity + $alreadyInShoppingCart;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into tyre_cart (customer_id,tyre_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE tyre_cart set customer_id=$customerID,tyre_id=$itemID,quantity=$quantity where customer_id=$customerID and tyre_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
			
		}
		if ($itemType == 2) {
			//Apdorojam ratlankių įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(2,$itemID,$customerID);
			
			$quantity = $quantity + $alreadyInShoppingCart;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into wheel_cart (customer_id,wheel_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE wheel_cart set customer_id=$customerID,wheel_id=$itemID,quantity=$quantity where customer_id=$customerID and wheel_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
		}
		if ($itemType == 3) {
			//Apdorojam motorolerių įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(3,$itemID,$customerID);
			
			$quantity = $quantity + $alreadyInShoppingCart;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into motorbike_cart (customer_id,motorbike_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE motorbike_cart set customer_id=$customerID,motorbike_id=$itemID,quantity=$quantity where customer_id=$customerID and motorbike_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
		}
	}
	
	/**
	*Gražinamas prekių kiekis esantis krepšelyje
	*@param Integer $itemType 1 - Padanga, 2 - Ratlankis, 3 - Motoroleris
	*@param Integer $itemID Prekės identifikacinis numeris
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer prekės kiekis esantis krepšelyje
	*/
	public function getItemQuantityFromShoppingCart($itemType,$itemID,$customerID)
	{
		$quantity = null;
		if ($itemType == 1) {
			//Padangų kiekio paieška krepšelyje
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query('select quantity from tyre_cart where customer_id='.$customerID.' and tyre_id='.$itemID);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->getItemQuantityFromShoppingCart()');
			}
			$db->disconnect();
			$result->fetchInto($data);
			$quantity = $data[0];
		}
		if ($itemType == 2) {
			//Ratlankių kiekio paieška krepšelyje
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query('select quantity from wheel_cart where customer_id='.$customerID.' and wheel_id='.$itemID);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->getItemQuantityFromShoppingCart()');
			}
			$db->disconnect();
			$result->fetchInto($data);
			$quantity = $data[0];
		}
		if ($itemType == 3) {
			//Motorolerių kiekio paieška krepšelyje
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query('select quantity from motorbike_cart where customer_id='.$customerID.' and motorbike_id='.$itemID);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->getItemQuantityFromShoppingCart()');
			}
			$db->disconnect();
			$result->fetchInto($data);
			$quantity = $data[0];
		}
		return $quantity;
	}
	
	/**
	*Tikrinama ar skaičius teigiamas int
	*@param String $digit Parametras kuris tikrinamas ar yra int
	*@return Boolean true - is integer $digit, false - is not integer $digit
	*/
	public function isInteger($digit)
	{
		$digit = trim($digit);
		if (preg_match("/[^\d]/",$digit)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*Gražinama prekių pinigų suma esantys krepšelyje
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Decimal prekių pinigų suma esantys krepšelyje
	*/
	public function getShoppingCartTotal($customerID)
	{
		
		//Skaičiuojame kiek turime krepšelyje pinigų už padangas
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select sum(case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end)  from tyre,tyre_cart,customer where tyre.id=tyre_cart.tyre_id and customer.id=tyre_cart.customer_id and customer.id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$tyreTotal = $data[0];
		} else {
			$tyreTotal = 0;
		}
		
		//Skaičiuojame kiek turime krepšelyje pinigų už ratlankius
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select sum(case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end)  from wheel,wheel_cart,customer where wheel.id=wheel_cart.wheel_id and customer.id=wheel_cart.customer_id and customer.id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$wheelTotal = $data[0];
		} else {
			$wheelTotal = 0;
		}
		
		//Skaičiuojame kiek turime krepšelyje pinigų už motorolerius
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select sum(case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end)  from motorbike,motorbike_cart,customer where motorbike.id=motorbike_cart.motorbike_id and customer.id=motorbike_cart.customer_id and customer.id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$motorbikeTotal = $data[0];
		} else {
			$motorbikeTotal = 0;
		}
		
		$total = $tyreTotal + $wheelTotal + $motorbikeTotal;
		return $total;
	}
	
	/**
	*Gražinama skirtingų prekių kiekis esantis krepšelyje
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer skirtingų prekių kiekis esantis krepšelyje
	*/
	public function getShoppingCartItemTotal($customerID)
	{
		//Skaičiuojame kiek turime krepšelyje padangų
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select count(id) from tyre_cart where customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $result->getMessage();
			die('Kritinė klaida: ShoppingCart->getShoppingCartItemTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$tyreItemTotal = $data[0];
		} else {
			$tyreItemTotal = 0;
		}

		//Skaičiuojame kiek turime krepšelyje ratlankių
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select count(*) from wheel_cart where customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartItemTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$wheelItemTotal = $data[0];
		} else {
			$wheelItemTotal = 0;
		}
		
		//Skaičiuojame kiek turime krepšelyje motorolerių
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select count(*) from motorbike_cart where customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartItemTotal()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$motorbikeItemTotal = $data[0];
		} else {
			$motorbikeItemTotal = 0;
		}	
		
		$itemTotal = $tyreItemTotal + $wheelItemTotal + $motorbikeItemTotal;
		return $itemTotal;
	}
	
	/**
	*Gražinamos padangos esančios esantys krepšelyje
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Array padangos esančios esantys krepšelyje
	*/
	public function getShoppingCartTyre($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select tyre_cart.id, tyre.id, tyre_manufacturer.name,tyre_width,height,diameter,season,description_lt,description_en,description_ru,big_photo_path,small_photo_path,quantity, (case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end) as price ,case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt else (price_lt - price_lt*discount/100) end) else price_lt end  from tyre,tyre_cart,customer,tyre_manufacturer where tyre.id=tyre_cart.tyre_id and customer.id=tyre_cart.customer_id and tyre_manufacturer.id = tyre.tyre_manufacturer_id and customer.id='.$customerID.' order by price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartTyre()');
		}

		$tyre_cart = null;
		while ($result->fetchInto($row)) {
		    $tyre_cart[] = $row;
		}
		$db->disconnect();
		return $tyre_cart;
	}
	
	/**
	*Gražinamos ratlankiai esantys esantys krepšelyje
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Array ratlankiai esantys esantys krepšelyje
	*/
	public function getShoppingCartWheel($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select wheel_cart.id, wheel.id, wheel_manufacturer.name,diameter,0,color,\'\',\'\',\'\',big_photo_path,small_photo_path,quantity, (case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end) as price,case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt else (price_lt - price_lt*discount/100) end) else price_lt end,design  from wheel,wheel_cart,customer,wheel_manufacturer where wheel.id=wheel_cart.wheel_id and customer.id=wheel_cart.customer_id and wheel_manufacturer.id = wheel.wheel_manufacturer_id and customer.id='.$customerID.' order by price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartWheel()');
		}

		$wheel_cart = null;
		while ($result->fetchInto($row)) {
		    $wheel_cart[] = $row;
		}
		$db->disconnect();
		return $wheel_cart;
	}
	
	/**
	*Gražinamos motoroleriai esantys esantys krepšelyje
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Array motoroleriai esantys esantys krepšelyje
	*/
	public function getShoppingCartMotorbike($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select motorbike_cart.id, motorbike.id, motorbike_manufacturer.name,description_lt,description_en,description_ru,big_photo_path,small_photo_path,quantity, (case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt*quantity else (price_lt - price_lt*discount/100)*quantity end) else price_lt*quantity end) as price,case when discount_flag=true then (case when (price_lt - price_lt*discount/100)<min_price_lt then min_price_lt else (price_lt - price_lt*discount/100) end) else price_lt end  from motorbike,motorbike_cart,customer,motorbike_manufacturer where motorbike.id=motorbike_cart.motorbike_id and customer.id=motorbike_cart.customer_id and motorbike_manufacturer.id = motorbike.motorbike_manufacturer_id and customer.id='.$customerID.' order by price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getShoppingCartMotorbike()');
		}

		$motorbike_cart = null;
		while ($result->fetchInto($row)) {
		    $motorbike_cart[] = $row;
		}
		$db->disconnect();
		return $motorbike_cart;
	}
	
	/**
	*Prekės įdėjimas į krepšelį (tiksliai kiek nurodyta, senas kiekis ištrinamas (jei yra) ir įrašomas naujas)
	*@param Integer $itemType 1 - Padanga, 2 - Ratlankis, 3 - Motoroleris
	*@param Integer $itemID Prekės identifikacinis numeris
	*@param Integer $quantity Kiekis
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return void Prekės įdėjimas į krepšelį
	*/
	public function placeItemToShoppingCartExactly($itemType,$itemID,$quantity,$customerID)
	{
		//echo "$itemType,$itemID,$quantity,$customerID";
		if ($itemType == 1) {
			//Apdorojam padangų įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(1,$itemID,$customerID);
			$quantity = $quantity + 0;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into tyre_cart (customer_id,tyre_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE tyre_cart set customer_id=$customerID,tyre_id=$itemID,quantity=$quantity where customer_id=$customerID and tyre_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
			
		}
		if ($itemType == 2) {
			//Apdorojam ratlankių įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(2,$itemID,$customerID);
			
			$quantity = $quantity + 0;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into wheel_cart (customer_id,wheel_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE wheel_cart set customer_id=$customerID,wheel_id=$itemID,quantity=$quantity where customer_id=$customerID and wheel_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
		}
		if ($itemType == 3) {
			//Apdorojam motorolerių įdėjimą į krepšelį
			$alreadyInShoppingCart = $this->getItemQuantityFromShoppingCart(3,$itemID,$customerID);
			
			$quantity = $quantity + 0;
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			if (!isset($alreadyInShoppingCart)) {
				$result = $db->query("INSERT into motorbike_cart (customer_id,motorbike_id,quantity) values ($customerID,$itemID,$quantity)");
			} else {
				$result = $db->query("UPDATE motorbike_cart set customer_id=$customerID,motorbike_id=$itemID,quantity=$quantity where customer_id=$customerID and motorbike_id=$itemID");
			}
			
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->placeItemToShoppingCart()');
			}
			$db->disconnect();
		}
	}
	
	/**
	*Prekės vienoto pašalinimas iš krepšelio
	*@param Integer $itemType 1 - Padanga, 2 - Ratlankis, 3 - Motoroleris
	*@param Integer $cartID Vieneto įdėto į krepšelį identifikacinis numeris
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return void Prekės vienoto pašalinimas iš krepšelio
	*/
	public function deleteItemFromShoppingCart($itemType,$cartID,$customerID)
	{
		//echo "$itemType,$itemID,$quantity,$customerID";
		if ($itemType == 1) {
			//Apdorojam padangų pašalinimas iš krepšelio
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query("delete from tyre_cart where id=$cartID and customer_id=$customerID");		
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->deleteItemFromShoppingCart()');
			}
			$db->disconnect();
		}
		if ($itemType == 2) {
			//Apdorojam ratlankių pašalinimą iš krepšelio
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query("delete from wheel_cart where id=$cartID and customer_id=$customerID");		
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->deleteItemFromShoppingCart()');
			}
			$db->disconnect();
		}
		if ($itemType == 3) {
			//Apdorojam motorolerių pašalinimą iš krepšelio

			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result = $db->query("delete from motorbike_cart where id=$cartID and customer_id=$customerID");		
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->deleteItemFromShoppingCart()');
			}
			$db->disconnect();
		}
	}
	
	
	/**
	*Prekės užsakymas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Array $tyreData - Krepšelyje esantys padangų duomenys
	*@param Array $wheelData - Krepšelyje esantys ratlankių duomenys
	*@param Array $motorbikeData - Krepšelyje esantys motorolerių duomenys
	*@param TEXT $other Papildoma užsakymo informacija
	*@param Integer $store_id Parduotuvės identifikacinis numeris (jei null, pristatymas už papildoma mokestį)
	*@param Integer $shoppingInStore - Apmokėjimas 1 - grynais 2 - Sumokėjimas per banką (null, jei pristatymas už papildomą mokestį)
	*@param String $shipmentAddress Pristatymo adresas (null, jei atsiėmimas prekių parduotuvėje)
	*@param Integer $shipmentPrice Pristatymo kaina
	*@return void Prekės užsakymas
	*/
	public function orderGoods($customerID,$tyreData,$wheelData,$motorbikeData,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice)
	{
		//echo '$customerID,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice'."$customerID,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice";
		$this->createNewOrder($customerID,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice);
		$orderNo = $this->getLastOrderNo($customerID);

		$error = 0;

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		//Padangos iš krepšelio perkeliamos į užsakymus
		for ($i=0; $i < count($tyreData); $i++) {
			$result = $db->query("INSERT INTO order_item_tyre (order_id,tyre_id,quantity,price) values ($orderNo,{$tyreData[$i][1]},{$tyreData[$i][12]},{$tyreData[$i][13]})");		
			if (PEAR::isError($result)) {
				$error++;
			}
		}
		
		//Ratlankiai iš krepšelio perkeliami į užsakymus
		for ($i=0; $i < count($wheelData); $i++) {
			$result = $db->query("INSERT INTO order_item_wheel (order_id,wheel_id,quantity,price) values ($orderNo,{$wheelData[$i][1]},{$wheelData[$i][11]},{$wheelData[$i][12]})");		
			if (PEAR::isError($result)) {
				$error++;
			}
		}	
		
		//Motoroleriai iš krepšelio perkeliami į užsakymus
		for ($i=0; $i < count($motorbikeData); $i++) {
			$result = $db->query("INSERT INTO order_item_motorbike (order_id,motorbike_id,quantity,price) values ($orderNo,{$motorbikeData[$i][1]},{$motorbikeData[$i][8]},{$motorbikeData[$i][9]})");		
			if (PEAR::isError($result)) {
				$error++;
			}
		}	
			
		//Klaidos ateju pašaliname pakeitimus
		if ($error != 0) {
			$db->query("delete from orders where customer_id=$customerID and id=$orderNo");		
		} else {
			//Ištrinama informacija iš krepšelių
			$db->query("delete from tyre_cart where customer_id=$customerID");
			$db->query("delete from wheel_cart where customer_id=$customerID");
			$db->query("delete from motorbike_cart where customer_id=$customerID");
		}
		$db->disconnect();
	}
	
	/**
	*Sukuriamas naujas užsakymas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param TEXT $other papildoma užsakymo informacija
	*@param Integer $store_id Parduotuvės identifikacinis numeris (jei null, pristatymas už papildoma mokestį)
	*@param Integer $shoppingInStore - Apmokėjimas 1 - grynais 2 - Sumokėjimas per banką (null, jei pristatymas už papildomą mokestį)
	*@param String $shipmentAddress Pristatymo adresas (null, jei atsiėmimas prekių parduotuvėje)
	*@param Integer $shipmentPrice Pristatymo kaina
	*@return void Sukuriamas naujas užsakymas
	*/
	public function createNewOrder($customerID,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice)
	{

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		
		$query = $db->prepare('INSERT into orders (customer_id,other,store_id,payment_type,shipment_address,shipment_price) values (?,?,?,?,?,?)');
		$data = array($customerID,$other,$store_id,$shoppingInStore,$shipmentAddress,$shipmentPrice);
		$query_res = $db->execute($query, $data);
		
		
		
		if (PEAR::isError($query_res)) {
			//echo $query_res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->createNewOrder()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Gražinamas paskutinis kliento užsakymas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Integer 0 ir daugiau - Kliento paskutinio užsakymo numeris
	*/
	public function getLastOrderNo($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select max(id) from orders where customer_id='.$customerID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getLastOrderNo()');
		}
		$db->disconnect();
		$result->fetchInto($data);
		return $data[0];
	}
	
	/**
	*
	*Gražinami kliento atlikti užsakymai
	*@param Integer $customerID Kliento identifikacinis numeris
	*@return Array Užsakymai
	*/
	public function getCustomerOrders($customerID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select id,order_time, process_flag,store_id,payment_type,shipment_address,shipment_price from orders where customer_id='.$customerID.' order by order_time desc');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getCustomerOrders()');
		}
		
		$orders = null;
		while ($result->fetchInto($row)) {
		    $orders[] = $row;
		}
		$db->disconnect();
		return $orders;
	}
	
	/**
	*
	*Gražinamas kliento užsakymo laikas ir parametrai
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return Array kliento užsakymo laikas ir parametrai
	*/
	public function getCustomerOrder($customerID,$orderID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select id,order_time, process_flag,other,store_id,payment_type,shipment_address,shipment_price from orders where customer_id='.$customerID.' and id='.$orderID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getCustomerOrder()');
		}
		$result->fetchInto($row);
		$db->disconnect();
		return  $row;
	}
	
	/**
	*
	*Gražinamas parduotuvės adresas
	*@param Integer $storeID parduotuvės adresas
	*@return Array parduotuvės adresas
	*/
	public function getStoreAddress($storeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select id,address from store where id='.$storeID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getStoreAddress()');
		}
		$result->fetchInto($row);
		$db->disconnect();
		return  $row;
	}
	
	
	/**
	*Gražinamos padangos esančios konkrečiame užsakyme
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return Array padangos esančios konkrečiame užsakyme
	*/
	public function getCustomerOrderTyre($customerID,$orderID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select order_item_tyre.id, tyre.id, tyre_manufacturer.name,tyre_width,height,diameter,season,description_lt,description_en,description_ru,big_photo_path,small_photo_path,order_item_tyre.quantity, order_item_tyre.price from tyre,tyre_manufacturer,order_item_tyre,orders where tyre.id=order_item_tyre.tyre_id and tyre_manufacturer.id=tyre.tyre_manufacturer_id and orders.id=order_item_tyre.order_id and orders.customer_id='.$customerID.' and orders.id='.$orderID.' order by order_item_tyre.price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getCustomerOrderTyre()');
		}

		$tyre_order = null;
		while ($result->fetchInto($row)) {
		    $tyre_order[] = $row;
		}
		$db->disconnect();
		return $tyre_order;
	}
	
	/**
	*Gražinami ratlankiai esantys konkrečiame užsakyme
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return Array ratlankiai esantys konkrečiame užsakyme
	*/
	public function getCustomerOrderWheel($customerID,$orderID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select order_item_wheel.id, wheel.id, wheel_manufacturer.name,diameter,0,color,\'\',\'\',\'\',big_photo_path,small_photo_path,order_item_wheel.quantity, order_item_wheel.price from wheel,wheel_manufacturer,order_item_wheel,orders where wheel.id=order_item_wheel.wheel_id and wheel_manufacturer.id=wheel.wheel_manufacturer_id and orders.id=order_item_wheel.order_id and orders.customer_id='.$customerID.' and orders.id='.$orderID.' order by order_item_wheel.price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getCustomerOrderWheel()');
		}

		$wheel_order = null;
		while ($result->fetchInto($row)) {
		    $wheel_order[] = $row;
		}
		$db->disconnect();
		return $wheel_order;
	}
	
	/**
	*Gražinami motoroleriai esantys konkrečiame užsakyme
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return Array motoroleriai esantys konkrečiame užsakyme
	*/
	public function getCustomerOrderMotorbike($customerID,$orderID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select order_item_motorbike.id, motorbike.id, motorbike_manufacturer.name,description_lt,description_en,description_ru,big_photo_path,small_photo_path,order_item_motorbike.quantity, order_item_motorbike.price from motorbike,motorbike_manufacturer,order_item_motorbike,orders where motorbike.id=order_item_motorbike.motorbike_id and motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and orders.id=order_item_motorbike.order_id and orders.customer_id='.$customerID.' and orders.id='.$orderID.' order by order_item_motorbike.price asc');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getCustomerOrderMotorbike()');
		}

		$motorbike_order = null;
		while ($result->fetchInto($row)) {
		    $motorbike_order[] = $row;
		}
		$db->disconnect();
		return $motorbike_order;
	}
	
	/**
	*
	*Gražinama užsakymo kaina
	*@param Integer $order Užsakymo numeris
	*@return decimal 0 ir daugiau - užsakymo kaina
	*/
	public function getOrderPrice($order)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		//Padangų kaina
		$result= $db->query('select sum(price) from order_item_tyre where order_id='.$order);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getOrderPrice()');
		}
		$result->fetchInto($data);
		$tyrePrice = $data[0];
		
		//Ratlankių kaina
		$result= $db->query('select sum(price) from order_item_wheel where order_id='.$order);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getOrderPrice()');
		}
		$result->fetchInto($data);
		$wheelPrice = $data[0];
		
		//Motorolerių kaina
		$result= $db->query('select sum(price) from order_item_motorbike where order_id='.$order);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getOrderPrice()');
		}
		$result->fetchInto($data);
		$motorbikePrice = $data[0];
		
		$db->disconnect();
		
		return $tyrePrice+$wheelPrice+$motorbikePrice;
	}
	
	/**
	*
	*Ištrinamas kliento užsakymas, jei jis yra Nepatvirtintas arba atmestas
	*@param Integer $customerID Kliento identifikacinis numeris
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return void
	*/
	public function removeCustomerOrder($customerID,$orderID)
	{
		$customerOrder = $this->getCustomerOrder($customerID,$orderID);
		if ($customerOrder[2] == 1 || $customerOrder[2] == 3) {
			$connect = new ConnectManager();
			$db = $connect->getConnect();
			$result= $db->query('delete from orders where customer_id='.$customerID.' and id='.$orderID);
			if (PEAR::isError($result)) {
				$db->disconnect();
				die('Kritinė klaida: ShoppingCart->removeCustomerOrder()');
			}
			$db->disconnect();
		}
	}
	
	/**
	*
	*Ištrinamas užsakymas
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return void
	*/
	public function removeOrder($orderID)
	{

		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from orders where id='.$orderID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->removeOrder()');
		}
		$db->disconnect();
	}
	
	/**
	*Gražinamas užsakymų kiekis pagal paieškos sąlygas
	*@param Date $dateFrom Nuo šios datos rodomi užsakymai
	*@param Date $dateTo Iki šios datos rodomi užsakymai
	*@param Integer $flag Užsakymo statusas
	*@param String $customer Įvesta kliento paieška
	*@return Array padangų kiekis pagal paieškos sąlygas
	*/

	public function getOrdersCount($dateFrom,$dateTo,$flag,$customer)
	{
		//echo "$dateFrom,$dateTo,$flag,$customer";
		if (strlen($dateFrom) < 10) {
			$dateFrom = null;
		}

		if (strlen($dateTo) < 10) {
			$dateTo = null;
		}
		
		if ($flag+0 == 0) {
			$flag = '%';
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($dateFrom == null) {
			//Be pradzios
			$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id and order_time<=\''.$dateTo.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' ');
		}
		if ($dateTo == null) {
			//Be pabaigos
			$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id and order_time>=\''.$dateFrom.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' ');
		}
		if ($dateFrom == null && $dateTo == null) {
			//Be pradzios ir pabaigos
			$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' ');
		}
		
		if ($dateFrom != null && $dateTo != null) {
			//Su pradzia ir pabaiga
			$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id and order_time>=\''.$dateFrom.'\' and order_time<=\''.$dateTo.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' ');
		}
//		$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id ');
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $result->getDebugInfo();
			die('Kritinė klaida: ShoppingCart->getOrdersCount()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
		
	}
	
	
	/**
	*Gražinamas užsakymų duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš orders lentelės pagal pateiktas paieškos sąlygas
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Date $dateFrom Nuo šios datos rodomi užsakymai
	*@param Date $dateTo Iki šios datos rodomi užsakymai
	*@param Integer $flag Užsakymo statusas
	*@param String $customer Įvesta kliento paieška
	*@return Array padangų kiekis pagal paieškos sąlygas
	*/

	public function getOrders($offset,$limit,$dateFrom,$dateTo,$flag,$customer)
	{
		//echo "$offset,$limit,$dateFrom,$dateTo,$flag,$customer";
		if (strlen($dateFrom) < 10) {
			$dateFrom = null;
		}

		if (strlen($dateTo) < 10) {
			$dateTo = null;
		}
		
		if ($flag+0 == 0) {
			$flag = '%';
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($dateFrom == null) {
			//Be pradzios
			$result = $db->query('select customer.name,customer.surname,customer.company_name,orders.id,orders.order_time,orders.other,orders.process_flag,customer.id,store_id,payment_type,shipment_address,shipment_price  from orders,customer where orders.customer_id=customer.id and order_time<=\''.$dateTo.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' order by order_time desc limit '.$limit.' offset '.$offset);
		}
		if ($dateTo == null) {
			//Be pabaigos
			$result = $db->query('select customer.name,customer.surname,customer.company_name,orders.id,orders.order_time,orders.other,orders.process_flag,customer.id,store_id,payment_type,shipment_address,shipment_price from orders,customer where orders.customer_id=customer.id and order_time>=\''.$dateFrom.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' order by order_time desc limit '.$limit.' offset '.$offset);
		}
		if ($dateFrom == null && $dateTo == null) {
			//Be pradzios ir pabaigos
			$result = $db->query('select customer.name,customer.surname,customer.company_name,orders.id,orders.order_time,orders.other,orders.process_flag,customer.id,store_id,payment_type,shipment_address,shipment_price from orders,customer where orders.customer_id=customer.id and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' order by order_time desc limit '.$limit.' offset '.$offset);
		}
		
		if ($dateFrom != null && $dateTo != null) {
			//Su pradzia ir pabaiga
			$result = $db->query('select customer.name,customer.surname,customer.company_name,orders.id,orders.order_time,orders.other,orders.process_flag,customer.id,store_id,payment_type,shipment_address,shipment_price from orders,customer where orders.customer_id=customer.id and order_time>=\''.$dateFrom.'\' and order_time<=\''.$dateTo.'\' and trim(to_char(process_flag,\'999999999999\')) like \''.$flag.'\' and coalesce(name,\'\')||\' \'||coalesce(surname,\'\')||\' \'||coalesce(company_name,\'\') like \'%'.$customer.'%\' order by order_time desc limit '.$limit.' offset '.$offset);
		}
//		$result = $db->query('select count(orders.id) from orders,customer where orders.customer_id=customer.id ');
		if (PEAR::isError($result)) {
			$db->disconnect();
			//echo $result->getDebugInfo();
			die('Kritinė klaida: ShoppingCart->getOrders()');
		}
		$db->disconnect();
		$data = null;
		while ($result->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Pakeičiamas užsakymo įvykdymo statusas
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@param Integer $process_flag Užsakymo statusas
	*/
	public function updateOrderProcessFlag($orderID,$process_flag)
	{
		//echo '$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password ->'."$customerID,$name,$surname,$identity_code,$address,$phone,$email,$company_name,$code,$fax,$password";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update orders set process_flag=? where id=?');
		$data = array($process_flag,$orderID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: ShoppingCart->updateOrderProcessFlag()');
		}
		$db->disconnect();
	}
	
	
	/**
	*Gražinamas visų parduotuvių masyvas
	*@return Array visų parduotuvių masyvas
	*/
	public function getAllStores()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result = $db->query('select id, address from store');
		if (PEAR::isError($result)) {
			//echo $result->getMessage();
			$db->disconnect();
			die('Kritinė klaida: ShoppingCart->getAllStores()');
		}

		$stores = null;
		while ($result->fetchInto($row)) {
		    $stores[] = $row;
		}
		$db->disconnect();
		return $stores;
	}
	
}

/*
$a = new CompaniesInterface();
print_r($a->getPracticeJobStudent(2));
*/
?>
