<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**

*Motorolerių informacijos valdymo klasė
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Motorbike
{

	/**
	*
	*Gražinamas motorolerių likutis
	*@param Integer $motorbikeID Motorolerio identifikacinis numeris
	*@return Integer 0 ir daugiau - motorolerių likutis
	*/
	public function getMotorbikeBalance($motorbikeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select balance from motorbike where id='.$motorbikeID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbikeBalance()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	

	/**
	*Gražinamas visų skirtingų motorolerių gamintojų pavadinimų masyvas
	*@return Array visų skirtingų motorolerių gamintojų pavadinimų masyvas
	*/

	public function getMotorbikeManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from motorbike_manufacturer where id = any(select distinct motorbike_manufacturer_id from motorbike where is_deleted=false order by motorbike_manufacturer_id) order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbikeManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų motorolerių gamintojų pavadinimų masyvas
	*@return Array visų motorolerių gamintojų pavadinimų masyvas
	*/

	public function getAllMotorbikeManufacturers()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,name from motorbike_manufacturer order by name asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getAllMotorbikeManufacturers()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų motorolerių duomenų masyvas
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš motorbike lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo identifikacinis numeris
	*@param numeric(7,2) $max_price motorolerio kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array visų motorolerių duomenų masyvas
	*/

	public function getMotorbikes($offset,$limit,$motorbike_manufacturer_id,$max_price,$user_discount)
	{
		//echo $max_price;
		if ($motorbike_manufacturer_id+0 == 0) {
			$motorbike_manufacturer_id = '%';
		}

		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select motorbike.id, motorbike_manufacturer_id, name, price_lt,min_price_lt, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price, price_in_store from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' order by price limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbike()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų akcijinių motorolerių duomenų masyvas
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo identifikacinis numeris
	*@param numeric(7,2) $max_price motorolerio kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return Array visų akcijinių motorolerių duomenų masyvas
	*/

	public function getMotorbikesSales($motorbike_manufacturer_id,$max_price,$user_discount)
	{
		//echo $max_price;
		if ($motorbike_manufacturer_id+0 == 0) {
			$motorbike_manufacturer_id = '%';
		}

		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select motorbike.id, motorbike_manufacturer_id, name, price_lt,min_price_lt, description_lt, description_en, description_ru, small_photo_path, discount_flag, status,balance, (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) as price,price_in_store from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and status=2 order by price');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbike()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas motorolerių kiekis
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš motorbike lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo identifikacinis numeris
	*@param numeric(7,2) $max_price motorolerio kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return integer motorolerių kiekis
	*/

	public function getMotorbikeCount($offset,$limit,$motorbike_manufacturer_id,$max_price,$user_discount)
	{
		//echo $this->getTopPrice();
		if ($motorbike_manufacturer_id+0 == 0) {
			$motorbike_manufacturer_id = '%';
		}

		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		
		//echo 'select (motorbike.id) from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' order by price limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(motorbike.id) from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' limit '.$limit.' offset '.$offset);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbikeCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$res->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas akcijinių motorolerių kiekis
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš motorbike lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo identifikacinis numeris
	*@param numeric(7,2) $max_price motorolerio kaina
	*@param Integer $user_discount Vartotojui taikoma nuolaida
	*@return integer akcijinių motorolerių kiekis
	*/

	public function getMotorbikeCountSales($motorbike_manufacturer_id,$max_price,$user_discount)
	{
		//echo $this->getTopPrice();
		if ($motorbike_manufacturer_id+0 == 0) {
			$motorbike_manufacturer_id = '%';
		}

		if ($max_price+0 == 0) {
			$max_price = $this->getTopPrice();
		}	
		
		if ($user_discount+0 == 0) {
			$user_discount = 0;
		}		
		
		//echo 'select (motorbike.id) from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' order by price limit '.$limit.' offset '.$offset;
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select count(motorbike.id) from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.is_deleted=false and trim(to_char(motorbike_manufacturer_id,\'999999999999\')) like \''.$motorbike_manufacturer_id.'\' and (case when discount_flag=true then (case when  price_lt-price_lt*'.$user_discount.'/100 < min_price_lt then min_price_lt else price_lt-price_lt*'.$user_discount.'/100 end) else price_lt end ) <= '.$max_price.' and status=2');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbikeCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$res->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	
	/**
	*
	*
	*Gražinama maksimali prekės kaina
	*@return Integer 0 ir daugiau - maksimali prekės kaina
	*/
	public function getTopPrice()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('select max(price_lt) from motorbike where is_deleted=false');
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getTopPrice()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0]+0;
		} else {
			return 0;
		}
	}
	
	/**
	*Gražinamas pasirinkto motorolerio duomenų masyvas
	*@param Integer $motorbikeID Motorolerio identifikacinis numeris
	*@return Array motorolerio duomenų masyvas
	*/

	public function getMotorbike($motorbikeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res =  $db->query('select motorbike.id, motorbike_manufacturer_id, name, balance, price_lt,min_price_lt, description_lt, description_en, description_ru, big_photo_path, discount_flag, status, price_in_store,small_photo_path from motorbike,motorbike_manufacturer where motorbike_manufacturer.id=motorbike.motorbike_manufacturer_id and motorbike.id='.$motorbikeID);
		if (PEAR::isError($res)) {
			//echo $res->getMessage();
			$db->disconnect();
			die('Kritinė klaida: Motorbike->getMotorbike()');
		}
		$res->fetchInto($selectedMotorbike);
		$db->disconnect();
		return $selectedMotorbike;
	}
	
	
	/**
	*Motorolerio pašalinimas
	*
	*@param Integer $motorbikeID Motorolerio identifikacinis numeris
	*@return void
	*/
	public function removeMotorbike($motorbikeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from motorbike where id='.$motorbikeID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: Motorbike->removeMotorbike()');
		}
		$db->disconnect();
	}	

	/**
	*
	*Skaičiaus tikrinimas
	*@param String $digit Skaičius
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function isDigit($digit)
	{
		$digit = trim($digit);
		if (strlen($digit) == 0) return false; 
		
		if (preg_match("/[^\d]/",$digit)) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	*
	*
	*Skaičiaus po kablelio tikrinimas
	*@param String $digit Skaičius su kableliu
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkDigit($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/^[\d]+\.?[\d]*$/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Atnaujinami motorolerio duomenys
	*@param Integer $id motorolerio identifikacinis numeris
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo ID
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali motorolerio kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $description_lt Aprašymas LT
	*@param String $description_en Aprašymas EN
	*@param String $description_ru Aprašymas RU
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Integer $status Statusas
	*/
	public function updateMotorbike($id,$motorbike_manufacturer_id,$balance,$price_lt,$min_price_lt,$price_in_store,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status)
	{
		//echo "$id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update motorbike set motorbike_manufacturer_id=?,balance=?,price_lt=?,min_price_lt=?,price_in_store=?,description_lt=?,description_en=?,description_ru=?,big_photo_path=?,small_photo_path=?,discount_flag=?,status=? where id=?');
		$data = array($motorbike_manufacturer_id,$balance,$price_lt,$min_price_lt,$price_in_store,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status,$id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getDebugInfo();
			die('Kritinė klaida: Motorbike->updateMotorbike()');
		}
		$db->disconnect();
	}
	
	/**
	*Įterpiami motorolerio duomenys
	*@param Integer $motorbike_manufacturer_id Motorolerio gamintojo ID
	*@param Integer $balance Likutis
	*@param numeric(7,2) $price_lt Kaina litais
	*@param numeric(7,2) $min_price_lt Minimali motorolerio kaina
	*@param numeric(7,2) $price_in_store Kaina parduotuvėje
	*@param String $description_lt Aprašymas LT
	*@param String $description_en Aprašymas EN
	*@param String $description_ru Aprašymas RU
	*@param String $big_photo_path Kelias iki didelės nuotraukos
	*@param String $small_photo_path Kelias iki mažos nuotraukos
	*@param Boolean $discount_flag Nuolaidos flagas
	*@param Integer $status Statusas
	*/
	public function insertMotorbike($motorbike_manufacturer_id,$balance,$price_lt,$min_price_lt,$price_in_store,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status)
	{
		//echo "$id,$tyre_manufacturer_id,$tyre_width,$height,$diameter,$season,$load_index,$speed_index,$balance,$price_lt,$min_price_lt,$price_in_store,$weave,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into motorbike (motorbike_manufacturer_id,balance,price_lt,min_price_lt,price_in_store,description_lt,description_en,description_ru,big_photo_path,small_photo_path,discount_flag,status) values (?,?,?,?,?,?,?,?,?,?,?,?)');
		$data = array($motorbike_manufacturer_id,$balance,$price_lt,$min_price_lt,$price_in_store,$description_lt,$description_en,$description_ru,$big_photo_path,$small_photo_path,$discount_flag,$status);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getDebugInfo();
			die('Kritinė klaida: Motorbike->insertMotorbike()');
		}
		$db->disconnect();
	}
}
?>