<?php
/**
*Straipsnių valdymas
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Straipsnių valdymas
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class Article
{
	/**
	*Gražinamas masyve pasirinktas straipsnis Lietuvių, Anglų ir Rusų kalbomis
	*@param Integer $articleID Straipsnio identifikacinis numeris
	*@return Array Straipsnio masyvas Lietuvių, Anglų, Rusų kalbomis
	*/
	public function getArticle($articleID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select article_text_lt, article_text_en, article_text_ru, article_time from article where id='.$articleID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: Article->getArticle()');
		}
		$res->fetchInto($article);
		$db->disconnect();
		return $article;
	}
	
	/**
	*Atnaujinami Straipsnio duomenys
	*@param Integer $articleID Straipsnio identifikacinis numeris
	*@param String $article_text_lt Straipsnio tekstas lietuviškai
	*@param String $article_text_en Straipsnio tekstas angliškai
	*@param String $article_text_ru Straipsnio tekstas rusiškai
	*@param time $article_time Straipsnio atnaujinimo laikas
	*/
	public function updateArticle($articleID,$article_text_lt,$article_text_en,$article_text_ru)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update article set article_text_lt=?,article_text_en=?,article_text_ru=?, article_time=(select CURRENT_TIMESTAMP) where id=?');
		$data = array($article_text_lt,$article_text_en,$article_text_ru,$articleID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: Article->updateArticle()');
		}
		$db->disconnect();
	}
	
}

/*
$a = new CompaniesInterface();
print_r($a->getPracticeJobStudent(2));
*/
?>
