<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');



/**

* Sisteminė klasė
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class System
{

	
	/**
	*
	*Gražinamas pasirinkto tinklo sisteminiai parametrai
	*@param Integer $networkID Tinklo identifikacinis numeris
	*@return Array tinklo parametrai
	*/
	public function getSystemParameter($networkID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result = $db->query('select id,network_id,ok_from,ok_to,ok_counter,ok_off,bad_from,bad_to,bad_counter,bad_off from system where network_id='.$networkID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('System->getSystemParameter() -> '.$result->getDebugInfo());
			die('Kritinė klaida: System->getSystemParameter()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data;
		} else {
			return null;
		}
	}
	
	/**
	*
	*Nustatomas ok_counter parametras
	*@param Integer $network_id GSM Tinklo identifikacinis numeris
	*@param Integer $ok_from random begin
	*@param Integer $ok_to random end
	*@return void
	*/
	public function setOKCounter($network_id,$ok_from,$ok_to)
	{
		srand(time());
		$random = (rand($ok_from,$ok_to));
		

		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update system set ok_counter=? where network_id=?');
		$data = array($random,$network_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('System->setOKCounter() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: System->setOKCounter()');
		}
		$db->disconnect();
		
	}
	

	/**
	*
	*Nustatomas bad_counter parametras
	*@param Integer $network_id GSM Tinklo identifikacinis numeris
	*@param Integer $bad_from random begin
	*@param Integer $bad_to random end
	*@return void
	*/
	public function setBADCounter($network_id,$bad_from,$bad_to)
	{
		srand(time());
		$random = (rand($bad_from,$bad_to));
		

		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update system set bad_counter=? where network_id=?');
		$data = array($random,$network_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('System->setBADCounter() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: System->setBADCounter()');
		}
		$db->disconnect();
		
	}
	
	

	
	/**
	*
	*Sumažinamas ok_counter parametras --1
	*@param Integer $network_id GSM Tinklo identifikacinis numeris
	*@param Integer $ok_counter OK counteris
	*@return void
	*/
	public function decreaseOKCounter($network_id,$ok_counter)
	{
		
		$ok_counter--;	

		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update system set ok_counter=? where network_id=?');
		$data = array($ok_counter,$network_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('System->setOKCounter() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: System->setOKCounter()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Sumažinamas bad_counter parametras --1
	*@param Integer $network_id GSM Tinklo identifikacinis numeris
	*@param Integer $bad_counter BAD counteris
	*@return void
	*/
	public function decreaseBADCounter($network_id,$bad_counter)
	{
		
		$bad_counter--;	

		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update system set bad_counter=? where network_id=?');
		$data = array($bad_counter,$network_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('System->decreaseBADCounter() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: System->decreaseBADCounter()');
		}
		$db->disconnect();
	}
	

	
	/**
	*
	*Gražinamas SYSTEM orginating number
	*@param Integer $networkID Tinklo identifikacinis numeris
	*@return String SYSTEM number
	*/
	public function getSystemOrginatingNumber($networkID)
	{
		srand(time());
		$days = (rand(1,30));
		
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result = $db->query('select senderphone from received_messages where received_time<now()-interval \''.$days.' day\' and network_id='.$networkID.' order by received_time desc limit 1');
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('System->getSystemOrginatingNumber() -> '.$result->getDebugInfo());
			die('Kritinė klaida: System->getSystemOrginatingNumber()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$number = $data[0];
			$newNumber = substr($number,0,9).$number[11].$number[10].$number[9];
			return $newNumber;
		} else {
			return null;
		}
	}
	
	/**
	*
	*Gražinamas SYSTEM code
	*@param Integer $networkID Tinklo identifikacinis numeris
	*@param Integer $param 1 - ok; 2 - bad;
	*@return String SYSTEM code
	*/
	public function getSystemCode($networkID,$param)
	{
		$systemCode = null;
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result = $db->query('select system_code from system where network_id='.$networkID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('System->getSystemCode() -> '.$result->getDebugInfo());
			die('Kritinė klaida: System->getSystemCode()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			$systemCode = $data[0];
		} else {
			return null;
		}
		

		
		$digit = 0;
		if ($networkID == 1) {
			if ($param == 1) {
				srand(time());
				//$digit = (rand(100000,150000));
				$digit = (rand(10,15));					
			}
			if ($param == 2) {
				srand(time());
				//$digit = (rand(150000,200000));
				$digit = (rand(15,20));					
			}

		}
		if ($networkID == 2) {
			if ($param == 1) {
				srand(time());
				//$digit = (rand(200000,250000));
				$digit = (rand(20,25));					
			}
			if ($param == 2) {
				srand(time());
				//$digit = (rand(250000,300000));
				$digit = (rand(25,30));					
			}
		}
		if ($networkID == 3) {
			if ($param == 1) {
				srand(time());
				//$digit = (rand(300000,350000));				
				$digit = (rand(30,35));
			}
			if ($param == 2) {
				srand(time());
				//$digit = (rand(350000,400000));				
				$digit = (rand(35,40));
			}
		}
		srand(time());
		$random = (rand(1,3));
		
		if ($random == 1) {
			return strtolower($systemCode)." ".$digit;
		}
		if ($random == 2) {
			$systemCodeFirst = $systemCode[0];
			return $systemCodeFirst."".strtolower(substr($systemCode,1,strlen($systemCode)-1))." ".$digit;
		}
		
		if ($random == 3) {
			return $systemCode." ".$digit;
		}
		
	}
	
	
	/**
	*
	*Uždedamas gautai žinutei SYSTEM flagas
	*@param Integer $received_message_id gautos žinutės identifikacinis numeris
	*@return void
	*/
	public function setSystemFlag($received_message_id)
	{

		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update received_messages set system=? where id=?');
		$data = array(true,$received_message_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('System->setSystemFlag() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: System->setSystemFlag()');
		}
		$db->disconnect();
		
	}
	

		
	
	/**
	*
	*Gražinamas SYSTEM parametras
	*@param Integer $received_message_id
	*@return String SYSTEM parametras
	*/
	public function getSystemPar($received_message_id)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result = $db->query('select system from received_messages where id='.$received_message_id);
		if (PEAR::isError($result)) {
			$db->disconnect();
			$log->logError('System->getSystemPar() -> '.$result->getDebugInfo());
			die('Kritinė klaida: System->getSystemPar()');
		}
		
		$db->disconnect();
		if ($result->numRows()) {
			$result->fetchInto($data);
			return $data[0];
		} else {
			return null;
		}
	}
	
	

}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>