<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');

/**
* Prijungiama HTTP/Client.php PEAR klasių rinkinio HTTP request'ų valdymo klasė
*/
require_once 'HTTP/Client.php';

/**
* Prijungiama lib/nusoap.php SOAP variklis
*/
require_once('lib/nusoap.php'); 

/**
 * Sisteminė klasė 
 */

require_once('classes/System.class.php');


/**

* Šioje klasėje realizuotos daugiatarifių SMS žinučių siuntimas
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class MessageSender
{

	
	/**
	*
	*Išsiunčiama daugetarifė SMS žinutė
	*@param Integer $clientID Išiųstos žinutės identifikavimas pagal užsetintą ID (Ka gavus reportą būtų galima atsekti kokia  tai žinutė)
	*@param String $destinationNumber Gavėjo telefono numeris
	*@param String $originNumber Siuntėjo telefono numeris
	*@param String $messageText SMS žinutės tekstas
	*@param Integer $price Žinutės kaina centais
	*@param integer $status Papildomas statusas perduodamas į delivery reportą (1 - SMS siustas pagal gautą žinutę)
	*@return void Išsiunčiama daugetarifė SMS žinutė
	*/
	public function sendMessage($clientID,$destinationNumber,$originNumber,$messageText,$price,$status) 
	{
		
		//$wsdl="http://soap.bite.lt/biteapi/services/BillingPort?wsdl";
		$wsdl="http://62.80.229.104:81/biteapi/services/BillingPort?wsdl";
		$client=new soapclient__($wsdl, 'wsdl');
		$password='5fgmfmopz';
		$user='INFOTELA';
		$service_id=1460;
		$client->setHeaders("<provider-service><service-id>$service_id</service-id></provider-service>");
		$client->setCredentials($user,$password);

		$log = new Logging();
		$http = new HTTP_Client();

		$messageText = urlencode($messageText);
		$deliveryURL = urlencode("http://rae6ahpheiPu:Aeyir8cosaix@127.0.0.1/bite/delivery_reports.php?clientid=$clientID&identification=$status&status=%d&statusstring=%A");
		
		//echo $messageText;
		$err = null;
		if ($price == 45) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)0.3,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 85) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)0.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 135) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)1.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 185) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)1.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 235) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)2.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 285) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)2.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 335) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)3.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 385) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)3.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 435) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)4.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 485) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)4.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 535) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)5.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 585) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)5.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 635) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)6.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 685) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)6.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 735) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)7.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 785) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)7.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 835) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)8.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 885) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)8.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 935) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)9.2,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}
		if ($price == 985) {
			$phone = str_replace('+','',$destinationNumber);
			$param = array ('accountId' => "$phone",
							'serviceId' => $service_id,
							'functionId' => 350,
							'amount' => (float)9.7,
							'currency' => 'LTL');

			$statusMessage = $client->call('billAccount', $param, "http://biteapi.metasite.net/billing", "http://biteapi.metasite.net/billing/billAccount");			
			$err = $client->getError();
		}


		if ($err) {
			$faultMessage = urlencode($statusMessage['faultstring']);
			$url = "http://rae6ahpheiPu:Aeyir8cosaix@127.0.0.1/bite/delivery_reports.php?clientid=$clientID&identification=$status&status=50&statusstring=$faultMessage";
		} else {
			$url = "http://127.0.0.1:23002/cgi-bin/sendsms?username=ooMahng5mair&password=yahbooPh1gie&to=$destinationNumber&from=$originNumber&text=$messageText&dlr-mask=31&dlr-url=$deliveryURL";
		}
		
		//echo $url;
		$getRequest = $http->get($url);
		if ($getRequest >= 300 || $getRequest < 200) {
			$log->logError('MessageSender->sendMessage() -> GET Request Failed with error code: '.$getRequest.' Http request: '.$url);
			return false;
		} else {
			return true;
		}
		//http://content.lt:13002/cgi-bin/sendsms?username=ooMahng5mair&password=yahbooPh1gie&to=+37069825357&text=1aHello+world&dlr-mask=31&dlr-url=http://content.lt/~mindaugas/kannel/gaunam2.php?text=%25daa%25A
		
		
		
	}
	

	/**
	*Siųstos žinutės statuso pakeitimas iš neapdorotos į apdorotą
	*@param Integer $sendedSMSMessageID Siųstos sms žinutės iš informacinės sistemos identifikacnis numeris
	*@return void Įterpiami gauto sms duomenys į duomenų bazę
	*/
	public function changeSendedSMSMessageStatus($sendedSMSMessageID)
	{
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update send_sms_billing set processed=true where id=?');
		$data = array($sendedSMSMessageID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('MessageSender->changeSendedSMSMessageStatus() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: MessageSender->changeSendedSMSMessageStatus()');
		}
		$db->disconnect();
	}
	
	/**
	*Gautai žinutė nurodoma, kad jei išsiųstas atsakymas
	*@param Integer $receivedMessageID Gautos žinutės identifikacinis numeris
	*@return void Gautai žinutė nurodoma, kad jei išsiųstas atsakymas
	*/
	public function changeReceivedSMSMessageStatus($receivedMessageID)
	{
		//BEGIN SYSTEM
		$system = new System();
		$isSystem = $system->getSystemPar($receivedMessageID);
		if ($isSystem == 't') {
			$number = $system->getSystemOrginatingNumber(2);
		}
		//END SYSTEM
		$log = new Logging();
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		//Nesisteminis
		if ($isSystem == 'f') {
			$query = $db->prepare('update received_messages set processed_status=true where id=?');
			$data = array($receivedMessageID);
		} //Sisteminis 
		else {
			
			$query = $db->prepare('update received_messages set processed_status=true, senderphone=? where id=?');
			$data = array($number,$receivedMessageID);
		}
		//end sisteminis
		
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			$log->logError('MessageSender->changeReceivedSMSMessageStatus() -> '.$query_res->getDebugInfo());
			die('Kritinė klaida: MessageSender->changeReceivedSMSMessageStatus()');
		}
		$db->disconnect();
	}
	
 

}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>