<?php

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');

/**
* Prijungiama Logging.class.php klaidų įrašymo į failus valdymo klasė
*/
require_once('Logging.class.php');

/**
* Prijungiama Customer.class.php klientų duomenų valdymo klasė
*/
require_once('Customer.class.php');

/**
* Prijungiama MessageSender.class.php daugiatarifių SMS žinučių siuntimo klasių biblioteka
*/
require_once('MessageSender.class.php');



/**

* Šioje klasėje realizuotos apmokestinimo iš kliento IS apdorojimas
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class ClientISBillingManager
{
	/**
	 *Apdorojama gauta užklausa iš kliento informacinės sistemos
	 * 
	 *@param String $received_message_id Gautos žinutės identifikacinis numeris
	 *@param Integer $allowed_billing_id Klientui priskirto tarifo identifikacinis numeris
	 *@param Integer $customer_id Kliento identifikacinis numeris
	 *@param String $reply Perduodamas atsakymas
	 */
	public function manageISBillingRequests($received_message_id,$allowed_billing_id,$customer_id,$reply) {
		$customer = new Customer();
		$sender = new MessageSender();
		$networkID = $customer->getOperatorID($received_message_id);
		
		if ($networkID == 2) {
			
			$customerID = $customer->getCustomerIDByReceiveMessageID($received_message_id);
			$isAccessAllowed = $customer->checkGSMAccess($customerID,2);
			$isURLEnabled = $customer->checkCustomerISURL($customerID);
			$cost = $customer->getCustomerAllowdBillingPrice($allowed_billing_id);
			
			//Teisinga užklausa, ji apmokestinama, siunciam jei aktyvus kliento IS url adresas
			if ($customerID > 0 && $isAccessAllowed == true && $isURLEnabled == true) {
				$sender->sendMessage($received_message_id,$customer->getReceiveMessagePhone($received_message_id),'1616',$reply,$cost,1);
				$sender->changeReceivedSMSMessageStatus($received_message_id);
				$customer->setReceiveMessageCustomer($received_message_id,$customerID);
				$customer->setReceiveMessagePrice($received_message_id,$cost);
				$customer->insertReplyISMessage($received_message_id,$allowed_billing_id,$customer_id,$reply,true);
			}
			
		}

	}
	
}


//$a = new Customer();
//echo $a->checkVATCode('1as34d');

?>