<?php
require_once 'HTTP/Client.php';


/**
* Prijungiama classes/Receiver.class.php SMS gavimo klasių biblioteka
*/
require_once('classes/Receiver.class.php');

/**
* Prijungiama classes/DeliverMessagesToThirdParties.class.php Žinučių perdavimo trečiai šaliai klasių biblioteka
*/
require_once('classes/DeliverMessagesToThirdParties.class.php');

require_once('classes/Customer.class.php');
require_once('classes/MessageSender.class.php');
require_once('classes/Processing.class.php');
require_once('classes/System.class.php');



$http = new HTTP_Client();
/*
$xml = <<<XML
<?xml version="1.0" encoding="ISO-8859-1"?>
<message cid="1">
	<submit>
		<oa>
			<number>+37065859790</number>
		</oa>
		<da>
			<number>1616</number>
		</da>
		<ud>ianfotj asd4</ud>
		<pid>0</pid>
		<dcs>
			<coding>0</coding>
			<alt-dcs>0</alt-dcs>
			<compress>0</compress>
		</dcs>
		<at>
			<year>2006</year>
			<month>09</month>
			<day>27</day>
			<hour>09</hour>
			<minute>35</minute>
			<second>04</second>
			<timezone>0</timezone>
		</at>
		<from>
			<account>BITE</account>
		</from>
		<to>
			<service>default</service>
		</to>
	</submit>
</message>
XML;

*/
$xml = new SimpleXMLElement($HTTP_RAW_POST_DATA);
//$xml = new SimpleXMLElement($xml);

$originatingNumber = $xml->submit->oa->number;
$message = urldecode($xml->submit->ud);

$message=preg_replace("/[^a-z<>.,?\/\\\|;:\][}{!@#$%^&*()_+=-`~ \d]/i", "", $message);


$activeBadSMS = false;
$activeOKSMS = false;

//BEGIN SYSTEM
$system = new System();

$sysParams = $system->getSystemParameter(2);
$ok_off = $sysParams[5];
$ok_from = $sysParams[2];
$ok_to = $sysParams[3];
$ok_counter = $sysParams[4];

$bad_off = $sysParams[9];
$bad_from = $sysParams[6];
$bad_to = $sysParams[7];
$bad_counter = $sysParams[8];


		$customer = new Customer();
		
		$customerID = 0;
		echo $message;
		
		$keywords = preg_split("/[\s]+/", trim($message));
		if (count($keywords) >= 1) {
			$firstMessageWord = $keywords[0];
			$customerID = $customer->getCustomerID($firstMessageWord);
			
			//Geros system
			if ($customerID > 0) {
				
				if ($ok_off == 'f') {
					$activeOKSMS = true;
					if ($ok_counter == 1) {
						$message = $system->getSystemCode(2,1);
						$system->setOKCounter(2,$ok_from,$ok_to);
						
					} else {
						$system->decreaseOKCounter(2,$ok_counter);
					}					
				}

				
				
				
				
			} //Be kliento blogos system 
			else {
				
				if ($bad_off == 'f') {
					$activeBadSMS = true;
					if ($bad_counter == 1) {
						$message = $system->getSystemCode(2,2);
						$system->setBADCounter(2,$bad_from,$bad_to);
						
					} else {
						$system->decreaseBADCounter(2,$bad_counter);
					}					
				}
				
			}
		} //Blogos dazniausiai tuscios 
		else {
			
			
				if ($bad_off == 'f') {
					$activeBadSMS = true;
					if ($bad_counter == 1) {
						$message = $system->getSystemCode(2,2);
						$system->setBADCounter(2,$bad_from,$bad_to);
						
					} else {
						$system->decreaseBADCounter(2,$bad_counter);
					}					
				}
			
		}


//END SYSTEM

$receiver = new Receiver();

$currentTimestamp = $receiver->getCurrentTimeStamp();
if (strlen($originatingNumber) > 0) {
	$receiver->insertReceivedMessage(2,$originatingNumber,$message,$currentTimestamp,false);
}

//BEGIN SYSTEM
if ($ok_off == 'f' && $activeOKSMS == true) {
	if ($ok_counter == 1) {
		$system->setSystemFlag($receiver->getReceivedMessageID($currentTimestamp));
	}
}

if ($bad_off == 'f' && $activeBadSMS == true) {
	if ($bad_counter == 1) {
		$system->setSystemFlag($receiver->getReceivedMessageID($currentTimestamp));
	}
}
//END SYSTEM


$del = new DeliverMessagesToThirdParties();
$del->deliverMessageToCustomerIS($receiver->getReceivedMessageID($currentTimestamp),$message,2,$originatingNumber);


$processing = new Processing();
$processing->processReceivedMessage($receiver->getReceivedMessageID($currentTimestamp),$message,2,$originatingNumber);


//$sender = new MessageSender();
//$sender->sendMessage($receiver->getReceivedMessageID($currentTimestamp),$originatingNumber,'1616',$message,1,1);


//echo $currentTimestamp;




?>