<?php
	/*
		Copyright (c) Rolandas Razma
		Released under the GNU General Public License
	*/

	class webtopay {
		var $code, $title, $description, $enabled;


		// class constructor
		function webtopay() {
			global $order;

			$this->code			= 'webtopay';
			$this->title		= MODULE_PAYMENT_WEBTOPAY_TEXT_TITLE;
			$this->description	= MODULE_PAYMENT_WEBTOPAY_TEXT_DESCRIPTION;
			$this->sort_order	= MODULE_PAYMENT_WEBTOPAY_SORT_ORDER;
			$this->enabled		= ((MODULE_PAYMENT_WEBTOPAY_STATUS == 'True') ? true : false);

			if ((int)MODULE_PAYMENT_WEBTOPAY_ORDER_STATUS_ID > 0) {
				$this->order_status = MODULE_PAYMENT_WEBTOPAY_ORDER_STATUS_ID;
			}

			if (is_object($order)) $this->update_status();

			$this->form_action_url = 'https://www.webtopay.com/pay/';
		}


		// class methods
		function update_status() {
			global $order;

			if ( ($this->enabled == true) && ((int)MODULE_PAYMENT_WEBTOPAY_ZONE > 0) ) {
				$check_flag = false;
				$check_query = tep_db_query("select zone_id from " . TABLE_ZONES_TO_GEO_ZONES . " where geo_zone_id = '" . MODULE_PAYMENT_WEBTOPAY_ZONE . "' and zone_country_id = '" . $order->billing['country']['id'] . "' order by zone_id");

				while ($check = tep_db_fetch_array($check_query)) {
					if ($check['zone_id'] < 1) {
						$check_flag = true;
						break;
					} elseif ($check['zone_id'] == $order->billing['zone_id']) {
						$check_flag = true;
						break;
					}
				}

				if ($check_flag == false) {
					$this->enabled = false;
				}
			}
		}


		function javascript_validation() {
			return false;
		}


		function selection() {
			return array(
				'id' => $this->code,
				'module' => $this->title
			);
		}


		function pre_confirmation_check() {
			/* Hack */
			unset($_SESSION->cart['cartID'], $_SESSION['cartID']);
			$_SESSION['payment'] = $_POST['payment'];
			$_SESSION['OrderID'] = md5( microtime().$GLOBALS['customer_id'] );
			tep_session_close();

			/* Fix for sessions stored in mysql by laurynas.butkus@gmail.com */
			if (STORE_SESSIONS == 'mysql')
				session_set_save_handler('_sess_open', '_sess_close', '_sess_read', '_sess_write', '_sess_destroy', '_sess_gc');
			/*/Fix for sessions stored in mysql */

			tep_session_start();
			/*/Hack */

			return false;
		}


		function confirmation() {
			return false;
		}


		function process_button() {
			global $order, $currencies, $currency, $customer_id, $cartID;

			if ( !in_array($currency, array('CAD', 'EUR', 'GBP', 'JPY', 'LTL', 'LTL')) ) {
				$currency = 'LTL';
			}

			/* Hack */
			$newSID = md5(tep_session_id());
			tep_session_id($newSID);
			/*/Hack */

			$process_button_string =
			tep_draw_hidden_field('MerchantID',		MODULE_PAYMENT_WEBTOPAY_ID) .
			tep_draw_hidden_field('Amount',			($order->info['total'] * $currencies->get_value($currency) *100)) .
			tep_draw_hidden_field('Currency',		$currency) .
			tep_draw_hidden_field('OrderID',		$_SESSION['OrderID']) .
			tep_draw_hidden_field('Lang',			substr($_SESSION['language'],0, 3)) .
			tep_draw_hidden_field('Country',		$order->customer['country']['iso_code_2']) .

			tep_draw_hidden_field('AcceptURL',		tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
			tep_draw_hidden_field('CallbackURL',	tep_href_link(FILENAME_CHECKOUT_PROCESS, '', 'SSL')) .
			tep_draw_hidden_field('CancelURL',		tep_href_link(FILENAME_CHECKOUT_PAYMENT, '', 'SSL')) .
			tep_draw_hidden_field('Cookie',			tep_session_name()."={$newSID}") .
			tep_draw_hidden_field('Test',			MODULE_PAYMENT_WEBTOPAY_TESTING);

			return $process_button_string;
		}


		function before_process() {
			if( $_REQUEST['transaction'] ){
				$GLOBALS['order']->customer['email_address'] .= "\nDont\nSend\nEmail\nPlease\n:)";
			}
			return false;
		}


		function after_process() {
			global $insert_id, $cartID;

			if( $_REQUEST['orderid'] )
				$_SESSION['OrderID'] = $_REQUEST['orderid'];

			tep_db_query("UPDATE " . TABLE_ORDERS . " SET `SSID` = '".$_SESSION['OrderID']."' WHERE `orders_id` = '" . (int)$insert_id . "'");
			$order_query = tep_db_query("SELECT `orders_id` FROM " . TABLE_ORDERS . " WHERE `SSID` = '" . $_SESSION['OrderID'] . "' ORDER By `orders_id` ASC");

			if( tep_db_num_rows($order_query) > 1 ){
				$this->tep_remove_order($insert_id, true);
				$order = tep_db_fetch_array($order_query);
				$insert_id = $order['orders_id'];
			}

			if( $_REQUEST['transaction'] ){
				if ( $_REQUEST['transaction'] == md5(MODULE_PAYMENT_WEBTOPAY_PASS."|{$_REQUEST['orderid']}|".(( MODULE_PAYMENT_WEBTOPAY_TESTING == "Yes" )?1:0)."|1") ) {
					$isOk = true;
				}else{
                    $isOk = false;
                }

				if( $isOk && MODULE_PAYMENT_WEBTOPAY_CH_ORDER_STATUS == "Yes" ) {
					tep_db_query("UPDATE " . TABLE_ORDERS . " SET `orders_status` = '20' WHERE `orders_id` = '" . (int)$insert_id . "'");
				}elseif( !$isOk ){
					$this->tep_remove_order($insert_id, true);
				}

				die();
			}

			return false;
		}


		function output_error() {
			return false;
		}


		function check() {
			if (!isset($this->_check)) {
				$check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_PAYMENT_WEBTOPAY_STATUS'");
				$this->_check = tep_db_num_rows($check_query);
			}
			return $this->_check;
		}


		function install() {
			$this->remove();

			/* Hack */
			global $language, $module_type;
			include_once(DIR_FS_CATALOG_LANGUAGES.$language.'/modules/'.$module_type.'/webtopay.php');
			/*/Hack */

            $field = tep_db_fetch_array(tep_db_query("SELECT `currencies_id` FROM " . TABLE_CURRENCIES . " WHERE  `code` = 'LTL' LIMIT 1"));
            if( !$field['currencies_id'] ){
                tep_db_query("insert into " . TABLE_CURRENCIES . "(`title`, `code`, `symbol_left`, `symbol_right`, `decimal_point`, `thousands_point`, `decimal_places`, `value`, `last_updated`) values ('Lithuania litas', 'LTL', 'Lt', '', '.', ',', '2', '2.38189947', NOW())");
            }

			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_STATUS_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_STATUS', 'True', '".MODULE_PAYMENT_WEBTOPAY_STATUS_DESCRIPTION."', '6', '3', 'tep_cfg_select_option(array(\'True\', \'False\'), ', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_ID_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_ID', '0', '".MODULE_PAYMENT_WEBTOPAY_ID_DESCRIPTION."', '6', '4', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_PASS_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_PASS', '0', '".MODULE_PAYMENT_WEBTOPAY_PASS_DESCRIPTION."', '6', '5', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_CURRENCY_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_CURRENCY', 'Selected Currency', '".MODULE_PAYMENT_WEBTOPAY_CURRENCY_DESCRIPTION."', '6', '6', 'tep_cfg_select_option(array(\'Selected Currency\',\'Only USD\',\'Only CAD\',\'Only EUR\',\'Only GBP\',\'Only JPY\'), ', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_ZONE_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_ZONE', '0', '".MODULE_PAYMENT_WEBTOPAY_ZONE_DESCRIPTION."', '6', '2', 'tep_get_zone_class_title', 'tep_cfg_pull_down_zone_classes(', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_SORT_ORDER_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_SORT_ORDER', '0', '".MODULE_PAYMENT_WEBTOPAY_SORT_ORDER_DESCRIPTION."', '6', '0', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, 	configuration_group_id, sort_order, set_function, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_TESTING_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_TESTING', 	'No', '".MODULE_PAYMENT_WEBTOPAY_TESTING_DESCRIPTION."', '6', '0', 'tep_cfg_select_option(array(\'Yes\', \'No\'), ', now())");
			tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, 	configuration_group_id, sort_order, set_function, date_added) values ('".MODULE_PAYMENT_WEBTOPAY_CH_ORDER_STATUS_TITLE."', 'MODULE_PAYMENT_WEBTOPAY_CH_ORDER_STATUS', 	'Yes', '".MODULE_PAYMENT_WEBTOPAY_CH_ORDER_STATUS_DESCRIPTION."', '6', '0', 'tep_cfg_select_option(array(\'Yes\', \'No\'), ', now())");

			$d = dir(DIR_FS_CATALOG_LANGUAGES);
			while ( false !== ($entry = $d->read()) ) {
				if( $entry != "." && $entry != ".." && is_dir($d->path.$entry) && is_file($d->path.$entry.'/modules/'.$module_type.'/webtopay.php') ){
					$langFile = implode('', file($d->path.$entry.'/modules/'.$module_type.'/webtopay.php'));
					preg_match("/MODULE_PAYMENT_WEBTOPAY_ORDERS_STATUS_20.*['\"]\s*,\s*['\"]([^\"']+)/", $langFile, $constant);

					$language_query = tep_db_query("SELECT languages_id from " . TABLE_LANGUAGES . " WHERE directory = '" . $entry . "'");
					$languageData = tep_db_fetch_array($language_query);

					if( $languageData ){
						tep_db_query("insert into " . TABLE_ORDERS_STATUS . " (orders_status_id, language_id, orders_status_name) values (20, '".$languageData['languages_id']."', '".trim($constant[1])."')");
					}
				}
			}
			$d->close();

			tep_db_query("ALTER TABLE ".TABLE_ORDERS." ADD `SSID` VARCHAR( 40 ) NOT NULL");
		}


		function remove() {
			tep_db_query("DELETE FROM " . TABLE_CONFIGURATION . " WHERE `configuration_key` IN ('" . implode("', '", $this->keys()) . "')");
			tep_db_query("DELETE FROM " . TABLE_ORDERS_STATUS . " WHERE `orders_status_id` = '20'");

			$res = tep_db_query("SHOW FIELDS FROM " . TABLE_ORDERS);
			while ($field = tep_db_fetch_array($res)) {
				if( $field['Field'] == 'SSID' ){
					tep_db_query("ALTER TABLE " . TABLE_ORDERS . " DROP `SSID` ");
					break;
				}
			}
		}


		function keys() {
			return array('MODULE_PAYMENT_WEBTOPAY_STATUS', 'MODULE_PAYMENT_WEBTOPAY_TESTING', 'MODULE_PAYMENT_WEBTOPAY_ID', 'MODULE_PAYMENT_WEBTOPAY_PASS', 'MODULE_PAYMENT_WEBTOPAY_CURRENCY', 'MODULE_PAYMENT_WEBTOPAY_ZONE', 'MODULE_PAYMENT_WEBTOPAY_SORT_ORDER', 'MODULE_PAYMENT_WEBTOPAY_CH_ORDER_STATUS');
		}


		function tep_remove_order($order_id, $restock = false) {
			if ($restock) {
				$order_query = tep_db_query("SELECT products_id, products_quantity from " . TABLE_ORDERS_PRODUCTS . " where orders_id = '" . (int)$order_id . "'");
				while ($order = tep_db_fetch_array($order_query)) {
					tep_db_query("UPDATE " . TABLE_PRODUCTS . " SET products_quantity = products_quantity + " . $order['products_quantity'] . ", products_ordered = products_ordered - " . $order['products_quantity'] . " where products_id = '" . (int)$order['products_id'] . "'");
				}
			}

			tep_db_query("DELETE FROM " . TABLE_ORDERS . " WHERE orders_id = '" . (int)$order_id . "'");
			tep_db_query("DELETE FROM " . TABLE_ORDERS_PRODUCTS . " WHERE orders_id = '" . (int)$order_id . "'");
			tep_db_query("DELETE FROM " . TABLE_ORDERS_PRODUCTS_ATTRIBUTES . " WHERE orders_id = '" . (int)$order_id . "'");
			tep_db_query("DELETE FROM " . TABLE_ORDERS_STATUS_HISTORY . " WHERE orders_id = '" . (int)$order_id . "'");
			tep_db_query("DELETE FROM " . TABLE_ORDERS_TOTAL . " WHERE orders_id = '" . (int)$order_id . "'");
		}

	}

?>