<?php
/**
*
* acp_common.php [Lithuanian]
*
* @package language
* @version $Id: $
* @copyright (c) 2008 phpBB Group
* @author 2008-11-16 - Vilius Šumskas
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$lang = array_merge($lang, array(
	'ACP_ADMINISTRATORS'	=> 'Administratoriai',
	'ACP_ADMIN_LOGS'	=> 'Administratorių veiksmų registras',
	'ACP_ADMIN_ROLES'	=> 'Administratorių rolės',
	'ACP_ATTACHMENTS'	=> 'Prikabinti failai',
	'ACP_ATTACHMENT_SETTINGS'	=> 'Prikabintų failų nustatymai',
	'ACP_AUTH_SETTINGS'	=> 'Autentifikacija',
	'ACP_AUTOMATION'	=> 'Automatizacija',
	'ACP_AVATAR_SETTINGS'	=> 'Avatarų nustatymai',
	'ACP_BACKUP'	=> 'Atsarginė kopija',
	'ACP_BAN'	=> 'Blokavimas',
	'ACP_BAN_EMAILS'	=> 'Blokuoti el. pašto adresus',
	'ACP_BAN_IPS'	=> 'Blokuoti IP adresus',
	'ACP_BAN_USERNAMES'	=> 'Blokuoti vartotojų vardus',
	'ACP_BBCODES'	=> 'BBKodai',
	'ACP_BOARD_CONFIGURATION'	=> 'Konfigūracija',
	'ACP_BOARD_FEATURES'	=> 'Galimybės',
	'ACP_BOARD_MANAGEMENT'	=> 'Lentos valdymas',
	'ACP_BOARD_SETTINGS'	=> 'Lentos nustatymai',
	'ACP_BOTS'	=> 'Vorai/Robotai',
	'ACP_CAPTCHA'	=> 'CAPTCHA',
	'ACP_CAT_DATABASE'	=> 'Duomenų bazė',
	'ACP_CAT_DOT_MODS'	=> '.MOD`ai',
	'ACP_CAT_FORUMS'	=> 'Forumai',
	'ACP_CAT_GENERAL'	=> 'Bendrai',
	'ACP_CAT_MAINTENANCE'	=> 'Priežiūra',
	'ACP_CAT_PERMISSIONS'	=> 'Teisės',
	'ACP_CAT_POSTING'	=> 'Pranešimų rašymas',
	'ACP_CAT_STYLES'	=> 'Stiliai',
	'ACP_CAT_SYSTEM'	=> 'Sistema',
	'ACP_CAT_USERGROUP'	=> 'Vartotojai ir grupės',
	'ACP_CAT_USERS'	=> 'Vartotojai',
	'ACP_CLIENT_COMMUNICATION'	=> 'Klientų bendravimas',
	'ACP_COOKIE_SETTINGS'	=> 'Sausainėlių nustatymai',
	'ACP_CRITICAL_LOGS'	=> 'Klaidų registras',
	'ACP_CUSTOM_PROFILE_FIELDS'	=> 'Papildomi aprašo laukai',
	'ACP_DATABASE'	=> 'Duomenų bazės valdymas',
	'ACP_DISALLOW'	=> 'Neleisti',
	'ACP_DISALLOW_USERNAMES'	=> 'Drausti vartotojų vardus',
	'ACP_EMAIL_SETTINGS'	=> 'El. pašto nustatymai',
	'ACP_EXTENSION_GROUPS'	=> 'Valdyti išplėtimų grupes',
	'ACP_FORUM_BASED_PERMISSIONS'	=> 'Forumo teisės',
	'ACP_FORUM_LOGS'	=> 'Diskusijų registras',
	'ACP_FORUM_MANAGEMENT'	=> 'Forumo valdymas',
	'ACP_FORUM_MODERATORS'	=> 'Forumo moderatoriai',
	'ACP_FORUM_PERMISSIONS'	=> 'Forumo teisės',
	'ACP_FORUM_ROLES'	=> 'Forumo rolės',
	'ACP_GENERAL_CONFIGURATION'	=> 'Pagrindiniai nustatymai',
	'ACP_GENERAL_TASKS'	=> 'Pagrindinės užduotys',
	'ACP_GLOBAL_MODERATORS'	=> 'Globalūs moderatoriai',
	'ACP_GLOBAL_PERMISSIONS'	=> 'Globalios teisės',
	'ACP_GROUPS'	=> 'Grupės',
	'ACP_GROUPS_FORUM_PERMISSIONS'	=> 'Grupių teisės forumuose',
	'ACP_GROUPS_MANAGE'	=> 'Valdyti grupes',
	'ACP_GROUPS_MANAGEMENT'	=> 'Grupių valdymas',
	'ACP_GROUPS_PERMISSIONS'	=> 'Grupių teisės',
	'ACP_ICONS'	=> 'Temų piktogramos',
	'ACP_ICONS_SMILIES'	=> 'Temų piktogramos/šypsenėlės',
	'ACP_IMAGESETS'	=> 'Paveikslėlių komplektai',
	'ACP_INACTIVE_USERS'	=> 'Neaktyvūs vartotojai',
	'ACP_INDEX'	=> 'Pirmasis administravimo puslapis',
	'ACP_JABBER_SETTINGS'	=> 'Jabber nustatymai',
	'ACP_LANGUAGE'	=> 'Kalbos valdymas',
	'ACP_LANGUAGE_PACKS'	=> 'Kalbų paketai',
	'ACP_LOAD_SETTINGS'	=> 'Apkrovimo nustatymai',
	'ACP_LOGGING'	=> 'Registras',
	'ACP_MAIN'	=> 'Pagrindinis administravimo puslapis',
	'ACP_MANAGE_EXTENSIONS'	=> 'Valdyti išplėtimus',
	'ACP_MANAGE_FORUMS'	=> 'Valdyti forumus',
	'ACP_MANAGE_RANKS'	=> 'Valdyti rangus',
	'ACP_MANAGE_REASONS'	=> 'Valdyti raportų/blokavimo priežastis',
	'ACP_MANAGE_USERS'	=> 'Valdyti vartotojus',
	'ACP_MASS_EMAIL'	=> 'Masinis el. pašto siuntimas',
	'ACP_MESSAGES'	=> 'Žinutės',
	'ACP_MESSAGE_SETTINGS'	=> 'Asmeninių žinučių nustatymai',
	'ACP_MODULE_MANAGEMENT'	=> 'Modulių valdymas',
	'ACP_MOD_LOGS'	=> 'Moderatorių veiksmų registras',
	'ACP_MOD_ROLES'	=> 'Moderatorių rolės',
	'ACP_NO_ITEMS'	=> 'Kol kas nėra.',
	'ACP_ORPHAN_ATTACHMENTS'	=> 'Pasimetę failai',
	'ACP_PERMISSIONS'	=> 'Teisės',
	'ACP_PERMISSION_MASKS'	=> 'Teisių vykdymas',
	'ACP_PERMISSION_ROLES'	=> 'Teisių rolės',
	'ACP_PERMISSION_TRACE'	=> 'Teisių tyrimas',
	'ACP_PHP_INFO'	=> 'PHP informacija',
	'ACP_POST_SETTINGS'	=> 'Rašymo nustatymai',
	'ACP_PRUNE_FORUMS'	=> 'Forumų valymas',
	'ACP_PRUNE_USERS'	=> 'Vartotojų valymas',
	'ACP_PRUNING'	=> 'Valymas',
	'ACP_QUICK_ACCESS'	=> 'Greitasis meniu',
	'ACP_RANKS'	=> 'Rangai',
	'ACP_REASONS'	=> 'Raportų/blokavimo priežastys',
	'ACP_REGISTER_SETTINGS'	=> 'Vartotojų registracijos nustatymai',
	'ACP_RESTORE'	=> 'Atstatymas',
	'ACP_SEARCH'	=> 'Paieškos konfigūracija',
	'ACP_SEARCH_INDEX'	=> 'Paieškos indeksas',
	'ACP_SEARCH_SETTINGS'	=> 'Paieškos nustatymai',
	'ACP_SECURITY_SETTINGS'	=> 'Saugumo nustatymai',
	'ACP_SERVER_CONFIGURATION'	=> 'Serverio konfigūracija',
	'ACP_SERVER_SETTINGS'	=> 'Serverio nustatymai',
	'ACP_SIGNATURE_SETTINGS'	=> 'Parašo nustatymai',
	'ACP_SMILIES'	=> 'Šypsenėlės',
	'ACP_STYLE_COMPONENTS'	=> 'Stilių komponentai',
	'ACP_STYLE_MANAGEMENT'	=> 'Stilių valdymas',
	'ACP_STYLES'	=> 'Stiliai',
	'ACP_TEMPLATES'	=> 'Šablonai',
	'ACP_THEMES'	=> 'Temos',
	'ACP_UPDATE'	=> 'Atnaujinama',
	'ACP_USERS_FORUM_PERMISSIONS'	=> 'Vartotojų teisės forumuose',
	'ACP_USERS_LOGS'	=> 'Vartotojų veiksmų registras',
	'ACP_USERS_PERMISSIONS'	=> 'Vartotojų teisės',
	'ACP_USER_ATTACH'	=> 'Prikabinti failai',
	'ACP_USER_AVATAR'	=> 'Avataras',
	'ACP_USER_FEEDBACK'	=> 'Atsiliepimai',
	'ACP_USER_GROUPS'	=> 'Grupės',
	'ACP_USER_MANAGEMENT'	=> 'Vartotojo valdymas',
	'ACP_USER_OVERVIEW'	=> 'Santrauka',
	'ACP_USER_PERM'	=> 'Teisės',
	'ACP_USER_PREFS'	=> 'Nustatymai',
	'ACP_USER_PROFILE'	=> 'Aprašas',
	'ACP_USER_RANK'	=> 'Rangas',
	'ACP_USER_ROLES'	=> 'Vartotojo rolės',
	'ACP_USER_SECURITY'	=> 'Vartotojo saugumas',
	'ACP_USER_SIG'	=> 'Parašas',
	'ACP_VC_SETTINGS'	=> 'Vaizdinio patvirtinimo nustatymai',
	'ACP_VC_CAPTCHA_DISPLAY'	=> 'CAPTCHA paveikslėlio peržiūra',
	'ACP_VERSION_CHECK'	=> 'Tikrinti versijos naujumą',
	'ACP_VIEW_ADMIN_PERMISSIONS'	=> 'Peržiūrėti administravimo teises',
	'ACP_VIEW_FORUM_MOD_PERMISSIONS'	=> 'Peržiūrėti forumo moderavimo teises',
	'ACP_VIEW_FORUM_PERMISSIONS'	=> 'Peržiūrėti forumo teises',
	'ACP_VIEW_GLOBAL_MOD_PERMISSIONS'	=> 'Peržiūrėti globalaus moderavimo teises',
	'ACP_VIEW_USER_PERMISSIONS'	=> 'Peržiūrėti vartotojo teises',
	'ACP_WORDS'	=> 'Cenzūra',
	'ACTION'	=> 'Veiksmas',
	'ACTIONS'	=> 'Veiksmai',
	'ACTIVATE'	=> 'Aktyvuoti',
	'ADD'	=> 'Pridėti',
	'ADMIN'	=> 'Administravimas',
	'ADMIN_INDEX'	=> 'Pirmasis administravimo puslapis',
	'ADMIN_PANEL'	=> 'Administratoriaus valdymo pultas',
	'ADM_LOGOUT'	=> 'Atsijungti nuo AVP',
	'ADM_LOGGED_OUT'	=> 'Sėkmingai atsijungėte nuo administratoriaus valdymo pulto',
	'BACK'	=> 'Atgal',
	'COLOUR_SWATCH'	=> 'Spalvų paletė',
	'CONFIG_UPDATED'	=> 'Konfigūracija sėkmingai atnaujinta.',
	'DEACTIVATE'	=> 'Išjungti',
	'DIRECTORY_DOES_NOT_EXIST'	=> 'Įrašytas kelias “%s” neegzistuoja.',
	'DIRECTORY_NOT_DIR'	=> 'Įrašytas kelias “%s” nėra katalogas.',
	'DIRECTORY_NOT_WRITABLE'	=> 'Nurodytas katalogas “%s” yra tik skaitymui.',
	'DISABLE'	=> 'Išjungti',
	'DOWNLOAD'	=> 'Atsisiųsti',
	'DOWNLOAD_AS'	=> 'Išsaugoti kaip',
	'DOWNLOAD_STORE'	=> 'Atsisiųsti arba išsaugoti failą',
	'DOWNLOAD_STORE_EXPLAIN'	=> 'Galite atsisiųsti failą arba išsaugoti į katalogą <samp>store/</samp>.',
	'EDIT'	=> 'Keisti',
	'ENABLE'	=> 'Įjungti',
	'EXPORT_DOWNLOAD'	=> 'Atsisiųsti',
	'EXPORT_STORE'	=> 'Išsaugoti',
	'GENERAL_OPTIONS'	=> 'Pagrindiniai parametrai',
	'GENERAL_SETTINGS'	=> 'Pagrindiniai nustatymai',
	'GLOBAL_MASK'	=> 'Globalus teisių vykdymas',
	'INSTALL'	=> 'Įdiegti',
	'IP'	=> 'Vartotojo IP',
	'IP_HOSTNAME'	=> 'IP adresai arba internetiniai vardai',
	'LOGGED_IN_AS'	=> 'Jūs prisijungę kaip:',
	'LOGIN_ADMIN'	=> 'Norėdami administruoti diskusijas turite prisijungti.',
	'LOGIN_ADMIN_CONFIRM'	=> 'Norėdami administruoti diskusijas turite prisijungti dar kartą.',
	'LOGIN_ADMIN_SUCCESS'	=> 'Jūs sėkmingai prisijungėte ir dabar būsite nukreipti į administratoriaus valdymo pultą.',
	'LOOK_UP_FORUM'	=> 'Pasirinkti forumą',
	'LOOK_UP_FORUMS_EXPLAIN'	=> 'Galite pasirinkti daugiau nei vieną forumą.',
	'MANAGE'	=> 'Valdyti',
	'MENU_TOGGLE'	=> 'Paslėpti arba parodyti šoninį meniu',
	'MOVE_DOWN'	=> 'Perkelti apačion',
	'MOVE_UP'	=> 'Perkelti aukštyn',
	'NOTIFY'	=> 'Informacija',
	'NO_ADMIN'	=> 'Jūs neturite teisės administruoti šių diskusijų.',
	'NO_EMAILS_DEFINED'	=> 'Nerastas nei vienas teisingas el. pašto adresas.',
	'NO_PASSWORD_SUPPLIED'	=> 'Norėdami prisijungti prie administratoriaus valdymo pulto turite įvesti slaptažodį.',
	'OFF'	=> 'Išjungta',
	'ON'	=> 'Įjungta',
	'PARSE_BBCODE'	=> 'Apdoroti BBKodą',
	'PARSE_SMILIES'	=> 'Apdoroti šypsenėles',
	'PARSE_URLS'	=> 'Apdoroti nuorodas',
	'PERMISSIONS_TRANSFERRED'	=> 'Teisės perimtos',
	'PERMISSIONS_TRANSFERRED_EXPLAIN'	=> 'Jūs perėmėte vartotojo %1$s teises. Siu šio vartotojo teisėmis galite naršyti diskusijose tačiau negalėsite prieiti prie administratoriaus valdymo pulto, kadangi administravimo teisės nebuvo perimtos. Savo teises galite <a href="%2$s"><strong>susigrąžinti</strong></a> bet kuriuo metu.',
	'PIXEL'	=> 'piks.',
	'PROCEED_TO_ACP'	=> '%sEiti į administratoriaus valdymo pultą%s',
	'REMIND'	=> 'Priminti',
	'RESYNC'	=> 'Sinchronizuoti',
	'RETURN_TO'	=> 'Grįžti į…',
	'SELECT_ANONYMOUS'	=> 'Pasirinkti anoniminį vartotoją',
	'SELECT_OPTION'	=> 'Pasirinkite veiksmą',
	'SETTING_TOO_LOW'	=> 'Įrašyta nustatymo “%1$s” reikšmė yra per maža. Minimali leistina reikšmė yra %2$d.',
	'SETTING_TOO_BIG'	=> 'Įrašyta nustatymo “%1$s” reikšmė yra per didelė. Maksimali leistina reikšmė yra %2$d.',
	'SETTING_TOO_LONG'	=> 'Įrašyta nustatymo “%1$s” reikšmė per ilga. Maksimalus leistinas ilgis yra %2$d.',
	'SETTING_TOO_SHORT'	=> 'Įrašyta nustatymo “%1$s” reikšmė per trumpa. Minimalus leistinas ilgis yra %2$d.',
	'UCP'	=> 'Vartotojo valdymo pultas',
	'USERNAMES_EXPLAIN'	=> 'Kiekvieną vartotojo vardą rašykite naujoje eilutėje.',
	'USER_CONTROL_PANEL'	=> 'Vartotojo valdymo pultas',
	'WARNING'	=> 'Perspėjimas',
	'ACP_PHP_INFO_EXPLAIN'	=> 'Šiame puslapyje rodoma serveryje įdiegtos PHP versijos informacija. Čia taip pat rasite užkrautų modulių, kintamųjų bei standartinių nustatymų sąrašą. Šie duomenys gali pagelbėti problemų diagnostikos metu. Atsiminkite, kad dėl saugumo sumetimų, kai kurie internetinių paslaugų teikėjai ribos čia rodomą informacija.',
	'NO_PHPINFO_AVAILABLE'	=> 'Nepavyko nustatyti jūsų PHP konfigūracijos. Phpinfo() išjungta dėl saugumo sumetimų.',
	'ACP_ADMIN_LOGS_EXPLAIN'	=> 'Čia rodomi visi diskusijų administratorių veiksmai. Galite surūšiuoti juos pagal vartotojo vardą, datą, IP adresą arba veiksmą. Jeigu turite reikiamas teises, galite ištrinti vieną įrašą arba išvalyti visą registrą.',
	'ACP_CRITICAL_LOGS_EXPLAIN'	=> 'Čia rodomi visi pačios diskusijų lentos veiksmai. Informacija šiame sąraše padės spręsti visas specifines problemas, pavyzdžiui problemas apie nepristatytus el. laiškus. Galite surūšiuoti juos pagal vartotojo vardą, datą, IP adresą arba veiksmą. Jeigu turite reikiamas teises, galite ištrinti vieną įrašą arba išvalyti visą registrą.',
	'ACP_MOD_LOGS_EXPLAIN'	=> 'Čia rodomi visi veiksmai atlikti forumuose, temose ir pranešimuose, taipogi moderatorių veiksmai vartotojų atžvilgiu, įskaitant blokavimą. Galite surūšiuoti juos pagal vartotojo vardą, datą, IP adresą arba veiksmą. Jeigu turite reikiamas teises, galite ištrinti vieną įrašą arba išvalyti visą registrą.',
	'ACP_USERS_LOGS_EXPLAIN'	=> 'Čia rodomi visi vartotojų veiksmai (raportai, perspėjimai ir vartotojų atsiliepimai).',
	'ALL_ENTRIES'	=> 'Visi įrašai',
	'DISPLAY_LOG'	=> 'Rodyti paskutinius įrašus',
	'NO_ENTRIES'	=> 'Pasirinktu periodu nėra jokių įrašų.',
	'SORT_IP'	=> 'IP adresą',
	'SORT_DATE'	=> 'Datą',
	'SORT_ACTION'	=> 'Įrašo veiksmą',
	'ADMIN_INTRO'	=> 'Dėkojame, kad pasirinkote mus. Šiame puslapyje rasite diskusijų statistiką. Nuorodų kairiajame ekrano šone pagalba galite valdyti kiekvieną diskusijų lentos elementą. Kiekviename puslapyje rasite instrukcijas kaip naudoti vieną ar kitą įrankį.',
	'ADMIN_LOG'	=> 'Administratorių veiksmų registras',
	'ADMIN_LOG_INDEX_EXPLAIN'	=> 'Čia rodomi paskutiniai penki diskusijų administratorių veiksmai. Pilną veiksmų sąrašą rasite pasirinkę tinkamą meniu punktą arba paspaudę ant nuorodos žemiau.',
	'AVATAR_DIR_SIZE'	=> 'Avatarų katalogo dydis',
	'BOARD_STARTED'	=> 'Diskusijų lenta startavo',
	'BOARD_VERSION'	=> 'Diskusijų lentos versija',
	'DATABASE_SERVER_INFO'	=> 'Informacija apie duomenų bazės serverį',
	'DATABASE_SIZE'	=> 'Duomenų bazės dydis',
	'FILES_PER_DAY'	=> 'Prikabinti failai per dieną',
	'FORUM_STATS'	=> 'Diskusijų statistika',
	'GZIP_COMPRESSION'	=> 'GZip suspaudimas',
	'NOT_AVAILABLE'	=> 'Nepasiekiamas',
	'NUMBER_FILES'	=> 'Prikabintų failų skaičius',
	'NUMBER_POSTS'	=> 'Pranešimų skaičius',
	'NUMBER_TOPICS'	=> 'Temų skaičius',
	'NUMBER_USERS'	=> 'Vartotojų skaičius',
	'NUMBER_ORPHAN'	=> 'Pasimetę failai',
	'POSTS_PER_DAY'	=> 'Nauji pranešimai per dieną',
	'PURGE_CACHE'	=> 'Išvalyti kešą',
	'PURGE_CACHE_CONFIRM'	=> 'Ar tikrai norite išvalyti kešą?',
	'PURGE_CACHE_EXPLAIN'	=> 'Išvalo visus kešuojamus objektus, įskaitant kešuojamus šablonus ar užklausas.',
	'RESET_DATE'	=> 'Iš naujo nustatyti diskusijų lentos starto pradžią',
	'RESET_DATE_CONFIRM'	=> 'Ar tikrai norite iš naujo nustatyti diskusijų lentos starto pradžią?',
	'RESET_ONLINE'	=> 'Išvalyti daugiausiai prisijungusių vartotojų skaičių',
	'RESET_ONLINE_CONFIRM'	=> 'Ar tikrai norite išvalyti daugiausiai prisijungusių vartotojų skaičių?',
	'RESYNC_POSTCOUNTS'	=> 'Suskaičiuoti pranešimus iš naujo',
	'RESYNC_POSTCOUNTS_EXPLAIN'	=> 'Bus suskaičiuoti tik esami pranešimai. Valymo metu ištrinti pranešimai nebus įskaityti.',
	'RESYNC_POSTCOUNTS_CONFIRM'	=> 'Ar tikrai norite iš naujo suskaičiuoti pranešimus?',
	'RESYNC_POST_MARKING'	=> 'Pažymėti temas su žvaigždute iš naujo',
	'RESYNC_POST_MARKING_CONFIRM'	=> 'Ar tikrai norite suskaičiuoti temas su žvaigždute?',
	'RESYNC_POST_MARKING_EXPLAIN'	=> 'Iš pradžių visos temos bus atžymėtos, o tada vėl pažymėtos tos temos, kuriose per pastaruosius šešis mėnesius yra naujų pranešimų.',
	'RESYNC_STATS'	=> 'Atnaujinti statistiką',
	'RESYNC_STATS_CONFIRM'	=> 'Ar tikrai norite atnaujinti statistiką?',
	'RESYNC_STATS_EXPLAIN'	=> 'Suskaičiuoja visus pranešimus, temas, vartotojus ir prikabintus failus.',
	'RUN'	=> 'Pradėti',
	'STATISTIC'	=> 'Duomuo',
	'STATISTIC_RESYNC_OPTIONS'	=> 'Duomenų suskaičiavimas arba ištrynimas',
	'TOPICS_PER_DAY'	=> 'Naujos temos per dieną',
	'UPLOAD_DIR_SIZE'	=> 'Prikabintų failų katalogo dydis',
	'USERS_PER_DAY'	=> 'Nauji vartotojai per dieną',
	'VALUE'	=> 'Reikšmė',
	'VIEW_ADMIN_LOG'	=> 'Parodyti administratorių veiksmų registrą',
	'VIEW_INACTIVE_USERS'	=> 'Parodyti neaktyvius vartotojus',
	'WELCOME_PHPBB'	=> 'Sveiki atvykę į kvepalai.lt forumą',
	'WRITABLE_CONFIG'	=> 'Jūsų konfigūracinis failas (config.php) yra visiems prieinamas. Primygtinai rekomenduojame pakeisti failo teises į 640 arba bent jau 644 (pavyzdžiui: <a href="http://en.wikipedia.org/wiki/Chmod" rel="external">chmod</a> 640 config.php).',
	'INACTIVE_DATE'	=> 'Neaktyvus nuo',
	'INACTIVE_REASON'	=> 'Priežastis',
	'INACTIVE_REASON_MANUAL'	=> 'Išjungtas administratoriaus',
	'INACTIVE_REASON_PROFILE'	=> 'Pasikeitė aprašas',
	'INACTIVE_REASON_REGISTER'	=> 'Naujai registruotas',
	'INACTIVE_REASON_REMIND'	=> 'Priverstinis vartotojo vardo patvirtinimas',
	'INACTIVE_REASON_UNKNOWN'	=> 'Nežinoma',
	'INACTIVE_USERS'	=> 'Neaktyvūs vartotojai',
	'INACTIVE_USERS_EXPLAIN'	=> 'Čia yra užsiregistravusių bet neaktyvių vartotojų sąrašas. Jeigu norite, galite įjungti, ištrinti arba priminti (el. laišku) šiems vartotojams apie tai.',
	'INACTIVE_USERS_EXPLAIN_INDEX'	=> 'Paskutinių 10 užsiregistravusių bet neaktyvių vartotojų. Pilną sąrašą rasite paspaudę ant nuorodos žemiau, kur galėsite įjungti, ištrinti arba priminti (el. laišku) šiems vartotojams apie tai.',
	'NO_INACTIVE_USERS'	=> 'Neaktyvių vartotojų nėra',
	'SORT_INACTIVE'	=> 'Neaktyvumo datą',
	'SORT_LAST_VISIT'	=> 'Paskutinį apsilankymą',
	'SORT_REASON'	=> 'Priežastį',
	'SORT_REG_DATE'	=> 'Registracijos datą',
	'USER_IS_INACTIVE'	=> 'Vartotojas yra neaktyvus',
	'LOG_ACL_ADD_USER_GLOBAL_U_'	=> '<strong>Pridėtos arba pakeistos vartotojų vartotojiškos teisės</strong><br />» %s',
	'LOG_ACL_ADD_GROUP_GLOBAL_U_'	=> '<strong>Pridėtos arba pakeistos grupių vartotojiškos teisės</strong><br />» %s',
	'LOG_ACL_ADD_USER_GLOBAL_M_'	=> '<strong>Pridėtos arba pakeistos vartotojų globalaus moderavimo teisės</strong><br />» %s',
	'LOG_ACL_ADD_GROUP_GLOBAL_M_'	=> '<strong>Pridėtos arba pakeistos grupių globalaus moderavimo teisės</strong><br />» %s',
	'LOG_ACL_ADD_USER_GLOBAL_A_'	=> '<strong>Pridėtos arba pakeistos vartotojų administravimo teisės</strong><br />» %s',
	'LOG_ACL_ADD_GROUP_GLOBAL_A_'	=> '<strong>Pridėtos arba pakeistos grupių administravimo teisės</strong><br />» %s',
	'LOG_ACL_ADD_ADMIN_GLOBAL_A_'	=> '<strong>Pridėti arba pakeisti administratoriai</strong><br />» %s',
	'LOG_ACL_ADD_MOD_GLOBAL_M_'	=> '<strong>Pridėti arba pakeisti globalūs moderatoriai</strong><br />» %s',
	'LOG_ACL_ADD_USER_LOCAL_F_'	=> '<strong>Pridėtas arba pakeistas vartotojų forumo priėjimo lygis</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_ADD_USER_LOCAL_M_'	=> '<strong>Pridėtas arba pakeistas vartotojų forumo moderavimo priėjimo lygis</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_ADD_GROUP_LOCAL_F_'	=> '<strong>Pridėtas arba pakeistas grupių forumo priėjimo lygis</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_ADD_GROUP_LOCAL_M_'	=> '<strong>Pridėtas arba pakeistas grupių forumo moderavimo priėjimo lygis</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_ADD_MOD_LOCAL_M_'	=> '<strong>Pridėti arba pakeisti moderatoriai</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_ADD_FORUM_LOCAL_F_'	=> '<strong>Pridėtos arba pakeistos forumo teisės</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_DEL_ADMIN_GLOBAL_A_'	=> '<strong>Pašalinti administratoriai</strong><br />» %s',
	'LOG_ACL_DEL_MOD_GLOBAL_M_'	=> '<strong>Pašalinti globalūs moderatoriai</strong><br />» %s',
	'LOG_ACL_DEL_MOD_LOCAL_M_'	=> '<strong>Pašalinti moderatoriai</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_DEL_FORUM_LOCAL_F_'	=> '<strong>Pašalintos vartotojo/grupės forumo teisės</strong> forume %1$s<br />» %2$s',
	'LOG_ACL_TRANSFER_PERMISSIONS'	=> '<strong>Perimtos vartotojo teisės</strong><br />» %s',
	'LOG_ACL_RESTORE_PERMISSIONS'	=> '<strong>Sugrąžintos nuosavos teisės po to, kai buvo pasinaudota vartotojo teisėmis</strong><br />» %s',
	'LOG_ADMIN_AUTH_FAIL'	=> '<strong>Nepavykęs administratoriaus bandymas prisijungti</strong>',
	'LOG_ADMIN_AUTH_SUCCESS'	=> '<strong>Sėkmingas administratoriaus prisijungimas</strong>',
	'LOG_ATTACHMENTS_DELETED'	=> '<strong>Ištrinti vartotojo prikabinti failai</strong><br />» %s',
	'LOG_ATTACH_EXT_ADD'	=> '<strong>Sukurtas arba pakeistas prikabintų failų išplėtimas</strong><br />» %s',
	'LOG_ATTACH_EXT_DEL'	=> '<strong>Ištrintas prikabintų failų išplėtimas</strong><br />» %s',
	'LOG_ATTACH_EXT_UPDATE'	=> '<strong>Atnaujintas prikabintų failų išplėtimas</strong><br />» %s',
	'LOG_ATTACH_EXTGROUP_ADD'	=> '<strong>Sukurta išplėtimų grupė</strong><br />» %s',
	'LOG_ATTACH_EXTGROUP_EDIT'	=> '<strong>Pakeista išplėtimų grupė</strong><br />» %s',
	'LOG_ATTACH_EXTGROUP_DEL'	=> '<strong>Ištrinta išplėtimų grupė</strong><br />» %s',
	'LOG_ATTACH_FILEUPLOAD'	=> '<strong>Pasimetęs failas prikabintas prie pranešimo</strong><br />» ID %1$d - %2$s',
	'LOG_ATTACH_ORPHAN_DEL'	=> '<strong>Ištrinti pasimetę failai</strong><br />» %s',
	'LOG_BAN_EXCLUDE_USER'	=> '<strong>Vartotojas išskirtas iš blokuojamų sąrašo</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_BAN_EXCLUDE_IP'	=> '<strong>IP adresas išskirtas iš blokuojamų sąrašo</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_BAN_EXCLUDE_EMAIL'	=> '<strong>El. pašto adresas išskirtas iš blokuojamų sąrašo</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_BAN_USER'	=> '<strong>Užblokuotas vartotojas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_BAN_IP'	=> '<strong>Užblokuotas IP adresas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_BAN_EMAIL'	=> '<strong>Užblokuotas el. pašto adresas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_UNBAN_USER'	=> '<strong>Atblokuotas vartotojas</strong><br />» %s',
	'LOG_UNBAN_IP'	=> '<strong>Atblokuotas IP adresas</strong><br />» %s',
	'LOG_UNBAN_EMAIL'	=> '<strong>Atblokuotas el. pašto adresas</strong><br />» %s',
	'LOG_BBCODE_ADD'	=> '<strong>Pridėtas naujas BBKodas</strong><br />» %s',
	'LOG_BBCODE_EDIT'	=> '<strong>Pakeistas BBKodas</strong><br />» %s',
	'LOG_BBCODE_DELETE'	=> '<strong>Ištrintas BBKodas</strong><br />» %s',
	'LOG_BOT_ADDED'	=> '<strong>Pridėtas naujas robotas</strong><br />» %s',
	'LOG_BOT_DELETE'	=> '<strong>Ištrintas robotas</strong><br />» %s',
	'LOG_BOT_UPDATED'	=> '<strong>Pakeistas roboto aprašymas</strong><br />» %s',
	'LOG_CLEAR_ADMIN'	=> '<strong>Išvalyti visi įrašai apie administratorių veiksmus</strong>',
	'LOG_CLEAR_CRITICAL'	=> '<strong>Išvalyti visi įrašai apie diskusijų lentos klaidas</strong>',
	'LOG_CLEAR_MOD'	=> '<strong>Išvalyti visi įrašai apie moderatorių veiksmus</strong>',
	'LOG_CLEAR_USER'	=> '<strong>Išvalyti visi įrašai apie vartotojo veiksmus</strong><br />» %s',
	'LOG_CLEAR_USERS'	=> '<strong>Išvalyti visi įrašai apie vartotojų veiksmus</strong>',
	'LOG_CONFIG_ATTACH'	=> '<strong>Pakeisti prikabintų failų nustatymai</strong>',
	'LOG_CONFIG_AUTH'	=> '<strong>Pakeisti autentifikacijos nustatymai</strong>',
	'LOG_CONFIG_AVATAR'	=> '<strong>Pakeisti avatarų nustatymai</strong>',
	'LOG_CONFIG_COOKIE'	=> '<strong>Pakeisti sausainėlių nustatymai</strong>',
	'LOG_CONFIG_EMAIL'	=> '<strong>Pakeisti el. pašto nustatymai</strong>',
	'LOG_CONFIG_FEATURES'	=> '<strong>Pakeistos diskusijų lentos galimybės</strong>',
	'LOG_CONFIG_LOAD'	=> '<strong>Pakeisti apkrovimo nustatymai</strong>',
	'LOG_CONFIG_MESSAGE'	=> '<strong>Pakeisti asmeninių žinučių nustatymai</strong>',
	'LOG_CONFIG_POST'	=> '<strong>Pakeisti pranešimų nustatymai</strong>',
	'LOG_CONFIG_REGISTRATION'	=> '<strong>Pakeisti vartotojų registracijos nustatymai</strong>',
	'LOG_CONFIG_SEARCH'	=> '<strong>Pakeisti paieškos nustatymai</strong>',
	'LOG_CONFIG_SECURITY'	=> '<strong>Pakeisti saugumo nustatymai</strong>',
	'LOG_CONFIG_SERVER'	=> '<strong>Pakeisti serverio nustatymai</strong>',
	'LOG_CONFIG_SETTINGS'	=> '<strong>Pakeisti diskusijų lentos nustatymai</strong>',
	'LOG_CONFIG_SIGNATURE'	=> '<strong>Pakeisti parašų nustatymai</strong>',
	'LOG_CONFIG_VISUAL'	=> '<strong>Pakeisti vaizdinio patvirtinimo nustatymai</strong>',
	'LOG_APPROVE_TOPIC'	=> '<strong>Patvirtina tema</strong><br />» %s',
	'LOG_BUMP_TOPIC'	=> '<strong>Vartotojas priminė apie temą</strong><br />» %s',
	'LOG_DELETE_POST'	=> '<strong>Ištrintas pranešimas</strong><br />» %s',
	'LOG_DELETE_SHADOW_TOPIC'	=> '<strong>Ištrintas temos šešėlis</strong><br />» %s',
	'LOG_DELETE_TOPIC'	=> '<strong>Ištrinta tema</strong><br />» %s',
	'LOG_FORK'	=> '<strong>Nukopijuota tema</strong><br />» forume %s',
	'LOG_LOCK'	=> '<strong>Užrakinta tema</strong><br />» %s',
	'LOG_LOCK_POST'	=> '<strong>Užrakintas pranešimas</strong><br />» %s',
	'LOG_MERGE'	=> '<strong>Sujungti pranešimai</strong> į tema<br />» %s',
	'LOG_MOVE'	=> '<strong>Perkelta tema</strong><br />» iš %1$s į %2$s',
	'LOG_POST_APPROVED'	=> '<strong>Patvirtintas pranešimas</strong><br />» %s',
	'LOG_POST_DISAPPROVED'	=> '<strong>Atmestas pranešimas “%1$s” dėl</strong><br />» %2$s',
	'LOG_POST_EDITED'	=> '<strong>Redaguotas pranešimas “%1$s”, kurio autorius</strong><br />» %2$s',
	'LOG_REPORT_CLOSED'	=> '<strong>Uždarytas raportas</strong><br />» %s',
	'LOG_REPORT_DELETED'	=> '<strong>Ištrintas raportas</strong><br />» %s',
	'LOG_SPLIT_DESTINATION'	=> '<strong>Perkelti išskirti pranešimai</strong><br />» į %s',
	'LOG_SPLIT_SOURCE'	=> '<strong>Išskirti pranešimai</strong><br />» iš %s',
	'LOG_TOPIC_APPROVED'	=> '<strong>Patvirtinta tema</strong><br />» %s',
	'LOG_TOPIC_DISAPPROVED'	=> '<strong>Atmesta tema “%1$s” dėl</strong><br />%2$s',
	'LOG_TOPIC_RESYNC'	=> '<strong>Iš naujo suskaičiuotas temų skaičius</strong><br />» %s',
	'LOG_TOPIC_TYPE_CHANGED'	=> '<strong>Pakeistas temos tipas</strong><br />» %s',
	'LOG_UNLOCK'	=> '<strong>Atrakinta tema</strong><br />» %s',
	'LOG_UNLOCK_POST'	=> '<strong>Atrakintas pranešimas</strong><br />» %s',
	'LOG_DISALLOW_ADD'	=> '<strong>Uždraustas vartotojo vardas</strong><br />» %s',
	'LOG_DISALLOW_DELETE'	=> '<strong>Ištrintas draudžiamas vartotojo vardas</strong>',
	'LOG_DB_BACKUP'	=> '<strong>Padaryta atsarginė duomenų bazės kopija</strong>',
	'LOG_DB_DELETE'	=> '<strong>Ištrinta atsarginė duomenų bazės kopija</strong>',
	'LOG_DB_RESTORE'	=> '<strong>Atstatyta duomenų bazė</strong>',
	'LOG_DOWNLOAD_EXCLUDE_IP'	=> '<strong>Iš atsisiuntimų sąrašo išskirtas IP/internetinis adresas</strong><br />» %s',
	'LOG_DOWNLOAD_IP'	=> '<strong>Į atsisiuntimų sąrašą įtrauktas IP/internetinis adresas</strong><br />» %s',
	'LOG_DOWNLOAD_REMOVE_IP'	=> '<strong>Iš atsisiuntimų sąrašo ištrintas IP/internetinis adresas</strong><br />» %s',
	'LOG_ERROR_JABBER'	=> '<strong>Jabber klaida</strong><br />» %s',
	'LOG_ERROR_EMAIL'	=> '<strong>El. pašto klaida</strong><br />» %s',
	'LOG_FORUM_ADD'	=> '<strong>Sukurtas naujas forumas</strong><br />» %s',
	'LOG_FORUM_DEL_FORUM'	=> '<strong>Ištrintas forumas</strong><br />» %s',
	'LOG_FORUM_DEL_FORUMS'	=> '<strong>Ištrintas forumas ir jo subforumai</strong><br />» %s',
	'LOG_FORUM_DEL_MOVE_FORUMS'	=> '<strong>Ištrintas forumas ir perkelti jo subforumai</strong> į %1$s<br />» %2$s',
	'LOG_FORUM_DEL_MOVE_POSTS'	=> '<strong>Ištrintas forumas ir perkelti jo pranešimai</strong> į %1$s<br />» %2$s',
	'LOG_FORUM_DEL_MOVE_POSTS_FORUMS'	=> '<strong>Ištrintas forumas ir jo subforumai, pranešimai perkelti</strong> į %1$s<br />» %2$s',
	'LOG_FORUM_DEL_MOVE_POSTS_MOVE_FORUMS'	=> '<strong>Ištrintas forumas, pranešimai perkelti</strong> į %1$s <strong>, o subforumai</strong> į %2$s<br />» %3$s',
	'LOG_FORUM_DEL_POSTS'	=> '<strong>Ištrintas forumas ir visi jo pranešimai</strong><br />» %s',
	'LOG_FORUM_DEL_POSTS_FORUMS'	=> '<strong>Ištrintas forumas, visi jo pranešimai ir subforumai</strong><br />» %s',
	'LOG_FORUM_DEL_POSTS_MOVE_FORUMS'	=> '<strong>Ištrintas forumas ir visi jo pranešimai, subforumai perkelti</strong> į %1$s<br />» %2$s',
	'LOG_FORUM_EDIT'	=> '<strong>Pakeisti forumo duomenys</strong><br />» %s',
	'LOG_FORUM_MOVE_DOWN'	=> '<strong>Perkeltas forumas</strong> %1$s <strong>žemiau</strong> %2$s',
	'LOG_FORUM_MOVE_UP'	=> '<strong>Perkeltas forumas</strong> %1$s <strong>aukščiau</strong> %2$s',
	'LOG_FORUM_SYNC'	=> '<strong>Susinchronizuotas forumas</strong><br />» %s',
	'LOG_GROUP_CREATED'	=> '<strong>Sukurta nauja vartotojų grupė</strong><br />» %s',
	'LOG_GROUP_DEFAULTS'	=> '<strong>Grupė “%1$s” padaryta pagrindine nariams</strong><br />» %2$s',
	'LOG_GROUP_DELETE'	=> '<strong>Ištrinta vartotojų grupė</strong><br />» %s',
	'LOG_GROUP_DEMOTED'	=> '<strong>Pažeminti pareigose lyderiai vartotojų grupėje</strong> %1$s<br />» %2$s',
	'LOG_GROUP_PROMOTED'	=> '<strong>Nariai paskelbti lyderiais vartotojų grupėje</strong> %1$s<br />» %2$s',
	'LOG_GROUP_REMOVE'	=> '<strong>Pašalinti nariai iš vartotojų grupės</strong> %1$s<br />» %2$s',
	'LOG_GROUP_UPDATED'	=> '<strong>Pakeisti vartotojų grupės duomenys</strong><br />» %s',
	'LOG_MODS_ADDED'	=> '<strong>Pridėti nauji lyderiai į vartotojų grupę</strong> %1$s<br />» %2$s',
	'LOG_USERS_APPROVED'	=> '<strong>Patvirtinti vartotojai į vartotojų grupę</strong> %1$s<br />» %2$s',
	'LOG_USERS_ADDED'	=> '<strong>Pridėti nauji nariai į vartotojų grupę</strong> %1$s<br />» %2$s',
	'LOG_IMAGESET_ADD_DB'	=> '<strong>Į duomenų bazę pridėtas naujas paveikslėlių komplektas</strong><br />» %s',
	'LOG_IMAGESET_ADD_FS'	=> '<strong>Į failų sistemą pridėtas naujas paveikslėlių komplektas</strong><br />» %s',
	'LOG_IMAGESET_DELETE'	=> '<strong>Ištrintas paveikslėlių komplektas</strong><br />» %s',
	'LOG_IMAGESET_EDIT_DETAILS'	=> '<strong>Pakeisti paveikslėlių komplekto duomenys</strong><br />» %s',
	'LOG_IMAGESET_EDIT'	=> '<strong>Pakeistas paveikslėlių komplektas</strong><br />» %s',
	'LOG_IMAGESET_EXPORT'	=> '<strong>Išeksportuotas paveikslėlių komplektas</strong><br />» %s',
	'LOG_IMAGESET_LANG_MISSING'	=> '<strong>Paveikslėlių komplektui trūksta “%2$s” kalba išverstų paveikslėlių</strong><br />» %1$s',
	'LOG_IMAGESET_LANG_REFRESHED'	=> '<strong>Atnaujinta “%2$s” paveikslėlių komplekto kalba</strong><br />» %1$s',
	'LOG_IMAGESET_REFRESHED'	=> '<strong>Atnaujintas paveikslėlių komplektas</strong><br />» %s',
	'LOG_INACTIVE_ACTIVATE'	=> '<strong>Įjungti neaktyvūs vartotojai</strong><br />» %s',
	'LOG_INACTIVE_DELETE'	=> '<strong>Ištrinti neaktyvūs vartotojai</strong><br />» %s',
	'LOG_INACTIVE_REMIND'	=> '<strong>El. paštu išsiųstas priminimas neaktyviems vartotojams</strong><br />» %s',
	'LOG_INSTALL_CONVERTED'	=> '<strong>Sukonvertuota iš %1$s į %2$s</strong>',
	'LOG_INSTALL_INSTALLED'	=> '<strong>Įdiegtas forumas %s</strong>',
	'LOG_IP_BROWSER_FORWARDED_CHECK'	=> '<strong>Sesijos IP/naršyklės/X_FORWARDED_FOR antraštės patikrinimas nepavyko</strong><br />»Vartotojo IP “<em>%1$s</em>” sutikrintas su sesijos IP “<em>%2$s</em>”, vartotojo naršyklė “<em>%3$s</em>” sutikrinta su sesijos naršykle “<em>%4$s</em>”, o vartotojo X_FORWARDED_FOR antraštė “<em>%5$s</em>” sutikrinta su sesijos X_FORWARDED_FOR antrašte “<em>%6$s</em>”.',
	'LOG_JAB_CHANGED'	=> '<strong>Pakeistas Jabber vartotojo vardas</strong>',
	'LOG_JAB_PASSCHG'	=> '<strong>Pakeistas Jabber slaptažodis</strong>',
	'LOG_JAB_REGISTER'	=> '<strong>Užregistruotas Jabber vartotojo vardas</strong>',
	'LOG_JAB_SETTINGS_CHANGED'	=> '<strong>Pakeisti Jabber nustatymai</strong>',
	'LOG_LANGUAGE_PACK_DELETED'	=> '<strong>Ištrintas kalbos paketas</strong><br />» %s',
	'LOG_LANGUAGE_PACK_INSTALLED'	=> '<strong>Įdiegtas kalbos paketas</strong><br />» %s',
	'LOG_LANGUAGE_PACK_UPDATED'	=> '<strong>Atnaujintas kalbos paketo aprašymas</strong><br />» %s',
	'LOG_LANGUAGE_FILE_REPLACED'	=> '<strong>Pakeistas kalbos failas</strong><br />» %s',
	'LOG_LANGUAGE_FILE_SUBMITTED'	=> '<strong>Į saugojimo katalogą įrašytas kalbos failas</strong><br />» %s',
	'LOG_MASS_EMAIL'	=> '<strong>Išsiųstas el. paštas</strong><br />» %s',
	'LOG_MCP_CHANGE_POSTER'	=> '<strong>Pakeistas temos “%1$s” autorius</strong><br />» iš %2$s į %3$s',
	'LOG_MODULE_DISABLE'	=> '<strong>Išjungtas modulis</strong><br />» %s',
	'LOG_MODULE_ENABLE'	=> '<strong>Įjungtas modulis</strong><br />» %s',
	'LOG_MODULE_MOVE_DOWN'	=> '<strong>Žemyn perkeltas modulis</strong><br />» %1$s žemiau %2$s',
	'LOG_MODULE_MOVE_UP'	=> '<strong>Aukštyn perkeltas modulis</strong><br />» %1$s aukščiau %2$s',
	'LOG_MODULE_REMOVED'	=> '<strong>Ištrintas modulis</strong><br />» %s',
	'LOG_MODULE_ADD'	=> '<strong>Pridėtas modulis</strong><br />» %s',
	'LOG_MODULE_EDIT'	=> '<strong>Pakeistas modulis</strong><br />» %s',
	'LOG_A_ROLE_ADD'	=> '<strong>Sukurta administratoriaus rolė</strong><br />» %s',
	'LOG_A_ROLE_EDIT'	=> '<strong>Pakeista administratoriaus rolė</strong><br />» %s',
	'LOG_A_ROLE_REMOVED'	=> '<strong>Ištrinta administratoriaus rolė</strong><br />» %s',
	'LOG_F_ROLE_ADD'	=> '<strong>Sukurta forumo rolė</strong><br />» %s',
	'LOG_F_ROLE_EDIT'	=> '<strong>Pakeista forumo rolė</strong><br />» %s',
	'LOG_F_ROLE_REMOVED'	=> '<strong>Ištrinta forumo rolė</strong><br />» %s',
	'LOG_M_ROLE_ADD'	=> '<strong>Sukurta moderatoriaus rolė</strong><br />» %s',
	'LOG_M_ROLE_EDIT'	=> '<strong>Pakeista moderatoriaus rolė</strong><br />» %s',
	'LOG_M_ROLE_REMOVED'	=> '<strong>Ištrinta moderatoriaus rolė</strong><br />» %s',
	'LOG_U_ROLE_ADD'	=> '<strong>Sukurta vartotojo rolė</strong><br />» %s',
	'LOG_U_ROLE_EDIT'	=> '<strong>Pakeista vartotojo rolė</strong><br />» %s',
	'LOG_U_ROLE_REMOVED'	=> '<strong>Ištrinta vartotojo rolė</strong><br />» %s',
	'LOG_PROFILE_FIELD_ACTIVATE'	=> '<strong>Įjungtas aprašo laukas</strong><br />» %s',
	'LOG_PROFILE_FIELD_CREATE'	=> '<strong>Pridėtas aprašo laukas</strong><br />» %s',
	'LOG_PROFILE_FIELD_DEACTIVATE'	=> '<strong>Išjungtas aprašo laukas</strong><br />» %s',
	'LOG_PROFILE_FIELD_EDIT'	=> '<strong>Pakeistas aprašo laukas</strong><br />» %s',
	'LOG_PROFILE_FIELD_REMOVED'	=> '<strong>Ištrintas aprašo laukas</strong><br />» %s',
	'LOG_PRUNE'	=> '<strong>Išvalyti forumai</strong><br />» %s',
	'LOG_AUTO_PRUNE'	=> '<strong>Automatiškai išvalyti forumai</strong><br />» %s',
	'LOG_PRUNE_USER_DEAC'	=> '<strong>Išjungti vartotojai</strong><br />» %s',
	'LOG_PRUNE_USER_DEL_DEL'	=> '<strong>Išvalyti vartotojai ir ištrinti jų pranešimai</strong><br />» %s',
	'LOG_PRUNE_USER_DEL_ANON'	=> '<strong>Išvalyti vartotojai ir palikti jų pranešimai</strong><br />» %s',
	'LOG_PURGE_CACHE'	=> '<strong>Išvalytas kešas</strong>',
	'LOG_RANK_ADDED'	=> '<strong>Sukurtas naujas rangas</strong><br />» %s',
	'LOG_RANK_REMOVED'	=> '<strong>Ištrintas rangas</strong><br />» %s',
	'LOG_RANK_UPDATED'	=> '<strong>Atnaujintas rangas</strong><br />» %s',
	'LOG_REASON_ADDED'	=> '<strong>Pridėta raporto/blokavimo priežastis</strong><br />» %s',
	'LOG_REASON_REMOVED'	=> '<strong>Ištrinta raporto/blokavimo priežastis</strong><br />» %s',
	'LOG_REASON_UPDATED'	=> '<strong>Atnaujinta raporto/blokavimo priežastis</strong><br />» %s',
	'LOG_REFERER_INVALID'	=> '<strong>Šaltinio (referer) patikrinimas nepavyko</strong><br />»Šaltinis “<em>%1$s</em>”. Užklausa nutraukta, o sesija uždaryta.',
	'LOG_RESET_DATE'	=> '<strong>Iš naujo nustatyta diskusijų lentos starto data</strong>',
	'LOG_RESET_ONLINE'	=> '<strong>Išvalytas daugiausiai prisijungusių vartotojų skaičius</strong>',
	'LOG_RESYNC_POSTCOUNTS'	=> '<strong>Iš naujo suskaičiuoti vartotojo pranešimai</strong>',
	'LOG_RESYNC_POST_MARKING'	=> '<strong>Iš naujo pažymėtos temos su žvaigždute</strong>',
	'LOG_RESYNC_STATS'	=> '<strong>Iš naujo suskaičiuoti visi pranešimai, temos ir vartotojai</strong>',
	'LOG_SEARCH_INDEX_CREATED'	=> '<strong>Sukurtas paieškos indeksas</strong><br />» %s',
	'LOG_SEARCH_INDEX_REMOVED'	=> '<strong>Ištrintas paieškos indeksas</strong><br />» %s',
	'LOG_STYLE_ADD'	=> '<strong>Pridėtas naujas stilius</strong><br />» %s',
	'LOG_STYLE_DELETE'	=> '<strong>Ištrintas stilius</strong><br />» %s',
	'LOG_STYLE_EDIT_DETAILS'	=> '<strong>Pakeistas stilius</strong><br />» %s',
	'LOG_STYLE_EXPORT'	=> '<strong>Išeksportuotas stilius</strong><br />» %s',
	'LOG_TEMPLATE_ADD_DB'	=> '<strong>Į duomenų bazę pridėtas naujas šablonas</strong><br />» %s',
	'LOG_TEMPLATE_ADD_FS'	=> '<strong>Į failų sistemą pridėtas naujas šablonas</strong><br />» %s',
	'LOG_TEMPLATE_CACHE_CLEARED'	=> '<strong>Šablonų komplekte <em>%1$s</em> ištrinti kešuojami failai</strong><br />» %2$s',
	'LOG_TEMPLATE_DELETE'	=> '<strong>Ištrintas šablonų komplektas</strong><br />» %s',
	'LOG_TEMPLATE_EDIT'	=> '<strong>Pakeistas šablonų komplektas <em>%1$s</em></strong><br />» %2$s',
	'LOG_TEMPLATE_EDIT_DETAILS'	=> '<strong>Pakeistas šablono aprašymas</strong><br />» %s',
	'LOG_TEMPLATE_EXPORT'	=> '<strong>Išeksportuotas šablonų komplektas</strong><br />» %s',
	'LOG_TEMPLATE_REFRESHED'	=> '<strong>Atnaujintas šablonų komplektas</strong><br />» %s',
	'LOG_THEME_ADD_DB'	=> '<strong>Į duomenų bazę pridėta nauja tema</strong><br />» %s',
	'LOG_THEME_ADD_FS'	=> '<strong>Į failų sistemą pridėta nauja tema</strong><br />» %s',
	'LOG_THEME_DELETE'	=> '<strong>Ištrinta tema</strong><br />» %s',
	'LOG_THEME_EDIT_DETAILS'	=> '<strong>Pakeistas temos aprašymas</strong><br />» %s',
	'LOG_THEME_EDIT'	=> '<strong>Pakeista tema <em>%1$s</em></strong>',
	'LOG_THEME_EDIT_FILE'	=> '<strong>Pakeista tema <em>%1$s</em></strong><br />» Pakeistas failas <em>%2$s</em>',
	'LOG_THEME_EXPORT'	=> '<strong>Išeksportuota tema</strong><br />» %s',
	'LOG_THEME_REFRESHED'	=> '<strong>Atnaujinta tema</strong><br />» %s',
	'LOG_UPDATE_DATABASE'	=> '<strong>Atnaujinta duomenų bazė iš versijos %1$s į versiją %2$s</strong>',
	'LOG_UPDATE_PHPBB'	=> '<strong>Atnaujintas forumas iš versijos %1$s į versiją %2$s</strong>',
	'LOG_USER_ACTIVE'	=> '<strong>Vartotojas įjungtas</strong><br />» %s',
	'LOG_USER_BAN_USER'	=> '<strong>Užblokuotas vartotojas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_USER_BAN_IP'	=> '<strong>Užblokuotas IP adresas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_USER_BAN_EMAIL'	=> '<strong>Užblokuotas el. pašto adresas</strong> dėl “<em>%1$s</em>”<br />» %2$s',
	'LOG_USER_DELETED'	=> '<strong>Ištrintas vartotojas</strong><br />» %s',
	'LOG_USER_DEL_ATTACH'	=> '<strong>Ištrinti visi vartotojo prikabinti failai</strong><br />» %s',
	'LOG_USER_DEL_AVATAR'	=> '<strong>Ištrintas vartotojo avataras</strong><br />» %s',
	'LOG_USER_DEL_POSTS'	=> '<strong>Ištrinti visi vartotojo pranešimai</strong><br />» %s',
	'LOG_USER_DEL_SIG'	=> '<strong>Ištrintas vartotojo parašas</strong><br />» %s',
	'LOG_USER_INACTIVE'	=> '<strong>Išjungtas vartotojas</strong><br />» %s',
	'LOG_USER_MOVE_POSTS'	=> '<strong>Perkelti vartotojo pranešimai</strong><br />» vartotojo “%1$s” pranešimai į forumą “%2$s”',
	'LOG_USER_NEW_PASSWORD'	=> '<strong>Pakeistas vartotojo slaptažodis</strong><br />» %s',
	'LOG_USER_REACTIVATE'	=> '<strong>Priverstinis vartotojo vardo patvirtinimas</strong><br />» %s',
	'LOG_USER_UPDATE_EMAIL'	=> '<strong>Vartotojas “%1$s” pakeitė el. pašto adresą</strong><br />» iš “%2$s” į “%3$s”',
	'LOG_USER_UPDATE_NAME'	=> '<strong>Pakeistas vartotojo vardas</strong><br />» iš “%1$s” į “%2$s”',
	'LOG_USER_USER_UPDATE'	=> '<strong>Pakeisti vartotojo duomenys</strong><br />» %s',
	'LOG_USER_ACTIVE_USER'	=> '<strong>Aktyvuotas vartotojo vardas</strong>',
	'LOG_USER_DEL_AVATAR_USER'	=> '<strong>Ištrintas vartotojo avataras</strong>',
	'LOG_USER_DEL_SIG_USER'	=> '<strong>Ištrintas vartotojo parašas</strong>',
	'LOG_USER_FEEDBACK'	=> '<strong>Pridėtas atsiliepimas apie vartotoją</strong><br />» %s',
	'LOG_USER_GENERAL'	=> '<strong>Pridėtas įrašas:</strong><br />» %s',
	'LOG_USER_INACTIVE_USER'	=> '<strong>Išjungtas vartotojo vardas</strong>',
	'LOG_USER_LOCK'	=> '<strong>Vartotojas užrakino savo temą</strong><br />» %s',
	'LOG_USER_MOVE_POSTS_USER'	=> '<strong>Perkelti visi pranešimai į forumą</strong>» %s',
	'LOG_USER_REACTIVATE_USER'	=> '<strong>Priverstinis vartotojo vardo patvirtinimas</strong>',
	'LOG_USER_UNLOCK'	=> '<strong>Vartotojas atrakino savo temą</strong><br />» %s',
	'LOG_USER_WARNING'	=> '<strong>Perspėtas vartotojas</strong><br />» %s',
	'LOG_USER_WARNING_BODY'	=> '<strong>Vartotojas perspėtas dėl</strong><br />» %s',
	'LOG_USER_GROUP_CHANGE'	=> '<strong>Vartotojas pakeitė savo pagrindinę grupę</strong><br />» %s',
	'LOG_USER_GROUP_DEMOTE'	=> '<strong>Vartotojas nebe vartotojų grupės lyderis</strong><br />» %s',
	'LOG_USER_GROUP_JOIN'	=> '<strong>Vartotojas prisijungė į grupę</strong><br />» %s',
	'LOG_USER_GROUP_JOIN_PENDING'	=> '<strong>Vartotojas prisijungę į grupę ir turi būti patvirtintas</strong><br />» %s',
	'LOG_USER_GROUP_RESIGN'	=> '<strong>Vartotojas atsijungė nuo grupės</strong><br />» %s',
	'LOG_WORD_ADD'	=> '<strong>Pridėtas naujas cenzūruojamas žodis</strong><br />» %s',
	'LOG_WORD_DELETE'	=> '<strong>Ištrintas cenzūruojamas žodis</strong><br />» %s',
	'LOG_WORD_EDIT'	=> '<strong>Pakeistas cenzūruojamas žodis</strong><br />» %s',
));

?>