<?php
/**
*Naujienų valdymas
*
*Naujienų formavimas
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Naujienų valdymas
*
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class News
{
	/**
	*Gražinamas visų naujienų abstraktų asociatyvus masyvas
	*@return Array naujienų abstraktų asociatyvus masyvas
	*/
	public function getAllNews()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id, abstract_lt, abstract_en, abstract_ru, article_time from news order by article_time desc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: News->getAllNews()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas pasirinktos naujienos (Lietuvių, Anglų, Rusų kalbomis) masyvas
	*@param Integer $newsID Naujienos identifikacinis numeris
	*@return Array pasirinktos naujienos (Lietuvių, Anglų, Rusų kalbomis) masyvas
	*/
	public function getNews($newsID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select article_text_lt, article_text_en, article_text_ru, article_time, abstract_lt, abstract_en, abstract_ru from news where id='.$newsID.' order by article_time desc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: News->getNews()');
		}
		$res->fetchInto($news);
		$db->disconnect();
		return $news;
	}
	
	/**
	*
	*Ištrinama naujiena
	*@param Integer $newID Naujienos identifikacinis numeris
	*@return void
	*/
	public function removeNews($newID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$result= $db->query('delete from news where id='.$newID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: News->removeNews()');
		}
		$db->disconnect();
	}
	
	/**
	*Atnaujinami Naujienos duomenys
	*@param Integer $newsID Naujienos identifikacinis numeris
	*@param String $article_text_lt Straipsnio tekstas lietuviškai
	*@param String $article_text_en Straipsnio tekstas angliškai
	*@param String $article_text_ru Straipsnio tekstas rusiškai
	*@param String $abstract_lt Straipsnio abstraktus tekstas lietuviškai
	*@param String $abstract_en Straipsnio abstraktus tekstas angliškai
	*@param String $abstract_ru Straipsnio abstraktus tekstas rusiškai
	*/
	public function updateNews($articleID,$article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru)
	{
		//echo "$articleID,$article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update news set article_text_lt=?,article_text_en=?,article_text_ru=?, article_time=(select CURRENT_TIMESTAMP), abstract_lt=?, abstract_en=?, abstract_ru=? where id=?');
		$data = array($article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru,$articleID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: News->updateNews()');
		}
		$db->disconnect();
	}
	
	/**
	*Sukuriama naujiena
	*@param String $article_text_lt Straipsnio tekstas lietuviškai
	*@param String $article_text_en Straipsnio tekstas angliškai
	*@param String $article_text_ru Straipsnio tekstas rusiškai
	*@param String $abstract_lt Straipsnio abstraktus tekstas lietuviškai
	*@param String $abstract_en Straipsnio abstraktus tekstas angliškai
	*@param String $abstract_ru Straipsnio abstraktus tekstas rusiškai
	*/
	public function insertNews($article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru)
	{
		//echo "$articleID,$article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru";
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into news (article_text_lt, article_text_en,article_text_ru, abstract_lt, abstract_en, abstract_ru ) values (?,?,?,?,?,?)');
		$data = array($article_text_lt,$article_text_en,$article_text_ru,$abstract_lt,$abstract_en,$abstract_ru);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: News->insertNews()');
		}
		$db->disconnect();
	}
}

/*
$a = new CompaniesInterface();
print_r($a->getPracticeJobStudent(2));
*/
?>
