<?php
/**
*Prisijungimo prie DBVS valdymas

*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/

/**
* Prijungiama DB.php PEAR klasių biblioteka
*/
require_once('DB.php');

/** 
* RDBVS iniciacija
*
* Prisijungimo nustatymo klasė
*@copyright Copyright 2006, Mindaugas Rimkus
*/
class ConnectManager
{
	/**
	*DNS prisijungimas prie DB
	*@var String DNS String eilutė
	*/
	private $dsn = 'pgsql://grafozubovo_lt:takistas53s2@127.0.0.1/grafozubovo_lt';
	
	/**
	*Prisijungimo ir portatyvimo parametrų masyvas
	*@var Array Prisijungimo parametrai
	*/
	private $options = array(
    						'debug'       => 2,
   							'portability' => DB_PORTABILITY_ALL,
							);		

	/**
	*DB prisijungimo objektas
	*@var Object Prisijungimo prie duomenų bazės objektas
	*/
	private $db;
	
	/**
	*Klasės konstruktorius 
	*
	*Inicijuojamas prisijungimas prie duomenų bazės
	*/
	public function __construct()
	{

		$this->db = DB::connect($this->dsn, $this->options);
		if (PEAR::isError($this->db)) {
			die('ConnectManager->__construct: '.$this->db->getMessage());
		}
	}
	/**
	*Gražinamas prisijungimo objektas
	*@return Object Prisijungimo objektas
	*/
	public function getConnect()
	{
		return $this->db;
	}
}
?>
