<?php
header( "Expires: Mon, 26 Jul 1997 05:00:00 GMT" );  // disable IE caching
header( "Last-Modified: " . gmdate( "D, d M Y H:i:s" ) . " GMT" ); 
header( "Cache-Control: no-cache, must-revalidate" ); 
header( "Pragma: no-cache" );

$splitter = md5("JA Headline");
define( '_VALID_MOS', 1 );

chdir ('../..');
include_once( "configuration.php" );
include_once( "includes/joomla.php" );
include_once( "includes/database.php" );

include_once( $mosConfig_absolute_path .'/language/' . $mosConfig_lang . '.php' );

require_once( $mosConfig_absolute_path .'/includes/sef.php' );
require_once( $mosConfig_absolute_path .'/includes/frontend.php' );

if (!isset($_GET['news']) || !isset($_GET['total'])) exit;

$news = $_GET['news'];
$total = $_GET['total'];

$charset = array(
   "CHARSET=ISO-8859-1" => "ISO8859-1",
   "CHARSET=ISO8859-1" => "ISO8859-1",
   "CHARSET=ISO-8859-15" => "ISO8859-15",
   "CHARSET=ISO8859-15" => "ISO8859-15",
   "CHARSET=UTF-8" => "UTF-8",
   "CHARSET=CP866" => "ibm866",
   "CHARSET=866" => "ibm866",
   "CHARSET=IBM866" => "ibm866",
   "CHARSET=CP1251" => "Windows-1251",
   "CHARSET=WINDOWS-1251" => "Windows-1251",
   "CHARSET=WIN-1251" => "Windows-1251",
   "CHARSET=1251" => "Windows-1251",
   "CHARSET=CP1252" => "Windows-1252",
   "CHARSET=WINDOWS-1252" => "Windows-1252",
   "CHARSET=1252" => "Windows-1252",
   "CHARSET=KOI8-R" => "koi8-ru",
   "CHARSET=KOI8-RU" => "koi8-ru",
   "CHARSET=KOI8R" => "koi8-ru",
   "CHARSET=BIG5" => "950",
   "CHARSET=950" => "950",
   "CHARSET=GB2312" => "936",
   "CHARSET=936" => "936",
   "CHARSET=BIG5-HKSCS" => "BIG5-HKSCS",
   "CHARSET=SHIFT_JIS" => "SJIS",
   "CHARSET=SJIS" => "SJIS",
   "CHARSET=932" => "SJIS",
   "CHARSET=EUC-JP" => "EUCJP",
   "CHARSET=EUCJP" => "EUCJP"
);

$current_charset = isset($charset[strtoupper(_ISO)]) ? $charset[strtoupper(_ISO)] : "";

$option = strval( strtolower( mosGetParam( $_REQUEST, 'option' ) ) );
$mainframe = new mosMainFrame( $database, $option, '.' );
$mainframe->initSession();
$now 		= _CURRENT_SERVER_TIME;
$access 	= !$mainframe->getCfg( 'shownoauth' );
$nullDate 	= $database->getNullDate();
$my = $mainframe->getUser();
$gid = intval( $my->gid );
$db = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );

$query = "SELECT a.images, a.introtext, a.id, a.title, a.sectionid, a.catid, cc.title as cattitle"
			. "\n FROM #__content AS a"
			. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
			. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
			. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
			. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
			. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
			. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
			. "\n AND cc.published = 1 )"
			. "\n ORDER BY f.ordering ASC limit ". ($news - 1) .", 1";
$database->setQuery($query);
$firstnew = null;
$database->loadObject($firstnew);

$Itemid = $mainframe->getItemid( $firstnew->id, 0, 0, 1, 1, 1 );
if ($Itemid == NULL) {
	$Itemid = '';
} else {
	$Itemid = '&amp;Itemid='. $Itemid;
}
$link = sefRelToAbs( 'index.php?option=com_content&amp;task=view&amp;id='. $firstnew->id . $Itemid );

$image = replaceImage ($firstnew, 0, 1);
echo "<div class=\"ja-newscontent\">\n";
echo $image. "\n";

echo "<a href=\"$link\" class=\"ja-newstitle\" title=\"".textprocess($firstnew->title)."\">".textprocess($firstnew->title)."</a>\n";
echo unhtmlentities(textprocess($firstnew->introtext)) . "\n</div>\n";
echo "<a href=\"$link\" class=\"readon\">".textprocess(_READ_MORE)."</a>";
echo "</div>";
		
$query = "SELECT a.title"
		. "\n FROM #__content AS a"
		. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
		. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
		. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
		. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
		. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
		. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
		. "\n AND cc.published = 1 )"
		. "\n ORDER BY f.ordering ASC limit ".(($news < $total) ? $news : 0).", 1";
$database->setQuery($query);
$nexttitle = $database->loadResult();

$query = "SELECT a.title"
		. "\n FROM #__content AS a"
		. "\n INNER JOIN #__content_frontpage AS f ON f.content_id = a.id"
		. "\n INNER JOIN #__categories AS cc ON cc.id = a.catid"
		. "\n WHERE ( a.state = 1 AND a.sectionid > 0 "
		. "\n AND ( a.publish_up = '$nullDate' OR a.publish_up <= '$now' )"
		. "\n AND ( a.publish_down = '$nullDate' OR a.publish_down >= '$now' )"
		. ( $access ? "\n AND a.access <= $my->gid AND cc.access <= $my->gid" : '' )
		. "\n AND cc.published = 1 )"
		. "\n ORDER BY f.ordering ASC limit ". (($news > 1) ? $news - 2 : $total - 1) .", 1";
$database->setQuery($query);
$prevtitle = $database->loadResult();

echo $splitter.textprocess($nexttitle).$splitter.textprocess($prevtitle);
		
	function replaceImage( &$row, $maxchars, $showimage, $width = -1, $height = -1 ) {
		global $database, $_MAMBOTS, $current_charset;

		// expression to search for
		$regex = '/{mosimage\s*.*?}/i';	

		$image = $showimage?processImage ( $row, $width, $height ):"";
		$row->introtext = trim($row->introtext);
		$row->introtext = preg_replace( $regex, '', $row->introtext );

	  //Trim HTML tags to get text only.
		//$regex_p = "/<[^>]*>/";
		//$row->introtext1 = preg_replace( $regex_p, '', $row->introtext );    
		$row->introtext1 = strip_tags($row->introtext);
		$row->introtext1 = trim(htmlentities($row->introtext1, ENT_NOQUOTES, $current_charset));
		if ($maxchars && strlen ($row->introtext) > $maxchars) {
			$row->introtext1 = substr ($row->introtext1, 0, $maxchars) . "...";
		}
		// clean up globals
		return $image;
	}

	function processImage ( &$row, $width, $height ) {
		global $mosConfig_absolute_path, $mosConfig_live_site;

		// split on \n the images fields into an array
		$row->images 	= explode( "\n", $row->images );
		$img = trim( $row->images[0] );

		// split on pipe the attributes of the image
		if ( $img ) {
			$attrib = explode( '|', trim( $img ) );
			// $attrib[0] image name and path from /images/stories

			// $attrib[1] alignment
			if ( !isset($attrib[1]) || !$attrib[1] ) {
				$attrib[1] = '';
			}

			// $attrib[2] alt & title
			if ( !isset($attrib[2]) || !$attrib[2] ) {
				$attrib[2] = 'Image';
			} else {
				$attrib[2] = htmlspecialchars( $attrib[2] );
			}

			// $attrib[3] border
			if ( !isset($attrib[3]) || !$attrib[3] ) {
				$attrib[3] = 0;
			}

			$attrib[4]	= '';
			$border 	= 0;

			// $attrib[5] caption position
			if ( !isset($attrib[5]) || !$attrib[5] ) {
				$attrib[5] = '';
			}

			// $attrib[6] caption alignment
			if ( !isset($attrib[6]) || !$attrib[6] ) {
				$attrib[6] = '';
			}

			// image size attibutes

			// assemble the <image> tag
			$image = '<img src="'. $mosConfig_live_site .'/images/stories/'. $attrib[0] .'"';
			// no aligment variable - if caption detected
			if ( !$attrib[4] ) {
				$image .= $attrib[1] ? ' align="'. $attrib[1] .'"' : '';
			}
			$image .=' alt="'. $attrib[2] .'" title="'. $attrib[2] .'" border="'. $border .'" '. (($width != -1) ? 'width="'. $width . '"' : '') .(($height != -1) ? ' height="'. $height .'"' : '').' />';

			$img = $image;
		}
		return $img;
	}
   
   function unhtmlentities($string) 
   {
		 $trans_tbl = array("&lt;" => "<", "&gt;" => ">", "&amp;" => "&");
       return strtr($string, $trans_tbl);
   }
	
	function textprocess($string) {
		global $current_charset;
		if ($current_charset == "UTF-8") return $string;
		else if (function_exists("iconv")) return iconv(str_replace("CHARSET=", "", strtoupper(_ISO)), "UTF-8", $string);
		else if ($current_charset) return htmlentities($string, ENT_NOQUOTES, $current_charset);
		else return $string;
	}
?>