<?php
/**
*Ložių užsakymų valdymas
*
*@author Mindaugas Rimkus <mr@esu.as>
*@copyright Copyright 2006, Mindaugas Rimkus
*/
/**

/**
* Prijungiama ConnectManager.class.php prisijungimo prie duomenų bazės klasių biblioteka
*/
require_once('ConnectManager.class.php');


/** 
* Ložių užsakymų  valdymas
*
*@copyright Copyright 2007, Mindaugas Rimkus
*/
class LodgeOrders
{

	/**
	*Gražinamas visų įmonių duomenų masyvas
	*@param String $search paieškos sąlyga
	*@return Array visų įmonių duomenų asociatyvus masyvas
	*/
	public function getCompanies($search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select id,name,code,vat_code,address,phone,fax,email,published from companies where lower(id || name || code ||  COALESCE(vat_code,\'\') ||  COALESCE(address,\'\') || phone || COALESCE(fax,\'\') || COALESCE(email,\'\')) like \'%'.$search.'%\' order by name asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getCompanies()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Pakeičiamas įmonės publikavimo statusas
	*@param Integer $company_id Įmonės identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateCompanyPublication($company_id,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies set published=? where id=?');
		$data = array($pubStatus,$company_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateCompanyPublication()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Ištrinama įmonė
	*@param Integer ARRAY $companiesIDS įmonių identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeCompanies($companiesIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($companiesIDS); $i++) {
			if ($i != count($companiesIDS) - 1) {
				$whereClause .= 'id='.$companiesIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$companiesIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from companies where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->removeCompanies()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*
	*
	*Įmonės kodo tikrinimas
	*@param String $digit Skaičius
	*@return Boolean true - valid $digit, false - Invalid
	*/
	public function checkCompanyCode($digit)
	{
		$digit = trim($digit);
		
		if (preg_match("/\d{9}/",$digit)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*
	*
	*Įmonės PVM kodo tikrinimas
	*@param String $vatCode Skaičius
	*@return Boolean true - valid $vatCode, false - Invalid
	*/
	public function checkCompanyVATCode($vatCode)
	{
		$vatCode = trim($vatCode);
		
		if (preg_match("/LT\d{7,20}/i",$vatCode)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Elektronio pašto adreso tikrinimas
	*
	*Tikrinama ar elektroninis paštas sudarytas pagal taisykles
	*@param String $email elektroninio pašto adresas
	*@return Boolean true - valid $email, false - Invalid
	*/
	public function checkEmail($email) 
	{
		$email = trim($email);
		if (preg_match("/^[a-zA-Z][\w\.-]*[a-zA-Z0-9]@[a-zA-Z0-9][\w\.-]*[a-zA-Z0-9]\.[a-zA-Z][a-zA-Z\.]*[a-zA-Z]$/",$email)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Telefono tikrinimas
	*
	*Tikrinama ar telefono numeris sudarytas tinkamai
	*@param String $phone telefono numeris
	*@return Boolean true - valid $phone, false - Invalid
	*/
	public function checkPhone($phone) 
	{
		$phone = trim($phone);
		if (preg_match("/^[+\d][\d]+[\d]$/",$phone)) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Sukuriama įmonė
	*@param String $companyName Įmonės pavadinimas
	*@param Integer $companyCode Įmonės kodas
	*@param String $companyVATcode Įmonės PVM kodas
	*@param String $companyPhone Įmonės telefonas
	*@param String $companyFax Įmonės faksas
	*@param String $companyEmail Įmonės email
	*@param String $companyAddress Įmonės adresas
	*@param String $published Įmonės publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function insertCompany($companyName,$companyCode,$companyVATcode,$companyPhone,$companyFax,$companyEmail,$companyAddress,$published)
	{
		if (strlen(trim($companyVATcode)) == 0) {
			$companyVATcode = null;
		}
		if (strlen(trim($companyFax)) == 0) {
			$companyFax = null;
		}
		if (strlen(trim($companyEmail)) == 0) {
			$companyEmail = null;
		}
		if (strlen(trim($companyAddress)) == 0) {
			$companyAddress = null;
		}
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into companies (name,code,vat_code,address,phone,fax,email,published) values (?,?,?,?,?,?,?,?)');
		$data = array($companyName,$companyCode,$companyVATcode,$companyAddress,$companyPhone,$companyFax,$companyEmail,$published);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->insertCompany()');
		}

		$db->disconnect();
	}
	
	/**
	*
	*
	*Tikrinama ar neegzistuoja įmonė
	*@param String $company_name Įmonės pavadinimas
	*@param Integer $company_code Įmonės kodas
	*@param Integer $companyID Ši įmonės bus praleista tikrinimo metu
	*@return Boolean true - egzistoja, false - neegzistuoja
	*/
	public function checkCompanyExistence($company_name,$company_code,$companyID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$company_name = trim($company_name);
		$company_code = trim($company_code);
	
		if (strlen($company_code) == 0) {
			$result= $db->query('select id from companies where name=\''.$company_name.'\' and id<>'.$companyID);
		} else {
			$result= $db->query('select id from companies where (name=\''.$company_name.'\' or code=\''.$company_code.'\') and id<>'.$companyID);
		}
		
		if (PEAR::isError($result)) {
			//echo $result->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->checkCompanyExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Gražinami pasirinktos įmonės duomenys
	*@param Integer $companyID
	*@return Array pasirinktos įmonės duomenys
	*/
	public function getCompanyData($companyID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id,name,code,vat_code,address,phone,fax,email,published from companies where id='.$companyID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: LodgeOrders->getCompanyData()');
		}
		$res->fetchInto($companyData);
		$db->disconnect();
		return $companyData;
	}
	
	/**
	*Atnaujinami įmonės duomenys
	*@param Integer $companyID Įmonės identifikacinis numeris
	*@param String $companyName Įmonės pavadinimas
	*@param Integer $companyCode Įmonės kodas
	*@param String $companyVATcode Įmonės PVM kodas
	*@param String $companyPhone Įmonės telefonas
	*@param String $companyFax Įmonės faksas
	*@param String $companyEmail Įmonės email
	*@param String $companyAddress Įmonės adresas
	*@param String $published Įmonės publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function updateCompany($companyID,$companyName,$companyCode,$companyVATcode,$companyPhone,$companyFax,$companyEmail,$companyAddress,$published)
	{
		if (strlen(trim($companyVATcode)) == 0) {
			$companyVATcode = null;
		}
		if (strlen(trim($companyFax)) == 0) {
			$companyFax = null;
		}
		if (strlen(trim($companyEmail)) == 0) {
			$companyEmail = null;
		}
		if (strlen(trim($companyAddress)) == 0) {
			$companyAddress = null;
		}
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies set name=?,code=?,vat_code=?,address=?,phone=?,fax=?,email=?,published=? where id=?');
		$data = array($companyName,$companyCode,$companyVATcode,$companyAddress,$companyPhone,$companyFax,$companyEmail,$published,$companyID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateCompany()');
		}

		$db->disconnect();
	}
	

	
	
	//PRASIDEDA companies_persons metodai
	
	
	/**
	*Gražinami visi įmonės asmenys masyve
	*@param String $search paieškos sąlyga
	*@param Integer $companyID įmonės identifikacinis numeris (Jie 0 tuomet rodyti visų įmonių)
	*@return Array visi įmonės asmenys assoc masyve
	*/
	public function getCompaniesPersons($companyID,$search)
	{
		$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if ($companyID != 0) {
			$data = $db->getAssoc('select loge_customers.id,loge_customers.username,loge_customers.password,loge_customers.firstname,loge_customers.lastname,loge_customers.phone,loge_customers.email,loge_customers.company_id,loge_customers.published,companies.name,companies.code from loge_customers,companies where companies.id='.$companyID.' and lower(loge_customers.username || loge_customers.password || loge_customers.firstname || loge_customers.lastname || loge_customers.phone ||  COALESCE( loge_customers.email,\'\')) like \'%'.$search.'%\' and  loge_customers.company_id=companies.id order by loge_customers.firstname asc');
		} else {
			$data = $db->getAssoc('select loge_customers.id,loge_customers.username,loge_customers.password,loge_customers.firstname,loge_customers.lastname,loge_customers.phone,loge_customers.email,loge_customers.company_id,loge_customers.published,companies.name,companies.code from loge_customers,companies where lower(loge_customers.username || loge_customers.password || loge_customers.firstname || loge_customers.lastname || loge_customers.phone ||  COALESCE( loge_customers.email,\'\')) like \'%'.$search.'%\' and  loge_customers.company_id=companies.id order by loge_customers.firstname asc');
		}
		
		if (PEAR::isError($data)) {
			echo $data->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getCompaniesPersons()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Pakeičiamas įmonės atsakingo žmogaus publikavimo statusas
	*@param Integer $companyPersonIDpub Įmonės atsakingo žmogaus identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateCompanyPersonPublication($companyPersonIDpub,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update loge_customers set published=? where id=?');
		$data = array($pubStatus,$companyPersonIDpub);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateCompanyPersonPublication()');
		}
		$db->disconnect();
	}
	
	/**
	*
	*Ištrinami įmonės atsakingi asmenys
	*@param Integer ARRAY $companiesPersonsIDS įmonių atsakingų asmenų už ložių rezervavimą identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeCompaniesPersons($companiesPersonsIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($companiesPersonsIDS); $i++) {
			if ($i != count($companiesPersonsIDS) - 1) {
				$whereClause .= 'id='.$companiesPersonsIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$companiesPersonsIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from loge_customers where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->removeCompaniesPersons()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*
	*
	*Tikrinama ar neegzistuoja įmonės atsakingas žmogus
	*@param String $companyPersonUsername Įmonės atsakingo žmogaus vartotojo vardas
	*@param Integer $companyPersonID Šis įmonės atsakingas žmogaus bus praleidžiamas tikrinimo metu
	*@return Boolean true - egzistoja, false - neegzistuoja
	*/
	public function checkCompanyPersonExistence($companyPersonUsername,$companyPersonID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$companyPersonUsername = trim($companyPersonUsername);
		
		
		$result= $db->query('select id from loge_customers where username=\''.$companyPersonUsername.'\' and id<>'.$companyPersonID);
		
		
		if (PEAR::isError($result)) {
			//echo $result->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->checkCompanyPersonExistence()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	
	/**
	*Sukuriamas įmonės atsakingas asmuo
	*@param Integer $choisedCompany Šiai įmonei bus priskirtas asmuo
	*@param String $firstname Vardas
	*@param String $lastname Pavardė
	*@param String $phone Asmens telefonas
	*@param String $email El. pašto adresas
	*@param String $username Vartotojo vardas
	*@param String $password Slaptažodis
	*@param String $published Įmonės atsakingo asmens publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function insertCompanyPerson($choisedCompany,$firstname,$lastname,$phone,$email,$username,$password,$published)
	{
		if (strlen(trim($email)) == 0) {
			$email = null;
		}
	
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into loge_customers (username,password,firstname,lastname,phone,email,company_id,published) values (?,?,?,?,?,?,?,?)');
		$data = array($username,$password,$firstname,$lastname,$phone,$email,$choisedCompany,$published);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->insertCompanyPerson()');
		}

		$db->disconnect();
	}
	
	/**
	*Gražinamas pasirinkto įmonės atsakingo asmens duomenys
	*@param Integer $companyPersonID įmonės atsakingo asmens identifikacinis numeris
	*@return Array pasirinkto įmonės atsakingo asmens duomenų masyvas
	*/
	public function getCompanyPersonData($companyPersonID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id,username,password,firstname,lastname,phone,email,company_id,published from loge_customers where id='.$companyPersonID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: LodgeOrders->getCompanyPersonData()');
		}
		$res->fetchInto($companyPersonData);
		$db->disconnect();
		return $companyPersonData;
	}
	
	
	/**
	*Atnaujinamas įmonės atsakingas asmuo
	*@param Integer $company_person_id Keičiamo įmonės atsakingo asmens identifikacinis numeris
	*@param Integer $choisedCompany Šiai įmonei bus priskirtas asmuo
	*@param String $firstname Vardas
	*@param String $lastname Pavardė
	*@param String $phone Asmens telefonas
	*@param String $email El. pašto adresas
	*@param String $username Vartotojo vardas
	*@param String $password Slaptažodis
	*@param String $published Įmonės atsakingo asmens publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function updateCompanyPerson($company_person_id,$choisedCompany,$firstname,$lastname,$phone,$email,$username,$password,$published)
	{
		if (strlen(trim($email)) == 0) {
			$email = null;
		}
	
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update loge_customers set username=?,password=?,firstname=?,lastname=?,phone=?,email=?,company_id=?,published=? where id=?');
		$data = array($username,$password,$firstname,$lastname,$phone,$email,$choisedCompany,$published,$company_person_id);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateCompanyPerson()');
		}

		$db->disconnect();
	}	
	
	//PRASIDEDA assigned_lodges metodai
	
	
	/**
	*Gražinami visos ložės ir kabinos priskirtos įmonei masyve
	*@param Integer $lodgeNumber ložės arba kabinos numeris (Jie 0 tuomet rodyti visos ložės ir kabinos rodomos)
	*@param Integer $companyID Įmonės identifikacinis numeris (Jie 0 tuomet rodyti visas įmones)
	*@param Integer $lodgeType 1 - ložė; 2 - kabina; 0 - abi
	*@return Array visos ložės ir kabinos priskirtos įmonei assoc masyve
	*/
	public function getCompaniesLodges($lodgeNumber,$companyID,$lodgeType)
	{
		$lodgeNumber = trim($lodgeNumber);
		$companyID = trim($companyID);
		$lodgeType = trim($lodgeType);
		//echo "$lodgeNumber"."<br />";
		//echo "$companyID"."<br />";
		//echo "$lodgeType"."<br />";
		
		if (strlen($lodgeNumber) == 0) {
			$lodgeNumber = '%';
		}
		if (strlen($companyID) == 0) {
			$companyID = '%';
		}
		if (strlen($lodgeType) == 0) {
			$lodgeType = '%';
		}
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$data = $db->getAssoc('select companies_loges.id,companies.id,companies.name,companies.code,loges.loge_number,loges.type,companies_loges.published from companies_loges,companies,loges where companies_loges.company_id=companies.id and companies_loges.loge_id=loges.id and trim(to_char(loges.type,\'999999999999\')) like \''.$lodgeType.'\' and  trim(to_char(companies.id,\'999999999999\')) like \''.$companyID.'\' and trim(to_char(loges.loge_number,\'999999999999\')) like \''.$lodgeNumber.'\' order by loge_number');
	
		
		if (PEAR::isError($data)) {
			echo $data->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getCompaniesLodges()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Pakeičiamas įmonei priskirtos ložės arba kabinos publikavimo statusas
	*@param Integer $companyLodgeIDPub Įmonei priskirtos ložės arba kabinos identifikacinis numeris
	*@param bool $current_status Esamas publikavimo statusas
	*/
	public function updateCompanyLodgePublication($companyLodgeIDPub,$current_status)
	{
		if ($current_status == 'f') {
			$pubStatus = true;
		} else {
			$pubStatus = false;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies_loges set published=? where id=?');
		$data = array($pubStatus,$companyLodgeIDPub);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateCompanyPersonPublication()');
		}
		$db->disconnect();
	}
	
	/**
	*Gražinamas visų skirtingų įmonių duomenų, kuriuos turi ložes arba kabinas masyvas
	*@return Array visų skirtingų įmonių duomenų, kuriuos turi ložes arba kabinas assoc masyvas
	*/
	public function getDistinctCompaniesFromCompaniesLoges()
	{
		//$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select companies.id,companies.name,companies.code from companies_loges,companies,loges where companies_loges.company_id=companies.id and companies_loges.loge_id=loges.id order by companies.name');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctCompaniesFromCompaniesLoges()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų ložių numerių, kurios priskirto įmonėms masyvas
	*@return Array visų skirtingų ložių numerių, kurios priskirto įmonėms masyvas
	*/
	public function getDistinctLodgesNumbersFromCompaniesLoges()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct(loges.loge_number) from companies_loges,companies,loges where companies_loges.company_id=companies.id and companies_loges.loge_id=loges.id order by loges.loge_number asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesNumbersFromCompaniesLoges()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas visų skirtingų tipų, kurios priskirto įmonėms masyvas
	*@return Array visų skirtingų tipų, kurios priskirto įmonėms masyvas
	*/
	public function getDistinctLodgesTypesFromCompaniesLoges()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct(loges.type) from companies_loges,companies,loges where companies_loges.company_id=companies.id and companies_loges.loge_id=loges.id order by loges.type asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesTypesFromCompaniesLoges()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*
	*Ištrinamos įmonės priskirto ložės arba kabinos
	*@param Integer ARRAY $companiesLogesIDS įmonei priskirtų ložių arba kabinų identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeCompaniesLoges($companiesLogesIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($companiesLogesIDS); $i++) {
			if ($i != count($companiesLogesIDS) - 1) {
				$whereClause .= 'id='.$companiesLogesIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$companiesLogesIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from companies_loges where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->removeCompaniesPersons()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*Gražinamas visų skirtingų ložių numerių esančių sistemojė masyvas
	*@return Array visų skirtingų ložių numerių esančių sistemojė masyvas
	*/
	public function getAllDistinctLodgesNumbersLoges()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id,loge_number from loges order by loge_number asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getAllDistinctLodgesNumbersLoges()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	

	/**
	*
	*
	*Tikrinama ar neegzistuoja įmonei priskirta ložė su nurodytu ložės ID
	*@param Integer $assigmentID Priskyrimo ložės įmonei identifikacinis numeris, šis ID bus praleistas tikrinimo metu
	*@param Integer $companyID įmonės identifikacinis numeris
	*@param Integer $lodgeID Ložės arba kabinos identifikacinis numeris
	*@return Boolean true - egzistoja, false - neegzistuoja
	*/
	public function checkLodgeAssigment($assigmentID,$companyID,$lodgeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$assigmentID = trim($assigmentID);
		$companyID = trim($companyID);
		$lodgeID = trim($lodgeID);
		
		
		$result = $db->query('select id from companies_loges where company_id='.$companyID.' and loge_id='.$lodgeID.' and id<>'.$assigmentID);
		
		
		if (PEAR::isError($result)) {
			//echo $result->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->checkLodgeAssigment()');
		}
		$db->disconnect();
		if ($result->numRows()) {
			return true;
		} else {
			return false;
		}
	}
	
	/**
	*Gražinamas ložės identifikacinis numeris
	*@param Integer $lodgeNumber Ložės numeris
	*@return Integer ložės identifikacinis numeris
	*/
	public function getLodgeID($lodgeNumber)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select id from loges where loge_number='.$lodgeNumber);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getLodgeID()');
		}
		
		$res->fetchInto($row);
		    
		
		$db->disconnect();
		return $row[0];
		
	}
	
	/**
	*Įmonei priskiriama ložė arba kabina
	*@param Integer $companyID Įmonės identifikacinis numeris
	*@param String $logeID Ložės identifikacinis numeris
	*@param String $published publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function insertCompanyLodge($companyID,$logeID,$published)
	{		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('insert into companies_loges (company_id,loge_id,published) values (?,?,?)');
		$data = array($companyID,$logeID,$published);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->insertCompanyLodge()');
		}

		$db->disconnect();
	}
	
	/**
	*Gražinamas įmonės ložės arba kabinos duomenys
	*@param Integer $companyLodgeID įmonei priskirtos ložės arba kabinos identifikacinis numeris
	*@return Array įmonės pasirinktos ložės arba kabinos duomenų masyvas
	*/
	public function getCompanyLodgeData($companyLodgeID)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$res = $db->query('select id,company_id,loge_id,published from companies_loges where id='.$companyLodgeID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			//echo $res->getDebugInfo();
			die('Kritinė klaida: LodgeOrders->getCompanyLodgeData()');
		}
		$res->fetchInto($companyLodgeData);
		$db->disconnect();
		return $companyLodgeData;
	}
	
	/**
	*Atnaujinamas įmonei priskiriamos ložės arba kabinos duomenys
	*@param Integer $assigmentID Priskirtos ložės arba kabinos identifikacinis numeris
	*@param Integer $companyID Įmonės identifikacinis numeris
	*@param String $logeID Ložės identifikacinis numeris
	*@param String $published publikavimo statusas: Ar publikuoti: true - publikuoti; false - nepublikuoti;

	*/
	public function updateCompanyLodge($assigmentID,$companyID,$logeID,$published)
	{		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update companies_loges set company_id=?,loge_id=?,published=? where id=?');
		$data = array($companyID,$logeID,$published,$assigmentID);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			//echo $query_res->getDebugInfo();
			$db->disconnect();
			
			die('Kritinė klaida: LodgeOrders->updateCompanyLodge()');
		}

		$db->disconnect();
	}
	
	//PRASIDEDA lodges_orders metodai
	
	/**
	*Gražinamas užsakymų kiekis kiekis
	*@param Integer $company_id įmonės identifikacinis numeris
	*@param Date  $time Užsakymo paieškos laikas
	*@param Integer $lodge_number ložės arba kabinos numeris
	*@param Integer $type tipas: ložė ar kabina
	*@param Integer $payment_type Apmokėjimo tipas
	*@param Integer $confirmation_type Pavirtinimo statusas
	*@return integer užsakymų kiekis kiekis
	*/

	public function getLodgesOrdersCount($company_id,$time,$lodge_number,$type,$payment_type,$confirmation_type)
	{
		
		if (strlen($company_id) == 0) {
			$company_id = '%';
		}

		if (strlen($lodge_number) == 0) {
			$lodge_number = '%';
		}
		if (strlen($type) == 0) {
			$type = '%';
		}
		if (strlen($payment_type) == 0) {
			$payment_type = '%';
		}
		if (strlen($confirmation_type) == 0) {
			$confirmation_type = '%';
		}
		
	
// select loges_orders.id,loges_orders.from_time,loges_orders.to_time,loges_orders.order_time, companies.name,loges.loge_number,loges.type from companies,companies_loges,loges,loges_orders where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id;		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if (strlen($time) == 0) {
			$res =  $db->query('select count(loges_orders.id) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and trim(to_char(companies.id,\'999999999999\')) like \''.$company_id.'\' and trim(to_char(loges.loge_number,\'999999999999\')) like \''.$lodge_number.'\' and trim(to_char(loges.type,\'999999999999\')) like \''.$type.'\' and trim(to_char(loges_orders.payment_type,\'999999999999\')) like \''.$payment_type.'\' and trim(to_char(loges_orders.confirmation,\'999999999999\')) like \''.$confirmation_type.'\'');
		} else {
			$res =  $db->query('select count(loges_orders.id) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and trim(to_char(companies.id,\'999999999999\')) like \''.$company_id.'\' and trim(to_char(loges.loge_number,\'999999999999\')) like \''.$lodge_number.'\' and trim(to_char(loges.type,\'999999999999\')) like \''.$type.'\' and trim(to_char(loges_orders.payment_type,\'999999999999\')) like \''.$payment_type.'\' and trim(to_char(loges_orders.confirmation,\'999999999999\')) like \''.$confirmation_type.'\' and from_time>\'  '.$time.'   \' and from_time<timestamp \' '.$time.' \'+ interval \'24 hours\'');
		}

		
		
		if (PEAR::isError($res)) {
			echo $res->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getLodgesOrdersCount()');
		}
		
		$db->disconnect();
		if ($res->numRows()) {
			$res->fetchInto($data);
			return $data[0];
		} else {
			return 0;
		}
	}
	

	/**
	*Gražinami ložių arba kabinų užsakymai
	*@param Integer $offset iki offset kintamojo bus nerodomos reikšmės iš loges_orders lentelės
	*@param Integer $limit Rodomų įrašų kiekis
	*@param Integer $company_id įmonės identifikacinis numeris
	*@param Date  $time Užsakymo paieškos laikas
	*@param Integer $lodge_number ložės arba kabinos numeris
	*@param Integer $type tipas: ložė ar kabina
	*@param Integer $payment_type Apmokėjimo tipas
	*@param Integer $confirmation_type Pavirtinimo statusas
	*@return Array užsakymų duomenų masyvas
	*
	*/

	public function getLogesOrders($offset,$limit,$company_id,$time,$lodge_number,$type,$payment_type,$confirmation_type)
	{
		if (strlen($company_id) == 0) {
			$company_id = '%';
		}

		if (strlen($lodge_number) == 0) {
			$lodge_number = '%';
		}
		if (strlen($type) == 0) {
			$type = '%';
		}
		if (strlen($payment_type) == 0) {
			$payment_type = '%';
		}
		if (strlen($confirmation_type) == 0) {
			$confirmation_type = '%';
		}
		
	
// select loges_orders.id,loges_orders.from_time,loges_orders.to_time,loges_orders.order_time, companies.name,loges.loge_number,loges.type from companies,companies_loges,loges,loges_orders where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id;		
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		if (strlen($time) == 0) {
			$res =  $db->query('select loges_orders.id,loges_orders.from_time,loges_orders.to_time,loges_orders.order_time, companies.name,companies.code,loges.loge_number,loges.type,loge_customers.firstname,loge_customers.lastname,loges_orders.payment_type,loges_orders.confirmation,loges_orders.people_count from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and trim(to_char(companies.id,\'999999999999\')) like \''.$company_id.'\' and trim(to_char(loges.loge_number,\'999999999999\')) like \''.$lodge_number.'\' and trim(to_char(loges.type,\'999999999999\')) like \''.$type.'\' and trim(to_char(loges_orders.payment_type,\'999999999999\')) like \''.$payment_type.'\' and trim(to_char(loges_orders.confirmation,\'999999999999\')) like \''.$confirmation_type.'\' order by loges_orders.order_time desc limit '.$limit.' offset '.$offset);
		} else {
			$res =  $db->query('select loges_orders.id,loges_orders.from_time,loges_orders.to_time,loges_orders.order_time, companies.name,companies.code,loges.loge_number,loges.type,loge_customers.firstname,loge_customers.lastname,loges_orders.payment_type,loges_orders.confirmation,loges_orders.people_count from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and trim(to_char(companies.id,\'999999999999\')) like \''.$company_id.'\' and trim(to_char(loges.loge_number,\'999999999999\')) like \''.$lodge_number.'\' and trim(to_char(loges.type,\'999999999999\')) like \''.$type.'\' and trim(to_char(loges_orders.payment_type,\'999999999999\')) like \''.$payment_type.'\' and       from_time>\'  '.$time.'   \' and from_time<timestamp \' '.$time.' \'+ interval \'24 hours\'     and trim(to_char(loges_orders.confirmation,\'999999999999\')) like \''.$confirmation_type.'\' order by loges_orders.order_time desc limit '.$limit.' offset '.$offset);
		}
		
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getLodgesOrders()');
		}
		
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
	}	
	
	
	/**
	*Gražinamas visų skirtingų ložių numerių, kurios yra užsakytos masyvas
	*@return Array visų skirtingų ložių numerių, kurios yra užsakytos masyvas
	*/
	public function getDistinctLodgesNumbersFromOrders()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select  distinct(loges.loge_number) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id order by loges.loge_number asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesNumbersFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas visų skirtingų ložių numerių, kurios yra užsakytos masyvas ir priklauso nurodytam klientui
	*@param Integer $customer_id Kliento identifikacinis numeris
	*@return Array visų skirtingų ložių numerių, kurios yra užsakytos masyvas ir priklauso nurodytam klientui masyvas
	*/
	public function getDistinctCustomersLodgesNumbersFromOrders($customer_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select  distinct(loges.loge_number) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and loge_customers.id='.$customer_id.'  order by loges.loge_number asc');
		//echo 'select  distinct(loges.loge_number) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and companies.id='.$customer_id.'  order by loges.loge_number asc';
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesNumbersFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	
	/**
	*Gražinamas visų skirtingų įmonių duomenų, kuriuos yra užsakytos masyvas
	*@return Array visų skirtingų įmonių duomenų, kuriuos yra užsakytos masyvas
	*/
	public function getDistinctCompaniesFromOrders()
	{
		//$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select  companies.id,companies.name from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id order by companies.name asc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctCompaniesFromOrders()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų skirtingų ložių tipų, kurios yra užsakytos masyvas
	*@return Array visų skirtingų ložių tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctLodgesTypesFromOrders()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct(loges.type) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id order by loges.type asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesNumbersFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas visų kliento skirtingų ložių tipų, kurios yra užsakytos masyvas
	*@param $customer_id Kliento identifikacinis numeris
	*@return Array visų kliento skirtingų ložių tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctCustomerLodgesTypesFromOrders($customer_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct(loges.type) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and loge_customers.id='.$customer_id.' order by loges.type asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctLodgesNumbersFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas visų skirtingų apmokėjimo tipų, kurios yra užsakytos masyvas
	*@return Array visų skirtingų apmokėjimo tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctPaymentTypesFromOrders()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct( loges_orders.payment_type) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id order by  loges_orders.payment_type asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctPaymentTypesFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Gražinamas visų kliento skirtingų apmokėjimo tipų, kurios yra užsakytos masyvas
	*@param $customer_id Kliento identifikacinis numeris
	*@return Array visų kliento skirtingų apmokėjimo tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctCustomerPaymentTypesFromOrders($customer_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct( loges_orders.payment_type) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and loge_customers.id='.$customer_id.' order by  loges_orders.payment_type asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctPaymentTypesFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*Pakeičiamas užsakymo patvirtinimo statusas
	*@param Integer $orderIDPub Užsakymo identifikacinis numeris
	*@param bool $current_status Esamas patvirtinimo statusas statusas
	*/
	public function updateOrderConfirmation($orderIDPub,$current_status)
	{
		if ($current_status == '0') {
			$pubStatus = 1;
		} else {
			$pubStatus = 0;
		}
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$query = $db->prepare('update loges_orders set confirmation=? where id=?');
		$data = array($pubStatus,$orderIDPub);
		$query_res = $db->execute($query, $data);
		if (PEAR::isError($query_res)) {
			$db->disconnect();
			//echo $query_res->getMessage();
			die('Kritinė klaida: LodgeOrders->updateOrderConfirmation()');
		}
		$db->disconnect();
	}
	
	/**
	*Gražinamas visų skirtingų patvirtinimo tipų, kurios yra užsakytos masyvas
	*@return Array visų skirtingų patvirtinimo tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctConfirmationTypesFromOrders()
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct( loges_orders.confirmation) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id order by  loges_orders.confirmation asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctConfirmationTypesFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	
	/**
	*Gražinamas visų kliento skirtingų patvirtinimo tipų, kurios yra užsakytos masyvas
	*@param Integer $customer_id
	*@return Array visų kliento skirtingų patvirtinimo tipų, kurios yra užsakytos masyvas
	*/
	public function getDistinctCustomerConfirmationTypesFromOrders($customer_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select distinct( loges_orders.confirmation) from companies,companies_loges,loges,loges_orders,loge_customers where companies.id=companies_loges.company_id and loges.id=companies_loges.loge_id and loges_orders.companies_loge_id=companies_loges.id and loge_customers.company_id=companies.id and loge_customers.id=loges_orders.loge_customer_id and loge_customers.id='.$customer_id.' order by  loges_orders.confirmation asc');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getDistinctConfirmationTypesFromOrders()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		return $data;
		
	}
	
	/**
	*
	*Ištrinami užsakymai
	*@param Integer ARRAY $ordersIDS užsakymų identifikaciniai numeriai, kuriuos norima ištrinti
	*@return void
	*/
	public function removeOrders($ordersIDS)
	{
		$whereClause = "";
		for ($i = 0; $i < count($ordersIDS); $i++) {
			if ($i != count($ordersIDS) - 1) {
				$whereClause .= 'id='.$ordersIDS[$i].' or ';
			} else {
				$whereClause .= 'id='.$ordersIDS[$i];
			}
			
		}
		//echo $whereClause;
		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from loges_orders where '.$whereClause);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->removeOrders()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	/**
	*Tikrinima ar prieiga įmonei yra leidžiama
	*@param String $username Vartotojo vardas
	*@param String $password Slaptažodis
	*@return Int -1 - Šiam įmonės atstovui prieiga yra uždrausta; -2 -įmonei prigeiga yra uždrausta; 0 - Vartotojas neegzistuoja; >0 - Vartotojo ID
	*/
	public function checkLogin($username,$password)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select loge_customers.id,loge_customers.published,companies.published from companies,loge_customers where companies.id=loge_customers.company_id and username=\''.$username.'\' and password=\''.$password.'\' ');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->checkLogin()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		if (count($row) == 0) {
			return -100;
		}
		if ($row[2] == 'f') {
			return -2;
		}
		if ($row[1] == 'f') {
			return -1;
		}	
		return $row[0];
		
	}
	
	/**
	*Gražinamas įmonės ID 
	*@param String $loge_customers_id Įmonės darbuotojo ID
	*@return Int $companyID Įmonės identifikacinis numeris
	*/
	public function getCompanyID($loge_customers_id)
	{
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select company_id from loge_customers where id='.$loge_customers_id);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getCompanyID()');
		}
		$data = null;
		while ($res->fetchInto($row)) {
		    $data[] = $row;
		}
		$db->disconnect();
		
		return $row[0];
		
	}
	
	
	/**
	*Gražinamas visų menu grupių masyvas, pagal atlikto užsakymo ID
	*@param String $orderID
	*@return Array visų menu grupių masyvas asociatyvus masyvas
	*/
	public function getMenuGroupsRegistredAdmin($orderID)
	{
		$search = '';
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		$data = $db->getAssoc('select menu_group.id,menu_group.name,menu_group.is_deleted,menu_group.order_id,menu_group.published,menu_group.name_en from menu_group,menu,ordered_menu where menu_group.id=menu.menu_group_id and ordered_menu.menu_id=menu.id and ordered_menu.quantity > 0 and ordered_menu.loges_order_id = '.$orderID.' order by menu_group.order_id desc');
		if (PEAR::isError($data)) {
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenuGroupsRegistredAdmin()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinamas visų menu masyvas kurie patenka į užsakymus
	*@param String $orderID
	*@return Array visų menu asociatyvus masyvas
	*/
	public function getMenusAdmin($orderID)
	{
		//$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$data = $db->getAssoc('select menu.id,menu.dish,menu.price, menu.order_id,menu_group.name,menu.published,menu.view_not_registred,menu.menu_group_id,menu_group.name_en,menu_group.name_ru,menu.dish_description,menu.dish_en,menu.dish_ru,menu.dish_description_en,menu.dish_description_ru,ordered_menu.quantity from menu,menu_group,ordered_menu where ordered_menu.menu_id=menu.id and  menu.menu_group_id=menu_group.id and ordered_menu.loges_order_id = '.$orderID.'  order by menu.order_id desc');
//echo 'select menu.id,menu.dish,menu.price, menu.order_id,menu_group.name,menu.published,menu.view_not_registred,menu.menu_group_id,menu_group.name_en,menu_group.name_ru,menu.dish_description,menu.dish_en,menu.dish_ru,menu.dish_description_en,menu.dish_description_ru,ordered_menu.quantity from menu,menu_group,ordered_menu where ordered_menu.menu_id=menu.id and  menu.menu_group_id=menu_group.id order by menu.order_id desc';
		
		if (PEAR::isError($data)) {
			echo $data->getDebugInfo();
			$db->disconnect();
			die('Kritinė klaida: Menu->getMenusAdmin()');
		}
		$db->disconnect();
		return $data;
	}
	
	/**
	*Gražinama užsakymo kaina
	*@param String $orderID
	*@return Numeric $price Užsakymo kaina
	*/
	public function getOrderPrice($orderID)
	{
		//$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select sum(menu.price*ordered_menu.quantity) from menu,menu_group,ordered_menu where ordered_menu.menu_id=menu.id and  menu.menu_group_id=menu_group.id and ordered_menu.loges_order_id = '.$orderID.' ');
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getOrderPrice()');
		}

		$res->fetchInto($row);
		return $row[0];
		$db->disconnect();

	}
	
	/**
	*Gražinami užsakymo duomenys
	*@param String $orderID
	*@return Array Užsakymo duomenys
	*/
	public function getOrderDetail($orderID)
	{
		//$search = strtolower($search);
		$connect = new ConnectManager();
		$db = $connect->getConnect();

		$res = $db->query('select loges_orders.from_time, loges_orders.to_time,loges_orders.order_time,loges_orders.payment_type,loges_orders.confirmation,loges_orders.other_info, loges.loge_number,loges.type,loges_orders.people_count from loges_orders,companies_loges,loges where loges.id=companies_loges.loge_id and companies_loges.id=loges_orders.companies_loge_id and loges_orders.id = '.$orderID);
		if (PEAR::isError($res)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->getOrderDetail()');
		}

		$res->fetchInto($row);
		return $row;
		$db->disconnect();

	}
	
	/**
	*
	*Ištrinama užsakymas
	*@param Integer $orderID Užsakymo identifikacinis numeris
	*@return void
	*/
	public function removeOrder($orderID)
	{		
		$connect = new ConnectManager();
		$db = $connect->getConnect();
		
		$result= $db->query('delete from loges_orders where id='.$orderID);
		if (PEAR::isError($result)) {
			$db->disconnect();
			die('Kritinė klaida: LodgeOrders->removeOrder()');
		}
		$db->disconnect();
		//echo 'delete from menu_group where '.$whereClause;
	}
	
	

	

}


?>