--
-- PostgreSQL database dump
--

-- Dumped from database version 9.6.11
-- Dumped by pg_dump version 9.6.11

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


--
-- Name: http; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS http WITH SCHEMA public;


--
-- Name: EXTENSION http; Type: COMMENT; Schema: -; Owner: -
--

COMMENT ON EXTENSION http IS 'HTTP client for PostgreSQL, allows web page retrieval inside the database.';


--
-- Name: check_imported_payments(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.check_imported_payments(cust_id integer) RETURNS record
    LANGUAGE plpgsql
    AS $$DECLARE

BEGIN
	 return (select sum(payment_quantity_invoice_table), sum(rasta) from (select min(contract_id),min(type),min(file_name),sum(payment_quantity) as payment_quantity_invoice_table, payment_date, (select sum(payments.payment_quantity) from payments,invoices,contracts where contracts.id=invoices.contract_id and invoices.id=payments.invoice_id and payments.pay_date=imported_payments.payment_date and contracts.customer_id=cust_id) as rasta from imported_payments,contracts  where contracts.id=imported_payments.contract_id and contracts.customer_id=cust_id group by payment_date order by payment_date) as tbl);
	 
END$$;


--
-- Name: check_imports(integer); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.check_imports(cust_id integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$DECLARE
res_payments integer;
res_change_fee integer;
BEGIN
	select max(case when payment_quantity_invoice_table!=coalesce(rasta, 0) then 1 else 0 end) into res_payments from (select min(contract_id),min(type),min(file_name),sum(payment_quantity) as payment_quantity_invoice_table, payment_date, (select sum(payments.payment_quantity) from payments,invoices,contracts where contracts.id=invoices.contract_id and invoices.id=payments.invoice_id and payments.pay_date=imported_payments.payment_date and contracts.customer_id=cust_id) as rasta from imported_payments,contracts  where contracts.id=imported_payments.contract_id and contracts.customer_id=cust_id group by payment_date order by payment_date) as tbl;
	res_payments := coalesce(res_payments, 0);
	
	select case when contracts.mountly_fee!=invoices.quantity then 1 else 0 end into res_change_fee   from customers,contracts,invoices where customers.id=contracts.customer_id and contracts.id=invoices.contract_id and customers.id=cust_id order by invoices.id desc limit 1;
	res_change_fee := coalesce(res_change_fee, 0);	
	
	if  (res_payments = 1) and  (res_change_fee = 0) then
		return 1;
	elsif (res_payments = 0) and  (res_change_fee = 1) then
		return 2;
	elsif (res_payments = 1) and  (res_change_fee = 1) then 
		return 3;
	elsif (res_payments = 0) and  (res_change_fee = 0) then 
		return 0;
	end if;
	 
END$$;


--
-- Name: FUNCTION check_imports(cust_id integer); Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON FUNCTION public.check_imports(cust_id integer) IS 'return value:
1 - Nesutvarkytas perlo importas;
2 - Pasikeitė paskutinės sąskaitos sumą lyginant su sutartimi;
3 - Abu kriterijai teisingi 1. ir 2.
0 - Perlo importas geras - paskutinė sąskaita nepasikeitė lyginant su sutartini.';


SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: invoices; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.invoices (
    id integer NOT NULL,
    quantity numeric(8,2) NOT NULL,
    payment_quantity numeric(8,2) DEFAULT 0 NOT NULL,
    contract_id integer NOT NULL,
    inv_date date DEFAULT now() NOT NULL,
    pay_date date,
    inv_path character varying(255),
    purpose text,
    is_inv boolean DEFAULT false NOT NULL,
    vat_inv_no integer,
    vat integer,
    vat_inv_date date,
    vat_inv_quantity numeric(8,2),
    vat_inv_id integer,
    vat_oper_code character varying(255),
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN invoices.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.id IS 'Sąskaitos identifikacinis numeris';


--
-- Name: COLUMN invoices.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.quantity IS 'Saskaitos suma';


--
-- Name: COLUMN invoices.payment_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.payment_quantity IS 'Gauta apmokėjimo suma';


--
-- Name: COLUMN invoices.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.contract_id IS 'Sutarties identifikacinis numeris';


--
-- Name: COLUMN invoices.inv_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.inv_date IS 'Sąskaitos išrašymo data';


--
-- Name: COLUMN invoices.pay_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.pay_date IS 'Apmokėjimo data';


--
-- Name: COLUMN invoices.inv_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.inv_path IS 'Kelias iki sąskaitos';


--
-- Name: COLUMN invoices.purpose; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.purpose IS 'Mokėjimo paskirtis';


--
-- Name: COLUMN invoices.is_inv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.is_inv IS 'Ar išrašyta PVM sąskaita faktūra';


--
-- Name: COLUMN invoices.vat_inv_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat_inv_no IS 'Jei sąskaita išrašyta tai sąskaitos numeris';


--
-- Name: COLUMN invoices.vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat IS 'PVM dydis procentais';


--
-- Name: COLUMN invoices.vat_inv_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat_inv_date IS 'Sąskaitos išrašymo data';


--
-- Name: COLUMN invoices.vat_inv_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat_inv_quantity IS 'Mokesčio dydis be PVM';


--
-- Name: COLUMN invoices.vat_inv_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat_inv_id IS 'Sąskaitos identifikacinis numeris buhalterinėje programoje';


--
-- Name: COLUMN invoices.vat_oper_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.vat_oper_code IS 'PVM sąskaitoje esančios operacijos kodas';


--
-- Name: COLUMN invoices.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN invoices.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.invoices.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: create_invoices(numeric, integer, date, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.create_invoices(invoice_quantity numeric, contract integer, invoice_date date, invoice_purpose text) RETURNS SETOF public.invoices
    LANGUAGE plpgsql
    AS $$BEGIN
   RETURN QUERY
 
  insert into invoices (quantity,contract_id,inv_date,purpose) values(invoice_quantity,contract,invoice_date,invoice_purpose ) returning id,quantity,payment_quantity,contract_id,inv_date,pay_date,inv_path,purpose,is_inv,vat_inv_no,vat,vat_inv_date,vat_inv_quantity,vat_inv_id,vat_oper_code,create_time,modify_time; 
   
END
$$;


--
-- Name: is_date(character varying); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.is_date(s character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $$begin
  perform s::date;
  if (s < '1970/01/01') then
  return false;
    end if;
  return true;
exception when others then
  return false;
end;
$$;


--
-- Name: sms; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.sms (
    id integer NOT NULL,
    contract_id integer NOT NULL,
    sender character varying(15),
    receiver character varying(15),
    msg_text character varying(255),
    sms_insert_status integer DEFAULT 0,
    sent_time timestamp without time zone DEFAULT now() NOT NULL,
    dlr_time timestamp without time zone,
    dlr_status character varying(255),
    message_id character varying(255),
    url_view_time timestamp without time zone,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN sms.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.id IS 'SMS identifikacinis numeris';


--
-- Name: COLUMN sms.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.contract_id IS 'Sutarties identifikacinis numeris';


--
-- Name: COLUMN sms.sender; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.sender IS 'SMS siuntėjo numeris';


--
-- Name: COLUMN sms.receiver; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.receiver IS 'SMS gavėjo numeris';


--
-- Name: COLUMN sms.msg_text; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.msg_text IS 'SMS žinutės tekstas';


--
-- Name: COLUMN sms.sms_insert_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.sms_insert_status IS 'HTTP statusas išsiųstos žinutės: 1701 Success, 1702  One of the parameter is missing or OTP is not numeric, 1703 User authentication has failed, 1705 Message does not contain "%m", 1706  Invalid destination, 1707 Invalid source (Sender), 1710 Internal error, 1715 Response time out, 1025 Insufficient user credit, null problem with server connection';


--
-- Name: COLUMN sms.sent_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.sent_time IS 'SMS žinutės išsiuntimo laikas';


--
-- Name: COLUMN sms.dlr_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.dlr_time IS 'SMS žinutės delivery reports gavimo laikas';


--
-- Name: COLUMN sms.dlr_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.dlr_status IS 'Delivery reports statusas (UNKNOWN, ACKED, ENROUTE, DELIVRD, EXPIRED, DELETED, UNDELIV, ACCEPTED, REJECTD)';


--
-- Name: COLUMN sms.message_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.message_id IS 'SMS žinutės siuntėjo serverio identifikacinis numeris';


--
-- Name: COLUMN sms.url_view_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.url_view_time IS 'SMS žinutėje esančio URL paspaudimo laikas';


--
-- Name: COLUMN sms.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN sms.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.sms.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: send_sms_by_contractid(integer, text, text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.send_sms_by_contractid(contractid integer, message_receiver text, message_text text) RETURNS SETOF public.sms
    LANGUAGE plpgsql ROWS 100000
    AS $$DECLARE
 balance numeric(10,2);
 sms_response varchar(255);
 sms_receiver varchar(15);
 sms_message varchar(200);
 password varchar(8);
BEGIN
   select customers.phone into sms_receiver from customers,contracts where customers.id=contracts.customer_id and contracts.id=contractid;
   select customers.password into password  from customers,contracts where customers.id=contracts.customer_id and contracts.id=contractid;
   select sum(payment_quantity)-sum(quantity) into balance from invoices where invoices.contract_id=contractid;
   perform http_set_curlopt('CURLOPT_TIMEOUT', '5');
   perform http_set_curlopt('CURLOPT_CONNECTTIMEOUT', '5');
   if balance>0 then
       sms_message := 'Sveiki,'||chr(10)||'Susiderinimui siunciame interneto mokejimu suvestine:'||chr(10)||'http://mano.bitnet.lt/?'||contractid||password||chr(10)||'Permoka:' || to_char(balance,'FM99999999.00') || 'Eur'||chr(10)||'Buhalterija:+37069825357';
   else
       sms_message := 'Sveiki,'||chr(10)||'Susiderinimui siunciame interneto mokejimu suvestine:'||chr(10)||'http://mano.bitnet.lt/?'||contractid||password||chr(10)||'Skola:' || to_char(balance,'FM99999999.00') || 'Eur'||chr(10)||'Buhalterija:+37069825357';
   end if;

   if CHAR_LENGTH(message_text)>0 then
       sms_message := message_text;
   end if;

   if CHAR_LENGTH(message_receiver)>0 then
       sms_receiver := message_receiver;
   end if;

   select content into sms_response from http_get('http://api.rmlconnect.net:8080/bulksms/bulksms?username=disigma1&password=Labas12@&type=5&dlr=1&destination='||sms_receiver||'&source=Priminimas&message='||urlencode(sms_message));
   RETURN QUERY
insert into sms (contract_id,sender,receiver,msg_text,sms_insert_status,message_id) values (contractid,'Priminimas',sms_receiver,sms_message,cast(split_part(sms_response, '|', 1) AS INTEGER),split_part(sms_response, '|',3))  returning id,sms.contract_id,sender,receiver,msg_text,sms_insert_status,sent_time,dlr_time,dlr_status,message_id,url_view_time,create_time,modify_time;

exception 
  WHEN sqlstate 'XX000' THEN
    RAISE NOTICE 'SQLSTATE: %', SQLSTATE;
RETURN QUERY
insert into sms (contract_id,sender,receiver,msg_text,sms_insert_status,message_id) values (contractid,'Priminimas',sms_receiver,sms_message,0,split_part(sms_response, '|',3))  returning id,sms.contract_id,sender,receiver,msg_text,sms_insert_status,sent_time,dlr_time,dlr_status,message_id,url_view_time,create_time,modify_time;



END$$;


--
-- Name: send_telegram(text); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.send_telegram(message text) RETURNS integer
    LANGUAGE plpgsql
    AS $$BEGIN
   perform http_set_curlopt('CURLOPT_TIMEOUT', '5');
   perform http_set_curlopt('CURLOPT_CONNECTTIMEOUT', '5');
      perform  http_get('https://api.telegram.org/bot739527897:AAGDebMdaEDhztCzr1apI9inss2WbxG78aE/sendMessage?chat_id=520680227&text='||message);
   RETURN 1;
 
 return 1;
exception 
  WHEN sqlstate 'XX000' THEN
    return 0;

END; $$;


--
-- Name: update_invoice_payments(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.update_invoice_payments() RETURNS trigger
    LANGUAGE plpgsql
    AS $$declare
	pQuant numeric(8,2); 
	pDate date;
begin
IF TG_OP = 'INSERT'
THEN
select sum(payment_quantity), max(pay_date) INTO pQuant,pDate from payments where invoice_id=NEW.invoice_id;
update invoices set payment_quantity=pQuant, pay_date=pDate where id=NEW.invoice_id;
RETURN NEW;
ELSEIF TG_OP = 'UPDATE'
THEN
IF NEW.invoice_id <> OLD.invoice_id THEN
update invoices set payment_quantity=0, pay_date=null where id=OLD.invoice_id;
select sum(payment_quantity), max(pay_date) INTO pQuant,pDate from payments where invoice_id=NEW.invoice_id;
update invoices set payment_quantity=pQuant, pay_date=pDate where id=NEW.invoice_id;
ELSE
select sum(payment_quantity), max(pay_date) INTO pQuant,pDate from payments where invoice_id=NEW.invoice_id;
update invoices set payment_quantity=pQuant, pay_date=pDate where id=NEW.invoice_id;
END IF;
RETURN NEW;
ELSEIF TG_OP = 'DELETE'
THEN
select coalesce(sum(payment_quantity), 0), max(pay_date) INTO pQuant,pDate from payments where invoice_id=OLD.invoice_id;
update invoices set payment_quantity=pQuant, pay_date=pDate where id=OLD.invoice_id;
RETURN NEW;
END IF;
end;
$$;


--
-- Name: updatetimes(); Type: FUNCTION; Schema: public; Owner: -
--

CREATE FUNCTION public.updatetimes() RETURNS trigger
    LANGUAGE plpgsql SECURITY DEFINER
    AS $$
        BEGIN
        NEW.modify_time := current_timestamp;
        RETURN NEW;
        END;
$$;


--
-- Name: REFBank; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public."REFBank" (
    "Code" integer,
    "Name" character varying(255),
    "CorAccount" integer,
    "SWIFTCode" integer
);


--
-- Name: bank_accounts; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bank_accounts (
    id integer NOT NULL,
    recipient_name character varying(255) NOT NULL,
    recipient_surname character varying(255) NOT NULL,
    recipient_code character varying(255),
    bank_name character varying(255) NOT NULL,
    bank_code character varying(255) NOT NULL,
    bank_account_no character varying(255) NOT NULL,
    owner_id integer NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN bank_accounts.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.id IS 'Banko sąskaitos identifikacinis numeris';


--
-- Name: COLUMN bank_accounts.recipient_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.recipient_name IS 'Gavėjo vardas';


--
-- Name: COLUMN bank_accounts.recipient_surname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.recipient_surname IS 'Gavėjo pavardė';


--
-- Name: COLUMN bank_accounts.recipient_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.recipient_code IS 'Gavėjo kodas';


--
-- Name: COLUMN bank_accounts.bank_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.bank_name IS 'Banko pavadinimas';


--
-- Name: COLUMN bank_accounts.bank_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.bank_code IS 'Banko kodas';


--
-- Name: COLUMN bank_accounts.bank_account_no; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.bank_account_no IS 'Banko sąskaitos numeris';


--
-- Name: COLUMN bank_accounts.owner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.owner_id IS 'Savininkui priklausanti banko sąskaita';


--
-- Name: COLUMN bank_accounts.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN bank_accounts.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bank_accounts.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: bank_accounts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.bank_accounts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: bank_accounts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.bank_accounts_id_seq OWNED BY public.bank_accounts.id;


--
-- Name: bitnet; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bitnet (
    ip character varying(255) NOT NULL,
    "time" timestamp without time zone DEFAULT now(),
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN bitnet.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bitnet.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN bitnet.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bitnet.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: bitnet_test; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.bitnet_test (
    username character varying(255),
    password character varying(255),
    "current_time" timestamp with time zone DEFAULT now(),
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN bitnet_test.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bitnet_test.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN bitnet_test.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.bitnet_test.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: contracts; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.contracts (
    id integer NOT NULL,
    customer_id integer NOT NULL,
    plan_id integer NOT NULL,
    mountly_fee numeric(8,3) NOT NULL,
    owner_id integer NOT NULL,
    valid_from date DEFAULT now() NOT NULL,
    valid_to date,
    contract_path character varying(255),
    suspend_from date,
    suspend_to date,
    is_active boolean DEFAULT true NOT NULL,
    registred timestamp without time zone DEFAULT now() NOT NULL,
    other_info text,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN contracts.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.id IS 'Sutarties identifikacinis numeris';


--
-- Name: COLUMN contracts.customer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.customer_id IS 'Kliento identifikacinis numeris';


--
-- Name: COLUMN contracts.plan_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.plan_id IS 'plano identifikacinis numeris';


--
-- Name: COLUMN contracts.mountly_fee; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.mountly_fee IS 'Mėnesio kaina';


--
-- Name: COLUMN contracts.owner_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.owner_id IS 'Savininko identifikacinis numeris';


--
-- Name: COLUMN contracts.valid_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.valid_from IS 'Galiuoja nuo';


--
-- Name: COLUMN contracts.valid_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.valid_to IS 'Galioja iki';


--
-- Name: COLUMN contracts.contract_path; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.contract_path IS 'Sutarties failas';


--
-- Name: COLUMN contracts.suspend_from; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.suspend_from IS 'Sustabdytas tiekimas nuo';


--
-- Name: COLUMN contracts.suspend_to; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.suspend_to IS 'Sustabdytas tiekimas iki';


--
-- Name: COLUMN contracts.is_active; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.is_active IS 'Ar aktyvi';


--
-- Name: COLUMN contracts.registred; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.registred IS 'Registracijos laikas';


--
-- Name: COLUMN contracts.other_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.other_info IS 'Papildoma informacija';


--
-- Name: COLUMN contracts.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN contracts.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.contracts.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: contracts_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.contracts_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: contracts_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.contracts_id_seq OWNED BY public.contracts.id;


--
-- Name: customers; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.customers (
    id integer NOT NULL,
    company_name character varying(255),
    code character varying(255) NOT NULL,
    vat_code character varying(255),
    name character varying(255) NOT NULL,
    surname character varying(255) NOT NULL,
    address character varying(255) NOT NULL,
    phone character varying(255),
    is_company boolean DEFAULT false NOT NULL,
    username character varying(255) NOT NULL,
    password character varying(255) NOT NULL,
    registred timestamp without time zone DEFAULT now() NOT NULL,
    activate_iptv boolean DEFAULT false NOT NULL,
    sms_inform boolean DEFAULT false NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN customers.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.id IS 'Kliento identifikacinis numeris';


--
-- Name: COLUMN customers.company_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.company_name IS 'Įmonės pavadinimas';


--
-- Name: COLUMN customers.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.code IS 'Kodas, jei fizinis asmens, jei įmonė įmonės kodas';


--
-- Name: COLUMN customers.vat_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.vat_code IS 'Įmonės pvm kodas';


--
-- Name: COLUMN customers.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.name IS 'Vardas';


--
-- Name: COLUMN customers.surname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.surname IS 'Pavardė';


--
-- Name: COLUMN customers.address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.address IS 'Adresas';


--
-- Name: COLUMN customers.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.phone IS 'Telefonas';


--
-- Name: COLUMN customers.is_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.is_company IS 'Ar įmonė';


--
-- Name: COLUMN customers.username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.username IS 'Prisijungimo prie sistemos vartotojo vardas';


--
-- Name: COLUMN customers.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.password IS 'Prisijungimo prie sistemos slaptažodis';


--
-- Name: COLUMN customers.registred; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.registred IS 'Registracijos laikas';


--
-- Name: COLUMN customers.activate_iptv; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.activate_iptv IS 'Ar aktyvuojama IPTV ikona';


--
-- Name: COLUMN customers.sms_inform; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.sms_inform IS 'Kliento informavimas SMS išrašius SF';


--
-- Name: COLUMN customers.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN customers.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.customers.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: customers_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.customers_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: customers_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.customers_id_seq OWNED BY public.customers.id;


--
-- Name: imported_payments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.imported_payments (
    id integer NOT NULL,
    contract_id integer NOT NULL,
    file_name character varying(255) NOT NULL,
    payment_date date NOT NULL,
    payment_quantity numeric(8,2) NOT NULL,
    type integer NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: TABLE imported_payments; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.imported_payments IS 'Importuoti mokėjimai';


--
-- Name: COLUMN imported_payments.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.id IS 'Importuoto mokėjimo identifikacinis numeris';


--
-- Name: COLUMN imported_payments.contract_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.contract_id IS 'Sutarties identifikacinis numeris';


--
-- Name: COLUMN imported_payments.file_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.file_name IS 'Failo pavadinimas';


--
-- Name: COLUMN imported_payments.payment_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.payment_date IS 'Mokėjimo data';


--
-- Name: COLUMN imported_payments.payment_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.payment_quantity IS 'Apmokėta suma';


--
-- Name: COLUMN imported_payments.type; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.type IS 'Apmokėjimo tipas: 1-Perlas; ';


--
-- Name: COLUMN imported_payments.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN imported_payments.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: imported_payments_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.imported_payments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: imported_payments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.imported_payments_id_seq OWNED BY public.imported_payments.id;


--
-- Name: imported_payments_tmp; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.imported_payments_tmp (
    id integer NOT NULL,
    contract_id integer NOT NULL,
    file_name character varying(255) NOT NULL,
    payment_date date NOT NULL,
    payment_quantity numeric(8,2) NOT NULL,
    type integer DEFAULT 1,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN imported_payments_tmp.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments_tmp.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN imported_payments_tmp.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.imported_payments_tmp.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: imported_payments_tmp_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.imported_payments_tmp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: imported_payments_tmp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.imported_payments_tmp_id_seq OWNED BY public.imported_payments_tmp.id;


--
-- Name: invoices_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.invoices_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: invoices_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.invoices_id_seq OWNED BY public.invoices.id;


--
-- Name: jar; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.jar (
    id integer NOT NULL,
    code character varying(255) NOT NULL,
    name character varying(255) NOT NULL,
    vat_code character varying(255),
    address character varying(255),
    phone character varying(255),
    email character varying(255)
);


--
-- Name: COLUMN jar.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.id IS 'Identifikacinis numeris';


--
-- Name: COLUMN jar.code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.code IS 'Įmonės kodas';


--
-- Name: COLUMN jar.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.name IS 'Įmonės pavadinimas';


--
-- Name: COLUMN jar.vat_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.vat_code IS 'Įmonės PVM kodas';


--
-- Name: COLUMN jar.address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.address IS 'Įmonės adresas';


--
-- Name: COLUMN jar.phone; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.phone IS 'Įmonės telefonas';


--
-- Name: COLUMN jar.email; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.jar.email IS 'Įmonės el. pastas';


--
-- Name: jar_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.jar_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: jar_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.jar_id_seq OWNED BY public.jar.id;


--
-- Name: network_info; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.network_info (
    id integer NOT NULL,
    ip character varying(255) NOT NULL,
    mask character varying(255) NOT NULL,
    gateway character varying(255) NOT NULL,
    dns1 character varying(255) NOT NULL,
    dns2 character varying(255),
    other_info text,
    contract_id integer,
    mac_address character varying(20) NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN network_info.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.id IS 'tinklo informacijos indentifikacinis numeris';


--
-- Name: COLUMN network_info.ip; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.ip IS 'IP adresas';


--
-- Name: COLUMN network_info.mask; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.mask IS 'maskë';


--
-- Name: COLUMN network_info.gateway; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.gateway IS 'Gatevëjus';


--
-- Name: COLUMN network_info.dns1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.dns1 IS 'DNS 1';


--
-- Name: COLUMN network_info.dns2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.dns2 IS 'DNS 2';


--
-- Name: COLUMN network_info.other_info; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.other_info IS 'Papildoma informacija';


--
-- Name: COLUMN network_info.mac_address; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.mac_address IS 'MAC adresas';


--
-- Name: COLUMN network_info.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN network_info.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.network_info.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: network_info_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.network_info_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: network_info_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.network_info_id_seq OWNED BY public.network_info.id;


--
-- Name: owners; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.owners (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    surname character varying(255) NOT NULL,
    username character varying(255) NOT NULL,
    password character varying(255) NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN owners.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.id IS 'savininko id';


--
-- Name: COLUMN owners.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.name IS 'savininko vardas';


--
-- Name: COLUMN owners.surname; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.surname IS 'savininko pavardė';


--
-- Name: COLUMN owners.username; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.username IS 'Vartotojo vardas administratoriaus';


--
-- Name: COLUMN owners.password; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.password IS 'Slaptaþodis administratoriaus';


--
-- Name: COLUMN owners.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN owners.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.owners.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: owners_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.owners_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: owners_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.owners_id_seq OWNED BY public.owners.id;


SET default_with_oids = true;

--
-- Name: payments; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.payments (
    id integer NOT NULL,
    invoice_id integer NOT NULL,
    pay_date date NOT NULL,
    payment_quantity numeric(8,2) NOT NULL,
    bank_transfer_id character varying(255),
    cash boolean DEFAULT false NOT NULL,
    comment text,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN payments.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.id IS 'Mokėjiimo identifikacinis numeris';


--
-- Name: COLUMN payments.invoice_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.invoice_id IS 'Sąskaitos identifikacinis numeris';


--
-- Name: COLUMN payments.pay_date; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.pay_date IS 'Apmokėjimo data';


--
-- Name: COLUMN payments.payment_quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.payment_quantity IS 'Gauta apmokėjimo suma';


--
-- Name: COLUMN payments.bank_transfer_id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.bank_transfer_id IS 'Banko išraro įrašo identifikacinis numeris';


--
-- Name: COLUMN payments.cash; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.cash IS 'Gryni pinigai';


--
-- Name: COLUMN payments.comment; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.comment IS 'Apmokėjimo komentaras';


--
-- Name: COLUMN payments.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN payments.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.payments.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: payments_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.payments_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: payments_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.payments_id_seq OWNED BY public.payments.id;


SET default_with_oids = false;

--
-- Name: plans; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.plans (
    id integer NOT NULL,
    name character varying(255) NOT NULL,
    download character varying(255) NOT NULL,
    upload character varying(255) NOT NULL,
    price_company numeric(8,2) NOT NULL,
    price_person numeric(8,2) NOT NULL,
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN plans.id; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.id IS 'Plano identifikacinis numeris';


--
-- Name: COLUMN plans.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.name IS 'Plano pavadinimas';


--
-- Name: COLUMN plans.download; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.download IS 'Download greitis';


--
-- Name: COLUMN plans.upload; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.upload IS 'Upload greitis';


--
-- Name: COLUMN plans.price_company; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.price_company IS 'Kaina įmonei';


--
-- Name: COLUMN plans.price_person; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.price_person IS 'Kaina fiziniui';


--
-- Name: COLUMN plans.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN plans.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.plans.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: plans_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.plans_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: plans_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.plans_id_seq OWNED BY public.plans.id;


--
-- Name: purchases; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.purchases (
    refid character varying(255) NOT NULL,
    invoice_number character varying(20),
    sender_code character varying(20),
    sender_name character varying(150),
    sender_vat character varying(20),
    sender_street character varying(150),
    sender_city character varying(40),
    sender_country character varying(2),
    iban character varying(34),
    date_invoice date,
    date_due date,
    reverse_charge boolean DEFAULT false,
    currency character varying(3),
    amount_tax0 numeric(8,2),
    amount_tax1 numeric(8,2),
    tax1_rate smallint,
    amount_tax2 numeric(8,2),
    tax2_rate smallint,
    amount_untaxed numeric(8,2),
    amount_total numeric(8,2),
    import_status character varying(10),
    import_status_reason character varying(120),
    invoice_file character varying(60)
);


--
-- Name: TABLE purchases; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.purchases IS 'Atpažintų pirkimų lentelė';


--
-- Name: COLUMN purchases.refid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.refid IS 'Infotec referencinis transakcijos numeris';


--
-- Name: COLUMN purchases.invoice_number; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.invoice_number IS 'SF serija ir numeris';


--
-- Name: COLUMN purchases.sender_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_code IS 'Tiekėjo juridinio asmens kodas';


--
-- Name: COLUMN purchases.sender_name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_name IS 'Tiekėjo pavadinimas';


--
-- Name: COLUMN purchases.sender_vat; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_vat IS 'Tiekėjo PVM mokėtojo kodas';


--
-- Name: COLUMN purchases.sender_street; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_street IS 'Tiekėjo adresas';


--
-- Name: COLUMN purchases.sender_city; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_city IS 'Tiekėjo miestas';


--
-- Name: COLUMN purchases.sender_country; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.sender_country IS 'Tiekėjo šalies kodas';


--
-- Name: COLUMN purchases.iban; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.iban IS 'Tiekėjo tarptautinis banko sąskaitos numeris';


--
-- Name: COLUMN purchases.date_invoice; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.date_invoice IS 'SF išrašymo data';


--
-- Name: COLUMN purchases.date_due; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.date_due IS 'SF apmokėjimo data';


--
-- Name: COLUMN purchases.reverse_charge; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.reverse_charge IS 'Atvirkštinio PVM požymis;0 - nėra, 1 - yra, PVM kodo neformuojame ';


--
-- Name: COLUMN purchases.currency; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.currency IS 'SF valiutos kodas';


--
-- Name: COLUMN purchases.amount_tax0; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.amount_tax0 IS 'PVM suma, apmokestinta 0% tarifu';


--
-- Name: COLUMN purchases.amount_tax1; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.amount_tax1 IS 'PVM suma';


--
-- Name: COLUMN purchases.tax1_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.tax1_rate IS 'Procentinė PVM išraiška';


--
-- Name: COLUMN purchases.amount_tax2; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.amount_tax2 IS 'PVM suma';


--
-- Name: COLUMN purchases.tax2_rate; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.tax2_rate IS 'Procentinė PVM išraiška';


--
-- Name: COLUMN purchases.amount_untaxed; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.amount_untaxed IS 'Visa SF suma be PVM';


--
-- Name: COLUMN purchases.amount_total; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.amount_total IS 'Visa SF suma';


--
-- Name: COLUMN purchases.import_status; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.import_status IS 'Statusas - Reikšmių pavyzdžiai, paskirtis:  * Valid - validi (visi duomenys teisingi); * Rejected - atmesta (nekorektiški duomenys); * Exeption - yra neatitikimų (nesutampa sumos). Reikia suderinti, kokiais atvejais kokios turi būti formuojamos status reikšmės Reikšmių formavimo sąlygos Excel puslapyje Exeption, Reject';


--
-- Name: COLUMN purchases.import_status_reason; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.import_status_reason IS 'Statuso komentaras - Komentaruose tikslinga fiksuoti daromus pakeitimus (sumų pataisymus, kitas leistinas duomenų korekcijas) Komentarų tekstai gali būti standartizuoti, pagal sąskaitos faktūros informaciją. Reikšmių formavimo sąlygos Excel puslapyje Exeption, Reject';


--
-- Name: COLUMN purchases.invoice_file; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases.invoice_file IS 'Nuoroda į skenuoto vaizdo failą - Stulpelio reikšmė - nuoroda į grafinį sąskaitos faktūros failą, kuris pateikiamas kartu su duomenimis';


--
-- Name: purchases_details; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.purchases_details (
    purchases_refid character varying(255) NOT NULL,
    default_code character varying(20),
    name character varying(150),
    quantity numeric(8,2),
    uom character varying(20),
    price_unit numeric(8,2),
    amount_netto numeric(8,2),
    vat_amount numeric(8,2)
);


--
-- Name: TABLE purchases_details; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON TABLE public.purchases_details IS 'Pirkimo eilutės';


--
-- Name: COLUMN purchases_details.purchases_refid; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.purchases_refid IS 'Infotec referencinis transakcijos numeris';


--
-- Name: COLUMN purchases_details.default_code; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.default_code IS 'Prekės kodas';


--
-- Name: COLUMN purchases_details.name; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.name IS 'Prekės ar paslaugos pavadinimas';


--
-- Name: COLUMN purchases_details.quantity; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.quantity IS 'Kiekis';


--
-- Name: COLUMN purchases_details.uom; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.uom IS 'Matavimo vienetas';


--
-- Name: COLUMN purchases_details.price_unit; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.price_unit IS 'Prekės ar paslaugos vieneto kaina be nuolaidos';


--
-- Name: COLUMN purchases_details.amount_netto; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.amount_netto IS 'Prekės ar paslaugos vieneto kaina su nuolaida, be PVM';


--
-- Name: COLUMN purchases_details.vat_amount; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.purchases_details.vat_amount IS 'PVM suma';


--
-- Name: sms_id_seq; Type: SEQUENCE; Schema: public; Owner: -
--

CREATE SEQUENCE public.sms_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


--
-- Name: sms_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: -
--

ALTER SEQUENCE public.sms_id_seq OWNED BY public.sms.id;


--
-- Name: test; Type: TABLE; Schema: public; Owner: -
--

CREATE TABLE public.test (
    id integer,
    tekstas text,
    skaicius numeric(8,2),
    create_time timestamp without time zone DEFAULT now() NOT NULL,
    modify_time timestamp without time zone DEFAULT now() NOT NULL
);


--
-- Name: COLUMN test.create_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.test.create_time IS 'Įrašo įvedimo laikas';


--
-- Name: COLUMN test.modify_time; Type: COMMENT; Schema: public; Owner: -
--

COMMENT ON COLUMN public.test.modify_time IS 'Įrašo paskutinio modifikavimo laikas';


--
-- Name: bank_accounts id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.bank_accounts ALTER COLUMN id SET DEFAULT nextval('public.bank_accounts_id_seq'::regclass);


--
-- Name: contracts id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.contracts ALTER COLUMN id SET DEFAULT nextval('public.contracts_id_seq'::regclass);


--
-- Name: customers id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.customers ALTER COLUMN id SET DEFAULT nextval('public.customers_id_seq'::regclass);


--
-- Name: imported_payments id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.imported_payments ALTER COLUMN id SET DEFAULT nextval('public.imported_payments_id_seq'::regclass);


--
-- Name: imported_payments_tmp id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.imported_payments_tmp ALTER COLUMN id SET DEFAULT nextval('public.imported_payments_tmp_id_seq'::regclass);


--
-- Name: invoices id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.invoices ALTER COLUMN id SET DEFAULT nextval('public.invoices_id_seq'::regclass);


--
-- Name: jar id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.jar ALTER COLUMN id SET DEFAULT nextval('public.jar_id_seq'::regclass);


--
-- Name: network_info id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.network_info ALTER COLUMN id SET DEFAULT nextval('public.network_info_id_seq'::regclass);


--
-- Name: owners id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.owners ALTER COLUMN id SET DEFAULT nextval('public.owners_id_seq'::regclass);


--
-- Name: payments id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.payments ALTER COLUMN id SET DEFAULT nextval('public.payments_id_seq'::regclass);


--
-- Name: plans id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.plans ALTER COLUMN id SET DEFAULT nextval('public.plans_id_seq'::regclass);


--
-- Name: sms id; Type: DEFAULT; Schema: public; Owner: -
--

ALTER TABLE ONLY public.sms ALTER COLUMN id SET DEFAULT nextval('public.sms_id_seq'::regclass);


--
-- Data for Name: REFBank; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public."REFBank" ("Code", "Name", "CorAccount", "SWIFTCode") FROM stdin;
123	Testas SQL	1	1
\.


--
-- Data for Name: bank_accounts; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bank_accounts (id, recipient_name, recipient_surname, recipient_code, bank_name, bank_code, bank_account_no, owner_id, create_time, modify_time) FROM stdin;
\.


--
-- Name: bank_accounts_id_seq; Type: SEQUENCE SET; Schema: public; Owner: -
--

SELECT pg_catalog.setval('public.bank_accounts_id_seq', 1, false);


--
-- Data for Name: bitnet; Type: TABLE DATA; Schema: public; Owner: -
--

COPY public.bitnet (ip, "time", create_time, modify_time) FROM stdin;
78.62.123.243	2008-11-19 15:47:52.18393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 15:48:11.859208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 15:48:31.571819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:07:36.178736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:07:55.999399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:08:17.784953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:08:37.600132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:28:04.576102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:28:24.47785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:28:44.289893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:29:04.088362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:48:14.756463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:48:34.721677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:48:54.60901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 16:49:14.421036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:08:33.711475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:08:53.49621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:09:13.357157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:09:33.322407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:28:51.872772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:29:11.713067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:29:31.622055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:29:51.85658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:49:24.430182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:49:44.252189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:50:07.078874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 17:50:27.008152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:09:54.626016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:10:14.470129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:10:34.349737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:10:56.230874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:30:22.009008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:30:41.875819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:31:01.753826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:31:21.778152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:50:58.269334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:51:21.115623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:51:43.061523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 18:52:03.05206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:12:09.29977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:12:31.142996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:12:50.965294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:13:10.810717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:33:00.977649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:33:20.858601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:33:40.704715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:34:00.452449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:53:55.753389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:54:15.598997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:54:35.415312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 19:54:55.421665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:14:45.621497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:15:05.454339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:15:25.291159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:15:45.122175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:35:34.419287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:35:54.213016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:36:16.046874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:36:35.969522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:56:17.57683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:56:37.933281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:56:57.777293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 20:57:17.611413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:16:52.512908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:17:12.329516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:17:32.123999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:17:51.910954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:37:33.952095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:37:53.835975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:38:13.666955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:38:33.536021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:58:28.226258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:58:47.998134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:59:07.805711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 21:59:27.643417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:19:13.321788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:19:33.042357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:19:52.763887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:20:12.496243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:40:01.567066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:40:21.362007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:40:41.077974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 22:41:01.208083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:00:47.899775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:01:07.617027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:01:27.331156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:01:47.042951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:21:25.320462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:21:44.951642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:22:04.590041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:22:24.204912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:41:56.413169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:42:15.993521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:42:35.658227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-19 23:42:55.336734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:02:30.802473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:02:50.369268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:03:09.957786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:03:29.706185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:23:03.723592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:23:23.345327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:23:42.94755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:24:02.632152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:43:28.114044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:43:47.748606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:44:07.349028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 00:44:26.930279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:03:50.474337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:04:10.068176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:04:29.714707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:04:49.278377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:24:06.169873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:24:25.824846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:24:45.448864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:25:05.037814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:44:30.736946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:44:50.364499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:45:09.999916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 01:45:29.61128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:04:54.436466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:05:14.051466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:05:33.713161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:05:53.353163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:25:16.695128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:25:36.285248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:25:55.89833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:26:15.535412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:45:38.179765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:45:57.809548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:46:17.453415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 02:46:37.113041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:05:56.905343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:06:17.105433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:06:37.138659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:06:56.737772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:26:20.819877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:26:40.457952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:27:00.113787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:27:19.694476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:46:44.937778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:47:04.525219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:47:24.55033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 03:47:44.225004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:07:04.705713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:07:24.292986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:07:43.884809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:08:03.761241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:27:24.821423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:27:44.37554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:28:04.01735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:28:23.655563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:47:47.334666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:48:06.917554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:48:26.529242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 04:48:46.126214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:08:07.875575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:08:27.558713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:08:47.089979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:09:06.717668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:28:25.576186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:28:45.244381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:29:04.85041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:29:24.391307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:48:50.064527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:49:09.610411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:49:29.191578	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 05:49:48.757141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:09:11.061921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:09:30.643614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:09:50.212877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:10:09.852871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:29:34.254403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:29:53.847987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:30:13.403871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:30:33.417918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:49:55.892821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:50:15.46063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:50:35.025169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 06:50:54.658191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:10:20.043703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:10:39.766237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:10:59.340485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:11:18.919233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:30:44.006032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:31:03.580786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:31:23.128923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:31:42.688848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:50:54.074359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:51:13.676168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:51:33.292233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 07:51:52.860696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:11:09.533583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:11:29.154703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:11:48.811272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:12:08.40789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:31:26.973405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:31:46.593136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:32:06.256262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:32:25.877555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:51:37.376602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:51:57.024806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:52:16.639054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 08:52:36.278768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:11:43.539132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:12:03.207806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:12:22.886589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:12:42.593089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:31:43.926326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:32:03.545441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:32:23.093192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:32:42.717253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:51:38.408762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:51:58.038111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:52:17.696527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 09:52:37.387304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:12:31.551751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:12:51.198732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:13:10.898147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:13:30.588135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:33:43.472797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:34:03.180812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:34:22.838557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:34:42.540825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:54:34.825213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:54:54.458123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:55:14.067214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 10:55:33.696036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:14:43.552193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:15:03.277069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:15:22.954134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:15:42.675965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:35:02.081452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:35:21.706592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:35:41.367034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:36:01.071228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:55:32.66961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:55:52.438452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:56:12.170913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 11:56:31.988163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:15:42.138356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:16:36.029424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:16:55.726226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:17:15.439552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:36:22.790806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:36:42.518738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:37:02.565339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:37:22.319808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:56:42.129668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:57:01.823514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:57:21.607236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 12:57:41.470775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:17:08.977755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:17:30.638082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:17:50.301463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:18:10.029884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:38:35.593379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:38:55.314592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:39:16.926688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:39:36.561715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 13:59:59.424961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:00:19.127273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:00:38.797563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:00:58.525839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:21:04.478352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:21:24.224532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:21:44.048387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:22:03.830283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:41:09.781264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:41:29.467452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:41:49.211021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 14:42:08.965379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:01:10.359858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:01:30.102466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:01:49.859393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:02:09.666424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:21:08.375166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:21:28.160672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:21:47.923394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:22:07.93363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:41:17.928855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:41:37.673036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:41:57.398124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 15:42:17.191077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:01:44.725518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:02:04.442945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:02:24.240392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:02:44.056095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:22:00.202873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:22:19.962271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:22:39.744306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:22:59.464795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:42:07.049343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:42:26.846129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:42:46.61944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 16:43:06.436947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:03:08.076112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:03:27.899458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:03:47.656906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:04:07.435108	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:23:15.709642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:23:35.608021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:23:55.380123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:24:15.189418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:43:42.973191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:44:02.784106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:44:22.551757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 17:44:42.411616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:04:14.78404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:04:34.596725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:04:54.48344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:05:17.399112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:24:59.419211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:25:19.301653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:25:39.130428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:25:58.927899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:34:28.654363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 18:34:54.20203	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 18:35:17.546503	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 18:35:43.920179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 18:45:40.475743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 18:46:00.242654	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 18:46:20.173127	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 18:46:40.05229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 19:06:23.426256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 19:06:43.262049	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 19:07:03.353456	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 19:07:25.13815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 19:27:15.963255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 19:27:35.902188	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 19:27:56.088893	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 19:28:16.172238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 19:48:08.17999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 19:48:28.00223	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 19:48:47.953602	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 19:49:08.184644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 20:08:57.645012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 20:09:18.050219	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 20:09:38.095403	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 20:09:58.272095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 20:29:51.299348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 20:30:11.354914	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 20:30:31.569874	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 20:30:55.307921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 20:50:47.35606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 20:51:07.179738	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 20:51:27.442507	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 20:51:49.361053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 21:11:26.778211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 21:11:46.513765	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 21:12:06.445434	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 21:12:26.693612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 21:32:14.570714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 21:32:34.444585	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 21:32:54.333985	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 21:33:14.465215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 21:53:14.469891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 21:53:34.361332	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 21:55:42.505661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 22:15:18.627058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 22:15:38.4044	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 22:15:58.544907	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 22:16:18.304514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 22:36:03.526855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 22:36:23.259968	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 22:36:42.973482	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 22:37:02.678237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 22:56:56.801566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 22:57:16.566776	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 22:57:36.339695	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 22:57:56.109323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 23:17:53.440529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 23:18:13.54627	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 23:18:33.278843	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 23:18:52.979584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 23:38:41.046733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 23:39:00.7951	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 23:39:20.566494	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-20 23:39:40.39139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-20 23:59:19.81026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-20 23:59:39.617535	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-20 23:59:59.325606	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 00:00:19.047042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 00:19:41.98893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 00:20:01.658907	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 00:20:21.427409	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 00:20:41.173136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 00:40:01.073302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 00:40:20.744798	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 00:40:40.84839	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 00:41:00.562884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 01:00:27.015114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 01:00:46.710727	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 01:01:06.487285	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 01:01:26.227119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 01:20:46.982119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 01:21:06.613217	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 01:21:26.25485	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 01:21:46.270062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 01:41:01.305245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 01:41:21.005653	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 01:41:40.674662	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 01:42:00.352643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 02:01:13.654886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 02:01:33.268497	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 02:01:52.871878	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 02:02:12.546537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 02:21:28.400317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 02:21:48.063885	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 02:22:07.806959	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 02:22:27.464655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 02:41:41.925194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 02:42:01.555672	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 02:42:21.200337	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 02:42:40.853058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 03:01:57.544835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 03:02:17.176564	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 03:02:37.194267	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 03:02:56.90544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 03:22:10.912873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 03:22:30.54768	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 03:22:50.180714	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 03:23:09.854105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 03:42:28.727402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 03:42:48.400683	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 03:43:08.091937	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 03:43:28.009035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 04:02:45.116874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 04:03:04.746927	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 04:03:24.382781	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 04:03:44.015339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 04:22:58.996227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 04:23:18.641927	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 04:23:38.266425	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 04:23:57.93149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 04:43:18.219202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 04:43:37.783499	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 04:43:57.405045	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 04:44:16.986121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 05:03:31.075064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 05:03:50.690506	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 05:04:10.258995	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 05:04:29.913318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 05:23:48.535604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 05:24:08.130318	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 05:24:27.732878	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 05:24:47.36789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 05:44:07.016458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 05:44:26.638914	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 05:44:46.322797	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 05:45:05.896639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 06:04:23.085651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 06:04:42.674537	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 06:05:02.264375	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 06:05:21.840524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 06:24:38.956408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 06:24:58.92907	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 06:25:18.53566	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 06:25:38.202307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 06:44:54.079308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 06:45:13.673749	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 06:45:33.284576	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 06:45:52.922448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 07:05:05.056243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 07:05:24.649441	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 07:05:44.296949	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 07:06:03.908889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 07:25:11.260088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 07:25:30.865163	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 07:25:50.435863	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 07:26:10.104802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 07:45:20.118319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 07:45:39.818171	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 07:45:59.411608	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 07:46:19.018107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 08:05:27.472419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 08:05:47.077489	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 08:06:06.677	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 08:06:26.31043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 08:25:38.736004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 08:25:58.384947	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 08:26:18.085351	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 08:26:37.772533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 08:45:33.723381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 08:45:53.380765	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 08:46:13.075236	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 08:46:32.677057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 09:05:33.696363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 09:05:53.410863	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 09:06:13.257118	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 09:06:32.913109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 09:25:21.22997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 09:25:40.894539	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 09:26:00.605935	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 09:26:20.335322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 09:45:06.315765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 09:45:26.026715	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 09:45:45.748518	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 09:46:05.906995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 10:04:50.514957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 10:05:10.203974	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 10:05:29.943194	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 10:05:49.679301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 10:24:20.992837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 10:24:40.711233	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 10:25:00.802213	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 10:25:20.646001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 10:44:21.531301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 10:44:41.216504	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 10:45:00.937626	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 10:45:20.722837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 11:04:21.75244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 11:04:41.440091	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 11:05:01.179322	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 11:05:20.889834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 11:24:10.805854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 11:24:30.493413	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 11:24:50.19169	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 11:25:09.915954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 11:44:05.087181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 11:44:24.762261	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 11:44:44.45729	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 11:45:04.101371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 12:03:55.282789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 12:04:15.006892	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 12:04:34.86953	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 12:04:54.741018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 12:24:42.046655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 12:25:01.79486	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 12:25:21.561727	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 12:25:41.233426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 12:44:37.144176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 12:44:56.95579	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 12:45:17.143906	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 12:45:37.028278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 13:04:40.067625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 13:04:59.865692	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 13:05:20.054663	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 13:05:39.887369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 13:24:54.674472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 13:25:14.468954	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 13:25:34.498253	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 13:25:54.67181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 13:45:23.728204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 13:45:43.473369	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 13:46:03.635852	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 13:46:23.727615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 14:05:40.81966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 14:06:00.590743	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 14:06:21.401841	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 14:06:41.434945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 14:25:57.363958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 14:26:17.128112	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 14:26:37.05923	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 14:26:57.212086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 14:46:26.485764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 14:46:46.278841	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 14:47:06.11974	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 14:47:25.963225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 15:06:52.814322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 15:07:12.6061	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 15:07:33.044953	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 15:07:52.927658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 15:27:19.395081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 15:27:39.197061	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 15:27:59.125926	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 15:28:19.36994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 15:47:48.588734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 15:48:08.371849	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 15:48:28.964141	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 15:48:49.176707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 16:08:10.658245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 16:08:30.373918	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 16:08:50.325302	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 16:09:10.398871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 16:28:37.935541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 16:28:57.698928	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 16:29:17.55436	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 16:29:37.736015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 16:49:07.456334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 16:49:27.205224	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 16:49:47.623755	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 16:50:09.636986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 17:09:24.411786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 17:09:44.272698	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 17:10:04.17349	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 17:10:24.63909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 17:29:55.464125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 17:30:15.219636	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 17:30:35.041599	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 17:30:55.274201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 17:50:16.327891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 17:50:36.064967	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 17:50:56.244862	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 17:51:16.217424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 18:10:23.055632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 18:10:42.85317	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 18:11:05.630594	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 18:11:25.821817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 18:30:34.625702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 18:30:54.379703	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 18:31:14.868408	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 18:31:36.661351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 18:50:30.746771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 18:50:50.482138	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 18:51:10.30913	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 18:51:30.564015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 19:10:38.73473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 19:10:58.544275	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 19:11:18.869396	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 19:11:39.350845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 19:30:53.553899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 19:31:13.328159	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 19:31:33.691193	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 19:31:53.57465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 19:51:38.486678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 19:51:58.259199	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 19:52:18.154555	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 19:52:38.174349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 20:12:05.921342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 20:12:25.658699	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 20:12:45.441049	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 20:13:05.269623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 20:32:12.937406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 20:32:32.674867	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 20:32:52.798053	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 20:33:12.763545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 20:52:35.379157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 20:52:55.125713	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 20:53:14.905214	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 20:53:34.756562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 21:12:49.474117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 21:13:09.250081	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 21:13:29.292832	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 21:13:49.444721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 21:33:17.094774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 21:33:36.85445	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 21:33:56.712178	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 21:34:16.567918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 21:53:32.271952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 21:53:52.033576	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 21:54:12.156708	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 21:54:31.979935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 22:13:52.820424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 22:14:12.547612	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 22:14:32.486756	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 22:14:52.217432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 22:34:10.755074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 22:34:30.466806	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 22:34:50.214799	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 22:35:10.025339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 22:54:29.229381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 22:54:48.892554	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 22:55:08.647073	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 22:55:28.416139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 23:14:40.577183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 23:15:00.360323	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 23:15:20.881114	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 23:15:40.890691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 23:34:44.525159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 23:35:04.265528	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 23:35:24.029347	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 23:35:43.903797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-21 23:54:39.936151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-21 23:54:59.648142	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-21 23:55:19.440058	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-21 23:55:39.209558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 00:14:44.451942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 00:15:04.133569	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 00:15:24.121104	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 00:15:43.786461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 00:34:48.899689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 00:35:08.506876	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 00:35:28.24129	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 00:35:47.979412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 00:55:03.392477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 00:55:22.971935	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 00:55:42.59868	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 00:56:02.330208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 01:15:40.885162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 01:16:00.519228	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 01:16:20.143615	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 01:16:39.839398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 01:36:04.411108	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 01:36:24.076583	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 01:36:43.683024	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 01:37:03.383871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 01:56:28.047755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 01:56:47.604575	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 01:57:07.227147	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 01:57:26.821977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 02:16:46.858131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 02:17:06.42619	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 02:17:26.035104	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 02:17:45.638482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 02:37:07.341706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 02:37:27.151632	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 02:37:46.730427	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 02:38:06.331221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 02:57:24.940687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 02:57:44.518854	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 02:58:04.184125	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 02:58:23.789897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 03:17:48.137556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 03:18:07.758332	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 03:18:27.389223	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 03:18:47.021989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 03:38:09.266856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 03:38:28.862216	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 03:38:48.443409	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 03:39:08.02789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 03:58:31.452683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 03:58:51.44371	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 03:59:11.32239	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 03:59:30.893087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 04:18:53.572208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 04:19:13.167336	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 04:19:32.768538	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 04:19:52.356477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 04:39:14.096187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 04:39:33.72522	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 04:39:53.333179	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 04:40:13.027964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 04:59:33.032522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 04:59:52.66653	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 05:00:12.310172	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 05:00:31.905941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 05:19:54.024989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 05:20:13.631543	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 05:20:33.254941	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 05:20:52.841324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 05:40:15.952212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 05:40:35.487947	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 05:40:55.098718	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 05:41:14.663291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 06:00:35.963499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 06:00:55.815305	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 06:01:15.428896	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 06:01:35.107374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 06:20:55.193338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 06:21:14.750275	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 06:21:34.327743	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 06:21:53.963555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 06:41:15.931814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 06:41:35.523013	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 06:41:55.126277	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 06:42:14.728507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 07:01:39.239836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 07:01:58.845016	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 07:02:18.411891	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 07:02:37.963701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 07:22:02.689351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 07:22:22.248524	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 07:22:41.899451	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 07:23:01.520593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 07:42:21.134739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 07:42:40.69911	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 07:43:00.365125	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 07:43:19.957158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 08:02:33.193472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 08:02:53.160058	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 08:03:12.79204	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 08:03:32.472131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 08:22:44.521215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 08:23:04.15814	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 08:23:23.825773	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 08:23:43.486564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 08:42:34.770554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 08:42:54.425788	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 08:43:14.16463	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 08:43:33.849204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 09:02:30.062344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 09:02:49.781037	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 09:03:09.500934	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 09:03:29.480785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 09:22:24.82126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 09:22:44.620542	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 09:23:04.367524	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 09:23:24.068022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 09:42:17.588237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 09:42:37.29132	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 09:42:57.039739	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 09:43:16.732282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 10:02:11.004384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 10:02:30.719747	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 10:02:50.523756	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 10:03:10.238186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 10:22:08.113191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 10:22:28.31338	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 10:22:47.987942	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 10:23:07.737184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 10:42:01.827623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 10:42:21.552547	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 10:42:41.350609	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 10:43:01.156259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 11:02:03.108633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 11:02:22.865745	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 11:02:42.722667	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 11:03:02.530244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 11:22:07.656945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 11:22:27.419485	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 11:22:47.244198	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 11:23:07.090295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 11:42:24.599679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 11:42:44.492182	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 11:43:04.727288	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 11:43:24.656972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 12:03:04.267436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 12:03:31.169107	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 12:03:51.387304	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 12:04:11.607334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 12:23:16.416766	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 12:23:38.232491	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 12:24:08.280477	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 12:24:30.211871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 12:43:32.396956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 12:43:52.324824	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 12:44:12.352791	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 12:44:32.318432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 13:03:35.425066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 13:03:57.311002	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 13:04:19.531086	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 13:04:41.384476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 13:23:50.872424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 13:24:10.797127	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 13:24:33.001243	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 13:24:52.951241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 13:43:56.775673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 13:44:16.644732	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 13:44:36.515572	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 13:44:56.607424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 14:04:29.918757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 14:04:49.872907	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 14:05:10.292296	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 14:05:30.659516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 14:25:05.442715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 14:25:25.243855	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 14:25:45.109147	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 14:26:04.95383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 14:45:44.698855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 14:46:04.524101	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 14:46:24.535	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 14:46:46.452021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 15:06:35.584413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 15:06:55.471538	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 15:07:15.751147	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 15:07:35.897443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 15:27:44.706953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 15:28:22.001698	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 15:51:19.148287	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 15:51:38.907438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 16:11:30.365699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 16:11:50.126022	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 16:12:11.899571	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 16:12:32.056415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 16:32:21.60849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 16:32:43.49416	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 16:33:05.391643	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 16:33:25.878501	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 16:55:52.844618	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 16:56:57.652674	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 16:57:19.65034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 17:17:30.747174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 17:17:50.871859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 17:38:53.323521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 17:39:15.192593	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 17:39:35.049297	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 17:44:46.36399	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 18:21:47.036297	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 18:22:06.882502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 18:41:47.478523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 19:02:05.476699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 19:03:01.270652	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 19:03:21.754796	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 19:03:43.528144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 19:23:08.097606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 19:23:27.89049	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 19:24:52.662606	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 19:25:14.439797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 19:44:31.117476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 19:44:50.951513	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 19:45:11.31655	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 19:45:31.106137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 20:05:18.711026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 20:05:44.339367	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 20:06:25.269486	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 20:06:45.000832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 20:26:26.322367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 20:26:46.053356	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 20:27:05.890623	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 20:27:25.666985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 20:47:20.542215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 20:47:40.222726	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 20:48:00.050048	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 20:48:19.816386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 21:08:33.492677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 21:08:53.951945	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 21:09:13.632193	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 21:09:33.402486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 21:30:07.6928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 21:30:27.453488	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 21:30:50.076819	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 21:31:54.753021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 21:51:56.396076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 21:52:16.65446	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 21:52:36.48172	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 21:52:56.159599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 22:13:16.289096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 22:34:18.517983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 22:34:38.780785	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 22:35:27.022646	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 22:35:46.784184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 22:55:38.917256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 22:55:58.658592	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 22:56:18.348826	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 22:56:38.118725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 23:17:19.990777	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 23:17:39.770201	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 23:17:59.969041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 23:38:06.856921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 23:38:26.540105	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-22 23:38:46.228224	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-22 23:40:10.890319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-22 23:59:38.640463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-22 23:59:58.27414	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 00:00:17.933661	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 00:00:37.606124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 00:20:19.96894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 00:20:39.632717	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 00:20:59.260177	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 00:21:18.940439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 00:40:47.318241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 00:41:06.944434	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 00:41:26.552479	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 00:41:46.196807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 01:01:48.164574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 01:02:07.778492	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 01:02:27.8486	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 01:02:47.430653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 01:22:33.562304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 01:22:53.182124	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 01:23:12.816895	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 01:23:32.416733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 01:43:01.79595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 01:43:21.431239	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 01:43:41.107512	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 01:44:00.782309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 02:03:34.642115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 02:03:54.247179	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 02:04:13.915182	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 02:04:33.67703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 02:24:12.271813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 02:24:31.864819	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 02:24:51.5022	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 02:25:11.119378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 02:44:46.992106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 02:45:06.724882	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 02:45:26.361949	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 02:45:45.978229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 03:05:59.445213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 03:06:19.079139	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 03:06:38.662028	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 03:06:58.262438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 03:26:48.481411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 03:27:08.08588	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 03:27:27.682331	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 03:27:47.303722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 03:47:31.726369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 03:47:51.389636	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 03:48:10.98516	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 03:48:30.620024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 04:08:05.688454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 04:08:25.863796	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 04:08:45.482912	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 04:09:05.062811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 04:28:57.218325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 04:29:18.830747	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 04:29:40.489262	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 04:30:00.112572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 04:50:03.744076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 04:50:23.399449	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 04:50:43.05091	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 04:51:02.691681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 05:11:29.360367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 05:11:49.045626	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 05:12:08.702686	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 05:12:28.384579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 05:32:09.627122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 05:32:29.28307	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 05:32:48.909996	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 05:33:09.026258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 05:53:09.87511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 05:53:29.440974	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 05:53:49.069917	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 05:54:08.66798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 06:14:34.921951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 06:15:00.705195	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 06:15:20.387469	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 06:15:40.009288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 06:35:20.028516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 06:35:39.638404	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 06:35:59.234061	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 06:36:18.865882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 06:56:36.016186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 06:56:55.616058	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 06:57:17.27398	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 06:57:36.919584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 07:17:08.253974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 07:17:28.570286	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 07:17:48.166508	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 07:18:07.761739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 07:38:25.792915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 07:38:47.336578	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 07:39:07.013985	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 07:39:26.658955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 07:59:30.952194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 07:59:50.945307	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 08:00:10.5857	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 08:00:30.246396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 08:20:15.092017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 08:20:34.712657	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 08:20:44.938442	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 08:21:04.670407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 08:41:00.809015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 08:41:20.377615	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 08:41:40.008127	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 08:41:59.737902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 09:02:00.35831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 09:02:19.956439	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 09:02:39.580793	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 09:02:59.201476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 09:22:21.808916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 09:22:41.552761	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 09:23:01.495923	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 09:23:21.200297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 09:43:22.165533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 09:43:42.279367	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 09:44:02.062079	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 09:44:21.766536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 10:04:18.62369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 10:04:38.407712	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 10:04:58.186992	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 10:05:17.891351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 10:25:25.869968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 10:25:45.567795	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 10:26:05.288592	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 10:26:25.015195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 10:46:42.587735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 10:47:23.297429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 11:09:00.365855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 11:09:20.131687	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 11:10:39.860995	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 11:10:59.603638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 11:31:53.874743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 11:32:13.549324	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 11:32:35.356767	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 11:32:55.143233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 11:55:15.351413	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 11:55:35.130904	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 11:56:37.900377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 12:18:09.728732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 12:18:29.484977	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 12:18:49.204391	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 12:19:08.99562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 12:40:04.932365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 12:40:24.756476	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 12:40:44.584587	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 12:41:40.637503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 13:06:15.880893	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 13:06:35.600722	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 13:06:55.289345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 13:28:48.133213	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 13:29:07.798864	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 13:29:29.448353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 14:01:23.947661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 14:01:43.699718	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 14:02:44.395793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 14:24:42.463545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 14:25:02.179073	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 14:25:21.886778	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 14:49:22.139998	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 14:50:46.905889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 15:11:23.997791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 15:11:43.762838	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 15:12:48.485034	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 15:13:08.264866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 15:33:31.661937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 15:33:51.444275	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 15:34:11.253754	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 15:34:31.064949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 15:54:48.069744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 15:55:14.634824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 16:23:53.902797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 16:24:13.600404	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 16:24:33.358326	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 16:24:53.133019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 16:45:32.104258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 16:45:51.851543	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 16:46:11.880318	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 16:46:31.570822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 17:10:49.236545	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 17:11:08.969557	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 17:11:28.728395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 17:32:52.999749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 17:33:22.988012	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 17:33:43.053126	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 17:34:04.82566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 17:55:32.364286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 17:55:52.189252	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 17:56:16.953517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 18:18:12.667965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 18:18:32.482499	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 18:18:52.304898	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 18:19:12.115357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 18:40:20.117779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 18:40:39.905366	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 18:40:59.719255	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 18:41:19.615964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2008-11-23 19:03:02.006575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2008-11-23 19:03:57.706411	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.138.139	2008-11-23 19:04:19.41936	2000-01-01 00:00:00	2000-01-01 00:00:00
88.118.155.244	2008-11-23 19:04:51.233898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:52:47.962601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:52:58.673021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:02.669367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:07.029355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:07.286207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:07.469146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:07.708574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:07.885408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:08.202262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:08.373723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:08.53996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:08.724177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:18.093762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:18.33158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:18.549633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:18.72338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:18.885275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.045576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.213211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.373378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.528779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.693196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:19.862349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.004165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.162256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.318327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.494665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.701016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:20.892714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:21.078019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:21.237289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:21.372084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:21.541758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:53:34.844694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:34.957613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.109336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.256613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.432065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.610568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.748226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:35.906745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.071569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.216072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.376184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.535798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.685159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.837948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:36.966958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:37.151732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:37.325989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:37.464733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:37.736044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:37.898607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:38.056197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:38.23116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:38.391868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:38.552448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:38.85563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.026729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.193304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.30912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.461559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.636678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.767511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:39.964223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:40.125849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:40.271806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:40.567609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:40.751604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:40.896293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:41.286045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:41.462859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:41.639599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:41.775337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:41.952619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:42.242929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:53:42.372333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:57:08.692215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:57:36.816926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:57:40.674363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-11 23:57:42.730868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-11 23:58:41.351018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-11 23:59:08.91566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 00:01:56.071894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 00:03:15.012454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 00:03:27.596636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 16:36:17.606707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 16:41:23.630864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 17:08:14.313599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 17:08:31.61783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 17:08:48.403238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 17:09:05.490844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 17:26:44.50513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 17:27:01.428894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 17:27:18.365856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 17:27:35.388096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 17:44:29.084047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 17:44:46.28315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 17:45:03.574125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 17:45:20.672777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 18:03:25.306146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 18:03:42.151813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 18:03:58.879855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 18:04:15.627065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 18:20:43.258382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 18:21:00.026571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 18:21:16.726011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 18:21:33.433652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 18:38:25.06172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 18:38:41.880355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 18:38:58.656014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 18:39:15.512612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 18:55:32.362963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 18:55:49.131798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 18:56:06.890224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 18:56:23.944623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 19:13:00.471964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 19:13:17.905722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 19:13:35.168299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 19:13:54.60983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 21:15:04.546926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 21:15:21.28145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 21:15:38.129921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 21:15:55.061477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 21:33:00.079192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 21:33:16.733303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 21:33:33.382049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 21:33:50.064917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 21:50:26.131533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 21:50:42.992983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 21:50:59.789615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 21:51:16.658609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 22:08:46.880308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 22:09:03.798184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 22:09:21.071786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 22:09:38.082098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 22:26:53.190457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 22:27:10.160504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 22:27:27.064029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 22:27:44.006332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 22:44:17.688486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 22:44:34.453401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 22:44:51.227628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 22:45:08.052577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 23:01:58.570732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 23:02:15.292421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 23:02:32.035167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 23:02:48.803949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 23:19:33.438119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 23:19:50.101568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 23:20:06.815687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 23:20:23.527098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 23:37:16.651343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 23:37:33.366877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 23:37:50.069424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 23:38:06.744487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-12 23:54:55.442712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-12 23:55:12.187748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-12 23:55:28.878712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-12 23:55:45.62177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 00:12:34.45695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 00:12:51.154983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 00:13:07.873392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 00:13:24.632261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 00:30:10.961862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 00:30:27.688615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 00:30:44.409154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 00:31:01.108261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 00:47:49.437838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 00:48:06.116311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 00:48:22.782173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 00:48:39.472585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 01:05:25.786895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 01:05:42.839588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 01:05:59.493277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 01:06:16.198159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 01:23:02.553787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 01:23:19.247107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 01:23:35.902705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 01:23:52.5784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 01:41:03.095945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 01:41:19.776137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 01:41:36.439462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 01:41:53.128866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 01:59:05.575437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 01:59:22.255508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 01:59:38.82437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 01:59:55.477102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 02:17:04.177545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 02:17:20.820525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 02:17:37.505493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 02:17:54.206885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 02:35:04.795608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 02:35:21.464334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 02:35:38.13145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 02:35:54.769299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 02:53:05.075482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 02:53:21.741401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 02:53:38.343491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 02:53:55.043478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 03:11:05.35203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 03:11:22.023113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 03:11:38.735399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 03:11:55.466411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 03:29:04.077868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 03:29:20.733023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 03:29:37.427856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 03:29:54.213122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 03:47:05.285026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 03:47:21.95165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 03:47:38.533593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 03:47:55.18411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 04:05:03.700916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 04:05:20.338163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 04:05:36.998193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 04:05:53.711753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 04:23:05.99261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 04:23:22.632414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 04:23:39.388298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 04:23:56.062553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 04:41:04.418367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 04:41:21.05832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 04:41:37.701136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 04:41:54.38716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 04:59:04.914471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 04:59:21.617921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 04:59:38.313252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 04:59:54.981127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 05:17:03.483514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 05:17:20.142359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 05:17:36.814087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 05:17:53.524722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 05:35:02.095367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 05:35:18.725251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 05:35:35.425294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 05:35:52.084693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 05:53:02.63957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 05:53:19.338016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 05:53:35.963361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 05:53:52.602121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 06:11:01.328503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 06:11:17.949298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 06:11:34.632983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 06:11:51.334245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 06:29:05.593998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 06:29:22.470477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 06:29:39.148066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 06:29:55.796421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 06:47:06.708823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 06:47:23.36889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 06:47:40.070444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 06:47:56.753632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 07:05:05.29413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 07:05:21.917024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 07:05:38.560633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 07:05:55.253522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 07:23:03.521543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 07:23:20.179713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 07:23:36.88242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 07:23:53.490577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 07:41:06.446781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 07:41:23.094702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 07:41:39.778103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 07:41:56.438242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 07:59:22.206137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 07:59:38.897179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 07:59:55.564639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 08:00:12.258195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 08:17:22.915653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 08:17:39.574719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 08:17:56.274283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 08:18:13.136511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 08:34:59.408958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 08:35:16.110851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 08:35:32.808548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 08:35:49.451207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 08:52:38.029184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 08:52:54.71912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 08:53:11.394427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 08:53:28.082869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 09:09:56.174044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 09:10:12.867035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 09:10:29.516101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 09:10:46.221582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 09:27:14.58955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 09:27:31.307074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 09:27:47.959905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 09:28:04.674499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 09:44:31.384417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 09:44:48.083144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 09:45:04.754304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 09:45:21.462899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 10:01:49.57591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 10:02:06.232034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 10:02:22.913182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 10:02:39.597217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 10:18:47.988573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 10:19:04.711553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 10:19:23.372428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 10:19:40.157375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 10:36:04.541523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 10:36:21.121968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 10:36:37.792395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 10:36:54.527223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 10:53:03.075545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 10:53:19.802711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 10:53:36.489987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 10:53:53.180193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 11:10:20.518383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 11:10:37.204275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 11:10:53.919509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 11:11:10.593969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 11:27:13.008949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 11:27:29.788371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 11:27:46.514522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 11:28:03.234798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 11:44:33.639809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 11:44:50.394207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 11:45:07.106168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 11:45:23.87207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 12:01:29.191574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 12:01:45.941633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 12:02:02.674237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 12:02:19.391198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 12:18:48.007801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 12:19:04.81124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 12:19:21.57238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 12:19:38.691588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 12:35:44.312735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 12:36:01.077774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 12:36:17.859709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 12:36:34.601563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 12:53:03.492525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 12:53:20.243074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 12:53:37.019694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 12:53:53.818665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 13:09:56.135344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 13:10:12.955849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 13:10:29.720558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 13:10:46.537556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 13:27:15.614167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 13:27:32.462999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 13:27:49.292456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 13:28:06.114721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 13:44:15.297775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 13:44:32.174418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 13:44:48.965642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 13:45:05.818892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 14:01:50.236807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 14:02:06.93828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 14:02:23.652868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 14:02:40.276221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 14:18:54.642062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 14:19:11.321424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 14:19:27.99178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 14:19:44.790057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 14:36:13.796703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 14:36:30.556229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 14:36:47.301524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 14:37:04.047573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 14:53:08.173247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 14:53:24.888335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 14:53:41.581828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 14:53:58.472337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 15:10:27.858403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 15:10:44.511628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 15:11:01.214358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 15:11:17.960948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 15:27:27.428211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 15:27:44.153924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 15:28:00.823037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 15:28:17.482969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 15:45:08.564866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 15:45:25.313437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 15:45:42.064382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 15:45:58.814568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 16:02:05.962709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 16:02:22.616261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 16:02:39.266822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 16:02:56.069339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 16:19:23.033947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 16:19:39.745815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 16:19:56.452527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 16:20:13.206751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 16:36:33.964242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 16:36:50.624768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 16:37:07.582898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 16:37:24.307913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 16:56:05.384039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 16:56:22.055915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 16:56:38.760477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 16:56:55.474966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 17:13:06.36999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 17:13:22.997898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 17:13:39.721804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 17:13:56.430022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 17:30:40.505395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 17:31:00.237415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 17:31:16.872011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 17:31:33.605368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 17:48:07.082618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 17:48:23.872989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 17:48:40.81865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 17:48:57.538444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 18:05:28.967943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 18:05:45.668228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 18:06:02.388291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 18:06:19.125754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 18:22:31.407256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 18:22:48.152134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 18:23:04.89257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 18:23:21.582908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 18:40:00.895172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 18:40:17.589215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 18:40:34.381693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 18:40:51.16726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 18:57:08.671486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 18:57:25.37242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 18:57:42.125452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 18:57:58.782416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 19:14:13.362033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 19:14:33.044447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 19:14:49.81386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 19:15:06.516879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 19:32:37.930458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 19:32:54.730188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 19:33:11.418332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 19:33:28.136286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 19:49:46.816743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 19:50:03.461727	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 19:50:20.166685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 19:50:36.950514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 20:06:43.213005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 20:07:03.049864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 20:07:19.836215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 20:07:36.663026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 20:23:47.164984	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 20:24:03.891951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 20:24:20.64523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 20:24:37.405648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 20:40:47.57429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 20:41:04.453327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 20:41:21.393089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 20:41:38.193604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 20:57:47.63637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 20:58:04.501889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 20:58:21.3204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 20:58:38.083387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 21:15:08.09711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 21:15:24.868105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 21:15:41.925669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 21:15:58.754404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 21:32:07.928764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 21:32:24.687673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 21:32:41.413927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 21:32:58.173024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 21:49:09.572128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 21:49:26.307842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 21:49:43.046782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 21:49:59.868469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 22:06:08.556441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 22:06:25.235763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 22:06:41.991192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 22:06:58.70702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 22:23:05.83354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 22:23:22.526603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 22:23:39.19149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 22:23:55.977641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 22:39:58.818262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 22:40:15.520483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 22:40:32.181009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 22:40:48.900216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 22:56:55.511909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 22:57:12.130975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 22:57:28.823842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 22:57:45.554737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 23:13:52.086405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 23:14:08.749647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 23:14:25.449181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 23:14:42.176658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 23:30:52.691636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 23:31:09.356942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 23:31:26.015688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 23:31:42.787105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-13 23:47:48.856218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-13 23:48:05.576522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-13 23:48:22.295367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-13 23:48:39.001755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 00:04:45.444593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 00:05:02.075064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 00:05:18.783336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 00:05:35.517036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 00:21:37.653439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 00:21:54.330384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 00:22:11.011598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 00:22:27.690965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 00:38:30.109378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 00:38:46.764254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 00:39:03.441556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 00:39:20.084877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 00:55:22.245878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 00:55:38.971513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 00:55:55.618355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 00:56:12.282492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 01:12:14.200041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 01:12:30.846889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 01:12:47.496909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 01:13:04.252972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 01:29:06.432117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 01:29:23.052651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 01:29:39.734575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 01:29:56.454212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 01:46:00.512086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 01:46:17.198193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 01:46:33.849458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 01:46:50.542486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 02:02:54.282629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 02:03:10.922206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 02:03:27.587538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 02:03:44.187239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 02:20:10.705103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 02:20:27.335924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 02:20:44.049438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 02:21:00.73595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 02:37:24.545413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 02:37:41.218567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 02:37:57.868374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 02:38:14.525964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 02:54:40.968487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 02:54:57.666345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 02:55:14.344986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 02:55:31.009857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 03:11:56.940624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 03:12:13.663107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 03:12:30.331533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 03:12:47.0206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 03:29:13.380896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 03:29:30.033783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 03:29:46.714389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 03:30:03.307516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 03:46:29.074892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 03:46:45.713613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 03:47:02.394437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 03:47:19.087841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 04:03:45.191609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 04:04:01.873002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 04:04:18.563371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 04:04:35.203187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 04:20:59.155853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 04:21:15.829639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 04:21:32.533649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 04:21:49.198052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 04:38:15.361276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 04:38:32.047998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 04:38:48.613586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 04:39:05.419953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 04:55:29.498361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 04:55:46.210355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 04:56:02.874392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 04:56:19.5772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 05:12:42.742056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 05:12:59.407321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 05:13:16.01166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 05:13:32.694453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 05:29:56.950577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 05:30:13.62646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 05:30:30.279062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 05:30:46.950318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 05:47:11.1436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 05:47:27.788855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 05:47:44.442364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 05:48:01.149721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 06:04:29.207793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 06:04:45.87544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 06:05:02.556164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 06:05:19.162204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 06:21:43.167141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 06:21:59.818602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 06:22:16.550908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 06:22:33.214115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 08:11:19.850379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 08:27:41.680293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 08:27:58.132513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 08:28:14.788304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 08:28:31.24001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 08:45:19.573013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 08:45:36.231512	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 08:45:52.882528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 08:46:09.567395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 09:02:11.73426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 09:02:28.476261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 09:02:45.149619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 09:03:01.838392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 09:20:23.485139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 09:20:40.10533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 09:20:56.783135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 09:21:13.503931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 09:36:57.649866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 09:37:14.296748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 09:37:30.950086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 09:37:47.616719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 09:53:53.90582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 09:54:10.650196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 09:54:27.305355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 09:54:44.013239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 10:10:24.853347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 10:10:41.59243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 10:10:58.15819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 10:11:14.849104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 10:44:16.882477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 10:44:33.570063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 10:44:50.353487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 10:45:07.13678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 11:01:45.116255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 11:02:01.752603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 11:02:19.083309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 11:02:35.956758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 11:18:31.115573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 11:18:48.044596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 11:19:04.793469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 11:19:21.604274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 11:36:16.872857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 11:36:33.601593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 11:36:50.367831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 11:37:07.16456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 11:55:04.097794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 11:55:20.843389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 11:55:37.58087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 11:55:54.311272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 12:13:21.871938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 12:13:38.651193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 12:13:55.328872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 12:14:12.103246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 12:31:21.867928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 12:31:38.558763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 12:31:55.409431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 12:32:12.414124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 12:50:04.944437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 12:50:21.897376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 12:50:38.685007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 12:50:55.508181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 13:08:53.260249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 13:09:10.041122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 13:09:26.885747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 13:09:43.673001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 13:27:18.870657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 13:27:36.060755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 13:27:52.961375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 13:28:09.852326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 13:45:55.747016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 13:46:12.533569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 13:46:29.296281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 13:46:48.40211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 14:04:41.077558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 14:04:58.103153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 14:05:15.020265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 14:05:31.759245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 14:22:55.655269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 14:23:12.608397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 14:23:33.616329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 14:23:50.808762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 14:42:06.587917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 14:42:24.04579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 14:42:44.806783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 14:43:02.04811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 15:00:44.510579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 15:01:03.496168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 15:01:22.596572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 15:01:41.747956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 15:18:39.097554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 15:18:58.011384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 15:19:15.12966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 15:19:44.54904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 15:36:36.797916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 15:36:53.799998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 15:37:10.983504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 15:37:27.705644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 15:54:55.500305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 15:55:12.457344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 15:55:29.69957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 15:55:47.242386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 16:13:10.485829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 16:13:27.330858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 16:13:44.289966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 16:14:01.634052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 16:31:52.485024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 16:32:09.310819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 16:32:26.231052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 16:32:42.909526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 16:48:51.214839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 16:49:07.999082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 16:49:24.904974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 16:49:41.728005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 17:06:19.639803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 17:06:36.461916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 17:06:53.506583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 17:07:11.397527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 17:23:04.253177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 17:23:21.027342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 17:23:37.849369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 17:23:55.600158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 17:40:01.065654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 17:40:19.856263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 17:40:36.774746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 17:40:54.382331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 17:56:58.511313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 17:57:21.101896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 17:57:38.560216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 17:57:55.702451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 18:14:40.773418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 18:14:57.439764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 18:15:14.371851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 18:15:31.168681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 18:31:59.129004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 18:32:16.011425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 18:32:32.973226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 18:32:49.968779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 18:49:46.098791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 18:50:02.856746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 18:50:19.587052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 18:50:36.312911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 19:07:21.959847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 19:07:38.887082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 19:07:55.877761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 19:08:12.874228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 19:25:14.095106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 19:25:31.398697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 19:25:48.820136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 19:26:13.031635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 19:42:26.355306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 19:42:43.157953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 19:43:00.446844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 19:43:17.387842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 19:59:49.132924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 20:00:05.8598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 20:00:22.706031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 20:00:39.69505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 20:16:35.37253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 20:16:52.245803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 20:17:09.170008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 20:17:26.150508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 20:34:20.546067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 20:34:37.329527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 20:34:54.134747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 20:35:11.169191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 20:52:08.653776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 20:52:25.463996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 20:52:42.266406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 20:52:59.168249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 21:09:02.82461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 21:09:19.591168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 21:09:36.329537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 21:09:53.378177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 21:26:45.978123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 21:27:02.734832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 21:27:19.553246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 21:27:36.329775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 21:44:09.015983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 21:44:25.727783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 21:44:42.571403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 21:44:59.338353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 22:01:45.373597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 22:02:02.0771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 22:02:18.878981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 22:02:35.726832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 22:18:59.274103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 22:19:16.007316	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 22:19:32.687502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 22:19:49.409291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 22:36:36.862957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 22:36:53.553083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 22:37:10.236301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 22:37:26.873255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 22:54:16.225786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 22:54:32.922016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 22:54:49.700496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 22:55:06.303315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 23:11:53.925188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 23:12:10.605342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 23:12:27.29236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 23:12:43.936542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 23:29:27.991894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 23:29:44.674197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 23:30:01.462172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 23:30:22.267977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-14 23:47:01.491547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-14 23:47:18.072533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-14 23:47:34.768275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-14 23:47:51.481454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 00:04:15.756269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 00:04:32.462951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 00:04:49.17081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 00:05:05.851953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 00:21:30.08369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 00:21:46.764886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 00:22:03.453519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 00:22:20.155577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 00:38:46.526525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 00:39:03.164746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 00:39:19.749382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 00:39:36.409941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 00:56:00.380504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 00:56:17.030928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 00:56:33.694463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 00:56:50.392615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 01:13:14.499124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 01:13:31.125662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 01:13:47.793571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 01:14:04.481437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 01:30:28.169571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 01:30:44.825145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 01:31:01.491667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 01:31:18.162914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 01:47:42.380469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 01:47:59.061738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 01:48:15.756885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 01:48:32.434095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 02:04:56.401194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 02:05:13.090297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 02:05:29.78162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 02:05:46.425151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 02:22:10.623114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 02:22:27.274136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 02:22:43.944492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 02:23:00.643941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 02:39:26.784733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 02:39:43.431443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 02:40:00.080525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 02:40:16.778568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 02:56:41.014375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 02:56:57.696046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 02:57:14.39589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 02:57:31.058287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 03:13:57.177098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 03:14:13.796903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 03:14:30.458388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 03:14:47.123622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 03:31:10.987537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 03:31:27.667103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 03:31:44.308742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 03:32:00.923961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 03:48:25.144434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 03:48:41.756415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 03:48:58.412161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 03:49:15.098591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 04:05:41.287884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 04:05:57.950442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 04:06:14.616119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 04:06:31.345258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 04:22:55.222163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 04:23:11.861854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 04:23:28.547759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 04:23:45.228088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 04:40:09.41992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 04:40:26.094504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 04:40:42.675335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 04:40:59.383351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 04:57:23.278032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 04:57:39.935993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 04:57:56.640151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 04:58:13.325753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 05:14:37.632216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 05:14:54.238868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 05:15:10.93262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 05:15:27.648644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 05:31:51.789757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 05:32:08.446823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 05:32:25.100966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 05:32:41.777683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 05:49:07.814348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 05:49:24.440952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 05:49:41.132033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 05:49:57.84229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 06:06:23.828811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 06:06:40.492182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 06:06:57.17352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 06:07:13.890514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 06:23:38.220263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 06:23:54.879306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 06:24:11.522309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 06:24:28.207384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 06:40:57.116207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 06:41:13.759781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 06:41:30.431957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 06:41:47.112594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 06:58:11.193249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 06:58:27.857126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 06:58:44.530056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 06:59:01.157981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 07:15:24.983945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 07:15:41.590378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 07:15:58.286149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 07:16:14.987453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 07:32:38.787635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 07:32:55.446226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 07:33:12.13229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 07:33:28.804849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 07:49:52.601406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 07:50:09.240333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 07:50:25.91855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 07:50:42.62191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 08:07:06.466354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 08:07:23.119434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 08:07:39.715159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 08:07:56.408693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 08:24:22.346774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 08:24:39.013145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 08:24:55.713833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 08:25:12.389783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 08:41:36.450672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 08:41:53.110137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 08:42:09.77574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 08:42:26.440716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 08:58:54.838376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 08:59:11.489946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 08:59:28.148003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 08:59:44.864838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 09:16:11.352867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 09:16:27.94732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 09:16:44.709422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 09:17:01.391455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 09:33:36.249158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 09:33:52.922004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 09:34:09.641171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 09:34:26.428727	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 09:51:17.656527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 09:51:34.369042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 09:51:51.060876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 09:52:07.814532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 10:09:02.643648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 10:09:19.385024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 10:09:36.041626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 10:09:52.872661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 10:26:45.760395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 10:27:02.568275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 10:27:19.271837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 10:27:36.160042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 10:44:16.583187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 10:44:33.424756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 10:44:50.187947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 10:45:07.019406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 11:01:52.666448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 11:02:09.485861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 11:02:26.181009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 11:02:42.875842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 11:19:29.901889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 11:19:46.708205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 11:20:03.492003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 11:20:20.222976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 11:36:48.387478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 11:37:05.022991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 11:37:21.751844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 11:37:38.459152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 11:54:59.028979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 11:55:15.873441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 12:12:36.260599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 12:12:53.000028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 12:29:54.960579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 12:30:11.66196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 12:30:28.509538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 12:30:47.257831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 12:47:21.221126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 12:47:37.971631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 12:47:54.697509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 12:48:11.387123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 13:04:54.510114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 13:05:11.267367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 13:05:27.94895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 13:05:44.646429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 13:22:03.076268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 13:22:19.812466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 13:22:36.519392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 13:22:53.287001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 13:39:37.712449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 13:39:54.56461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 13:40:11.323596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 13:40:28.120234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 13:57:15.732104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 13:57:32.431609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 13:57:49.346869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 13:58:06.070995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 14:14:44.384866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 14:15:01.192411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 14:15:18.11812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 14:15:35.560409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 14:31:43.026439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 14:32:00.449293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 14:32:19.538024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 14:32:37.336574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 14:48:44.536524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 14:49:01.277474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 14:49:18.128673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 14:49:34.954534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 15:05:47.403596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 15:06:04.135705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 15:06:21.159571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 15:06:40.239774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 15:22:49.273038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 15:23:06.059654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 15:23:23.235519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 15:23:40.362127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 15:39:53.558848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 15:40:10.445025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 15:40:27.238834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 15:40:44.315952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 15:57:13.21461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 15:57:29.979676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 15:57:46.981301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 15:58:03.781247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 16:14:10.13917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 16:14:31.714203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 16:14:48.665381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 16:15:05.573284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 16:31:18.564649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 16:31:35.366253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 16:31:54.49707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 16:32:13.986319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 16:48:20.741716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 16:48:40.552591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 16:48:57.338036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 16:49:17.092475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 17:05:29.589801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 17:05:48.379764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 17:06:05.098154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 17:06:21.926209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 17:22:57.166408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 17:23:13.928538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 17:23:30.635113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 17:23:47.329561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 17:40:22.459226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 17:40:39.442496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 17:40:56.215618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 17:41:13.003441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 17:58:04.893486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 17:58:21.65293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 17:58:38.482834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 17:58:55.714016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 18:15:33.177253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 18:15:51.93625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 18:16:08.900208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 18:16:25.735713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 18:32:52.677149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 18:33:09.441534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 18:33:26.258027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 18:33:43.528447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 18:49:58.453345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 18:50:15.340646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 18:50:32.105153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 18:50:49.114524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 19:06:44.54944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 19:07:04.479808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 19:07:21.446386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 19:07:39.11857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 19:24:27.659297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 19:24:44.361419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 19:25:01.207641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 19:25:18.086474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 19:41:43.599882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 19:42:00.565165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 19:42:19.687103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 19:42:38.560801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 19:59:28.482764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 19:59:48.621158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 20:00:05.382936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 20:00:22.239334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 20:16:20.4905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 20:16:39.267205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 20:16:56.039637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 20:17:12.813449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 20:33:43.28222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 20:33:59.906245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 20:34:17.352041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 20:34:34.311982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 20:50:24.219183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 20:50:40.976395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 20:51:00.84077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 20:51:18.064365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 21:07:34.214142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 21:07:51.150556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 21:08:09.946431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 21:08:27.362325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 21:24:21.466205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 21:24:38.421407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 21:24:55.338247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 21:25:12.11449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 21:41:21.596903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 21:41:38.630393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 21:41:55.827649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 21:42:13.471799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 21:57:57.807053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 21:58:14.507774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 21:58:31.426062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 21:58:50.213967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 22:15:18.140212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 22:15:37.99864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 22:15:54.712055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 22:16:11.540842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 22:32:16.455535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 22:32:33.226986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 22:32:49.934778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 22:33:06.617291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 22:49:30.690455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 22:49:47.351492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 22:50:04.04959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 22:50:20.721623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 23:06:20.562349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 23:06:37.247484	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 23:06:53.913226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 23:07:10.59362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 23:23:34.986909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 23:23:51.625154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 23:24:08.26037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 23:24:24.98387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 23:40:59.853942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 23:41:16.517559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 23:41:33.228174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 23:41:49.879119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-15 23:58:18.218088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-15 23:58:34.858301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-15 23:58:51.565609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-15 23:59:08.277593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 00:15:34.475623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 00:15:51.177561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 00:16:07.871415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 00:16:24.591181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 00:32:50.916307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 00:33:07.546372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 00:33:24.262884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 00:33:40.922948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 00:50:05.189858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 00:50:21.870041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 00:50:38.536396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 00:50:55.245007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 01:07:41.446148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 01:07:58.148171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 01:08:14.854289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 01:08:31.596365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 01:25:19.941677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 01:25:36.62033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 01:25:53.276997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 01:26:09.920036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 01:42:56.384197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 01:43:13.046773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 01:43:29.734912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 01:43:46.38775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 02:00:32.655369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 02:00:49.332914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 02:01:05.978614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 02:01:22.665927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 02:18:13.149477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 02:18:29.866471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 02:18:46.534793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 02:19:03.138125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 02:35:53.609807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 02:36:10.249217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 02:36:26.907324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 02:36:43.552431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 02:53:29.732588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 02:53:46.415372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 02:54:03.044633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 02:54:19.710498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 03:11:11.134785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 03:11:27.808136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 03:11:44.565547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 03:12:01.234472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 03:28:47.431658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 03:29:04.105994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 03:29:20.79818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 03:29:37.466664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 03:46:25.584724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 03:46:42.252728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 03:46:58.936731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 03:47:15.576719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 04:04:03.314714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 04:04:19.974878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 04:04:36.653816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 04:04:53.322272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 04:21:39.567528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 04:21:56.122834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 04:22:12.857778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 04:22:29.586903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 04:39:15.544121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 04:39:32.115385	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 04:39:48.779707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 04:40:05.437915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 04:56:53.231599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 04:57:09.857157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 04:57:26.524997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 04:57:43.185149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 05:14:31.590305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 05:14:48.192346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 05:15:04.841765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 05:15:21.525805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 05:32:07.443991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 05:32:24.108291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 05:32:40.740143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 05:32:57.408882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 05:49:45.329234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 05:50:01.982312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 05:50:18.654915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 05:50:35.320261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 06:07:21.399301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 06:07:38.039956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 06:07:54.695013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 06:08:11.383272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 06:24:57.064522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 06:25:13.730098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 06:25:30.374892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 06:25:47.086466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 06:42:33.186453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 06:42:49.871587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 06:43:06.568577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 06:43:23.221409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 07:00:09.111549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 07:00:25.793857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 07:00:42.486699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 07:00:59.110703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 07:17:47.090384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 07:18:03.709653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 07:18:20.401423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 07:18:37.045382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 07:35:23.100913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 07:35:39.777217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 07:35:56.396045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 07:36:13.057062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 07:52:58.904954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 07:53:15.553374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 07:53:32.248419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 07:53:48.879815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 08:10:39.187521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 08:10:55.98789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 08:11:12.734768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 08:11:29.443643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 08:27:53.494255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 08:28:10.17399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 08:28:26.767104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 08:28:43.43232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 08:45:09.392864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 08:45:26.054575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 08:45:42.716529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 08:45:59.398694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 09:02:13.802906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 09:02:30.499777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 09:02:47.131971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 09:03:03.802526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 09:19:08.970764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 09:19:25.595486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 09:19:42.26209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 09:19:58.999249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 09:36:10.331983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 09:36:27.011423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 09:36:43.709001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 09:37:00.397488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 09:53:13.35329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 09:53:30.005279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 09:53:46.681651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 09:54:03.390155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 10:10:19.613945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 10:10:36.3315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 10:10:53.211171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 10:11:09.91899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 10:27:25.806885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 10:27:42.495966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 10:27:59.247855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 10:28:15.870524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 10:44:29.731609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 10:44:46.399045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 10:45:03.047411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 10:45:19.79182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 11:01:36.288635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 11:01:52.963412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 11:02:09.734891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 11:02:26.59581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 11:18:17.435809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 11:18:34.125186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 11:18:50.816511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 11:19:07.554959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 11:34:50.643258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 11:35:07.329983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 11:35:24.156589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 11:35:40.882011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 11:51:47.049243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 11:52:03.761741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 11:52:22.649453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 11:52:40.292573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 12:08:27.967407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 12:08:45.398264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 12:09:02.133412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 12:09:19.849388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 12:25:09.308408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 12:25:26.325982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 12:25:43.213536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 12:26:00.117572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 12:41:46.174654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 12:42:03.04042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 12:42:19.998967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 12:42:36.875226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 12:58:41.486466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 12:58:58.185698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 12:59:14.991102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 12:59:32.038817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 13:15:22.601454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 13:15:39.298401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 13:15:56.043904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 13:16:12.876621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 13:32:06.248268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 13:32:22.985839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 13:32:40.007816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 13:32:57.079397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 13:48:44.401079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 13:49:13.878381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 13:49:33.855801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 13:49:50.581534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 14:05:37.528822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 14:05:56.647976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 14:06:16.016766	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 14:06:39.928923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 14:22:37.46423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 14:22:54.329936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 14:23:11.104764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 14:23:27.920527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 14:39:14.328897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 14:39:31.016502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 14:39:47.853547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 14:40:04.602421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 14:56:01.108725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 14:56:17.773664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 14:56:34.621453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 14:56:51.35123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 15:12:40.715377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 15:12:57.464683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 15:13:14.358418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 15:13:31.079669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 15:29:29.744547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 15:29:46.493874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 15:30:03.26064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 15:30:20.028429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 15:46:16.103074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 15:46:32.861336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 15:46:49.602663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 15:47:06.466613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 16:03:07.553417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 16:03:24.279451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 16:03:40.991434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 16:03:57.775535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 16:20:00.200801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 16:20:17.021916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 16:20:33.748917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 16:20:50.560061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 16:36:42.812544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 16:36:59.502013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 16:37:16.1969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 16:37:32.904693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 16:53:24.532914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 16:53:41.371259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 16:53:58.176326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 16:54:15.289008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 17:10:44.816264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 17:11:01.541926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 17:11:18.426881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 17:11:35.178676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 17:28:05.69983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 17:28:22.344873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 17:28:39.165265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 17:28:55.884571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 17:45:25.09216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 17:45:41.88263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 17:45:58.799534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 17:46:15.590864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 18:12:25.809106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 18:12:42.660399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 18:12:59.432296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 18:13:16.292665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 18:30:30.049777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 18:30:46.917061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 18:31:03.710959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 18:31:20.625989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 19:37:43.461206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 20:03:59.181624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 20:04:16.087247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 20:25:11.331738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 20:25:28.661359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 20:25:52.023418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 20:26:11.843654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 20:41:46.148523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 20:42:02.850714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 20:42:19.818011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 20:42:36.667856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 20:58:37.504089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 20:58:54.461579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 20:59:11.31252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 20:59:28.105796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 21:14:55.865107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 21:15:13.334524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 21:15:32.220465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 21:15:49.093403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 21:31:48.564221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 21:32:05.3743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 21:32:24.16677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 21:32:46.706087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 21:48:16.216511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 21:48:35.15818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 21:48:54.480974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 21:49:14.464562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 22:05:38.457818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 22:05:55.212901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 22:06:14.077201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 22:06:33.441049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 22:22:02.665722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 22:22:19.908279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 22:22:36.727441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 22:22:54.271148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 22:39:07.691994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 22:39:24.37462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 22:39:41.1556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 22:39:57.937975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 22:55:46.548301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 22:56:03.224026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 22:56:20.102152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 22:56:36.864792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 23:12:50.685317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 23:13:07.319826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 23:13:24.011672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 23:13:40.757924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 23:28:58.888167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 23:29:15.55128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 23:29:32.271436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 23:29:49.025235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-16 23:46:19.775457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-16 23:46:36.466691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-16 23:46:53.071149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-16 23:47:09.754876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 00:02:52.222118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 00:03:08.910556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 00:03:25.550574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 00:03:42.25057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 00:20:08.905563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 00:20:25.542776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 00:20:42.22574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 00:20:58.914268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 00:36:38.903237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 00:36:55.525301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 00:37:12.214399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 00:37:28.953442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 00:53:53.302337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 00:54:09.938509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 00:54:26.601715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 00:54:43.351872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 01:10:23.565293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 01:10:40.246682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 01:10:56.951181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 01:11:13.604939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 01:27:38.153901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 01:27:54.856361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 01:28:11.552696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 01:28:28.284491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 01:44:08.046318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 01:44:24.685331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 01:44:41.32331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 01:44:58.013981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 02:01:22.350294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 02:01:38.983705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 02:01:55.739435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 02:02:12.382892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 02:17:52.497326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 02:18:09.160929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 02:18:25.829739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 02:18:42.454734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 02:35:06.642499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 02:35:23.274547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 02:35:40.01814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 02:35:56.744461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 02:52:55.04314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 02:53:11.727983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 02:53:28.355538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 02:53:45.062604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 03:10:13.403427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 03:10:30.100285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 03:10:46.719904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 03:11:03.4097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 03:26:45.32969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 03:27:02.017175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 03:27:18.598097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 03:27:35.258867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 03:43:59.544527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 03:44:16.171259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 03:44:32.866561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 03:44:49.600151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 04:00:29.177461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 04:00:45.823526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 04:01:02.480997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 04:01:19.17959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 04:17:42.515897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 04:17:59.1678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 04:18:15.821089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 04:18:32.492352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 04:34:12.227858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 04:34:28.922925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 04:34:45.589524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 04:35:02.242374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 04:51:26.283513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 04:51:42.90518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 04:51:59.580652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 04:52:16.266113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 05:07:56.005303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 05:08:12.654734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 05:08:29.343719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 05:08:46.054731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 05:25:10.372026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 05:25:27.030315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 05:25:43.734132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 05:26:00.381193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 05:41:39.952747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 05:41:56.588429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 05:42:13.294164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 05:42:30.008464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 05:58:53.881449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 05:59:10.451882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 05:59:27.136335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 05:59:43.857799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 06:15:25.486121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 06:15:42.126666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 06:15:58.800685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 06:16:15.519526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 06:32:39.534534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 06:32:56.194425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 06:33:12.888145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 06:33:29.551957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 06:49:53.634072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 06:50:10.584834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 06:50:27.278226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 06:50:43.942774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 07:07:52.40344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 07:08:09.051403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 07:08:25.746855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 07:08:42.416497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 07:25:08.8026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 07:25:25.406209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 07:25:42.043722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 07:25:58.706251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 07:43:09.273732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 07:43:25.986868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 07:43:42.727423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 07:43:59.414536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 08:00:29.566662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 08:00:46.223833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 08:01:02.85502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 08:01:19.518772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 08:18:41.550486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 08:18:58.220101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 08:19:15.076597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 08:19:31.744892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 08:35:58.012373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 08:36:14.669223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 08:36:31.349508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 08:36:48.038399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 08:53:58.458268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 08:54:15.113015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 08:54:31.811049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 08:54:48.498564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 09:10:54.557924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 09:11:11.449093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 09:11:28.243272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 09:11:44.965913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 09:28:31.48419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 09:28:48.167016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 09:29:04.833331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 09:29:21.48154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 09:45:03.717231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 09:45:20.423667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 09:45:37.080389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 09:45:53.813352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 10:02:22.368917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 10:02:39.02152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 10:02:55.969911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 10:03:12.714259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 10:19:05.1803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 10:19:21.864836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 10:19:38.559286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 10:19:55.258163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 10:36:29.517458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 10:36:46.2286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 10:37:02.860528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 10:37:19.645171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 10:53:08.346274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 10:53:24.985417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 10:53:41.647383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 10:53:58.3817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 11:10:29.010994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 11:10:45.759917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 11:11:02.431144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 11:11:19.087968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 11:27:01.598075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 11:27:18.287738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 11:27:34.986679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 11:27:51.718178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 11:44:16.453383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 11:44:33.289756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 11:44:50.026243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 11:45:06.787819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 12:00:57.393323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 12:01:14.254752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 12:01:31.007024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 12:01:47.928891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 12:18:22.718047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 12:18:39.451154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 12:18:56.05041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 12:19:12.844672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 12:35:05.94169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 12:35:22.618552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 12:35:39.266403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 12:35:55.973943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 12:52:41.229528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 12:52:57.93424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 12:53:14.66698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 12:53:31.394429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 13:09:24.47393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 13:09:41.285766	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 13:09:58.204096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 13:10:14.937094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 13:26:53.883227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 13:27:10.611531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 13:27:27.360904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 13:27:44.09598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 13:44:02.100622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 13:44:18.807293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 13:44:35.702499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 13:44:52.390247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 14:01:27.575159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 14:01:44.301141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 14:02:01.020412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 14:02:17.732872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 14:18:49.032256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 14:19:05.841215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 14:19:22.603572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 14:19:39.311194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 14:36:04.067821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 14:36:20.899604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 14:36:37.781356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 14:36:56.493303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 14:53:20.04802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 14:53:36.70844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 14:53:53.407863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 14:54:10.159292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 15:10:46.75213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 15:11:03.481869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 15:11:20.379097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 15:11:37.149911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 15:28:06.160019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 15:28:22.967023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 15:28:39.691472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 15:28:56.540382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 15:45:51.746255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 15:46:08.907291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 15:46:26.069266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 15:46:45.153409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 16:04:35.154411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 16:04:51.872511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 16:05:08.578311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 16:05:25.307089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 16:23:34.298511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 16:23:51.000049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 16:24:07.73608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 16:24:24.592117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 16:41:53.061067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 16:42:09.888922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 16:42:26.73059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 16:42:43.592886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 16:59:54.033478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 17:00:10.734345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 17:00:27.527159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 17:00:44.338085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 17:18:07.92039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 17:18:24.980935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 17:18:41.747513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 17:18:58.416332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 17:36:13.559454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 17:36:30.299425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 17:36:47.034753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 17:37:03.845911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 17:54:06.424041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 17:54:25.270154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 17:54:42.33071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 17:54:59.38892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 18:11:39.363601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 18:11:56.451301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 18:12:15.765486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 18:12:33.559778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 18:29:32.470414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 18:29:56.930051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 18:30:14.273726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 18:30:33.760086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 18:47:07.144263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 18:47:23.864927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 18:47:41.163011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 18:48:00.803618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 19:04:19.754851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 19:04:39.908632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 19:04:57.762302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 19:05:15.423558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 19:21:43.71919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 19:22:03.031279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 19:22:20.788047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 19:22:39.69675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 19:38:39.517982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 19:38:56.185589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 19:39:13.050813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 19:39:29.832418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 19:55:38.507093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 19:55:55.270557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 19:56:12.342073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 19:56:29.175605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 20:13:16.941875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 20:13:33.751571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 20:13:50.572033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 20:14:07.411448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 20:31:02.441865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 20:31:19.112997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 20:31:36.022828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 20:31:52.917224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 20:48:19.451462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 20:48:36.44575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 20:48:53.41335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 20:49:14.250923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 21:05:41.247106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 21:05:58.538394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 21:06:15.951947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 21:06:34.828505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 21:22:56.854051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 21:23:13.739812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 21:23:30.680685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 21:23:48.082051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 21:40:22.354378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 21:40:39.237699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 21:40:55.912337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 21:41:12.710402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 21:57:02.272128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 21:57:19.009475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 21:57:36.038669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 21:57:52.636778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 22:13:51.897233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 22:14:08.595365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 22:14:25.348583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 22:14:42.084531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 22:31:11.222258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 22:31:27.914625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 22:31:44.550836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 22:32:01.30957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 22:47:52.481925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 22:48:09.207624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 22:48:25.872175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 22:48:42.656962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 23:05:14.188719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 23:05:30.948056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 23:05:47.62183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 23:06:04.286656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 23:22:00.412023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 23:22:17.095759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 23:22:33.819905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 23:22:50.512673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 23:39:42.776489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 23:39:59.415346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 23:40:16.155068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 23:40:32.939394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-17 23:56:40.971369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-17 23:56:57.650205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-17 23:57:14.269607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-17 23:57:30.950746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 00:14:19.375801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 00:14:36.072992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 00:14:52.726928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 00:15:09.389403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 00:31:10.340616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 00:31:27.036943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 00:31:43.696787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 00:32:00.43087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 00:48:48.40123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 00:49:05.110853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 00:49:21.679977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 00:49:38.34336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 01:05:40.526449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 01:05:57.152809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 01:06:13.853431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 01:06:30.522918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 01:23:16.947682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 01:23:33.611915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 01:23:50.302214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 01:24:06.98579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 01:40:08.966907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 01:40:25.533706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 01:40:42.231632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 01:40:58.952081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 01:57:44.891489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 01:58:01.512289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 01:58:18.143475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 01:58:34.819076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 02:14:38.812519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 02:14:55.440307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 02:15:12.104473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 02:15:28.870911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 02:32:24.992087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 02:32:41.689495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 02:32:58.367405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 02:33:15.051345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 02:49:17.004186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 02:49:33.674709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 02:49:50.382509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 02:50:07.016629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 03:06:53.086748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 03:07:09.737964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 03:07:26.423744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 03:07:43.097707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 03:24:13.458336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 03:24:30.115437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 03:24:46.785669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 03:25:03.453798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 03:42:21.122638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 03:42:37.764469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 03:42:54.442217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 03:43:11.135378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 03:59:52.735291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 04:00:09.417228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 04:00:26.132812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 04:00:42.760399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 04:17:29.11481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 04:17:45.734991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 04:18:02.437958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 04:18:19.150412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 04:34:50.514019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 04:35:07.202391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 04:35:23.850278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 04:35:40.5276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 04:52:34.902499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 04:52:51.541078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 04:53:08.204225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 04:53:24.898616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 05:09:29.182524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 05:09:45.793706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 05:10:02.440257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 05:10:19.132209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 05:27:07.372026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 05:27:24.053438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 05:27:40.732926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 05:27:57.419994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 05:44:07.836942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 05:44:24.52866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 05:44:41.168563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 05:44:57.760016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 06:01:50.223102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 06:02:06.91327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 06:02:23.632714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 06:02:40.237178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 06:18:48.538271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 06:19:05.205774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 06:19:21.87051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 06:19:38.530507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 06:36:43.81563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 06:37:00.479991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 06:37:17.120179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 06:37:33.78653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 06:53:46.044728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 06:54:02.714273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 06:54:19.384339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 06:54:36.090246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 07:11:02.348684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 07:11:18.999849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 07:11:35.651692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 07:11:52.35169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 07:27:32.385874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 07:27:49.047571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 07:28:05.643441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 07:28:22.346299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 07:44:57.227051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 07:45:13.896109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 07:45:30.617513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 07:45:47.233097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 08:01:31.274455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 08:01:47.963496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 08:02:04.665253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 08:02:21.720557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 08:18:52.542846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 08:19:09.207492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 08:19:25.858398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 08:19:42.516334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 08:37:51.664028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 08:38:08.340088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 08:38:25.066293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 08:38:41.926165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 08:54:52.697555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 08:55:09.364298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 08:55:26.060061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 08:55:42.796866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 09:11:59.363089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 09:12:16.016489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 09:12:32.681067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 09:12:49.388853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 09:29:05.39996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 09:29:22.069198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 09:29:38.784708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 09:29:55.404722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 09:46:21.328689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 09:46:37.950408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 09:46:54.656582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 09:47:11.392338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 10:03:29.338417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 10:03:46.027095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 10:04:02.698635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 10:04:19.376288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 10:20:28.858983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 10:20:45.599913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 10:21:02.321207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 10:21:19.205066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 10:37:43.46561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 10:38:00.239312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 10:38:17.004276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 10:38:33.863232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 10:54:51.633542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 10:55:08.477709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 10:55:25.150012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 10:55:41.931677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 11:12:09.15413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 11:12:25.875389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 11:12:42.591172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 11:12:59.342814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 11:29:00.236774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 11:29:17.027844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 11:29:33.702603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 11:29:50.400698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 11:46:25.972135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 11:46:42.611191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 11:46:59.341467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 11:47:16.029176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 12:03:25.17863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 12:03:41.882733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 12:03:58.595593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 12:04:15.297925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 12:21:18.322781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 12:21:35.086387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 12:21:51.855435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 12:22:08.528591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 12:38:19.805498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 12:38:36.625156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 12:38:53.408039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 12:39:10.302799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 12:56:03.246318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 12:56:20.021936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 12:56:36.66976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 12:56:53.413162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 13:13:17.81875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 13:13:34.586436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 13:13:51.280054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 13:14:08.019371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 13:30:24.75609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 13:30:41.47647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 13:30:58.184909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 13:31:15.001357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 13:46:39.644659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 13:46:56.374386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 13:47:13.181225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 13:47:29.941051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 14:03:47.233123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 14:04:03.96146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 14:04:20.673235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 14:04:37.437944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 14:20:22.254254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 14:20:39.01487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 14:20:55.783342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 14:21:12.464789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 14:37:07.831802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 14:37:24.619556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 14:37:41.39601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 14:37:58.15572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 14:53:47.624909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 14:54:04.434503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 14:54:26.603304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 14:54:43.514153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 15:11:01.732985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 15:11:18.442592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 15:11:35.230087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 15:11:52.144001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 15:27:28.868051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 15:27:46.004337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 15:28:02.779087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 15:28:19.77364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 15:44:37.571975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 15:44:57.396326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 15:45:14.127433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 15:45:31.06655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 16:01:15.553768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 16:01:32.346428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 16:01:49.082351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 16:02:05.796887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 16:18:23.097168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 16:18:39.835711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 16:18:56.801515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 16:19:15.918998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 16:34:56.230426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 16:35:12.957127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 16:35:29.762377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 16:35:46.46244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 16:51:59.784732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 16:52:16.493762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 16:52:33.265902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 16:52:50.007987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 17:08:58.271993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 17:09:15.004905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 17:09:31.680203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 17:09:48.437829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 17:25:40.026848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 17:25:56.822343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 17:26:13.639094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 17:26:33.393591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 17:42:33.047441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 17:42:49.748427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 17:43:06.520318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 17:43:23.257074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 18:00:02.74787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 18:00:19.544357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 18:00:36.296622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 18:00:53.064389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 18:17:27.703351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 18:17:44.490572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 18:18:01.246658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 18:18:18.039679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 18:35:10.172899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 18:35:26.983993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 18:35:43.830009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 18:36:00.608002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 18:52:44.916164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 18:53:01.636152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 18:53:18.413378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 18:53:35.14998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 19:10:29.461632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 19:10:46.262978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 19:11:03.034891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 19:11:19.803523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 19:28:42.412981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 19:28:59.17567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 19:29:16.095705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 19:29:32.771787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 19:46:19.942725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 19:46:36.691268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 19:46:53.475438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 19:47:10.326892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 20:11:42.671175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 20:11:59.363778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 20:12:16.183192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 20:31:21.944554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 20:31:38.454753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 20:31:55.198238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 20:48:16.584246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 20:48:33.375957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 20:48:50.208116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 21:06:48.460535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 21:07:05.196186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 21:07:21.964212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 21:23:21.306012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 21:23:38.174796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 21:23:55.218427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 21:24:12.353555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 21:40:23.657449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 21:40:40.377543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 21:40:57.173157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 21:41:13.928928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 21:57:32.599368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 21:57:49.339721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 21:58:06.132485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 21:58:22.925617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 22:14:17.993206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 22:14:34.609918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 22:14:51.33756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 22:15:08.124201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 22:31:29.153957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 22:31:45.930925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 22:32:02.625702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 22:32:19.274368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 22:48:08.190742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 22:48:24.901686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 22:48:41.584784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 22:48:58.276931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 23:05:02.958637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 23:05:19.684588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 23:05:36.331571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 23:05:53.036639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 23:21:39.315733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 23:21:56.000937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 23:22:12.642348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 23:22:29.219438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 23:38:17.687676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 23:38:34.381211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 23:38:51.003736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 23:39:07.68209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-18 23:54:57.925421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-18 23:55:14.594447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-18 23:55:31.252148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-18 23:55:47.898081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 00:11:41.256728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 00:11:57.948443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 00:12:14.608986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 00:12:31.288574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 00:28:17.560968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 00:28:34.270872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 00:28:50.936242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 00:29:07.626287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 00:45:09.701112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 00:45:26.398433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 00:45:43.136674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 00:45:59.801906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 01:02:01.571652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 01:02:18.225241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 01:02:34.89326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 01:02:51.575486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 01:18:53.279116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 01:19:09.88081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 01:19:26.573904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 01:19:43.256918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 01:35:45.228693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 01:36:01.934684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 01:36:18.605575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 01:36:35.315002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 01:52:42.969534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 01:52:59.666355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 01:53:16.312589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 01:53:32.991246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 02:09:36.824226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 02:09:53.489337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 02:10:10.137888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 02:10:26.824279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 02:26:34.281044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 02:26:50.933132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 02:27:07.621977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 02:27:24.265473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 02:43:25.736772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 02:43:42.432848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 02:43:59.107047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 02:44:15.782337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 03:00:42.11543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 03:00:58.918823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 03:01:15.575551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 03:01:32.237227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 03:18:13.783911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 03:18:30.497778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 03:18:47.135404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 03:19:03.821886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 03:35:27.891642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 03:35:44.570696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 03:36:01.215977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 03:36:17.933361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 03:52:41.697591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 03:52:58.253926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 03:53:14.922837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 03:53:31.708443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 04:09:56.005323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 04:10:12.619808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 04:10:29.277159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 04:10:45.926432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 04:27:08.861398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 04:27:25.501028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 04:27:42.158905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 04:27:58.870016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 04:44:22.928146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 04:44:39.615759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 04:44:56.292618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 04:45:12.931826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 05:01:36.604868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 05:01:53.275317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 05:02:09.94993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 05:02:26.658348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 05:18:50.667171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 05:19:07.339598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 05:19:23.961919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 05:19:40.660823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 05:36:06.389651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 05:36:23.085731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 05:36:39.71756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 05:36:56.390199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 05:53:24.249328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 05:53:40.800019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 05:53:57.435081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 05:54:14.109322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 06:10:57.242291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 06:11:13.897437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 06:11:30.523045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 06:11:47.180156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 06:28:11.497443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 06:28:28.151783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 06:28:44.826055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 06:29:01.492447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 06:45:52.117722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 06:46:08.794315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 06:46:25.469209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 06:46:42.1231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 07:03:30.199092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 07:03:46.886199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 07:04:03.554815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 07:04:20.207142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 07:21:12.721787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 07:21:29.379662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 07:21:46.088637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 07:22:02.698484	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 07:38:53.022629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 07:39:09.684889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 07:39:26.368846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 07:39:43.013305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 07:56:35.443101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 07:56:52.136038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 07:57:08.833559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 07:57:25.468398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 08:14:18.723566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 08:14:35.394296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 08:14:52.064215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 08:15:08.735633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 08:31:57.19438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 08:32:13.829484	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 08:32:30.495961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 08:32:47.388757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 08:49:35.987647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 08:49:52.66136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 08:50:09.371076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 08:50:26.007452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 09:07:22.491959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 09:07:39.155686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 09:07:55.857013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 09:08:12.513179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 09:25:07.010035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 09:25:23.697903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 09:25:40.356064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 09:25:57.039169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 09:42:57.620447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 09:43:14.271658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 09:43:30.960378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 09:43:47.689312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 10:00:40.190699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 10:00:56.895198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 10:01:13.566164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 10:01:30.317288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 10:18:25.844515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 10:18:42.562421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 10:18:59.244649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 10:19:15.84152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 10:36:12.895453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 10:36:29.572631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 10:36:46.19705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 10:37:02.884831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 10:53:31.24075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 10:53:47.894742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 10:54:04.542973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 10:54:21.278547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 11:10:27.894327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 11:10:44.570804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 11:11:01.243387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 11:11:17.942328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 11:27:22.371311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 11:27:39.091454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 11:27:55.794957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 11:28:12.477242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 11:44:14.866317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 11:44:31.571132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 11:44:48.275771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 11:45:04.962719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 12:01:07.633426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 12:01:24.303154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 12:01:40.99113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 12:01:57.71936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 12:18:02.146314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 12:18:18.850213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 12:18:35.536599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 12:18:52.195301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 12:35:01.097483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 12:35:17.772766	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 12:35:34.436809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 12:35:51.163239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 12:52:03.872298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 12:52:20.538992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 12:52:37.483152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 12:52:54.187782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 13:09:00.517654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 13:09:17.19137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 13:09:33.958069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 13:09:50.626476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 13:26:05.293664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 13:26:21.991021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 13:26:38.619127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 13:26:55.307963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 13:42:59.828824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 13:43:16.507669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 13:43:33.137358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 13:43:49.848029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 14:00:02.651548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 14:00:19.32112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 14:00:36.036089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 14:00:52.754288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 14:17:06.26782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 14:17:23.025861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 14:17:39.969162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 14:17:57.516847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 14:34:09.806624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 14:34:26.427079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 14:34:43.174243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 14:34:59.956275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 14:51:33.816647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 14:51:50.546259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 14:52:07.334351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 14:52:24.015048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 15:08:47.415465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 15:09:04.045814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 15:09:20.759846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 15:09:37.462436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 15:26:05.083822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 15:26:21.760424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 15:26:38.408339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 15:26:55.139627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 15:43:22.859323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 15:43:39.602643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 15:43:56.2989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 15:44:13.103425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 16:00:38.581614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 16:00:55.262767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 16:01:11.948155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 16:01:28.881832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 16:18:06.685417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 16:18:23.380654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 16:18:40.184343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 16:18:56.918819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 16:35:26.997047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 16:35:43.873328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 16:36:00.567843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 16:36:17.636992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 16:52:29.515927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 16:52:46.206274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 16:53:02.986732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 16:53:19.675208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 17:09:38.602768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 17:09:55.349089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 17:10:12.041654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 17:10:28.806835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 17:26:54.560128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 17:27:11.480939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 17:27:28.253693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 17:27:45.151113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 17:44:03.506949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 17:44:20.310282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 17:44:37.191185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 17:44:53.959195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 18:01:08.02726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 18:01:25.13107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 18:01:41.88378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 18:01:58.80726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 18:18:33.541564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 18:18:52.448675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 18:19:09.362822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 18:19:28.27714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 18:35:54.756618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 18:36:11.450588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 18:36:28.220304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 18:36:44.929126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 18:53:11.429142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 18:53:28.372505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 18:53:45.341758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 18:54:02.173731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 19:10:22.495575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 19:10:39.276651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 19:10:56.092942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 19:11:12.875553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 19:27:28.135228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 19:27:45.223989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 19:28:02.028632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 19:28:18.710445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 19:44:43.327449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 19:45:00.105889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 19:45:16.939169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 19:45:34.627871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 20:01:57.347554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 20:02:14.024958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 20:02:30.782417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 20:02:47.602475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 20:19:15.811994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 20:19:32.512576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 20:19:49.270992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 20:20:06.085517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 20:36:18.914912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 20:36:35.64437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 20:36:52.367677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 20:37:11.034408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 20:53:00.953608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 20:53:17.682964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 20:53:34.537742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 20:53:53.225713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 21:09:47.858114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 21:10:04.544774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 21:10:21.473361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 21:10:38.258866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 21:26:27.83626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 21:26:44.542503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 21:27:01.428717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 21:27:20.364177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 21:42:40.245671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 21:42:56.980751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 21:43:13.959424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 21:43:30.963439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 22:01:09.344338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 22:01:46.366375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 22:05:23.192848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 22:20:55.159373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 22:21:11.727193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 22:21:28.913284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 22:21:47.705764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 22:37:51.474096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 22:38:08.09132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 22:38:24.700209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 22:38:41.216872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 22:53:58.895772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 22:54:15.430982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 22:54:32.144977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 22:54:48.663123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 23:10:42.509355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 23:10:59.079029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 23:11:15.759765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 23:11:32.289327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 23:27:06.141535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 23:27:22.738309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 23:27:39.400555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 23:27:55.928072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-19 23:44:23.460425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-19 23:44:40.170388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-19 23:44:56.918567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-19 23:45:13.606519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 00:00:53.875814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 00:01:10.542789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 00:01:27.21906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 00:01:43.914563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 00:18:09.903422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 00:18:26.561605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 00:18:43.219561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 00:18:59.937393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 00:34:41.566851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 00:34:58.244098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 00:35:14.833635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 00:35:31.524521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 00:51:55.801256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 00:52:12.440122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 00:52:29.126452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 00:52:45.848978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 01:08:27.443851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 01:08:44.063976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 01:09:00.712238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 01:09:17.407993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 01:25:41.234838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 01:25:57.889131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 01:26:14.489805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 01:26:31.236848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 01:42:10.651338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 01:42:27.401264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 01:42:44.03309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 01:43:00.623181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 01:59:30.667834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 01:59:47.286141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 02:00:03.908275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 02:00:20.591883	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 02:15:59.879619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 02:16:16.488204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 02:16:33.183659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 02:16:49.867507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 02:33:13.729444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 02:33:30.456723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 02:33:47.103085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 02:34:03.712448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 02:49:45.5295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 02:50:02.156605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 02:50:18.807422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 02:50:35.482127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 03:06:59.634447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 03:07:16.245479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 03:07:32.921746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 03:07:49.617421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 03:23:35.064194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 03:23:51.611474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 03:24:08.256423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 03:24:24.923485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 03:40:48.598884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 03:41:05.289893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 03:41:21.920185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 03:41:38.524728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 03:57:18.130295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 03:57:34.820544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 03:57:51.510055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 03:58:08.120565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 04:14:32.04273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 04:14:48.667577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 04:15:05.302461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 04:15:21.997441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 04:31:03.70274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 04:31:20.323264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 04:31:36.922523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 04:31:53.586912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 04:48:17.517869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 04:48:34.154984	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 04:48:50.803929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 04:49:07.496228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 05:04:53.217794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 05:05:09.842115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 05:05:26.504323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 05:05:43.368925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 05:22:09.458761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 05:22:26.137751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 05:22:42.749583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 05:22:59.405695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 05:38:39.027734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 05:38:55.684154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 05:39:12.319714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 05:39:28.992864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 05:55:52.953558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 05:56:09.629206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 05:56:26.293251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 05:56:42.998894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 06:12:27.775607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 06:12:44.43978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 06:13:01.088116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 06:13:17.844643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 06:29:41.858791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 06:29:58.511428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 06:30:15.082237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 06:30:31.772393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 06:46:11.582962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 06:46:28.20764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 06:46:44.885246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 06:47:01.588629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 07:03:29.267451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 07:03:45.877547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 07:04:02.524949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 07:04:19.212908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 07:20:00.713808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 07:20:17.39052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 07:20:34.034555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 07:20:50.737143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 07:37:18.94243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 07:37:35.573492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 07:37:52.140524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 07:38:08.819596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 07:53:50.28611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 07:54:06.965838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 07:54:23.566864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 07:54:40.262544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 08:11:04.706152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 08:11:21.398356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 08:11:38.079841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 08:11:54.755514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 08:27:36.671103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 08:27:53.30506	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 08:28:10.088542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 08:28:26.789053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 08:44:53.055764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 08:45:09.711545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 08:45:26.328627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 08:45:43.021087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 09:01:39.85493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 09:01:56.523083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 09:02:13.362269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 09:02:30.048618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 09:19:07.794367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 09:19:24.454878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 09:19:41.132883	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 09:19:57.753907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 09:35:46.51091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 09:36:03.23605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 09:36:19.972637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 09:36:36.716816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 09:53:11.848535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 09:53:28.559131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 09:53:46.030121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 09:54:02.831417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 10:09:51.160609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 10:10:07.817431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 10:10:24.653803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 10:10:41.857587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 10:26:53.611929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 10:27:10.703121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 10:27:27.621745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 10:27:44.729691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 10:43:16.427584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 10:43:33.848526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 10:43:51.655932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 10:44:08.784309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 11:00:27.023479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 11:00:43.755452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 11:01:00.527681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 11:01:17.367739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 11:16:46.881016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 11:17:03.822845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 11:17:20.568753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 11:17:37.376209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 11:33:51.274234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 11:34:08.222671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 11:34:24.860713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 11:34:41.684051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 11:50:26.87443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 11:50:43.694173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 11:51:00.616334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 11:51:17.469724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 12:07:37.309058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 12:07:54.198261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 12:08:11.028385	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 12:08:28.059164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 12:24:12.380428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 12:24:29.068478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 12:24:46.046203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 12:25:03.373655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 12:41:25.714932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 12:41:42.857655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 12:42:00.016427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 12:42:18.965768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 12:57:59.80513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 12:58:16.597124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 12:58:33.345456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 12:58:50.102741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 13:15:09.821576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 13:15:26.60021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 13:15:43.427821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 13:16:02.36893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 13:31:51.116322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 13:32:07.958594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 13:32:24.823788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 13:32:41.616448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 13:49:39.339903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 13:49:56.157595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 13:50:12.885451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 13:50:31.649189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 14:06:01.833228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 14:06:18.966038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 14:06:36.275222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 14:06:55.194964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 14:23:25.643435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 14:23:43.06768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 14:24:00.16814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 14:24:17.093604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 14:39:51.5857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 14:40:13.705001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 14:40:31.138266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 14:40:49.182623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 14:57:24.848957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 14:57:42.082306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 14:57:59.435769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 14:58:18.652503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 15:13:48.31443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 15:14:05.031847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 15:14:21.925617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 15:14:39.217679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 15:30:58.27751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 15:31:15.327177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 15:31:32.054956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 15:31:51.338066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 15:47:23.104879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 15:47:40.434186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 15:47:57.582942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 15:48:14.405378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 16:04:32.141328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 16:04:48.845479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 16:05:05.736648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 16:05:22.664082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 16:20:50.322587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 16:21:07.11042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 16:21:23.936138	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 16:21:42.835215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 16:38:12.750244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 16:38:29.528236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 16:38:46.784945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 16:39:05.978918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 16:54:47.121781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 16:55:03.81737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 16:55:20.560537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 16:55:37.391746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 17:12:06.484293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 17:12:23.480886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 17:12:40.261874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 17:12:57.092795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 17:28:36.284072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 17:28:53.011358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 17:29:09.80439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 17:29:26.59757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 17:46:00.022856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 17:46:16.667285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 17:46:33.502323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 17:46:50.236312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 20:47:25.344626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 20:47:42.224156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 20:47:58.972056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 20:48:17.74392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 21:04:52.211321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 21:05:09.13995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 21:05:25.921744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 21:05:42.631063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 21:21:08.750595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 21:21:25.40147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 21:21:42.986437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 21:21:59.78497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 21:38:13.716896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 21:38:30.651654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 21:38:47.383064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 21:39:04.16587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 21:54:35.635376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 21:54:52.370869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 21:55:09.185639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 21:55:25.971068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 22:11:53.959783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 22:12:10.75584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 22:12:27.736017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 22:12:44.436985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 22:28:11.283868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 22:28:28.040769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 22:28:44.803868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 22:29:01.779765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 22:45:08.479055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 22:45:25.217326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 22:45:41.991231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 22:45:58.607915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 23:01:20.346276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 23:01:36.962023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 23:01:53.639821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 23:02:10.392938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 23:18:23.085991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 23:18:39.732445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 23:18:56.405845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 23:19:13.149714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 23:34:35.592095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 23:34:52.26534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 23:35:08.950292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 23:35:25.648163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-20 23:51:28.081733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-20 23:51:44.783488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-20 23:52:01.467579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-20 23:52:18.199622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 00:07:38.320588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 00:07:54.986735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 00:08:11.593711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 00:08:28.259852	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 00:24:30.5438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 00:24:47.197678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 00:25:03.803647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 00:25:20.472577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 00:41:02.491171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 00:41:19.20792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 00:41:35.911991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 00:41:52.590002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 00:58:20.802134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 00:58:37.417439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 00:58:54.103295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 00:59:10.739286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 01:15:23.380539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 01:15:40.058605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 01:15:56.742776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 01:16:13.403821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 01:32:41.596176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 01:32:58.248689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 01:33:14.901706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 01:33:31.534637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 01:49:11.577839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 01:49:28.264087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 01:49:44.985043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 01:50:01.65676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 02:06:25.506749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 02:06:42.235042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 02:06:58.892736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 02:07:15.621583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 02:22:55.324612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 02:23:11.966194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 02:23:28.60647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 02:23:45.327017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 02:40:09.359909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 02:40:25.995602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 02:40:42.671318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 02:40:59.385855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 02:56:41.311311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 02:56:57.961029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 02:57:14.671773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 02:57:31.326693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 03:13:55.243858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 03:14:11.915363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 03:14:28.540154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 03:14:45.198204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 03:30:25.432276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 03:30:42.115602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 03:30:58.756006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 03:31:15.428699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 03:47:39.430223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 03:47:56.06168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 03:48:12.749887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 03:48:29.4425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 04:04:09.220465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 04:04:25.816529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 04:04:42.485384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 04:04:59.144277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 04:21:23.15856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 04:21:39.811032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 04:21:56.403357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 04:22:13.054519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 04:37:52.889428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 04:38:09.503026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 04:38:26.157296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 04:38:42.784526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 04:55:08.479092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 04:55:25.14823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 04:55:41.786732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 04:55:58.477467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 05:11:37.994932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 05:11:54.593146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 05:12:11.330668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 05:12:28.022321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 05:28:52.139648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 05:29:08.782357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 05:29:25.386451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 05:29:42.052307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 05:45:22.143716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 05:45:38.788401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 05:45:55.469393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 05:46:12.131104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 06:02:36.099856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 06:02:52.732473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 06:03:09.366928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 06:03:26.028429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 06:19:11.99001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 06:19:28.629374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 06:19:45.276912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 06:20:01.953483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 06:36:27.916994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 06:36:44.585928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 06:37:01.193589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 06:37:17.898306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 06:52:57.461604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 06:53:14.114014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 06:53:30.813064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 06:53:47.439315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 07:10:15.298295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 07:10:31.967647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 07:10:48.608795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 07:11:05.305002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 07:26:53.372449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 07:27:10.025095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 07:27:26.691477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 07:27:43.421662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 07:44:13.461862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 07:44:30.125338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 07:44:46.762204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 07:45:03.444364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 08:00:50.018623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 08:01:06.715019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 08:01:23.368753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 08:01:40.092343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 08:18:04.088086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 08:18:20.742183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 08:18:37.399214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 08:18:54.03804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 08:34:38.158686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 08:34:54.87131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 08:35:11.560886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 08:35:28.190379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 08:52:08.39524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 08:52:25.070692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 08:52:41.729744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 08:52:58.425391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 09:08:44.657679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 09:09:01.343616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 09:09:18.123976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 09:09:34.810155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 09:26:12.225297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 09:26:28.87302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 09:26:45.558176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 09:27:02.33277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 09:42:54.2846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 09:43:11.119184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 09:43:28.021019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 09:43:44.864633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 10:00:31.20161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 10:00:48.244587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 10:01:05.457151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 10:01:24.455618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 10:17:25.134257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 10:17:41.874914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 10:17:59.696202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 10:18:16.639588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 10:34:50.045069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 10:35:07.261649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 10:35:24.579298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 10:35:44.420297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 10:51:09.863111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 10:51:26.665621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 10:51:43.450737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 10:52:00.142943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 11:08:19.801476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 11:08:37.015353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 11:08:54.208266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 11:09:13.784137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 11:25:01.568223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 11:25:18.277378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 11:25:35.007188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 11:25:51.722836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 11:42:20.89587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 11:42:37.959886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 11:42:54.661266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 11:43:11.350117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 11:59:02.77439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 11:59:19.612492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 11:59:36.347034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 11:59:53.704468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 12:16:24.917847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 12:16:41.682454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 12:16:58.471676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 12:17:15.680571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 12:32:43.992857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 12:33:00.752282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 12:33:17.425036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 12:33:34.268683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 12:49:50.456004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 12:50:07.311093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 12:50:24.337751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 12:50:41.719257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 13:06:27.660775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 13:06:44.523706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 13:07:01.216865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 13:07:18.30074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 13:24:41.273029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 13:24:58.151329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 13:25:15.306799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 13:25:32.299108	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 13:40:49.717246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 13:41:06.434977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 13:41:23.371196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 13:41:40.135403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 13:57:52.926209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 13:58:10.718379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 13:58:27.740275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 13:58:44.410776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 14:14:36.268933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 14:14:53.431781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 14:15:10.564427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 14:15:27.637208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 14:31:41.675913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 14:31:58.412182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 14:32:15.065209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 14:32:32.816094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 14:48:27.715914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 14:48:44.52104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 14:49:01.231912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 14:49:17.967409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 15:05:28.656529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 15:05:45.486194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 15:06:02.275629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 15:06:19.134934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 15:22:17.213179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 15:22:34.129673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 15:23:01.489841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 15:23:18.459643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 15:39:37.201116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 15:39:54.320399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 15:40:11.444078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 15:40:29.854189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 15:56:58.143906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 15:57:17.240818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 15:57:34.00408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 15:57:51.118643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 16:14:40.116862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 16:14:56.893905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 16:15:13.865689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 16:15:30.558384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 16:33:39.600033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 16:33:56.290404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 16:34:13.026815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 16:34:29.697349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 16:51:35.326885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 16:51:52.066649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 16:52:08.69296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 16:52:25.468393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 17:09:22.467734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 17:09:39.161944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 17:09:55.841653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 17:10:12.57438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 17:28:16.933544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 17:28:33.655615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 17:28:51.167852	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 17:29:07.948406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 17:45:13.683022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 17:45:30.339919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 17:45:47.033534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 17:46:03.757303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 18:02:36.190022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 18:02:53.131431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 18:03:09.898557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 18:03:27.34161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 18:19:51.367011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 18:20:08.060006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 18:20:24.80708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 18:20:41.596692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 18:38:12.229498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 18:38:29.070335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 18:38:47.971886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 18:39:04.788238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 18:55:26.736716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 18:55:43.451548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 18:56:00.216886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 18:56:17.052016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 19:12:46.8861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 19:13:03.630813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 19:13:20.362157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 19:13:38.165781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 19:30:51.114191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 19:31:07.946656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 19:31:24.875682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 19:31:43.652458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 19:49:25.645083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 19:49:42.325058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 19:49:59.387229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 19:50:21.745191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 20:07:03.740096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 20:07:20.42684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 20:07:37.235578	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 20:07:54.272751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 20:25:42.435977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 20:25:59.15	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 20:26:15.885704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 20:26:32.703184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 20:43:12.253229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 20:43:28.976989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 20:43:48.094738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 20:44:04.888907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 21:01:23.013683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 21:01:39.725074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 21:01:56.539655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 21:02:13.420989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 21:18:58.686268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 21:19:17.47636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 21:19:34.222631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 21:19:56.004635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 21:36:49.951184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 21:37:06.682383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 21:37:23.601183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 21:37:44.349853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 21:53:53.790448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 21:54:10.506794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 21:54:27.196432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 21:54:43.961131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 22:11:54.009661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 22:12:10.660819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 22:12:27.388361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 22:12:44.186695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 22:29:10.452392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 22:29:27.159394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 22:29:44.004135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 22:30:00.81298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 22:46:49.134045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 22:47:05.811772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 22:47:22.555733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 22:47:39.293736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 23:03:35.070055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 23:03:51.809491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 23:04:08.462016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 23:04:25.121524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 23:21:00.725693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 23:21:17.355086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 23:21:34.051383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 23:21:50.731856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 23:37:35.418691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 23:37:52.025355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 23:38:08.70747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 23:38:25.428548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-21 23:54:52.293562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-21 23:55:09.016603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-21 23:55:25.737583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-21 23:55:42.448569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 00:11:24.851654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 00:11:41.565814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 00:11:58.25724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 00:12:14.961369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 00:28:39.10294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 00:28:55.766272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 00:29:12.418716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 00:29:29.125057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 00:45:13.576559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 00:45:30.245776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 00:45:46.885133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 00:46:03.538274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 01:02:29.756216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 01:02:46.39887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 01:03:03.076392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 01:03:19.81638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 01:19:08.052504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 01:19:24.743467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 01:19:41.434672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 01:19:58.138131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 01:36:22.24471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 01:36:38.936159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 01:36:55.577434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 01:37:12.23811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 01:53:16.636927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 01:53:33.211976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 01:53:49.848989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 01:54:06.536951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 02:11:25.005713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 02:11:41.651259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 02:11:58.324928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 02:12:14.965752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 02:28:17.134113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 02:28:33.825497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 02:28:50.482486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 02:29:07.1477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 02:45:57.380286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 02:46:14.077524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 02:46:30.703724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 02:46:47.36324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 03:02:49.614109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 03:03:06.322374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 03:03:22.96282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 03:03:39.680934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 03:20:30.329055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 03:20:46.992344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 03:21:03.614869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 03:21:20.296155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 03:37:24.994685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 03:37:41.576697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 03:37:58.200312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 03:38:14.909062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 03:55:01.534078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 03:55:18.160706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 03:55:34.856227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 03:55:51.494382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 04:11:54.032733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 04:12:10.673058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 04:12:27.3743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 04:12:44.082019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 04:29:36.551013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 04:29:53.362556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 04:30:10.040414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 04:30:26.729087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 04:46:31.050266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 04:46:47.72138	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 04:47:04.418668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 04:47:21.078298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 05:04:09.519163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 05:04:26.264907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 05:04:42.933827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 05:04:59.601067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 05:21:04.215117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 05:21:20.873826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 05:21:37.5631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 05:21:54.208655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 05:38:47.790514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 05:39:04.49797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 05:39:21.128018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 05:39:37.750565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 05:55:44.359879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 05:56:00.985997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 05:56:17.56824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 05:56:34.237799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 06:13:22.630539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 06:13:39.354172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 06:13:56.041931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 06:14:12.769431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 06:30:19.174991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 06:30:35.821763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 06:30:52.523517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 06:31:09.217449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 06:47:55.59677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 06:48:12.251867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 06:48:28.900358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 06:48:45.609848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 07:04:50.030393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 07:05:06.61576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 07:05:23.306845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 07:05:40.03033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 07:22:28.423159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 07:22:44.996615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 07:23:01.676319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 07:23:18.373658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 07:39:22.653233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 07:39:39.334003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 07:39:56.077311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 07:40:12.788227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 07:56:59.189324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 07:57:15.84241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 07:57:32.524102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 07:57:49.237383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 08:13:51.463486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 08:14:08.256246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 08:14:24.915249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 08:14:41.538685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 08:31:29.936605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 08:31:46.613905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 08:32:03.307281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 08:32:19.994105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 08:48:22.448234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 08:48:39.089786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 08:48:55.757008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 08:49:12.376789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 09:05:58.76424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 09:06:15.422365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 09:06:32.124025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 09:06:48.822636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 09:22:57.441165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 09:23:14.127596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 09:23:30.825454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 09:23:47.527544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 09:40:34.056794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 09:40:50.717477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 09:41:07.369641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 09:41:24.021605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 09:57:32.848347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 09:57:49.517372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 09:58:06.218141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 09:58:22.91643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 10:15:37.051757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 10:15:53.703478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 10:16:10.428303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 10:16:27.083826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 10:32:39.212697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 10:32:55.901431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 10:33:12.591577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 10:33:29.251816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 10:50:25.580575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 10:50:42.308176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 10:50:59.034099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 10:51:15.681195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 11:07:03.932101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 11:07:20.691485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 11:07:37.478688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 11:07:54.180008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 11:24:34.20575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 11:24:50.856696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 11:25:07.546657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 11:25:24.854964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 11:41:37.225634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 11:41:54.041788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 11:42:10.893623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 11:42:27.717483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 11:59:21.389318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 11:59:38.119413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 11:59:54.875824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 12:00:11.706871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 12:16:05.76694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 12:16:22.576611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 12:16:39.27969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 12:16:56.035303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 12:33:46.847636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 12:34:03.568158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 12:34:20.335249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 12:34:37.124739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 12:51:06.427543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 12:51:23.174959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 12:51:39.956898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 12:51:56.676556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 13:08:45.070411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 13:09:01.795366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 13:09:18.598505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 13:09:37.436054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 13:26:57.878115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 13:27:14.527432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 13:27:31.432086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 13:27:48.381632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 13:44:33.628738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 13:44:50.50178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 13:45:07.374991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 13:45:24.193925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 14:01:44.80803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 14:02:01.490137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 14:02:18.279382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 14:02:35.262658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 14:19:14.350564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 14:19:31.108594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 14:19:47.80229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 14:20:04.536576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 14:37:01.44963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 14:37:23.489144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 14:37:40.386885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 14:37:58.275943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 14:54:17.202122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 14:54:34.241253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 14:54:51.085468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 14:55:07.943661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 15:11:47.410868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 15:12:04.382402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 15:12:21.488218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 15:12:40.358723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 15:29:17.734437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 15:29:34.506559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 15:29:59.825897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 15:30:19.185391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 15:46:10.850779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 15:46:27.751289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 15:46:44.826961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 15:47:02.071769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 16:04:08.161167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 16:04:25.288292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 16:04:42.548928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 16:05:07.106611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 16:22:18.19737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 16:22:38.43517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 16:22:57.694336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 16:23:16.96735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 16:39:54.453802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 16:40:11.66368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 16:40:28.447432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 16:40:45.113893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 16:57:21.853556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 16:57:39.014616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 16:57:56.211574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 16:58:15.833884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 17:15:29.036313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 17:15:45.927718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 17:16:04.953626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 17:16:23.858583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 17:32:28.98146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 17:32:45.923865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 17:33:02.808315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 17:33:21.926229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 17:50:43.78552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 17:51:00.612504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 17:51:17.460599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 17:51:34.354813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 18:08:24.497077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 18:08:41.394866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 18:08:58.575782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 18:09:15.47075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 18:26:35.367466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 18:26:52.449543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 18:27:09.778351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 18:27:28.320195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 18:45:02.254834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 18:45:21.416457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 18:45:40.570574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 18:45:59.510291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 19:04:39.997529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 19:04:57.150906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 19:05:14.206433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 19:05:33.734572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 19:22:43.345828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 19:23:00.623696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 19:23:17.900562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 19:23:38.754652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 19:40:38.023034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 19:40:55.089772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 19:41:12.219617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 19:41:31.55017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 19:57:44.774375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 19:58:01.715123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 19:58:18.772445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 19:58:37.787846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 20:15:09.232716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 20:15:26.000681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 20:15:48.11486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 20:16:05.013205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 20:32:05.642407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 20:32:22.760948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 20:32:40.095828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 20:32:57.499398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 20:49:50.387428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 20:50:07.193871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 20:50:24.175337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 20:50:41.32256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 21:07:02.788675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 21:07:19.68913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 21:07:36.611736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 21:07:55.523789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 21:24:46.415246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 21:25:03.354489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 21:25:20.496325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 21:25:43.338214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 21:41:58.280719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 21:42:15.011529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 21:42:31.728635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 21:42:48.460705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 21:59:21.17997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 21:59:37.974369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 21:59:54.708819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 22:00:11.497261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 22:16:08.426535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 22:16:25.150379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 22:16:42.57082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 22:16:59.282749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 22:33:50.115003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 22:34:06.821238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 22:34:23.493522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 22:34:40.175076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 22:50:47.621409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 22:51:04.264263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 22:51:21.016577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 22:51:37.669762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 23:08:32.403363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 23:08:49.126413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 23:09:05.793731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 23:09:22.421965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 23:25:24.589184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 23:25:41.263283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 23:25:57.921614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 23:26:14.537985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-22 23:43:29.503215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-22 23:43:46.252318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-22 23:44:02.914216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-22 23:44:19.581962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 00:00:43.717196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 00:01:00.385202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 00:01:17.030333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 00:01:33.664055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 00:18:44.334867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 00:19:01.028462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 00:19:17.623888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 00:19:34.290762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 00:36:08.450631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 00:36:25.06259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 00:36:41.721194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 00:36:58.435616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 00:54:12.722428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 00:54:29.446106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 00:54:45.983703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 00:55:02.64461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 01:11:32.805317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 01:11:49.446334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 01:12:06.126828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 01:12:22.840173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 01:29:30.878693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 01:29:47.565442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 01:30:04.225469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 01:30:21.12196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 01:46:47.076528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 01:47:03.735547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 01:47:20.442733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 01:47:37.083718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 02:04:45.469106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 02:05:02.133001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 02:05:18.823018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 02:05:35.468429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 02:22:01.64237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 02:22:18.292125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 02:22:34.9809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 02:22:51.695491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 02:40:01.47961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 02:40:18.146159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 02:40:34.817405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 02:40:51.486414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 02:57:19.367539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 02:57:35.992507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 02:57:52.618875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 02:58:09.309981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 03:15:17.573569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 03:15:34.249321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 03:15:50.87221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 03:16:07.498304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 03:32:31.558074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 03:32:48.424235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 03:33:05.104152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 03:33:21.73394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 03:50:29.998795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 03:50:46.636158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 03:51:03.28745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 03:51:19.994266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 04:07:46.165592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 04:08:02.826944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 04:08:19.481472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 04:08:36.145731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 04:25:44.345303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 04:26:01.023078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 04:26:17.637681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 04:26:34.285965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 04:43:00.390097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 04:43:17.071301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 04:43:33.75148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 04:43:50.45715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 05:00:58.521057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 05:01:15.202264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 05:01:31.853876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 05:01:48.507809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 05:18:12.415128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 05:18:28.962761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 05:18:45.598584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 05:19:02.304959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 05:36:10.305349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 05:36:26.953472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 05:36:43.629434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 05:37:00.281161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 05:53:26.387186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 05:53:43.028819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 05:53:59.690899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 05:54:16.43135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 06:11:24.608716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 06:11:41.241742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 06:11:57.906137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 06:12:14.595733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 06:28:38.328939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 06:28:55.107428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 06:29:11.73867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 06:29:28.474777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 06:46:58.848018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 06:47:15.51124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 06:47:32.178853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 06:47:48.831833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 07:04:37.090338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 07:04:53.768746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 07:05:10.419462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 07:05:27.107774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 07:22:42.053672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 07:22:58.71399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 07:23:15.364988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 07:23:32.005163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 07:39:55.844593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 07:40:12.42123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 07:40:29.081115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 07:40:45.806272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 07:57:57.950561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 07:58:14.64191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 07:58:31.283854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 07:58:47.871623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 08:15:12.159004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 08:15:28.766917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 08:15:45.502467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 08:16:02.149893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 08:33:10.092825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 08:33:26.745544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 08:33:43.393949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 08:34:00.080338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 08:50:24.160173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 08:50:40.827355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 08:50:57.473388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 08:51:14.150919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 09:08:22.682081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 09:08:39.268303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 09:08:55.963346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 09:09:12.602301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 09:25:39.091679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 09:25:55.784681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 09:26:12.517849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 09:26:29.148303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 09:43:37.93615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 09:43:54.636303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 09:44:11.229392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 09:44:27.893464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 10:00:52.185861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 10:01:08.929029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 10:01:25.60111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 10:01:42.279946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 10:18:35.481301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 10:18:52.219246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 10:19:08.999417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 10:19:25.710266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 10:36:02.711268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 10:36:21.395812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 10:36:38.140323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 10:36:54.898267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 10:53:53.473148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 10:54:10.125869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 10:54:26.900799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 10:54:43.592983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 11:10:38.971913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 11:10:55.704671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 11:11:12.405175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 11:11:29.150285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 11:27:36.749923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 11:27:53.477634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 11:28:10.1398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 11:28:26.883187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 11:44:20.107512	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 11:44:36.879932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 11:44:53.622949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 11:45:10.324655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 12:01:13.955893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 12:01:30.626757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 12:01:47.394428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 12:02:04.154933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 12:17:47.159132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 12:18:05.87867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 12:18:22.799444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 12:18:39.49232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 12:34:47.535025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 12:35:04.253666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 12:35:20.909016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 12:35:37.641211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 12:51:23.822586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 12:51:40.58241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 12:51:57.294022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 12:52:13.98492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 13:08:47.2505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 13:09:04.000278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 13:09:20.691248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 13:09:37.394049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 13:25:46.742524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 13:26:03.586315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 13:26:20.468395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 13:26:37.213828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 13:43:02.9129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 13:43:19.853075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 13:43:36.542014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 13:43:53.366904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 13:59:47.588952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 14:00:04.351031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 14:00:21.08678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 14:00:37.799039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 14:18:18.714703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 14:18:35.51354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 14:18:52.213165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 14:19:09.097262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 14:35:22.838163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 14:35:39.556761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 14:35:56.311627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 14:36:15.070499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 14:52:36.823602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 14:52:53.923855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 14:53:10.569043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 14:53:27.54161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 15:10:25.315194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 15:10:42.02174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 15:10:58.84534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 15:11:15.71963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 15:27:36.903935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 15:27:53.826376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 15:28:10.750417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 15:28:27.606304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 15:45:07.322362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 15:45:24.098002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 15:45:40.854324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 15:45:57.621581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 16:02:16.7038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 16:02:33.709232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 16:02:50.935294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 16:03:08.437494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 16:18:38.497688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 16:18:55.296602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 16:19:12.139249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 16:19:29.052692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 16:35:18.276696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 16:35:35.032431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 16:35:51.873967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 16:36:08.942617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 16:51:43.826778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 16:52:04.562811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 16:52:23.470697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 16:52:40.247201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 17:09:09.810398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 17:09:26.551011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 17:09:43.360678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 17:10:00.370377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 17:25:27.813985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 17:25:44.636555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 17:26:01.305823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 17:26:18.22244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 17:42:09.366756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 17:42:26.189562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 17:42:43.311203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 17:43:00.380356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 17:58:28.385034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 17:58:45.193808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 17:59:04.204044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 17:59:23.298946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 18:15:13.445242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 18:15:30.199075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 18:15:46.979338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 18:16:03.77199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 18:31:37.573955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 18:31:54.321389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 18:32:11.118956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 18:32:28.015174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 18:48:45.05838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 18:49:01.982669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 18:49:18.772188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 18:49:35.562891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 19:05:40.616339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 19:05:57.779074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 19:06:14.800989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 19:06:32.203134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 19:22:27.780514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 19:22:48.189608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 19:23:05.02927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 19:23:22.262469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 19:39:00.68474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 19:39:17.447359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 19:39:34.203414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 19:39:51.040177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 19:55:11.553592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 19:55:28.345124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 19:55:45.512198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 19:56:05.081229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 20:11:49.097654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 20:12:06.255522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 20:12:23.309104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 20:12:40.715602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 20:28:31.315424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 20:28:48.062246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 20:29:04.904217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 20:29:21.818166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 20:44:52.224144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 20:45:09.073987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 20:45:25.838264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 20:45:42.708819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 21:01:54.652912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 21:02:11.362415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 21:02:28.174371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 21:02:45.103105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 21:18:56.256581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 21:19:13.071791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 21:19:29.916899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 21:19:46.810504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 21:36:37.529852	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 21:36:54.310916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 21:37:11.028544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 21:37:27.754194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 21:53:16.392608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 21:53:33.121076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 21:53:49.869374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 21:54:06.776802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 22:10:44.937261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 22:11:01.701865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 22:11:18.391549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 22:11:35.137641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 22:27:25.608726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 22:27:42.330868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 22:27:59.118102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 22:28:15.804285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 22:44:53.398377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 22:45:10.028497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 22:45:26.724761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 22:45:43.478289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 23:01:25.817994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 23:01:42.49558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 23:01:59.189637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 23:02:15.883229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 23:18:46.411971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 23:19:03.133239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 23:19:19.838971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 23:19:36.505574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 23:35:19.990613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 23:35:36.648288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 23:35:53.331058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 23:36:10.044982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-23 23:52:34.311888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-23 23:52:50.99905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-23 23:53:07.683845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-23 23:53:24.389914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 00:09:28.481759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 00:09:45.147379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 00:10:01.816796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 00:10:18.518768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 00:27:04.64568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 00:27:21.268867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 00:27:37.907504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 00:27:54.608891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 00:43:56.667893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 00:44:13.279594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 00:44:29.987674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 00:44:46.671675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 01:01:32.673171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 01:01:49.250782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 01:02:05.920268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 01:02:22.600127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 01:18:26.657333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 01:18:43.288225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 01:18:59.940299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 01:19:16.615299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 01:36:04.41461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 01:36:21.051709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 01:36:37.711158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 01:36:54.390661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 01:52:56.451486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 01:53:13.135664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 01:53:29.806215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 01:53:46.469802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 02:10:34.605931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 02:10:51.240715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 02:11:07.906658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 02:11:24.631679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 02:27:28.753448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 02:27:45.40035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 02:28:02.068785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 02:28:18.65272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 02:45:04.519934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 02:45:21.183401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 02:45:37.787103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 02:45:54.357761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 03:01:56.931254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 03:02:35.665923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 03:03:05.413263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 03:03:22.083478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 03:20:15.231661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 03:20:31.875157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 03:20:48.553203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 03:21:05.201907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 03:37:11.133695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 03:37:27.805316	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 03:37:44.490131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 03:38:01.124689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 03:54:47.18341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 03:55:03.852558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 03:55:20.618408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 03:55:37.29748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 04:11:43.447187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 04:12:00.101773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 04:12:16.699072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 04:12:33.367318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 04:29:25.699791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 04:29:42.365571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 04:29:58.97357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 04:30:15.645752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 04:46:17.47059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 04:46:34.13402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 04:46:50.830589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 04:47:07.504625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 05:03:53.512361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 05:04:10.190834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 05:04:26.803418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 05:04:43.480144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 05:20:45.532519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 05:21:02.161048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 05:21:18.798442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 05:21:35.494376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 05:38:21.460961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 05:38:38.138573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 05:38:54.732866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 05:39:11.405387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 05:55:13.625892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 05:55:30.218395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 05:55:46.849575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 05:56:03.51906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 06:12:49.65149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 06:13:06.297745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 06:13:22.951854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 06:13:39.620333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 06:29:43.617316	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 06:30:00.326833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 06:30:16.967204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 06:30:33.684502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 06:47:19.684499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 06:47:36.282239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 06:47:52.928095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 06:48:09.597752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 07:04:11.590793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 07:04:28.222276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 07:04:44.87464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 07:05:01.530226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 07:21:51.838723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 07:22:08.496616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 07:22:25.140237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 07:22:41.863695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 07:38:43.529156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 07:39:00.20838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 07:39:16.845526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 07:39:33.541416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 07:55:59.565853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 07:56:16.201938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 07:56:32.876038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 07:56:49.513451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 08:12:31.864555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 08:12:48.534346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 08:13:05.259172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 08:13:21.976101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 08:29:28.208568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 08:29:44.869375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 08:30:01.54625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 08:30:18.284943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 08:45:50.888314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 08:46:07.541314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 08:46:24.232216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 08:46:41.200799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 09:03:11.816232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 09:03:28.478968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 09:03:45.152802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 09:04:01.761682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 09:19:33.984357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 09:19:50.705615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 09:20:07.401907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 09:20:24.109707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 09:36:15.386091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 09:36:32.072002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 09:36:48.752657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 09:37:05.430756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 09:52:29.077368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 09:52:45.72711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 09:53:02.351325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 09:53:19.106294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 10:09:01.201822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 10:09:17.923162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 10:09:34.54299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 10:09:51.472253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 10:25:15.704412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 10:25:32.369322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 10:25:49.060709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 10:26:05.777166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 10:41:57.390934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 10:42:14.108712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 10:42:30.770423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 10:42:47.572796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 10:58:13.67884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 10:58:30.42777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 10:58:47.07608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 10:59:03.738098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 11:14:48.824542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 11:15:05.511119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 11:15:22.193205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 11:15:38.949218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 11:31:03.65515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 11:31:20.438672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 11:31:37.107865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 11:31:53.794736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 11:47:40.391194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 11:47:57.07105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 11:48:13.785828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 11:48:30.471812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 12:03:54.70205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 12:04:11.357474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 12:04:27.996262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 12:04:44.701257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 12:20:26.860781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 12:20:43.557441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 12:21:00.211158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 12:21:16.910978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 12:36:45.433889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 12:37:02.120105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 12:37:18.840422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 12:37:35.548948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 12:53:21.645107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 12:53:38.262965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 12:53:54.95303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 12:54:11.677614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 13:09:28.471866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 13:09:45.222703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 13:10:01.891198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 13:10:18.559415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 13:25:57.912962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 13:26:14.648829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 13:26:31.345758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 13:26:47.975794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 13:42:07.123516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 13:42:23.741357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 13:42:40.411228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 13:42:57.140868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 13:58:42.548047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 13:58:59.333259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 13:59:16.335338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 13:59:33.046361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 14:14:57.291095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 14:15:14.007906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 14:15:30.66327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 14:15:47.3403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 14:31:25.833587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 14:31:42.532774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 14:31:59.215668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 14:32:15.908924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 14:47:35.056379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 14:47:51.769091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 14:48:08.668799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 14:48:25.410729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 15:04:37.808064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 15:04:54.426972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 15:05:11.164699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 15:05:27.887251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 15:20:52.005018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 15:21:08.709708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 15:21:25.409959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 15:21:42.078613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 15:37:53.951262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 15:38:10.633541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 15:38:28.060015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 15:38:44.9518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 15:54:09.768742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 15:54:26.475774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 15:54:43.660949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 15:55:00.379994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 16:11:13.472293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 16:11:30.220879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 16:11:46.877926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 16:12:03.596925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 16:27:32.312072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 16:27:49.072942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 16:28:05.7653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 16:28:22.409768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 16:45:04.961072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 16:45:21.639746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 16:45:38.439891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 16:45:55.166449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 17:02:08.03087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 17:02:24.81293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 17:02:41.535936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 17:02:58.283733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 17:20:24.575896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 17:20:41.184866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 17:20:57.877862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 17:21:14.726125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 17:39:03.048045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 17:39:19.759302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 17:39:36.422019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 17:39:53.181468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 17:57:32.349551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 17:57:49.061906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 17:58:05.765352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 17:58:22.433918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 18:14:54.582925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 18:15:11.310332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 18:15:28.043861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 18:15:44.763095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 18:33:30.095461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 18:33:48.805126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 18:34:08.622053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 18:34:25.390054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 18:50:37.040982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 18:50:53.95682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 18:51:10.737568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 18:51:27.853519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 19:08:42.972425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 19:08:59.975004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 19:09:16.877039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 19:09:33.710763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 19:25:58.400407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 19:26:15.109335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 19:26:32.135998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 19:26:49.046842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 19:43:29.946731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 19:43:52.425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 19:44:11.493136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 19:44:30.739979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 20:00:33.561585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 20:00:52.654312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 20:01:11.808399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 20:01:31.514835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 20:18:24.248197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 20:18:46.420723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 20:19:05.334815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 20:19:22.724939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 20:36:08.413805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 20:36:27.508055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 20:36:46.426508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 20:37:03.835093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 20:53:17.443128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 20:53:41.497978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 20:53:58.64898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 20:54:17.629132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 21:10:34.185189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 21:10:50.949861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 21:11:18.001925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 21:11:34.78242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 21:27:59.832871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 21:28:16.519745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 21:28:33.643471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 21:28:51.083745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 21:44:41.755585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 21:44:58.441647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 21:45:15.351357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 21:45:32.289696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 22:01:57.61182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 22:02:14.372327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 22:02:31.101126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 22:02:47.93258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 22:18:58.805065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 22:19:15.48931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 22:19:32.325548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 22:19:49.201211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 22:35:59.85542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 22:36:16.536295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 22:36:33.182613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 22:36:49.901192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 22:52:55.225453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 22:53:11.889177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 22:53:28.583238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 22:53:45.366357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 23:10:02.8597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 23:10:19.470855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 23:10:36.199448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 23:10:53.001192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 23:26:57.78355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 23:27:14.412612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 23:27:31.070681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 23:27:47.765163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-24 23:44:05.505827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-24 23:44:22.171557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-24 23:44:38.864926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-24 23:44:55.582112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 00:01:03.458001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 00:01:20.132438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 00:01:36.731206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 00:01:53.493561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 00:17:58.279271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 00:18:14.918563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 00:18:31.64162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 00:18:48.370053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 00:34:51.007345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 00:35:07.632925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 00:36:40.87957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 00:36:57.525565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 00:53:23.518689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 00:53:40.157953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 00:53:56.829596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 00:54:13.529879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 01:10:37.740572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 01:10:54.377809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 01:11:11.048207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 01:11:27.72488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 01:27:54.117792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 01:28:10.746131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 01:28:27.391713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 01:28:44.080816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 01:45:08.582676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 01:45:25.250286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 01:45:41.95246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 01:45:58.591101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 02:02:37.837207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 02:02:54.490095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 02:03:11.203057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 02:03:27.871009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 02:19:51.967748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 02:20:08.613897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 02:20:25.246826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 02:20:41.957633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 02:37:05.816195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 02:37:22.458914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 02:37:39.097124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 02:37:55.768172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 02:54:21.685439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 02:54:38.309223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 02:54:54.993508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 02:55:11.675065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 03:11:39.804606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 03:11:56.475666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 03:12:13.110325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 03:12:29.808979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 03:28:55.780018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 03:29:12.470327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 03:29:29.151859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 03:29:45.822102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 03:46:09.56986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 03:46:26.203133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 03:46:42.805238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 03:46:59.508118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 04:03:23.570267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 04:03:40.238351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 04:03:56.935698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 04:04:13.575416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 04:20:37.584873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 04:20:54.193036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 04:21:10.91656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 04:21:27.626625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 04:37:51.834413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 04:38:08.487127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 04:38:25.154666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 04:38:41.787256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 04:55:05.730952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 04:55:22.347557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 04:55:39.062857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 04:55:55.75783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 05:12:19.621505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 05:12:36.332651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 05:12:53.008404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 05:13:09.593219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 05:29:33.550981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 05:29:50.122788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 05:30:06.810092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 05:30:23.503364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 05:46:47.764683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 05:47:04.462187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 05:47:21.022041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 05:47:37.666014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 06:04:01.634232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 06:04:18.260384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 06:04:34.903108	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 06:04:51.58786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 06:21:15.453564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 06:21:32.127446	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 06:21:48.733709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 06:22:05.421274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 06:38:29.42533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 06:38:46.065816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 06:39:02.712265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 06:39:19.380453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 06:55:43.14969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 06:55:59.830546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 06:56:16.494851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 06:56:33.183951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 07:12:56.98252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 07:13:13.66687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 07:13:30.300358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 07:13:46.969202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 07:30:20.052899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 07:30:36.636085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 07:30:53.305628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 07:31:10.09599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 07:47:39.818731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 07:47:56.515431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 07:48:13.204235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 07:48:29.904354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 08:05:04.183137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 08:05:20.812925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 08:05:37.474087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 08:05:54.118626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 08:22:22.366175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 08:22:39.021677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 08:22:55.70514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 08:23:12.393586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 08:39:49.925181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 08:40:06.571965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 08:40:23.181762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 08:40:39.921291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 08:57:11.937286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 08:57:28.606371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 08:57:45.295536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 08:58:01.880867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 09:14:43.503052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 09:15:00.110441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 09:15:16.777672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 09:15:33.448992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 09:32:03.482319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 09:32:20.06549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 09:32:36.691317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 09:32:53.386113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 09:48:57.963649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 09:49:14.668049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 09:49:31.420092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 09:49:48.103287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 10:06:00.931249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 10:06:17.639656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 10:06:34.377937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 10:06:50.966011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 10:22:37.537954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 10:22:54.193221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 10:23:10.865668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 10:23:27.518569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 10:39:35.72815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 10:39:52.374076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 10:40:08.974207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 10:40:25.66129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 10:56:20.784452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 10:56:37.473291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 10:56:54.068246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 10:57:10.734389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 11:13:29.931251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 11:13:46.6475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 11:14:03.354431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 11:14:20.019184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 11:30:20.777318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 11:30:37.465222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 11:30:54.140002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 11:31:10.813286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 11:47:44.355953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 11:48:00.986979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 11:48:17.770804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 11:48:34.559021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 12:04:26.494864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 12:04:43.256465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 12:04:59.990942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 12:05:16.75133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 12:21:27.544715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 12:21:44.275076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 12:22:00.903416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 12:22:17.605065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 12:38:08.000122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 12:38:24.662765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 12:38:41.394241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 12:38:58.031427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 12:55:10.672677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 12:55:27.374903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 12:55:43.993939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 12:56:00.810906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 13:11:59.799655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 13:12:16.512089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 13:12:33.151905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 13:12:49.827687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 13:29:05.358047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 13:29:22.085823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 13:29:40.8043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 13:29:57.53918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 13:45:47.061531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 13:46:03.754353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 13:46:20.468361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 13:46:37.217002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 14:03:07.098107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 14:03:23.770684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 14:03:40.42329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 14:03:57.138433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 14:20:18.803336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 14:20:35.54277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 14:20:52.297905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 14:21:09.026294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 14:37:44.604368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 14:38:04.361192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 14:38:21.132433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 14:38:37.921531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 14:54:37.46781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 14:54:54.142374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 14:55:10.909571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 14:55:28.049478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 15:11:55.986438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 15:12:12.675983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 15:12:29.39759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 15:12:46.097652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 15:28:46.391426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 15:29:03.06145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 15:29:19.721344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 15:29:36.454158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 15:46:24.448415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 15:46:44.118473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 15:47:00.883927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 15:47:17.656836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 16:03:14.243094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 16:03:30.933966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 16:03:47.647563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 16:04:04.370093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 16:20:09.132789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 16:20:25.81795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 16:20:42.563061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 16:20:59.286349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 16:36:41.116997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 16:36:57.86658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 16:37:14.660135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 16:37:31.546113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 16:53:48.383661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 16:54:05.129521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 16:54:22.071239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 16:54:39.035261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 17:10:20.235296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 17:10:37.017108	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 17:10:53.756105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 17:11:10.506283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 17:27:28.373113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 17:27:45.27059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 17:28:02.187664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 17:28:19.192045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 17:44:18.519836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 17:44:35.225982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 17:44:51.943519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 17:45:08.657032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 18:01:16.751244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 18:01:33.505784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 18:01:50.361123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 18:02:07.141585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 18:23:53.501063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 18:24:10.200495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 18:24:29.036109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 18:24:45.859412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 18:40:11.262594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 18:40:28.470415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 18:40:45.482054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 18:41:02.471008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 18:57:10.900239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 18:57:27.670567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 18:57:44.575551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 18:58:01.575223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 19:13:32.811228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 19:13:49.777833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 19:14:06.715585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 19:14:23.845094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 19:30:21.936939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 19:30:39.267538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 19:30:56.530945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 19:31:14.569456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 19:47:17.239332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 19:47:36.20204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 19:47:53.31621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 19:48:10.448155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 20:04:07.420716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 20:04:24.22892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 20:04:40.982482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 20:04:57.828586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 20:20:37.249911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 20:20:57.379306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 20:21:16.515849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 20:21:33.450191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 20:37:51.553139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 20:38:08.852654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 20:38:26.0701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 20:38:43.766397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 20:55:25.031843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 20:55:41.812236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 20:55:59.061396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 20:56:18.216281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 21:12:29.677993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 21:12:46.515237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 21:13:03.522179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 21:13:22.969056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 21:29:24.356102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 21:29:41.08911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 21:29:57.875191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 21:30:14.733598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 21:46:28.27926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 21:46:51.983812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 21:47:11.795022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 21:47:28.849298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 22:03:19.121525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 22:03:36.242791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 22:03:52.910724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 22:04:09.653031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 22:20:42.324553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 22:20:58.990061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 22:21:15.734645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 22:21:32.412972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 22:37:26.210325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 22:37:42.912543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 22:37:59.636169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 22:38:16.373202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 22:54:52.265222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 22:55:08.918464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 22:55:25.559913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 22:55:42.282077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 23:11:38.31084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 23:11:54.939489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 23:12:11.60493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 23:12:28.321706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 23:29:03.556565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 23:29:20.237129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 23:29:36.91491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 23:29:53.517264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-25 23:45:40.067552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-25 23:45:56.74863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-25 23:46:13.432285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-25 23:46:30.196267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 00:02:54.866107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 00:03:11.509086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 00:03:28.092048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 00:03:44.808368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 00:19:24.690773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 00:19:41.427476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 00:19:58.118978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 00:20:14.782275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 00:37:05.630226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 00:37:22.318156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 00:37:38.973955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 00:37:55.65139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 00:54:01.9914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 00:54:18.632208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 00:54:35.293102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 00:54:52.010933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 01:11:43.022379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 01:11:59.701364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 01:12:16.349604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 01:12:33.032441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 01:28:35.152417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 01:28:51.763346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 01:29:08.427183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 01:29:25.107454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 01:46:11.374553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 01:46:28.027916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 01:46:44.633134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 01:47:01.324295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 02:03:03.277636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 02:03:19.894495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 02:03:36.559279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 02:03:53.232239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 02:20:39.565367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 02:20:56.179921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 02:21:12.84788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 02:21:29.582003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 02:37:31.268304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 02:37:47.917777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 02:38:04.581942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 02:38:21.282912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 02:55:07.643171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 02:55:24.252912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 02:55:40.916121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 02:55:57.629089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 03:11:59.1534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 03:12:15.823176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 03:12:32.460135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 03:12:49.125949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 03:29:35.225808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 03:29:51.896073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 03:30:08.547807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 03:30:25.210869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 03:46:27.20188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 03:46:43.876374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 03:47:00.500957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 03:47:17.163596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 04:04:03.79193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 04:04:20.449486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 04:04:37.130461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 04:04:53.777623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 04:20:55.735963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 04:21:12.392854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 04:21:29.088717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 04:21:45.735391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 04:38:32.182753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 04:38:48.905118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 04:39:05.587613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 04:39:22.280707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 04:55:24.264863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 04:55:40.897711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 04:55:57.575979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 04:56:14.227886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 05:13:00.333687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 05:13:16.990352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 05:13:33.67456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 05:13:50.371828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 05:29:54.384185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 05:30:11.013939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 05:30:27.66834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 05:30:44.33568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 05:47:41.461125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 05:47:58.196466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 05:48:14.880379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 05:48:31.573709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 06:04:35.739761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 06:04:52.410778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 06:05:08.977707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 06:05:25.713365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 06:22:12.238458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 06:22:28.925693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 06:22:45.547508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 06:23:02.243991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 06:39:04.210427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 06:39:20.833282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 06:39:37.531419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 06:39:54.193391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 06:56:40.371523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 06:56:57.034203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 06:57:13.705461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 06:57:30.358226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 07:13:32.63249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 07:13:49.306839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 07:14:05.939019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 07:14:22.623281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 07:31:15.276628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 07:31:31.866736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 07:31:48.519982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 07:32:05.223472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 07:48:10.932199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 07:48:27.668232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 07:48:44.324687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 07:49:01.028785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 08:05:52.940151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 08:06:09.621672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 08:06:26.282007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 08:06:43.261489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 08:22:53.351655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 08:23:09.97667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 08:23:26.621635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 08:23:43.416443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 08:40:35.64351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 08:40:52.346889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 08:41:09.108915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 08:41:25.718754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 08:57:29.442791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 08:57:46.108047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 08:58:02.737137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 08:58:19.469493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 09:15:13.70993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 09:15:30.340887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 09:15:46.981126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 09:16:03.69125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 09:32:12.837412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 09:32:29.426143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 09:32:46.116542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 09:33:02.835461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 09:49:31.562353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 09:49:48.206496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 09:50:04.888193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 09:50:21.522031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 10:06:15.267279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 10:06:31.984339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 10:06:48.654081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 10:07:05.277583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 10:23:43.112848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 10:23:59.88515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 10:24:16.599729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 10:24:33.353831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 10:40:23.972954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 10:40:40.663509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 10:40:57.364851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 10:41:14.099682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 10:57:52.35828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 10:58:09.006129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 10:58:25.748686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 10:58:42.490121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 11:14:39.009331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 11:14:55.689983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 11:15:12.339986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 11:15:29.04358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 11:32:01.070299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 11:32:17.821891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 11:32:34.419549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 11:32:51.144218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 11:48:38.075454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 11:48:54.785843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 11:49:11.435197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 11:49:28.130984	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 12:06:10.715404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 12:06:27.465186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 12:06:44.151759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 12:07:00.806826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 12:23:24.182877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 12:23:40.85566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 12:23:57.606337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 12:24:14.29673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 12:42:06.219428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 12:42:24.90146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 12:42:41.512305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 12:42:58.228542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 12:59:46.578146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 13:00:03.335253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 13:00:19.982211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 13:00:36.679158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 13:16:49.146853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 13:17:05.835602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 13:17:22.605081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 13:17:39.259557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 13:33:39.367319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 13:33:56.055376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 13:34:12.766064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 13:34:29.463096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 13:51:11.736903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 13:51:28.465643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 13:51:45.161713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 13:52:02.001304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 14:08:18.046704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 14:08:34.774452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 14:08:51.496773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 14:09:08.243082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 14:25:52.807684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 14:26:09.54645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 14:26:26.255016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 14:26:43.018389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 14:42:56.242075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 14:43:12.93852	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 14:43:29.755534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 14:43:46.451872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 15:00:01.104439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 15:00:17.938919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 15:00:34.816134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 15:00:51.888126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 15:17:05.80515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 15:17:22.627057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 15:17:39.522653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 15:17:56.255691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 15:34:49.419478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 15:35:08.12655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 15:35:24.948688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 15:35:41.715537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 15:52:48.47756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 15:53:05.211101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 15:53:22.119251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 15:53:38.96893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 16:10:10.156063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 16:10:26.966913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 16:10:45.877421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 16:11:02.772067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 16:27:34.010267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 16:27:50.68214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 16:28:07.42241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 16:28:24.219938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 16:44:42.455813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 16:44:59.142452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 16:45:15.875312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 16:45:35.950056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 17:02:35.578011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 17:02:52.453312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 17:03:09.16509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 17:03:25.918554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 17:19:38.173261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 17:19:54.863788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 17:20:11.836736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 17:20:28.576867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 17:37:15.215744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 17:37:32.131882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 17:37:48.869866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 17:38:05.620907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 17:54:44.395571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 17:55:03.19848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 17:55:19.982837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 17:55:38.279044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 18:12:09.57036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 18:12:26.346319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 18:12:43.172442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 18:13:00.507348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 18:29:51.144014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 18:30:07.94546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 18:30:24.777279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 18:30:45.552863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 18:46:57.010337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 18:47:15.912597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 18:47:33.733469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 18:47:50.695086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 19:04:21.565811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 19:04:38.905551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 19:04:56.069553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 19:05:15.560414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 19:21:47.32741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 19:22:04.448557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 19:22:22.167421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 19:22:41.332788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 19:39:02.199336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 19:39:19.293676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 19:39:36.571076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 19:39:53.859707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 19:55:51.939123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 19:56:12.266609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 19:56:31.701964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 19:56:49.755277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 20:12:54.932508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 20:13:12.278348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 20:13:29.696884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 20:13:47.345317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 20:29:56.686614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 20:30:13.82609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 20:30:31.084914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 20:30:50.516973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 20:47:09.453536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 20:47:26.563397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 20:47:44.572007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 20:48:06.114568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 21:04:00.020964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 21:04:17.019648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 21:04:34.071424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 21:04:51.446813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 21:21:33.89504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 21:21:50.744049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 21:22:07.744892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 21:22:24.737684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 21:38:16.615767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 21:38:33.474539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 21:38:50.281656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 21:39:07.114379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 21:55:43.409188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 21:56:00.229041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 21:56:17.017573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 21:56:33.806842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 22:12:27.428725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 22:12:44.3026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 22:13:01.123808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 22:13:17.950763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 22:29:53.348407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 22:30:10.044369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 22:30:26.763218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 22:30:43.538086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 22:46:28.542716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 22:46:45.184305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 22:47:01.883479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 22:47:18.594814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 23:03:50.742564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 23:04:07.385416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 23:04:24.01762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 23:04:40.7443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 23:20:25.867293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 23:20:42.563636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 23:20:59.265261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 23:21:15.970473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 23:37:47.013079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 23:38:03.667745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 23:38:20.39589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 23:38:37.157657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-26 23:54:19.817968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-26 23:54:36.504757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-26 23:54:53.153184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-26 23:55:09.865549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 00:11:36.538777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 00:11:53.223499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 00:12:09.940792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 00:12:26.586636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 00:28:34.006753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 00:28:50.725879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 00:29:07.348906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 00:29:24.034592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 00:46:15.042552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 00:46:31.757926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 00:46:48.459861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 00:47:05.134068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 01:03:13.946526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 01:03:30.60566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 01:03:47.311829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 01:04:04.057237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 01:20:54.820537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 01:21:11.493004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 01:21:28.132277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 01:21:44.811927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 01:37:59.928818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 01:38:16.589176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 01:38:33.24945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 01:38:49.933002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 01:55:38.090774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 01:55:54.837432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 01:56:11.469654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 01:56:28.159496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 02:12:33.900516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 02:12:50.549403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 02:13:07.239565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 02:13:23.860065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 02:30:10.514273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 02:30:27.176906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 02:30:43.828955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 02:31:00.514185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 02:47:04.43495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 02:47:21.122334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 02:47:37.823806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 02:47:54.424868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 03:04:44.77383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 03:05:01.435563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 03:05:18.084784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 03:05:34.729077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 03:21:38.53437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 03:21:55.199327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 03:22:11.898304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 03:22:28.59825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 03:39:17.190008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 03:39:33.895755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 03:39:50.546054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 03:40:07.205633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 03:56:08.867125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 03:56:25.497842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 03:56:42.1191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 03:56:58.892699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 04:13:46.807452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 04:14:03.472626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 04:14:20.107718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 04:14:36.82016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 04:30:38.526896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 04:30:55.112402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 04:31:11.775091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 04:31:28.468667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 04:48:14.464757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 04:48:31.073473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 04:48:47.723424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 04:49:04.422722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 05:05:08.351699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 05:05:25.011749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 05:05:41.668764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 05:05:58.342239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 05:22:46.409255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 05:23:03.030352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 05:23:19.730171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 05:23:36.437713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 05:39:40.365142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 05:39:57.005816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 05:40:13.637442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 05:40:30.351194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 05:57:18.659071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 05:57:35.229669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 05:57:51.901561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 05:58:08.598095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 06:14:12.221648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 06:14:28.959751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 06:14:45.597888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 06:15:02.285001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 06:31:48.304491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 06:32:04.93247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 06:32:21.595648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 06:32:38.309249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 06:48:41.678024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 06:48:58.349362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 06:49:15.039082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 06:49:31.72214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 07:06:19.841696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 07:06:36.537207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 07:06:53.209158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 07:07:09.890206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 07:23:17.474884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 07:23:34.125441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 07:23:50.783732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 07:24:07.443467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 07:40:57.945564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 07:41:14.630854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 07:41:31.253636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 07:41:47.923034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 07:57:54.217196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 07:58:10.850891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 07:58:27.4923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 07:58:44.181172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 08:15:36.843565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 08:15:53.505465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 08:16:10.215749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 08:16:26.875982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 08:32:57.360265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 08:33:14.045805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 08:33:30.746012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 08:33:47.344014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 08:50:37.871759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 08:50:54.546646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 08:51:11.177002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 08:51:27.869241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 09:07:20.525541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 09:07:37.19091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 09:07:53.941804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 09:08:10.616853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 09:24:42.112706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 09:24:58.747759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 09:25:15.498763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 09:25:32.165703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 09:41:18.770818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 09:41:35.40061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 09:41:52.073835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 09:42:08.82	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 09:58:42.786314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 09:58:59.441394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 09:59:16.158756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 09:59:32.781254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 10:15:25.550329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 10:15:42.250264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 10:15:58.996367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 10:16:15.664452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 10:32:29.675152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 10:32:46.296588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 10:33:03.020082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 10:33:19.75975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 10:49:10.010254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 10:49:26.687767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 10:49:43.361667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 10:50:00.126378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 11:05:46.836662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 11:06:03.512772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 11:06:20.130213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 11:06:36.947154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 11:21:59.690388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 11:22:16.387366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 11:22:33.098793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 11:22:49.778651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 11:39:07.582525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 11:39:24.325844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 11:39:40.920228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 11:39:57.654838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 11:55:28.796773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 11:55:47.546101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 11:56:08.284188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 11:56:24.92812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 12:12:33.575776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 12:12:50.449495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 12:13:07.127071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 12:13:23.919578	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 12:28:54.206753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 12:29:10.878015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 12:29:27.580906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 12:29:44.24864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 12:45:55.643428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 12:46:12.322196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 12:46:29.000964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 12:46:45.716875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 13:02:14.412187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 13:02:31.090064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 13:02:47.788886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 13:03:04.514885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 13:19:12.690185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 13:19:29.38922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 13:19:46.081114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 13:20:02.795901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 13:35:27.624413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 13:35:44.305573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 13:36:00.971092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 13:36:17.65322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 13:52:37.468794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 13:52:54.14071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 13:53:10.841832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 13:53:27.543065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 14:09:11.036348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 14:09:27.746164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 14:09:44.567395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 14:10:01.34974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 14:26:10.462505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 14:26:27.290176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 14:26:44.081821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 14:27:00.812959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 14:42:56.594214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 14:43:13.431939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 14:43:30.386974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 14:43:47.088426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 15:00:40.861793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 15:00:57.533019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 15:01:14.315031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 15:01:30.968095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 15:18:19.093821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 15:18:35.772566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 15:18:52.480396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 15:19:09.201611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 15:35:26.528459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 15:35:43.23151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 15:36:00.053563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 15:36:16.788543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 15:52:38.391812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 15:52:55.143756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 15:53:11.965738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 15:53:28.674409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 16:09:11.097673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 16:09:27.82128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 16:09:45.052468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 16:10:01.804053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 16:26:29.019056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 16:26:45.767934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 16:27:02.474972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 16:27:19.196311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 16:43:07.802726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 16:43:24.604254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 16:43:41.459806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 16:44:00.091236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 16:59:21.718296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 16:59:38.482205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 16:59:55.229607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 17:00:12.038416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 17:15:35.345179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 17:15:52.045126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 17:16:08.902745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 17:16:26.061254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 17:32:12.940321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 17:32:29.71446	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 17:32:46.450692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 17:33:03.212104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 17:49:06.084774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 17:49:23.011816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 17:49:39.798914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 17:49:56.710712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 18:06:12.134623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 18:06:31.151912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 18:06:48.065412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 18:07:09.29089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 18:23:38.670095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 18:23:55.887491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 18:24:12.938253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 18:24:29.766242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 18:40:31.967922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 18:40:48.725675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 18:41:05.739183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 18:41:22.469477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 18:57:26.465625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 18:57:43.359523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 18:58:02.687117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 18:58:19.569838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 19:14:58.321193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 19:15:15.558337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 19:15:32.436394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 19:15:51.2161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 19:32:10.246437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 19:32:27.095002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 19:32:46.834744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 19:33:05.720366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 19:48:35.118628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 19:48:52.251124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 19:49:11.067947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 19:49:28.160232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 20:05:22.181286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 20:05:39.070948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 20:05:58.119969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 20:06:16.918007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 20:22:28.02707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 20:22:44.848925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 20:23:01.862584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 20:23:18.820802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 20:39:58.440797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 20:40:15.23531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 20:40:32.250209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 20:40:49.170679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 20:56:54.886626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 20:57:12.098492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 20:57:30.13128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 20:57:47.90991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 21:14:21.105226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 21:14:37.956004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 21:14:55.150563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 21:15:14.071047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 21:30:41.954594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 21:30:58.656683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 21:31:15.515671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 21:31:32.303337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 21:47:26.986708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 21:47:43.64672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 21:48:00.458267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 21:48:17.202121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 22:04:12.152867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 22:04:28.811901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 22:04:45.665436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 22:05:02.43852	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 22:21:15.423699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 22:21:32.180383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 22:21:48.999395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 22:22:05.760093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 22:38:03.394786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 22:38:20.076099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 22:38:36.829545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 22:38:53.558141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 22:55:03.256971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 22:55:19.948943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 22:55:36.729674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 22:55:53.431843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 23:12:03.48958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 23:12:20.077131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 23:12:36.76125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 23:12:53.441218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 23:28:58.232813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 23:29:14.848246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 23:29:31.567551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 23:29:48.255687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-27 23:46:11.982238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-27 23:46:28.655125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-27 23:46:45.434306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-27 23:47:02.073563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 00:03:48.192647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 00:04:04.869716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 00:04:21.597317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 00:04:38.277462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 00:21:12.02188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 00:21:28.70866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 00:21:45.393431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 00:22:02.070136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 00:38:32.910662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 00:38:49.567354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 00:39:06.277399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 00:39:22.994696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 00:55:53.620503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 00:56:10.283093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 00:56:26.978618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 00:56:43.601876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 01:13:16.154266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 01:13:32.800757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 01:13:49.481063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 01:14:06.220076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 01:30:34.226967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 01:30:50.924221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 01:31:07.595115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 01:31:24.201369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 01:47:48.435011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 01:48:05.061005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 01:48:21.793507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 01:48:38.501917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 02:05:15.548983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 02:05:32.212584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 02:05:48.891257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 02:06:05.575152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 02:22:42.738888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 02:22:59.423152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 02:23:16.123299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 02:23:32.702836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 02:40:12.077023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 02:40:28.720815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 02:40:45.39074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 02:41:02.113766	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 02:57:28.340274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 02:57:44.98492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 02:58:01.585168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 02:58:18.29833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 03:14:48.677899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 03:15:05.359898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 03:15:22.018837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 03:15:38.638481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 03:32:10.074989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 03:32:26.718103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 03:32:43.42627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 03:33:00.102658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 03:49:24.308332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 03:49:40.935264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 03:49:57.601268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 03:50:14.32158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 04:06:40.482788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 04:06:57.107171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 04:07:13.76066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 04:07:30.492886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 04:23:54.362814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 04:24:11.040253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 04:24:27.713132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 04:24:44.383115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 04:41:08.517294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 04:41:25.150112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 04:41:41.854567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 04:41:58.572472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 04:58:22.466011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 04:58:39.151339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 04:58:55.823789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 04:59:12.518355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 05:15:36.395951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 05:15:53.055796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 05:16:09.73631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 05:16:26.42274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 05:32:50.117345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 05:33:06.728248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 05:33:23.443024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 05:33:40.10835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 05:50:10.108362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 05:50:26.790808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 05:50:43.462843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 05:51:00.066067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 06:07:23.96293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 06:07:40.54698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 06:07:57.237792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 06:08:13.96757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 06:24:37.75698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 06:24:54.442159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 06:25:11.120762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 06:25:27.84114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 06:41:56.17009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 06:42:12.886863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 06:42:29.582036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 06:42:46.261112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 06:59:15.12313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 06:59:31.833254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 06:59:48.447967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 07:00:05.154281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 07:16:51.241738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 07:17:07.948415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 07:17:24.63446	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 07:17:41.362647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 07:34:29.81376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 07:34:46.461037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 07:35:03.1188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 07:35:19.772729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 07:51:45.14133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 07:52:01.789268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 07:52:18.476261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 07:52:35.123133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 08:09:02.056327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 08:09:18.731783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 08:09:35.319286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 08:09:52.054873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 08:26:19.376618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 08:26:36.154402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 08:26:52.899042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 08:27:09.560137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 08:43:48.306855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 08:44:04.988053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 08:44:21.649139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 08:44:38.349068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 09:01:02.534202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 09:01:19.403795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 09:01:38.305935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 09:01:55.232084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 09:18:26.538744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 09:18:45.304054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 09:19:02.056042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 09:19:18.799936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 09:35:40.050138	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 09:35:56.770856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 09:36:13.42406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 09:36:30.091103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 09:52:45.339082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 09:53:01.996926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 09:53:18.711986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 09:53:35.486892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 10:09:38.306063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 10:09:54.955936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 10:10:11.909456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 10:10:28.581028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 10:26:55.772036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 10:27:12.969619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 10:27:30.044387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 10:27:48.164819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 10:44:06.281151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 10:44:23.001418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 10:44:39.702953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 10:44:56.421085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 11:01:54.945041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 11:02:11.671658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 11:02:28.362582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 11:02:45.118441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 11:18:58.323823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 11:19:15.070443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 11:19:31.94916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 11:19:48.761724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 11:36:54.521716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 11:37:11.246661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 11:37:28.078254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 11:37:46.905632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 11:55:23.332957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 11:55:42.101515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 11:55:58.914608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 11:56:15.68418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 12:13:33.119276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 12:13:50.338069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 12:14:09.057601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 12:14:26.811454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 12:31:32.93067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 12:31:51.771296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 12:32:10.483263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 12:32:27.482762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 12:49:47.625733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 12:50:04.511963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 12:50:23.384101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 12:50:40.214046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 13:07:33.035092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 13:07:49.955543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 13:08:06.71269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 13:08:23.60558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 13:25:22.07774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 13:25:38.946049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 13:25:55.705082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 13:26:12.597845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 13:43:03.736566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 13:43:20.388134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 13:43:37.220542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 13:43:54.021206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 13:59:48.313652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 14:00:05.001742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 14:00:21.927007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 14:00:38.775296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 14:16:28.197501	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 14:16:45.034665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 14:17:05.163079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 14:17:24.170722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 14:33:26.948102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 14:33:43.859217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 14:34:00.806161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 14:34:20.211332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 14:50:29.672152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 14:50:46.521058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 14:51:03.278905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 14:51:22.038106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 15:08:05.278807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 15:08:21.973978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 15:08:38.97103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 15:08:57.757607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 15:24:45.312585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 15:25:01.918409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 15:25:21.906925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 15:25:38.771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 15:41:29.120384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 15:41:45.972292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 15:42:02.864679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 15:42:22.228859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 15:57:50.210891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 15:58:07.023132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 15:58:23.93476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 15:58:40.899069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 16:14:44.675342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 16:15:01.922413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 16:15:18.940952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 16:15:35.950241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 16:32:24.025833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 16:32:40.861799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 16:32:58.037511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 16:33:16.000652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 16:49:11.505763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 16:49:28.476912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 16:49:45.457807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 16:50:02.728655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 17:05:44.951542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 17:06:01.920131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 17:06:19.094663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 17:06:36.757378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 17:22:49.166507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 17:23:05.895812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 17:23:22.660297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 17:23:39.361151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 17:39:15.929723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 17:39:32.895434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 17:39:49.968617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 17:40:07.099379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 17:56:08.489317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 17:56:25.298531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 17:56:42.30817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 17:56:59.323036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 18:13:17.515317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 18:13:34.571617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 18:13:51.601344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 18:14:09.116042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 18:30:32.765443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 18:30:49.585101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 18:31:06.743319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 18:31:24.179519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 18:47:38.488556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 18:47:55.216095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 18:48:12.115256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 18:48:28.938128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 19:04:39.991833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 19:04:56.832563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 19:05:13.660733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 19:05:30.538058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 19:21:46.288682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 19:22:03.018021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 19:22:20.028751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 19:22:37.016599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 19:38:56.82592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 19:39:13.620415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 19:39:35.451683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 19:39:52.345244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 19:56:37.942961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 19:56:54.936581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 19:57:12.048156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 19:57:31.540086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 20:13:35.404036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 20:13:52.564248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 20:14:09.743161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 20:14:26.601813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 20:30:36.202188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 20:30:53.047285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 20:31:09.947624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 20:31:26.687408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 20:47:09.53895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 20:47:26.411913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 20:47:43.307917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 20:48:00.191602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 21:04:18.486364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 21:04:35.281596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 21:04:52.079821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 21:05:08.859192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 21:21:20.881874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 21:21:37.696529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 21:21:54.694155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 21:22:11.754516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 21:38:26.163008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 21:38:45.460028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 21:39:02.467628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 21:39:19.67914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 21:55:04.080041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 21:55:20.780407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 21:55:37.751955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 21:55:54.584805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 22:12:07.274994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 22:12:23.931877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 22:12:40.67016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 22:12:57.391094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 22:29:09.677765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 22:29:26.895474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 22:29:43.63658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 22:30:00.355538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 22:46:42.278363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 22:46:58.981559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 22:47:15.751307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 22:47:32.505346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 23:03:58.32895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 23:04:15.028239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 23:04:31.703482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 23:04:48.507563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 23:21:48.404777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 23:22:05.070907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 23:22:21.687633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 23:22:38.465811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 23:38:57.759604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 23:39:14.463483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 23:39:31.146288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 23:39:47.896305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-02-28 23:56:47.505865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-02-28 23:57:04.171905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-02-28 23:57:20.841398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-02-28 23:57:37.606373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 00:13:39.669568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 00:13:56.333426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 00:14:13.055289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 00:14:29.750274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 00:31:22.116497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 00:31:38.790466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 00:31:55.580722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 00:32:12.240391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 00:48:52.091605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 00:49:08.699248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 00:49:25.386857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 00:49:42.064755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 01:07:18.684533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 01:07:38.780549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 01:07:55.446561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 01:08:12.905921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 01:25:45.161388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 01:26:01.823309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 01:26:18.571778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 01:26:37.854142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 01:44:14.588564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 01:44:32.800926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 01:44:49.452216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 01:45:07.207073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 02:02:41.741577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 02:03:03.893845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 02:03:20.567308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 02:03:39.248444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 02:21:37.838577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 02:21:54.491795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 02:22:11.435686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 02:22:32.986151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 02:40:34.126567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 02:40:50.77981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 02:41:07.938564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 02:41:28.91637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 02:59:36.988004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 02:59:56.780446	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 03:00:15.301642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 03:00:39.920348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 03:18:45.206758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 03:19:02.02642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 03:19:18.78816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 03:19:35.445978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 03:37:05.520711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 03:37:22.177233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 03:37:38.864666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 03:37:55.562767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 03:55:26.072349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 03:55:42.799768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 03:55:59.495007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 03:56:16.251935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 04:13:46.691684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 04:14:03.293716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 04:14:19.954051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 04:14:36.66837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 04:32:08.95253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 04:32:25.548567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 04:32:42.30619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 04:32:59.077546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 04:50:28.540121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 04:50:45.203116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 04:51:01.847312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 04:51:18.500755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 05:08:51.073645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 05:09:07.725412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 05:09:24.410934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 05:09:41.087866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 05:27:11.362895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 05:27:28.056209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 05:27:44.675444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 05:28:01.37169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 05:46:10.174972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 05:46:26.761977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 05:46:43.404251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 05:47:00.058662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 06:04:32.74813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 06:04:49.425603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 06:05:06.086731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 06:05:22.740554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 06:22:58.267272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 06:23:14.982118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 06:23:31.67751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 06:23:48.409849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 06:41:44.253882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 06:42:00.911281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 06:42:17.569839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 06:42:34.26503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 07:00:04.300174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 07:00:20.95712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 07:00:37.601267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 07:00:54.288241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 07:18:24.731012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 07:18:41.386432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 07:18:58.063219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 07:19:14.741497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 07:36:46.281886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 07:37:02.903231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 07:37:19.59984	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 07:37:36.263293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 07:55:06.306694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 07:55:22.978173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 07:55:39.590914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 07:55:56.215874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 08:13:06.84408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 08:13:23.540668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 08:13:40.196114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 08:13:56.872915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 08:31:05.041318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 08:31:21.665332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 08:31:38.381213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 08:31:55.063102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 08:49:02.066778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 08:49:18.684566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 08:49:35.345595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 08:49:52.076792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 09:07:00.414283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 09:07:17.046731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 09:07:33.724868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 09:07:50.447529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 09:25:27.396185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 09:25:44.045922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 09:26:00.692182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 09:26:17.399893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 09:43:17.658488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 09:43:34.383295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 09:43:51.044904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 09:44:07.761767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 10:01:30.467043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 10:01:47.150878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 10:02:04.202907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 10:02:20.919678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 10:19:22.4661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 10:19:39.263088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 10:19:56.296359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 10:20:12.963435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 10:37:23.248948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 10:37:40.02206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 10:37:56.741528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 10:38:13.473901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 10:55:15.363303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 10:55:32.032184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 10:55:48.792606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 10:56:05.489168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 11:12:43.124071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 11:13:00.052968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 11:13:16.986468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 11:13:34.192396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 11:30:03.012487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 11:30:19.757021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 11:30:37.008233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 11:30:53.931093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 11:47:43.048116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 11:47:59.819378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 11:48:16.623988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 11:48:33.468024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 12:05:15.870426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 12:05:32.697168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 12:05:49.56893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 12:06:06.410137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 12:23:30.63154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 12:23:47.384873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 12:24:04.195803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 12:24:21.553825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 12:41:18.870167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 12:41:35.642512	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 12:41:52.627726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 12:42:09.443169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 12:59:06.931006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 12:59:23.665059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 12:59:40.491302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 12:59:57.361907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 13:17:06.949305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 13:17:23.680692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 13:17:40.483263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 13:17:57.696095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 13:35:24.398631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 13:35:41.188042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 13:35:57.873685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 13:36:14.539113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 13:53:33.496934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 13:53:50.39521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 13:54:07.238679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 13:54:24.502176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 14:11:33.481975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 14:11:50.32153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 14:12:07.172449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 14:12:23.974417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 14:29:14.067032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 14:29:30.915166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 14:29:47.675771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 14:30:04.664598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 14:46:37.33965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 14:46:54.17492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 14:47:10.930048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 14:47:30.737775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 15:04:02.071924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 15:04:20.936163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 15:04:38.024543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 15:04:57.143777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 15:21:21.160903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 15:21:38.003561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 15:21:54.902056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 15:22:13.678434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 15:38:46.242542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 15:39:03.018158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 15:39:20.065422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 15:39:36.957675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 15:55:45.829251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 15:56:02.75904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 15:56:19.824553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 15:56:40.752633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 16:12:43.809541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 16:13:00.597477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 16:13:17.580075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 16:13:34.88554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 16:29:46.506944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 16:30:03.520477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 16:30:20.859527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 16:30:38.137508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 16:46:37.889364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 16:46:55.026829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 16:47:12.290972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 16:47:31.727542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 17:03:36.93452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 17:03:53.629755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 17:04:10.498677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 17:04:29.43745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 17:20:57.761399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 17:21:16.829751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 17:21:33.964709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 17:21:50.846095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 17:37:57.434175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 17:38:14.335447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 17:38:31.392035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 17:38:50.560548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 17:55:16.384862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 17:55:41.760299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 17:56:16.283451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 17:56:37.005965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 18:12:49.734976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 18:13:09.030544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 18:13:26.553723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 18:13:46.622494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 18:29:35.087894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 18:29:52.330667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 18:30:09.605045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 18:30:29.279864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 18:47:00.539696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 18:47:17.715832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 18:47:34.927508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 18:47:52.152767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 19:03:51.410771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 19:04:08.711427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 19:04:25.992136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 19:04:43.39224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 19:20:21.117794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 19:20:38.375938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 19:20:55.618489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 19:21:13.041201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 19:37:21.000517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 19:37:38.022413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 19:37:55.290263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 19:38:12.826534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 19:54:01.591791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 19:54:18.715408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 19:54:35.900075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 19:54:55.122323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 20:11:46.543511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 20:12:03.433099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 20:12:20.222307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 20:12:37.215476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 20:28:09.93743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 20:28:28.463311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 20:28:49.372238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 20:29:06.366636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 20:45:11.277035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 20:45:28.499989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 20:45:49.841189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 20:46:07.169028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 21:02:23.429155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 21:02:40.549322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 21:02:58.674242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 21:03:19.043992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 21:19:48.067238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 21:20:05.13378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 21:20:22.341675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 21:20:39.665691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 21:37:01.237065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 21:37:18.277211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 21:37:35.353791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 21:37:52.511035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 21:54:00.100751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 21:54:17.084409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 21:54:37.06294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 21:54:54.016098	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 22:11:05.942694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 22:11:22.846965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 22:11:46.663676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 22:12:03.607479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 22:27:55.863301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 22:28:12.72352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 22:28:35.972596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 22:28:52.965949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 22:44:59.571413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 22:45:16.53427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 22:45:33.409276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 22:45:52.387681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 23:01:50.78402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 23:02:07.58056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 23:02:24.544102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 23:02:41.458134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 23:18:48.161158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 23:19:05.002457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 23:19:21.827873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 23:19:38.691541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 23:35:53.694042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 23:36:10.544031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 23:36:27.35089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 23:36:44.147219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-01 23:52:28.943206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-01 23:52:45.640112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-01 23:53:02.398125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-01 23:53:19.056802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 00:09:42.663109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 00:10:19.283888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 00:10:40.623003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 00:10:57.328248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 00:27:16.728767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 00:27:33.447028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 00:27:50.083122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 00:28:06.789018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 00:44:21.068018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 00:44:37.714885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 00:44:54.36807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 00:45:11.070104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 01:01:24.686992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 01:01:41.390768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 01:01:58.091281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 01:02:14.776941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 01:18:38.205704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 01:18:54.892897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 01:19:11.561986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 01:19:28.275608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 01:35:39.670526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 01:35:56.332637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 01:36:13.038794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 01:36:29.734819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 01:52:35.595315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 01:52:52.243892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 01:53:08.928721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 01:53:25.561407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 02:09:29.969433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 02:09:46.669125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 02:10:03.275651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 02:10:19.973395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 02:26:33.91181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 02:26:50.582635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 02:27:07.277465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 02:27:23.952343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 02:43:25.953442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 02:43:42.611793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 02:43:59.257262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 02:44:15.932689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 03:00:17.656566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 03:00:34.309986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 03:00:50.978604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 03:01:07.638713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 03:17:09.152173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 03:17:25.767778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 03:17:42.430664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 03:17:59.144303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 03:34:02.907868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 03:34:19.593021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 03:34:36.146752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 03:34:52.826062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 03:50:54.792127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 03:51:11.462337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 03:51:28.021464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 03:51:44.7237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 04:07:47.046625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 04:08:03.642712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 04:08:20.309134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 04:08:36.990694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 04:24:57.972028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 04:25:14.658529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 04:25:31.281051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 04:25:47.910327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 04:42:04.279951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 04:42:20.970113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 04:42:37.578199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 04:42:54.239415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 04:59:15.139523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 04:59:31.811785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 04:59:48.475948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 05:00:05.137693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 05:16:11.190407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 05:16:27.851548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 05:16:44.600045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 05:17:01.250396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 05:33:03.39867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 05:33:20.063799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 05:33:36.67806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 05:33:53.377091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 05:50:17.352994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 05:50:33.993423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 05:50:50.665928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 05:51:07.346688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 06:07:31.349561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 06:07:48.043655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 06:08:04.633048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 06:08:21.292481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 06:24:27.278333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 06:24:43.854838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 06:25:00.565758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 06:25:17.215576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 06:41:19.46147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 06:41:36.121541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 06:41:52.78949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 06:42:09.492094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 06:58:11.184015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 06:58:27.865937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 06:58:44.483809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 06:59:01.138464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 07:15:11.722187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 07:15:28.369344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 07:15:44.998666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 07:16:01.685404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 07:32:10.60668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 07:32:27.23251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 07:32:43.838937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 07:33:00.544261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 07:49:14.967231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 07:49:31.611686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 07:49:48.294429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 07:50:05.088222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 08:06:11.793858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 08:06:28.464754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 08:06:45.161563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 08:07:01.763885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 08:23:16.180252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 08:23:32.854447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 08:23:49.470737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 08:24:06.177257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 08:40:30.890062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 08:40:47.533292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 08:41:04.205783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 08:41:20.832895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 08:57:33.023635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 08:57:49.678029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 08:58:06.315627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 08:58:25.042001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 09:14:51.320936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 09:15:07.997863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 09:15:24.82659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 09:15:41.559776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 09:32:01.946684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 09:32:18.710408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 09:32:37.421946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 09:32:54.153978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 09:48:47.879071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 09:49:04.559347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 09:49:21.23397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 09:49:37.908658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 10:05:28.721584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 10:05:45.417907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 10:06:02.08155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 10:06:18.810083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 10:22:21.253347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 10:22:38.010117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 10:22:54.656623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 10:23:11.372757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 10:38:40.478606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 10:38:57.191038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 10:39:14.010155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 10:39:30.692142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 10:55:19.683787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 10:55:36.36748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 10:55:53.047972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 10:56:09.747398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 11:11:50.772387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 11:12:07.511718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 11:12:24.182466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 11:12:40.910701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 11:28:50.576342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 11:29:07.279694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 11:29:24.027842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 11:29:40.685247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 11:45:28.117003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 11:45:44.890178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 11:46:01.639874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 11:46:18.399185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 12:02:42.161289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 12:02:58.897577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 12:03:15.61806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 12:03:32.350023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 12:19:32.114017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 12:19:50.038962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 12:20:06.791242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 12:20:23.643158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 12:36:21.234729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 12:36:38.012268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 12:36:54.825848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 12:37:11.599828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 12:52:39.800028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 12:52:56.563844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 12:53:13.358079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 12:53:30.037158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 13:09:19.030487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 13:09:35.954653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 13:09:52.723232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 13:10:09.433873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 13:25:43.113584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 13:25:59.917609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 13:26:16.757642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 13:26:33.659703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 13:42:26.562258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 13:42:43.296913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 13:43:00.171233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 13:43:17.107105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 13:59:04.716335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 13:59:21.502587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 13:59:38.355822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 13:59:55.258555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 14:15:47.707967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 14:16:04.511423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 14:16:21.696704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 14:16:39.100771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 14:32:31.59796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 14:32:48.362438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 14:33:05.195976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 14:33:22.084864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 14:49:34.277873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 14:49:51.167334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 14:50:08.100202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 14:50:25.219325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 15:06:17.247949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 15:06:34.044808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 15:06:50.86083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 15:07:07.926395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 15:23:41.859127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 15:23:58.670745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 15:24:15.364728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 15:24:32.199357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 15:40:26.938578	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 15:40:43.728556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 15:41:00.504362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 15:41:17.237682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 15:57:25.016548	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 15:57:41.855405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 15:57:58.644216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 15:58:15.474433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 16:14:05.491827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 16:14:22.317055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 16:14:39.096174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 16:14:56.39823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 16:30:48.42235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 16:31:05.228238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 16:31:21.958231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 16:31:38.899419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 16:47:42.592751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 16:47:59.402358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 16:48:16.22405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 16:48:33.139679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 17:05:08.732281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 17:05:25.451111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 17:05:42.190813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 17:05:58.96985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 17:22:12.640027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 17:22:29.357768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 17:22:45.989479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 17:23:02.92829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 17:39:38.640752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 17:39:55.402156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 17:40:12.487224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 17:40:29.502596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 17:57:10.628989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 17:57:27.401208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 17:57:44.208628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 17:58:01.105592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 18:14:26.808758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 18:14:43.605351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 18:15:00.504309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 18:15:17.805462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 18:31:38.147174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 18:31:54.957238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 18:32:12.061369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 18:32:31.406507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 18:49:35.733761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 18:49:52.527988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 18:50:09.830055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 18:50:27.584723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 19:06:54.854425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 19:07:12.041746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 19:07:34.600333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 19:07:52.256435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 19:24:29.742698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 19:24:46.747489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 19:25:03.983697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 19:25:21.152699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 19:42:25.649911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 19:42:43.042995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 19:43:00.25917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 19:43:19.347699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 20:00:07.771401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 20:00:24.7567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 20:00:41.666142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 20:00:58.986869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 20:17:16.618957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 20:17:35.28426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 20:17:52.396402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 20:18:09.987277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 20:34:45.334376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 20:35:02.65977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 20:35:19.982495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 20:35:37.235148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 20:51:12.11795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 20:51:29.051064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 20:51:46.189275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 20:52:03.760409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 21:08:15.685651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 21:08:32.936213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 21:08:50.142317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 21:09:08.052951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 21:24:51.941674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 21:25:09.065168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 21:25:26.157986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 21:25:43.225052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 21:41:50.075495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 21:42:07.19631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 21:42:24.110297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 21:42:41.182698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 21:58:05.029571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 21:58:21.914661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 21:58:38.796682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 21:58:55.64252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 22:14:48.216467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 22:15:05.01306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 22:15:21.863903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 22:15:38.725058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 22:31:09.390789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 22:31:26.130339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 22:31:42.83078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 22:31:59.532673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 22:48:21.065181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 22:48:37.73185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 22:48:54.448733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 22:49:11.191955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 23:05:21.064531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 23:05:37.790307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 23:05:54.482259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 23:06:11.225456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 23:22:23.658844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 23:22:40.299266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 23:22:56.95743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 23:23:13.688206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 23:38:38.006578	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 23:38:54.697339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 23:39:11.41155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 23:39:28.104328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-02 23:55:29.888176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-02 23:55:46.48444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-02 23:56:03.166474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-02 23:56:19.864543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 00:12:07.82857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 00:12:24.466376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 00:12:41.163151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 00:12:57.85149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 00:29:26.866928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 00:29:43.583152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 00:30:00.26804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 00:30:16.930163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 00:45:57.014434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 00:46:13.681723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 00:46:30.380463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 00:46:47.058285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 01:03:11.267309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 01:03:27.984264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 01:03:44.638982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 01:04:01.34423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 01:19:49.306279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 01:20:05.997784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 01:20:22.637131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 01:20:39.388008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 01:37:22.601847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 01:37:39.227951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 01:37:55.911745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 01:38:12.533269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 01:54:09.739177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 01:54:26.396994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 01:54:43.088256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 01:54:59.793273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 02:11:27.534213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 02:11:44.216059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 02:12:00.913174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 02:12:17.571304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 02:28:10.676748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 02:28:27.297547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 02:28:43.945778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 02:29:00.622075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 02:45:24.423423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 02:45:41.097182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 02:45:57.718053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 02:46:14.42525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 03:01:56.05994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 03:02:12.72231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 03:02:29.400133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 03:02:46.051348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 03:19:20.172475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 03:19:36.971496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 03:19:53.638516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 03:20:10.337662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 03:35:52.169687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 03:36:08.832904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 03:36:25.518849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 03:36:42.1686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 03:53:08.206062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 03:53:24.835134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 03:53:41.506621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 03:53:58.152037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 04:09:38.022367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 04:09:54.702008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 04:10:11.395881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 04:10:28.063386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 04:26:52.020417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 04:27:08.64819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 04:27:25.25618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 04:27:41.939916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 04:43:25.879001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 04:43:42.551269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 04:43:59.171408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 04:44:15.885442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 05:00:53.850659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 05:01:10.607803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 05:01:27.319502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 05:01:43.999384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 05:17:27.964064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 05:17:44.575324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 05:18:01.238018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 05:18:17.896369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 05:34:49.671414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 05:35:06.340173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 05:35:23.019679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 05:35:39.753542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 05:51:23.559667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 05:51:40.215516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 05:51:56.893909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 05:52:13.559885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 06:08:37.472566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 06:08:54.126764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 06:09:10.75846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 06:09:27.430029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 06:25:07.355171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 06:25:24.075205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 06:25:40.83632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 06:25:57.595763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 06:42:27.725922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 06:42:44.410467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 06:43:01.119375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 06:43:17.832625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 06:59:16.760227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 06:59:33.373159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 06:59:50.024091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 07:00:06.716567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 07:16:34.632623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 07:16:51.319741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 07:17:07.988255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 07:17:24.566228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 07:33:12.505681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 07:33:29.221595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 07:33:45.892134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 07:34:02.571905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 07:50:30.460856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 07:50:47.058136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 07:51:03.733428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 07:51:20.393744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 08:07:11.662611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 08:07:28.267135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 08:07:44.908356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 08:08:01.588996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 08:24:37.13758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 08:24:53.819369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 08:25:10.496692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 08:25:27.176412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 08:41:19.80485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 08:41:36.491453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 08:41:53.189009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 08:42:09.815618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 08:58:48.67113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 08:59:05.360152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 08:59:22.132201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 08:59:38.806337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 09:15:30.535325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 09:15:47.220371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 09:16:03.959126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 09:16:20.628806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 09:32:57.394879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 09:33:14.001204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 09:33:30.966152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 09:33:47.64301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 09:49:32.137581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 09:49:48.784958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 09:50:05.429825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 09:50:22.115048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 10:06:54.89717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 10:07:11.620228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 10:07:28.37802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 10:07:44.999299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 10:23:47.81813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 10:24:04.508849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 10:24:21.211403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 10:24:37.866655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 10:41:08.106521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 10:41:24.775541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 10:41:41.511295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 10:41:58.246655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 10:58:00.511605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 10:58:17.148088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 10:58:33.819836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 10:58:50.575049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 11:15:25.981088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 11:15:42.674735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 11:15:59.393476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 11:16:16.10456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 11:32:05.281964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 11:32:22.072051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 11:32:38.752323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 11:32:55.550173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 11:49:23.044813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 11:49:39.774146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 11:49:56.472487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 11:50:13.094507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 12:06:11.120859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 12:06:27.881494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 12:06:44.603004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 12:07:01.209003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 12:23:48.198981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 12:24:04.905835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 12:24:21.571855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 12:24:38.295016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 12:40:42.744602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 12:40:59.422259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 12:41:16.105983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 12:41:32.780541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 12:58:27.236372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 12:58:43.948731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 12:59:00.643369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 12:59:17.379865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 13:15:16.931884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 13:15:33.732053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 13:15:50.390982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 13:16:07.036503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 13:33:28.838502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 13:33:45.524675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 13:34:02.183582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 13:34:18.876238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 13:50:31.235605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 13:50:48.370635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 13:51:05.257386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 13:51:22.770315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 14:08:18.178644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 14:08:34.86263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 14:08:51.583348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 14:09:08.300134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 14:25:10.286715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 14:25:27.006052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 14:25:43.92976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 14:26:00.717944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 14:43:08.884924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 14:43:25.600517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 14:43:42.352725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 14:43:59.042354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 14:59:51.14503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 15:00:07.839069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 15:00:24.614052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 15:00:41.685494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 15:16:54.591251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 15:17:11.30363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 15:17:28.030489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 15:17:44.728798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 15:33:18.157603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 15:33:34.908718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 15:33:51.87045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 15:34:08.608583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 15:50:19.998823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 15:50:36.776692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 15:50:53.558368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 15:51:10.391474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 16:06:39.840746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 16:06:56.610156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 16:07:16.465393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 16:07:35.303224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 16:24:02.989706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 16:24:19.796248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 16:24:36.767276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 16:24:53.707676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 16:40:21.284847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 16:40:37.991754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 16:40:54.692465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 16:41:11.37707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 16:57:26.990024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 16:57:43.74564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 16:58:00.618396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 16:58:17.406795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 17:13:51.667863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 17:14:08.48012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 17:14:25.271035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 17:14:42.04713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 17:31:12.888294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 17:31:29.693494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 17:31:46.685918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 17:32:03.554893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 17:47:54.723282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 17:48:11.588533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 17:48:28.298709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 17:48:47.45563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 18:05:15.947933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 18:05:32.749655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 18:05:49.543195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 18:06:06.411475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 18:22:01.578681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 18:22:18.386304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 18:22:35.303388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 18:22:52.094354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 18:39:29.31021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 18:39:46.195779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 18:40:03.088532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 18:40:22.151332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 18:56:20.035085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 18:56:36.713703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 18:56:53.496573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 18:57:10.388464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 19:13:22.562475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 19:13:39.392875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 19:13:56.640994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 19:14:13.920496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 19:30:40.585498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 19:30:57.671194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 19:31:14.844586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 19:31:32.69629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 19:47:39.417133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 19:47:56.432805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 19:48:13.377106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 19:48:30.481873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 20:04:35.703585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 20:04:58.023807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 20:05:15.527754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 20:05:35.293146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 20:21:59.237367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 20:22:16.491341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 20:22:34.064945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 20:22:58.791747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 20:39:05.726584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 20:39:23.494278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 20:39:40.847799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 20:39:58.640809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 20:56:38.748445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 20:56:56.071289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 20:57:13.583415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 20:57:31.283299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 21:13:53.473781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 21:14:10.865738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 21:14:28.055511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 21:14:46.466495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 21:31:31.643397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 21:31:48.594343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 21:32:05.894326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 21:32:24.700689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 21:48:36.193783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 21:48:52.932236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 21:49:09.752143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 21:49:26.621824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 22:05:33.5395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 22:05:50.337801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 22:06:07.244205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 22:06:24.027393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 22:22:14.923508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 22:22:31.921447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 22:22:48.647879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 22:23:05.564964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 22:39:41.558973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 22:39:58.270867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 22:40:14.898353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 22:40:31.660332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 22:56:19.439955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 22:56:36.146789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 22:56:52.845713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 22:57:09.563985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 23:13:51.140699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 23:14:07.818137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 23:14:24.520856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 23:14:41.154297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 23:30:39.782405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 23:30:56.453271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 23:31:13.151615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 23:31:29.873704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-03 23:47:54.007034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-03 23:48:10.665503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-03 23:48:27.290647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-03 23:48:44.011878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 00:05:10.202261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 00:05:26.908746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 00:05:43.619611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 00:06:00.342831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 00:23:10.71952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 00:23:27.410473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 00:23:44.237673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 00:24:00.884674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 00:40:24.922095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 00:40:41.563508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 00:40:58.243407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 00:41:14.931669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 00:58:26.984598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 00:58:43.634347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 00:59:00.270972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 00:59:16.984381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 01:15:41.267135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 01:15:57.934676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 01:16:14.562971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 01:16:31.245334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 01:33:39.333906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 01:33:55.980703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 01:34:12.663173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 01:34:29.351565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 01:50:55.228699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 01:51:11.935795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 01:51:28.530289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 01:51:45.192318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 02:08:55.017192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 02:09:11.624275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 02:09:28.272921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 02:09:44.977268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 02:26:12.748594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 02:26:29.380742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 02:26:46.084615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 02:27:02.705295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 02:44:12.640294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 02:44:29.31039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 02:44:46.011589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 02:45:02.674188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 03:01:28.611601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 03:01:45.30765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 03:02:01.949956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 03:02:18.668493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 03:19:26.561215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 03:19:43.237241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 03:19:59.931621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 03:20:16.565743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 03:36:40.73916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 03:36:57.353628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 03:37:14.031398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 03:37:30.704186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 03:54:39.005663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 03:54:55.645305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 03:55:12.341956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 03:55:29.057709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 04:11:52.953366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 04:12:09.627069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 04:12:26.312012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 04:12:42.985783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 04:29:51.265102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 04:30:07.862131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 04:30:24.522966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 04:30:41.19201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 04:47:05.355428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 04:47:22.015305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 04:47:38.706511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 04:47:55.290764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 05:05:03.631638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 05:05:20.281219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 05:05:36.862988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 05:05:53.588328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 05:22:17.615129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 05:22:34.234895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 05:22:50.918929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 05:23:07.614129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 05:40:15.354216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 05:40:31.986435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 05:40:48.6219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 05:41:05.228171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 05:57:30.889545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 05:57:47.478956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 05:58:04.151252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 05:58:20.891819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 06:15:28.990832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 06:15:45.623085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 06:16:02.262405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 06:16:18.957615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 06:32:42.709439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 06:32:59.347389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 06:33:15.95536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 06:33:32.689376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 06:51:04.278939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 06:51:20.955946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 06:51:37.683621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 06:51:54.338798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 07:08:18.139508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 07:08:34.795382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 07:08:51.514237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 07:09:08.17161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 07:26:20.22843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 07:26:36.840457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 07:26:53.482638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 07:27:10.162231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 07:43:34.182911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 07:43:50.892596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 07:44:07.577762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 07:44:24.195646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 08:01:32.663109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 08:01:49.339692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 08:02:05.916583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 08:02:22.605067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 08:18:46.913733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 08:19:03.576363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 08:19:20.258153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 08:19:36.968586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 08:36:49.572836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 08:37:06.226285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 08:37:22.898598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 08:37:39.541904	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 08:54:04.234873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 08:54:20.835596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 08:54:37.486486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 08:54:54.19747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 09:12:10.848167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 09:12:27.541246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 09:12:44.195125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 09:13:00.83035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 09:29:29.166577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 09:29:45.801841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 09:30:02.489412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 09:30:19.123154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 09:47:52.131977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 09:48:08.794623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 09:48:25.418384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 09:48:42.121805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 10:05:10.115017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 10:05:26.795943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 10:05:43.44429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 10:06:00.106741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 10:23:12.610134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 10:23:29.250802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 10:23:45.944276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 10:24:02.577955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 10:40:35.48813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 10:40:52.144116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 10:41:08.816066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 10:41:25.517623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 10:58:21.82528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 10:58:38.422707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 10:58:55.111538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 10:59:11.906799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 11:15:31.759736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 11:15:48.44681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 11:16:05.158523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 11:16:21.795994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 11:33:15.566436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 11:33:32.255399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 11:33:48.911122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 11:34:05.572632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 11:50:09.791237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 11:50:26.431556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 11:50:43.033169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 11:50:59.812148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 12:07:46.571629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 12:08:03.266427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 12:08:19.910586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 12:08:36.555539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 12:24:43.749254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 12:25:00.438094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 12:25:17.131191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 12:25:33.843345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 12:42:02.438908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 12:42:19.118487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 12:42:35.832829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 12:42:52.517291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 12:58:34.946831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 12:58:51.549316	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 12:59:08.263762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 12:59:24.997884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 13:15:38.927174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 13:15:55.594215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 13:16:12.284744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 13:16:29.017015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 13:32:09.980094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 13:32:26.709521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 13:32:43.441275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 13:33:00.156241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 13:49:13.365865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 13:49:30.022263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 13:49:46.757057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 13:50:03.415534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 14:05:50.389164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 14:06:07.11547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 14:06:23.884737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 14:06:40.622686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 14:22:55.294099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 14:23:11.979438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 14:23:28.566979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 14:25:01.827888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 14:40:47.421661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 14:41:04.122985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 14:41:20.778525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 14:41:37.460267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 14:57:33.033756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 14:57:49.726765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 14:58:06.586802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 14:58:23.374338	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 15:13:59.968549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 15:14:16.684712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 15:14:33.47049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 15:14:50.335882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 15:30:42.048741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 15:31:01.079177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 15:31:17.854967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 15:31:34.631142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 15:47:03.058622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 15:47:19.734103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 15:47:36.490102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 15:47:53.29173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 16:03:32.975031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 16:03:49.738517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 16:04:06.596451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 16:04:23.315776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 16:20:08.151135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 16:20:24.896494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 16:20:41.635772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 16:20:58.375485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 16:37:09.145083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 16:37:26.013006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 16:37:42.800303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 16:38:00.236744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 16:53:38.97833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 16:53:55.734365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 16:54:12.53054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 16:54:29.295143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 17:10:28.836477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 17:10:45.543564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 17:11:02.353308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 17:11:19.112096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 17:27:07.228931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 17:27:23.992257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 17:27:40.725979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 17:27:57.402502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 17:44:39.926093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 17:44:56.634701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 17:45:13.61725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 17:45:30.6831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 18:01:35.470534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 18:01:52.203119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 18:02:09.705396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 18:02:26.438221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 18:18:27.584973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 18:18:44.366564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 18:19:01.110262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 18:19:17.830024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 18:35:18.224525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 18:35:34.993052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 18:35:51.884282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 18:36:08.711157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 18:51:58.854179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 18:52:15.725505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 18:52:32.727549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 18:52:49.571063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 19:08:39.369845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 19:08:56.240889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 19:09:13.334708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 19:09:32.29425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 19:25:52.442689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 19:26:09.367593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 19:26:26.200347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 19:26:45.399563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 19:42:25.79368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 19:42:43.012076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 19:43:00.047914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 19:43:16.834943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 19:58:45.838377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 19:59:02.542415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 19:59:19.449744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 19:59:36.229215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 20:15:36.834465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 20:15:53.523968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 20:16:10.433916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 20:16:27.201237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 20:32:51.579131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 20:33:10.355587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 20:33:27.346705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 20:33:44.422311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 20:50:32.886215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 20:50:49.729163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 20:51:06.569337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 20:51:27.59696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 21:07:41.905324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 21:07:58.647082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 21:08:15.570477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 21:08:34.49062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 21:24:51.082539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 21:25:07.836046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 21:25:24.656118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 21:25:41.578399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 21:41:42.776261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 21:41:59.551204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 21:42:16.369729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 21:42:33.230501	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 21:58:57.131013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 21:59:14.057872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 21:59:32.919409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 21:59:49.748718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 22:15:39.489816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 22:15:56.226807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 22:16:12.979065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 22:16:29.70028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 22:32:50.384931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 22:33:07.039509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 22:33:23.735835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 22:33:40.462606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 22:49:27.076136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 22:49:45.795795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 22:50:02.48038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 22:50:19.205484	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 23:07:25.067043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 23:07:41.653124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 23:07:58.347653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 23:08:15.057206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 23:24:23.294148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 23:24:39.953954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 23:24:56.625596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 23:25:13.352937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 23:42:09.518201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 23:42:26.174208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-04 23:42:42.8538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-04 23:42:59.562398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-04 23:59:40.842062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-04 23:59:57.462464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 00:00:14.185438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 00:00:30.868993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 00:17:43.250856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 00:17:59.918521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 00:18:16.653076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 00:18:33.384365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 00:34:57.161047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 00:35:13.770115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 00:35:30.408623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 00:35:47.122849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 00:52:59.121666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 00:53:15.732666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 00:53:32.632573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 00:53:49.298528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 01:10:15.236099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 01:10:31.885646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 01:10:48.525717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 01:11:05.221608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 01:28:13.482212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 01:28:30.136908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 01:28:46.727177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 01:29:03.430183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 01:45:29.255155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 01:45:45.91399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 01:46:02.622328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 01:46:19.280136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 02:03:28.883602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 02:03:45.540081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 02:04:02.205071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 02:04:18.832862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 02:20:44.805971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 02:21:01.467134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 02:21:18.111327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 02:21:34.791357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 02:38:45.100814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 02:39:01.75841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 02:39:18.41638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 02:39:35.082405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 02:56:01.07608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 02:56:17.714373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 02:56:34.302935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 02:56:51.007855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 03:13:59.163237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 03:14:15.805151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 03:14:32.474126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 03:14:49.1447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 03:31:13.119103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 03:31:29.830858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 03:31:46.529188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 03:32:03.201716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 03:49:11.641157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 03:49:28.306419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 03:49:44.927978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 03:50:01.581499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 04:06:27.240448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 04:06:43.919773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 04:07:00.620092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 04:07:17.592343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 04:24:25.631308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 04:24:42.298114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 04:24:58.995343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 04:25:15.561246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 04:41:41.395874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 04:41:58.022067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 04:42:14.631699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 04:42:31.325161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 04:59:39.574855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 04:59:56.255909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 05:00:12.964729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 05:00:29.618345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 05:16:55.180903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 05:17:11.858091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 05:17:28.444082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 05:17:45.108936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 05:34:53.205566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 05:35:09.759329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 05:35:26.448567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 05:35:43.158711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 05:52:06.476065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 05:52:23.10039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 05:52:39.781034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 05:52:56.41683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 06:10:06.588901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 06:10:23.284842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 06:10:39.847425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 06:10:56.527447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 06:27:22.497084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 06:27:39.170885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 06:27:55.848061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 06:28:12.521552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 06:45:33.561699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 06:45:50.252425	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 06:46:06.878212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 06:46:23.530497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 07:02:49.548243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 07:03:06.206692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 07:03:22.865703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 07:03:39.553193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 07:20:53.277675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 07:21:09.911424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 07:21:26.542086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 07:21:43.15386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 07:38:07.137526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 07:38:23.797365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 07:38:40.493752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 07:38:57.166872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 07:55:45.403347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 07:56:02.051096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 07:56:18.703208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 07:56:35.376532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 08:12:23.519922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 08:12:40.176165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 08:12:56.798689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 08:13:13.487535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 08:29:41.698528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 08:29:58.357048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 08:30:15.027745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 08:30:31.691027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 08:46:13.569293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 08:46:30.252038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 08:46:46.939035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 08:47:03.635258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 09:03:56.731875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 09:04:13.395587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 09:04:30.095384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 09:04:46.828647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 09:20:32.959053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 09:20:49.642348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 09:21:06.293294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 09:21:22.980708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 09:37:53.704058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 09:38:10.418737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 09:38:27.008946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 09:38:43.675655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 09:54:30.455055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 09:54:47.159955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 09:55:03.827202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 09:55:20.473386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 10:12:12.400134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 10:12:29.072195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 10:12:45.79664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 10:13:02.495847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 10:29:18.974207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 10:29:35.628323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 10:29:52.300637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 10:30:08.972607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 10:46:44.273396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 10:47:00.955713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 10:47:17.691641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 10:47:34.336914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 11:03:48.529657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 11:04:05.215137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 11:04:21.921681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 11:04:38.600283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 11:21:20.463595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 11:21:37.125231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 11:21:53.792917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 11:22:10.552195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 11:38:36.720105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 11:38:53.332113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 11:39:10.077629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 11:39:26.806687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 11:55:58.160966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 11:56:14.820101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 11:56:31.726261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 11:56:48.426823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 12:13:01.962497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 12:13:18.553201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 12:13:35.206373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 12:13:51.922473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 12:30:27.244417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 12:30:43.900527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 12:31:00.555554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 12:31:17.324049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 12:47:03.671365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 12:47:20.497088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 12:47:37.248838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 12:47:53.940189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 13:04:15.228825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 13:04:31.963432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 13:04:48.714027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 13:05:05.512597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 13:21:32.846679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 13:21:49.539806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 13:22:06.324301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 13:22:23.02204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 13:38:37.347672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 13:38:54.056709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 13:39:10.768283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 13:39:27.615334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 13:55:08.07104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 13:55:24.81664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 13:55:41.553519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 13:55:58.270829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 14:12:39.692418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 14:12:56.393393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 14:13:13.155847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 14:13:29.880484	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 14:29:18.930095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 14:29:35.653424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 14:29:52.352681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 14:30:09.110181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 14:46:10.448518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 14:46:27.163672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 14:46:43.910687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 14:47:00.689597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 15:02:54.351803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 15:03:11.077438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 15:03:28.004564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 15:03:44.745884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 15:19:44.252161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 15:20:00.989851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 15:20:17.767053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 15:20:34.552922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 15:36:29.116987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 15:36:45.801399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 15:37:02.530948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 15:37:19.264313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 15:53:44.09231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 15:54:00.764909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 15:54:17.479328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 15:54:34.252313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 16:10:37.179452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 16:10:53.915655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 16:11:12.614023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 16:11:29.361498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 16:27:33.463471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 16:27:52.226431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 16:28:08.925199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 16:28:25.74879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 16:44:47.257202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 16:45:03.933755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 16:45:20.899359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 16:45:37.72327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 17:01:22.904861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 17:01:39.569244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 17:01:56.345563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 17:02:13.184662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 17:18:55.038237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 17:19:11.873729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 17:19:29.107211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 17:19:46.400897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 17:36:37.132991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 17:36:54.134444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 17:37:11.362623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 17:37:33.577932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 17:54:29.893312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 17:54:47.088807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 17:55:03.969258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 17:55:21.241081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 18:11:41.282083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 18:11:58.379184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 18:12:15.455169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 18:12:37.744928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 18:29:23.851535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 18:29:40.706051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 18:29:57.414905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 18:30:14.272251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 18:47:39.931424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 18:47:57.0973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 18:48:14.037076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 18:48:31.426537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 19:04:37.382619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 19:04:54.526863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 19:05:11.319628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 19:05:28.302231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 19:22:12.772559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 19:22:29.859901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 19:22:46.840667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 19:23:14.960851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 19:39:13.517819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 19:39:32.26593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 19:39:49.164785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 19:40:05.982834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 19:55:56.60467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 19:56:13.783471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 19:56:31.930444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 19:56:56.194317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 20:13:50.273814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 20:14:07.672081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 20:14:24.895763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 20:14:51.136132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 20:31:18.444755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 20:31:35.718892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 20:31:52.930684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 20:32:10.425983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 20:48:36.342052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 20:48:53.330769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 20:49:10.297454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 20:49:27.20631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 21:05:54.192853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 21:06:11.129028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 21:06:28.1048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 21:06:45.914054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 21:22:38.712331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 21:22:55.611919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 21:23:12.405621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 21:23:29.192205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 21:39:57.376898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 21:40:14.127897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 21:40:30.894617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 21:40:47.638952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 21:56:41.014427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 21:56:57.739372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 21:57:14.669793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 21:57:31.546064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 22:13:50.812565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 22:14:07.518534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 22:14:24.274056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 22:14:40.948769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 22:30:30.86523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 22:30:47.635342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 22:31:04.366742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 22:31:21.085854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 22:48:12.431886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 22:48:29.090031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 22:48:45.799187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 22:49:02.553925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 23:05:14.73916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 23:05:31.440416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 23:05:48.116873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 23:06:04.987652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 23:23:06.425415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 23:23:23.07403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 23:23:39.750379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 23:23:56.438328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 23:40:02.258488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 23:40:18.907534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 23:40:35.518365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 23:40:52.239282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-05 23:58:00.631223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-05 23:58:17.210735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-05 23:58:33.915002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-05 23:58:50.6126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 00:15:15.984963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 00:15:32.597527	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 00:15:49.275204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 00:16:05.915029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 00:33:14.064705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 00:33:30.781143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 00:33:47.395721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 00:34:04.1566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 00:50:30.041008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 00:50:46.70279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 00:51:03.379041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 00:51:20.113779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 01:08:32.350803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 01:08:49.049055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 01:09:05.710096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 01:09:22.373899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 01:25:48.228066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 01:26:04.818718	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 01:26:21.477038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 01:26:38.183162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 01:43:46.490921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 01:45:19.639153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 01:45:36.319449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 01:45:52.993993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 02:02:17.321242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 02:02:33.949299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 02:02:50.64054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 02:03:07.359093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 02:20:15.464311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 02:20:32.094819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 02:20:48.759552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 02:21:05.444886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 02:37:29.497693	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 02:37:46.175049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 02:38:02.790099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 02:38:19.482751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 02:55:29.878381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 02:55:46.501552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 02:57:19.648321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 02:57:36.380794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 03:14:00.463175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 03:14:17.132573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 03:14:33.764822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 03:14:50.424375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 03:32:00.424447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 03:32:17.107003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 03:32:33.796919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 03:32:50.47558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 03:49:16.647629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 03:49:33.283494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 03:49:49.985343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 03:50:06.673252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 04:07:17.124241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 04:07:33.781164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 04:07:50.438817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 04:08:07.066666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 04:24:30.688804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 04:24:47.290361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 04:25:03.977208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 04:25:20.629057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 04:42:41.730284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 04:42:58.377268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 04:43:15.058216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 04:43:31.744793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 04:59:55.530254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 05:00:12.178363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 05:00:28.893992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 05:00:45.550912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 05:17:56.013482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 05:18:12.720095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 05:18:29.407237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 05:18:46.087622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 05:35:09.758809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 05:35:26.433176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 05:35:43.047021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 05:35:59.728988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 05:53:07.721334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 05:53:24.373633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 05:53:41.083368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 05:53:57.714292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 06:10:25.442934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 06:10:42.131566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 06:10:58.795279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 06:11:15.459683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 06:28:27.902842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 06:28:44.593982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 06:29:01.192019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 06:29:17.854044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 06:45:41.586343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 06:45:58.235932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 06:46:14.912729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 06:46:31.644572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 07:03:39.585543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 07:03:56.355198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 07:04:13.052073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 07:04:29.690879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 07:20:53.660919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 07:21:10.297429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 07:21:26.964857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 07:21:43.697732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 07:38:51.870238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 07:39:08.536586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 07:39:25.176894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 07:39:41.864458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 07:56:05.591562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 07:56:22.276247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 07:56:38.853461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 07:56:55.522897	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 08:14:04.072566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 08:14:20.643492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 08:14:37.322592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 08:14:53.968147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 08:31:18.04027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 08:31:34.729112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 08:31:51.398841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 08:32:08.047401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 08:48:54.441947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 08:49:11.133324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 08:49:27.889847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 08:49:44.578477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 09:05:55.973128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 09:06:12.662456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 09:06:29.31055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 09:06:45.967486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 09:23:42.887146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 09:23:59.624187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 09:24:16.343459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 09:24:32.975626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 09:40:40.523797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 09:40:57.231255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 09:41:13.852071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 09:41:30.544621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 09:58:25.250079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 09:58:41.917826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 09:58:58.549178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 09:59:15.269619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 10:15:26.445079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 10:15:43.079585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 10:15:59.794837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 10:16:16.617828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 10:33:36.137508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 10:33:52.754476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 10:34:09.410271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 10:34:26.095851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 10:51:03.229533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 10:51:19.806378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 10:51:36.540633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 10:51:55.311429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 11:09:06.16256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 11:09:23.109817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 11:09:40.068299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 11:09:57.074092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 11:26:13.709719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 11:26:30.55248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 11:26:47.655276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 11:27:04.578069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 11:44:02.635741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 11:44:19.490765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 11:44:36.38798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 11:44:53.29184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 12:01:56.670491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 12:02:14.173419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 12:02:31.687821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 12:02:48.85289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 12:19:25.177094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 12:19:41.929384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 12:19:58.7372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 12:20:16.198751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 12:36:32.804633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 12:36:49.652553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 12:37:06.320062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 12:37:23.029612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 12:54:17.667943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 12:54:34.452251	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 12:54:51.17631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 12:55:07.947044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 13:11:17.036525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 13:11:33.710974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 13:11:50.49651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 13:12:09.242337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 13:29:48.551764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 13:30:05.321305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 13:30:22.036997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 13:30:38.737004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 13:49:07.330156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 13:49:23.985479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 13:49:40.777843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 13:49:57.542739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 14:07:24.412254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 14:07:41.159104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 14:07:57.993522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 14:08:14.684723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 14:24:23.931742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 14:24:40.643076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 14:24:57.374467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 14:25:14.759467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 14:41:46.205967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 14:42:02.949777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 14:42:19.766772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 14:42:36.584974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 14:58:44.582151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 14:59:01.324392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 14:59:18.133329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 14:59:34.874505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 15:15:41.767139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 15:15:58.536042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 15:16:15.465476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 15:16:32.238191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 15:32:12.265701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 15:32:28.908783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 15:32:45.68733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 15:33:02.679908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 15:48:50.646877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 15:49:07.376395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 15:49:24.580087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 15:49:44.419546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 16:05:34.954235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 16:05:51.700397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 16:06:08.46521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 16:06:25.271248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 16:22:19.835561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 16:22:36.764271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 16:22:53.514134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 16:23:11.116628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 16:39:08.877696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 16:39:25.619354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 16:39:42.555473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 16:39:59.552181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 16:56:12.742249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 16:56:29.536712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 16:56:46.29859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 16:57:03.969911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 17:13:15.353712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 17:13:32.268125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 17:13:49.186247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 17:14:06.463846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 17:30:39.187946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 17:30:56.001047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 17:31:13.170579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 17:31:30.612076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 17:47:32.787734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 17:47:49.63778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 17:48:06.569838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 17:48:23.299045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 18:04:34.110614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 18:04:51.071017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 18:05:08.16492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 18:05:27.915383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 18:21:23.572537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 18:21:40.771819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 18:21:57.80021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 18:22:15.225248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 18:38:36.991893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 18:38:53.890184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 18:39:10.990529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 18:39:27.822234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 18:55:34.970297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 18:55:52.136873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 18:56:09.2479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 18:56:29.798017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 19:12:46.057983	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 19:13:03.141341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 19:13:20.163946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 19:13:38.031367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 19:29:50.930105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 19:30:08.493885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 19:30:26.018677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 19:30:45.823257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 19:46:56.50912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 19:47:14.036201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 19:47:31.096209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 19:47:48.540506	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 20:03:31.591974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 20:03:48.320301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 20:04:05.535182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 20:04:25.025608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 20:20:28.596397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 20:20:45.845993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 20:21:03.391152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 20:21:20.85195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 20:38:32.376173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 20:38:56.372901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 20:39:13.520575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 20:39:42.957725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 20:56:27.35253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 20:56:44.318127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 20:57:01.110172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 20:57:20.16433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 21:14:10.606102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 21:14:27.591051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 21:14:44.492849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 21:15:02.146246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 21:31:37.908596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 21:31:54.720061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 21:32:11.64606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 21:32:29.187713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 21:49:30.419157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 21:49:47.219989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 21:50:04.265993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 21:50:24.072478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 22:06:35.270836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 22:06:52.024009	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 22:07:08.730391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 22:07:25.846448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 22:24:23.629414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 22:24:41.017648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 22:24:58.44137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 22:25:15.924637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 22:41:49.887058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 22:42:06.548431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 22:42:23.325352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 22:42:39.996932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 22:59:52.395593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 23:00:09.168911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 23:00:25.769121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 23:00:42.54408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 23:17:15.359286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 23:17:31.99283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 23:17:48.691771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 23:18:05.403793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 23:35:21.715495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 23:35:38.41618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 23:35:55.073977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 23:36:11.691704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-06 23:52:36.068213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-06 23:52:52.72743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-06 23:53:09.468018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-06 23:53:26.173703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 00:10:43.272758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 00:10:59.925133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 00:11:16.597905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 00:11:33.310285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 00:28:01.544246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 00:28:18.226546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 00:28:34.895927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 00:28:51.593023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 00:46:07.742694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 00:46:24.405759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 00:46:41.131502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 00:46:57.778069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 01:03:23.854736	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 01:03:40.493389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 01:03:57.067567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 01:04:13.787674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 01:21:21.89151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 01:21:38.516786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 01:21:55.164431	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 01:22:11.826488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 01:38:41.985289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 01:38:58.636683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 01:39:15.552594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 01:39:32.136134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 01:56:42.635348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 01:56:59.308985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 01:57:15.919395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 01:57:32.58398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 02:13:56.700676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 02:14:13.373265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 02:14:30.070383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 02:14:46.760684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 02:31:58.912354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 02:32:15.625866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 02:32:32.274091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 02:32:48.921795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 02:49:13.042303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 02:49:29.657306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 02:49:46.330374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 02:50:02.985412	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 03:07:15.093812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 03:07:31.725359	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 03:07:48.450479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 03:08:05.153808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 03:24:35.149117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 03:24:51.820754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 03:25:08.442786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 03:25:25.117778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 03:42:32.720429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 03:42:49.320805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 03:43:05.968162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 03:43:22.630887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 03:59:48.611335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 04:00:05.251844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 04:00:21.932244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 04:00:38.588656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 04:17:46.58666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 04:18:03.274076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 04:18:19.869517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 04:18:36.53306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 04:35:00.42905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 04:35:17.042298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 04:35:33.697191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 04:35:50.411902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 04:53:00.235731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 04:53:16.911092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 04:53:33.620266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 04:53:50.283248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 05:10:18.464997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 05:10:35.087145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 05:10:51.754075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 05:11:08.49901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 05:28:16.508043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 05:28:33.132764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 05:28:49.791958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 05:29:06.470689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 05:45:32.250117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 05:45:48.924671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 05:46:05.663875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 05:46:22.340764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 06:03:32.516315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 06:03:49.175259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 06:04:05.830201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 06:04:22.551594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 06:20:46.564711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 06:21:03.231909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 06:21:19.895033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 06:21:36.593679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 06:38:44.795419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 06:39:01.456841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 06:39:18.15238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 06:39:34.781943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 06:55:58.975056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 06:56:15.535585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 06:56:32.213441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 06:56:48.924985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 07:14:00.749773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 07:14:17.415972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 07:14:34.104283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 07:14:50.748622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 07:31:14.582286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 07:31:31.213215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 07:31:47.836722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 07:32:04.537283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 07:49:16.469887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 07:49:33.030645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 07:49:49.710959	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 07:50:06.421144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 08:06:30.646973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 08:06:47.297188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 08:07:03.967052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 08:07:20.623973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 08:24:42.010293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 08:24:58.710103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 08:25:15.274713	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 08:25:31.96315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 08:41:34.108804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 08:41:50.738611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 08:42:07.394329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 08:42:24.101506	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 08:59:12.375566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 08:59:29.015593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 08:59:45.595558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 09:00:02.335557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 09:16:06.757654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 09:16:23.460495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 09:16:40.166308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 09:16:56.835553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 09:33:26.086686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 09:33:42.744727	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 09:33:59.410075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 09:34:16.075104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 09:49:58.729837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 09:50:15.48256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 09:50:32.268783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 09:50:49.00891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 10:07:19.557894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 10:07:36.367974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 10:07:53.163104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 10:08:10.066816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 10:23:58.755685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 10:24:15.65013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 10:24:32.426366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 10:24:49.413016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 10:41:03.088529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 10:41:19.979067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 10:41:36.862189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 10:41:53.888855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 10:57:16.869528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 10:57:33.628308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 10:57:50.502871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 10:58:07.167951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 11:14:17.868113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 11:14:34.559599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 11:14:51.510041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 11:15:08.279476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 11:30:33.462908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 11:30:50.223833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 11:31:07.067977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 11:31:23.890775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 11:47:39.807832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 11:47:56.748977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 11:48:13.597575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 11:48:30.544639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 12:03:54.412027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 12:04:11.159738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 12:04:28.050107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 12:04:45.133167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 12:21:17.565394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 12:21:34.862273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 12:21:52.088858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 12:22:09.646508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 12:38:45.157465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 12:39:01.951649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 12:39:18.711012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 12:39:35.543448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 12:55:48.57091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 12:56:05.369067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 12:56:22.238941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 12:56:41.435387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 13:12:25.671234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 13:12:42.819847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 13:13:00.275642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 13:13:18.087299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 13:29:42.660868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 13:29:59.669678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 13:30:17.133252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 13:30:41.389246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 13:46:30.05081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 13:46:46.982557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 13:47:04.329399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 13:47:22.137671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 14:03:36.880932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 14:03:53.697735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 14:04:16.012088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 14:04:35.592656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 14:20:17.386971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 14:20:34.626297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 14:20:56.04326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 14:21:16.287467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 14:37:05.68953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 14:37:25.886566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 14:37:42.879034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 14:38:01.789831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 14:53:33.775004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 14:53:52.966287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 14:54:14.079142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 14:54:35.345476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 15:10:26.625774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 15:10:45.568296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 15:11:02.990384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 15:11:22.472383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 15:27:08.30343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 15:27:33.80022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 15:27:56.203654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 15:28:16.894523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 15:44:55.185276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 15:45:12.007569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 15:45:29.058203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 15:45:46.235792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 16:01:22.67477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 16:01:41.435357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 16:01:58.240776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 16:02:15.057817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 16:18:15.101071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 16:18:35.018336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 16:18:55.828787	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 16:19:15.267587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 16:34:49.910031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 16:35:06.946387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 16:35:26.220635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 16:35:43.413233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 16:51:59.588362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 16:52:16.313977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 16:52:36.818368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 16:52:53.967308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 17:08:30.89067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 17:08:47.718975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 17:09:04.732976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 17:09:24.039404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 17:25:40.61677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 17:25:57.519925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 17:26:18.489952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 17:26:35.412033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 17:42:13.52981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 17:42:30.374016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 17:42:50.454715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 17:43:09.284215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 17:58:40.010192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 17:59:02.290725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 17:59:22.001231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 17:59:41.775733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 18:15:19.158809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 18:15:40.400895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 18:16:05.832737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 18:16:27.56717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 18:32:31.505168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 18:32:52.811106	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 18:33:10.05168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 18:33:29.837409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 18:50:05.520665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 18:50:22.445923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 18:50:42.501386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 18:51:01.37329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 19:06:52.232332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 19:07:11.357441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 19:07:28.431492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 19:07:47.903028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 19:23:32.70923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 19:23:51.50195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 19:24:08.92871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 19:24:25.929915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 19:40:30.852459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 19:40:47.60398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 19:41:04.891329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 19:41:24.051393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 19:57:06.440872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 19:57:23.482671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 19:57:40.666928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 19:57:58.157575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 20:14:31.36257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 20:14:48.49148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 20:15:07.67735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 20:15:28.137551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 20:31:07.740465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 20:31:24.735463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 20:31:43.922008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 20:32:03.19597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 20:48:42.937838	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 20:49:06.942988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 20:49:24.30956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 20:49:43.808861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 21:06:00.260637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 21:06:17.227764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 21:06:36.285724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 21:06:57.48648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 21:24:11.985475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 21:24:31.039348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 21:24:50.073062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 21:25:12.657204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 21:41:12.63487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 21:41:29.346237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 21:41:46.396999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 21:42:03.95895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 21:58:52.797791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 21:59:09.912982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 21:59:26.76381	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 21:59:43.749162	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 22:15:31.682205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 22:15:48.558326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 22:16:05.416715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 22:16:22.226462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 22:33:19.382909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 22:33:36.153617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 22:33:52.864546	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 22:34:09.971063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 22:49:59.367059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 22:50:16.118308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 22:50:32.817018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 22:50:49.487686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 23:07:34.010135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 23:07:50.621936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 23:08:07.516521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 23:08:26.409047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 23:24:44.16587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 23:25:00.896234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 23:25:17.596117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 23:25:34.240194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 23:42:37.413768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 23:42:54.126401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-07 23:43:10.827518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-07 23:43:27.475323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-07 23:59:40.847842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-07 23:59:57.521244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 00:00:14.192629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 00:00:30.921388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 00:17:27.154923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 00:17:43.814539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 00:18:00.425953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 00:18:17.262577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 00:34:46.465271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 00:35:03.165033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 00:35:19.831297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 00:35:36.548532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 00:52:44.011301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 00:53:00.71213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 00:53:17.375055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 00:53:34.02906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 01:10:02.792505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 01:10:19.49007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 01:10:36.14974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 01:10:52.863526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 01:28:03.267667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 01:28:19.883006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 01:28:36.576354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 01:28:53.273508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 01:45:21.923214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 01:45:38.64449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 01:45:55.238342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 01:46:11.967813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 02:03:23.274459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 02:03:39.952053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 02:03:56.615734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 02:04:13.256793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 02:20:36.346169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 02:20:52.990747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 02:21:09.705328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 02:22:42.975335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 02:39:52.86056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 02:40:09.498686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 02:40:26.125689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 02:40:42.829373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 02:57:07.974878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 02:57:24.633185	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 02:57:41.277599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 02:57:57.965528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 03:15:06.665376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 03:15:23.317592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 03:15:40.027153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 03:15:56.59491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 03:32:26.525222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 03:32:43.153735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 03:32:59.808809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 03:33:16.484365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 03:50:34.603873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 03:50:51.259827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 03:51:07.951914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 03:51:24.706515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 04:07:47.476699	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 04:08:04.185964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 04:08:20.79991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 04:08:37.488022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 04:25:45.529839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 04:26:02.134956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 04:26:18.843898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 04:26:35.49719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 04:43:01.260349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 04:43:17.994931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 04:43:34.657158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 04:43:51.253583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 05:00:59.524455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 05:01:16.236082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 05:01:32.862454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 05:01:49.527785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 05:18:12.273882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 05:18:28.877252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 05:18:45.523436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 05:19:02.211997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 05:36:07.361169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 05:36:24.017843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 05:36:40.650489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 05:36:57.316674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 05:53:21.238702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 05:53:37.899733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 05:53:54.576135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 05:54:11.301487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 06:11:19.281571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 06:11:35.861971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 06:11:52.504929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 06:12:09.217678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 06:28:33.015155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 06:28:49.692204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 06:29:06.37773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 06:29:23.023664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 06:46:31.523919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 06:46:48.158584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 06:47:04.798779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 06:47:21.421285	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 07:03:45.564697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 07:04:02.16921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 07:04:18.847663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 07:04:35.575318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 07:21:42.676651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 07:21:59.331747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 07:22:16.011995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 07:22:32.721863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 07:38:53.473799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 07:39:10.138593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 07:39:26.766588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 07:39:43.448358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 07:56:55.533719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 07:57:12.074764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 07:57:28.727203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 07:57:45.569103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 08:14:08.502321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 08:14:25.158537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 08:14:41.874655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 08:14:58.553751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 08:32:03.729954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 08:32:20.415195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 08:32:37.147223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 08:32:53.771117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 08:48:59.783329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 08:49:16.467178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 08:49:33.083567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 08:49:49.832638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 09:06:12.273294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 09:06:28.887199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 09:06:45.593928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 09:07:02.290476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 09:22:42.184385	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 09:22:58.808415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 09:23:15.466499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 09:23:32.184457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 09:40:00.856368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 09:40:17.555421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 09:40:34.265531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 09:40:50.915644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 09:56:34.967765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 09:56:51.621005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 09:57:08.510458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 09:57:25.291489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 10:13:51.973007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 10:14:08.653819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 10:14:25.301678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 10:14:42.19771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 10:30:25.210649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 10:30:42.351842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 10:30:59.267951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 10:31:16.203809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 10:48:02.309397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 10:48:19.059096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 10:48:35.827884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 10:48:52.725905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 11:04:25.219569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 11:04:42.027916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 11:04:58.926036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 11:05:15.684834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 11:21:44.32485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 11:22:01.264862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 11:22:18.73816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 11:22:35.821839	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 11:38:58.741149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 11:39:15.652574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 11:39:32.361504	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 11:39:49.648644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 11:56:35.400991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 11:56:52.180433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 11:57:13.03857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 11:57:30.0953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 12:13:22.688426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 12:13:39.444654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 12:13:58.328442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 12:14:15.483556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 12:30:34.756112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 12:30:53.582334	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 12:31:10.51481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 12:31:28.62926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 12:47:15.272419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 12:47:36.073505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 12:47:53.127833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 12:48:12.115136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 13:04:43.575271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 13:05:02.967172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 13:05:21.997955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 13:05:39.502849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 13:21:31.539807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 13:21:50.446956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 13:22:11.568785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 13:22:28.818909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 13:39:47.097861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 13:40:09.077243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 13:40:26.20581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 13:40:43.104332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 13:56:53.190825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 13:57:13.017183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 13:57:32.872088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 13:57:52.387561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 14:14:22.028077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 14:14:43.018189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 14:15:02.242911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 14:15:23.564082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 14:31:59.948502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 14:32:18.773213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 14:32:37.572012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 14:32:54.615011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 14:49:43.603567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 14:50:02.448467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 14:50:19.458233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 14:50:38.375692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 15:06:57.705821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 15:07:14.478218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 15:07:31.550834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 15:07:51.547756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 15:24:55.082082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 15:25:11.93075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 15:25:28.911037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 15:25:51.267222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 15:42:08.656518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 15:42:25.794122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 15:42:45.098848	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 15:43:04.5367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 15:59:43.129544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 15:59:59.997535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 16:00:19.090167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 16:00:37.976284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 16:17:00.914535	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 16:17:17.807377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 16:17:34.72964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 16:17:51.559223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 16:34:38.081953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 16:34:55.413551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 16:35:12.246488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 16:35:29.165254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 16:52:04.752053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 16:52:21.513985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 16:52:38.476762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 16:52:55.762427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 17:09:44.653416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 17:10:03.442168	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 17:10:20.341973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 17:10:39.935717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 17:27:43.178201	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 17:28:01.955985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 17:28:18.947263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 17:28:37.845823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 17:46:46.0206	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 17:47:02.696293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 17:47:19.441962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 17:47:37.767975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 18:05:48.282958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 18:06:05.940156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 18:06:23.088342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 18:06:40.627413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 18:23:38.941311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 18:23:56.032769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 18:24:13.146825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 18:24:35.97581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 18:40:48.79808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 18:41:07.774644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 18:41:24.789619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 18:41:42.161856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 18:59:12.223697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 18:59:32.367634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 18:59:49.142148	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 19:00:05.958861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 19:17:07.195623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 19:17:24.437649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 19:17:41.369825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 19:18:00.337013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 19:34:14.344012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 19:34:31.51227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 19:34:49.249974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 19:35:10.240956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 19:51:36.886218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 19:51:54.028287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 19:52:13.264717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 19:52:30.78006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 20:09:44.363981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 20:10:01.288008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 20:10:22.073879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 20:10:41.688068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 20:27:24.31974	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 20:27:43.556281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 20:28:00.832556	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 20:28:18.032039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 20:45:00.198045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 20:45:17.048554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 20:45:33.983733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 20:45:51.095528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 21:02:43.545269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 21:03:00.187771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 21:03:17.380254	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 21:03:36.098596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 21:20:47.621543	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 21:21:04.291975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 21:21:21.002895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 21:21:37.800331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 21:38:43.773248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 21:39:00.48506	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 21:39:17.146136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 21:39:33.892245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 21:56:06.971188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 21:56:23.693662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 21:56:40.46227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 21:56:57.140554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 22:13:49.481624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 22:14:08.363294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 22:14:25.087345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 22:14:41.800001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 22:31:00.454912	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 22:31:17.210043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 22:31:33.920962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 22:31:50.640183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 22:48:12.566125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 22:48:29.204746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 22:48:45.927759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 22:49:02.633995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 23:05:22.785792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 23:05:39.492298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 23:05:58.999789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 23:06:15.811701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 23:22:48.984666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 23:23:05.653422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 23:23:22.420731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 23:23:39.239469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 23:40:20.231601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 23:40:36.958971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 23:40:53.680143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 23:41:10.416824	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-08 23:57:59.146876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-08 23:58:15.879299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-08 23:58:32.554679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-08 23:58:49.264066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 00:15:38.130456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 00:15:54.808074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 00:16:11.502402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 00:16:28.222236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 00:33:17.006952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 00:33:33.640129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 00:33:50.365978	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 00:34:07.05523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 00:50:53.437238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 00:51:10.092215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 00:51:26.68648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 00:51:43.361427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 01:08:35.417767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 01:08:52.060558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 01:09:08.760195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 01:09:25.420643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 01:26:17.554267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 01:26:34.175774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 01:26:50.834771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 01:27:07.454884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 01:43:55.260846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 01:44:11.918064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 01:44:28.560423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 01:44:45.258832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 02:01:35.373956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 02:01:52.001166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 02:02:08.674104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 02:02:25.388989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 02:19:21.520649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 02:19:38.246328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 02:19:54.931041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 02:20:11.661069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 02:36:59.587744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 02:37:16.170856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 02:37:32.864797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 02:37:49.540273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 02:54:37.948812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 02:54:54.647869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 02:55:11.254701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 02:55:27.961439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 03:12:17.970481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 03:12:34.593027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 03:12:51.218004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 03:13:07.883651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 03:30:04.226476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 03:30:20.876908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 03:30:37.499585	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 03:30:54.171743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 03:47:46.205328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 03:48:02.84476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 03:48:19.532184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 03:48:36.145967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 04:05:30.258333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 04:05:46.91245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 04:06:03.638756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 04:06:20.30944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 04:23:05.15205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 04:23:21.813514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 04:23:38.497758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 04:23:55.194875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 04:40:48.884147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 04:41:05.501925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 04:41:22.236147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 04:41:38.925283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 04:58:40.071511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 04:58:56.787671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 04:59:13.442401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 04:59:30.122034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 05:16:20.33831	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 05:16:36.923675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 05:16:53.610625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 05:17:10.310846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 05:34:11.023278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 05:34:27.634898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 05:34:44.282158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 05:35:00.979668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 05:51:49.008833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 05:52:05.592489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 05:52:22.246435	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 05:52:38.999955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 06:09:40.153811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 06:09:56.746006	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 06:10:13.374099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 06:10:30.087258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 06:27:42.12097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 06:27:58.780405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 06:28:15.455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 06:28:32.141369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 06:45:50.504644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 06:46:07.114297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 06:46:23.824988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 06:46:40.471091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 07:03:50.646767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 07:04:07.272241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 07:04:23.856231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 07:04:40.549542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 07:21:32.465462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 07:21:49.152918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 07:22:05.815541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 07:22:22.502284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 07:38:50.617798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 07:39:07.217319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 07:39:23.914879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 07:39:40.554286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 07:56:04.450171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 07:56:21.141035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 07:56:37.808738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 07:56:54.436735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 08:13:28.66579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 08:13:45.311115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 08:14:01.979259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 08:14:18.660072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 08:30:24.742706	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 08:30:41.395144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 08:30:58.244478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 08:31:14.918942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 08:47:21.163246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 08:47:37.825676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 08:47:54.504922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 08:48:11.17173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 09:04:12.705817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 09:04:29.397249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 09:04:46.088382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 09:05:02.752152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 09:21:05.061204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 09:21:21.842046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 09:21:38.531726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 09:21:55.17795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 09:37:58.984218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 09:38:15.595647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 09:38:32.206369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 09:38:48.902302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 09:54:38.987958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 09:54:55.729493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 09:55:12.536754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 09:55:29.198623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 10:11:31.414427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 10:11:48.118432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 10:12:04.77382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 10:12:21.457182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 10:28:22.703661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 10:28:39.408197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 10:28:56.361637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 10:29:13.074227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 10:45:01.296788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 10:45:18.047723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 10:45:34.78613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 10:45:51.685392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 11:01:30.513894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 11:01:47.255048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 11:02:04.090541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 11:02:20.785622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 11:18:37.479095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 11:18:54.225407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 11:19:10.99156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 11:19:27.67207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 11:37:47.16528	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 11:38:03.853153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 11:38:20.519428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 11:38:37.26779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 11:54:27.74116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 11:54:44.457612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 11:55:01.078312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 11:55:17.825226	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 12:11:24.447447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 12:11:41.34988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 12:11:58.049372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 12:12:14.766021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 12:28:07.876046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 12:28:24.720921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 12:28:41.35239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 12:29:00.099771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 12:45:00.787388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 12:45:17.507987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 12:45:34.276409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 12:45:51.032564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 13:01:56.903607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 13:02:13.570542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 13:02:30.356072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 13:02:47.129155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 13:19:03.986763	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 13:19:20.878773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 13:19:37.745355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 13:19:54.45677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 13:35:47.66434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 13:36:04.307575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 13:36:21.082405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 13:36:37.791062	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 13:52:39.72878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 13:52:56.421028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 13:53:13.235423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 13:53:29.987462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 14:09:26.79622	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 14:09:43.474509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 14:10:00.352257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 14:10:17.368227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 14:25:51.704497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 14:26:08.528483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 14:26:25.258561	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 14:26:42.688618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 14:43:06.80086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 14:43:23.622014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 14:43:40.35229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 14:43:57.164826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 14:59:46.972986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 15:00:03.898717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 15:00:20.657114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 15:00:39.493566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 15:16:21.076634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 15:16:37.83018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 15:16:54.50681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 15:17:11.323102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 15:33:05.587135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 15:33:25.51594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 15:33:42.193551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 15:33:59.063873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 15:49:35.39866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 15:49:52.267172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 15:50:09.595844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 15:50:28.481125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 16:06:19.51501	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 16:06:36.273707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 16:06:53.091462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 16:07:10.092627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 16:23:21.544614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 16:23:38.332812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 16:23:55.469559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 16:24:14.414388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 16:40:16.51429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 16:40:33.554394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 16:40:50.518723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 16:41:08.031674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 16:56:58.572312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 16:57:15.420352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 16:57:32.353284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 16:57:51.24362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 17:13:53.294911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 17:14:10.460731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 17:14:27.522223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 17:14:46.664948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 17:31:06.051719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 17:31:22.920244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 17:31:40.17696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 17:32:02.146315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 17:49:13.976242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 17:49:31.067647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 17:49:47.953742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 17:50:04.905573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 18:05:40.293029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 18:05:59.611633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 18:06:17.034516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 18:06:34.554075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 18:22:38.65994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 18:22:55.599346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 18:23:12.490454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 18:23:31.548139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 18:42:27.069613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 18:42:46.213459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 18:43:05.540038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 18:43:24.329814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 18:59:46.355697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 19:00:03.431184	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 19:00:20.403574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 19:00:39.330742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 19:16:22.729073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 19:16:39.564152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 19:16:56.777461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 19:17:15.654057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 19:32:50.636536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 19:33:07.629368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 19:33:24.677301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 19:33:47.774246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 19:49:32.866823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 19:49:49.76646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 19:50:06.893694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 19:50:31.437217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 20:06:12.125215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 20:06:29.396584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 20:06:46.191638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 20:07:03.852492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 20:23:41.211468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 20:23:58.01717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 20:24:15.05149	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 20:24:32.053199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 20:40:51.187888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 20:41:07.997957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 20:41:24.76121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 20:41:41.648294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 20:57:40.521807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 20:57:57.312759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 20:58:14.055801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 20:58:31.081507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 21:15:15.92515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 21:15:32.713449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 21:15:49.556042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 21:16:06.371963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 21:33:18.788439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 21:33:35.505029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 21:33:52.313948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 21:34:09.065835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 21:51:09.909871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 21:51:26.649997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 21:51:43.452249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 21:52:00.148992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 22:08:54.078225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 22:09:10.85951	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 22:09:27.595151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 22:09:44.524002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 22:26:20.242121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 22:26:36.978623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 22:26:53.77814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 22:27:10.65156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 22:43:29.987382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 22:43:46.783236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 22:44:03.591626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 22:44:20.442056	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 23:00:52.489558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 23:01:09.198698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 23:01:25.967245	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 23:01:42.767156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 23:17:47.655873	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 23:18:04.319782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 23:18:20.986571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 23:18:37.710159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 23:35:36.724491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 23:35:53.547139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 23:36:10.222878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 23:36:26.935647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-09 23:52:53.143482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-09 23:53:09.796797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-09 23:53:26.466634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-09 23:53:43.171987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 00:10:29.510336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 00:10:46.149231	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 00:11:02.820343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 00:11:19.618644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 00:28:10.012919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 00:28:26.623049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 00:28:43.31844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 00:29:00.020769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 00:45:50.25507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 00:46:06.89406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 00:46:23.491297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 00:46:40.243935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 01:03:28.32397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 01:03:44.98307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 01:04:01.573882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 01:04:18.270526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 01:21:26.446025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 01:21:43.087688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 01:21:59.649896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 01:22:16.356677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 01:39:26.005269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 01:39:42.589343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 01:39:59.252158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 01:40:15.996639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 01:57:28.595911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 01:57:45.268069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 01:58:01.969866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 01:58:18.63506	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 02:15:28.88335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 02:15:45.530258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 02:16:02.401815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 02:16:18.969884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 02:33:29.21751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 02:33:45.968566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 02:34:02.60297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 02:34:19.263613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 02:51:29.429806	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 02:51:46.09458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 02:52:02.700444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 02:52:19.425144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 03:09:29.140244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 03:09:45.732263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 03:10:02.418418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 03:10:19.088114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 03:27:29.356986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 03:27:46.011001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 03:28:02.712075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 03:28:19.358525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 03:45:29.503793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 03:45:46.152869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 03:46:02.844552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 03:46:19.5188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 04:03:35.879664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 04:03:52.516214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 04:04:09.099803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 04:04:25.766437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 04:21:28.544292	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 04:21:45.186656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 04:22:01.826323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 04:22:18.474638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 04:39:09.292316	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 04:39:25.933228	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 04:39:42.545328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 04:39:59.237841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 04:57:13.749448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 04:57:30.337646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 04:57:46.998708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 04:58:03.70118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 05:15:17.406216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 05:15:34.081507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 05:15:50.761694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 05:16:07.412262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 05:32:57.513085	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 05:33:14.173105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 05:33:30.807234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 05:33:47.478625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 05:50:37.542574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 05:50:54.157592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 05:51:10.830212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 05:51:27.514521	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 06:08:15.779883	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 06:08:32.411492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 06:08:48.988805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 06:09:05.705756	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 06:25:53.031658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 06:26:09.774323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 06:26:26.348378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 06:26:42.991377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 06:43:28.886723	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 06:43:45.563724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 06:44:02.26386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 06:44:18.842936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 07:01:06.8993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 07:01:23.577319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 07:01:40.224536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 07:01:56.893017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 07:18:43.032856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 07:18:59.679331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 07:19:16.306451	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 07:19:33.044116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 07:36:23.298938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 07:36:39.960609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 07:36:56.697033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 07:37:13.429872	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 07:53:37.031154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 07:53:53.750777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 07:54:10.452579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 07:54:27.028107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 08:10:53.324845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 08:11:09.889834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 08:11:26.566173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 08:11:43.263757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 08:28:09.422173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 08:28:26.124267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 08:28:42.803612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 08:28:59.492526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 08:45:31.640066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 08:45:48.217687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 08:46:04.900745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 08:46:21.644929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 09:02:49.834586	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 09:03:06.477987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 09:03:23.128433	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 09:03:39.780616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 09:20:05.820632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 09:20:22.450117	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 09:20:39.14691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 09:20:55.837077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 09:37:21.918925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 09:37:38.555437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 09:37:55.251209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 09:38:11.878988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 09:54:22.559243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 09:54:39.306396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 09:54:56.054142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 09:55:12.774914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 10:11:25.432653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 10:11:42.142174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 10:11:58.745664	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 10:12:15.473483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 10:28:02.006294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 10:28:18.674643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 10:28:35.293172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 10:28:52.038312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 10:44:56.749467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 10:45:13.525789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 10:45:30.210819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 10:45:47.050479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 11:01:29.251144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 11:01:46.030065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 11:02:02.860416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 11:02:19.56583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 11:18:07.633932	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 11:18:26.302252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 11:18:43.001127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 11:18:59.702045	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 11:34:52.071466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 11:35:08.833253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 11:35:25.504691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 11:35:42.269207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 11:51:24.085998	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 11:51:45.971801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 11:52:12.876022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 11:52:29.679509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 12:08:30.129161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 12:08:46.933084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 12:09:03.716165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 12:09:20.464846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 12:25:00.89823	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 12:25:17.591526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 12:25:34.45832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 12:25:51.247695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 12:41:38.5047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 12:41:55.241743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 12:42:11.989632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 12:42:28.847886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 12:57:57.906945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 12:58:14.667851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 12:58:31.434111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 12:58:48.191796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 13:14:43.245825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 13:15:00.147259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 13:15:16.882931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 13:15:33.781881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 13:31:09.260054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 13:31:26.129726	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 13:31:42.988575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 13:31:59.860411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 13:47:54.11647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 13:48:10.959426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 13:48:27.845558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 13:48:44.811611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 14:04:26.888411	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 14:04:43.765374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 14:05:00.723159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 14:05:18.005819	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 14:21:08.18219	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 14:21:25.031532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 14:21:41.917159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 14:21:58.835588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 14:37:30.840193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 14:37:47.701165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 14:38:04.642313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 14:38:21.472262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 14:54:16.498614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 14:54:33.369131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 14:54:50.328721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 14:55:07.255315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 15:10:46.731541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 15:11:03.521287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 15:11:20.426944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 15:11:37.349112	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 15:27:04.777496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 15:27:21.931656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 15:27:38.935655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 15:27:56.249443	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 15:43:49.714825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 15:44:06.711722	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 15:44:23.593522	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 15:44:40.504618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 16:00:20.303487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 16:00:37.114119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 16:00:53.967039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 16:01:11.021283	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 16:17:17.794279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 16:17:34.643158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 16:17:51.469227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 16:18:08.267672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 16:34:14.780348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 16:34:31.501371	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 16:34:48.4124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 16:35:05.232104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 16:50:55.2362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 16:51:11.983968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 16:51:28.702438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 16:51:45.445104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 17:07:47.387059	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 17:08:04.451662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 17:08:21.983712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 17:08:41.225202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 17:24:18.49812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 17:24:35.667115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 17:24:52.815906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 17:25:10.386675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 17:40:45.84657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 17:41:02.912262	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 17:41:20.007439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 17:41:38.827574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 17:57:34.162467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 17:57:50.939606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 17:58:07.686446	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 17:58:24.393754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 18:15:24.447424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 18:15:41.146345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 18:15:58.046032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 18:16:16.803971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 18:32:33.89328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 18:32:52.687696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 18:33:09.38544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 18:33:26.229615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 18:50:08.469598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 18:50:25.462924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 18:50:42.307554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 18:50:59.160797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 19:07:11.986966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 19:07:28.722188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 19:07:45.556992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 19:08:02.900013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 19:24:23.349757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 19:24:40.481559	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 19:25:01.604048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 19:25:18.764588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 19:41:22.155539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 19:41:44.39389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 19:42:06.839021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 19:42:31.566595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 19:59:09.9523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 19:59:28.687043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 19:59:47.542537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 20:00:04.331893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 20:16:15.868463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 20:16:32.917005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 20:16:49.888735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 20:17:07.572917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 20:33:54.788614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 20:34:11.493039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 20:34:30.534895	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 20:34:49.512621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 20:50:38.104461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 20:50:55.087144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 20:51:12.165417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 20:51:31.770554	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 21:08:33.1853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 21:08:50.178764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 21:09:07.129322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 21:09:27.429719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 21:25:35.040618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 21:25:51.744656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 21:26:10.560651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 21:26:30.406346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 21:43:08.289551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 21:43:25.386175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 21:43:42.294523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 21:44:01.394424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 21:59:42.925636	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 22:00:00.038789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 22:00:17.160352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 22:00:34.11311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 22:17:10.17179	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 22:17:30.250396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 22:17:47.597088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 22:18:08.926582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 22:34:00.573238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 22:34:17.275101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 22:34:34.036505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 22:34:50.791952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 22:51:25.137687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 22:51:41.931541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 22:51:58.679794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 22:52:15.495246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 23:08:09.30887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 23:08:25.984558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 23:08:42.843174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 23:08:59.531555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 23:25:58.559483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 23:26:15.319955	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 23:26:32.066542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 23:26:48.814396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-10 23:43:12.53936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-10 23:43:29.112235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-10 23:43:46.058141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-10 23:44:02.734808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 00:00:53.86572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 00:01:12.533861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 00:01:29.148078	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 00:01:45.86141	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 00:18:05.600653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 00:18:22.273958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 00:18:38.967295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 00:18:55.661938	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 00:35:44.189529	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 00:36:00.812073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 00:36:17.50683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 00:36:34.219643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 00:52:36.522461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 00:52:53.159048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 00:53:09.858966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 00:53:26.569074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 01:10:16.574731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 01:10:33.140387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 01:10:49.801454	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 01:11:06.514942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 01:27:13.845879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 01:27:30.507031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 01:27:47.238628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 01:28:03.936786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 01:44:54.216273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 01:45:10.809608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 01:45:27.473809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 01:45:44.166109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 02:01:49.886114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 02:02:06.532947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 02:02:23.206719	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 02:02:39.872841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 02:19:27.799731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 02:19:44.407855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 02:20:01.090348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 02:20:17.83743	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 02:36:21.862539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 02:36:38.586881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 02:36:55.341328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 02:37:11.973893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 02:53:58.529217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 02:54:15.097415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 02:54:31.785667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 02:54:48.47608	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 03:10:50.265498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 03:11:06.896835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 03:11:23.527476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 03:11:40.196318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 03:28:28.155816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 03:28:44.737151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 03:29:01.42594	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 03:29:18.090977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 03:45:21.962227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 03:45:38.585374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 03:45:55.281712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 03:46:11.928767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 04:02:59.706346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 04:03:16.275511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 04:03:32.954807	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 04:03:49.631434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 04:19:53.472696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 04:20:10.080774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 04:20:26.740703	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 04:20:43.435859	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 04:37:29.095038	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 04:37:45.639194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 04:38:02.291809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 04:38:18.982571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 04:54:22.877042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 04:54:39.52458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 04:54:56.174647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 04:55:12.878426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 05:12:14.013272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 05:12:30.643419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 05:12:47.286778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 05:13:03.93363	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 05:29:09.44193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 05:29:26.080444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 05:29:42.759613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 05:29:59.45429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 05:46:50.17628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 05:47:06.828041	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 05:47:23.499746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 05:47:40.190315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 06:03:43.954066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 06:04:00.568139	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 06:04:17.225661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 06:04:33.916652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 06:21:19.794051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 06:21:36.331354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 06:21:52.969087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 06:22:09.687507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 06:38:11.525929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 06:38:28.240332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 06:38:44.887755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 06:39:01.568498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 06:55:47.435685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 06:56:04.025073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 06:56:20.712884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 06:56:37.373996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 07:12:43.289331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 07:12:59.967351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 07:13:16.620738	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 07:13:33.294047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 07:30:19.371776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 07:30:35.946637	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 07:30:52.612182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 07:31:09.329358	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 07:47:11.556137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 07:47:28.20066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 07:47:44.886753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 07:48:01.582534	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 08:04:49.878348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 08:05:06.477786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 08:05:23.16595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 08:05:39.851877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 08:21:25.757648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 08:21:42.433173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 08:21:59.060765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 08:22:15.738227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 08:38:43.810376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 08:39:00.480867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 08:39:17.201661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 08:39:33.984263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 08:55:16.430397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 08:55:33.021274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 08:55:49.692968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 08:56:06.41073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 09:12:37.749402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 09:12:54.453016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 09:13:11.078734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 09:13:27.800235	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 09:29:22.904996	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 09:29:39.636999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 09:29:56.273447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 09:30:12.960097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 09:46:57.799826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 09:47:14.559093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 09:47:31.27568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 09:47:47.933328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 10:03:58.596013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 10:04:15.259128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 10:04:31.907913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 10:04:48.715669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 10:21:30.713654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 10:21:47.426137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 10:22:04.17704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 10:22:20.918126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 10:38:52.620886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 10:39:09.388865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 10:39:26.030752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 10:39:42.850898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 10:56:09.868064	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 10:56:26.635486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 10:56:43.382176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 10:57:00.098135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 11:12:39.30331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 11:12:55.94847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 11:13:12.659122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 11:13:31.460008	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 11:30:09.071964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 11:30:25.808167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 11:30:42.691094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 11:30:59.431104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 11:46:23.724119	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 11:46:40.488678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 11:46:57.468869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 11:47:14.236166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 12:03:29.293128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 12:03:46.449026	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 12:04:05.313832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 12:04:22.443448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 12:20:22.923456	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 12:20:39.830917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 12:20:56.639788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 12:21:13.470084	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 12:38:00.311475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 12:38:17.068772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 12:38:33.995565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 12:38:51.177186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 12:54:56.591673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 12:55:13.316725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 12:55:30.383828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 12:55:49.493572	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 13:13:15.578809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 13:13:32.471821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 13:13:49.510325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 13:14:06.551459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 13:31:00.904866	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 13:31:20.015623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 13:31:39.435113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 13:31:57.047378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 13:49:04.340772	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 13:49:28.6222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 13:49:48.11478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 13:50:05.759462	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 14:06:17.484827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 14:06:34.535603	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 14:06:51.492133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 14:07:08.82901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 14:23:57.897027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 14:24:14.785604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 14:24:33.497919	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 14:24:50.764686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 14:41:07.219466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 14:41:23.874407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 14:41:40.687128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 14:41:57.42159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 14:59:06.153234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 14:59:23.187213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 14:59:44.851303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 15:00:04.11105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 15:17:15.3606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 15:17:34.32327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 15:17:53.310195	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 15:18:10.750419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 15:35:03.608421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 15:35:20.222788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 15:35:36.983573	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 15:35:53.796427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 15:52:17.774166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 15:52:34.624525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 15:52:51.458571	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 15:53:11.448588	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 16:09:55.788541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 16:10:17.075033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 16:10:36.094965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 16:10:52.856563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 16:27:18.485428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 16:27:35.799031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 16:27:53.423213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 16:28:12.339234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 16:44:43.160889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 16:45:00.081635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 16:45:16.99746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 16:45:34.431749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 17:01:57.01654	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 17:02:13.762802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 17:02:32.681976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 17:02:49.633378	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 17:20:23.312631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 17:20:44.097127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 17:21:03.030303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 17:21:19.928105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 17:37:17.517715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 17:37:34.160563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 17:37:50.963696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 17:38:08.481297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 17:54:42.25303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 17:55:01.028329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 17:55:21.18909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 17:55:40.927356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 18:12:04.200717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 18:12:26.299593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 18:12:43.685542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 18:13:02.540269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 18:29:52.172777	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 18:30:10.92751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 18:30:27.817331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 18:30:44.755741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 18:47:26.605134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 18:47:43.779263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 18:48:00.598665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 18:48:18.078493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 19:05:01.841216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 19:05:19.017519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 19:05:36.034826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 19:05:54.29258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 19:22:33.101097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 19:22:50.123467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 19:23:09.102189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 19:23:28.321757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 19:39:59.576716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 19:40:18.310788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 19:40:35.312774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 19:40:52.126365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 19:57:35.153001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 19:57:54.249986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 19:58:11.401005	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 19:58:35.890751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 20:15:25.31558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 20:15:42.231287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 20:16:04.526658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 20:16:23.858269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 20:33:58.037073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 20:34:17.101884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 20:34:34.172634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 20:34:53.074428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 20:53:11.685033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 20:53:28.596386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 20:53:45.695729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 20:54:05.006509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 21:10:27.14935	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 21:10:44.103986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 21:11:00.813171	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 21:11:19.809193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 21:28:13.729174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 21:28:33.535496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 21:28:53.350968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 21:29:10.177282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 21:45:36.654557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 21:45:53.399601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 21:46:10.186619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 21:46:26.993136	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 22:03:08.34564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 22:03:25.283011	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 22:03:42.094621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 22:03:58.865944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 22:20:12.976311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 22:20:29.793481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 22:20:46.578898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 22:21:03.343539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 22:37:30.035915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 22:37:46.775961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 22:38:03.971928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 22:38:21.163067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 22:54:02.810255	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 22:54:19.823602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 22:54:36.443648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 22:54:53.20875	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 23:11:26.091701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 23:11:42.769691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 23:11:59.510644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 23:12:16.67533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 23:28:24.764322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 23:28:41.692826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 23:28:58.584401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 23:29:18.52309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-11 23:45:48.989048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-11 23:46:05.572156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-11 23:46:22.249925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-11 23:46:38.973347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 00:03:06.575434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 00:03:23.25695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 00:03:39.955113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 00:03:56.622796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 00:20:41.95944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 00:20:58.634044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 00:21:15.337044	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 00:21:32.025562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 00:38:18.569409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 00:38:35.172368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 00:38:51.828956	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 00:39:08.513073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 00:55:54.440187	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 00:56:11.07216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 00:56:27.653032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 00:56:44.407595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 01:13:32.921977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 01:13:49.601077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 01:14:06.317894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 01:14:22.955029	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 01:31:09.030191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 01:31:25.788074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 01:31:42.523128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 01:31:59.209867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 01:48:47.889712	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 01:49:04.66885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 01:49:21.490615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 01:49:38.357125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 02:06:24.520679	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 02:06:41.074697	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 02:06:57.754925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 02:07:14.466757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 02:24:00.785057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 02:24:17.453569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 02:24:34.064577	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 02:24:50.763365	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 02:41:37.192126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 02:41:53.897459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 02:42:10.554835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 02:42:27.148518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 02:59:13.550661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 02:59:30.204458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 02:59:46.886391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 03:00:03.60399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 03:16:49.79758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 03:17:06.427941	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 03:17:23.146284	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 03:17:39.879946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 03:34:26.123676	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 03:34:42.767752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 03:34:59.397913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 03:35:16.114369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 03:52:02.422164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 03:52:19.121271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 03:52:35.752452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 03:52:52.465804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 04:09:38.355498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 04:09:55.000261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 04:10:11.699405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 04:10:28.355557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 04:27:16.640855	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 04:27:33.302748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 04:27:50.046208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 04:28:06.778771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 04:44:56.833745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 04:45:13.484927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 04:45:30.181401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 04:45:46.87928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 05:02:33.095937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 05:02:49.648746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 05:03:06.269854	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 05:03:22.953732	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 05:20:10.811567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 05:20:27.499159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 05:20:44.058793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 05:21:00.709771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 05:37:47.041639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 05:38:03.667877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 05:38:20.339309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 05:38:36.974899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 05:55:23.09846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 05:55:39.752376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 05:55:56.426659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 05:56:13.158239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 06:12:59.19715	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 06:13:15.77943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 06:13:32.452876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 06:13:49.149472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 06:30:35.243305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 06:30:51.899564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 06:31:08.564002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 06:31:25.304692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 06:48:11.287587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 06:48:27.96593	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 06:48:44.568389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 06:49:01.22992	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 07:05:49.376887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 07:06:06.081672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 07:06:22.816093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 07:06:39.424542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 07:23:25.733436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 07:23:42.353144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 07:23:59.014304	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 07:24:15.704775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 07:41:01.927328	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 07:41:18.510937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 07:41:35.200681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 07:41:51.928905	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 07:58:17.878925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 07:58:34.573099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 07:58:51.210273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 07:59:07.907907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 08:15:12.128476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 08:15:28.808079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 08:15:45.42014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 08:16:02.107547	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 08:32:08.0808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 08:32:24.744437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 08:32:41.305881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 08:32:57.994392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 08:49:02.2342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 08:49:18.868708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 08:49:35.503339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 08:49:52.242269	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 09:05:56.208758	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 09:06:12.868485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 09:06:29.697233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 09:06:46.501438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 09:22:53.884414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 09:23:10.518646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 09:23:27.290913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 09:23:43.957336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 09:39:58.106339	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 09:40:14.790014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 09:40:31.583146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 09:40:48.250132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 09:57:01.519326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 09:57:18.308493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 09:57:35.199221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 09:57:51.962994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 10:13:42.230298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 10:13:58.993818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 10:14:15.743047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 10:14:32.612237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 10:30:21.47448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 10:30:38.161923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 10:30:54.85827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 10:31:11.622376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 10:46:55.340933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 10:47:11.996398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 10:47:28.741439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 10:47:45.579467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 11:03:39.877076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 11:03:56.561627	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 11:04:13.298537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 11:04:32.09134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 11:20:14.556755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 11:20:31.289796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 11:20:48.023274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 11:21:04.827783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 11:37:41.515288	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 11:37:58.172086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 11:38:14.910483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 11:38:31.639716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 11:54:45.061039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 11:55:01.78789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 11:55:19.113741	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 11:55:35.822778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 12:12:41.745395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 12:12:58.563969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 12:13:15.693936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 12:13:32.516569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 12:30:53.331857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 12:31:10.198968	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 12:31:26.967971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 12:31:43.710357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 12:48:19.753318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 12:48:36.707747	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 12:48:53.491971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 12:49:10.389482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 13:05:27.556093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 13:05:44.330491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 13:06:01.009447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 13:06:17.797198	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 13:23:22.651048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 13:23:39.451088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 13:23:56.500755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 13:24:13.383988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 13:41:18.793472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 13:41:35.574901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 13:41:52.338734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 13:42:09.017892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 13:58:51.766161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 13:59:08.443889	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 13:59:25.172121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 13:59:41.952842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 14:16:19.715815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 14:16:36.592733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 14:16:53.277391	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 14:17:10.112511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 14:33:18.174675	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 14:33:34.964471	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 14:33:51.610181	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 14:34:08.645216	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 14:49:57.211882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 14:50:14.152915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 14:50:30.928253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 14:50:47.810291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 15:06:56.518013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 15:07:13.266194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 15:07:30.026385	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 15:07:47.01735	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 15:23:46.970677	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 15:24:03.798132	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 15:24:23.679271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 15:24:40.47007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 15:40:38.78003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 15:40:55.610745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 15:41:12.335538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 15:41:29.185178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 15:57:26.15146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 15:57:42.8739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 15:58:01.652725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 15:58:18.358671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 16:14:25.476614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 16:14:42.108442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 16:14:58.836634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 16:15:15.659518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 16:31:20.94109	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 16:31:37.560261	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 16:31:54.281804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 16:32:11.105178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 16:49:23.9724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 16:49:40.765397	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 16:49:57.563264	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 16:50:14.349249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 17:06:57.730095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 17:07:14.626783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 17:07:31.546177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 17:07:49.029948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 17:24:32.97825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 17:24:50.030441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 17:25:06.876054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 17:25:23.73566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 17:42:41.747583	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 17:42:58.563737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 17:43:15.327016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 17:43:32.134093	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 18:00:05.392836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 18:00:22.208642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 18:00:39.010039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 18:00:55.874851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 18:16:58.139631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 18:17:14.951035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 18:17:31.753657	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 18:17:48.653795	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 18:33:53.816762	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 18:34:10.837591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 18:34:27.595531	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 18:34:44.360351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 18:51:05.504902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 18:51:22.611291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 18:51:39.246989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 18:51:56.351134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 19:08:14.923151	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 19:08:31.947539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 19:08:49.016961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 19:09:06.613222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 19:25:12.784936	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 19:25:29.89615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 19:25:46.988427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 19:26:03.734113	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 19:42:02.636175	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 19:42:19.723764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 19:42:36.775977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 19:42:54.850204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 19:58:44.295375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 19:59:01.209169	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 19:59:18.106837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 19:59:34.862776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 20:15:37.528065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 20:15:54.202957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 20:16:11.210257	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 20:16:28.074317	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 20:32:26.987142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 20:32:43.972888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 20:33:01.15497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 20:33:18.131369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 20:49:05.242422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 20:49:22.39616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 20:49:44.656674	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 20:50:02.252478	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 21:05:45.716914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 21:06:02.694135	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 21:06:20.03298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 21:06:37.216027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 21:22:58.570769	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 21:23:15.263482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 21:23:32.422778	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 21:23:49.484649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 21:40:11.760517	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 21:40:28.978399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 21:40:45.822061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 21:41:03.496468	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 21:57:03.673481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 21:57:20.451609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 21:57:37.437863	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 21:57:54.29389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 22:14:09.142249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 22:14:25.916602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 22:14:42.647033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 22:14:59.369237	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 22:31:01.332893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 22:31:18.298039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 22:31:34.944977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 22:31:51.747714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 22:48:01.415494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 22:48:18.008415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 22:48:37.741617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 22:48:54.484907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 23:04:39.186606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 23:04:55.92533	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 23:05:12.552061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 23:05:29.354057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 23:21:31.015846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 23:21:47.803414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 23:22:04.441954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 23:22:21.165775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 23:38:06.744153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 23:38:23.450333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 23:38:40.15567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 23:38:56.764658	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-12 23:55:40.319991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-12 23:55:56.93843	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-12 23:56:13.643705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-12 23:56:30.406708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 00:12:29.525874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 00:12:46.217366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 00:13:02.899498	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 00:13:19.587731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 00:30:01.04563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 00:30:17.677856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 00:30:34.343601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 00:30:51.042684	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 00:46:55.381962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 00:47:11.951942	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 00:47:28.681542	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 00:47:45.419234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 01:04:31.933128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 01:04:48.729867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 01:05:05.296954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 01:05:21.976526	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 01:21:24.528584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 01:21:41.165704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 01:21:57.861834	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 01:22:14.639799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 01:39:00.859276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 01:39:17.544669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 01:39:34.152202	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 01:39:50.822324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 01:55:55.289764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 01:56:11.968575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 01:56:28.587759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 01:56:45.270749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 02:13:31.573068	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 02:13:48.33847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 02:14:04.984252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 02:14:21.674953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 02:30:23.595332	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 02:30:40.25509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 02:30:56.877847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 02:31:13.616532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 02:47:59.730979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 02:48:16.39862	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 02:48:33.078728	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 02:48:49.700423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 03:04:53.949884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 03:05:10.623134	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 03:05:27.230563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 03:05:43.914158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 03:22:29.927376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 03:22:46.601043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 03:23:03.307555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 03:23:19.939015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 03:39:22.38953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 03:39:39.034232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 03:39:55.699744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 03:40:12.325694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 03:56:58.327734	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 03:57:14.974957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 03:57:31.648052	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 03:57:48.319405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 04:13:52.189645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 04:14:08.849947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 04:14:25.534018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 04:14:42.123297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 04:31:28.158759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 04:31:44.828032	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 04:32:01.495404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 04:32:18.20825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 04:48:20.265656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 04:48:36.945754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 04:48:53.599579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 04:49:10.239966	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 05:05:56.544287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 05:06:13.189007	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 05:06:29.865103	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 05:06:46.524611	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 05:22:50.081544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 05:23:06.731649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 05:23:23.37335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 05:23:40.113234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 05:40:26.032916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 05:40:42.650928	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 05:40:59.305393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 05:41:16.017856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 05:57:17.966953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 05:57:34.62241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 05:57:51.339166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 05:58:08.045899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 06:14:53.700004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 06:15:10.372152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 06:15:27.017155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 06:15:43.704131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 06:31:45.818651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 06:32:02.417143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 06:32:19.075404	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 06:32:35.815368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 06:49:22.248331	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 06:49:38.89321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 06:49:55.607147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 06:50:12.25301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 07:06:15.830994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 07:06:32.400667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 07:06:49.105878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 07:07:05.812791	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 07:23:51.586957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 07:24:08.249203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 07:25:41.347444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 07:25:58.020286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 07:42:02.24063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 07:42:18.901211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 07:42:35.562234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 07:42:52.272019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 07:59:38.20225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 07:59:54.806207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 08:00:11.446495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 08:00:28.172001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 08:16:38.251704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 08:16:54.923095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 08:17:11.600122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 08:17:28.347686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 08:34:16.692033	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 08:34:33.329063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 08:34:50.027377	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 08:35:06.684789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 08:50:49.462049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 08:51:06.153417	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 08:51:22.784429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 08:51:39.530321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 09:08:09.937436	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 09:08:26.602495	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 09:08:43.330327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 09:09:00.003298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 09:24:51.411314	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 09:25:08.107828	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 09:25:24.794963	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 09:25:41.53915	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 09:42:41.003199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 09:42:57.702619	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 09:43:14.412104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 09:43:31.152857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 09:59:15.866393	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 09:59:32.475589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 09:59:49.266416	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 10:00:06.045392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 10:15:57.469629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 10:16:14.303137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 10:16:31.007305	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 10:16:47.780519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 10:32:10.592802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 10:32:27.278315	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 10:32:44.52401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 10:33:01.264142	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 10:48:56.082312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 10:49:12.747445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 10:49:29.533395	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 10:49:46.296319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 11:05:08.569165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 11:05:25.245428	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 11:05:41.862605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 11:05:58.578096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 11:21:47.176347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 11:22:03.850976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 11:22:20.550737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 11:22:37.236725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 11:37:56.611217	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 11:38:13.235477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 11:38:29.949278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 11:38:46.645368	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 11:54:30.597812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 11:54:47.344055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 11:55:04.100021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 11:55:20.827965	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 12:11:00.852066	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 12:11:17.537382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 12:11:36.368704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 12:11:53.096145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 12:27:39.517592	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 12:27:56.288869	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 12:28:13.088902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 12:28:29.898995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 12:43:57.650275	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 12:44:14.39817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 12:44:31.002095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 12:44:47.720362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 13:00:37.789058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 13:00:54.478167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 13:01:11.206374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 13:01:27.841822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 13:16:55.450102	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 13:17:12.074489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 13:17:29.207558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 13:17:46.260422	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 13:33:29.927294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 13:33:46.754448	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 13:34:03.388803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 13:34:20.147595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 13:49:47.493507	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 13:50:04.184749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 13:50:20.941624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 13:50:39.92829	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 14:06:37.307569	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 14:06:54.12948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 14:07:10.908999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 14:07:27.805152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 14:23:17.561244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 14:23:34.646803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 14:23:51.425302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 14:24:10.72439	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 14:40:00.543291	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 14:40:17.510023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 14:40:38.211177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 14:40:55.32962	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 14:56:30.717075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 14:56:47.590846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 14:57:04.393086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 14:57:21.402392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 15:14:09.982191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 15:14:26.814972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 15:14:43.571375	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 15:15:01.272286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 15:31:40.148221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 15:31:56.786651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 15:32:16.600434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 15:32:33.976267	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 15:48:46.677618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 15:49:03.605689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 15:49:25.885605	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 15:49:45.063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 16:05:36.662768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 16:05:53.732615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 16:06:11.379234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 16:06:30.489926	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 16:22:41.458818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 16:22:58.220164	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 16:23:15.140083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 16:23:33.926204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 16:40:03.796841	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 16:40:20.462467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 16:40:37.427232	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 16:41:01.703757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 16:58:00.977302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 16:58:17.840489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 16:58:34.845121	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 16:58:51.883415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 17:14:57.385389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 17:15:14.181771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 17:15:31.225662	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 17:15:48.079137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 17:32:38.810409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 17:32:55.531321	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 17:33:12.471464	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 17:33:29.303519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 17:49:48.515822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 17:50:05.417903	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 17:50:22.876354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 17:50:45.309574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 18:08:38.824707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 18:08:55.807441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 18:09:12.912494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 18:09:30.11802	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 18:26:20.471851	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 18:26:37.487958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 18:26:54.907868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 18:27:12.485771	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 18:44:04.491849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 18:44:21.49107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 18:44:38.564126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 18:44:56.079497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 19:01:54.965845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 19:02:11.745221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 19:02:28.613837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 19:02:45.62949	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 19:20:23.90125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 19:20:44.788525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 19:21:01.962673	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 19:21:21.003265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 19:38:36.406717	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 19:38:53.411213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 19:39:10.46194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 19:39:27.414233	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 19:56:24.119256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 19:56:40.972352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 19:56:57.895343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 19:57:14.813403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 20:13:54.269111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 20:14:10.91918	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 20:14:27.816086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 20:14:46.619785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 20:31:33.846491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 20:31:50.614957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 20:32:07.336204	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 20:32:24.175666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 20:48:56.67441	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 20:49:13.4396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 20:49:30.23277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 20:49:46.974472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 21:06:42.773407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 21:07:02.550812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 21:07:19.403157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 21:07:36.30979	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 21:23:55.014336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 21:24:11.728925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 21:24:28.582182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 21:24:45.310268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 21:41:26.291116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 21:41:42.951695	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 21:41:59.711599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 21:42:18.480236	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 21:58:49.126025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 21:59:06.209196	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 21:59:22.973621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 21:59:39.742071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 22:17:20.409544	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 22:17:37.125082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 22:17:53.82995	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 22:18:10.581361	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 22:34:59.543632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 22:35:16.227887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 22:35:32.964989	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 22:35:49.741655	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 22:53:36.441266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 22:53:53.123623	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 22:54:09.766923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 22:54:26.501748	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 23:11:22.913481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 23:11:39.647663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 23:11:56.367502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 23:12:13.033925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 23:29:56.00111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 23:30:16.76649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 23:30:33.509294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 23:30:50.268678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-13 23:47:55.205224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-13 23:48:11.915845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-13 23:48:28.600158	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-13 23:48:45.327457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 00:06:37.246629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 00:06:53.925886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 00:07:10.629648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 00:07:27.401293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 00:24:15.911194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 00:24:32.553749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 00:24:49.241683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 00:25:05.942222	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 00:42:23.508199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 00:42:40.202246	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 00:42:56.826799	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 00:43:13.509485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 00:59:41.921351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 00:59:58.620898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 01:00:15.185057	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 01:00:31.839921	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 01:17:40.343352	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 01:17:57.022115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 01:18:13.674268	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 01:18:30.344688	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 01:34:54.332981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 01:35:10.966789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 01:35:27.658487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 01:35:44.35786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 01:52:54.196432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 01:53:10.890579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 01:53:27.540476	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 01:53:44.175509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 02:10:10.299621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 02:10:26.910002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 02:10:43.576975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 02:11:00.264616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 02:28:10.292714	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 02:28:26.865617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 02:28:43.48553	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 02:29:00.159751	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 02:45:24.040644	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 02:45:40.714405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 02:45:57.40975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 02:46:13.980496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 03:03:22.531832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 03:03:39.194709	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 03:03:55.877716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 03:04:12.52364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 03:20:36.406784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 03:20:52.977558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 03:21:09.589311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 03:21:26.299523	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 03:38:34.541505	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 03:38:51.213128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 03:39:07.894048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 03:39:24.538513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 03:55:48.491207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 03:56:05.146911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 03:56:21.757341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 03:56:38.491924	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 04:13:46.297075	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 04:14:02.976396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 04:14:19.592091	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 04:14:36.269004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 04:31:00.340286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 04:31:17.014595	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 04:31:33.708604	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 04:31:50.406186	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 04:48:58.396343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 04:49:15.05646	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 04:49:31.72639	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 04:49:48.40455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 05:06:25.594346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 05:06:42.242483	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 05:06:58.887408	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 05:07:15.563157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 05:24:23.689877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 05:24:40.316419	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 05:24:57.024584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 05:25:13.689372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 05:41:37.45396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 05:41:54.166836	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 05:42:10.821804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 05:42:27.433021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 05:59:35.402239	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 05:59:52.071357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 06:00:08.688694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 06:00:25.336092	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 06:16:49.279913	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 06:17:05.880953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 06:17:22.584294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 06:17:39.289487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 06:34:47.357163	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 06:35:04.072631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 06:35:20.749473	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 06:35:37.41313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 06:52:01.536879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 06:52:18.223954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 06:52:34.82063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 06:52:51.45398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 07:10:02.836729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 07:10:19.475614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 07:10:36.198046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 07:10:52.86656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 07:27:18.287345	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 07:27:34.962964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 07:27:51.626898	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 07:28:08.276131	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 07:45:40.832773	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 07:45:57.440616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 07:46:14.102144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 07:46:30.837161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 08:03:17.193218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 08:03:33.935021	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 08:03:50.522445	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 08:04:07.280278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 08:20:55.493205	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 08:21:12.188429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 08:21:29.008668	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 08:21:45.6614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 08:37:47.761564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 08:38:04.431625	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 08:38:21.187868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 08:38:37.789809	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 08:55:31.872016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 08:55:48.531144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 08:56:05.280914	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 08:56:21.93353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 09:12:08.048271	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 09:12:24.750667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 09:12:41.47024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 09:12:58.167687	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 09:29:28.734438	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 09:29:45.457947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 09:30:02.059399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 09:30:18.798444	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 09:46:25.199337	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 09:46:41.927842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 09:46:58.612459	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 09:47:15.300191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 10:03:56.860805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 10:04:13.605129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 10:04:30.279886	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 10:04:46.902065	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 10:21:40.415653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 10:21:57.068357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 10:22:13.762313	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 10:22:30.447686	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 10:39:06.623079	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 10:39:23.375182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 10:39:40.086282	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 10:39:56.862525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 10:56:21.701122	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 10:56:38.444405	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 10:56:55.273094	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 10:57:12.080384	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 11:12:40.763615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 11:12:57.521053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 11:13:14.185215	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 11:13:30.924155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 11:29:55.685813	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 11:30:12.423727	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 11:30:29.14244	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 11:30:45.835295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 11:46:43.240154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 11:47:00.0856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 11:47:16.799721	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 11:47:33.578172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 12:03:49.331853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 12:04:06.041609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 12:04:22.762669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 12:04:39.471557	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 12:20:18.633696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 12:20:37.685832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 12:20:54.608388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 12:21:11.360274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 12:37:15.915118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 12:37:32.890612	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 12:37:49.720309	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 12:38:06.576969	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 12:53:47.752159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 12:54:04.590156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 12:54:21.373617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 12:54:38.191519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 13:10:34.576558	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 13:10:51.239015	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 13:11:07.93096	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 13:11:24.702189	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 13:27:04.820035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 13:27:21.593939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 13:27:38.33294	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 13:27:55.032885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 13:44:11.389975	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 13:44:28.228353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 13:44:44.92437	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 13:45:01.767123	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 14:01:39.943871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 14:01:56.658193	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 14:02:13.321351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 14:02:30.068343	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 14:18:23.658775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 14:18:40.324808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 14:18:57.144126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 14:19:13.859083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 14:34:42.646432	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 14:34:59.43234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 14:35:16.286731	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 14:35:33.01223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 14:51:23.392399	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 14:51:42.49597	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 14:51:59.492958	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 14:52:16.476025	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 15:07:56.050355	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 15:08:12.886369	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 15:08:29.731229	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 15:08:46.471764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 15:24:50.303682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 15:25:07.018624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 15:25:23.766642	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 15:25:40.617035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 15:41:36.312971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 15:41:53.175568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 15:42:12.154702	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 15:42:29.436784	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 15:58:38.270786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 15:58:55.025299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 15:59:11.901536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 15:59:28.751039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 16:15:25.752822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 16:15:42.499653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 16:16:01.277054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 16:16:17.998159	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 16:32:29.306882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 16:32:46.00902	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 16:33:02.801372	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 16:33:19.548994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 16:49:33.643455	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 16:49:50.593752	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 16:50:07.331661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 16:50:24.37788	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 17:06:28.216209	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 17:06:44.991364	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 17:07:01.693901	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 17:07:18.453082	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 17:23:21.878682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 17:23:45.470581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 17:24:02.537988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 17:24:19.936616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 17:40:24.648916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 17:40:41.347382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 17:40:57.994298	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 17:41:14.766001	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 17:57:20.727991	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 17:57:37.537034	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 17:57:54.299846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 17:58:11.61845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 18:14:07.312427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 18:14:24.185024	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 18:14:40.998774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 18:14:58.172946	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 18:31:06.796333	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 18:31:23.440931	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 18:31:40.178648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 18:31:56.959496	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 18:48:22.726775	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 18:48:39.466973	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 18:48:56.30565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 18:49:13.180199	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 19:05:07.729487	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 19:05:24.41967	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 19:05:41.141739	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 19:05:57.926733	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 19:22:55.705253	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 19:23:12.40499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 19:23:29.289203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 19:23:46.083362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 19:39:34.850602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 19:39:51.815745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 19:40:08.44386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 19:40:25.297882	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 19:56:59.019793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 19:57:15.767028	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 19:57:32.532692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 19:57:49.35452	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 20:14:01.530295	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 20:14:18.362649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 20:14:35.406067	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 20:14:52.490394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 20:32:16.998651	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 20:32:33.98383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 20:32:50.865249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 20:33:08.064782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 20:49:20.011027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 20:49:36.703081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 20:49:53.414568	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 20:50:10.135351	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 21:06:56.027994	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 21:07:12.846277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 21:07:29.710348	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 21:07:47.219212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 21:24:20.500689	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 21:24:37.164729	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 21:24:53.90555	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 21:25:10.995457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 21:41:34.010273	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 21:41:50.706128	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 21:42:07.543765	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 21:42:24.306081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 21:58:49.402798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 21:59:06.124678	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 21:59:22.839707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 21:59:39.562814	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 22:16:45.26925	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 22:17:02.012307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 22:17:18.737694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 22:17:35.596986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 22:34:08.043049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 22:34:24.765776	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 22:34:41.44827	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 22:34:58.12512	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 22:51:58.678376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 22:52:15.391212	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 22:52:32.094302	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 22:52:48.899174	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 23:09:26.571242	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 23:09:43.212155	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 23:09:59.907138	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 23:10:16.616943	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 23:26:55.58613	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 23:27:12.245423	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 23:27:28.976666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 23:27:45.675694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-14 23:44:21.405413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-14 23:44:38.000482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-14 23:44:54.703161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-14 23:45:11.458027	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 00:01:37.243922	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 00:01:53.946279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 00:02:10.607485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 00:02:27.287513	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 00:18:58.817753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 00:19:15.414856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 00:19:32.101576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 00:19:49.029781	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 00:36:04.473173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 00:36:21.175457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 00:36:37.837908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 00:36:54.54793	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 00:53:16.181157	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 00:53:32.877562	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 00:53:49.574849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 00:54:06.226564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 01:10:43.013104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 01:10:59.602997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 01:11:16.29421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 01:11:32.997116	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 01:28:13.024789	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 01:28:29.716545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 01:28:46.333327	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 01:29:03.073238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 01:45:33.047499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 01:45:49.796387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 01:46:06.524095	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 01:46:23.245645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 02:03:13.615178	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 02:03:30.19379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 02:03:46.837643	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 02:04:03.529633	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 02:20:44.608012	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 02:21:01.251768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 02:21:17.858046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 02:21:34.595277	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 02:38:08.810609	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 02:38:25.513796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 02:38:42.145218	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 02:38:58.75724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 02:55:34.665458	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 02:55:51.239856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 02:56:07.897311	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 02:56:24.595394	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 03:13:18.522429	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 03:13:35.19035	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 03:13:51.85947	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 03:14:08.547349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 03:30:44.456672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 03:31:01.155761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 03:31:17.869792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 03:31:34.515867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 03:48:18.334319	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 03:48:35.001165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 03:48:51.726286	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 03:49:08.442849	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 04:05:37.887022	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 04:05:54.5256	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 04:06:11.113786	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 04:06:27.8492	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 04:22:59.434746	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 04:23:16.103223	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 04:23:32.783867	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 04:23:49.4214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 04:40:16.085077	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 04:40:32.773653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 04:40:49.339191	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 04:41:06.010933	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 04:57:31.42988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 04:57:48.090682	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 04:58:04.722618	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 04:58:21.378868	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 05:14:53.131985	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 05:15:09.761638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 05:15:26.338844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 05:15:43.052401	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 05:32:15.769785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 05:32:32.390402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 05:32:49.059856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 05:33:05.720418	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 05:49:30.369878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 05:49:47.084111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 05:50:03.749661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 05:50:20.424031	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 06:06:50.034944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 06:07:06.707574	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 06:07:23.426039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 06:07:40.116667	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 06:24:07.771536	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 06:24:24.478307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 06:24:41.08118	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 06:24:57.795811	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 06:41:29.277043	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 06:41:45.928856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 06:42:02.56696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 06:42:19.211792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 06:58:50.886379	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 06:59:07.478724	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 06:59:24.106545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 06:59:40.832601	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 07:16:08.548037	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 07:16:25.186537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 07:16:41.884716	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 07:16:58.489088	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 07:33:24.249711	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 07:33:40.908083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 07:33:57.567606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 07:34:14.209916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 07:50:41.549779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 07:50:58.191645	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 07:51:14.874842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 07:51:31.543482	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 08:08:23.429442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 08:08:40.096649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 08:08:56.788782	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 08:09:13.521211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 08:25:41.304537	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 08:25:58.009172	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 08:26:14.642952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 08:26:31.349563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 08:42:55.534274	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 08:43:12.168917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 08:43:28.842403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 08:43:45.547241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 09:00:11.454165	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 09:00:28.146909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 09:00:44.837564	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 09:01:01.475234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 09:17:09.468308	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 09:17:26.144909	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 09:17:42.789152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 09:17:59.550524	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 09:34:23.803837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 09:34:40.416322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 09:34:57.139984	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 09:35:13.973879	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 09:51:30.356016	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 09:51:47.043999	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 09:52:03.767442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 09:52:20.546409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 10:08:35.263207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 10:08:51.997467	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 10:09:08.723388	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 10:09:25.432054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 10:25:18.381638	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 10:25:35.060426	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 10:25:51.825049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 10:26:08.644785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 10:42:00.96356	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 10:42:17.720415	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 10:42:34.396387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 10:42:51.114299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 10:59:04.729516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 10:59:21.471774	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 10:59:38.151054	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 10:59:56.983014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 11:15:54.254076	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 11:16:10.915816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 11:16:27.732133	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 11:16:44.851511	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 11:32:45.609488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 11:33:02.39779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 11:33:19.118624	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 11:33:35.988874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 11:49:24.089707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 11:49:40.838884	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 11:49:57.977964	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 11:50:14.870293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 12:06:39.887453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 12:06:56.62993	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 12:07:13.424652	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 12:07:30.314367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 12:23:27.148761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 12:23:43.915414	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 12:24:00.608986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 12:24:17.487104	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 12:40:18.111434	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 12:40:34.911596	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 12:40:54.693083	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 12:41:11.356344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 12:57:39.561812	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 12:57:56.280047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 12:58:13.098861	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 12:58:29.938927	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 13:14:58.293981	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 13:15:15.041326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 13:15:31.96073	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 13:15:50.720911	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 13:31:57.28409	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 13:32:14.175692	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 13:32:31.366952	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 13:32:50.107301	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 13:49:13.464362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 13:49:32.318406	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 13:49:48.96457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 13:50:05.846146	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 14:05:55.647323	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 14:06:12.348278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 14:06:29.212691	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 14:06:48.062632	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 14:23:08.268659	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 14:23:24.931917	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 14:23:42.033081	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 14:24:00.895349	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 14:39:53.140888	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 14:40:09.879944	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 14:40:26.611211	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 14:40:43.500107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 14:57:07.183453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 14:57:23.852552	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 14:57:40.6457	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 14:57:57.471508	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 15:13:54.468003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 15:14:11.188243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 15:14:28.024357	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 15:14:46.796071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 15:30:46.168899	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 15:31:03.057665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 15:31:20.188672	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 15:31:36.930145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 15:47:11.927805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 15:47:28.834844	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 15:47:45.677761	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 15:48:03.04509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 16:04:08.30051	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 16:04:27.543857	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 16:04:44.811344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 16:05:02.023749	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 16:20:39.074177	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 16:20:56.027525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 16:21:13.072566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 16:21:32.414584	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 16:37:49.442976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 16:38:06.18324	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 16:38:23.220213	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 16:38:40.106853	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 16:55:13.114069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 16:55:29.917685	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 16:55:46.684475	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 16:56:03.723143	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 17:12:28.719258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 17:12:47.793954	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 17:13:10.058575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 17:13:31.102039	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 17:29:19.908124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 17:29:36.827755	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 17:29:55.784971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 17:30:12.762127	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 17:46:19.727249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 17:46:36.525615	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 17:46:53.386704	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 17:47:10.343247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 18:02:47.731783	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 18:03:04.6497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 18:03:21.73948	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 18:03:42.968842	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 18:20:29.138641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 18:20:47.940376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 18:21:04.89957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 18:21:23.740322	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 18:37:03.86653	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 18:37:20.606058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 18:37:37.392779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 18:37:54.275362	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 18:54:25.278877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 18:54:42.456442	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 18:54:59.496821	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 18:55:16.468447	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 19:11:03.150887	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 19:11:19.919004	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 19:11:36.737413	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 19:11:54.884326	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 19:28:17.225796	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 19:28:33.979792	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 19:28:50.740798	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 19:29:07.661346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 19:45:05.398114	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 19:45:22.69488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 19:45:44.84891	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 19:46:09.450207	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 20:03:07.831152	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 20:03:29.724957	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 20:03:48.91757	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 20:04:08.036258	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 20:20:52.65515	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 20:21:09.421145	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 20:21:32.895567	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 20:21:50.374551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 20:38:39.971977	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 20:38:57.03374	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 20:39:14.170825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 20:39:31.416745	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 20:55:31.911606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 20:55:48.648538	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 20:56:05.455373	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 20:56:22.433737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 21:13:14.38344	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 21:13:33.575892	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 21:13:55.852472	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 21:14:15.256744	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 21:30:22.274097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 21:30:41.277003	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 21:30:58.214318	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 21:31:17.29137	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 21:47:39.144502	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 21:47:56.244626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 21:48:13.068725	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 21:48:30.215197	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 22:04:17.789461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 22:04:34.594474	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 22:04:53.531023	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 22:05:10.46953	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 22:21:59.088587	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 22:22:15.752046	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 22:22:32.435281	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 22:22:49.176937	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 22:38:44.426248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 22:39:01.23234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 22:39:17.86002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 22:39:34.574386	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 22:56:14.878837	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 22:56:31.589018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 22:56:48.302287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 22:57:05.022894	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 23:13:28.631509	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 23:13:45.306263	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 23:14:01.923192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 23:14:18.675635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 23:31:20.759234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 23:31:37.453881	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 23:31:54.141427	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 23:32:10.764176	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-15 23:48:21.969463	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-15 23:48:38.597214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-15 23:48:55.178494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-15 23:49:11.884248	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 00:06:02.351846	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 00:06:19.053648	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 00:06:35.769582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 00:06:52.433663	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 00:22:57.310188	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 00:23:13.951835	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 00:23:30.633893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 00:23:47.301649	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 00:40:30.315156	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 00:40:47.017602	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 00:41:03.674576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 00:41:20.405647	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 00:57:24.367616	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 00:57:41.08466	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 00:57:57.737986	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 00:58:14.383167	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 01:15:02.412366	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 01:15:19.053628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 01:15:35.704982	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 01:15:52.527896	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 01:31:53.965525	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 01:32:10.653635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 01:32:27.275124	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 01:32:43.983299	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 01:49:29.964708	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 01:49:46.576908	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 01:50:03.234287	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 01:50:20.070576	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 02:06:27.807493	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 02:06:44.434822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 02:07:01.119621	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 02:07:17.802014	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 02:24:10.00208	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 02:24:26.61923	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 02:24:43.261461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 02:24:59.976614	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 02:41:01.826086	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 02:41:18.435312	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 02:41:35.111876	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 02:41:51.833266	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 02:58:40.051822	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 02:58:56.689489	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 02:59:13.316516	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 02:59:30.028617	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 03:15:36.544779	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 03:15:53.190234	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 03:16:09.828626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 03:16:26.503376	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 03:33:09.178325	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 03:33:25.885042	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 03:33:42.522382	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 03:33:59.174243	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 03:50:00.765591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 03:50:17.417817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 03:50:34.017514	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 03:50:50.675272	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 04:07:36.54265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 04:07:53.200707	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 04:08:09.90383	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 04:08:26.484874	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 04:24:28.15488	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 04:24:44.805297	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 04:25:01.47518	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 04:25:18.107173	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 04:42:03.217347	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 04:42:19.901575	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 04:42:36.539424	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 04:42:53.211002	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 04:58:51.716681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 04:59:08.410494	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 04:59:25.108048	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 04:59:41.883194	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 05:16:29.901631	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 05:16:46.489227	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 05:17:03.1589	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 05:17:19.811815	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 05:33:21.327329	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 05:33:37.952816	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 05:33:54.626767	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 05:34:11.337265	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 05:50:57.470071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 05:51:14.083817	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 05:51:30.713387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 05:51:47.381153	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 06:08:13.272307	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 06:08:29.914225	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 06:08:46.581477	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 06:09:03.30166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 06:26:13.172341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 06:26:29.916252	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 06:26:46.59945	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 06:27:03.26144	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 06:43:05.022069	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 06:43:21.730481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 06:43:38.39877	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 06:43:54.983768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 07:00:41.06797	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 07:00:57.714249	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 07:01:14.351036	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 07:01:31.035276	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 07:17:31.461485	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 07:17:48.130545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 07:18:04.768389	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 07:18:21.476013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 07:34:46.269661	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 07:35:02.908497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 07:35:19.486566	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 07:35:36.182107	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 07:51:14.755241	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 07:51:31.387063	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 07:51:48.075396	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 07:52:04.652832	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 08:08:31.309607	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 08:08:48.023801	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 08:09:04.674582	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 08:09:21.353293	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 08:25:12.422214	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 08:25:29.015053	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 08:25:45.735599	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 08:26:02.531049	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 08:42:26.176794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 08:42:42.802641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 08:42:59.500019	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 08:43:16.178754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 08:58:59.995885	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 08:59:16.673754	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 08:59:33.259099	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 08:59:49.949598	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 09:16:14.146634	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 09:16:30.848486	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 09:16:47.482976	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 09:17:04.182628	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 09:32:52.640681	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 09:33:09.296551	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 09:33:26.007929	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 09:33:42.736392	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 09:50:17.642669	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 09:50:34.331972	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 09:50:51.015532	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 09:51:07.677519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 10:06:35.679856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 10:06:52.327018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 10:07:08.972768	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 10:07:27.629306	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 10:23:36.002289	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 10:23:52.724398	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 10:24:09.418563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 10:24:26.167804	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 10:39:53.995166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 10:40:10.778825	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 10:40:27.440403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 10:40:44.189403	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 10:56:58.835238	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 10:57:15.426192	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 10:57:32.128013	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 10:57:48.828629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 11:13:12.743503	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 11:13:29.472047	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 11:13:46.154058	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 11:14:02.8497	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 11:30:08.657367	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 11:30:25.371606	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 11:30:42.073635	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 11:30:58.737402	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 11:46:26.936303	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 11:46:43.603581	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 11:47:00.327111	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 11:47:17.036342	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 12:03:25.703705	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 12:03:42.273785	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 12:03:59.985247	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 12:04:16.725987	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 12:19:41.468907	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 12:19:58.200545	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 12:20:14.888934	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 12:20:31.660666	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 12:36:45.130341	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 12:37:01.876449	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 12:37:18.499759	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 12:37:35.246421	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 12:53:04.298061	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 12:53:20.975893	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 12:53:37.667818	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 12:53:54.413018	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 13:10:27.771856	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 13:10:44.533101	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 13:11:01.190259	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 13:11:17.898539	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 13:27:09.640858	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 13:27:26.321997	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 13:27:43.076656	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 13:27:59.763461	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 13:44:57.61971	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 13:45:14.346465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 13:45:31.071126	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 13:45:47.734154	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 14:01:36.51845	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 14:01:53.251808	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 14:02:10.058701	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 14:02:26.855479	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 14:18:59.291563	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 14:19:16.045161	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 14:19:32.866072	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 14:19:51.67278	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 14:35:25.6224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 14:35:42.361865	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 14:35:59.182055	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 14:36:15.884794	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 14:52:52.371988	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 14:53:09.04826	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 14:53:25.797629	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 14:53:42.599696	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 15:10:04.504097	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 15:10:21.45387	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 15:10:38.206499	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 15:10:54.931074	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 15:27:33.437336	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 15:27:50.144465	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 15:28:06.773453	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 15:28:23.502805	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 15:44:21.620203	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 15:44:38.32939	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 15:44:54.960481	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 15:45:11.767183	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 16:01:59.414407	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 16:02:16.161129	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 16:02:32.859591	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 16:02:49.635961	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 16:19:06.312087	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 16:19:23.076737	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 16:19:44.842519	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 16:20:03.590671	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 16:36:44.64353	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 16:37:01.441279	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 16:37:18.29346	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 16:37:35.193491	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 16:53:52.603182	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 16:54:09.382698	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 16:54:26.40878	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 16:54:43.111541	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 17:11:28.725803	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 17:11:45.479833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 17:12:02.282125	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 17:12:19.426166	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 17:28:25.227296	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 17:28:42.331354	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 17:28:59.281071	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 17:29:18.134224	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 17:46:07.246847	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 17:46:24.278916	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 17:46:41.012221	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 17:46:59.92469	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 18:03:03.322147	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 18:03:20.235665	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 18:03:37.012115	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 18:03:53.751694	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 18:25:58.073105	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 18:26:19.799626	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 18:42:47.701641	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 18:43:04.495089	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 18:43:21.232864	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 18:43:38.019906	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 19:00:29.955742	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 19:00:46.866871	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 19:01:03.627683	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 19:01:20.431764	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 19:19:03.294833	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 19:19:19.995549	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 19:19:37.00335	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 19:19:54.10565	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.122.250	2009-03-16 19:38:49.539753	2000-01-01 00:00:00	2000-01-01 00:00:00
78.62.123.243	2009-03-16 19:39:06.267579	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.79.12	2009-03-16 19:39:23.0017	2000-01-01 00:00:00	2000-01-01 00:00:00
78.56.64.143	2009-03-16 19: